<?php

namespace Schema31\GeoBundle\Model;

use Schema31\GeoBundle\Entity\GeoStato;
use Schema31\GeoBundle\Entity\GeoRegione;
use Schema31\GeoBundle\Entity\GeoProvincia;
use Schema31\GeoBundle\Entity\GeoComune;

/**
 * Description of LuogoTrait
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
trait LuogoTrait {

    /**
     * @var GeoStato $stato
     *
     * @ORM\ManyToOne(targetEntity="Schema31\GeoBundle\Entity\GeoStato")
     * @ORM\JoinColumn(nullable=false)
     */       
    private $stato;

    /**
     * @var ?GeoRegione $regione
     *
     * @ORM\ManyToOne(targetEntity="Schema31\GeoBundle\Entity\GeoRegione")
     * @ORM\JoinColumn(nullable=true)
     */    
    private $regione;
    
    /**
     * @var ?GeoProvincia $provincia
     *
     * @ORM\ManyToOne(targetEntity="Schema31\GeoBundle\Entity\GeoProvincia")
     * @ORM\JoinColumn(nullable=true)
     */ 
    private $provincia;
    
    /**
     * @var ?GeoComune $comune
     *
     * @ORM\ManyToOne(targetEntity="Schema31\GeoBundle\Entity\GeoComune")
     * @ORM\JoinColumn(nullable=true)
     */    
    private $comune;
    
    public function getStato(): ?GeoStato  {
        return $this->stato;
    }

    public function getRegione(): ?GeoRegione {
        return $this->regione;
    }
    
    public function getProvincia(): ?GeoProvincia {
        return $this->provincia;
    }

    public function getComune(): ?GeoComune {
        return $this->comune;
    }
    
    public function setStato(GeoStato $stato) {
        $this->stato = $stato;
    }

    public function setRegione(?GeoRegione $regione) {
        $this->regione = $regione;
    }
    
    public function setProvincia(?GeoProvincia $provincia) {
        $this->provincia = $provincia;
    }

    public function setComune(?GeoComune $comune) {
        $this->comune = $comune;
    }
      
}
