<?php

namespace Schema31\GeoBundle\Model;

use Symfony\Component\Validator\Constraints as Assert;
use Doctrine\ORM\Mapping as ORM;

/**
 * @author Antonio Turdo <aturdo@schema31.it>
 */
trait IndirizzoTrait {

    /**
     * @var string $via
     *
     * @ORM\Column(name="via", type="string", length=64)
	 * @Assert\Length(min=1, max=64)
     * @Assert\NotNull() 
     */
    protected $via;

    /**
     * @var string $numeroCivico
     *
     * @ORM\Column(name="numero_civico", type="string", length=16)
	 * @Assert\Length(min=1, max=16)
     * @Assert\NotNull() 
     */
    protected $numeroCivico;
    
    /**
     * @var string $cap
     *
     * @ORM\Column(name="cap", type="string", length=5)
     * @Assert\Regex("/^\d{5}$/") 
	 * @Assert\Length(min=1, max=5)
     * @Assert\NotNull()
     */
    protected $cap;
    
    public function getVia() {
        return $this->via;
    }

    public function getNumeroCivico() {
        return $this->numeroCivico;
    }

    public function getCap() {
        return $this->cap;
    }

    public function setVia(string $via) {
        $this->via = $via;
    }

    public function setNumeroCivico(string $numeroCivico) {
        $this->numeroCivico = $numeroCivico;
    }

    public function setCap(string $cap) {
        $this->cap = $cap;
    }
    
}
