<?php

namespace Schema31\GeoBundle\Model;

use Symfony\Component\Validator\Constraints as Assert;

use Doctrine\ORM\Mapping as ORM;

use Schema31\GeoBundle\Entity\GeoProvincia;
use Schema31\GeoBundle\Entity\GeoComune;

/**
 * Description of IndirizzoRegioneItalia
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class IndirizzoRegioneItalia {

    /**
     * @var GeoProvincia $provincia
     *
     * @ORM\ManyToOne(targetEntity="Schema31\GeoBundle\Entity\GeoProvincia")
     * @ORM\JoinColumn(nullable=false)
     * @Assert\NotNull()
     */    
    private $provincia;
    
    /**
     * @var GeoComune $comune
     *
     * @ORM\ManyToOne(targetEntity="Schema31\GeoBundle\Entity\GeoComune")
     * @ORM\JoinColumn(nullable=false)
     * @Assert\NotNull()
     */    
    private $comune;
    
    use IndirizzoTrait;
    
    public function getProvincia(): ?GeoProvincia {
        return $this->provincia;
    }

    public function getComune(): ?GeoComune {
        return $this->comune;
    }

    public function setProvincia(GeoProvincia $provincia) {
        $this->provincia = $provincia;
    }

    public function setComune(GeoComune $comune) {
        $this->comune = $comune;
    }

}
