<?php

namespace Schema31\GeoBundle\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\OrderBy;

use Schema31\GeoBundle\Model\Luogo;
use Schema31\GeoBundle\Entity\GeoComune;

use Schema31\GeoBundle\Schema31GeoBundle;

/**
 * Descrizione di LuogoType
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class LuogoType extends AbstractType {

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('stato', GeoStatoType::class, ['cessati' => $options['cessati']]);
        
        $formModifier = function(FormInterface $form, ?int $statoId, ?int $provinciaId) use ($options) {      
            $hasProvincia = !is_null($statoId) && $statoId == Schema31GeoBundle::ITALIA_ID;
            
            $optionsProvincia = ['cessati' => $options['cessati']];
            $optionsProvincia['disabled'] = !$hasProvincia;
            $optionsProvincia['required'] = $hasProvincia;
                        
            $optionsComune = ['class' => GeoComune::class, 'placeholder' => ''];
            if (is_null($provinciaId)) {
                $optionsComune['choices'] = [];
                $optionsComune['disabled'] = true;
                $optionsComune['required'] = false;
            } else {
                $optionsComune['disabled'] = false;
                $optionsComune['required'] = true;
                
                $optionsComune['query_builder'] = function (EntityRepository $er) use ($provinciaId, $options){
                    $orderBy = new OrderBy();
                    $orderBy->add('g.capoluogo', 'DESC');
                    $orderBy->add('g.denominazione', 'ASC');
                    
                    $qb = $er->createQueryBuilder('g')
                    ->where('g.suddivisioneSuperiore = '.$provinciaId);
                    
                    if (!$options['cessati']) {
                        $qb->andWhere('g.cessato = 0');
                    }
                    
                    return $qb->orderBy($orderBy);
                };
            }
            
            $form->add('provincia', GeoProvinciaType::class, $optionsProvincia);
            $form->add('comune', EntityType::class, $optionsComune);                
        };
           
        $builder->addEventListener(
            FormEvents::PRE_SET_DATA,
            function (FormEvent $event) use ($formModifier){
                $stato = $event->getData()->getStato();
                $provincia = $event->getData()->getProvincia();
                
                $formModifier($event->getForm(), is_null($stato) ? null : $stato->getId(), is_null($provincia) ? null : $provincia->getId());
            }                
        );
        
        $builder->addEventListener(
            FormEvents::PRE_SUBMIT, 
            function (FormEvent $event) use ($formModifier){
                $data = $event->getData();

                $formModifier($event->getForm(), isset($data['stato']) ? (int) $data['stato'] : null, isset($data['provincia']) ? (int) $data['provincia'] : null);
            }
        );                       
    }
    
    public function buildView(FormView $view, FormInterface $form, array $options) {   
        $view->vars['cessati'] = $options['cessati'];
    }
    
    public function configureOptions(OptionsResolver $resolver) 
    {
        $resolver->setDefaults(array(
            'data_class' => Luogo::class,
            'cessati' => false   
        ));       
    } 
    
    public function getParent() {
        return \Symfony\Component\Form\Extension\Core\Type\FormType::class;
    }

}
