<?php

namespace Schema31\GeoBundle\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormInterface;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Doctrine\ORM\EntityRepository;

use Schema31\GeoBundle\Model\LuogoNascita;
use Schema31\GeoBundle\Entity\GeoStato;
use Schema31\GeoBundle\Entity\GeoProvincia;
use Schema31\GeoBundle\Entity\GeoComune;

/**
 * Descrizione di GeoStatoType
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class LuogoNascitaType extends AbstractType {
    const ITALIA_ID = 1;

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('stato', GeoStatoType::class);   
        
        $comuneModifier = function(FormInterface $form, $provinciaId) {
            $optionsComune = ['class' => GeoComune::class];
            if (is_null($provinciaId)) {
                $optionsComune['choices'] = [];
                $optionsComune['disabled'] = true;
            } else {
                $optionsComune['query_builder'] = function (EntityRepository $er) use ($provinciaId){
                    return $er->createQueryBuilder('g')
                    ->where('g.provincia = '.$provinciaId)
                    ->orderBy('g.denominazione', 'ASC');
                };
            }
            
            $form->add('comune', EntityType::class, $optionsComune);            
        };
        
        $formModifier = function(FormInterface $form, LuogoNascita $data) use ($comuneModifier){      
            $stato = $data->getStato();
            $hasProvincia = !is_null($stato) && $stato->getId() == self::ITALIA_ID;
            
            $optionsProvincia = [];
            if (!$hasProvincia) {
                $optionsProvincia['disabled'] = true;
            }
            $form->add('provincia', GeoProvinciaType::class, $optionsProvincia);                 
            
            $comuneModifier($form, is_null($data->getProvincia()) ? null : $data->getProvincia()->getId());                          
        };
           
        $builder->addEventListener(
            FormEvents::PRE_SET_DATA,
            function (FormEvent $event) use ($formModifier){
                $formModifier($event->getForm(), $event->getData());
            }                
        );
        
        $builder->addEventListener(
            FormEvents::PRE_SUBMIT, 
            function (FormEvent $event) use ($comuneModifier){
                $form = $event->getForm();
                $data = $event->getData();

                if (isset($data['stato']) && $data['stato'] == self::ITALIA_ID) {
                    $form->add('provincia', GeoProvinciaType::class);
                }

                if (isset($data['provincia'])) {
                    $comuneModifier($form, $data['provincia']);
                }
            }
        );                       
    }
    
    public function configureOptions(OptionsResolver $resolver) 
    {
        $resolver->setDefaults(array(
            "data_class" => LuogoNascita::class
        ));
    } 
    
    public function getParent() {
        return \Symfony\Component\Form\Extension\Core\Type\FormType::class;
    }

}
