<?php

namespace Schema31\GeoBundle\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Doctrine\ORM\EntityRepository;

use Schema31\GeoBundle\Entity\GeoProvincia;

/**
 * Descrizione di GeoStatoType
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class GeoProvinciaType extends AbstractType {

    public function configureOptions(OptionsResolver $resolver) 
    {
        $resolver->setDefaults(array(
            'class' => GeoProvincia::class,
            'query_builder' => function (EntityRepository $er) {
                return $er->createQueryBuilder('g')
                    ->orderBy('g.denominazione', 'ASC');
                },
            'empty_data' => '-',            
        ));
    }
    
    public function getParent()
    {
        return EntityType::class;
    }    

}
