<?php

namespace Schema31\GeoBundle\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormEvent;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;

use Schema31\GeoBundle\Model\LuogoNascita;

/**
 * Descrizione di GeoStatoType
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class LuogoNascitaType extends AbstractType {

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('stato', GeoStatoType::class)
            ->addEventListener(
                FormEvents::SUBMIT,
                [$this, 'onPreSubmit']
            )    
        ;
    }
    
    public function onPreSubmit(FormEvent $event)
    {
        $form = $event->getForm();     
        $stato = $form->get("stato")->getData();
        
        if ($stato->getDenominazione() == "Italia") {
            $form->add('provincia', GeoProvinciaType::class);
            
            $provincia = $form->get("provincia")->getData();
            
            if (!is_null($provincia)) {
                $form->add('comune', EntityType, [
                    'class' => GeoProvincia::class,
                    'query_builder' => function (EntityRepository $er) use ($provincia) {
                        return $er->createQueryBuilder('g')
                        ->where('g.provincia', $provincia->getId())
                        ->orderBy('g.denominazione', 'ASC');
                    }]
                );
            }
        }
    }    
    
    public function configureOptions(OptionsResolver $resolver) 
    {
        $resolver->setDefaults(array(
            "data_class" => LuogoNascita::class
        ));
    } 

}
