<?php

namespace Schema31\GeoBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity()
 * @ORM\Table(name="geo_province")
 */
class GeoProvincia extends Geo {

    /**
     * @ORM\ManyToOne(targetEntity="GeoRegione", inversedBy="province")
     * @ORM\JoinColumn()
     */
    protected $regione;

    /**
     * @ORM\Column(type="string", length=2)
     */
    protected $sigla_automobilistica;

    /**
     * @ORM\OneToMany(targetEntity="GeoComune", mappedBy="provincia")
     */
    protected $comuni;
    
    public function getRegione() {
        return $this->regione;
    }

    public function getSiglaAutomobilistica() {
        return $this->sigla_automobilistica;
    }

    public function getComuni() {
        return $this->comuni;
    } 

}