<?php

namespace Schema31\GeoBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

abstract class Geo {

    /**
     * @ORM\Id
     * @ORM\Column(type="bigint")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(type="string", length=256)
     */
    protected $denominazione;

    /**
     * @ORM\Column(type="date")
     */
    protected $data_istituzione;

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    protected $data_destituzione;
    
    public function getId() {
        return $this->id;
    }

    public function setId($id) {
        $this->id = $id;
    }

    public function getDenominazione() {
        return $this->denominazione;
    }

    public function setDenominazione($denominazione) {
        $this->denominazione = $denominazione;
    }

    public function getDataIstituzione() {
        return $this->data_istituzione;
    }

    public function setDataIstituzione($data_istituzione) {
        $this->data_istituzione = $data_istituzione;
    }

    public function getDataDestituzione() {
        return $this->data_destituzione;
    }

    public function setDataDestituzione($data_destituzione) {
        $this->data_destituzione = $data_destituzione;
    }

	public function __toString() {
		return $this->getDenominazione();
	}    
}
