<?php

namespace Schema31\GeoBundle\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;

use Symfony\Component\Form\Extension\Core\Type\TextType;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\OrderBy;

use Schema31\GeoBundle\Model\Luogo;
use Schema31\GeoBundle\Entity\GeoComune;

use Schema31\GeoBundle\Schema31GeoBundle;

/**
 * Descrizione di StatoComuneType
 * 
 * WIP
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class StatoComuneType extends AbstractType {
    
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('stato', GeoStatoType::class, ['cessati' => $options['cessati']]);
        
        $formModifier = function(FormInterface $form, ?int $statoId) use ($options) {      
            $hasComune = !is_null($statoId) && $statoId == Schema31GeoBundle::ITALIA_ID;
                 
            $optionsComune = ['mapped' => false];
            $optionsComune['disabled'] = !$hasComune;
            $optionsComune['required'] = $hasComune;
           
            $form->add('comuneSearch', TextType::class, $optionsComune);                
        };
           
        $builder->addEventListener(
            FormEvents::PRE_SET_DATA,
            function (FormEvent $event) use ($formModifier){
                $stato = $event->getData()->getStato();
                
                $formModifier($event->getForm(), is_null($stato) ? null : $stato->getId());
            }                
        );
        
        $builder->addEventListener(
            FormEvents::PRE_SUBMIT, 
            function (FormEvent $event) use ($formModifier){
                $data = $event->getData();

                $formModifier($event->getForm(), isset($data['stato']) ? (int) $data['stato'] : null);
            }
        );                       
    }
    
    public function buildView(FormView $view, FormInterface $form, array $options) {   
        $view->vars['cessati'] = $options['cessati'];
    }
    
    public function configureOptions(OptionsResolver $resolver) 
    {
        $resolver->setDefaults(array(
            'data_class' => Luogo::class,
            'cessati' => false   
        ));       
    } 
    
    public function getParent() {
        return \Symfony\Component\Form\Extension\Core\Type\FormType::class;
    }

}
