<?php

namespace Schema31\GeoBundle\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * Descrizione di IndirizzoRegioneItaliaType
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class IndirizzoRegioneItaliaType extends AbstractType {

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $optionsProvincia = [];
        
        $optionsProvincia['query_builder'] = function (EntityRepository $er) use ($options){
                $orderBy = new OrderBy();
                $orderBy->add('g.denominazione', 'ASC');

                $qb = $er->createQueryBuilder('g')
                ->where('g.regione = '.$options['regione']->getId());

                if (!$options['cessati']) {
                    $qb->andWhere('g.cessato = 0');
                }

                return $qb->orderBy($orderBy);
            };            
        
        $builder->add('provincia', GeoProvinciaType::class, $optionsProvincia);
        
        $formModifier = function(FormInterface $form, ?int $provinciaId) use ($options) {      
            $hasComune = !is_null($provinciaId);
                              
            $optionsComune = ['class' => GeoComune::class, 'placeholder' => ''];
            if (!$hasComune) {
                $optionsComune['choices'] = [];
                $optionsComune['disabled'] = true;
                $optionsComune['required'] = false;
            } else {
                $optionsComune['disabled'] = false;
                $optionsComune['required'] = true;
                
                $optionsComune['query_builder'] = function (EntityRepository $er) use ($provinciaId, $options){
                    $orderBy = new OrderBy();
                    $orderBy->add('g.capoluogo', 'DESC');
                    $orderBy->add('g.denominazione', 'ASC');
                    
                    $qb = $er->createQueryBuilder('g')
                    ->where('g.provincia = '.$provinciaId);
                    
                    if (!$options['cessati']) {
                        $qb->where('g.cessato = 0');
                    }
                    
                    return $qb->orderBy($orderBy);
                };
            }
            
            $form->add('comune', EntityType::class, $optionsComune);                
        };
           
        $builder->addEventListener(
            FormEvents::PRE_SET_DATA,
            function (FormEvent $event) use ($formModifier){
                $provincia = $event->getData()->getProvincia();
                
                $formModifier($event->getForm(), is_null($provincia) ? null : $provincia->getId());
            }                
        );
        
        $builder->addEventListener(
            FormEvents::PRE_SUBMIT, 
            function (FormEvent $event) use ($formModifier){
                $data = $event->getData();

                $formModifier($event->getForm(), isset($data['provincia']) ? (int) $data['provincia'] : null);
            }
        ); 
        
        $builder->add('via', null, ['label' => 'Via (piazza, corso, etc.)']);
        $builder->add('numeroCivico', null, ['label' => 'Numero civico']);
        $builder->add('cap', null, ['label' => 'CAP']);
    }
    
    public function buildView(FormView $view, FormInterface $form, array $options) {   
        $view->vars['cessati'] = $options['cessati'];
    }
    
    public function configureOptions(OptionsResolver $resolver) 
    {
        $resolver->setDefaults(array(
            'data_class' => Luogo::class,
            'cessati' => false
        ));
        
        $resolver->setRequired('regione');
    } 
    
    public function getParent() {
        return \Symfony\Component\Form\Extension\Core\Type\FormType::class;
    }

}
