<?php

namespace Schema31\GeoBundle\Model;

use Symfony\Component\Validator\Constraints as Assert;
use Doctrine\ORM\Mapping as ORM;

/**
 * Description of IndirizzoRegioneItalia
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class IndirizzoRegioneItalia {

    /**
     * @var Schema31\GeoBundle\Entity\GeoProvincia $provincia
     *
     * @ORM\ManyToOne(targetEntity="Schema31\GeoBundle\Entity\GeoProvincia")
     * @ORM\JoinColumn(nullable=false)
     * @Assert\NotNull()
     */    
    private $provincia;
    
    /**
     * @var Schema31\GeoBundle\Entity\GeoComune $comune
     *
     * @ORM\ManyToOne(targetEntity="Schema31\GeoBundle\Entity\GeoComune")
     * @ORM\JoinColumn(nullable=false)
     * @Assert\NotNull()
     */    
    private $comune;
    
    use IndirizzoTrait;
    
    public function getProvincia(): Schema31\GeoBundle\Entity\GeoProvincia {
        return $this->provincia;
    }

    public function getComune(): Schema31\GeoBundle\Entity\GeoComune {
        return $this->comune;
    }

    public function setProvincia(Schema31\GeoBundle\Entity\GeoProvincia $provincia) {
        $this->provincia = $provincia;
    }

    public function setComune(Schema31\GeoBundle\Entity\GeoComune $comune) {
        $this->comune = $comune;
    }

}
