<?php

namespace Schema31\GeoBundle\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\OptionsResolver\Options;

use Doctrine\ORM\EntityRepository;

use Schema31\GeoBundle\Entity\GeoStato;

/**
 * Descrizione di GeoStatoType
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class GeoStatoType extends AbstractType {

    public function configureOptions(OptionsResolver $resolver) 
    {
        $resolver->setDefaults(array(
            'class' => GeoStato::class,
            'placeholder' => '',
            'cessati' => false
        ));
                
        $resolver->setDefault('query_builder', function (Options $options) {
            return function (EntityRepository $er) use ($options) {
                $qb = $er->createQueryBuilder('g');
                
                if (!$options['cessati']) {
                    $qb->where('g.cessato = 0');
                }
                
                return $qb->orderBy('g.denominazione', 'ASC');
                };
        });                 
    }
    
    public function getParent()
    {
        return EntityType::class;
    }    

}
