<?php

namespace Schema31\GeoBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity()
 * @ORM\Table(name="geo_regioni")
 */
class GeoRegione extends Geo {

    /**
     * @ORM\ManyToOne(targetEntity="GeoStato", inversedBy="regioni")
     * @ORM\JoinColumn()
     */
    protected $stato;

    /**
     * @ORM\OneToMany(targetEntity="GeoProvincia", mappedBy="regione")
     */
    protected $province;

    public function getStato() {
        return $this->stato;
    }

    public function getProvince() {
        return $this->province;
    }

}
