<?php

namespace Schema31\GeoBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;

use Schema31\GeoBundle\Entity\GeoComune;

/**
 * Description of ComuneController
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class ComuneController extends Controller {
    
    /**
     * @Route("/byProvincia/{provinciaId}")
     */
    public function comuniByProvinciaAction($provinciaId)
    {
        $em = $this->get('doctrine')->getManager();
        
        $comuni = $em->getRepository(GeoComune::class)->findBy(['provincia' => $provinciaId]);
        
        $result = new \stdClass();
        $result->count = count($comuni);
        $result->items = array_map(function($comune) { 
            $resultComune = new \stdClass(); 
            $resultComune->id = $comune->getId();   
            $resultComune->denominazione = $comune->getDenominazione();
            
            return $resultComune;
        }, $comuni);

        return new JsonResponse($result);
    }
}
