CREATE TABLE `geo_stati` (
  `id` bigint(4) NOT NULL AUTO_INCREMENT,
  `denominazione` varchar(255) NOT NULL,
  `data_istituzione` date NOT NULL,
  `data_destituzione` date DEFAULT NULL,
  `cessato` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `geo_regioni` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `stato_id` bigint(20) NOT NULL,
  `denominazione` varchar(255) NOT NULL,
  `data_istituzione` date NOT NULL,
  `data_destituzione` date DEFAULT NULL,
  `cessato` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_E8130D8B6A65DCA5` (`stato_id`),
  CONSTRAINT `geo_regioni_ibfk_1` FOREIGN KEY (`stato_id`) REFERENCES `geo_stati` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `geo_province` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `regione_id` bigint(20) DEFAULT NULL,
  `sigla_automobilistica` varchar(2) NOT NULL,
  `denominazione` varchar(255) NOT NULL,
  `data_istituzione` date NOT NULL,
  `data_destituzione` date DEFAULT NULL,
  `cessato` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_A463A3AA899A361C` (`regione_id`),
  CONSTRAINT `geo_province_ibfk_1` FOREIGN KEY (`regione_id`) REFERENCES `geo_regioni` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `geo_comuni` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `provincia_id` bigint(20) NOT NULL,
  `denominazione` varchar(255) NOT NULL,
  `capoluogo` tinyint(1) NOT NULL,
  `data_istituzione` date NOT NULL,
  `data_destituzione` date DEFAULT NULL,
  `cessato` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_DB771F054E7121AF` (`provincia_id`),
  CONSTRAINT `geo_comuni_ibfk_1` FOREIGN KEY (`provincia_id`) REFERENCES `geo_province` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

# Dump of table geo_stati
# ------------------------------------------------------------

INSERT INTO `geo_stati` (`id`, `denominazione`, `data_istituzione`, `data_destituzione`, `cessato`)
VALUES
	(1,'Italia','1800-01-01',NULL,0),
	(2,'Austria','1800-01-01',NULL,0),
	(3,'Belgio','1800-01-01',NULL,0),
	(4,'Bulgaria','1800-01-01',NULL,0),
	(5,'Ceca, Repubblica','1800-01-01',NULL,0),
	(6,'Cipro','1800-01-01',NULL,0),
	(7,'Danimarca','1800-01-01',NULL,0),
	(8,'Estonia','1800-01-01',NULL,0),
	(9,'Finlandia','1800-01-01',NULL,0),
	(10,'Francia','1800-01-01',NULL,0),
	(11,'Germania','1800-01-01',NULL,0),
	(12,'Grecia','1800-01-01',NULL,0),
	(13,'Irlanda','1800-01-01',NULL,0),
	(14,'Lettonia','1800-01-01',NULL,0),
	(15,'Lituania','1800-01-01',NULL,0),
	(16,'Lussemburgo','1800-01-01',NULL,0),
	(17,'Malta','1800-01-01',NULL,0),
	(18,'Paesi Bassi','1800-01-01',NULL,0),
	(19,'Polonia','1800-01-01',NULL,0),
	(20,'Portogallo','1800-01-01',NULL,0),
	(21,'Regno Unito','1800-01-01',NULL,0),
	(22,'Romania','1800-01-01',NULL,0),
	(23,'Slovacchia','1800-01-01',NULL,0),
	(24,'Slovenia','1800-01-01',NULL,0),
	(25,'Spagna','1800-01-01',NULL,0),
	(26,'Svezia','1800-01-01',NULL,0),
	(27,'Ungheria','1800-01-01',NULL,0),
	(28,'Albania','1800-01-01',NULL,0),
	(29,'Andorra','1800-01-01',NULL,0),
	(30,'Bielorussia','1800-01-01',NULL,0),
	(31,'Bosnia-Erzegovina','1800-01-01',NULL,0),
	(32,'Croazia','1800-01-01',NULL,0),
	(33,'Islanda','1800-01-01',NULL,0),
	(34,'Kosovo','1800-01-01',NULL,0),
	(35,'Liechtenstein','1800-01-01',NULL,0),
	(36,'Macedonia, Repubblica di','1800-01-01',NULL,0),
	(37,'Moldova','1800-01-01',NULL,0),
	(38,'Monaco','1800-01-01',NULL,0),
	(39,'Montenegro','1800-01-01',NULL,0),
	(40,'Norvegia','1800-01-01',NULL,0),
	(41,'Russa, Federazione','1800-01-01',NULL,0),
	(42,'San Marino','1800-01-01',NULL,0),
	(43,'Serbia, Repubblica di','1800-01-01',NULL,0),
	(44,'Stato della Città del Vaticano','1800-01-01',NULL,0),
	(45,'Svizzera','1800-01-01',NULL,0),
	(46,'Turchia','1800-01-01',NULL,0),
	(47,'Ucraina','1800-01-01',NULL,0),
	(48,'Algeria','1800-01-01',NULL,0),
	(49,'Angola','1800-01-01',NULL,0),
	(50,'Benin (ex Dahomey)','1800-01-01',NULL,0),
	(51,'Botswana','1800-01-01',NULL,0),
	(52,'Burkina Faso (ex Alto Volta)','1800-01-01',NULL,0),
	(53,'Burundi','1800-01-01',NULL,0),
	(54,'Camerun','1800-01-01',NULL,0),
	(55,'Capo Verde','1800-01-01',NULL,0),
	(56,'Centrafricana, Repubblica','1800-01-01',NULL,0),
	(57,'Ciad','1800-01-01',NULL,0),
	(58,'Comore','1800-01-01',NULL,0),
	(59,'Congo (Repubblica del)','1800-01-01',NULL,0),
	(60,'Congo, Repubblica democratica del (ex Zaire)','1800-01-01',NULL,0),
	(61,'Costa d\'Avorio','1800-01-01',NULL,0),
	(62,'Egitto','1800-01-01',NULL,0),
	(63,'Eritrea','1800-01-01',NULL,0),
	(64,'Etiopia','1800-01-01',NULL,0),
	(65,'Gabon','1800-01-01',NULL,0),
	(66,'Gambia','1800-01-01',NULL,0),
	(67,'Ghana','1800-01-01',NULL,0),
	(68,'Gibuti','1800-01-01',NULL,0),
	(69,'Guinea','1800-01-01',NULL,0),
	(70,'Guinea Bissau','1800-01-01',NULL,0),
	(71,'Guinea Equatoriale','1800-01-01',NULL,0),
	(72,'Kenya','1800-01-01',NULL,0),
	(73,'Lesotho','1800-01-01',NULL,0),
	(74,'Liberia','1800-01-01',NULL,0),
	(75,'Libia','1800-01-01',NULL,0),
	(76,'Madagascar','1800-01-01',NULL,0),
	(77,'Malawi','1800-01-01',NULL,0),
	(78,'Mali','1800-01-01',NULL,0),
	(79,'Marocco','1800-01-01',NULL,0),
	(80,'Mauritania','1800-01-01',NULL,0),
	(81,'Mauritius','1800-01-01',NULL,0),
	(82,'Mozambico','1800-01-01',NULL,0),
	(83,'Namibia','1800-01-01',NULL,0),
	(84,'Niger','1800-01-01',NULL,0),
	(85,'Nigeria','1800-01-01',NULL,0),
	(86,'Ruanda','1800-01-01',NULL,0),
	(87,'São Tomé e Principe','1800-01-01',NULL,0),
	(88,'Senegal','1800-01-01',NULL,0),
	(89,'Seychelles','1800-01-01',NULL,0),
	(90,'Sierra Leone','1800-01-01',NULL,0),
	(91,'Somalia','1800-01-01',NULL,0),
	(92,'Sud Africa','1800-01-01',NULL,0),
	(93,'Sudan','1800-01-01',NULL,0),
	(94,'Swaziland','1800-01-01',NULL,0),
	(95,'Tanzania','1800-01-01',NULL,0),
	(96,'Togo','1800-01-01',NULL,0),
	(97,'Tunisia','1800-01-01',NULL,0),
	(98,'Uganda','1800-01-01',NULL,0),
	(99,'Zambia','1800-01-01',NULL,0),
	(100,'Zimbabwe (ex Rhodesia)','1800-01-01',NULL,0),
	(101,'Antigua e Barbuda','1800-01-01',NULL,0),
	(102,'Argentina','1800-01-01',NULL,0),
	(103,'Bahamas','1800-01-01',NULL,0),
	(104,'Barbados','1800-01-01',NULL,0),
	(105,'Belize','1800-01-01',NULL,0),
	(106,'Bolivia','1800-01-01',NULL,0),
	(107,'Brasile','1800-01-01',NULL,0),
	(108,'Canada','1800-01-01',NULL,0),
	(109,'Cile','1800-01-01',NULL,0),
	(110,'Colombia','1800-01-01',NULL,0),
	(111,'Costa Rica','1800-01-01',NULL,0),
	(112,'Cuba','1800-01-01',NULL,0),
	(113,'Dominica','1800-01-01',NULL,0),
	(114,'Dominicana, Repubblica','1800-01-01',NULL,0),
	(115,'Ecuador','1800-01-01',NULL,0),
	(116,'El Salvador','1800-01-01',NULL,0),
	(117,'Giamaica','1800-01-01',NULL,0),
	(118,'Grenada','1800-01-01',NULL,0),
	(119,'Guatemala','1800-01-01',NULL,0),
	(120,'Guyana','1800-01-01',NULL,0),
	(121,'Haiti','1800-01-01',NULL,0),
	(122,'Honduras','1800-01-01',NULL,0),
	(123,'Messico','1800-01-01',NULL,0),
	(124,'Nicaragua','1800-01-01',NULL,0),
	(125,'Panama','1800-01-01',NULL,0),
	(126,'Paraguay','1800-01-01',NULL,0),
	(127,'Perù','1800-01-01',NULL,0),
	(128,'Saint Kitts e Nevis','1800-01-01',NULL,0),
	(129,'Saint Lucia','1800-01-01',NULL,0),
	(130,'Saint Vincent e Grenadine','1800-01-01',NULL,0),
	(131,'Stati Uniti d\'America','1800-01-01',NULL,0),
	(132,'Suriname','1800-01-01',NULL,0),
	(133,'Trinidad e Tobago','1800-01-01',NULL,0),
	(134,'Uruguay','1800-01-01',NULL,0),
	(135,'Venezuela','1800-01-01',NULL,0),
	(136,'Afghanistan','1800-01-01',NULL,0),
	(137,'Arabia Saudita','1800-01-01',NULL,0),
	(138,'Armenia','1800-01-01',NULL,0),
	(139,'Azerbaigian','1800-01-01',NULL,0),
	(140,'Bahrein','1800-01-01',NULL,0),
	(141,'Bangladesh','1800-01-01',NULL,0),
	(142,'Bhutan','1800-01-01',NULL,0),
	(143,'Brunei','1800-01-01',NULL,0),
	(144,'Cambogia','1800-01-01',NULL,0),
	(145,'Cinese, Repubblica Popolare','1800-01-01',NULL,0),
	(146,'Corea, Repubblica Popolare Democratica (Corea del Nord)','1800-01-01',NULL,0),
	(147,'Corea, Repubblica (Corea del Sud)','1800-01-01',NULL,0),
	(148,'Emirati Arabi Uniti','1800-01-01',NULL,0),
	(149,'Filippine','1800-01-01',NULL,0),
	(150,'Georgia','1800-01-01',NULL,0),
	(151,'Giappone','1800-01-01',NULL,0),
	(152,'Giordania','1800-01-01',NULL,0),
	(153,'India','1800-01-01',NULL,0),
	(154,'Indonesia','1800-01-01',NULL,0),
	(155,'Iran, Repubblica Islamica del','1800-01-01',NULL,0),
	(156,'Iraq','1800-01-01',NULL,0),
	(157,'Israele','1800-01-01',NULL,0),
	(158,'Kazakhstan','1800-01-01',NULL,0),
	(159,'Kirghizistan','1800-01-01',NULL,0),
	(160,'Kuwait','1800-01-01',NULL,0),
	(161,'Laos','1800-01-01',NULL,0),
	(162,'Libano','1800-01-01',NULL,0),
	(163,'Malaysia','1800-01-01',NULL,0),
	(164,'Maldive','1800-01-01',NULL,0),
	(165,'Mongolia','1800-01-01',NULL,0),
	(166,'Myanmar (ex Birmania)','1800-01-01',NULL,0),
	(167,'Nepal','1800-01-01',NULL,0),
	(168,'Oman','1800-01-01',NULL,0),
	(169,'Pakistan','1800-01-01',NULL,0),
	(170,'Qatar','1800-01-01',NULL,0),
	(171,'Singapore','1800-01-01',NULL,0),
	(172,'Siria','1800-01-01',NULL,0),
	(173,'Sri Lanka (ex Ceylon)','1800-01-01',NULL,0),
	(174,'Tagikistan','1800-01-01',NULL,0),
	(175,'Taiwan (ex FROMosa)','1800-01-01',NULL,0),
	(176,'Territori dell\'Autonomia Palestinese','1800-01-01',NULL,0),
	(177,'Thailandia','1800-01-01',NULL,0),
	(178,'Timor Orientale','1800-01-01',NULL,0),
	(179,'Turkmenistan','1800-01-01',NULL,0),
	(180,'Uzbekistan','1800-01-01',NULL,0),
	(181,'Vietnam','1800-01-01',NULL,0),
	(182,'Yemen','1800-01-01',NULL,0),
	(183,'Australia','1800-01-01',NULL,0),
	(184,'Figi','1800-01-01',NULL,0),
	(185,'Kiribati','1800-01-01',NULL,0),
	(186,'Marshall, Isole','1800-01-01',NULL,0),
	(187,'Micronesia, Stati Federati','1800-01-01',NULL,0),
	(188,'Nauru','1800-01-01',NULL,0),
	(189,'Nuova Zelanda','1800-01-01',NULL,0),
	(190,'Palau','1800-01-01',NULL,0),
	(191,'Papua Nuova Guinea','1800-01-01',NULL,0),
	(192,'Salomone, Isole','1800-01-01',NULL,0),
	(193,'Samoa','1800-01-01',NULL,0),
	(194,'Tonga','1800-01-01',NULL,0),
	(195,'Tuvalu','1800-01-01',NULL,0),
	(196,'Vanuatu','1800-01-01',NULL,0),
	(197,'Apolide','1800-01-01',NULL,0),
	(198,'Jugoslavia','1800-01-01','2003-02-04',0);

# Dump of table geo_regioni
# ------------------------------------------------------------

INSERT INTO `geo_regioni` (`id`, `stato_id`, `denominazione`, `data_istituzione`, `data_destituzione`, `cessato`)
VALUES
	(1,1,'Piemonte','1800-01-01',NULL,0),
	(2,1,'Valle d\'Aosta/Vallée d\'Aoste','1800-01-01',NULL,0),
	(3,1,'Lombardia','1800-01-01',NULL,0),
	(4,1,'Trentino-Alto Adige/Südtirol','1800-01-01',NULL,0),
	(5,1,'Veneto','1800-01-01',NULL,0),
	(6,1,'Friuli-Venezia Giulia','1800-01-01',NULL,0),
	(7,1,'Liguria','1800-01-01',NULL,0),
	(8,1,'Emilia-Romagna','1800-01-01',NULL,0),
	(9,1,'Toscana','1800-01-01',NULL,0),
	(10,1,'Umbria','1800-01-01',NULL,0),
	(11,1,'Marche','1800-01-01',NULL,0),
	(12,1,'Lazio','1800-01-01',NULL,0),
	(13,1,'Abruzzo','1800-01-01',NULL,0),
	(14,1,'Molise','1800-01-01',NULL,0),
	(15,1,'Campania','1800-01-01',NULL,0),
	(16,1,'Puglia','1800-01-01',NULL,0),
	(17,1,'Basilicata','1800-01-01',NULL,0),
	(18,1,'Calabria','1800-01-01',NULL,0),
	(19,1,'Sicilia','1800-01-01',NULL,0),
	(20,1,'Sardegna','1800-01-01',NULL,0);

# Dump of table geo_province
# ------------------------------------------------------------

INSERT INTO `geo_province` (`id`, `regione_id`, `sigla_automobilistica`, `denominazione`, `data_istituzione`, `data_destituzione`, `cessato`)
VALUES
	(1,1,'TO','Torino','1800-01-01',NULL,0),
	(2,1,'VC','Vercelli','1800-01-01',NULL,0),
	(3,1,'NO','Novara','1800-01-01',NULL,0),
	(4,1,'CN','Cuneo','1800-01-01',NULL,0),
	(5,1,'AT','Asti','1800-01-01',NULL,0),
	(6,1,'AL','Alessandria','1800-01-01',NULL,0),
	(7,1,'BI','Biella','1800-01-01',NULL,0),
	(8,1,'VB','Verbano-Cusio-Ossola','1800-01-01',NULL,0),
	(9,2,'AO','Valle d\'Aosta/Vallée d\'Aoste','1800-01-01',NULL,0),
	(10,3,'VA','Varese','1800-01-01',NULL,0),
	(11,3,'CO','Como','1800-01-01',NULL,0),
	(12,3,'SO','Sondrio','1800-01-01',NULL,0),
	(13,3,'MI','Milano','1800-01-01',NULL,0),
	(14,3,'BG','Bergamo','1800-01-01',NULL,0),
	(15,3,'BS','Brescia','1800-01-01',NULL,0),
	(16,3,'PV','Pavia','1800-01-01',NULL,0),
	(17,3,'CR','Cremona','1800-01-01',NULL,0),
	(18,3,'MN','Mantova','1800-01-01',NULL,0),
	(19,3,'LC','Lecco','1800-01-01',NULL,0),
	(20,3,'LO','Lodi','1800-01-01',NULL,0),
	(21,3,'MB','Monza e della Brianza','1800-01-01',NULL,0),
	(22,4,'BZ','Bolzano/Bozen','1800-01-01',NULL,0),
	(23,4,'TN','Trento','1800-01-01',NULL,0),
	(24,5,'VR','Verona','1800-01-01',NULL,0),
	(25,5,'VI','Vicenza','1800-01-01',NULL,0),
	(26,5,'BL','Belluno','1800-01-01',NULL,0),
	(27,5,'TV','Treviso','1800-01-01',NULL,0),
	(28,5,'VE','Venezia','1800-01-01',NULL,0),
	(29,5,'PD','Padova','1800-01-01',NULL,0),
	(30,5,'RO','Rovigo','1800-01-01',NULL,0),
	(31,6,'UD','Udine','1800-01-01',NULL,0),
	(32,6,'GO','Gorizia','1800-01-01',NULL,0),
	(33,6,'TS','Trieste','1800-01-01',NULL,0),
	(34,6,'PN','Pordenone','1800-01-01',NULL,0),
	(35,7,'IM','Imperia','1800-01-01',NULL,0),
	(36,7,'SV','Savona','1800-01-01',NULL,0),
	(37,7,'GE','Genova','1800-01-01',NULL,0),
	(38,7,'SP','La Spezia','1800-01-01',NULL,0),
	(39,8,'PC','Piacenza','1800-01-01',NULL,0),
	(40,8,'PR','Parma','1800-01-01',NULL,0),
	(41,8,'RE','Reggio nell\'Emilia','1800-01-01',NULL,0),
	(42,8,'MO','Modena','1800-01-01',NULL,0),
	(43,8,'BO','Bologna','1800-01-01',NULL,0),
	(44,8,'FE','Ferrara','1800-01-01',NULL,0),
	(45,8,'RA','Ravenna','1800-01-01',NULL,0),
	(46,8,'FC','Forlì-Cesena','1800-01-01',NULL,0),
	(47,8,'RN','Rimini','1800-01-01',NULL,0),
	(48,9,'MS','Massa-Carrara','1800-01-01',NULL,0),
	(49,9,'LU','Lucca','1800-01-01',NULL,0),
	(50,9,'PT','Pistoia','1800-01-01',NULL,0),
	(51,9,'FI','Firenze','1800-01-01',NULL,0),
	(52,9,'LI','Livorno','1800-01-01',NULL,0),
	(53,9,'PI','Pisa','1800-01-01',NULL,0),
	(54,9,'AR','Arezzo','1800-01-01',NULL,0),
	(55,9,'SI','Siena','1800-01-01',NULL,0),
	(56,9,'GR','Grosseto','1800-01-01',NULL,0),
	(57,9,'PO','Prato','1800-01-01',NULL,0),
	(58,10,'PG','Perugia','1800-01-01',NULL,0),
	(59,10,'TR','Terni','1800-01-01',NULL,0),
	(60,11,'PU','Pesaro e Urbino','1800-01-01',NULL,0),
	(61,11,'AN','Ancona','1800-01-01',NULL,0),
	(62,11,'MC','Macerata','1800-01-01',NULL,0),
	(63,11,'AP','Ascoli Piceno','1800-01-01',NULL,0),
	(64,11,'FM','Fermo','1800-01-01',NULL,0),
	(65,12,'VT','Viterbo','1800-01-01',NULL,0),
	(66,12,'RI','Rieti','1800-01-01',NULL,0),
	(67,12,'RM','Roma','1800-01-01',NULL,0),
	(68,12,'LT','Latina','1800-01-01',NULL,0),
	(69,12,'FR','Frosinone','1800-01-01',NULL,0),
	(70,13,'AQ','L\'Aquila','1800-01-01',NULL,0),
	(71,13,'TE','Teramo','1800-01-01',NULL,0),
	(72,13,'PE','Pescara','1800-01-01',NULL,0),
	(73,13,'CH','Chieti','1800-01-01',NULL,0),
	(74,14,'CB','Campobasso','1800-01-01',NULL,0),
	(75,14,'IS','Isernia','1800-01-01',NULL,0),
	(76,15,'CE','Caserta','1800-01-01',NULL,0),
	(77,15,'BN','Benevento','1800-01-01',NULL,0),
	(78,15,'NA','Napoli','1800-01-01',NULL,0),
	(79,15,'AV','Avellino','1800-01-01',NULL,0),
	(80,15,'SA','Salerno','1800-01-01',NULL,0),
	(81,16,'FG','Foggia','1800-01-01',NULL,0),
	(82,16,'BA','Bari','1800-01-01',NULL,0),
	(83,16,'TA','Taranto','1800-01-01',NULL,0),
	(84,16,'BR','Brindisi','1800-01-01',NULL,0),
	(85,16,'LE','Lecce','1800-01-01',NULL,0),
	(86,16,'BT','Barletta-Andria-Trani','1800-01-01',NULL,0),
	(87,17,'PZ','Potenza','1800-01-01',NULL,0),
	(88,17,'MT','Matera','1800-01-01',NULL,0),
	(89,18,'CS','Cosenza','1800-01-01',NULL,0),
	(90,18,'CZ','Catanzaro','1800-01-01',NULL,0),
	(91,18,'RC','Reggio di Calabria','1800-01-01',NULL,0),
	(92,18,'KR','Crotone','1800-01-01',NULL,0),
	(93,18,'VV','Vibo Valentia','1800-01-01',NULL,0),
	(94,19,'TP','Trapani','1800-01-01',NULL,0),
	(95,19,'PA','Palermo','1800-01-01',NULL,0),
	(96,19,'ME','Messina','1800-01-01',NULL,0),
	(97,19,'AG','Agrigento','1800-01-01',NULL,0),
	(98,19,'CL','Caltanissetta','1800-01-01',NULL,0),
	(99,19,'EN','Enna','1800-01-01',NULL,0),
	(100,19,'CT','Catania','1800-01-01',NULL,0),
	(101,19,'RG','Ragusa','1800-01-01',NULL,0),
	(102,19,'SR','Siracusa','1800-01-01',NULL,0),
	(103,20,'SS','Sassari','1800-01-01',NULL,0),
	(104,20,'NU','Nuoro','1800-01-01',NULL,0),
	(105,20,'CA','Cagliari','1800-01-01',NULL,0),
	(106,20,'OR','Oristano','1800-01-01',NULL,0),
	(107,20,'OT','Olbia-Tempio','1800-01-01',NULL,0),
	(108,20,'OG','Ogliastra','1800-01-01',NULL,0),
	(109,20,'VS','Medio Campidano','1800-01-01',NULL,0),
	(110,20,'CI','Carbonia-Iglesias','1800-01-01',NULL,0),
	(111,NULL,'FU','Fiume','1800-01-01',NULL,1),
	(112,NULL,'PL','Pola','1800-01-01',NULL,1),
	(113,NULL,'ZA','Zara','1800-01-01',NULL,1);

# Dump of table geo_comuni
# ------------------------------------------------------------

INSERT INTO `geo_comuni` (`id`, `provincia_id`, `denominazione`, `capoluogo`, `data_istituzione`, `data_destituzione`, `cessato`)
VALUES
	(1,1,'Agliè',0,'1800-01-01',NULL,0),
	(2,1,'Airasca',0,'1800-01-01',NULL,0),
	(3,1,'Ala di Stura',0,'1800-01-01',NULL,0),
	(4,1,'Albiano d\'Ivrea',0,'1800-01-01',NULL,0),
	(5,1,'Alice Superiore',0,'1800-01-01',NULL,0),
	(6,1,'Almese',0,'1800-01-01',NULL,0),
	(7,1,'Alpette',0,'1800-01-01',NULL,0),
	(8,1,'Alpignano',0,'1800-01-01',NULL,0),
	(9,1,'Andezeno',0,'1800-01-01',NULL,0),
	(10,1,'Andrate',0,'1800-01-01',NULL,0),
	(11,1,'Angrogna',0,'1800-01-01',NULL,0),
	(12,1,'Arignano',0,'1800-01-01',NULL,0),
	(13,1,'Avigliana',0,'1800-01-01',NULL,0),
	(14,1,'Azeglio',0,'1800-01-01',NULL,0),
	(15,1,'Bairo',0,'1800-01-01',NULL,0),
	(16,1,'Balangero',0,'1800-01-01',NULL,0),
	(17,1,'Baldissero Canavese',0,'1800-01-01',NULL,0),
	(18,1,'Baldissero Torinese',0,'1800-01-01',NULL,0),
	(19,1,'Balme',0,'1800-01-01',NULL,0),
	(20,1,'Banchette',0,'1800-01-01',NULL,0),
	(21,1,'Barbania',0,'1800-01-01',NULL,0),
	(22,1,'Bardonecchia',0,'1800-01-01',NULL,0),
	(23,1,'Barone Canavese',0,'1800-01-01',NULL,0),
	(24,1,'Beinasco',0,'1800-01-01',NULL,0),
	(25,1,'Bibiana',0,'1800-01-01',NULL,0),
	(26,1,'Bobbio Pellice',0,'1800-01-01',NULL,0),
	(27,1,'Bollengo',0,'1800-01-01',NULL,0),
	(28,1,'Borgaro Torinese',0,'1800-01-01',NULL,0),
	(29,1,'Borgiallo',0,'1800-01-01',NULL,0),
	(30,1,'Borgofranco d\'Ivrea',0,'1800-01-01',NULL,0),
	(31,1,'Borgomasino',0,'1800-01-01',NULL,0),
	(32,1,'Borgone Susa',0,'1800-01-01',NULL,0),
	(33,1,'Bosconero',0,'1800-01-01',NULL,0),
	(34,1,'Brandizzo',0,'1800-01-01',NULL,0),
	(35,1,'Bricherasio',0,'1800-01-01',NULL,0),
	(36,1,'Brosso',0,'1800-01-01',NULL,0),
	(37,1,'Brozolo',0,'1800-01-01',NULL,0),
	(38,1,'Bruino',0,'1800-01-01',NULL,0),
	(39,1,'Brusasco',0,'1800-01-01',NULL,0),
	(40,1,'Bruzolo',0,'1800-01-01',NULL,0),
	(41,1,'Buriasco',0,'1800-01-01',NULL,0),
	(42,1,'Burolo',0,'1800-01-01',NULL,0),
	(43,1,'Busano',0,'1800-01-01',NULL,0),
	(44,1,'Bussoleno',0,'1800-01-01',NULL,0),
	(45,1,'Buttigliera Alta',0,'1800-01-01',NULL,0),
	(46,1,'Cafasse',0,'1800-01-01',NULL,0),
	(47,1,'Caluso',0,'1800-01-01',NULL,0),
	(48,1,'Cambiano',0,'1800-01-01',NULL,0),
	(49,1,'Campiglione-Fenile',0,'1800-01-01',NULL,0),
	(50,1,'Candia Canavese',0,'1800-01-01',NULL,0),
	(51,1,'Candiolo',0,'1800-01-01',NULL,0),
	(52,1,'Canischio',0,'1800-01-01',NULL,0),
	(53,1,'Cantalupa',0,'1800-01-01',NULL,0),
	(54,1,'Cantoira',0,'1800-01-01',NULL,0),
	(55,1,'Caprie',0,'1800-01-01',NULL,0),
	(56,1,'Caravino',0,'1800-01-01',NULL,0),
	(57,1,'Carema',0,'1800-01-01',NULL,0),
	(58,1,'Carignano',0,'1800-01-01',NULL,0),
	(59,1,'Carmagnola',0,'1800-01-01',NULL,0),
	(60,1,'Casalborgone',0,'1800-01-01',NULL,0),
	(61,1,'Cascinette d\'Ivrea',0,'1800-01-01',NULL,0),
	(62,1,'Caselette',0,'1800-01-01',NULL,0),
	(63,1,'Caselle Torinese',0,'1800-01-01',NULL,0),
	(64,1,'Castagneto Po',0,'1800-01-01',NULL,0),
	(65,1,'Castagnole Piemonte',0,'1800-01-01',NULL,0),
	(66,1,'Castellamonte',0,'1800-01-01',NULL,0),
	(67,1,'Castelnuovo Nigra',0,'1800-01-01',NULL,0),
	(68,1,'Castiglione Torinese',0,'1800-01-01',NULL,0),
	(69,1,'Cavagnolo',0,'1800-01-01',NULL,0),
	(70,1,'Cavour',0,'1800-01-01',NULL,0),
	(71,1,'Cercenasco',0,'1800-01-01',NULL,0),
	(72,1,'Ceres',0,'1800-01-01',NULL,0),
	(73,1,'Ceresole Reale',0,'1800-01-01',NULL,0),
	(74,1,'Cesana Torinese',0,'1800-01-01',NULL,0),
	(75,1,'Chialamberto',0,'1800-01-01',NULL,0),
	(76,1,'Chianocco',0,'1800-01-01',NULL,0),
	(77,1,'Chiaverano',0,'1800-01-01',NULL,0),
	(78,1,'Chieri',0,'1800-01-01',NULL,0),
	(79,1,'Chiesanuova',0,'1800-01-01',NULL,0),
	(80,1,'Chiomonte',0,'1800-01-01',NULL,0),
	(81,1,'Chiusa di San Michele',0,'1800-01-01',NULL,0),
	(82,1,'Chivasso',0,'1800-01-01',NULL,0),
	(83,1,'Ciconio',0,'1800-01-01',NULL,0),
	(84,1,'Cintano',0,'1800-01-01',NULL,0),
	(85,1,'Cinzano',0,'1800-01-01',NULL,0),
	(86,1,'Ciriè',0,'1800-01-01',NULL,0),
	(87,1,'Claviere',0,'1800-01-01',NULL,0),
	(88,1,'Coassolo Torinese',0,'1800-01-01',NULL,0),
	(89,1,'Coazze',0,'1800-01-01',NULL,0),
	(90,1,'Collegno',0,'1800-01-01',NULL,0),
	(91,1,'Colleretto Castelnuovo',0,'1800-01-01',NULL,0),
	(92,1,'Colleretto Giacosa',0,'1800-01-01',NULL,0),
	(93,1,'Condove',0,'1800-01-01',NULL,0),
	(94,1,'Corio',0,'1800-01-01',NULL,0),
	(95,1,'Cossano Canavese',0,'1800-01-01',NULL,0),
	(96,1,'Cuceglio',0,'1800-01-01',NULL,0),
	(97,1,'Cumiana',0,'1800-01-01',NULL,0),
	(98,1,'Cuorgnè',0,'1800-01-01',NULL,0),
	(99,1,'Druento',0,'1800-01-01',NULL,0),
	(100,1,'Exilles',0,'1800-01-01',NULL,0),
	(101,1,'Favria',0,'1800-01-01',NULL,0),
	(102,1,'Feletto',0,'1800-01-01',NULL,0),
	(103,1,'Fenestrelle',0,'1800-01-01',NULL,0),
	(104,1,'Fiano',0,'1800-01-01',NULL,0),
	(105,1,'Fiorano Canavese',0,'1800-01-01',NULL,0),
	(106,1,'Foglizzo',0,'1800-01-01',NULL,0),
	(107,1,'Forno Canavese',0,'1800-01-01',NULL,0),
	(108,1,'Frassinetto',0,'1800-01-01',NULL,0),
	(109,1,'Front',0,'1800-01-01',NULL,0),
	(110,1,'Frossasco',0,'1800-01-01',NULL,0),
	(111,1,'Garzigliana',0,'1800-01-01',NULL,0),
	(112,1,'Gassino Torinese',0,'1800-01-01',NULL,0),
	(113,1,'Germagnano',0,'1800-01-01',NULL,0),
	(114,1,'Giaglione',0,'1800-01-01',NULL,0),
	(115,1,'Giaveno',0,'1800-01-01',NULL,0),
	(116,1,'Givoletto',0,'1800-01-01',NULL,0),
	(117,1,'Gravere',0,'1800-01-01',NULL,0),
	(118,1,'Groscavallo',0,'1800-01-01',NULL,0),
	(119,1,'Grosso',0,'1800-01-01',NULL,0),
	(120,1,'Grugliasco',0,'1800-01-01',NULL,0),
	(121,1,'Ingria',0,'1800-01-01',NULL,0),
	(122,1,'Inverso Pinasca',0,'1800-01-01',NULL,0),
	(123,1,'Isolabella',0,'1800-01-01',NULL,0),
	(124,1,'Issiglio',0,'1800-01-01',NULL,0),
	(125,1,'Ivrea',0,'1800-01-01',NULL,0),
	(126,1,'La Cassa',0,'1800-01-01',NULL,0),
	(127,1,'La Loggia',0,'1800-01-01',NULL,0),
	(128,1,'Lanzo Torinese',0,'1800-01-01',NULL,0),
	(129,1,'Lauriano',0,'1800-01-01',NULL,0),
	(130,1,'Leini',0,'1800-01-01',NULL,0),
	(131,1,'Lemie',0,'1800-01-01',NULL,0),
	(132,1,'Lessolo',0,'1800-01-01',NULL,0),
	(133,1,'Levone',0,'1800-01-01',NULL,0),
	(134,1,'Locana',0,'1800-01-01',NULL,0),
	(135,1,'Lombardore',0,'1800-01-01',NULL,0),
	(136,1,'Lombriasco',0,'1800-01-01',NULL,0),
	(137,1,'Loranzè',0,'1800-01-01',NULL,0),
	(138,1,'Lugnacco',0,'1800-01-01',NULL,0),
	(139,1,'Luserna San Giovanni',0,'1800-01-01',NULL,0),
	(140,1,'Lusernetta',0,'1800-01-01',NULL,0),
	(141,1,'Lusigliè',0,'1800-01-01',NULL,0),
	(142,1,'Macello',0,'1800-01-01',NULL,0),
	(143,1,'Maglione',0,'1800-01-01',NULL,0),
	(144,1,'Marentino',0,'1800-01-01',NULL,0),
	(145,1,'Massello',0,'1800-01-01',NULL,0),
	(146,1,'Mathi',0,'1800-01-01',NULL,0),
	(147,1,'Mattie',0,'1800-01-01',NULL,0),
	(148,1,'Mazzè',0,'1800-01-01',NULL,0),
	(149,1,'Meana di Susa',0,'1800-01-01',NULL,0),
	(150,1,'Mercenasco',0,'1800-01-01',NULL,0),
	(151,1,'Meugliano',0,'1800-01-01',NULL,0),
	(152,1,'Mezzenile',0,'1800-01-01',NULL,0),
	(153,1,'Mombello di Torino',0,'1800-01-01',NULL,0),
	(154,1,'Mompantero',0,'1800-01-01',NULL,0),
	(155,1,'Monastero di Lanzo',0,'1800-01-01',NULL,0),
	(156,1,'Moncalieri',0,'1800-01-01',NULL,0),
	(157,1,'Moncenisio',0,'1800-01-01',NULL,0),
	(158,1,'Montaldo Torinese',0,'1800-01-01',NULL,0),
	(159,1,'Montalenghe',0,'1800-01-01',NULL,0),
	(160,1,'Montalto Dora',0,'1800-01-01',NULL,0),
	(161,1,'Montanaro',0,'1800-01-01',NULL,0),
	(162,1,'Monteu da Po',0,'1800-01-01',NULL,0),
	(163,1,'Moriondo Torinese',0,'1800-01-01',NULL,0),
	(164,1,'Nichelino',0,'1800-01-01',NULL,0),
	(165,1,'Noasca',0,'1800-01-01',NULL,0),
	(166,1,'Nole',0,'1800-01-01',NULL,0),
	(167,1,'Nomaglio',0,'1800-01-01',NULL,0),
	(168,1,'None',0,'1800-01-01',NULL,0),
	(169,1,'Novalesa',0,'1800-01-01',NULL,0),
	(170,1,'Oglianico',0,'1800-01-01',NULL,0),
	(171,1,'Orbassano',0,'1800-01-01',NULL,0),
	(172,1,'Orio Canavese',0,'1800-01-01',NULL,0),
	(173,1,'Osasco',0,'1800-01-01',NULL,0),
	(174,1,'Osasio',0,'1800-01-01',NULL,0),
	(175,1,'Oulx',0,'1800-01-01',NULL,0),
	(176,1,'Ozegna',0,'1800-01-01',NULL,0),
	(177,1,'Palazzo Canavese',0,'1800-01-01',NULL,0),
	(178,1,'Pancalieri',0,'1800-01-01',NULL,0),
	(179,1,'Parella',0,'1800-01-01',NULL,0),
	(180,1,'Pavarolo',0,'1800-01-01',NULL,0),
	(181,1,'Pavone Canavese',0,'1800-01-01',NULL,0),
	(182,1,'Pecco',0,'1800-01-01',NULL,0),
	(183,1,'Pecetto Torinese',0,'1800-01-01',NULL,0),
	(184,1,'Perosa Argentina',0,'1800-01-01',NULL,0),
	(185,1,'Perosa Canavese',0,'1800-01-01',NULL,0),
	(186,1,'Perrero',0,'1800-01-01',NULL,0),
	(187,1,'Pertusio',0,'1800-01-01',NULL,0),
	(188,1,'Pessinetto',0,'1800-01-01',NULL,0),
	(189,1,'Pianezza',0,'1800-01-01',NULL,0),
	(190,1,'Pinasca',0,'1800-01-01',NULL,0),
	(191,1,'Pinerolo',0,'1800-01-01',NULL,0),
	(192,1,'Pino Torinese',0,'1800-01-01',NULL,0),
	(193,1,'Piobesi Torinese',0,'1800-01-01',NULL,0),
	(194,1,'Piossasco',0,'1800-01-01',NULL,0),
	(195,1,'Piscina',0,'1800-01-01',NULL,0),
	(196,1,'Piverone',0,'1800-01-01',NULL,0),
	(197,1,'Poirino',0,'1800-01-01',NULL,0),
	(198,1,'Pomaretto',0,'1800-01-01',NULL,0),
	(199,1,'Pont-Canavese',0,'1800-01-01',NULL,0),
	(200,1,'Porte',0,'1800-01-01',NULL,0),
	(201,1,'Pragelato',0,'1800-01-01',NULL,0),
	(202,1,'Prali',0,'1800-01-01',NULL,0),
	(203,1,'Pralormo',0,'1800-01-01',NULL,0),
	(204,1,'Pramollo',0,'1800-01-01',NULL,0),
	(205,1,'Prarostino',0,'1800-01-01',NULL,0),
	(206,1,'Prascorsano',0,'1800-01-01',NULL,0),
	(207,1,'Pratiglione',0,'1800-01-01',NULL,0),
	(208,1,'Quagliuzzo',0,'1800-01-01',NULL,0),
	(209,1,'Quassolo',0,'1800-01-01',NULL,0),
	(210,1,'Quincinetto',0,'1800-01-01',NULL,0),
	(211,1,'Reano',0,'1800-01-01',NULL,0),
	(212,1,'Ribordone',0,'1800-01-01',NULL,0),
	(213,1,'Rivalba',0,'1800-01-01',NULL,0),
	(214,1,'Rivalta di Torino',0,'1800-01-01',NULL,0),
	(215,1,'Riva presso Chieri',0,'1800-01-01',NULL,0),
	(216,1,'Rivara',0,'1800-01-01',NULL,0),
	(217,1,'Rivarolo Canavese',0,'1800-01-01',NULL,0),
	(218,1,'Rivarossa',0,'1800-01-01',NULL,0),
	(219,1,'Rivoli',0,'1800-01-01',NULL,0),
	(220,1,'Robassomero',0,'1800-01-01',NULL,0),
	(221,1,'Rocca Canavese',0,'1800-01-01',NULL,0),
	(222,1,'Roletto',0,'1800-01-01',NULL,0),
	(223,1,'Romano Canavese',0,'1800-01-01',NULL,0),
	(224,1,'Ronco Canavese',0,'1800-01-01',NULL,0),
	(225,1,'Rondissone',0,'1800-01-01',NULL,0),
	(226,1,'Rorà',0,'1800-01-01',NULL,0),
	(227,1,'Roure',0,'1800-01-01',NULL,0),
	(228,1,'Rosta',0,'1800-01-01',NULL,0),
	(229,1,'Rubiana',0,'1800-01-01',NULL,0),
	(230,1,'Rueglio',0,'1800-01-01',NULL,0),
	(231,1,'Salassa',0,'1800-01-01',NULL,0),
	(232,1,'Salbertrand',0,'1800-01-01',NULL,0),
	(233,1,'Salerano Canavese',0,'1800-01-01',NULL,0),
	(234,1,'Salza di Pinerolo',0,'1800-01-01',NULL,0),
	(235,1,'Samone',0,'1800-01-01',NULL,0),
	(236,1,'San Benigno Canavese',0,'1800-01-01',NULL,0),
	(237,1,'San Carlo Canavese',0,'1800-01-01',NULL,0),
	(238,1,'San Colombano Belmonte',0,'1800-01-01',NULL,0),
	(239,1,'San Didero',0,'1800-01-01',NULL,0),
	(240,1,'San Francesco al Campo',0,'1800-01-01',NULL,0),
	(241,1,'Sangano',0,'1800-01-01',NULL,0),
	(242,1,'San Germano Chisone',0,'1800-01-01',NULL,0),
	(243,1,'San Gillio',0,'1800-01-01',NULL,0),
	(244,1,'San Giorgio Canavese',0,'1800-01-01',NULL,0),
	(245,1,'San Giorio di Susa',0,'1800-01-01',NULL,0),
	(246,1,'San Giusto Canavese',0,'1800-01-01',NULL,0),
	(247,1,'San Martino Canavese',0,'1800-01-01',NULL,0),
	(248,1,'San Maurizio Canavese',0,'1800-01-01',NULL,0),
	(249,1,'San Mauro Torinese',0,'1800-01-01',NULL,0),
	(250,1,'San Pietro Val Lemina',0,'1800-01-01',NULL,0),
	(251,1,'San Ponso',0,'1800-01-01',NULL,0),
	(252,1,'San Raffaele Cimena',0,'1800-01-01',NULL,0),
	(253,1,'San Sebastiano da Po',0,'1800-01-01',NULL,0),
	(254,1,'San Secondo di Pinerolo',0,'1800-01-01',NULL,0),
	(255,1,'Sant\'Ambrogio di Torino',0,'1800-01-01',NULL,0),
	(256,1,'Sant\'Antonino di Susa',0,'1800-01-01',NULL,0),
	(257,1,'Santena',0,'1800-01-01',NULL,0),
	(258,1,'Sauze di Cesana',0,'1800-01-01',NULL,0),
	(259,1,'Sauze d\'Oulx',0,'1800-01-01',NULL,0),
	(260,1,'Scalenghe',0,'1800-01-01',NULL,0),
	(261,1,'Scarmagno',0,'1800-01-01',NULL,0),
	(262,1,'Sciolze',0,'1800-01-01',NULL,0),
	(263,1,'Sestriere',0,'1800-01-01',NULL,0),
	(264,1,'Settimo Rottaro',0,'1800-01-01',NULL,0),
	(265,1,'Settimo Torinese',0,'1800-01-01',NULL,0),
	(266,1,'Settimo Vittone',0,'1800-01-01',NULL,0),
	(267,1,'Sparone',0,'1800-01-01',NULL,0),
	(268,1,'Strambinello',0,'1800-01-01',NULL,0),
	(269,1,'Strambino',0,'1800-01-01',NULL,0),
	(270,1,'Susa',0,'1800-01-01',NULL,0),
	(271,1,'Tavagnasco',0,'1800-01-01',NULL,0),
	(272,1,'Torino',1,'1800-01-01',NULL,0),
	(273,1,'Torrazza Piemonte',0,'1800-01-01',NULL,0),
	(274,1,'Torre Canavese',0,'1800-01-01',NULL,0),
	(275,1,'Torre Pellice',0,'1800-01-01',NULL,0),
	(276,1,'Trana',0,'1800-01-01',NULL,0),
	(277,1,'Trausella',0,'1800-01-01',NULL,0),
	(278,1,'Traversella',0,'1800-01-01',NULL,0),
	(279,1,'Traves',0,'1800-01-01',NULL,0),
	(280,1,'Trofarello',0,'1800-01-01',NULL,0),
	(281,1,'Usseaux',0,'1800-01-01',NULL,0),
	(282,1,'Usseglio',0,'1800-01-01',NULL,0),
	(283,1,'Vaie',0,'1800-01-01',NULL,0),
	(284,1,'Val della Torre',0,'1800-01-01',NULL,0),
	(285,1,'Valgioie',0,'1800-01-01',NULL,0),
	(286,1,'Vallo Torinese',0,'1800-01-01',NULL,0),
	(287,1,'Valperga',0,'1800-01-01',NULL,0),
	(288,1,'Valprato Soana',0,'1800-01-01',NULL,0),
	(289,1,'Varisella',0,'1800-01-01',NULL,0),
	(290,1,'Vauda Canavese',0,'1800-01-01',NULL,0),
	(291,1,'Venaus',0,'1800-01-01',NULL,0),
	(292,1,'Venaria Reale',0,'1800-01-01',NULL,0),
	(293,1,'Verolengo',0,'1800-01-01',NULL,0),
	(294,1,'Verrua Savoia',0,'1800-01-01',NULL,0),
	(295,1,'Vestignè',0,'1800-01-01',NULL,0),
	(296,1,'Vialfrè',0,'1800-01-01',NULL,0),
	(297,1,'Vico Canavese',0,'1800-01-01',NULL,0),
	(298,1,'Vidracco',0,'1800-01-01',NULL,0),
	(299,1,'Vigone',0,'1800-01-01',NULL,0),
	(300,1,'Villafranca Piemonte',0,'1800-01-01',NULL,0),
	(301,1,'Villanova Canavese',0,'1800-01-01',NULL,0),
	(302,1,'Villarbasse',0,'1800-01-01',NULL,0),
	(303,1,'Villar Dora',0,'1800-01-01',NULL,0),
	(304,1,'Villareggia',0,'1800-01-01',NULL,0),
	(305,1,'Villar Focchiardo',0,'1800-01-01',NULL,0),
	(306,1,'Villar Pellice',0,'1800-01-01',NULL,0),
	(307,1,'Villar Perosa',0,'1800-01-01',NULL,0),
	(308,1,'Villastellone',0,'1800-01-01',NULL,0),
	(309,1,'Vinovo',0,'1800-01-01',NULL,0),
	(310,1,'Virle Piemonte',0,'1800-01-01',NULL,0),
	(311,1,'Vische',0,'1800-01-01',NULL,0),
	(312,1,'Vistrorio',0,'1800-01-01',NULL,0),
	(313,1,'Viù',0,'1800-01-01',NULL,0),
	(314,1,'Volpiano',0,'1800-01-01',NULL,0),
	(315,1,'Volvera',0,'1800-01-01',NULL,0),
	(316,2,'Alagna Valsesia',0,'1800-01-01',NULL,0),
	(317,2,'Albano Vercellese',0,'1800-01-01',NULL,0),
	(318,2,'Alice Castello',0,'1800-01-01',NULL,0),
	(319,2,'Arborio',0,'1800-01-01',NULL,0),
	(320,2,'Asigliano Vercellese',0,'1800-01-01',NULL,0),
	(321,2,'Balmuccia',0,'1800-01-01',NULL,0),
	(322,2,'Balocco',0,'1800-01-01',NULL,0),
	(323,2,'Bianzè',0,'1800-01-01',NULL,0),
	(324,2,'Boccioleto',0,'1800-01-01',NULL,0),
	(325,2,'Borgo d\'Ale',0,'1800-01-01',NULL,0),
	(326,2,'Borgosesia',0,'1800-01-01',NULL,0),
	(327,2,'Borgo Vercelli',0,'1800-01-01',NULL,0),
	(328,2,'Breia',0,'1800-01-01',NULL,0),
	(329,2,'Buronzo',0,'1800-01-01',NULL,0),
	(330,2,'Campertogno',0,'1800-01-01',NULL,0),
	(331,2,'Carcoforo',0,'1800-01-01',NULL,0),
	(332,2,'Caresana',0,'1800-01-01',NULL,0),
	(333,2,'Caresanablot',0,'1800-01-01',NULL,0),
	(334,2,'Carisio',0,'1800-01-01',NULL,0),
	(335,2,'Casanova Elvo',0,'1800-01-01',NULL,0),
	(336,2,'San Giacomo Vercellese',0,'1800-01-01',NULL,0),
	(337,2,'Cellio',0,'1800-01-01',NULL,0),
	(338,2,'Cervatto',0,'1800-01-01',NULL,0),
	(339,2,'Cigliano',0,'1800-01-01',NULL,0),
	(340,2,'Civiasco',0,'1800-01-01',NULL,0),
	(341,2,'Collobiano',0,'1800-01-01',NULL,0),
	(342,2,'Costanzana',0,'1800-01-01',NULL,0),
	(343,2,'Cravagliana',0,'1800-01-01',NULL,0),
	(344,2,'Crescentino',0,'1800-01-01',NULL,0),
	(345,2,'Crova',0,'1800-01-01',NULL,0),
	(346,2,'Desana',0,'1800-01-01',NULL,0),
	(347,2,'Fobello',0,'1800-01-01',NULL,0),
	(348,2,'Fontanetto Po',0,'1800-01-01',NULL,0),
	(349,2,'Formigliana',0,'1800-01-01',NULL,0),
	(350,2,'Gattinara',0,'1800-01-01',NULL,0),
	(351,2,'Ghislarengo',0,'1800-01-01',NULL,0),
	(352,2,'Greggio',0,'1800-01-01',NULL,0),
	(353,2,'Guardabosone',0,'1800-01-01',NULL,0),
	(354,2,'Lamporo',0,'1800-01-01',NULL,0),
	(355,2,'Lenta',0,'1800-01-01',NULL,0),
	(356,2,'Lignana',0,'1800-01-01',NULL,0),
	(357,2,'Livorno Ferraris',0,'1800-01-01',NULL,0),
	(358,2,'Lozzolo',0,'1800-01-01',NULL,0),
	(359,2,'Mollia',0,'1800-01-01',NULL,0),
	(360,2,'Moncrivello',0,'1800-01-01',NULL,0),
	(361,2,'Motta de\' Conti',0,'1800-01-01',NULL,0),
	(362,2,'Olcenengo',0,'1800-01-01',NULL,0),
	(363,2,'Oldenico',0,'1800-01-01',NULL,0),
	(364,2,'Palazzolo Vercellese',0,'1800-01-01',NULL,0),
	(365,2,'Pertengo',0,'1800-01-01',NULL,0),
	(366,2,'Pezzana',0,'1800-01-01',NULL,0),
	(367,2,'Pila',0,'1800-01-01',NULL,0),
	(368,2,'Piode',0,'1800-01-01',NULL,0),
	(369,2,'Postua',0,'1800-01-01',NULL,0),
	(370,2,'Prarolo',0,'1800-01-01',NULL,0),
	(371,2,'Quarona',0,'1800-01-01',NULL,0),
	(372,2,'Quinto Vercellese',0,'1800-01-01',NULL,0),
	(373,2,'Rassa',0,'1800-01-01',NULL,0),
	(374,2,'Rima San Giuseppe',0,'1800-01-01',NULL,0),
	(375,2,'Rimasco',0,'1800-01-01',NULL,0),
	(376,2,'Rimella',0,'1800-01-01',NULL,0),
	(377,2,'Riva Valdobbia',0,'1800-01-01',NULL,0),
	(378,2,'Rive',0,'1800-01-01',NULL,0),
	(379,2,'Roasio',0,'1800-01-01',NULL,0),
	(380,2,'Ronsecco',0,'1800-01-01',NULL,0),
	(381,2,'Rossa',0,'1800-01-01',NULL,0),
	(382,2,'Rovasenda',0,'1800-01-01',NULL,0),
	(383,2,'Sabbia',0,'1800-01-01',NULL,0),
	(384,2,'Salasco',0,'1800-01-01',NULL,0),
	(385,2,'Sali Vercellese',0,'1800-01-01',NULL,0),
	(386,2,'Saluggia',0,'1800-01-01',NULL,0),
	(387,2,'San Germano Vercellese',0,'1800-01-01',NULL,0),
	(388,2,'Santhià',0,'1800-01-01',NULL,0),
	(389,2,'Scopa',0,'1800-01-01',NULL,0),
	(390,2,'Scopello',0,'1800-01-01',NULL,0),
	(391,2,'Serravalle Sesia',0,'1800-01-01',NULL,0),
	(392,2,'Stroppiana',0,'1800-01-01',NULL,0),
	(393,2,'Tricerro',0,'1800-01-01',NULL,0),
	(394,2,'Trino',0,'1800-01-01',NULL,0),
	(395,2,'Tronzano Vercellese',0,'1800-01-01',NULL,0),
	(396,2,'Valduggia',0,'1800-01-01',NULL,0),
	(397,2,'Varallo',0,'1800-01-01',NULL,0),
	(398,2,'Vercelli',1,'1800-01-01',NULL,0),
	(399,2,'Villarboit',0,'1800-01-01',NULL,0),
	(400,2,'Villata',0,'1800-01-01',NULL,0),
	(401,2,'Vocca',0,'1800-01-01',NULL,0),
	(402,3,'Agrate Conturbia',0,'1800-01-01',NULL,0),
	(403,3,'Ameno',0,'1800-01-01',NULL,0),
	(404,3,'Armeno',0,'1800-01-01',NULL,0),
	(405,3,'Arona',0,'1800-01-01',NULL,0),
	(406,3,'Barengo',0,'1800-01-01',NULL,0),
	(407,3,'Bellinzago Novarese',0,'1800-01-01',NULL,0),
	(408,3,'Biandrate',0,'1800-01-01',NULL,0),
	(409,3,'Boca',0,'1800-01-01',NULL,0),
	(410,3,'Bogogno',0,'1800-01-01',NULL,0),
	(411,3,'Bolzano Novarese',0,'1800-01-01',NULL,0),
	(412,3,'Borgolavezzaro',0,'1800-01-01',NULL,0),
	(413,3,'Borgomanero',0,'1800-01-01',NULL,0),
	(414,3,'Borgo Ticino',0,'1800-01-01',NULL,0),
	(415,3,'Briga Novarese',0,'1800-01-01',NULL,0),
	(416,3,'Briona',0,'1800-01-01',NULL,0),
	(417,3,'Caltignaga',0,'1800-01-01',NULL,0),
	(418,3,'Cameri',0,'1800-01-01',NULL,0),
	(419,3,'Carpignano Sesia',0,'1800-01-01',NULL,0),
	(420,3,'Casalbeltrame',0,'1800-01-01',NULL,0),
	(421,3,'Casaleggio Novara',0,'1800-01-01',NULL,0),
	(422,3,'Casalino',0,'1800-01-01',NULL,0),
	(423,3,'Casalvolone',0,'1800-01-01',NULL,0),
	(424,3,'Castellazzo Novarese',0,'1800-01-01',NULL,0),
	(425,3,'Castelletto sopra Ticino',0,'1800-01-01',NULL,0),
	(426,3,'Cavaglietto',0,'1800-01-01',NULL,0),
	(427,3,'Cavaglio d\'Agogna',0,'1800-01-01',NULL,0),
	(428,3,'Cavallirio',0,'1800-01-01',NULL,0),
	(429,3,'Cerano',0,'1800-01-01',NULL,0),
	(430,3,'Colazza',0,'1800-01-01',NULL,0),
	(431,3,'Comignago',0,'1800-01-01',NULL,0),
	(432,3,'Cressa',0,'1800-01-01',NULL,0),
	(433,3,'Cureggio',0,'1800-01-01',NULL,0),
	(434,3,'Divignano',0,'1800-01-01',NULL,0),
	(435,3,'Dormelletto',0,'1800-01-01',NULL,0),
	(436,3,'Fara Novarese',0,'1800-01-01',NULL,0),
	(437,3,'Fontaneto d\'Agogna',0,'1800-01-01',NULL,0),
	(438,3,'Galliate',0,'1800-01-01',NULL,0),
	(439,3,'Garbagna Novarese',0,'1800-01-01',NULL,0),
	(440,3,'Gargallo',0,'1800-01-01',NULL,0),
	(441,3,'Gattico',0,'1800-01-01',NULL,0),
	(442,3,'Ghemme',0,'1800-01-01',NULL,0),
	(443,3,'Gozzano',0,'1800-01-01',NULL,0),
	(444,3,'Granozzo con Monticello',0,'1800-01-01',NULL,0),
	(445,3,'Grignasco',0,'1800-01-01',NULL,0),
	(446,3,'Invorio',0,'1800-01-01',NULL,0),
	(447,3,'Landiona',0,'1800-01-01',NULL,0),
	(448,3,'Lesa',0,'1800-01-01',NULL,0),
	(449,3,'Maggiora',0,'1800-01-01',NULL,0),
	(450,3,'Mandello Vitta',0,'1800-01-01',NULL,0),
	(451,3,'Marano Ticino',0,'1800-01-01',NULL,0),
	(452,3,'Massino Visconti',0,'1800-01-01',NULL,0),
	(453,3,'Meina',0,'1800-01-01',NULL,0),
	(454,3,'Mezzomerico',0,'1800-01-01',NULL,0),
	(455,3,'Miasino',0,'1800-01-01',NULL,0),
	(456,3,'Momo',0,'1800-01-01',NULL,0),
	(457,3,'Nebbiuno',0,'1800-01-01',NULL,0),
	(458,3,'Nibbiola',0,'1800-01-01',NULL,0),
	(459,3,'Novara',1,'1800-01-01',NULL,0),
	(460,3,'Oleggio',0,'1800-01-01',NULL,0),
	(461,3,'Oleggio Castello',0,'1800-01-01',NULL,0),
	(462,3,'Orta San Giulio',0,'1800-01-01',NULL,0),
	(463,3,'Paruzzaro',0,'1800-01-01',NULL,0),
	(464,3,'Pella',0,'1800-01-01',NULL,0),
	(465,3,'Pettenasco',0,'1800-01-01',NULL,0),
	(466,3,'Pisano',0,'1800-01-01',NULL,0),
	(467,3,'Pogno',0,'1800-01-01',NULL,0),
	(468,3,'Pombia',0,'1800-01-01',NULL,0),
	(469,3,'Prato Sesia',0,'1800-01-01',NULL,0),
	(470,3,'Recetto',0,'1800-01-01',NULL,0),
	(471,3,'Romagnano Sesia',0,'1800-01-01',NULL,0),
	(472,3,'Romentino',0,'1800-01-01',NULL,0),
	(473,3,'San Maurizio d\'Opaglio',0,'1800-01-01',NULL,0),
	(474,3,'San Nazzaro Sesia',0,'1800-01-01',NULL,0),
	(475,3,'San Pietro Mosezzo',0,'1800-01-01',NULL,0),
	(476,3,'Sillavengo',0,'1800-01-01',NULL,0),
	(477,3,'Sizzano',0,'1800-01-01',NULL,0),
	(478,3,'Soriso',0,'1800-01-01',NULL,0),
	(479,3,'Sozzago',0,'1800-01-01',NULL,0),
	(480,3,'Suno',0,'1800-01-01',NULL,0),
	(481,3,'Terdobbiate',0,'1800-01-01',NULL,0),
	(482,3,'Tornaco',0,'1800-01-01',NULL,0),
	(483,3,'Trecate',0,'1800-01-01',NULL,0),
	(484,3,'Vaprio d\'Agogna',0,'1800-01-01',NULL,0),
	(485,3,'Varallo Pombia',0,'1800-01-01',NULL,0),
	(486,3,'Veruno',0,'1800-01-01',NULL,0),
	(487,3,'Vespolate',0,'1800-01-01',NULL,0),
	(488,3,'Vicolungo',0,'1800-01-01',NULL,0),
	(489,3,'Vinzaglio',0,'1800-01-01',NULL,0),
	(490,4,'Acceglio',0,'1800-01-01',NULL,0),
	(491,4,'Aisone',0,'1800-01-01',NULL,0),
	(492,4,'Alba',0,'1800-01-01',NULL,0),
	(493,4,'Albaretto della Torre',0,'1800-01-01',NULL,0),
	(494,4,'Alto',0,'1800-01-01',NULL,0),
	(495,4,'Argentera',0,'1800-01-01',NULL,0),
	(496,4,'Arguello',0,'1800-01-01',NULL,0),
	(497,4,'Bagnasco',0,'1800-01-01',NULL,0),
	(498,4,'Bagnolo Piemonte',0,'1800-01-01',NULL,0),
	(499,4,'Baldissero d\'Alba',0,'1800-01-01',NULL,0),
	(500,4,'Barbaresco',0,'1800-01-01',NULL,0),
	(501,4,'Barge',0,'1800-01-01',NULL,0),
	(502,4,'Barolo',0,'1800-01-01',NULL,0),
	(503,4,'Bastia Mondovì',0,'1800-01-01',NULL,0),
	(504,4,'Battifollo',0,'1800-01-01',NULL,0),
	(505,4,'Beinette',0,'1800-01-01',NULL,0),
	(506,4,'Bellino',0,'1800-01-01',NULL,0),
	(507,4,'Belvedere Langhe',0,'1800-01-01',NULL,0),
	(508,4,'Bene Vagienna',0,'1800-01-01',NULL,0),
	(509,4,'Benevello',0,'1800-01-01',NULL,0),
	(510,4,'Bergolo',0,'1800-01-01',NULL,0),
	(511,4,'Bernezzo',0,'1800-01-01',NULL,0),
	(512,4,'Bonvicino',0,'1800-01-01',NULL,0),
	(513,4,'Borgomale',0,'1800-01-01',NULL,0),
	(514,4,'Borgo San Dalmazzo',0,'1800-01-01',NULL,0),
	(515,4,'Bosia',0,'1800-01-01',NULL,0),
	(516,4,'Bossolasco',0,'1800-01-01',NULL,0),
	(517,4,'Boves',0,'1800-01-01',NULL,0),
	(518,4,'Bra',0,'1800-01-01',NULL,0),
	(519,4,'Briaglia',0,'1800-01-01',NULL,0),
	(520,4,'Briga Alta',0,'1800-01-01',NULL,0),
	(521,4,'Brondello',0,'1800-01-01',NULL,0),
	(522,4,'Brossasco',0,'1800-01-01',NULL,0),
	(523,4,'Busca',0,'1800-01-01',NULL,0),
	(524,4,'Camerana',0,'1800-01-01',NULL,0),
	(525,4,'Camo',0,'1800-01-01',NULL,0),
	(526,4,'Canale',0,'1800-01-01',NULL,0),
	(527,4,'Canosio',0,'1800-01-01',NULL,0),
	(528,4,'Caprauna',0,'1800-01-01',NULL,0),
	(529,4,'Caraglio',0,'1800-01-01',NULL,0),
	(530,4,'Caramagna Piemonte',0,'1800-01-01',NULL,0),
	(531,4,'Cardè',0,'1800-01-01',NULL,0),
	(532,4,'Carrù',0,'1800-01-01',NULL,0),
	(533,4,'Cartignano',0,'1800-01-01',NULL,0),
	(534,4,'Casalgrasso',0,'1800-01-01',NULL,0),
	(535,4,'Castagnito',0,'1800-01-01',NULL,0),
	(536,4,'Casteldelfino',0,'1800-01-01',NULL,0),
	(537,4,'Castellar',0,'1800-01-01',NULL,0),
	(538,4,'Castelletto Stura',0,'1800-01-01',NULL,0),
	(539,4,'Castelletto Uzzone',0,'1800-01-01',NULL,0),
	(540,4,'Castellinaldo',0,'1800-01-01',NULL,0),
	(541,4,'Castellino Tanaro',0,'1800-01-01',NULL,0),
	(542,4,'Castelmagno',0,'1800-01-01',NULL,0),
	(543,4,'Castelnuovo di Ceva',0,'1800-01-01',NULL,0),
	(544,4,'Castiglione Falletto',0,'1800-01-01',NULL,0),
	(545,4,'Castiglione Tinella',0,'1800-01-01',NULL,0),
	(546,4,'Castino',0,'1800-01-01',NULL,0),
	(547,4,'Cavallerleone',0,'1800-01-01',NULL,0),
	(548,4,'Cavallermaggiore',0,'1800-01-01',NULL,0),
	(549,4,'Celle di Macra',0,'1800-01-01',NULL,0),
	(550,4,'Centallo',0,'1800-01-01',NULL,0),
	(551,4,'Ceresole Alba',0,'1800-01-01',NULL,0),
	(552,4,'Cerretto Langhe',0,'1800-01-01',NULL,0),
	(553,4,'Cervasca',0,'1800-01-01',NULL,0),
	(554,4,'Cervere',0,'1800-01-01',NULL,0),
	(555,4,'Ceva',0,'1800-01-01',NULL,0),
	(556,4,'Cherasco',0,'1800-01-01',NULL,0),
	(557,4,'Chiusa di Pesio',0,'1800-01-01',NULL,0),
	(558,4,'Cigliè',0,'1800-01-01',NULL,0),
	(559,4,'Cissone',0,'1800-01-01',NULL,0),
	(560,4,'Clavesana',0,'1800-01-01',NULL,0),
	(561,4,'Corneliano d\'Alba',0,'1800-01-01',NULL,0),
	(562,4,'Cortemilia',0,'1800-01-01',NULL,0),
	(563,4,'Cossano Belbo',0,'1800-01-01',NULL,0),
	(564,4,'Costigliole Saluzzo',0,'1800-01-01',NULL,0),
	(565,4,'Cravanzana',0,'1800-01-01',NULL,0),
	(566,4,'Crissolo',0,'1800-01-01',NULL,0),
	(567,4,'Cuneo',1,'1800-01-01',NULL,0),
	(568,4,'Demonte',0,'1800-01-01',NULL,0),
	(569,4,'Diano d\'Alba',0,'1800-01-01',NULL,0),
	(570,4,'Dogliani',0,'1800-01-01',NULL,0),
	(571,4,'Dronero',0,'1800-01-01',NULL,0),
	(572,4,'Elva',0,'1800-01-01',NULL,0),
	(573,4,'Entracque',0,'1800-01-01',NULL,0),
	(574,4,'Envie',0,'1800-01-01',NULL,0),
	(575,4,'Farigliano',0,'1800-01-01',NULL,0),
	(576,4,'Faule',0,'1800-01-01',NULL,0),
	(577,4,'Feisoglio',0,'1800-01-01',NULL,0),
	(578,4,'Fossano',0,'1800-01-01',NULL,0),
	(579,4,'Frabosa Soprana',0,'1800-01-01',NULL,0),
	(580,4,'Frabosa Sottana',0,'1800-01-01',NULL,0),
	(581,4,'Frassino',0,'1800-01-01',NULL,0),
	(582,4,'Gaiola',0,'1800-01-01',NULL,0),
	(583,4,'Gambasca',0,'1800-01-01',NULL,0),
	(584,4,'Garessio',0,'1800-01-01',NULL,0),
	(585,4,'Genola',0,'1800-01-01',NULL,0),
	(586,4,'Gorzegno',0,'1800-01-01',NULL,0),
	(587,4,'Gottasecca',0,'1800-01-01',NULL,0),
	(588,4,'Govone',0,'1800-01-01',NULL,0),
	(589,4,'Grinzane Cavour',0,'1800-01-01',NULL,0),
	(590,4,'Guarene',0,'1800-01-01',NULL,0),
	(591,4,'Igliano',0,'1800-01-01',NULL,0),
	(592,4,'Isasca',0,'1800-01-01',NULL,0),
	(593,4,'Lagnasco',0,'1800-01-01',NULL,0),
	(594,4,'La Morra',0,'1800-01-01',NULL,0),
	(595,4,'Lequio Berria',0,'1800-01-01',NULL,0),
	(596,4,'Lequio Tanaro',0,'1800-01-01',NULL,0),
	(597,4,'Lesegno',0,'1800-01-01',NULL,0),
	(598,4,'Levice',0,'1800-01-01',NULL,0),
	(599,4,'Limone Piemonte',0,'1800-01-01',NULL,0),
	(600,4,'Lisio',0,'1800-01-01',NULL,0),
	(601,4,'Macra',0,'1800-01-01',NULL,0),
	(602,4,'Magliano Alfieri',0,'1800-01-01',NULL,0),
	(603,4,'Magliano Alpi',0,'1800-01-01',NULL,0),
	(604,4,'Mango',0,'1800-01-01',NULL,0),
	(605,4,'Manta',0,'1800-01-01',NULL,0),
	(606,4,'Marene',0,'1800-01-01',NULL,0),
	(607,4,'Margarita',0,'1800-01-01',NULL,0),
	(608,4,'Marmora',0,'1800-01-01',NULL,0),
	(609,4,'Marsaglia',0,'1800-01-01',NULL,0),
	(610,4,'Martiniana Po',0,'1800-01-01',NULL,0),
	(611,4,'Melle',0,'1800-01-01',NULL,0),
	(612,4,'Moiola',0,'1800-01-01',NULL,0),
	(613,4,'Mombarcaro',0,'1800-01-01',NULL,0),
	(614,4,'Mombasiglio',0,'1800-01-01',NULL,0),
	(615,4,'Monastero di Vasco',0,'1800-01-01',NULL,0),
	(616,4,'Monasterolo Casotto',0,'1800-01-01',NULL,0),
	(617,4,'Monasterolo di Savigliano',0,'1800-01-01',NULL,0),
	(618,4,'Monchiero',0,'1800-01-01',NULL,0),
	(619,4,'Mondovì',0,'1800-01-01',NULL,0),
	(620,4,'Monesiglio',0,'1800-01-01',NULL,0),
	(621,4,'Monforte d\'Alba',0,'1800-01-01',NULL,0),
	(622,4,'Montà',0,'1800-01-01',NULL,0),
	(623,4,'Montaldo di Mondovì',0,'1800-01-01',NULL,0),
	(624,4,'Montaldo Roero',0,'1800-01-01',NULL,0),
	(625,4,'Montanera',0,'1800-01-01',NULL,0),
	(626,4,'Montelupo Albese',0,'1800-01-01',NULL,0),
	(627,4,'Montemale di Cuneo',0,'1800-01-01',NULL,0),
	(628,4,'Monterosso Grana',0,'1800-01-01',NULL,0),
	(629,4,'Monteu Roero',0,'1800-01-01',NULL,0),
	(630,4,'Montezemolo',0,'1800-01-01',NULL,0),
	(631,4,'Monticello d\'Alba',0,'1800-01-01',NULL,0),
	(632,4,'Moretta',0,'1800-01-01',NULL,0),
	(633,4,'Morozzo',0,'1800-01-01',NULL,0),
	(634,4,'Murazzano',0,'1800-01-01',NULL,0),
	(635,4,'Murello',0,'1800-01-01',NULL,0),
	(636,4,'Narzole',0,'1800-01-01',NULL,0),
	(637,4,'Neive',0,'1800-01-01',NULL,0),
	(638,4,'Neviglie',0,'1800-01-01',NULL,0),
	(639,4,'Niella Belbo',0,'1800-01-01',NULL,0),
	(640,4,'Niella Tanaro',0,'1800-01-01',NULL,0),
	(641,4,'Novello',0,'1800-01-01',NULL,0),
	(642,4,'Nucetto',0,'1800-01-01',NULL,0),
	(643,4,'Oncino',0,'1800-01-01',NULL,0),
	(644,4,'Ormea',0,'1800-01-01',NULL,0),
	(645,4,'Ostana',0,'1800-01-01',NULL,0),
	(646,4,'Paesana',0,'1800-01-01',NULL,0),
	(647,4,'Pagno',0,'1800-01-01',NULL,0),
	(648,4,'Pamparato',0,'1800-01-01',NULL,0),
	(649,4,'Paroldo',0,'1800-01-01',NULL,0),
	(650,4,'Perletto',0,'1800-01-01',NULL,0),
	(651,4,'Perlo',0,'1800-01-01',NULL,0),
	(652,4,'Peveragno',0,'1800-01-01',NULL,0),
	(653,4,'Pezzolo Valle Uzzone',0,'1800-01-01',NULL,0),
	(654,4,'Pianfei',0,'1800-01-01',NULL,0),
	(655,4,'Piasco',0,'1800-01-01',NULL,0),
	(656,4,'Pietraporzio',0,'1800-01-01',NULL,0),
	(657,4,'Piobesi d\'Alba',0,'1800-01-01',NULL,0),
	(658,4,'Piozzo',0,'1800-01-01',NULL,0),
	(659,4,'Pocapaglia',0,'1800-01-01',NULL,0),
	(660,4,'Polonghera',0,'1800-01-01',NULL,0),
	(661,4,'Pontechianale',0,'1800-01-01',NULL,0),
	(662,4,'Pradleves',0,'1800-01-01',NULL,0),
	(663,4,'Prazzo',0,'1800-01-01',NULL,0),
	(664,4,'Priero',0,'1800-01-01',NULL,0),
	(665,4,'Priocca',0,'1800-01-01',NULL,0),
	(666,4,'Priola',0,'1800-01-01',NULL,0),
	(667,4,'Prunetto',0,'1800-01-01',NULL,0),
	(668,4,'Racconigi',0,'1800-01-01',NULL,0),
	(669,4,'Revello',0,'1800-01-01',NULL,0),
	(670,4,'Rifreddo',0,'1800-01-01',NULL,0),
	(671,4,'Rittana',0,'1800-01-01',NULL,0),
	(672,4,'Roaschia',0,'1800-01-01',NULL,0),
	(673,4,'Roascio',0,'1800-01-01',NULL,0),
	(674,4,'Robilante',0,'1800-01-01',NULL,0),
	(675,4,'Roburent',0,'1800-01-01',NULL,0),
	(676,4,'Roccabruna',0,'1800-01-01',NULL,0),
	(677,4,'Rocca Cigliè',0,'1800-01-01',NULL,0),
	(678,4,'Rocca de\' Baldi',0,'1800-01-01',NULL,0),
	(679,4,'Roccaforte Mondovì',0,'1800-01-01',NULL,0),
	(680,4,'Roccasparvera',0,'1800-01-01',NULL,0),
	(681,4,'Roccavione',0,'1800-01-01',NULL,0),
	(682,4,'Rocchetta Belbo',0,'1800-01-01',NULL,0),
	(683,4,'Roddi',0,'1800-01-01',NULL,0),
	(684,4,'Roddino',0,'1800-01-01',NULL,0),
	(685,4,'Rodello',0,'1800-01-01',NULL,0),
	(686,4,'Rossana',0,'1800-01-01',NULL,0),
	(687,4,'Ruffia',0,'1800-01-01',NULL,0),
	(688,4,'Sale delle Langhe',0,'1800-01-01',NULL,0),
	(689,4,'Sale San Giovanni',0,'1800-01-01',NULL,0),
	(690,4,'Saliceto',0,'1800-01-01',NULL,0),
	(691,4,'Salmour',0,'1800-01-01',NULL,0),
	(692,4,'Saluzzo',0,'1800-01-01',NULL,0),
	(693,4,'Sambuco',0,'1800-01-01',NULL,0),
	(694,4,'Sampeyre',0,'1800-01-01',NULL,0),
	(695,4,'San Benedetto Belbo',0,'1800-01-01',NULL,0),
	(696,4,'San Damiano Macra',0,'1800-01-01',NULL,0),
	(697,4,'Sanfrè',0,'1800-01-01',NULL,0),
	(698,4,'Sanfront',0,'1800-01-01',NULL,0),
	(699,4,'San Michele Mondovì',0,'1800-01-01',NULL,0),
	(700,4,'Sant\'Albano Stura',0,'1800-01-01',NULL,0),
	(701,4,'Santa Vittoria d\'Alba',0,'1800-01-01',NULL,0),
	(702,4,'Santo Stefano Belbo',0,'1800-01-01',NULL,0),
	(703,4,'Santo Stefano Roero',0,'1800-01-01',NULL,0),
	(704,4,'Savigliano',0,'1800-01-01',NULL,0),
	(705,4,'Scagnello',0,'1800-01-01',NULL,0),
	(706,4,'Scarnafigi',0,'1800-01-01',NULL,0),
	(707,4,'Serralunga d\'Alba',0,'1800-01-01',NULL,0),
	(708,4,'Serravalle Langhe',0,'1800-01-01',NULL,0),
	(709,4,'Sinio',0,'1800-01-01',NULL,0),
	(710,4,'Somano',0,'1800-01-01',NULL,0),
	(711,4,'Sommariva del Bosco',0,'1800-01-01',NULL,0),
	(712,4,'Sommariva Perno',0,'1800-01-01',NULL,0),
	(713,4,'Stroppo',0,'1800-01-01',NULL,0),
	(714,4,'Tarantasca',0,'1800-01-01',NULL,0),
	(715,4,'Torre Bormida',0,'1800-01-01',NULL,0),
	(716,4,'Torre Mondovì',0,'1800-01-01',NULL,0),
	(717,4,'Torre San Giorgio',0,'1800-01-01',NULL,0),
	(718,4,'Torresina',0,'1800-01-01',NULL,0),
	(719,4,'Treiso',0,'1800-01-01',NULL,0),
	(720,4,'Trezzo Tinella',0,'1800-01-01',NULL,0),
	(721,4,'Trinità',0,'1800-01-01',NULL,0),
	(722,4,'Valdieri',0,'1800-01-01',NULL,0),
	(723,4,'Valgrana',0,'1800-01-01',NULL,0),
	(724,4,'Valloriate',0,'1800-01-01',NULL,0),
	(725,4,'Valmala',0,'1800-01-01',NULL,0),
	(726,4,'Venasca',0,'1800-01-01',NULL,0),
	(727,4,'Verduno',0,'1800-01-01',NULL,0),
	(728,4,'Vernante',0,'1800-01-01',NULL,0),
	(729,4,'Verzuolo',0,'1800-01-01',NULL,0),
	(730,4,'Vezza d\'Alba',0,'1800-01-01',NULL,0),
	(731,4,'Vicoforte',0,'1800-01-01',NULL,0),
	(732,4,'Vignolo',0,'1800-01-01',NULL,0),
	(733,4,'Villafalletto',0,'1800-01-01',NULL,0),
	(734,4,'Villanova Mondovì',0,'1800-01-01',NULL,0),
	(735,4,'Villanova Solaro',0,'1800-01-01',NULL,0),
	(736,4,'Villar San Costanzo',0,'1800-01-01',NULL,0),
	(737,4,'Vinadio',0,'1800-01-01',NULL,0),
	(738,4,'Viola',0,'1800-01-01',NULL,0),
	(739,4,'Vottignasco',0,'1800-01-01',NULL,0),
	(740,5,'Agliano Terme',0,'1800-01-01',NULL,0),
	(741,5,'Albugnano',0,'1800-01-01',NULL,0),
	(742,5,'Antignano',0,'1800-01-01',NULL,0),
	(743,5,'Aramengo',0,'1800-01-01',NULL,0),
	(744,5,'Asti',1,'1800-01-01',NULL,0),
	(745,5,'Azzano d\'Asti',0,'1800-01-01',NULL,0),
	(746,5,'Baldichieri d\'Asti',0,'1800-01-01',NULL,0),
	(747,5,'Belveglio',0,'1800-01-01',NULL,0),
	(748,5,'Berzano di San Pietro',0,'1800-01-01',NULL,0),
	(749,5,'Bruno',0,'1800-01-01',NULL,0),
	(750,5,'Bubbio',0,'1800-01-01',NULL,0),
	(751,5,'Buttigliera d\'Asti',0,'1800-01-01',NULL,0),
	(752,5,'Calamandrana',0,'1800-01-01',NULL,0),
	(753,5,'Calliano',0,'1800-01-01',NULL,0),
	(754,5,'Calosso',0,'1800-01-01',NULL,0),
	(755,5,'Camerano Casasco',0,'1800-01-01',NULL,0),
	(756,5,'Canelli',0,'1800-01-01',NULL,0),
	(757,5,'Cantarana',0,'1800-01-01',NULL,0),
	(758,5,'Capriglio',0,'1800-01-01',NULL,0),
	(759,5,'Casorzo',0,'1800-01-01',NULL,0),
	(760,5,'Cassinasco',0,'1800-01-01',NULL,0),
	(761,5,'Castagnole delle Lanze',0,'1800-01-01',NULL,0),
	(762,5,'Castagnole Monferrato',0,'1800-01-01',NULL,0),
	(763,5,'Castel Boglione',0,'1800-01-01',NULL,0),
	(764,5,'Castell\'Alfero',0,'1800-01-01',NULL,0),
	(765,5,'Castellero',0,'1800-01-01',NULL,0),
	(766,5,'Castelletto Molina',0,'1800-01-01',NULL,0),
	(767,5,'Castello di Annone',0,'1800-01-01',NULL,0),
	(768,5,'Castelnuovo Belbo',0,'1800-01-01',NULL,0),
	(769,5,'Castelnuovo Calcea',0,'1800-01-01',NULL,0),
	(770,5,'Castelnuovo Don Bosco',0,'1800-01-01',NULL,0),
	(771,5,'Castel Rocchero',0,'1800-01-01',NULL,0),
	(772,5,'Cellarengo',0,'1800-01-01',NULL,0),
	(773,5,'Celle Enomondo',0,'1800-01-01',NULL,0),
	(774,5,'Cerreto d\'Asti',0,'1800-01-01',NULL,0),
	(775,5,'Cerro Tanaro',0,'1800-01-01',NULL,0),
	(776,5,'Cessole',0,'1800-01-01',NULL,0),
	(777,5,'Chiusano d\'Asti',0,'1800-01-01',NULL,0),
	(778,5,'Cinaglio',0,'1800-01-01',NULL,0),
	(779,5,'Cisterna d\'Asti',0,'1800-01-01',NULL,0),
	(780,5,'Coazzolo',0,'1800-01-01',NULL,0),
	(781,5,'Cocconato',0,'1800-01-01',NULL,0),
	(782,5,'Corsione',0,'1800-01-01',NULL,0),
	(783,5,'Cortandone',0,'1800-01-01',NULL,0),
	(784,5,'Cortanze',0,'1800-01-01',NULL,0),
	(785,5,'Cortazzone',0,'1800-01-01',NULL,0),
	(786,5,'Cortiglione',0,'1800-01-01',NULL,0),
	(787,5,'Cossombrato',0,'1800-01-01',NULL,0),
	(788,5,'Costigliole d\'Asti',0,'1800-01-01',NULL,0),
	(789,5,'Cunico',0,'1800-01-01',NULL,0),
	(790,5,'Dusino San Michele',0,'1800-01-01',NULL,0),
	(791,5,'Ferrere',0,'1800-01-01',NULL,0),
	(792,5,'Fontanile',0,'1800-01-01',NULL,0),
	(793,5,'Frinco',0,'1800-01-01',NULL,0),
	(794,5,'Grana',0,'1800-01-01',NULL,0),
	(795,5,'Grazzano Badoglio',0,'1800-01-01',NULL,0),
	(796,5,'Incisa Scapaccino',0,'1800-01-01',NULL,0),
	(797,5,'Isola d\'Asti',0,'1800-01-01',NULL,0),
	(798,5,'Loazzolo',0,'1800-01-01',NULL,0),
	(799,5,'Maranzana',0,'1800-01-01',NULL,0),
	(800,5,'Maretto',0,'1800-01-01',NULL,0),
	(801,5,'Moasca',0,'1800-01-01',NULL,0),
	(802,5,'Mombaldone',0,'1800-01-01',NULL,0),
	(803,5,'Mombaruzzo',0,'1800-01-01',NULL,0),
	(804,5,'Mombercelli',0,'1800-01-01',NULL,0),
	(805,5,'Monale',0,'1800-01-01',NULL,0),
	(806,5,'Monastero Bormida',0,'1800-01-01',NULL,0),
	(807,5,'Moncalvo',0,'1800-01-01',NULL,0),
	(808,5,'Moncucco Torinese',0,'1800-01-01',NULL,0),
	(809,5,'Mongardino',0,'1800-01-01',NULL,0),
	(810,5,'Montabone',0,'1800-01-01',NULL,0),
	(811,5,'Montafia',0,'1800-01-01',NULL,0),
	(812,5,'Montaldo Scarampi',0,'1800-01-01',NULL,0),
	(813,5,'Montechiaro d\'Asti',0,'1800-01-01',NULL,0),
	(814,5,'Montegrosso d\'Asti',0,'1800-01-01',NULL,0),
	(815,5,'Montemagno',0,'1800-01-01',NULL,0),
	(816,5,'Moransengo',0,'1800-01-01',NULL,0),
	(817,5,'Nizza Monferrato',0,'1800-01-01',NULL,0),
	(818,5,'Olmo Gentile',0,'1800-01-01',NULL,0),
	(819,5,'Passerano Marmorito',0,'1800-01-01',NULL,0),
	(820,5,'Penango',0,'1800-01-01',NULL,0),
	(821,5,'Piea',0,'1800-01-01',NULL,0),
	(822,5,'Pino d\'Asti',0,'1800-01-01',NULL,0),
	(823,5,'Piovà Massaia',0,'1800-01-01',NULL,0),
	(824,5,'Portacomaro',0,'1800-01-01',NULL,0),
	(825,5,'Quaranti',0,'1800-01-01',NULL,0),
	(826,5,'Refrancore',0,'1800-01-01',NULL,0),
	(827,5,'Revigliasco d\'Asti',0,'1800-01-01',NULL,0),
	(828,5,'Roatto',0,'1800-01-01',NULL,0),
	(829,5,'Robella',0,'1800-01-01',NULL,0),
	(830,5,'Rocca d\'Arazzo',0,'1800-01-01',NULL,0),
	(831,5,'Roccaverano',0,'1800-01-01',NULL,0),
	(832,5,'Rocchetta Palafea',0,'1800-01-01',NULL,0),
	(833,5,'Rocchetta Tanaro',0,'1800-01-01',NULL,0),
	(834,5,'San Damiano d\'Asti',0,'1800-01-01',NULL,0),
	(835,5,'San Giorgio Scarampi',0,'1800-01-01',NULL,0),
	(836,5,'San Martino Alfieri',0,'1800-01-01',NULL,0),
	(837,5,'San Marzano Oliveto',0,'1800-01-01',NULL,0),
	(838,5,'San Paolo Solbrito',0,'1800-01-01',NULL,0),
	(839,5,'Scurzolengo',0,'1800-01-01',NULL,0),
	(840,5,'Serole',0,'1800-01-01',NULL,0),
	(841,5,'Sessame',0,'1800-01-01',NULL,0),
	(842,5,'Settime',0,'1800-01-01',NULL,0),
	(843,5,'Soglio',0,'1800-01-01',NULL,0),
	(844,5,'Tigliole',0,'1800-01-01',NULL,0),
	(845,5,'Tonco',0,'1800-01-01',NULL,0),
	(846,5,'Tonengo',0,'1800-01-01',NULL,0),
	(847,5,'Vaglio Serra',0,'1800-01-01',NULL,0),
	(848,5,'Valfenera',0,'1800-01-01',NULL,0),
	(849,5,'Vesime',0,'1800-01-01',NULL,0),
	(850,5,'Viale',0,'1800-01-01',NULL,0),
	(851,5,'Viarigi',0,'1800-01-01',NULL,0),
	(852,5,'Vigliano d\'Asti',0,'1800-01-01',NULL,0),
	(853,5,'Villafranca d\'Asti',0,'1800-01-01',NULL,0),
	(854,5,'Villanova d\'Asti',0,'1800-01-01',NULL,0),
	(855,5,'Villa San Secondo',0,'1800-01-01',NULL,0),
	(856,5,'Vinchio',0,'1800-01-01',NULL,0),
	(857,5,'Montiglio Monferrato',0,'1800-01-01',NULL,0),
	(858,6,'Acqui Terme',0,'1800-01-01',NULL,0),
	(859,6,'Albera Ligure',0,'1800-01-01',NULL,0),
	(860,6,'Alessandria',1,'1800-01-01',NULL,0),
	(861,6,'Alfiano Natta',0,'1800-01-01',NULL,0),
	(862,6,'Alice Bel Colle',0,'1800-01-01',NULL,0),
	(863,6,'Alluvioni Cambiò',0,'1800-01-01',NULL,0),
	(864,6,'Altavilla Monferrato',0,'1800-01-01',NULL,0),
	(865,6,'Alzano Scrivia',0,'1800-01-01',NULL,0),
	(866,6,'Arquata Scrivia',0,'1800-01-01',NULL,0),
	(867,6,'Avolasca',0,'1800-01-01',NULL,0),
	(868,6,'Balzola',0,'1800-01-01',NULL,0),
	(869,6,'Basaluzzo',0,'1800-01-01',NULL,0),
	(870,6,'Bassignana',0,'1800-01-01',NULL,0),
	(871,6,'Belforte Monferrato',0,'1800-01-01',NULL,0),
	(872,6,'Bergamasco',0,'1800-01-01',NULL,0),
	(873,6,'Berzano di Tortona',0,'1800-01-01',NULL,0),
	(874,6,'Bistagno',0,'1800-01-01',NULL,0),
	(875,6,'Borghetto di Borbera',0,'1800-01-01',NULL,0),
	(876,6,'Borgoratto Alessandrino',0,'1800-01-01',NULL,0),
	(877,6,'Borgo San Martino',0,'1800-01-01',NULL,0),
	(878,6,'Bosco Marengo',0,'1800-01-01',NULL,0),
	(879,6,'Bosio',0,'1800-01-01',NULL,0),
	(880,6,'Bozzole',0,'1800-01-01',NULL,0),
	(881,6,'Brignano-Frascata',0,'1800-01-01',NULL,0),
	(882,6,'Cabella Ligure',0,'1800-01-01',NULL,0),
	(883,6,'Camagna Monferrato',0,'1800-01-01',NULL,0),
	(884,6,'Camino',0,'1800-01-01',NULL,0),
	(885,6,'Cantalupo Ligure',0,'1800-01-01',NULL,0),
	(886,6,'Capriata d\'Orba',0,'1800-01-01',NULL,0),
	(887,6,'Carbonara Scrivia',0,'1800-01-01',NULL,0),
	(888,6,'Carentino',0,'1800-01-01',NULL,0),
	(889,6,'Carezzano',0,'1800-01-01',NULL,0),
	(890,6,'Carpeneto',0,'1800-01-01',NULL,0),
	(891,6,'Carrega Ligure',0,'1800-01-01',NULL,0),
	(892,6,'Carrosio',0,'1800-01-01',NULL,0),
	(893,6,'Cartosio',0,'1800-01-01',NULL,0),
	(894,6,'Casal Cermelli',0,'1800-01-01',NULL,0),
	(895,6,'Casaleggio Boiro',0,'1800-01-01',NULL,0),
	(896,6,'Casale Monferrato',0,'1800-01-01',NULL,0),
	(897,6,'Casalnoceto',0,'1800-01-01',NULL,0),
	(898,6,'Casasco',0,'1800-01-01',NULL,0),
	(899,6,'Cassano Spinola',0,'1800-01-01',NULL,0),
	(900,6,'Cassine',0,'1800-01-01',NULL,0),
	(901,6,'Cassinelle',0,'1800-01-01',NULL,0),
	(902,6,'Castellania',0,'1800-01-01',NULL,0),
	(903,6,'Castellar Guidobono',0,'1800-01-01',NULL,0),
	(904,6,'Castellazzo Bormida',0,'1800-01-01',NULL,0),
	(905,6,'Castelletto d\'Erro',0,'1800-01-01',NULL,0),
	(906,6,'Castelletto d\'Orba',0,'1800-01-01',NULL,0),
	(907,6,'Castelletto Merli',0,'1800-01-01',NULL,0),
	(908,6,'Castelletto Monferrato',0,'1800-01-01',NULL,0),
	(909,6,'Castelnuovo Bormida',0,'1800-01-01',NULL,0),
	(910,6,'Castelnuovo Scrivia',0,'1800-01-01',NULL,0),
	(911,6,'Castelspina',0,'1800-01-01',NULL,0),
	(912,6,'Cavatore',0,'1800-01-01',NULL,0),
	(913,6,'Cella Monte',0,'1800-01-01',NULL,0),
	(914,6,'Cereseto',0,'1800-01-01',NULL,0),
	(915,6,'Cerreto Grue',0,'1800-01-01',NULL,0),
	(916,6,'Cerrina Monferrato',0,'1800-01-01',NULL,0),
	(917,6,'Coniolo',0,'1800-01-01',NULL,0),
	(918,6,'Conzano',0,'1800-01-01',NULL,0),
	(919,6,'Costa Vescovato',0,'1800-01-01',NULL,0),
	(920,6,'Cremolino',0,'1800-01-01',NULL,0),
	(921,6,'Cuccaro Monferrato',0,'1800-01-01',NULL,0),
	(922,6,'Denice',0,'1800-01-01',NULL,0),
	(923,6,'Dernice',0,'1800-01-01',NULL,0),
	(924,6,'Fabbrica Curone',0,'1800-01-01',NULL,0),
	(925,6,'Felizzano',0,'1800-01-01',NULL,0),
	(926,6,'Fraconalto',0,'1800-01-01',NULL,0),
	(927,6,'Francavilla Bisio',0,'1800-01-01',NULL,0),
	(928,6,'Frascaro',0,'1800-01-01',NULL,0),
	(929,6,'Frassinello Monferrato',0,'1800-01-01',NULL,0),
	(930,6,'Frassineto Po',0,'1800-01-01',NULL,0),
	(931,6,'Fresonara',0,'1800-01-01',NULL,0),
	(932,6,'Frugarolo',0,'1800-01-01',NULL,0),
	(933,6,'Fubine',0,'1800-01-01',NULL,0),
	(934,6,'Gabiano',0,'1800-01-01',NULL,0),
	(935,6,'Gamalero',0,'1800-01-01',NULL,0),
	(936,6,'Garbagna',0,'1800-01-01',NULL,0),
	(937,6,'Gavazzana',0,'1800-01-01',NULL,0),
	(938,6,'Gavi',0,'1800-01-01',NULL,0),
	(939,6,'Giarole',0,'1800-01-01',NULL,0),
	(940,6,'Gremiasco',0,'1800-01-01',NULL,0),
	(941,6,'Grognardo',0,'1800-01-01',NULL,0),
	(942,6,'Grondona',0,'1800-01-01',NULL,0),
	(943,6,'Guazzora',0,'1800-01-01',NULL,0),
	(944,6,'Isola Sant\'Antonio',0,'1800-01-01',NULL,0),
	(945,6,'Lerma',0,'1800-01-01',NULL,0),
	(946,6,'Lu',0,'1800-01-01',NULL,0),
	(947,6,'Malvicino',0,'1800-01-01',NULL,0),
	(948,6,'Masio',0,'1800-01-01',NULL,0),
	(949,6,'Melazzo',0,'1800-01-01',NULL,0),
	(950,6,'Merana',0,'1800-01-01',NULL,0),
	(951,6,'Mirabello Monferrato',0,'1800-01-01',NULL,0),
	(952,6,'Molare',0,'1800-01-01',NULL,0),
	(953,6,'Molino dei Torti',0,'1800-01-01',NULL,0),
	(954,6,'Mombello Monferrato',0,'1800-01-01',NULL,0),
	(955,6,'Momperone',0,'1800-01-01',NULL,0),
	(956,6,'Moncestino',0,'1800-01-01',NULL,0),
	(957,6,'Mongiardino Ligure',0,'1800-01-01',NULL,0),
	(958,6,'Monleale',0,'1800-01-01',NULL,0),
	(959,6,'Montacuto',0,'1800-01-01',NULL,0),
	(960,6,'Montaldeo',0,'1800-01-01',NULL,0),
	(961,6,'Montaldo Bormida',0,'1800-01-01',NULL,0),
	(962,6,'Montecastello',0,'1800-01-01',NULL,0),
	(963,6,'Montechiaro d\'Acqui',0,'1800-01-01',NULL,0),
	(964,6,'Montegioco',0,'1800-01-01',NULL,0),
	(965,6,'Montemarzino',0,'1800-01-01',NULL,0),
	(966,6,'Morano sul Po',0,'1800-01-01',NULL,0),
	(967,6,'Morbello',0,'1800-01-01',NULL,0),
	(968,6,'Mornese',0,'1800-01-01',NULL,0),
	(969,6,'Morsasco',0,'1800-01-01',NULL,0),
	(970,6,'Murisengo',0,'1800-01-01',NULL,0),
	(971,6,'Novi Ligure',0,'1800-01-01',NULL,0),
	(972,6,'Occimiano',0,'1800-01-01',NULL,0),
	(973,6,'Odalengo Grande',0,'1800-01-01',NULL,0),
	(974,6,'Odalengo Piccolo',0,'1800-01-01',NULL,0),
	(975,6,'Olivola',0,'1800-01-01',NULL,0),
	(976,6,'Orsara Bormida',0,'1800-01-01',NULL,0),
	(977,6,'Ottiglio',0,'1800-01-01',NULL,0),
	(978,6,'Ovada',0,'1800-01-01',NULL,0),
	(979,6,'Oviglio',0,'1800-01-01',NULL,0),
	(980,6,'Ozzano Monferrato',0,'1800-01-01',NULL,0),
	(981,6,'Paderna',0,'1800-01-01',NULL,0),
	(982,6,'Pareto',0,'1800-01-01',NULL,0),
	(983,6,'Parodi Ligure',0,'1800-01-01',NULL,0),
	(984,6,'Pasturana',0,'1800-01-01',NULL,0),
	(985,6,'Pecetto di Valenza',0,'1800-01-01',NULL,0),
	(986,6,'Pietra Marazzi',0,'1800-01-01',NULL,0),
	(987,6,'Piovera',0,'1800-01-01',NULL,0),
	(988,6,'Pomaro Monferrato',0,'1800-01-01',NULL,0),
	(989,6,'Pontecurone',0,'1800-01-01',NULL,0),
	(990,6,'Pontestura',0,'1800-01-01',NULL,0),
	(991,6,'Ponti',0,'1800-01-01',NULL,0),
	(992,6,'Ponzano Monferrato',0,'1800-01-01',NULL,0),
	(993,6,'Ponzone',0,'1800-01-01',NULL,0),
	(994,6,'Pozzol Groppo',0,'1800-01-01',NULL,0),
	(995,6,'Pozzolo Formigaro',0,'1800-01-01',NULL,0),
	(996,6,'Prasco',0,'1800-01-01',NULL,0),
	(997,6,'Predosa',0,'1800-01-01',NULL,0),
	(998,6,'Quargnento',0,'1800-01-01',NULL,0),
	(999,6,'Quattordio',0,'1800-01-01',NULL,0),
	(1000,6,'Ricaldone',0,'1800-01-01',NULL,0),
	(1001,6,'Rivalta Bormida',0,'1800-01-01',NULL,0),
	(1002,6,'Rivarone',0,'1800-01-01',NULL,0),
	(1003,6,'Roccaforte Ligure',0,'1800-01-01',NULL,0),
	(1004,6,'Rocca Grimalda',0,'1800-01-01',NULL,0),
	(1005,6,'Rocchetta Ligure',0,'1800-01-01',NULL,0),
	(1006,6,'Rosignano Monferrato',0,'1800-01-01',NULL,0),
	(1007,6,'Sala Monferrato',0,'1800-01-01',NULL,0),
	(1008,6,'Sale',0,'1800-01-01',NULL,0),
	(1009,6,'San Cristoforo',0,'1800-01-01',NULL,0),
	(1010,6,'San Giorgio Monferrato',0,'1800-01-01',NULL,0),
	(1011,6,'San Salvatore Monferrato',0,'1800-01-01',NULL,0),
	(1012,6,'San Sebastiano Curone',0,'1800-01-01',NULL,0),
	(1013,6,'Sant\'Agata Fossili',0,'1800-01-01',NULL,0),
	(1014,6,'Sardigliano',0,'1800-01-01',NULL,0),
	(1015,6,'Sarezzano',0,'1800-01-01',NULL,0),
	(1016,6,'Serralunga di Crea',0,'1800-01-01',NULL,0),
	(1017,6,'Serravalle Scrivia',0,'1800-01-01',NULL,0),
	(1018,6,'Sezzadio',0,'1800-01-01',NULL,0),
	(1019,6,'Silvano d\'Orba',0,'1800-01-01',NULL,0),
	(1020,6,'Solero',0,'1800-01-01',NULL,0),
	(1021,6,'Solonghello',0,'1800-01-01',NULL,0),
	(1022,6,'Spigno Monferrato',0,'1800-01-01',NULL,0),
	(1023,6,'Spineto Scrivia',0,'1800-01-01',NULL,0),
	(1024,6,'Stazzano',0,'1800-01-01',NULL,0),
	(1025,6,'Strevi',0,'1800-01-01',NULL,0),
	(1026,6,'Tagliolo Monferrato',0,'1800-01-01',NULL,0),
	(1027,6,'Tassarolo',0,'1800-01-01',NULL,0),
	(1028,6,'Terruggia',0,'1800-01-01',NULL,0),
	(1029,6,'Terzo',0,'1800-01-01',NULL,0),
	(1030,6,'Ticineto',0,'1800-01-01',NULL,0),
	(1031,6,'Tortona',0,'1800-01-01',NULL,0),
	(1032,6,'Treville',0,'1800-01-01',NULL,0),
	(1033,6,'Trisobbio',0,'1800-01-01',NULL,0),
	(1034,6,'Valenza',0,'1800-01-01',NULL,0),
	(1035,6,'Valmacca',0,'1800-01-01',NULL,0),
	(1036,6,'Vignale Monferrato',0,'1800-01-01',NULL,0),
	(1037,6,'Vignole Borbera',0,'1800-01-01',NULL,0),
	(1038,6,'Viguzzolo',0,'1800-01-01',NULL,0),
	(1039,6,'Villadeati',0,'1800-01-01',NULL,0),
	(1040,6,'Villalvernia',0,'1800-01-01',NULL,0),
	(1041,6,'Villamiroglio',0,'1800-01-01',NULL,0),
	(1042,6,'Villanova Monferrato',0,'1800-01-01',NULL,0),
	(1043,6,'Villaromagnano',0,'1800-01-01',NULL,0),
	(1044,6,'Visone',0,'1800-01-01',NULL,0),
	(1045,6,'Volpedo',0,'1800-01-01',NULL,0),
	(1046,6,'Volpeglino',0,'1800-01-01',NULL,0),
	(1047,6,'Voltaggio',0,'1800-01-01',NULL,0),
	(1048,9,'Allein',0,'1800-01-01',NULL,0),
	(1049,9,'Antey-Saint-Andrè',0,'1800-01-01',NULL,0),
	(1050,9,'Aosta',1,'1800-01-01',NULL,0),
	(1051,9,'Arnad',0,'1800-01-01',NULL,0),
	(1052,9,'Arvier',0,'1800-01-01',NULL,0),
	(1053,9,'Avise',0,'1800-01-01',NULL,0),
	(1054,9,'Ayas',0,'1800-01-01',NULL,0),
	(1055,9,'Aymavilles',0,'1800-01-01',NULL,0),
	(1056,9,'Bard',0,'1800-01-01',NULL,0),
	(1057,9,'Bionaz',0,'1800-01-01',NULL,0),
	(1058,9,'Brissogne',0,'1800-01-01',NULL,0),
	(1059,9,'Brusson',0,'1800-01-01',NULL,0),
	(1060,9,'Challand-Saint-Anselme',0,'1800-01-01',NULL,0),
	(1061,9,'Challand-Saint-Victor',0,'1800-01-01',NULL,0),
	(1062,9,'Chambave',0,'1800-01-01',NULL,0),
	(1063,9,'Chamois',0,'1800-01-01',NULL,0),
	(1064,9,'Champdepraz',0,'1800-01-01',NULL,0),
	(1065,9,'Champorcher',0,'1800-01-01',NULL,0),
	(1066,9,'Charvensod',0,'1800-01-01',NULL,0),
	(1067,9,'Chatillon',0,'1800-01-01',NULL,0),
	(1068,9,'Cogne',0,'1800-01-01',NULL,0),
	(1069,9,'Courmayeur',0,'1800-01-01',NULL,0),
	(1070,9,'Donnas',0,'1800-01-01',NULL,0),
	(1071,9,'Doues',0,'1800-01-01',NULL,0),
	(1072,9,'Emarèse',0,'1800-01-01',NULL,0),
	(1073,9,'Etroubles',0,'1800-01-01',NULL,0),
	(1074,9,'Fénis',0,'1800-01-01',NULL,0),
	(1075,9,'Fontainemore',0,'1800-01-01',NULL,0),
	(1076,9,'Gaby',0,'1800-01-01',NULL,0),
	(1077,9,'Gignod',0,'1800-01-01',NULL,0),
	(1078,9,'Gressan',0,'1800-01-01',NULL,0),
	(1079,9,'Gressoney-La-Trinitè',0,'1800-01-01',NULL,0),
	(1080,9,'Gressoney-Saint-Jean',0,'1800-01-01',NULL,0),
	(1081,9,'Hone',0,'1800-01-01',NULL,0),
	(1082,9,'Introd',0,'1800-01-01',NULL,0),
	(1083,9,'Issime',0,'1800-01-01',NULL,0),
	(1084,9,'Issogne',0,'1800-01-01',NULL,0),
	(1085,9,'Jovencan',0,'1800-01-01',NULL,0),
	(1086,9,'La Magdeleine',0,'1800-01-01',NULL,0),
	(1087,9,'La Salle',0,'1800-01-01',NULL,0),
	(1088,9,'La Thuile',0,'1800-01-01',NULL,0),
	(1089,9,'Lillianes',0,'1800-01-01',NULL,0),
	(1090,9,'Montjovet',0,'1800-01-01',NULL,0),
	(1091,9,'Morgex',0,'1800-01-01',NULL,0),
	(1092,9,'Nus',0,'1800-01-01',NULL,0),
	(1093,9,'Ollomont',0,'1800-01-01',NULL,0),
	(1094,9,'Oyace',0,'1800-01-01',NULL,0),
	(1095,9,'Perloz',0,'1800-01-01',NULL,0),
	(1096,9,'Pollein',0,'1800-01-01',NULL,0),
	(1097,9,'Pontboset',0,'1800-01-01',NULL,0),
	(1098,9,'Pontey',0,'1800-01-01',NULL,0),
	(1099,9,'Pont-Saint-Martin',0,'1800-01-01',NULL,0),
	(1100,9,'Prè-Saint-Didier',0,'1800-01-01',NULL,0),
	(1101,9,'Quart',0,'1800-01-01',NULL,0),
	(1102,9,'Rhemes-Notre-Dame',0,'1800-01-01',NULL,0),
	(1103,9,'Rhemes-Saint-Georges',0,'1800-01-01',NULL,0),
	(1104,9,'Roisan',0,'1800-01-01',NULL,0),
	(1105,9,'Saint-Christophe',0,'1800-01-01',NULL,0),
	(1106,9,'Saint-Denis',0,'1800-01-01',NULL,0),
	(1107,9,'Saint-Marcel',0,'1800-01-01',NULL,0),
	(1108,9,'Saint-Nicolas',0,'1800-01-01',NULL,0),
	(1109,9,'Saint-Oyen',0,'1800-01-01',NULL,0),
	(1110,9,'Saint-Pierre',0,'1800-01-01',NULL,0),
	(1111,9,'Saint-Rhémy-en-Bosses',0,'1800-01-01',NULL,0),
	(1112,9,'Saint-Vincent',0,'1800-01-01',NULL,0),
	(1113,9,'Sarre',0,'1800-01-01',NULL,0),
	(1114,9,'Torgnon',0,'1800-01-01',NULL,0),
	(1115,9,'Valgrisenche',0,'1800-01-01',NULL,0),
	(1116,9,'Valpelline',0,'1800-01-01',NULL,0),
	(1117,9,'Valsavarenche',0,'1800-01-01',NULL,0),
	(1118,9,'Valtournenche',0,'1800-01-01',NULL,0),
	(1119,9,'Verrayes',0,'1800-01-01',NULL,0),
	(1120,9,'Verrès',0,'1800-01-01',NULL,0),
	(1121,9,'Villeneuve',0,'1800-01-01',NULL,0),
	(1122,35,'Airole',0,'1800-01-01',NULL,0),
	(1123,35,'Apricale',0,'1800-01-01',NULL,0),
	(1124,35,'Aquila d\'Arroscia',0,'1800-01-01',NULL,0),
	(1125,35,'Armo',0,'1800-01-01',NULL,0),
	(1126,35,'Aurigo',0,'1800-01-01',NULL,0),
	(1127,35,'Badalucco',0,'1800-01-01',NULL,0),
	(1128,35,'Bajardo',0,'1800-01-01',NULL,0),
	(1129,35,'Bordighera',0,'1800-01-01',NULL,0),
	(1130,35,'Borghetto d\'Arroscia',0,'1800-01-01',NULL,0),
	(1131,35,'Borgomaro',0,'1800-01-01',NULL,0),
	(1132,35,'Camporosso',0,'1800-01-01',NULL,0),
	(1133,35,'Caravonica',0,'1800-01-01',NULL,0),
	(1134,35,'Carpasio',0,'1800-01-01',NULL,0),
	(1135,35,'Castellaro',0,'1800-01-01',NULL,0),
	(1136,35,'Castel Vittorio',0,'1800-01-01',NULL,0),
	(1137,35,'Ceriana',0,'1800-01-01',NULL,0),
	(1138,35,'Cervo',0,'1800-01-01',NULL,0),
	(1139,35,'Cesio',0,'1800-01-01',NULL,0),
	(1140,35,'Chiusanico',0,'1800-01-01',NULL,0),
	(1141,35,'Chiusavecchia',0,'1800-01-01',NULL,0),
	(1142,35,'Cipressa',0,'1800-01-01',NULL,0),
	(1143,35,'Civezza',0,'1800-01-01',NULL,0),
	(1144,35,'Cosio d\'Arroscia',0,'1800-01-01',NULL,0),
	(1145,35,'Costarainera',0,'1800-01-01',NULL,0),
	(1146,35,'Diano Arentino',0,'1800-01-01',NULL,0),
	(1147,35,'Diano Castello',0,'1800-01-01',NULL,0),
	(1148,35,'Diano Marina',0,'1800-01-01',NULL,0),
	(1149,35,'Diano San Pietro',0,'1800-01-01',NULL,0),
	(1150,35,'Dolceacqua',0,'1800-01-01',NULL,0),
	(1151,35,'Dolcedo',0,'1800-01-01',NULL,0),
	(1152,35,'Imperia',1,'1800-01-01',NULL,0),
	(1153,35,'Isolabona',0,'1800-01-01',NULL,0),
	(1154,35,'Lucinasco',0,'1800-01-01',NULL,0),
	(1155,35,'Mendatica',0,'1800-01-01',NULL,0),
	(1156,35,'Molini di Triora',0,'1800-01-01',NULL,0),
	(1157,35,'Montalto Ligure',0,'1800-01-01',NULL,0),
	(1158,35,'Montegrosso Pian Latte',0,'1800-01-01',NULL,0),
	(1159,35,'Olivetta San Michele',0,'1800-01-01',NULL,0),
	(1160,35,'Ospedaletti',0,'1800-01-01',NULL,0),
	(1161,35,'Perinaldo',0,'1800-01-01',NULL,0),
	(1162,35,'Pietrabruna',0,'1800-01-01',NULL,0),
	(1163,35,'Pieve di Teco',0,'1800-01-01',NULL,0),
	(1164,35,'Pigna',0,'1800-01-01',NULL,0),
	(1165,35,'Pompeiana',0,'1800-01-01',NULL,0),
	(1166,35,'Pontedassio',0,'1800-01-01',NULL,0),
	(1167,35,'Pornassio',0,'1800-01-01',NULL,0),
	(1168,35,'Prelà',0,'1800-01-01',NULL,0),
	(1169,35,'Ranzo',0,'1800-01-01',NULL,0),
	(1170,35,'Rezzo',0,'1800-01-01',NULL,0),
	(1171,35,'Riva Ligure',0,'1800-01-01',NULL,0),
	(1172,35,'Rocchetta Nervina',0,'1800-01-01',NULL,0),
	(1173,35,'San Bartolomeo al Mare',0,'1800-01-01',NULL,0),
	(1174,35,'San Biagio della Cima',0,'1800-01-01',NULL,0),
	(1175,35,'San Lorenzo al Mare',0,'1800-01-01',NULL,0),
	(1176,35,'Sanremo',0,'1800-01-01',NULL,0),
	(1177,35,'Santo Stefano al Mare',0,'1800-01-01',NULL,0),
	(1178,35,'Seborga',0,'1800-01-01',NULL,0),
	(1179,35,'Soldano',0,'1800-01-01',NULL,0),
	(1180,35,'Taggia',0,'1800-01-01',NULL,0),
	(1181,35,'Terzorio',0,'1800-01-01',NULL,0),
	(1182,35,'Triora',0,'1800-01-01',NULL,0),
	(1183,35,'Vallebona',0,'1800-01-01',NULL,0),
	(1184,35,'Vallecrosia',0,'1800-01-01',NULL,0),
	(1185,35,'Vasia',0,'1800-01-01',NULL,0),
	(1186,35,'Ventimiglia',0,'1800-01-01',NULL,0),
	(1187,35,'Vessalico',0,'1800-01-01',NULL,0),
	(1188,35,'Villa Faraldi',0,'1800-01-01',NULL,0),
	(1189,36,'Alassio',0,'1800-01-01',NULL,0),
	(1190,36,'Albenga',0,'1800-01-01',NULL,0),
	(1191,36,'Albissola Marina',0,'1800-01-01',NULL,0),
	(1192,36,'Albisola Superiore',0,'1800-01-01',NULL,0),
	(1193,36,'Altare',0,'1800-01-01',NULL,0),
	(1194,36,'Andora',0,'1800-01-01',NULL,0),
	(1195,36,'Arnasco',0,'1800-01-01',NULL,0),
	(1196,36,'Balestrino',0,'1800-01-01',NULL,0),
	(1197,36,'Bardineto',0,'1800-01-01',NULL,0),
	(1198,36,'Bergeggi',0,'1800-01-01',NULL,0),
	(1199,36,'Boissano',0,'1800-01-01',NULL,0),
	(1200,36,'Borghetto Santo Spirito',0,'1800-01-01',NULL,0),
	(1201,36,'Borgio Verezzi',0,'1800-01-01',NULL,0),
	(1202,36,'Bormida',0,'1800-01-01',NULL,0),
	(1203,36,'Cairo Montenotte',0,'1800-01-01',NULL,0),
	(1204,36,'Calice Ligure',0,'1800-01-01',NULL,0),
	(1205,36,'Calizzano',0,'1800-01-01',NULL,0),
	(1206,36,'Carcare',0,'1800-01-01',NULL,0),
	(1207,36,'Casanova Lerrone',0,'1800-01-01',NULL,0),
	(1208,36,'Castelbianco',0,'1800-01-01',NULL,0),
	(1209,36,'Castelvecchio di Rocca Barbena',0,'1800-01-01',NULL,0),
	(1210,36,'Celle Ligure',0,'1800-01-01',NULL,0),
	(1211,36,'Cengio',0,'1800-01-01',NULL,0),
	(1212,36,'Ceriale',0,'1800-01-01',NULL,0),
	(1213,36,'Cisano sul Neva',0,'1800-01-01',NULL,0),
	(1214,36,'Cosseria',0,'1800-01-01',NULL,0),
	(1215,36,'Dego',0,'1800-01-01',NULL,0),
	(1216,36,'Erli',0,'1800-01-01',NULL,0),
	(1217,36,'Finale Ligure',0,'1800-01-01',NULL,0),
	(1218,36,'Garlenda',0,'1800-01-01',NULL,0),
	(1219,36,'Giustenice',0,'1800-01-01',NULL,0),
	(1220,36,'Giusvalla',0,'1800-01-01',NULL,0),
	(1221,36,'Laigueglia',0,'1800-01-01',NULL,0),
	(1222,36,'Loano',0,'1800-01-01',NULL,0),
	(1223,36,'Magliolo',0,'1800-01-01',NULL,0),
	(1224,36,'Mallare',0,'1800-01-01',NULL,0),
	(1225,36,'Massimino',0,'1800-01-01',NULL,0),
	(1226,36,'Millesimo',0,'1800-01-01',NULL,0),
	(1227,36,'Mioglia',0,'1800-01-01',NULL,0),
	(1228,36,'Murialdo',0,'1800-01-01',NULL,0),
	(1229,36,'Nasino',0,'1800-01-01',NULL,0),
	(1230,36,'Noli',0,'1800-01-01',NULL,0),
	(1231,36,'Onzo',0,'1800-01-01',NULL,0),
	(1232,36,'Orco Feglino',0,'1800-01-01',NULL,0),
	(1233,36,'Ortovero',0,'1800-01-01',NULL,0),
	(1234,36,'Osiglia',0,'1800-01-01',NULL,0),
	(1235,36,'Pallare',0,'1800-01-01',NULL,0),
	(1236,36,'Piana Crixia',0,'1800-01-01',NULL,0),
	(1237,36,'Pietra Ligure',0,'1800-01-01',NULL,0),
	(1238,36,'Plodio',0,'1800-01-01',NULL,0),
	(1239,36,'Pontinvrea',0,'1800-01-01',NULL,0),
	(1240,36,'Quiliano',0,'1800-01-01',NULL,0),
	(1241,36,'Rialto',0,'1800-01-01',NULL,0),
	(1242,36,'Roccavignale',0,'1800-01-01',NULL,0),
	(1243,36,'Sassello',0,'1800-01-01',NULL,0),
	(1244,36,'Savona',1,'1800-01-01',NULL,0),
	(1245,36,'Spotorno',0,'1800-01-01',NULL,0),
	(1246,36,'Stella',0,'1800-01-01',NULL,0),
	(1247,36,'Stellanello',0,'1800-01-01',NULL,0),
	(1248,36,'Testico',0,'1800-01-01',NULL,0),
	(1249,36,'Toirano',0,'1800-01-01',NULL,0),
	(1250,36,'Tovo San Giacomo',0,'1800-01-01',NULL,0),
	(1251,36,'Urbe',0,'1800-01-01',NULL,0),
	(1252,36,'Vado Ligure',0,'1800-01-01',NULL,0),
	(1253,36,'Varazze',0,'1800-01-01',NULL,0),
	(1254,36,'Vendone',0,'1800-01-01',NULL,0),
	(1255,36,'Vezzi Portio',0,'1800-01-01',NULL,0),
	(1256,36,'Villanova d\'Albenga',0,'1800-01-01',NULL,0),
	(1257,36,'Zuccarello',0,'1800-01-01',NULL,0),
	(1258,37,'Arenzano',0,'1800-01-01',NULL,0),
	(1259,37,'Avegno',0,'1800-01-01',NULL,0),
	(1260,37,'Bargagli',0,'1800-01-01',NULL,0),
	(1261,37,'Bogliasco',0,'1800-01-01',NULL,0),
	(1262,37,'Borzonasca',0,'1800-01-01',NULL,0),
	(1263,37,'Busalla',0,'1800-01-01',NULL,0),
	(1264,37,'Camogli',0,'1800-01-01',NULL,0),
	(1265,37,'Campo Ligure',0,'1800-01-01',NULL,0),
	(1266,37,'Campomorone',0,'1800-01-01',NULL,0),
	(1267,37,'Carasco',0,'1800-01-01',NULL,0),
	(1268,37,'Casarza Ligure',0,'1800-01-01',NULL,0),
	(1269,37,'Casella',0,'1800-01-01',NULL,0),
	(1270,37,'Castiglione Chiavarese',0,'1800-01-01',NULL,0),
	(1271,37,'Ceranesi',0,'1800-01-01',NULL,0),
	(1272,37,'Chiavari',0,'1800-01-01',NULL,0),
	(1273,37,'Cicagna',0,'1800-01-01',NULL,0),
	(1274,37,'Cogoleto',0,'1800-01-01',NULL,0),
	(1275,37,'Cogorno',0,'1800-01-01',NULL,0),
	(1276,37,'Coreglia Ligure',0,'1800-01-01',NULL,0),
	(1277,37,'Crocefieschi',0,'1800-01-01',NULL,0),
	(1278,37,'Davagna',0,'1800-01-01',NULL,0),
	(1279,37,'Fascia',0,'1800-01-01',NULL,0),
	(1280,37,'Favale di Malvaro',0,'1800-01-01',NULL,0),
	(1281,37,'Fontanigorda',0,'1800-01-01',NULL,0),
	(1282,37,'Genova',1,'1800-01-01',NULL,0),
	(1283,37,'Gorreto',0,'1800-01-01',NULL,0),
	(1284,37,'Isola del Cantone',0,'1800-01-01',NULL,0),
	(1285,37,'Lavagna',0,'1800-01-01',NULL,0),
	(1286,37,'Leivi',0,'1800-01-01',NULL,0),
	(1287,37,'Lorsica',0,'1800-01-01',NULL,0),
	(1288,37,'Lumarzo',0,'1800-01-01',NULL,0),
	(1289,37,'Masone',0,'1800-01-01',NULL,0),
	(1290,37,'Mele',0,'1800-01-01',NULL,0),
	(1291,37,'Mezzanego',0,'1800-01-01',NULL,0),
	(1292,37,'Mignanego',0,'1800-01-01',NULL,0),
	(1293,37,'Moconesi',0,'1800-01-01',NULL,0),
	(1294,37,'Moneglia',0,'1800-01-01',NULL,0),
	(1295,37,'Montebruno',0,'1800-01-01',NULL,0),
	(1296,37,'Montoggio',0,'1800-01-01',NULL,0),
	(1297,37,'Ne',0,'1800-01-01',NULL,0),
	(1298,37,'Neirone',0,'1800-01-01',NULL,0),
	(1299,37,'Orero',0,'1800-01-01',NULL,0),
	(1300,37,'Pieve Ligure',0,'1800-01-01',NULL,0),
	(1301,37,'Portofino',0,'1800-01-01',NULL,0),
	(1302,37,'Propata',0,'1800-01-01',NULL,0),
	(1303,37,'Rapallo',0,'1800-01-01',NULL,0),
	(1304,37,'Recco',0,'1800-01-01',NULL,0),
	(1305,37,'Rezzoaglio',0,'1800-01-01',NULL,0),
	(1306,37,'Ronco Scrivia',0,'1800-01-01',NULL,0),
	(1307,37,'Rondanina',0,'1800-01-01',NULL,0),
	(1308,37,'Rossiglione',0,'1800-01-01',NULL,0),
	(1309,37,'Rovegno',0,'1800-01-01',NULL,0),
	(1310,37,'San Colombano Certenoli',0,'1800-01-01',NULL,0),
	(1311,37,'Santa Margherita Ligure',0,'1800-01-01',NULL,0),
	(1312,37,'Sant\'Olcese',0,'1800-01-01',NULL,0),
	(1313,37,'Santo Stefano d\'Aveto',0,'1800-01-01',NULL,0),
	(1314,37,'Savignone',0,'1800-01-01',NULL,0),
	(1315,37,'Serra Riccò',0,'1800-01-01',NULL,0),
	(1316,37,'Sestri Levante',0,'1800-01-01',NULL,0),
	(1317,37,'Sori',0,'1800-01-01',NULL,0),
	(1318,37,'Tiglieto',0,'1800-01-01',NULL,0),
	(1319,37,'Torriglia',0,'1800-01-01',NULL,0),
	(1320,37,'Tribogna',0,'1800-01-01',NULL,0),
	(1321,37,'Uscio',0,'1800-01-01',NULL,0),
	(1322,37,'Valbrevenna',0,'1800-01-01',NULL,0),
	(1323,37,'Vobbia',0,'1800-01-01',NULL,0),
	(1324,37,'Zoagli',0,'1800-01-01',NULL,0),
	(1325,38,'Ameglia',0,'1800-01-01',NULL,0),
	(1326,38,'Arcola',0,'1800-01-01',NULL,0),
	(1327,38,'Beverino',0,'1800-01-01',NULL,0),
	(1328,38,'Bolano',0,'1800-01-01',NULL,0),
	(1329,38,'Bonassola',0,'1800-01-01',NULL,0),
	(1330,38,'Borghetto di Vara',0,'1800-01-01',NULL,0),
	(1331,38,'Brugnato',0,'1800-01-01',NULL,0),
	(1332,38,'Calice al Cornoviglio',0,'1800-01-01',NULL,0),
	(1333,38,'Carro',0,'1800-01-01',NULL,0),
	(1334,38,'Carrodano',0,'1800-01-01',NULL,0),
	(1335,38,'Castelnuovo Magra',0,'1800-01-01',NULL,0),
	(1336,38,'Deiva Marina',0,'1800-01-01',NULL,0),
	(1337,38,'Follo',0,'1800-01-01',NULL,0),
	(1338,38,'Framura',0,'1800-01-01',NULL,0),
	(1339,38,'La Spezia',1,'1800-01-01',NULL,0),
	(1340,38,'Lerici',0,'1800-01-01',NULL,0),
	(1341,38,'Levanto',0,'1800-01-01',NULL,0),
	(1342,38,'Maissana',0,'1800-01-01',NULL,0),
	(1343,38,'Monterosso al Mare',0,'1800-01-01',NULL,0),
	(1344,38,'Ortonovo',0,'1800-01-01',NULL,0),
	(1345,38,'Pignone',0,'1800-01-01',NULL,0),
	(1346,38,'Portovenere',0,'1800-01-01',NULL,0),
	(1347,38,'Riccò del Golfo di Spezia',0,'1800-01-01',NULL,0),
	(1348,38,'Riomaggiore',0,'1800-01-01',NULL,0),
	(1349,38,'Rocchetta di Vara',0,'1800-01-01',NULL,0),
	(1350,38,'Santo Stefano di Magra',0,'1800-01-01',NULL,0),
	(1351,38,'Sarzana',0,'1800-01-01',NULL,0),
	(1352,38,'Sesta Godano',0,'1800-01-01',NULL,0),
	(1353,38,'Varese Ligure',0,'1800-01-01',NULL,0),
	(1354,38,'Vernazza',0,'1800-01-01',NULL,0),
	(1355,38,'Vezzano Ligure',0,'1800-01-01',NULL,0),
	(1356,38,'Zignago',0,'1800-01-01',NULL,0),
	(1357,10,'Agra',0,'1800-01-01',NULL,0),
	(1358,10,'Albizzate',0,'1800-01-01',NULL,0),
	(1359,10,'Angera',0,'1800-01-01',NULL,0),
	(1360,10,'Arcisate',0,'1800-01-01',NULL,0),
	(1361,10,'Arsago Seprio',0,'1800-01-01',NULL,0),
	(1362,10,'Azzate',0,'1800-01-01',NULL,0),
	(1363,10,'Azzio',0,'1800-01-01',NULL,0),
	(1364,10,'Barasso',0,'1800-01-01',NULL,0),
	(1365,10,'Bardello',0,'1800-01-01',NULL,0),
	(1366,10,'Bedero Valcuvia',0,'1800-01-01',NULL,0),
	(1367,10,'Besano',0,'1800-01-01',NULL,0),
	(1368,10,'Besnate',0,'1800-01-01',NULL,0),
	(1369,10,'Besozzo',0,'1800-01-01',NULL,0),
	(1370,10,'Biandronno',0,'1800-01-01',NULL,0),
	(1371,10,'Bisuschio',0,'1800-01-01',NULL,0),
	(1372,10,'Bodio Lomnago',0,'1800-01-01',NULL,0),
	(1373,10,'Brebbia',0,'1800-01-01',NULL,0),
	(1374,10,'Bregano',0,'1800-01-01',NULL,0),
	(1375,10,'Brenta',0,'1800-01-01',NULL,0),
	(1376,10,'Brezzo di Bedero',0,'1800-01-01',NULL,0),
	(1377,10,'Brinzio',0,'1800-01-01',NULL,0),
	(1378,10,'Brissago-Valtravaglia',0,'1800-01-01',NULL,0),
	(1379,10,'Brunello',0,'1800-01-01',NULL,0),
	(1380,10,'Brusimpiano',0,'1800-01-01',NULL,0),
	(1381,10,'Buguggiate',0,'1800-01-01',NULL,0),
	(1382,10,'Busto Arsizio',0,'1800-01-01',NULL,0),
	(1383,10,'Cadegliano-Viconago',0,'1800-01-01',NULL,0),
	(1384,10,'Cadrezzate',0,'1800-01-01',NULL,0),
	(1385,10,'Cairate',0,'1800-01-01',NULL,0),
	(1386,10,'Cantello',0,'1800-01-01',NULL,0),
	(1387,10,'Caravate',0,'1800-01-01',NULL,0),
	(1388,10,'Cardano al Campo',0,'1800-01-01',NULL,0),
	(1389,10,'Carnago',0,'1800-01-01',NULL,0),
	(1390,10,'Caronno Pertusella',0,'1800-01-01',NULL,0),
	(1391,10,'Caronno Varesino',0,'1800-01-01',NULL,0),
	(1392,10,'Casale Litta',0,'1800-01-01',NULL,0),
	(1393,10,'Casalzuigno',0,'1800-01-01',NULL,0),
	(1394,10,'Casciago',0,'1800-01-01',NULL,0),
	(1395,10,'Casorate Sempione',0,'1800-01-01',NULL,0),
	(1396,10,'Cassano Magnago',0,'1800-01-01',NULL,0),
	(1397,10,'Cassano Valcuvia',0,'1800-01-01',NULL,0),
	(1398,10,'Castellanza',0,'1800-01-01',NULL,0),
	(1399,10,'Castello Cabiaglio',0,'1800-01-01',NULL,0),
	(1400,10,'Castelseprio',0,'1800-01-01',NULL,0),
	(1401,10,'Castelveccana',0,'1800-01-01',NULL,0),
	(1402,10,'Castiglione Olona',0,'1800-01-01',NULL,0),
	(1403,10,'Castronno',0,'1800-01-01',NULL,0),
	(1404,10,'Cavaria con Premezzo',0,'1800-01-01',NULL,0),
	(1405,10,'Cazzago Brabbia',0,'1800-01-01',NULL,0),
	(1406,10,'Cislago',0,'1800-01-01',NULL,0),
	(1407,10,'Cittiglio',0,'1800-01-01',NULL,0),
	(1408,10,'Clivio',0,'1800-01-01',NULL,0),
	(1409,10,'Cocquio-Trevisago',0,'1800-01-01',NULL,0),
	(1410,10,'Comabbio',0,'1800-01-01',NULL,0),
	(1411,10,'Comerio',0,'1800-01-01',NULL,0),
	(1412,10,'Cremenaga',0,'1800-01-01',NULL,0),
	(1413,10,'Crosio della Valle',0,'1800-01-01',NULL,0),
	(1414,10,'Cuasso al Monte',0,'1800-01-01',NULL,0),
	(1415,10,'Cugliate-Fabiasco',0,'1800-01-01',NULL,0),
	(1416,10,'Cunardo',0,'1800-01-01',NULL,0),
	(1417,10,'Curiglia con Monteviasco',0,'1800-01-01',NULL,0),
	(1418,10,'Cuveglio',0,'1800-01-01',NULL,0),
	(1419,10,'Cuvio',0,'1800-01-01',NULL,0),
	(1420,10,'Daverio',0,'1800-01-01',NULL,0),
	(1421,10,'Dumenza',0,'1800-01-01',NULL,0),
	(1422,10,'Duno',0,'1800-01-01',NULL,0),
	(1423,10,'Fagnano Olona',0,'1800-01-01',NULL,0),
	(1424,10,'Ferno',0,'1800-01-01',NULL,0),
	(1425,10,'Ferrera di Varese',0,'1800-01-01',NULL,0),
	(1426,10,'Gallarate',0,'1800-01-01',NULL,0),
	(1427,10,'Galliate Lombardo',0,'1800-01-01',NULL,0),
	(1428,10,'Gavirate',0,'1800-01-01',NULL,0),
	(1429,10,'Gazzada Schianno',0,'1800-01-01',NULL,0),
	(1430,10,'Gemonio',0,'1800-01-01',NULL,0),
	(1431,10,'Gerenzano',0,'1800-01-01',NULL,0),
	(1432,10,'Germignaga',0,'1800-01-01',NULL,0),
	(1433,10,'Golasecca',0,'1800-01-01',NULL,0),
	(1434,10,'Gorla Maggiore',0,'1800-01-01',NULL,0),
	(1435,10,'Gorla Minore',0,'1800-01-01',NULL,0),
	(1436,10,'Gornate-Olona',0,'1800-01-01',NULL,0),
	(1437,10,'Grantola',0,'1800-01-01',NULL,0),
	(1438,10,'Inarzo',0,'1800-01-01',NULL,0),
	(1439,10,'Induno Olona',0,'1800-01-01',NULL,0),
	(1440,10,'Ispra',0,'1800-01-01',NULL,0),
	(1441,10,'Jerago con Orago',0,'1800-01-01',NULL,0),
	(1442,10,'Lavena Ponte Tresa',0,'1800-01-01',NULL,0),
	(1443,10,'Laveno-Mombello',0,'1800-01-01',NULL,0),
	(1444,10,'Leggiuno',0,'1800-01-01',NULL,0),
	(1445,10,'Lonate Ceppino',0,'1800-01-01',NULL,0),
	(1446,10,'Lonate Pozzolo',0,'1800-01-01',NULL,0),
	(1447,10,'Lozza',0,'1800-01-01',NULL,0),
	(1448,10,'Luino',0,'1800-01-01',NULL,0),
	(1449,10,'Luvinate',0,'1800-01-01',NULL,0),
	(1450,10,'Maccagno',0,'1800-01-01',NULL,0),
	(1451,10,'Malgesso',0,'1800-01-01',NULL,0),
	(1452,10,'Malnate',0,'1800-01-01',NULL,0),
	(1453,10,'Marchirolo',0,'1800-01-01',NULL,0),
	(1454,10,'Marnate',0,'1800-01-01',NULL,0),
	(1455,10,'Marzio',0,'1800-01-01',NULL,0),
	(1456,10,'Masciago Primo',0,'1800-01-01',NULL,0),
	(1457,10,'Mercallo',0,'1800-01-01',NULL,0),
	(1458,10,'Mesenzana',0,'1800-01-01',NULL,0),
	(1459,10,'Montegrino Valtravaglia',0,'1800-01-01',NULL,0),
	(1460,10,'Monvalle',0,'1800-01-01',NULL,0),
	(1461,10,'Morazzone',0,'1800-01-01',NULL,0),
	(1462,10,'Mornago',0,'1800-01-01',NULL,0),
	(1463,10,'Oggiona con Santo Stefano',0,'1800-01-01',NULL,0),
	(1464,10,'Olgiate Olona',0,'1800-01-01',NULL,0),
	(1465,10,'Origgio',0,'1800-01-01',NULL,0),
	(1466,10,'Orino',0,'1800-01-01',NULL,0),
	(1467,10,'Osmate',0,'1800-01-01',NULL,0),
	(1468,10,'Pino sulla Sponda del Lago Maggiore',0,'1800-01-01',NULL,0),
	(1469,10,'Porto Ceresio',0,'1800-01-01',NULL,0),
	(1470,10,'Porto Valtravaglia',0,'1800-01-01',NULL,0),
	(1471,10,'Rancio Valcuvia',0,'1800-01-01',NULL,0),
	(1472,10,'Ranco',0,'1800-01-01',NULL,0),
	(1473,10,'Saltrio',0,'1800-01-01',NULL,0),
	(1474,10,'Samarate',0,'1800-01-01',NULL,0),
	(1475,10,'Saronno',0,'1800-01-01',NULL,0),
	(1476,10,'Sesto Calende',0,'1800-01-01',NULL,0),
	(1477,10,'Solbiate Arno',0,'1800-01-01',NULL,0),
	(1478,10,'Solbiate Olona',0,'1800-01-01',NULL,0),
	(1479,10,'Somma Lombardo',0,'1800-01-01',NULL,0),
	(1480,10,'Sumirago',0,'1800-01-01',NULL,0),
	(1481,10,'Taino',0,'1800-01-01',NULL,0),
	(1482,10,'Ternate',0,'1800-01-01',NULL,0),
	(1483,10,'Tradate',0,'1800-01-01',NULL,0),
	(1484,10,'Travedona-Monate',0,'1800-01-01',NULL,0),
	(1485,10,'Tronzano Lago Maggiore',0,'1800-01-01',NULL,0),
	(1486,10,'Uboldo',0,'1800-01-01',NULL,0),
	(1487,10,'Valganna',0,'1800-01-01',NULL,0),
	(1488,10,'Varano Borghi',0,'1800-01-01',NULL,0),
	(1489,10,'Varese',1,'1800-01-01',NULL,0),
	(1490,10,'Vedano Olona',0,'1800-01-01',NULL,0),
	(1491,10,'Veddasca',0,'1800-01-01',NULL,0),
	(1492,10,'Venegono Inferiore',0,'1800-01-01',NULL,0),
	(1493,10,'Venegono Superiore',0,'1800-01-01',NULL,0),
	(1494,10,'Vergiate',0,'1800-01-01',NULL,0),
	(1495,10,'Viggiù',0,'1800-01-01',NULL,0),
	(1496,10,'Vizzola Ticino',0,'1800-01-01',NULL,0),
	(1497,10,'Sangiano',0,'1800-01-01',NULL,0),
	(1498,11,'Albavilla',0,'1800-01-01',NULL,0),
	(1499,11,'Albese con Cassano',0,'1800-01-01',NULL,0),
	(1500,11,'Albiolo',0,'1800-01-01',NULL,0),
	(1501,11,'Alserio',0,'1800-01-01',NULL,0),
	(1502,11,'Alzate Brianza',0,'1800-01-01',NULL,0),
	(1503,11,'Anzano del Parco',0,'1800-01-01',NULL,0),
	(1504,11,'Appiano Gentile',0,'1800-01-01',NULL,0),
	(1505,11,'Argegno',0,'1800-01-01',NULL,0),
	(1506,11,'Arosio',0,'1800-01-01',NULL,0),
	(1507,11,'Asso',0,'1800-01-01',NULL,0),
	(1508,11,'Barni',0,'1800-01-01',NULL,0),
	(1509,11,'Bellagio',0,'1800-01-01',NULL,0),
	(1510,11,'Bene Lario',0,'1800-01-01',NULL,0),
	(1511,11,'Beregazzo con Figliaro',0,'1800-01-01',NULL,0),
	(1512,11,'Binago',0,'1800-01-01',NULL,0),
	(1513,11,'Bizzarone',0,'1800-01-01',NULL,0),
	(1514,11,'Blessagno',0,'1800-01-01',NULL,0),
	(1515,11,'Blevio',0,'1800-01-01',NULL,0),
	(1516,11,'Bregnano',0,'1800-01-01',NULL,0),
	(1517,11,'Brenna',0,'1800-01-01',NULL,0),
	(1518,11,'Brienno',0,'1800-01-01',NULL,0),
	(1519,11,'Brunate',0,'1800-01-01',NULL,0),
	(1520,11,'Bulgarograsso',0,'1800-01-01',NULL,0),
	(1521,11,'Cabiate',0,'1800-01-01',NULL,0),
	(1522,11,'Cadorago',0,'1800-01-01',NULL,0),
	(1523,11,'Caglio',0,'1800-01-01',NULL,0),
	(1524,11,'Cagno',0,'1800-01-01',NULL,0),
	(1525,11,'Campione d\'Italia',0,'1800-01-01',NULL,0),
	(1526,11,'Cantù',0,'1800-01-01',NULL,0),
	(1527,11,'Canzo',0,'1800-01-01',NULL,0),
	(1528,11,'Capiago Intimiano',0,'1800-01-01',NULL,0),
	(1529,11,'Carate Urio',0,'1800-01-01',NULL,0),
	(1530,11,'Carbonate',0,'1800-01-01',NULL,0),
	(1531,11,'Carimate',0,'1800-01-01',NULL,0),
	(1532,11,'Carlazzo',0,'1800-01-01',NULL,0),
	(1533,11,'Carugo',0,'1800-01-01',NULL,0),
	(1534,11,'Casasco d\'Intelvi',0,'1800-01-01',NULL,0),
	(1535,11,'Caslino d\'Erba',0,'1800-01-01',NULL,0),
	(1536,11,'Casnate con Bernate',0,'1800-01-01',NULL,0),
	(1537,11,'Cassina Rizzardi',0,'1800-01-01',NULL,0),
	(1538,11,'Castelmarte',0,'1800-01-01',NULL,0),
	(1539,11,'Castelnuovo Bozzente',0,'1800-01-01',NULL,0),
	(1540,11,'Castiglione d\'Intelvi',0,'1800-01-01',NULL,0),
	(1541,11,'Cavallasca',0,'1800-01-01',NULL,0),
	(1542,11,'Cavargna',0,'1800-01-01',NULL,0),
	(1543,11,'Cerano d\'Intelvi',0,'1800-01-01',NULL,0),
	(1544,11,'Cermenate',0,'1800-01-01',NULL,0),
	(1545,11,'Cernobbio',0,'1800-01-01',NULL,0),
	(1546,11,'Cirimido',0,'1800-01-01',NULL,0),
	(1547,11,'Civenna',0,'1800-01-01',NULL,0),
	(1548,11,'Claino con Osteno',0,'1800-01-01',NULL,0),
	(1549,11,'Colonno',0,'1800-01-01',NULL,0),
	(1550,11,'Como',1,'1800-01-01',NULL,0),
	(1551,11,'Corrido',0,'1800-01-01',NULL,0),
	(1552,11,'Cremia',0,'1800-01-01',NULL,0),
	(1553,11,'Cucciago',0,'1800-01-01',NULL,0),
	(1554,11,'Cusino',0,'1800-01-01',NULL,0),
	(1555,11,'Dizzasco',0,'1800-01-01',NULL,0),
	(1556,11,'Domaso',0,'1800-01-01',NULL,0),
	(1557,11,'Dongo',0,'1800-01-01',NULL,0),
	(1558,11,'Dosso del Liro',0,'1800-01-01',NULL,0),
	(1559,11,'Drezzo',0,'1800-01-01',NULL,0),
	(1560,11,'Erba',0,'1800-01-01',NULL,0),
	(1561,11,'Eupilio',0,'1800-01-01',NULL,0),
	(1562,11,'Faggeto Lario',0,'1800-01-01',NULL,0),
	(1563,11,'Faloppio',0,'1800-01-01',NULL,0),
	(1564,11,'Fenegrò',0,'1800-01-01',NULL,0),
	(1565,11,'Figino Serenza',0,'1800-01-01',NULL,0),
	(1566,11,'Fino Mornasco',0,'1800-01-01',NULL,0),
	(1567,11,'Garzeno',0,'1800-01-01',NULL,0),
	(1568,11,'Gera Lario',0,'1800-01-01',NULL,0),
	(1569,11,'Gironico',0,'1800-01-01',NULL,0),
	(1570,11,'Grandate',0,'1800-01-01',NULL,0),
	(1571,11,'Grandola ed Uniti',0,'1800-01-01',NULL,0),
	(1572,11,'Griante',0,'1800-01-01',NULL,0),
	(1573,11,'Guanzate',0,'1800-01-01',NULL,0),
	(1574,11,'Inverigo',0,'1800-01-01',NULL,0),
	(1575,11,'Laglio',0,'1800-01-01',NULL,0),
	(1576,11,'Laino',0,'1800-01-01',NULL,0),
	(1577,11,'Lambrugo',0,'1800-01-01',NULL,0),
	(1578,11,'Lanzo d\'Intelvi',0,'1800-01-01',NULL,0),
	(1579,11,'Lasnigo',0,'1800-01-01',NULL,0),
	(1580,11,'Lenno',0,'1800-01-01',NULL,0),
	(1581,11,'Lezzeno',0,'1800-01-01',NULL,0),
	(1582,11,'Limido Comasco',0,'1800-01-01',NULL,0),
	(1583,11,'Lipomo',0,'1800-01-01',NULL,0),
	(1584,11,'Livo',0,'1800-01-01',NULL,0),
	(1585,11,'Locate Varesino',0,'1800-01-01',NULL,0),
	(1586,11,'Lomazzo',0,'1800-01-01',NULL,0),
	(1587,11,'Longone al Segrino',0,'1800-01-01',NULL,0),
	(1588,11,'Luisago',0,'1800-01-01',NULL,0),
	(1589,11,'Lurago d\'Erba',0,'1800-01-01',NULL,0),
	(1590,11,'Lurago Marinone',0,'1800-01-01',NULL,0),
	(1591,11,'Lurate Caccivio',0,'1800-01-01',NULL,0),
	(1592,11,'Magreglio',0,'1800-01-01',NULL,0),
	(1593,11,'Mariano Comense',0,'1800-01-01',NULL,0),
	(1594,11,'Maslianico',0,'1800-01-01',NULL,0),
	(1595,11,'Menaggio',0,'1800-01-01',NULL,0),
	(1596,11,'Merone',0,'1800-01-01',NULL,0),
	(1597,11,'Mezzegra',0,'1800-01-01',NULL,0),
	(1598,11,'Moltrasio',0,'1800-01-01',NULL,0),
	(1599,11,'Monguzzo',0,'1800-01-01',NULL,0),
	(1600,11,'Montano Lucino',0,'1800-01-01',NULL,0),
	(1601,11,'Montemezzo',0,'1800-01-01',NULL,0),
	(1602,11,'Montorfano',0,'1800-01-01',NULL,0),
	(1603,11,'Mozzate',0,'1800-01-01',NULL,0),
	(1604,11,'Musso',0,'1800-01-01',NULL,0),
	(1605,11,'Nesso',0,'1800-01-01',NULL,0),
	(1606,11,'Novedrate',0,'1800-01-01',NULL,0),
	(1607,11,'Olgiate Comasco',0,'1800-01-01',NULL,0),
	(1608,11,'Oltrona di San Mamette',0,'1800-01-01',NULL,0),
	(1609,11,'Orsenigo',0,'1800-01-01',NULL,0),
	(1610,11,'Ossuccio',0,'1800-01-01',NULL,0),
	(1611,11,'Parè',0,'1800-01-01',NULL,0),
	(1612,11,'Peglio',0,'1800-01-01',NULL,0),
	(1613,11,'Pellio Intelvi',0,'1800-01-01',NULL,0),
	(1614,11,'Pianello del Lario',0,'1800-01-01',NULL,0),
	(1615,11,'Pigra',0,'1800-01-01',NULL,0),
	(1616,11,'Plesio',0,'1800-01-01',NULL,0),
	(1617,11,'Pognana Lario',0,'1800-01-01',NULL,0),
	(1618,11,'Ponna',0,'1800-01-01',NULL,0),
	(1619,11,'Ponte Lambro',0,'1800-01-01',NULL,0),
	(1620,11,'Porlezza',0,'1800-01-01',NULL,0),
	(1621,11,'Proserpio',0,'1800-01-01',NULL,0),
	(1622,11,'Pusiano',0,'1800-01-01',NULL,0),
	(1623,11,'Ramponio Verna',0,'1800-01-01',NULL,0),
	(1624,11,'Rezzago',0,'1800-01-01',NULL,0),
	(1625,11,'Rodero',0,'1800-01-01',NULL,0),
	(1626,11,'Ronago',0,'1800-01-01',NULL,0),
	(1627,11,'Rovellasca',0,'1800-01-01',NULL,0),
	(1628,11,'Rovello Porro',0,'1800-01-01',NULL,0),
	(1629,11,'Sala Comacina',0,'1800-01-01',NULL,0),
	(1630,11,'San Bartolomeo Val Cavargna',0,'1800-01-01',NULL,0),
	(1631,11,'San Fedele Intelvi',0,'1800-01-01',NULL,0),
	(1632,11,'San Fermo della Battaglia',0,'1800-01-01',NULL,0),
	(1633,11,'San Nazzaro Val Cavargna',0,'1800-01-01',NULL,0),
	(1634,11,'Schignano',0,'1800-01-01',NULL,0),
	(1635,11,'Senna Comasco',0,'1800-01-01',NULL,0),
	(1636,11,'Solbiate',0,'1800-01-01',NULL,0),
	(1637,11,'Sorico',0,'1800-01-01',NULL,0),
	(1638,11,'Sormano',0,'1800-01-01',NULL,0),
	(1639,11,'Stazzona',0,'1800-01-01',NULL,0),
	(1640,11,'Tavernerio',0,'1800-01-01',NULL,0),
	(1641,11,'Torno',0,'1800-01-01',NULL,0),
	(1642,11,'Tremezzo',0,'1800-01-01',NULL,0),
	(1643,11,'Trezzone',0,'1800-01-01',NULL,0),
	(1644,11,'Turate',0,'1800-01-01',NULL,0),
	(1645,11,'Uggiate-Trevano',0,'1800-01-01',NULL,0),
	(1646,11,'Valbrona',0,'1800-01-01',NULL,0),
	(1647,11,'Valmorea',0,'1800-01-01',NULL,0),
	(1648,11,'Val Rezzo',0,'1800-01-01',NULL,0),
	(1649,11,'Valsolda',0,'1800-01-01',NULL,0),
	(1650,11,'Veleso',0,'1800-01-01',NULL,0),
	(1651,11,'Veniano',0,'1800-01-01',NULL,0),
	(1652,11,'Vercana',0,'1800-01-01',NULL,0),
	(1653,11,'Vertemate con Minoprio',0,'1800-01-01',NULL,0),
	(1654,11,'Villa Guardia',0,'1800-01-01',NULL,0),
	(1655,11,'Zelbio',0,'1800-01-01',NULL,0),
	(1656,11,'San Siro',0,'1800-01-01',NULL,0),
	(1657,11,'Gravedona ed Uniti',0,'1800-01-01',NULL,0),
	(1658,12,'Albaredo per San Marco',0,'1800-01-01',NULL,0),
	(1659,12,'Albosaggia',0,'1800-01-01',NULL,0),
	(1660,12,'Andalo Valtellino',0,'1800-01-01',NULL,0),
	(1661,12,'Aprica',0,'1800-01-01',NULL,0),
	(1662,12,'Ardenno',0,'1800-01-01',NULL,0),
	(1663,12,'Bema',0,'1800-01-01',NULL,0),
	(1664,12,'Berbenno di Valtellina',0,'1800-01-01',NULL,0),
	(1665,12,'Bianzone',0,'1800-01-01',NULL,0),
	(1666,12,'Bormio',0,'1800-01-01',NULL,0),
	(1667,12,'Buglio in Monte',0,'1800-01-01',NULL,0),
	(1668,12,'Caiolo',0,'1800-01-01',NULL,0),
	(1669,12,'Campodolcino',0,'1800-01-01',NULL,0),
	(1670,12,'Caspoggio',0,'1800-01-01',NULL,0),
	(1671,12,'Castello dell\'Acqua',0,'1800-01-01',NULL,0),
	(1672,12,'Castione Andevenno',0,'1800-01-01',NULL,0),
	(1673,12,'Cedrasco',0,'1800-01-01',NULL,0),
	(1674,12,'Cercino',0,'1800-01-01',NULL,0),
	(1675,12,'Chiavenna',0,'1800-01-01',NULL,0),
	(1676,12,'Chiesa in Valmalenco',0,'1800-01-01',NULL,0),
	(1677,12,'Chiuro',0,'1800-01-01',NULL,0),
	(1678,12,'Cino',0,'1800-01-01',NULL,0),
	(1679,12,'Civo',0,'1800-01-01',NULL,0),
	(1680,12,'Colorina',0,'1800-01-01',NULL,0),
	(1681,12,'Cosio Valtellino',0,'1800-01-01',NULL,0),
	(1682,12,'Dazio',0,'1800-01-01',NULL,0),
	(1683,12,'Delebio',0,'1800-01-01',NULL,0),
	(1684,12,'Dubino',0,'1800-01-01',NULL,0),
	(1685,12,'Faedo Valtellino',0,'1800-01-01',NULL,0),
	(1686,12,'Forcola',0,'1800-01-01',NULL,0),
	(1687,12,'Fusine',0,'1800-01-01',NULL,0),
	(1688,12,'Gerola Alta',0,'1800-01-01',NULL,0),
	(1689,12,'Gordona',0,'1800-01-01',NULL,0),
	(1690,12,'Grosio',0,'1800-01-01',NULL,0),
	(1691,12,'Grosotto',0,'1800-01-01',NULL,0),
	(1692,12,'Madesimo',0,'1800-01-01',NULL,0),
	(1693,12,'Lanzada',0,'1800-01-01',NULL,0),
	(1694,12,'Livigno',0,'1800-01-01',NULL,0),
	(1695,12,'Lovero',0,'1800-01-01',NULL,0),
	(1696,12,'Mantello',0,'1800-01-01',NULL,0),
	(1697,12,'Mazzo di Valtellina',0,'1800-01-01',NULL,0),
	(1698,12,'Mello',0,'1800-01-01',NULL,0),
	(1699,12,'Menarola',0,'1800-01-01',NULL,0),
	(1700,12,'Mese',0,'1800-01-01',NULL,0),
	(1701,12,'Montagna in Valtellina',0,'1800-01-01',NULL,0),
	(1702,12,'Morbegno',0,'1800-01-01',NULL,0),
	(1703,12,'Novate Mezzola',0,'1800-01-01',NULL,0),
	(1704,12,'Pedesina',0,'1800-01-01',NULL,0),
	(1705,12,'Piantedo',0,'1800-01-01',NULL,0),
	(1706,12,'Piateda',0,'1800-01-01',NULL,0),
	(1707,12,'Piuro',0,'1800-01-01',NULL,0),
	(1708,12,'Poggiridenti',0,'1800-01-01',NULL,0),
	(1709,12,'Ponte in Valtellina',0,'1800-01-01',NULL,0),
	(1710,12,'Postalesio',0,'1800-01-01',NULL,0),
	(1711,12,'Prata Camportaccio',0,'1800-01-01',NULL,0),
	(1712,12,'Rasura',0,'1800-01-01',NULL,0),
	(1713,12,'Rogolo',0,'1800-01-01',NULL,0),
	(1714,12,'Samolaco',0,'1800-01-01',NULL,0),
	(1715,12,'San Giacomo Filippo',0,'1800-01-01',NULL,0),
	(1716,12,'Sernio',0,'1800-01-01',NULL,0),
	(1717,12,'Sondalo',0,'1800-01-01',NULL,0),
	(1718,12,'Sondrio',1,'1800-01-01',NULL,0),
	(1719,12,'Spriana',0,'1800-01-01',NULL,0),
	(1720,12,'Talamona',0,'1800-01-01',NULL,0),
	(1721,12,'Tartano',0,'1800-01-01',NULL,0),
	(1722,12,'Teglio',0,'1800-01-01',NULL,0),
	(1723,12,'Tirano',0,'1800-01-01',NULL,0),
	(1724,12,'Torre di Santa Maria',0,'1800-01-01',NULL,0),
	(1725,12,'Tovo di Sant\'Agata',0,'1800-01-01',NULL,0),
	(1726,12,'Traona',0,'1800-01-01',NULL,0),
	(1727,12,'Tresivio',0,'1800-01-01',NULL,0),
	(1728,12,'Valdidentro',0,'1800-01-01',NULL,0),
	(1729,12,'Valdisotto',0,'1800-01-01',NULL,0),
	(1730,12,'Valfurva',0,'1800-01-01',NULL,0),
	(1731,12,'Val Masino',0,'1800-01-01',NULL,0),
	(1732,12,'Verceia',0,'1800-01-01',NULL,0),
	(1733,12,'Vervio',0,'1800-01-01',NULL,0),
	(1734,12,'Villa di Chiavenna',0,'1800-01-01',NULL,0),
	(1735,12,'Villa di Tirano',0,'1800-01-01',NULL,0),
	(1736,13,'Abbiategrasso',0,'1800-01-01',NULL,0),
	(1737,13,'Albairate',0,'1800-01-01',NULL,0),
	(1738,13,'Arconate',0,'1800-01-01',NULL,0),
	(1739,13,'Arese',0,'1800-01-01',NULL,0),
	(1740,13,'Arluno',0,'1800-01-01',NULL,0),
	(1741,13,'Assago',0,'1800-01-01',NULL,0),
	(1742,13,'Bareggio',0,'1800-01-01',NULL,0),
	(1743,13,'Basiano',0,'1800-01-01',NULL,0),
	(1744,13,'Basiglio',0,'1800-01-01',NULL,0),
	(1745,13,'Bellinzago Lombardo',0,'1800-01-01',NULL,0),
	(1746,13,'Bernate Ticino',0,'1800-01-01',NULL,0),
	(1747,13,'Besate',0,'1800-01-01',NULL,0),
	(1748,13,'Binasco',0,'1800-01-01',NULL,0),
	(1749,13,'Boffalora sopra Ticino',0,'1800-01-01',NULL,0),
	(1750,13,'Bollate',0,'1800-01-01',NULL,0),
	(1751,13,'Bresso',0,'1800-01-01',NULL,0),
	(1752,13,'Bubbiano',0,'1800-01-01',NULL,0),
	(1753,13,'Buccinasco',0,'1800-01-01',NULL,0),
	(1754,13,'Buscate',0,'1800-01-01',NULL,0),
	(1755,13,'Bussero',0,'1800-01-01',NULL,0),
	(1756,13,'Busto Garolfo',0,'1800-01-01',NULL,0),
	(1757,13,'Calvignasco',0,'1800-01-01',NULL,0),
	(1758,13,'Cambiago',0,'1800-01-01',NULL,0),
	(1759,13,'Canegrate',0,'1800-01-01',NULL,0),
	(1760,13,'Carpiano',0,'1800-01-01',NULL,0),
	(1761,13,'Carugate',0,'1800-01-01',NULL,0),
	(1762,13,'Casarile',0,'1800-01-01',NULL,0),
	(1763,13,'Casorezzo',0,'1800-01-01',NULL,0),
	(1764,13,'Cassano d\'Adda',0,'1800-01-01',NULL,0),
	(1765,13,'Cassina de\' Pecchi',0,'1800-01-01',NULL,0),
	(1766,13,'Cassinetta di Lugagnano',0,'1800-01-01',NULL,0),
	(1767,13,'Castano Primo',0,'1800-01-01',NULL,0),
	(1768,13,'Cernusco sul Naviglio',0,'1800-01-01',NULL,0),
	(1769,13,'Cerro al Lambro',0,'1800-01-01',NULL,0),
	(1770,13,'Cerro Maggiore',0,'1800-01-01',NULL,0),
	(1771,13,'Cesano Boscone',0,'1800-01-01',NULL,0),
	(1772,13,'Cesate',0,'1800-01-01',NULL,0),
	(1773,13,'Cinisello Balsamo',0,'1800-01-01',NULL,0),
	(1774,13,'Cisliano',0,'1800-01-01',NULL,0),
	(1775,13,'Cologno Monzese',0,'1800-01-01',NULL,0),
	(1776,13,'Colturano',0,'1800-01-01',NULL,0),
	(1777,13,'Corbetta',0,'1800-01-01',NULL,0),
	(1778,13,'Cormano',0,'1800-01-01',NULL,0),
	(1779,13,'Cornaredo',0,'1800-01-01',NULL,0),
	(1780,13,'Corsico',0,'1800-01-01',NULL,0),
	(1781,13,'Cuggiono',0,'1800-01-01',NULL,0),
	(1782,13,'Cusago',0,'1800-01-01',NULL,0),
	(1783,13,'Cusano Milanino',0,'1800-01-01',NULL,0),
	(1784,13,'Dairago',0,'1800-01-01',NULL,0),
	(1785,13,'Dresano',0,'1800-01-01',NULL,0),
	(1786,13,'Gaggiano',0,'1800-01-01',NULL,0),
	(1787,13,'Garbagnate Milanese',0,'1800-01-01',NULL,0),
	(1788,13,'Gessate',0,'1800-01-01',NULL,0),
	(1789,13,'Gorgonzola',0,'1800-01-01',NULL,0),
	(1790,13,'Grezzago',0,'1800-01-01',NULL,0),
	(1791,13,'Gudo Visconti',0,'1800-01-01',NULL,0),
	(1792,13,'Inveruno',0,'1800-01-01',NULL,0),
	(1793,13,'Inzago',0,'1800-01-01',NULL,0),
	(1794,13,'Lacchiarella',0,'1800-01-01',NULL,0),
	(1795,13,'Lainate',0,'1800-01-01',NULL,0),
	(1796,13,'Legnano',0,'1800-01-01',NULL,0),
	(1797,13,'Liscate',0,'1800-01-01',NULL,0),
	(1798,13,'Locate di Triulzi',0,'1800-01-01',NULL,0),
	(1799,13,'Magenta',0,'1800-01-01',NULL,0),
	(1800,13,'Magnago',0,'1800-01-01',NULL,0),
	(1801,13,'Marcallo con Casone',0,'1800-01-01',NULL,0),
	(1802,13,'Masate',0,'1800-01-01',NULL,0),
	(1803,13,'Mediglia',0,'1800-01-01',NULL,0),
	(1804,13,'Melegnano',0,'1800-01-01',NULL,0),
	(1805,13,'Melzo',0,'1800-01-01',NULL,0),
	(1806,13,'Mesero',0,'1800-01-01',NULL,0),
	(1807,13,'Milano',1,'1800-01-01',NULL,0),
	(1808,13,'Morimondo',0,'1800-01-01',NULL,0),
	(1809,13,'Motta Visconti',0,'1800-01-01',NULL,0),
	(1810,13,'Nerviano',0,'1800-01-01',NULL,0),
	(1811,13,'Nosate',0,'1800-01-01',NULL,0),
	(1812,13,'Novate Milanese',0,'1800-01-01',NULL,0),
	(1813,13,'Noviglio',0,'1800-01-01',NULL,0),
	(1814,13,'Opera',0,'1800-01-01',NULL,0),
	(1815,13,'Ossona',0,'1800-01-01',NULL,0),
	(1816,13,'Ozzero',0,'1800-01-01',NULL,0),
	(1817,13,'Paderno Dugnano',0,'1800-01-01',NULL,0),
	(1818,13,'Pantigliate',0,'1800-01-01',NULL,0),
	(1819,13,'Parabiago',0,'1800-01-01',NULL,0),
	(1820,13,'Paullo',0,'1800-01-01',NULL,0),
	(1821,13,'Pero',0,'1800-01-01',NULL,0),
	(1822,13,'Peschiera Borromeo',0,'1800-01-01',NULL,0),
	(1823,13,'Pessano con Bornago',0,'1800-01-01',NULL,0),
	(1824,13,'Pieve Emanuele',0,'1800-01-01',NULL,0),
	(1825,13,'Pioltello',0,'1800-01-01',NULL,0),
	(1826,13,'Pogliano Milanese',0,'1800-01-01',NULL,0),
	(1827,13,'Pozzo d\'Adda',0,'1800-01-01',NULL,0),
	(1828,13,'Pozzuolo Martesana',0,'1800-01-01',NULL,0),
	(1829,13,'Pregnana Milanese',0,'1800-01-01',NULL,0),
	(1830,13,'Rescaldina',0,'1800-01-01',NULL,0),
	(1831,13,'Rho',0,'1800-01-01',NULL,0),
	(1832,13,'Robecchetto con Induno',0,'1800-01-01',NULL,0),
	(1833,13,'Robecco sul Naviglio',0,'1800-01-01',NULL,0),
	(1834,13,'Rodano',0,'1800-01-01',NULL,0),
	(1835,13,'Rosate',0,'1800-01-01',NULL,0),
	(1836,13,'Rozzano',0,'1800-01-01',NULL,0),
	(1837,13,'San Colombano al Lambro',0,'1800-01-01',NULL,0),
	(1838,13,'San Donato Milanese',0,'1800-01-01',NULL,0),
	(1839,13,'San Giorgio su Legnano',0,'1800-01-01',NULL,0),
	(1840,13,'San Giuliano Milanese',0,'1800-01-01',NULL,0),
	(1841,13,'Santo Stefano Ticino',0,'1800-01-01',NULL,0),
	(1842,13,'San Vittore Olona',0,'1800-01-01',NULL,0),
	(1843,13,'San Zenone al Lambro',0,'1800-01-01',NULL,0),
	(1844,13,'Sedriano',0,'1800-01-01',NULL,0),
	(1845,13,'Segrate',0,'1800-01-01',NULL,0),
	(1846,13,'Senago',0,'1800-01-01',NULL,0),
	(1847,13,'Sesto San Giovanni',0,'1800-01-01',NULL,0),
	(1848,13,'Settala',0,'1800-01-01',NULL,0),
	(1849,13,'Settimo Milanese',0,'1800-01-01',NULL,0),
	(1850,13,'Solaro',0,'1800-01-01',NULL,0),
	(1851,13,'Trezzano Rosa',0,'1800-01-01',NULL,0),
	(1852,13,'Trezzano sul Naviglio',0,'1800-01-01',NULL,0),
	(1853,13,'Trezzo sull\'Adda',0,'1800-01-01',NULL,0),
	(1854,13,'Tribiano',0,'1800-01-01',NULL,0),
	(1855,13,'Truccazzano',0,'1800-01-01',NULL,0),
	(1856,13,'Turbigo',0,'1800-01-01',NULL,0),
	(1857,13,'Vanzago',0,'1800-01-01',NULL,0),
	(1858,13,'Vaprio d\'Adda',0,'1800-01-01',NULL,0),
	(1859,13,'Vermezzo',0,'1800-01-01',NULL,0),
	(1860,13,'Vernate',0,'1800-01-01',NULL,0),
	(1861,13,'Vignate',0,'1800-01-01',NULL,0),
	(1862,13,'Vimodrone',0,'1800-01-01',NULL,0),
	(1863,13,'Vittuone',0,'1800-01-01',NULL,0),
	(1864,13,'Vizzolo Predabissi',0,'1800-01-01',NULL,0),
	(1865,13,'Zelo Surrigone',0,'1800-01-01',NULL,0),
	(1866,13,'Zibido San Giacomo',0,'1800-01-01',NULL,0),
	(1867,13,'Villa Cortese',0,'1800-01-01',NULL,0),
	(1868,13,'Vanzaghello',0,'1800-01-01',NULL,0),
	(1869,13,'Baranzate',0,'1800-01-01',NULL,0),
	(1870,14,'Adrara San Martino',0,'1800-01-01',NULL,0),
	(1871,14,'Adrara San Rocco',0,'1800-01-01',NULL,0),
	(1872,14,'Albano Sant\'Alessandro',0,'1800-01-01',NULL,0),
	(1873,14,'Albino',0,'1800-01-01',NULL,0),
	(1874,14,'Almè',0,'1800-01-01',NULL,0),
	(1875,14,'Almenno San Bartolomeo',0,'1800-01-01',NULL,0),
	(1876,14,'Almenno San Salvatore',0,'1800-01-01',NULL,0),
	(1877,14,'Alzano Lombardo',0,'1800-01-01',NULL,0),
	(1878,14,'Ambivere',0,'1800-01-01',NULL,0),
	(1879,14,'Antegnate',0,'1800-01-01',NULL,0),
	(1880,14,'Arcene',0,'1800-01-01',NULL,0),
	(1881,14,'Ardesio',0,'1800-01-01',NULL,0),
	(1882,14,'Arzago d\'Adda',0,'1800-01-01',NULL,0),
	(1883,14,'Averara',0,'1800-01-01',NULL,0),
	(1884,14,'Aviatico',0,'1800-01-01',NULL,0),
	(1885,14,'Azzano San Paolo',0,'1800-01-01',NULL,0),
	(1886,14,'Azzone',0,'1800-01-01',NULL,0),
	(1887,14,'Bagnatica',0,'1800-01-01',NULL,0),
	(1888,14,'Barbata',0,'1800-01-01',NULL,0),
	(1889,14,'Bariano',0,'1800-01-01',NULL,0),
	(1890,14,'Barzana',0,'1800-01-01',NULL,0),
	(1891,14,'Bedulita',0,'1800-01-01',NULL,0),
	(1892,14,'Berbenno',0,'1800-01-01',NULL,0),
	(1893,14,'Bergamo',1,'1800-01-01',NULL,0),
	(1894,14,'Berzo San Fermo',0,'1800-01-01',NULL,0),
	(1895,14,'Bianzano',0,'1800-01-01',NULL,0),
	(1896,14,'Blello',0,'1800-01-01',NULL,0),
	(1897,14,'Bolgare',0,'1800-01-01',NULL,0),
	(1898,14,'Boltiere',0,'1800-01-01',NULL,0),
	(1899,14,'Bonate Sopra',0,'1800-01-01',NULL,0),
	(1900,14,'Bonate Sotto',0,'1800-01-01',NULL,0),
	(1901,14,'Borgo di Terzo',0,'1800-01-01',NULL,0),
	(1902,14,'Bossico',0,'1800-01-01',NULL,0),
	(1903,14,'Bottanuco',0,'1800-01-01',NULL,0),
	(1904,14,'Bracca',0,'1800-01-01',NULL,0),
	(1905,14,'Branzi',0,'1800-01-01',NULL,0),
	(1906,14,'Brembate',0,'1800-01-01',NULL,0),
	(1907,14,'Brembate di Sopra',0,'1800-01-01',NULL,0),
	(1908,14,'Brembilla',0,'1800-01-01',NULL,0),
	(1909,14,'Brignano Gera d\'Adda',0,'1800-01-01',NULL,0),
	(1910,14,'Brumano',0,'1800-01-01',NULL,0),
	(1911,14,'Brusaporto',0,'1800-01-01',NULL,0),
	(1912,14,'Calcinate',0,'1800-01-01',NULL,0),
	(1913,14,'Calcio',0,'1800-01-01',NULL,0),
	(1914,14,'Calusco d\'Adda',0,'1800-01-01',NULL,0),
	(1915,14,'Calvenzano',0,'1800-01-01',NULL,0),
	(1916,14,'Camerata Cornello',0,'1800-01-01',NULL,0),
	(1917,14,'Canonica d\'Adda',0,'1800-01-01',NULL,0),
	(1918,14,'Capizzone',0,'1800-01-01',NULL,0),
	(1919,14,'Capriate San Gervasio',0,'1800-01-01',NULL,0),
	(1920,14,'Caprino Bergamasco',0,'1800-01-01',NULL,0),
	(1921,14,'Caravaggio',0,'1800-01-01',NULL,0),
	(1922,14,'Carobbio degli Angeli',0,'1800-01-01',NULL,0),
	(1923,14,'Carona',0,'1800-01-01',NULL,0),
	(1924,14,'Carvico',0,'1800-01-01',NULL,0),
	(1925,14,'Casazza',0,'1800-01-01',NULL,0),
	(1926,14,'Casirate d\'Adda',0,'1800-01-01',NULL,0),
	(1927,14,'Casnigo',0,'1800-01-01',NULL,0),
	(1928,14,'Cassiglio',0,'1800-01-01',NULL,0),
	(1929,14,'Castelli Calepio',0,'1800-01-01',NULL,0),
	(1930,14,'Castel Rozzone',0,'1800-01-01',NULL,0),
	(1931,14,'Castione della Presolana',0,'1800-01-01',NULL,0),
	(1932,14,'Castro',0,'1800-01-01',NULL,0),
	(1933,14,'Cavernago',0,'1800-01-01',NULL,0),
	(1934,14,'Cazzano Sant\'Andrea',0,'1800-01-01',NULL,0),
	(1935,14,'Cenate Sopra',0,'1800-01-01',NULL,0),
	(1936,14,'Cenate Sotto',0,'1800-01-01',NULL,0),
	(1937,14,'Cene',0,'1800-01-01',NULL,0),
	(1938,14,'Cerete',0,'1800-01-01',NULL,0),
	(1939,14,'Chignolo d\'Isola',0,'1800-01-01',NULL,0),
	(1940,14,'Chiuduno',0,'1800-01-01',NULL,0),
	(1941,14,'Cisano Bergamasco',0,'1800-01-01',NULL,0),
	(1942,14,'Ciserano',0,'1800-01-01',NULL,0),
	(1943,14,'Cividate al Piano',0,'1800-01-01',NULL,0),
	(1944,14,'Clusone',0,'1800-01-01',NULL,0),
	(1945,14,'Colere',0,'1800-01-01',NULL,0),
	(1946,14,'Cologno al Serio',0,'1800-01-01',NULL,0),
	(1947,14,'Colzate',0,'1800-01-01',NULL,0),
	(1948,14,'Comun Nuovo',0,'1800-01-01',NULL,0),
	(1949,14,'Corna Imagna',0,'1800-01-01',NULL,0),
	(1950,14,'Cortenuova',0,'1800-01-01',NULL,0),
	(1951,14,'Costa di Mezzate',0,'1800-01-01',NULL,0),
	(1952,14,'Costa Valle Imagna',0,'1800-01-01',NULL,0),
	(1953,14,'Costa Volpino',0,'1800-01-01',NULL,0),
	(1954,14,'Covo',0,'1800-01-01',NULL,0),
	(1955,14,'Credaro',0,'1800-01-01',NULL,0),
	(1956,14,'Curno',0,'1800-01-01',NULL,0),
	(1957,14,'Cusio',0,'1800-01-01',NULL,0),
	(1958,14,'Dalmine',0,'1800-01-01',NULL,0),
	(1959,14,'Dossena',0,'1800-01-01',NULL,0),
	(1960,14,'Endine Gaiano',0,'1800-01-01',NULL,0),
	(1961,14,'Entratico',0,'1800-01-01',NULL,0),
	(1962,14,'Fara Gera d\'Adda',0,'1800-01-01',NULL,0),
	(1963,14,'Fara Olivana con Sola',0,'1800-01-01',NULL,0),
	(1964,14,'Filago',0,'1800-01-01',NULL,0),
	(1965,14,'Fino del Monte',0,'1800-01-01',NULL,0),
	(1966,14,'Fiorano al Serio',0,'1800-01-01',NULL,0),
	(1967,14,'Fontanella',0,'1800-01-01',NULL,0),
	(1968,14,'Fonteno',0,'1800-01-01',NULL,0),
	(1969,14,'Foppolo',0,'1800-01-01',NULL,0),
	(1970,14,'Foresto Sparso',0,'1800-01-01',NULL,0),
	(1971,14,'Fornovo San Giovanni',0,'1800-01-01',NULL,0),
	(1972,14,'Fuipiano Valle Imagna',0,'1800-01-01',NULL,0),
	(1973,14,'Gandellino',0,'1800-01-01',NULL,0),
	(1974,14,'Gandino',0,'1800-01-01',NULL,0),
	(1975,14,'Gandosso',0,'1800-01-01',NULL,0),
	(1976,14,'Gaverina Terme',0,'1800-01-01',NULL,0),
	(1977,14,'Gazzaniga',0,'1800-01-01',NULL,0),
	(1978,14,'Gerosa',0,'1800-01-01',NULL,0),
	(1979,14,'Ghisalba',0,'1800-01-01',NULL,0),
	(1980,14,'Gorlago',0,'1800-01-01',NULL,0),
	(1981,14,'Gorle',0,'1800-01-01',NULL,0),
	(1982,14,'Gorno',0,'1800-01-01',NULL,0),
	(1983,14,'Grassobbio',0,'1800-01-01',NULL,0),
	(1984,14,'Gromo',0,'1800-01-01',NULL,0),
	(1985,14,'Grone',0,'1800-01-01',NULL,0),
	(1986,14,'Grumello del Monte',0,'1800-01-01',NULL,0),
	(1987,14,'Isola di Fondra',0,'1800-01-01',NULL,0),
	(1988,14,'Isso',0,'1800-01-01',NULL,0),
	(1989,14,'Lallio',0,'1800-01-01',NULL,0),
	(1990,14,'Leffe',0,'1800-01-01',NULL,0),
	(1991,14,'Lenna',0,'1800-01-01',NULL,0),
	(1992,14,'Levate',0,'1800-01-01',NULL,0),
	(1993,14,'Locatello',0,'1800-01-01',NULL,0),
	(1994,14,'Lovere',0,'1800-01-01',NULL,0),
	(1995,14,'Lurano',0,'1800-01-01',NULL,0),
	(1996,14,'Luzzana',0,'1800-01-01',NULL,0),
	(1997,14,'Madone',0,'1800-01-01',NULL,0),
	(1998,14,'Mapello',0,'1800-01-01',NULL,0),
	(1999,14,'Martinengo',0,'1800-01-01',NULL,0),
	(2000,14,'Mezzoldo',0,'1800-01-01',NULL,0),
	(2001,14,'Misano di Gera d\'Adda',0,'1800-01-01',NULL,0),
	(2002,14,'Moio de\' Calvi',0,'1800-01-01',NULL,0),
	(2003,14,'Monasterolo del Castello',0,'1800-01-01',NULL,0),
	(2004,14,'Montello',0,'1800-01-01',NULL,0),
	(2005,14,'Morengo',0,'1800-01-01',NULL,0),
	(2006,14,'Mornico al Serio',0,'1800-01-01',NULL,0),
	(2007,14,'Mozzanica',0,'1800-01-01',NULL,0),
	(2008,14,'Mozzo',0,'1800-01-01',NULL,0),
	(2009,14,'Nembro',0,'1800-01-01',NULL,0),
	(2010,14,'Olmo al Brembo',0,'1800-01-01',NULL,0),
	(2011,14,'Oltre il Colle',0,'1800-01-01',NULL,0),
	(2012,14,'Oltressenda Alta',0,'1800-01-01',NULL,0),
	(2013,14,'Oneta',0,'1800-01-01',NULL,0),
	(2014,14,'Onore',0,'1800-01-01',NULL,0),
	(2015,14,'Orio al Serio',0,'1800-01-01',NULL,0),
	(2016,14,'Ornica',0,'1800-01-01',NULL,0),
	(2017,14,'Osio Sopra',0,'1800-01-01',NULL,0),
	(2018,14,'Osio Sotto',0,'1800-01-01',NULL,0),
	(2019,14,'Pagazzano',0,'1800-01-01',NULL,0),
	(2020,14,'Paladina',0,'1800-01-01',NULL,0),
	(2021,14,'Palazzago',0,'1800-01-01',NULL,0),
	(2022,14,'Palosco',0,'1800-01-01',NULL,0),
	(2023,14,'Parre',0,'1800-01-01',NULL,0),
	(2024,14,'Parzanica',0,'1800-01-01',NULL,0),
	(2025,14,'Pedrengo',0,'1800-01-01',NULL,0),
	(2026,14,'Peia',0,'1800-01-01',NULL,0),
	(2027,14,'Pianico',0,'1800-01-01',NULL,0),
	(2028,14,'Piario',0,'1800-01-01',NULL,0),
	(2029,14,'Piazza Brembana',0,'1800-01-01',NULL,0),
	(2030,14,'Piazzatorre',0,'1800-01-01',NULL,0),
	(2031,14,'Piazzolo',0,'1800-01-01',NULL,0),
	(2032,14,'Pognano',0,'1800-01-01',NULL,0),
	(2033,14,'Ponte Nossa',0,'1800-01-01',NULL,0),
	(2034,14,'Ponteranica',0,'1800-01-01',NULL,0),
	(2035,14,'Ponte San Pietro',0,'1800-01-01',NULL,0),
	(2036,14,'Pontida',0,'1800-01-01',NULL,0),
	(2037,14,'Pontirolo Nuovo',0,'1800-01-01',NULL,0),
	(2038,14,'Pradalunga',0,'1800-01-01',NULL,0),
	(2039,14,'Predore',0,'1800-01-01',NULL,0),
	(2040,14,'Premolo',0,'1800-01-01',NULL,0),
	(2041,14,'Presezzo',0,'1800-01-01',NULL,0),
	(2042,14,'Pumenengo',0,'1800-01-01',NULL,0),
	(2043,14,'Ranica',0,'1800-01-01',NULL,0),
	(2044,14,'Ranzanico',0,'1800-01-01',NULL,0),
	(2045,14,'Riva di Solto',0,'1800-01-01',NULL,0),
	(2046,14,'Rogno',0,'1800-01-01',NULL,0),
	(2047,14,'Romano di Lombardia',0,'1800-01-01',NULL,0),
	(2048,14,'Roncobello',0,'1800-01-01',NULL,0),
	(2049,14,'Roncola',0,'1800-01-01',NULL,0),
	(2050,14,'Rota d\'Imagna',0,'1800-01-01',NULL,0),
	(2051,14,'Rovetta',0,'1800-01-01',NULL,0),
	(2052,14,'San Giovanni Bianco',0,'1800-01-01',NULL,0),
	(2053,14,'San Paolo d\'Argon',0,'1800-01-01',NULL,0),
	(2054,14,'San Pellegrino Terme',0,'1800-01-01',NULL,0),
	(2055,14,'Santa Brigida',0,'1800-01-01',NULL,0),
	(2056,14,'Sant\'Omobono Terme',0,'1800-01-01',NULL,0),
	(2057,14,'Sarnico',0,'1800-01-01',NULL,0),
	(2058,14,'Scanzorosciate',0,'1800-01-01',NULL,0),
	(2059,14,'Schilpario',0,'1800-01-01',NULL,0),
	(2060,14,'Sedrina',0,'1800-01-01',NULL,0),
	(2061,14,'Selvino',0,'1800-01-01',NULL,0),
	(2062,14,'Seriate',0,'1800-01-01',NULL,0),
	(2063,14,'Serina',0,'1800-01-01',NULL,0),
	(2064,14,'Solto Collina',0,'1800-01-01',NULL,0),
	(2065,14,'Songavazzo',0,'1800-01-01',NULL,0),
	(2066,14,'Sorisole',0,'1800-01-01',NULL,0),
	(2067,14,'Sotto il Monte Giovanni XXIII',0,'1800-01-01',NULL,0),
	(2068,14,'Sovere',0,'1800-01-01',NULL,0),
	(2069,14,'Spinone al Lago',0,'1800-01-01',NULL,0),
	(2070,14,'Spirano',0,'1800-01-01',NULL,0),
	(2071,14,'Stezzano',0,'1800-01-01',NULL,0),
	(2072,14,'Strozza',0,'1800-01-01',NULL,0),
	(2073,14,'Suisio',0,'1800-01-01',NULL,0),
	(2074,14,'Taleggio',0,'1800-01-01',NULL,0),
	(2075,14,'Tavernola Bergamasca',0,'1800-01-01',NULL,0),
	(2076,14,'Telgate',0,'1800-01-01',NULL,0),
	(2077,14,'Terno d\'Isola',0,'1800-01-01',NULL,0),
	(2078,14,'Torre Boldone',0,'1800-01-01',NULL,0),
	(2079,14,'Torre de\' Roveri',0,'1800-01-01',NULL,0),
	(2080,14,'Torre Pallavicina',0,'1800-01-01',NULL,0),
	(2081,14,'Trescore Balneario',0,'1800-01-01',NULL,0),
	(2082,14,'Treviglio',0,'1800-01-01',NULL,0),
	(2083,14,'Treviolo',0,'1800-01-01',NULL,0),
	(2084,14,'Ubiale Clanezzo',0,'1800-01-01',NULL,0),
	(2085,14,'Urgnano',0,'1800-01-01',NULL,0),
	(2086,14,'Valbondione',0,'1800-01-01',NULL,0),
	(2087,14,'Valbrembo',0,'1800-01-01',NULL,0),
	(2088,14,'Valgoglio',0,'1800-01-01',NULL,0),
	(2089,14,'Valleve',0,'1800-01-01',NULL,0),
	(2090,14,'Valnegra',0,'1800-01-01',NULL,0),
	(2091,14,'Valsecca',0,'1800-01-01',NULL,0),
	(2092,14,'Valtorta',0,'1800-01-01',NULL,0),
	(2093,14,'Vedeseta',0,'1800-01-01',NULL,0),
	(2094,14,'Verdellino',0,'1800-01-01',NULL,0),
	(2095,14,'Verdello',0,'1800-01-01',NULL,0),
	(2096,14,'Vertova',0,'1800-01-01',NULL,0),
	(2097,14,'Viadanica',0,'1800-01-01',NULL,0),
	(2098,14,'Vigano San Martino',0,'1800-01-01',NULL,0),
	(2099,14,'Vigolo',0,'1800-01-01',NULL,0),
	(2100,14,'Villa d\'Adda',0,'1800-01-01',NULL,0),
	(2101,14,'Villa d\'Almè',0,'1800-01-01',NULL,0),
	(2102,14,'Villa di Serio',0,'1800-01-01',NULL,0),
	(2103,14,'Villa d\'Ogna',0,'1800-01-01',NULL,0),
	(2104,14,'Villongo',0,'1800-01-01',NULL,0),
	(2105,14,'Vilminore di Scalve',0,'1800-01-01',NULL,0),
	(2106,14,'Zandobbio',0,'1800-01-01',NULL,0),
	(2107,14,'Zanica',0,'1800-01-01',NULL,0),
	(2108,14,'Zogno',0,'1800-01-01',NULL,0),
	(2109,14,'Costa Serina',0,'1800-01-01',NULL,0),
	(2110,14,'Algua',0,'1800-01-01',NULL,0),
	(2111,14,'Cornalba',0,'1800-01-01',NULL,0),
	(2112,14,'Medolago',0,'1800-01-01',NULL,0),
	(2113,14,'Solza',0,'1800-01-01',NULL,0),
	(2114,15,'Acquafredda',0,'1800-01-01',NULL,0),
	(2115,15,'Adro',0,'1800-01-01',NULL,0),
	(2116,15,'Agnosine',0,'1800-01-01',NULL,0),
	(2117,15,'Alfianello',0,'1800-01-01',NULL,0),
	(2118,15,'Anfo',0,'1800-01-01',NULL,0),
	(2119,15,'Angolo Terme',0,'1800-01-01',NULL,0),
	(2120,15,'Artogne',0,'1800-01-01',NULL,0),
	(2121,15,'Azzano Mella',0,'1800-01-01',NULL,0),
	(2122,15,'Bagnolo Mella',0,'1800-01-01',NULL,0),
	(2123,15,'Bagolino',0,'1800-01-01',NULL,0),
	(2124,15,'Barbariga',0,'1800-01-01',NULL,0),
	(2125,15,'Barghe',0,'1800-01-01',NULL,0),
	(2126,15,'Bassano Bresciano',0,'1800-01-01',NULL,0),
	(2127,15,'Bedizzole',0,'1800-01-01',NULL,0),
	(2128,15,'Berlingo',0,'1800-01-01',NULL,0),
	(2129,15,'Berzo Demo',0,'1800-01-01',NULL,0),
	(2130,15,'Berzo Inferiore',0,'1800-01-01',NULL,0),
	(2131,15,'Bienno',0,'1800-01-01',NULL,0),
	(2132,15,'Bione',0,'1800-01-01',NULL,0),
	(2133,15,'Borgo San Giacomo',0,'1800-01-01',NULL,0),
	(2134,15,'Borgosatollo',0,'1800-01-01',NULL,0),
	(2135,15,'Borno',0,'1800-01-01',NULL,0),
	(2136,15,'Botticino',0,'1800-01-01',NULL,0),
	(2137,15,'Bovegno',0,'1800-01-01',NULL,0),
	(2138,15,'Bovezzo',0,'1800-01-01',NULL,0),
	(2139,15,'Brandico',0,'1800-01-01',NULL,0),
	(2140,15,'Braone',0,'1800-01-01',NULL,0),
	(2141,15,'Breno',0,'1800-01-01',NULL,0),
	(2142,15,'Brescia',1,'1800-01-01',NULL,0),
	(2143,15,'Brione',0,'1800-01-01',NULL,0),
	(2144,15,'Caino',0,'1800-01-01',NULL,0),
	(2145,15,'Calcinato',0,'1800-01-01',NULL,0),
	(2146,15,'Calvagese della Riviera',0,'1800-01-01',NULL,0),
	(2147,15,'Calvisano',0,'1800-01-01',NULL,0),
	(2148,15,'Capo di Ponte',0,'1800-01-01',NULL,0),
	(2149,15,'Capovalle',0,'1800-01-01',NULL,0),
	(2150,15,'Capriano del Colle',0,'1800-01-01',NULL,0),
	(2151,15,'Capriolo',0,'1800-01-01',NULL,0),
	(2152,15,'Carpenedolo',0,'1800-01-01',NULL,0),
	(2153,15,'Castegnato',0,'1800-01-01',NULL,0),
	(2154,15,'Castelcovati',0,'1800-01-01',NULL,0),
	(2155,15,'Castel Mella',0,'1800-01-01',NULL,0),
	(2156,15,'Castenedolo',0,'1800-01-01',NULL,0),
	(2157,15,'Casto',0,'1800-01-01',NULL,0),
	(2158,15,'Castrezzato',0,'1800-01-01',NULL,0),
	(2159,15,'Cazzago San Martino',0,'1800-01-01',NULL,0),
	(2160,15,'Cedegolo',0,'1800-01-01',NULL,0),
	(2161,15,'Cellatica',0,'1800-01-01',NULL,0),
	(2162,15,'Cerveno',0,'1800-01-01',NULL,0),
	(2163,15,'Ceto',0,'1800-01-01',NULL,0),
	(2164,15,'Cevo',0,'1800-01-01',NULL,0),
	(2165,15,'Chiari',0,'1800-01-01',NULL,0),
	(2166,15,'Cigole',0,'1800-01-01',NULL,0),
	(2167,15,'Cimbergo',0,'1800-01-01',NULL,0),
	(2168,15,'Cividate Camuno',0,'1800-01-01',NULL,0),
	(2169,15,'Coccaglio',0,'1800-01-01',NULL,0),
	(2170,15,'Collebeato',0,'1800-01-01',NULL,0),
	(2171,15,'Collio',0,'1800-01-01',NULL,0),
	(2172,15,'Cologne',0,'1800-01-01',NULL,0),
	(2173,15,'Comezzano-Cizzago',0,'1800-01-01',NULL,0),
	(2174,15,'Concesio',0,'1800-01-01',NULL,0),
	(2175,15,'Corte Franca',0,'1800-01-01',NULL,0),
	(2176,15,'Corteno Golgi',0,'1800-01-01',NULL,0),
	(2177,15,'Corzano',0,'1800-01-01',NULL,0),
	(2178,15,'Darfo Boario Terme',0,'1800-01-01',NULL,0),
	(2179,15,'Dello',0,'1800-01-01',NULL,0),
	(2180,15,'Desenzano del Garda',0,'1800-01-01',NULL,0),
	(2181,15,'Edolo',0,'1800-01-01',NULL,0),
	(2182,15,'Erbusco',0,'1800-01-01',NULL,0),
	(2183,15,'Esine',0,'1800-01-01',NULL,0),
	(2184,15,'Fiesse',0,'1800-01-01',NULL,0),
	(2185,15,'Flero',0,'1800-01-01',NULL,0),
	(2186,15,'Gambara',0,'1800-01-01',NULL,0),
	(2187,15,'Gardone Riviera',0,'1800-01-01',NULL,0),
	(2188,15,'Gardone Val Trompia',0,'1800-01-01',NULL,0),
	(2189,15,'Gargnano',0,'1800-01-01',NULL,0),
	(2190,15,'Gavardo',0,'1800-01-01',NULL,0),
	(2191,15,'Ghedi',0,'1800-01-01',NULL,0),
	(2192,15,'Gianico',0,'1800-01-01',NULL,0),
	(2193,15,'Gottolengo',0,'1800-01-01',NULL,0),
	(2194,15,'Gussago',0,'1800-01-01',NULL,0),
	(2195,15,'Idro',0,'1800-01-01',NULL,0),
	(2196,15,'Incudine',0,'1800-01-01',NULL,0),
	(2197,15,'Irma',0,'1800-01-01',NULL,0),
	(2198,15,'Iseo',0,'1800-01-01',NULL,0),
	(2199,15,'Isorella',0,'1800-01-01',NULL,0),
	(2200,15,'Lavenone',0,'1800-01-01',NULL,0),
	(2201,15,'Leno',0,'1800-01-01',NULL,0),
	(2202,15,'Limone sul Garda',0,'1800-01-01',NULL,0),
	(2203,15,'Lodrino',0,'1800-01-01',NULL,0),
	(2204,15,'Lograto',0,'1800-01-01',NULL,0),
	(2205,15,'Lonato del Garda',0,'1800-01-01',NULL,0),
	(2206,15,'Longhena',0,'1800-01-01',NULL,0),
	(2207,15,'Losine',0,'1800-01-01',NULL,0),
	(2208,15,'Lozio',0,'1800-01-01',NULL,0),
	(2209,15,'Lumezzane',0,'1800-01-01',NULL,0),
	(2210,15,'Maclodio',0,'1800-01-01',NULL,0),
	(2211,15,'Magasa',0,'1800-01-01',NULL,0),
	(2212,15,'Mairano',0,'1800-01-01',NULL,0),
	(2213,15,'Malegno',0,'1800-01-01',NULL,0),
	(2214,15,'Malonno',0,'1800-01-01',NULL,0),
	(2215,15,'Manerba del Garda',0,'1800-01-01',NULL,0),
	(2216,15,'Manerbio',0,'1800-01-01',NULL,0),
	(2217,15,'Marcheno',0,'1800-01-01',NULL,0),
	(2218,15,'Marmentino',0,'1800-01-01',NULL,0),
	(2219,15,'Marone',0,'1800-01-01',NULL,0),
	(2220,15,'Mazzano',0,'1800-01-01',NULL,0),
	(2221,15,'Milzano',0,'1800-01-01',NULL,0),
	(2222,15,'Moniga del Garda',0,'1800-01-01',NULL,0),
	(2223,15,'Monno',0,'1800-01-01',NULL,0),
	(2224,15,'Monte Isola',0,'1800-01-01',NULL,0),
	(2225,15,'Monticelli Brusati',0,'1800-01-01',NULL,0),
	(2226,15,'Montichiari',0,'1800-01-01',NULL,0),
	(2227,15,'Montirone',0,'1800-01-01',NULL,0),
	(2228,15,'Mura',0,'1800-01-01',NULL,0),
	(2229,15,'Muscoline',0,'1800-01-01',NULL,0),
	(2230,15,'Nave',0,'1800-01-01',NULL,0),
	(2231,15,'Niardo',0,'1800-01-01',NULL,0),
	(2232,15,'Nuvolento',0,'1800-01-01',NULL,0),
	(2233,15,'Nuvolera',0,'1800-01-01',NULL,0),
	(2234,15,'Odolo',0,'1800-01-01',NULL,0),
	(2235,15,'Offlaga',0,'1800-01-01',NULL,0),
	(2236,15,'Ome',0,'1800-01-01',NULL,0),
	(2237,15,'Ono San Pietro',0,'1800-01-01',NULL,0),
	(2238,15,'Orzinuovi',0,'1800-01-01',NULL,0),
	(2239,15,'Orzivecchi',0,'1800-01-01',NULL,0),
	(2240,15,'Ospitaletto',0,'1800-01-01',NULL,0),
	(2241,15,'Ossimo',0,'1800-01-01',NULL,0),
	(2242,15,'Padenghe sul Garda',0,'1800-01-01',NULL,0),
	(2243,15,'Paderno Franciacorta',0,'1800-01-01',NULL,0),
	(2244,15,'Paisco Loveno',0,'1800-01-01',NULL,0),
	(2245,15,'Paitone',0,'1800-01-01',NULL,0),
	(2246,15,'Palazzolo sull\'Oglio',0,'1800-01-01',NULL,0),
	(2247,15,'Paratico',0,'1800-01-01',NULL,0),
	(2248,15,'Paspardo',0,'1800-01-01',NULL,0),
	(2249,15,'Passirano',0,'1800-01-01',NULL,0),
	(2250,15,'Pavone del Mella',0,'1800-01-01',NULL,0),
	(2251,15,'San Paolo',0,'1800-01-01',NULL,0),
	(2252,15,'Pertica Alta',0,'1800-01-01',NULL,0),
	(2253,15,'Pertica Bassa',0,'1800-01-01',NULL,0),
	(2254,15,'Pezzaze',0,'1800-01-01',NULL,0),
	(2255,15,'Pian Camuno',0,'1800-01-01',NULL,0),
	(2256,15,'Pisogne',0,'1800-01-01',NULL,0),
	(2257,15,'Polaveno',0,'1800-01-01',NULL,0),
	(2258,15,'Polpenazze del Garda',0,'1800-01-01',NULL,0),
	(2259,15,'Pompiano',0,'1800-01-01',NULL,0),
	(2260,15,'Poncarale',0,'1800-01-01',NULL,0),
	(2261,15,'Ponte di Legno',0,'1800-01-01',NULL,0),
	(2262,15,'Pontevico',0,'1800-01-01',NULL,0),
	(2263,15,'Pontoglio',0,'1800-01-01',NULL,0),
	(2264,15,'Pozzolengo',0,'1800-01-01',NULL,0),
	(2265,15,'Pralboino',0,'1800-01-01',NULL,0),
	(2266,15,'Preseglie',0,'1800-01-01',NULL,0),
	(2267,15,'Prestine',0,'1800-01-01',NULL,0),
	(2268,15,'Prevalle',0,'1800-01-01',NULL,0),
	(2269,15,'Provaglio d\'Iseo',0,'1800-01-01',NULL,0),
	(2270,15,'Provaglio Val Sabbia',0,'1800-01-01',NULL,0),
	(2271,15,'Puegnago sul Garda',0,'1800-01-01',NULL,0),
	(2272,15,'Quinzano d\'Oglio',0,'1800-01-01',NULL,0),
	(2273,15,'Remedello',0,'1800-01-01',NULL,0),
	(2274,15,'Rezzato',0,'1800-01-01',NULL,0),
	(2275,15,'Roccafranca',0,'1800-01-01',NULL,0),
	(2276,15,'Rodengo Saiano',0,'1800-01-01',NULL,0),
	(2277,15,'Roè Volciano',0,'1800-01-01',NULL,0),
	(2278,15,'Roncadelle',0,'1800-01-01',NULL,0),
	(2279,15,'Rovato',0,'1800-01-01',NULL,0),
	(2280,15,'Rudiano',0,'1800-01-01',NULL,0),
	(2281,15,'Sabbio Chiese',0,'1800-01-01',NULL,0),
	(2282,15,'Sale Marasino',0,'1800-01-01',NULL,0),
	(2283,15,'Salò',0,'1800-01-01',NULL,0),
	(2284,15,'San Felice del Benaco',0,'1800-01-01',NULL,0),
	(2285,15,'San Gervasio Bresciano',0,'1800-01-01',NULL,0),
	(2286,15,'San Zeno Naviglio',0,'1800-01-01',NULL,0),
	(2287,15,'Sarezzo',0,'1800-01-01',NULL,0),
	(2288,15,'Saviore dell\'Adamello',0,'1800-01-01',NULL,0),
	(2289,15,'Sellero',0,'1800-01-01',NULL,0),
	(2290,15,'Seniga',0,'1800-01-01',NULL,0),
	(2291,15,'Serle',0,'1800-01-01',NULL,0),
	(2292,15,'Sirmione',0,'1800-01-01',NULL,0),
	(2293,15,'Soiano del Lago',0,'1800-01-01',NULL,0),
	(2294,15,'Sonico',0,'1800-01-01',NULL,0),
	(2295,15,'Sulzano',0,'1800-01-01',NULL,0),
	(2296,15,'Tavernole sul Mella',0,'1800-01-01',NULL,0),
	(2297,15,'Temù',0,'1800-01-01',NULL,0),
	(2298,15,'Tignale',0,'1800-01-01',NULL,0),
	(2299,15,'Torbole Casaglia',0,'1800-01-01',NULL,0),
	(2300,15,'Toscolano-Maderno',0,'1800-01-01',NULL,0),
	(2301,15,'Travagliato',0,'1800-01-01',NULL,0),
	(2302,15,'Tremosine',0,'1800-01-01',NULL,0),
	(2303,15,'Trenzano',0,'1800-01-01',NULL,0),
	(2304,15,'Treviso Bresciano',0,'1800-01-01',NULL,0),
	(2305,15,'Urago d\'Oglio',0,'1800-01-01',NULL,0),
	(2306,15,'Vallio Terme',0,'1800-01-01',NULL,0),
	(2307,15,'Valvestino',0,'1800-01-01',NULL,0),
	(2308,15,'Verolanuova',0,'1800-01-01',NULL,0),
	(2309,15,'Verolavecchia',0,'1800-01-01',NULL,0),
	(2310,15,'Vestone',0,'1800-01-01',NULL,0),
	(2311,15,'Vezza d\'Oglio',0,'1800-01-01',NULL,0),
	(2312,15,'Villa Carcina',0,'1800-01-01',NULL,0),
	(2313,15,'Villachiara',0,'1800-01-01',NULL,0),
	(2314,15,'Villanuova sul Clisi',0,'1800-01-01',NULL,0),
	(2315,15,'Vione',0,'1800-01-01',NULL,0),
	(2316,15,'Visano',0,'1800-01-01',NULL,0),
	(2317,15,'Vobarno',0,'1800-01-01',NULL,0),
	(2318,15,'Zone',0,'1800-01-01',NULL,0),
	(2319,15,'Piancogno',0,'1800-01-01',NULL,0),
	(2320,16,'Alagna',0,'1800-01-01',NULL,0),
	(2321,16,'Albaredo Arnaboldi',0,'1800-01-01',NULL,0),
	(2322,16,'Albonese',0,'1800-01-01',NULL,0),
	(2323,16,'Albuzzano',0,'1800-01-01',NULL,0),
	(2324,16,'Arena Po',0,'1800-01-01',NULL,0),
	(2325,16,'Badia Pavese',0,'1800-01-01',NULL,0),
	(2326,16,'Bagnaria',0,'1800-01-01',NULL,0),
	(2327,16,'Barbianello',0,'1800-01-01',NULL,0),
	(2328,16,'Bascapè',0,'1800-01-01',NULL,0),
	(2329,16,'Bastida de\' Dossi',0,'1800-01-01',NULL,0),
	(2330,16,'Bastida Pancarana',0,'1800-01-01',NULL,0),
	(2331,16,'Battuda',0,'1800-01-01',NULL,0),
	(2332,16,'Belgioioso',0,'1800-01-01',NULL,0),
	(2333,16,'Bereguardo',0,'1800-01-01',NULL,0),
	(2334,16,'Borgarello',0,'1800-01-01',NULL,0),
	(2335,16,'Borgo Priolo',0,'1800-01-01',NULL,0),
	(2336,16,'Borgoratto Mormorolo',0,'1800-01-01',NULL,0),
	(2337,16,'Borgo San Siro',0,'1800-01-01',NULL,0),
	(2338,16,'Bornasco',0,'1800-01-01',NULL,0),
	(2339,16,'Bosnasco',0,'1800-01-01',NULL,0),
	(2340,16,'Brallo di Pregola',0,'1800-01-01',NULL,0),
	(2341,16,'Breme',0,'1800-01-01',NULL,0),
	(2342,16,'Bressana Bottarone',0,'1800-01-01',NULL,0),
	(2343,16,'Broni',0,'1800-01-01',NULL,0),
	(2344,16,'Calvignano',0,'1800-01-01',NULL,0),
	(2345,16,'Campospinoso',0,'1800-01-01',NULL,0),
	(2346,16,'Candia Lomellina',0,'1800-01-01',NULL,0),
	(2347,16,'Canevino',0,'1800-01-01',NULL,0),
	(2348,16,'Canneto Pavese',0,'1800-01-01',NULL,0),
	(2349,16,'Carbonara al Ticino',0,'1800-01-01',NULL,0),
	(2350,16,'Casanova Lonati',0,'1800-01-01',NULL,0),
	(2351,16,'Casatisma',0,'1800-01-01',NULL,0),
	(2352,16,'Casei Gerola',0,'1800-01-01',NULL,0),
	(2353,16,'Casorate Primo',0,'1800-01-01',NULL,0),
	(2354,16,'Cassolnovo',0,'1800-01-01',NULL,0),
	(2355,16,'Castana',0,'1800-01-01',NULL,0),
	(2356,16,'Casteggio',0,'1800-01-01',NULL,0),
	(2357,16,'Castelletto di Branduzzo',0,'1800-01-01',NULL,0),
	(2358,16,'Castello d\'Agogna',0,'1800-01-01',NULL,0),
	(2359,16,'Castelnovetto',0,'1800-01-01',NULL,0),
	(2360,16,'Cava Manara',0,'1800-01-01',NULL,0),
	(2361,16,'Cecima',0,'1800-01-01',NULL,0),
	(2362,16,'Ceranova',0,'1800-01-01',NULL,0),
	(2363,16,'Ceretto Lomellina',0,'1800-01-01',NULL,0),
	(2364,16,'Cergnago',0,'1800-01-01',NULL,0),
	(2365,16,'Certosa di Pavia',0,'1800-01-01',NULL,0),
	(2366,16,'Cervesina',0,'1800-01-01',NULL,0),
	(2367,16,'Chignolo Po',0,'1800-01-01',NULL,0),
	(2368,16,'Cigognola',0,'1800-01-01',NULL,0),
	(2369,16,'Cilavegna',0,'1800-01-01',NULL,0),
	(2370,16,'Codevilla',0,'1800-01-01',NULL,0),
	(2371,16,'Confienza',0,'1800-01-01',NULL,0),
	(2372,16,'Copiano',0,'1800-01-01',NULL,0),
	(2373,16,'Corana',0,'1800-01-01',NULL,0),
	(2374,16,'Cornale',0,'1800-01-01',NULL,0),
	(2375,16,'Corteolona',0,'1800-01-01',NULL,0),
	(2376,16,'Corvino San Quirico',0,'1800-01-01',NULL,0),
	(2377,16,'Costa de\' Nobili',0,'1800-01-01',NULL,0),
	(2378,16,'Cozzo',0,'1800-01-01',NULL,0),
	(2379,16,'Cura Carpignano',0,'1800-01-01',NULL,0),
	(2380,16,'Dorno',0,'1800-01-01',NULL,0),
	(2381,16,'Ferrera Erbognone',0,'1800-01-01',NULL,0),
	(2382,16,'Filighera',0,'1800-01-01',NULL,0),
	(2383,16,'Fortunago',0,'1800-01-01',NULL,0),
	(2384,16,'Frascarolo',0,'1800-01-01',NULL,0),
	(2385,16,'Galliavola',0,'1800-01-01',NULL,0),
	(2386,16,'Gambarana',0,'1800-01-01',NULL,0),
	(2387,16,'Gambolò',0,'1800-01-01',NULL,0),
	(2388,16,'Garlasco',0,'1800-01-01',NULL,0),
	(2389,16,'Genzone',0,'1800-01-01',NULL,0),
	(2390,16,'Gerenzago',0,'1800-01-01',NULL,0),
	(2391,16,'Giussago',0,'1800-01-01',NULL,0),
	(2392,16,'Godiasco',0,'1800-01-01',NULL,0),
	(2393,16,'Golferenzo',0,'1800-01-01',NULL,0),
	(2394,16,'Gravellona Lomellina',0,'1800-01-01',NULL,0),
	(2395,16,'Gropello Cairoli',0,'1800-01-01',NULL,0),
	(2396,16,'Inverno e Monteleone',0,'1800-01-01',NULL,0),
	(2397,16,'Landriano',0,'1800-01-01',NULL,0),
	(2398,16,'Langosco',0,'1800-01-01',NULL,0),
	(2399,16,'Lardirago',0,'1800-01-01',NULL,0),
	(2400,16,'Linarolo',0,'1800-01-01',NULL,0),
	(2401,16,'Lirio',0,'1800-01-01',NULL,0),
	(2402,16,'Lomello',0,'1800-01-01',NULL,0),
	(2403,16,'Lungavilla',0,'1800-01-01',NULL,0),
	(2404,16,'Magherno',0,'1800-01-01',NULL,0),
	(2405,16,'Marcignago',0,'1800-01-01',NULL,0),
	(2406,16,'Marzano',0,'1800-01-01',NULL,0),
	(2407,16,'Mede',0,'1800-01-01',NULL,0),
	(2408,16,'Menconico',0,'1800-01-01',NULL,0),
	(2409,16,'Mezzana Bigli',0,'1800-01-01',NULL,0),
	(2410,16,'Mezzana Rabattone',0,'1800-01-01',NULL,0),
	(2411,16,'Mezzanino',0,'1800-01-01',NULL,0),
	(2412,16,'Miradolo Terme',0,'1800-01-01',NULL,0),
	(2413,16,'Montalto Pavese',0,'1800-01-01',NULL,0),
	(2414,16,'Montebello della Battaglia',0,'1800-01-01',NULL,0),
	(2415,16,'Montecalvo Versiggia',0,'1800-01-01',NULL,0),
	(2416,16,'Montescano',0,'1800-01-01',NULL,0),
	(2417,16,'Montesegale',0,'1800-01-01',NULL,0),
	(2418,16,'Monticelli Pavese',0,'1800-01-01',NULL,0),
	(2419,16,'Montù Beccaria',0,'1800-01-01',NULL,0),
	(2420,16,'Mornico Losana',0,'1800-01-01',NULL,0),
	(2421,16,'Mortara',0,'1800-01-01',NULL,0),
	(2422,16,'Nicorvo',0,'1800-01-01',NULL,0),
	(2423,16,'Olevano di Lomellina',0,'1800-01-01',NULL,0),
	(2424,16,'Oliva Gessi',0,'1800-01-01',NULL,0),
	(2425,16,'Ottobiano',0,'1800-01-01',NULL,0),
	(2426,16,'Palestro',0,'1800-01-01',NULL,0),
	(2427,16,'Pancarana',0,'1800-01-01',NULL,0),
	(2428,16,'Parona',0,'1800-01-01',NULL,0),
	(2429,16,'Pavia',1,'1800-01-01',NULL,0),
	(2430,16,'Pietra de\' Giorgi',0,'1800-01-01',NULL,0),
	(2431,16,'Pieve Albignola',0,'1800-01-01',NULL,0),
	(2432,16,'Pieve del Cairo',0,'1800-01-01',NULL,0),
	(2433,16,'Pieve Porto Morone',0,'1800-01-01',NULL,0),
	(2434,16,'Pinarolo Po',0,'1800-01-01',NULL,0),
	(2435,16,'Pizzale',0,'1800-01-01',NULL,0),
	(2436,16,'Ponte Nizza',0,'1800-01-01',NULL,0),
	(2437,16,'Portalbera',0,'1800-01-01',NULL,0),
	(2438,16,'Rea',0,'1800-01-01',NULL,0),
	(2439,16,'Redavalle',0,'1800-01-01',NULL,0),
	(2440,16,'Retorbido',0,'1800-01-01',NULL,0),
	(2441,16,'Rivanazzano Terme',0,'1800-01-01',NULL,0),
	(2442,16,'Robbio',0,'1800-01-01',NULL,0),
	(2443,16,'Robecco Pavese',0,'1800-01-01',NULL,0),
	(2444,16,'Rocca de\' Giorgi',0,'1800-01-01',NULL,0),
	(2445,16,'Rocca Susella',0,'1800-01-01',NULL,0),
	(2446,16,'Rognano',0,'1800-01-01',NULL,0),
	(2447,16,'Romagnese',0,'1800-01-01',NULL,0),
	(2448,16,'Roncaro',0,'1800-01-01',NULL,0),
	(2449,16,'Rosasco',0,'1800-01-01',NULL,0),
	(2450,16,'Rovescala',0,'1800-01-01',NULL,0),
	(2451,16,'Ruino',0,'1800-01-01',NULL,0),
	(2452,16,'San Cipriano Po',0,'1800-01-01',NULL,0),
	(2453,16,'San Damiano al Colle',0,'1800-01-01',NULL,0),
	(2454,16,'San Genesio ed Uniti',0,'1800-01-01',NULL,0),
	(2455,16,'San Giorgio di Lomellina',0,'1800-01-01',NULL,0),
	(2456,16,'San Martino Siccomario',0,'1800-01-01',NULL,0),
	(2457,16,'Sannazzaro de\' Burgondi',0,'1800-01-01',NULL,0),
	(2458,16,'Santa Cristina e Bissone',0,'1800-01-01',NULL,0),
	(2459,16,'Santa Giuletta',0,'1800-01-01',NULL,0),
	(2460,16,'Sant\'Alessio con Vialone',0,'1800-01-01',NULL,0),
	(2461,16,'Santa Margherita di Staffora',0,'1800-01-01',NULL,0),
	(2462,16,'Santa Maria della Versa',0,'1800-01-01',NULL,0),
	(2463,16,'Sant\'Angelo Lomellina',0,'1800-01-01',NULL,0),
	(2464,16,'San Zenone al Po',0,'1800-01-01',NULL,0),
	(2465,16,'Sartirana Lomellina',0,'1800-01-01',NULL,0),
	(2466,16,'Scaldasole',0,'1800-01-01',NULL,0),
	(2467,16,'Semiana',0,'1800-01-01',NULL,0),
	(2468,16,'Silvano Pietra',0,'1800-01-01',NULL,0),
	(2469,16,'Siziano',0,'1800-01-01',NULL,0),
	(2470,16,'Sommo',0,'1800-01-01',NULL,0),
	(2471,16,'Spessa',0,'1800-01-01',NULL,0),
	(2472,16,'Stradella',0,'1800-01-01',NULL,0),
	(2473,16,'Suardi',0,'1800-01-01',NULL,0),
	(2474,16,'Torrazza Coste',0,'1800-01-01',NULL,0),
	(2475,16,'Torre Beretti e Castellaro',0,'1800-01-01',NULL,0),
	(2476,16,'Torre d\'Arese',0,'1800-01-01',NULL,0),
	(2477,16,'Torre de\' Negri',0,'1800-01-01',NULL,0),
	(2478,16,'Torre d\'Isola',0,'1800-01-01',NULL,0),
	(2479,16,'Torrevecchia Pia',0,'1800-01-01',NULL,0),
	(2480,16,'Torricella Verzate',0,'1800-01-01',NULL,0),
	(2481,16,'Travacò Siccomario',0,'1800-01-01',NULL,0),
	(2482,16,'Trivolzio',0,'1800-01-01',NULL,0),
	(2483,16,'Tromello',0,'1800-01-01',NULL,0),
	(2484,16,'Trovo',0,'1800-01-01',NULL,0),
	(2485,16,'Val di Nizza',0,'1800-01-01',NULL,0),
	(2486,16,'Valeggio',0,'1800-01-01',NULL,0),
	(2487,16,'Valle Lomellina',0,'1800-01-01',NULL,0),
	(2488,16,'Valle Salimbene',0,'1800-01-01',NULL,0),
	(2489,16,'Valverde',0,'1800-01-01',NULL,0),
	(2490,16,'Varzi',0,'1800-01-01',NULL,0),
	(2491,16,'Velezzo Lomellina',0,'1800-01-01',NULL,0),
	(2492,16,'Vellezzo Bellini',0,'1800-01-01',NULL,0),
	(2493,16,'Verretto',0,'1800-01-01',NULL,0),
	(2494,16,'Verrua Po',0,'1800-01-01',NULL,0),
	(2495,16,'Vidigulfo',0,'1800-01-01',NULL,0),
	(2496,16,'Vigevano',0,'1800-01-01',NULL,0),
	(2497,16,'Villa Biscossi',0,'1800-01-01',NULL,0),
	(2498,16,'Villanova d\'Ardenghi',0,'1800-01-01',NULL,0),
	(2499,16,'Villanterio',0,'1800-01-01',NULL,0),
	(2500,16,'Vistarino',0,'1800-01-01',NULL,0),
	(2501,16,'Voghera',0,'1800-01-01',NULL,0),
	(2502,16,'Volpara',0,'1800-01-01',NULL,0),
	(2503,16,'Zavattarello',0,'1800-01-01',NULL,0),
	(2504,16,'Zeccone',0,'1800-01-01',NULL,0),
	(2505,16,'Zeme',0,'1800-01-01',NULL,0),
	(2506,16,'Zenevredo',0,'1800-01-01',NULL,0),
	(2507,16,'Zerbo',0,'1800-01-01',NULL,0),
	(2508,16,'Zerbolò',0,'1800-01-01',NULL,0),
	(2509,16,'Zinasco',0,'1800-01-01',NULL,0),
	(2510,17,'Acquanegra Cremonese',0,'1800-01-01',NULL,0),
	(2511,17,'Agnadello',0,'1800-01-01',NULL,0),
	(2512,17,'Annicco',0,'1800-01-01',NULL,0),
	(2513,17,'Azzanello',0,'1800-01-01',NULL,0),
	(2514,17,'Bagnolo Cremasco',0,'1800-01-01',NULL,0),
	(2515,17,'Bonemerse',0,'1800-01-01',NULL,0),
	(2516,17,'Bordolano',0,'1800-01-01',NULL,0),
	(2517,17,'Ca\' d\'Andrea',0,'1800-01-01',NULL,0),
	(2518,17,'Calvatone',0,'1800-01-01',NULL,0),
	(2519,17,'Camisano',0,'1800-01-01',NULL,0),
	(2520,17,'Campagnola Cremasca',0,'1800-01-01',NULL,0),
	(2521,17,'Capergnanica',0,'1800-01-01',NULL,0),
	(2522,17,'Cappella Cantone',0,'1800-01-01',NULL,0),
	(2523,17,'Cappella de\' Picenardi',0,'1800-01-01',NULL,0),
	(2524,17,'Capralba',0,'1800-01-01',NULL,0),
	(2525,17,'Casalbuttano ed Uniti',0,'1800-01-01',NULL,0),
	(2526,17,'Casale Cremasco-Vidolasco',0,'1800-01-01',NULL,0),
	(2527,17,'Casaletto Ceredano',0,'1800-01-01',NULL,0),
	(2528,17,'Casaletto di Sopra',0,'1800-01-01',NULL,0),
	(2529,17,'Casaletto Vaprio',0,'1800-01-01',NULL,0),
	(2530,17,'Casalmaggiore',0,'1800-01-01',NULL,0),
	(2531,17,'Casalmorano',0,'1800-01-01',NULL,0),
	(2532,17,'Casteldidone',0,'1800-01-01',NULL,0),
	(2533,17,'Castel Gabbiano',0,'1800-01-01',NULL,0),
	(2534,17,'Castelleone',0,'1800-01-01',NULL,0),
	(2535,17,'Castelverde',0,'1800-01-01',NULL,0),
	(2536,17,'Castelvisconti',0,'1800-01-01',NULL,0),
	(2537,17,'Cella Dati',0,'1800-01-01',NULL,0),
	(2538,17,'Chieve',0,'1800-01-01',NULL,0),
	(2539,17,'Cicognolo',0,'1800-01-01',NULL,0),
	(2540,17,'Cingia de\' Botti',0,'1800-01-01',NULL,0),
	(2541,17,'Corte de\' Cortesi con Cignone',0,'1800-01-01',NULL,0),
	(2542,17,'Corte de\' Frati',0,'1800-01-01',NULL,0),
	(2543,17,'Credera Rubbiano',0,'1800-01-01',NULL,0),
	(2544,17,'Crema',0,'1800-01-01',NULL,0),
	(2545,17,'Cremona',1,'1800-01-01',NULL,0),
	(2546,17,'Cremosano',0,'1800-01-01',NULL,0),
	(2547,17,'Crotta d\'Adda',0,'1800-01-01',NULL,0),
	(2548,17,'Cumignano sul Naviglio',0,'1800-01-01',NULL,0),
	(2549,17,'Derovere',0,'1800-01-01',NULL,0),
	(2550,17,'Dovera',0,'1800-01-01',NULL,0),
	(2551,17,'Drizzona',0,'1800-01-01',NULL,0),
	(2552,17,'Fiesco',0,'1800-01-01',NULL,0),
	(2553,17,'Formigara',0,'1800-01-01',NULL,0),
	(2554,17,'Gabbioneta-Binanuova',0,'1800-01-01',NULL,0),
	(2555,17,'Gadesco-Pieve Delmona',0,'1800-01-01',NULL,0),
	(2556,17,'Genivolta',0,'1800-01-01',NULL,0),
	(2557,17,'Gerre de\' Caprioli',0,'1800-01-01',NULL,0),
	(2558,17,'Gombito',0,'1800-01-01',NULL,0),
	(2559,17,'Grontardo',0,'1800-01-01',NULL,0),
	(2560,17,'Grumello Cremonese ed Uniti',0,'1800-01-01',NULL,0),
	(2561,17,'Gussola',0,'1800-01-01',NULL,0),
	(2562,17,'Isola Dovarese',0,'1800-01-01',NULL,0),
	(2563,17,'Izano',0,'1800-01-01',NULL,0),
	(2564,17,'Madignano',0,'1800-01-01',NULL,0),
	(2565,17,'Malagnino',0,'1800-01-01',NULL,0),
	(2566,17,'Martignana di Po',0,'1800-01-01',NULL,0),
	(2567,17,'Monte Cremasco',0,'1800-01-01',NULL,0),
	(2568,17,'Montodine',0,'1800-01-01',NULL,0),
	(2569,17,'Moscazzano',0,'1800-01-01',NULL,0),
	(2570,17,'Motta Baluffi',0,'1800-01-01',NULL,0),
	(2571,17,'Offanengo',0,'1800-01-01',NULL,0),
	(2572,17,'Olmeneta',0,'1800-01-01',NULL,0),
	(2573,17,'Ostiano',0,'1800-01-01',NULL,0),
	(2574,17,'Paderno Ponchielli',0,'1800-01-01',NULL,0),
	(2575,17,'Palazzo Pignano',0,'1800-01-01',NULL,0),
	(2576,17,'Pandino',0,'1800-01-01',NULL,0),
	(2577,17,'Persico Dosimo',0,'1800-01-01',NULL,0),
	(2578,17,'Pescarolo ed Uniti',0,'1800-01-01',NULL,0),
	(2579,17,'Pessina Cremonese',0,'1800-01-01',NULL,0),
	(2580,17,'Piadena',0,'1800-01-01',NULL,0),
	(2581,17,'Pianengo',0,'1800-01-01',NULL,0),
	(2582,17,'Pieranica',0,'1800-01-01',NULL,0),
	(2583,17,'Pieve d\'Olmi',0,'1800-01-01',NULL,0),
	(2584,17,'Pieve San Giacomo',0,'1800-01-01',NULL,0),
	(2585,17,'Pizzighettone',0,'1800-01-01',NULL,0),
	(2586,17,'Pozzaglio ed Uniti',0,'1800-01-01',NULL,0),
	(2587,17,'Quintano',0,'1800-01-01',NULL,0),
	(2588,17,'Ricengo',0,'1800-01-01',NULL,0),
	(2589,17,'Ripalta Arpina',0,'1800-01-01',NULL,0),
	(2590,17,'Ripalta Cremasca',0,'1800-01-01',NULL,0),
	(2591,17,'Ripalta Guerina',0,'1800-01-01',NULL,0),
	(2592,17,'Rivarolo del Re ed Uniti',0,'1800-01-01',NULL,0),
	(2593,17,'Rivolta d\'Adda',0,'1800-01-01',NULL,0),
	(2594,17,'Robecco d\'Oglio',0,'1800-01-01',NULL,0),
	(2595,17,'Romanengo',0,'1800-01-01',NULL,0),
	(2596,17,'Salvirola',0,'1800-01-01',NULL,0),
	(2597,17,'San Bassano',0,'1800-01-01',NULL,0),
	(2598,17,'San Daniele Po',0,'1800-01-01',NULL,0),
	(2599,17,'San Giovanni in Croce',0,'1800-01-01',NULL,0),
	(2600,17,'San Martino del Lago',0,'1800-01-01',NULL,0),
	(2601,17,'Scandolara Ravara',0,'1800-01-01',NULL,0),
	(2602,17,'Scandolara Ripa d\'Oglio',0,'1800-01-01',NULL,0),
	(2603,17,'Sergnano',0,'1800-01-01',NULL,0),
	(2604,17,'Sesto ed Uniti',0,'1800-01-01',NULL,0),
	(2605,17,'Solarolo Rainerio',0,'1800-01-01',NULL,0),
	(2606,17,'Soncino',0,'1800-01-01',NULL,0),
	(2607,17,'Soresina',0,'1800-01-01',NULL,0),
	(2608,17,'Sospiro',0,'1800-01-01',NULL,0),
	(2609,17,'Spinadesco',0,'1800-01-01',NULL,0),
	(2610,17,'Spineda',0,'1800-01-01',NULL,0),
	(2611,17,'Spino d\'Adda',0,'1800-01-01',NULL,0),
	(2612,17,'Stagno Lombardo',0,'1800-01-01',NULL,0),
	(2613,17,'Ticengo',0,'1800-01-01',NULL,0),
	(2614,17,'Torlino Vimercati',0,'1800-01-01',NULL,0),
	(2615,17,'Tornata',0,'1800-01-01',NULL,0),
	(2616,17,'Torre de\' Picenardi',0,'1800-01-01',NULL,0),
	(2617,17,'Torricella del Pizzo',0,'1800-01-01',NULL,0),
	(2618,17,'Trescore Cremasco',0,'1800-01-01',NULL,0),
	(2619,17,'Trigolo',0,'1800-01-01',NULL,0),
	(2620,17,'Vaiano Cremasco',0,'1800-01-01',NULL,0),
	(2621,17,'Vailate',0,'1800-01-01',NULL,0),
	(2622,17,'Vescovato',0,'1800-01-01',NULL,0),
	(2623,17,'Volongo',0,'1800-01-01',NULL,0),
	(2624,17,'Voltido',0,'1800-01-01',NULL,0),
	(2625,18,'Acquanegra sul Chiese',0,'1800-01-01',NULL,0),
	(2626,18,'Asola',0,'1800-01-01',NULL,0),
	(2627,18,'Bagnolo San Vito',0,'1800-01-01',NULL,0),
	(2628,18,'Bigarello',0,'1800-01-01',NULL,0),
	(2629,18,'Borgoforte',0,'1800-01-01',NULL,0),
	(2630,18,'Borgofranco sul Po',0,'1800-01-01',NULL,0),
	(2631,18,'Bozzolo',0,'1800-01-01',NULL,0),
	(2632,18,'Canneto sull\'Oglio',0,'1800-01-01',NULL,0),
	(2633,18,'Carbonara di Po',0,'1800-01-01',NULL,0),
	(2634,18,'Casalmoro',0,'1800-01-01',NULL,0),
	(2635,18,'Casaloldo',0,'1800-01-01',NULL,0),
	(2636,18,'Casalromano',0,'1800-01-01',NULL,0),
	(2637,18,'Castelbelforte',0,'1800-01-01',NULL,0),
	(2638,18,'Castel d\'Ario',0,'1800-01-01',NULL,0),
	(2639,18,'Castel Goffredo',0,'1800-01-01',NULL,0),
	(2640,18,'Castellucchio',0,'1800-01-01',NULL,0),
	(2641,18,'Castiglione delle Stiviere',0,'1800-01-01',NULL,0),
	(2642,18,'Cavriana',0,'1800-01-01',NULL,0),
	(2643,18,'Ceresara',0,'1800-01-01',NULL,0),
	(2644,18,'Commessaggio',0,'1800-01-01',NULL,0),
	(2645,18,'Curtatone',0,'1800-01-01',NULL,0),
	(2646,18,'Dosolo',0,'1800-01-01',NULL,0),
	(2647,18,'Felonica',0,'1800-01-01',NULL,0),
	(2648,18,'Gazoldo degli Ippoliti',0,'1800-01-01',NULL,0),
	(2649,18,'Gazzuolo',0,'1800-01-01',NULL,0),
	(2650,18,'Goito',0,'1800-01-01',NULL,0),
	(2651,18,'Gonzaga',0,'1800-01-01',NULL,0),
	(2652,18,'Guidizzolo',0,'1800-01-01',NULL,0),
	(2653,18,'Magnacavallo',0,'1800-01-01',NULL,0),
	(2654,18,'Mantova',1,'1800-01-01',NULL,0),
	(2655,18,'Marcaria',0,'1800-01-01',NULL,0),
	(2656,18,'Mariana Mantovana',0,'1800-01-01',NULL,0),
	(2657,18,'Marmirolo',0,'1800-01-01',NULL,0),
	(2658,18,'Medole',0,'1800-01-01',NULL,0),
	(2659,18,'Moglia',0,'1800-01-01',NULL,0),
	(2660,18,'Monzambano',0,'1800-01-01',NULL,0),
	(2661,18,'Motteggiana',0,'1800-01-01',NULL,0),
	(2662,18,'Ostiglia',0,'1800-01-01',NULL,0),
	(2663,18,'Pegognaga',0,'1800-01-01',NULL,0),
	(2664,18,'Pieve di Coriano',0,'1800-01-01',NULL,0),
	(2665,18,'Piubega',0,'1800-01-01',NULL,0),
	(2666,18,'Poggio Rusco',0,'1800-01-01',NULL,0),
	(2667,18,'Pomponesco',0,'1800-01-01',NULL,0),
	(2668,18,'Ponti sul Mincio',0,'1800-01-01',NULL,0),
	(2669,18,'Porto Mantovano',0,'1800-01-01',NULL,0),
	(2670,18,'Quingentole',0,'1800-01-01',NULL,0),
	(2671,18,'Quistello',0,'1800-01-01',NULL,0),
	(2672,18,'Redondesco',0,'1800-01-01',NULL,0),
	(2673,18,'Revere',0,'1800-01-01',NULL,0),
	(2674,18,'Rivarolo Mantovano',0,'1800-01-01',NULL,0),
	(2675,18,'Rodigo',0,'1800-01-01',NULL,0),
	(2676,18,'Roncoferraro',0,'1800-01-01',NULL,0),
	(2677,18,'Roverbella',0,'1800-01-01',NULL,0),
	(2678,18,'Sabbioneta',0,'1800-01-01',NULL,0),
	(2679,18,'San Benedetto Po',0,'1800-01-01',NULL,0),
	(2680,18,'San Giacomo delle Segnate',0,'1800-01-01',NULL,0),
	(2681,18,'San Giorgio di Mantova',0,'1800-01-01',NULL,0),
	(2682,18,'San Giovanni del Dosso',0,'1800-01-01',NULL,0),
	(2683,18,'San Martino dall\'Argine',0,'1800-01-01',NULL,0),
	(2684,18,'Schivenoglia',0,'1800-01-01',NULL,0),
	(2685,18,'Sermide',0,'1800-01-01',NULL,0),
	(2686,18,'Serravalle a Po',0,'1800-01-01',NULL,0),
	(2687,18,'Solferino',0,'1800-01-01',NULL,0),
	(2688,18,'Sustinente',0,'1800-01-01',NULL,0),
	(2689,18,'Suzzara',0,'1800-01-01',NULL,0),
	(2690,18,'Viadana',0,'1800-01-01',NULL,0),
	(2691,18,'Villa Poma',0,'1800-01-01',NULL,0),
	(2692,18,'Villimpenta',0,'1800-01-01',NULL,0),
	(2693,18,'Virgilio',0,'1800-01-01',NULL,0),
	(2694,18,'Volta Mantovana',0,'1800-01-01',NULL,0),
	(2695,22,'Aldino',0,'1800-01-01',NULL,0),
	(2696,22,'Andriano',0,'1800-01-01',NULL,0),
	(2697,22,'Anterivo',0,'1800-01-01',NULL,0),
	(2698,22,'Appiano sulla strada del vino',0,'1800-01-01',NULL,0),
	(2699,22,'Avelengo',0,'1800-01-01',NULL,0),
	(2700,22,'Badia',0,'1800-01-01',NULL,0),
	(2701,22,'Barbiano',0,'1800-01-01',NULL,0),
	(2702,22,'Bolzano',1,'1800-01-01',NULL,0),
	(2703,22,'Braies',0,'1800-01-01',NULL,0),
	(2704,22,'Brennero',0,'1800-01-01',NULL,0),
	(2705,22,'Bressanone',0,'1800-01-01',NULL,0),
	(2706,22,'Bronzolo',0,'1800-01-01',NULL,0),
	(2707,22,'Brunico',0,'1800-01-01',NULL,0),
	(2708,22,'Caines',0,'1800-01-01',NULL,0),
	(2709,22,'Caldaro sulla strada del vino',0,'1800-01-01',NULL,0),
	(2710,22,'Campo di Trens',0,'1800-01-01',NULL,0),
	(2711,22,'Campo Tures',0,'1800-01-01',NULL,0),
	(2712,22,'Castelbello-Ciardes',0,'1800-01-01',NULL,0),
	(2713,22,'Castelrotto',0,'1800-01-01',NULL,0),
	(2714,22,'Cermes',0,'1800-01-01',NULL,0),
	(2715,22,'Chienes',0,'1800-01-01',NULL,0),
	(2716,22,'Chiusa',0,'1800-01-01',NULL,0),
	(2717,22,'Cornedo all\'Isarco',0,'1800-01-01',NULL,0),
	(2718,22,'Cortaccia sulla strada del vino',0,'1800-01-01',NULL,0),
	(2719,22,'Cortina sulla strada del vino',0,'1800-01-01',NULL,0),
	(2720,22,'Corvara in Badia',0,'1800-01-01',NULL,0),
	(2721,22,'Curon Venosta',0,'1800-01-01',NULL,0),
	(2722,22,'Dobbiaco',0,'1800-01-01',NULL,0),
	(2723,22,'Egna',0,'1800-01-01',NULL,0),
	(2724,22,'Falzes',0,'1800-01-01',NULL,0),
	(2725,22,'Fiè allo Sciliar',0,'1800-01-01',NULL,0),
	(2726,22,'Fortezza',0,'1800-01-01',NULL,0),
	(2727,22,'Funes',0,'1800-01-01',NULL,0),
	(2728,22,'Gais',0,'1800-01-01',NULL,0),
	(2729,22,'Gargazzone',0,'1800-01-01',NULL,0),
	(2730,22,'Glorenza',0,'1800-01-01',NULL,0),
	(2731,22,'Laces',0,'1800-01-01',NULL,0),
	(2732,22,'Lagundo',0,'1800-01-01',NULL,0),
	(2733,22,'Laion',0,'1800-01-01',NULL,0),
	(2734,22,'Laives',0,'1800-01-01',NULL,0),
	(2735,22,'Lana',0,'1800-01-01',NULL,0),
	(2736,22,'Lasa',0,'1800-01-01',NULL,0),
	(2737,22,'Lauregno',0,'1800-01-01',NULL,0),
	(2738,22,'Luson',0,'1800-01-01',NULL,0),
	(2739,22,'Magrè sulla strada del vino',0,'1800-01-01',NULL,0),
	(2740,22,'Malles Venosta',0,'1800-01-01',NULL,0),
	(2741,22,'Marebbe',0,'1800-01-01',NULL,0),
	(2742,22,'Marlengo',0,'1800-01-01',NULL,0),
	(2743,22,'Martello',0,'1800-01-01',NULL,0),
	(2744,22,'Meltina',0,'1800-01-01',NULL,0),
	(2745,22,'Merano',0,'1800-01-01',NULL,0),
	(2746,22,'Monguelfo-Tesido',0,'1800-01-01',NULL,0),
	(2747,22,'Montagna',0,'1800-01-01',NULL,0),
	(2748,22,'Moso in Passiria',0,'1800-01-01',NULL,0),
	(2749,22,'Nalles',0,'1800-01-01',NULL,0),
	(2750,22,'Naturno',0,'1800-01-01',NULL,0),
	(2751,22,'Naz-Sciaves',0,'1800-01-01',NULL,0),
	(2752,22,'Nova Levante',0,'1800-01-01',NULL,0),
	(2753,22,'Nova Ponente',0,'1800-01-01',NULL,0),
	(2754,22,'Ora',0,'1800-01-01',NULL,0),
	(2755,22,'Ortisei',0,'1800-01-01',NULL,0),
	(2756,22,'Parcines',0,'1800-01-01',NULL,0),
	(2757,22,'Perca',0,'1800-01-01',NULL,0),
	(2758,22,'Plaus',0,'1800-01-01',NULL,0),
	(2759,22,'Ponte Gardena',0,'1800-01-01',NULL,0),
	(2760,22,'Postal',0,'1800-01-01',NULL,0),
	(2761,22,'Prato allo Stelvio',0,'1800-01-01',NULL,0),
	(2762,22,'Predoi',0,'1800-01-01',NULL,0),
	(2763,22,'Proves',0,'1800-01-01',NULL,0),
	(2764,22,'Racines',0,'1800-01-01',NULL,0),
	(2765,22,'Rasun Anterselva',0,'1800-01-01',NULL,0),
	(2766,22,'Renon',0,'1800-01-01',NULL,0),
	(2767,22,'Rifiano',0,'1800-01-01',NULL,0),
	(2768,22,'Rio di Pusteria',0,'1800-01-01',NULL,0),
	(2769,22,'Rodengo',0,'1800-01-01',NULL,0),
	(2770,22,'Salorno',0,'1800-01-01',NULL,0),
	(2771,22,'San Candido',0,'1800-01-01',NULL,0),
	(2772,22,'San Genesio Atesino',0,'1800-01-01',NULL,0),
	(2773,22,'San Leonardo in Passiria',0,'1800-01-01',NULL,0),
	(2774,22,'San Lorenzo di Sebato',0,'1800-01-01',NULL,0),
	(2775,22,'San Martino in Badia',0,'1800-01-01',NULL,0),
	(2776,22,'San Martino in Passiria',0,'1800-01-01',NULL,0),
	(2777,22,'San Pancrazio',0,'1800-01-01',NULL,0),
	(2778,22,'Santa Cristina Valgardena',0,'1800-01-01',NULL,0),
	(2779,22,'Sarentino',0,'1800-01-01',NULL,0),
	(2780,22,'Scena',0,'1800-01-01',NULL,0),
	(2781,22,'Selva dei Molini',0,'1800-01-01',NULL,0),
	(2782,22,'Selva di Val Gardena',0,'1800-01-01',NULL,0),
	(2783,22,'Senales',0,'1800-01-01',NULL,0),
	(2784,22,'Sesto',0,'1800-01-01',NULL,0),
	(2785,22,'Silandro',0,'1800-01-01',NULL,0),
	(2786,22,'Sluderno',0,'1800-01-01',NULL,0),
	(2787,22,'Stelvio',0,'1800-01-01',NULL,0),
	(2788,22,'Terento',0,'1800-01-01',NULL,0),
	(2789,22,'Terlano',0,'1800-01-01',NULL,0),
	(2790,22,'Termeno sulla strada del vino',0,'1800-01-01',NULL,0),
	(2791,22,'Tesimo',0,'1800-01-01',NULL,0),
	(2792,22,'Tires',0,'1800-01-01',NULL,0),
	(2793,22,'Tirolo',0,'1800-01-01',NULL,0),
	(2794,22,'Trodena nel parco naturale',0,'1800-01-01',NULL,0),
	(2795,22,'Tubre',0,'1800-01-01',NULL,0),
	(2796,22,'Ultimo',0,'1800-01-01',NULL,0),
	(2797,22,'Vadena',0,'1800-01-01',NULL,0),
	(2798,22,'Valdaora',0,'1800-01-01',NULL,0),
	(2799,22,'Val di Vizze',0,'1800-01-01',NULL,0),
	(2800,22,'Valle Aurina',0,'1800-01-01',NULL,0),
	(2801,22,'Valle di Casies',0,'1800-01-01',NULL,0),
	(2802,22,'Vandoies',0,'1800-01-01',NULL,0),
	(2803,22,'Varna',0,'1800-01-01',NULL,0),
	(2804,22,'Verano',0,'1800-01-01',NULL,0),
	(2805,22,'Villabassa',0,'1800-01-01',NULL,0),
	(2806,22,'Villandro',0,'1800-01-01',NULL,0),
	(2807,22,'Vipiteno',0,'1800-01-01',NULL,0),
	(2808,22,'Velturno',0,'1800-01-01',NULL,0),
	(2809,22,'La Valle',0,'1800-01-01',NULL,0),
	(2810,22,'Senale-San Felice',0,'1800-01-01',NULL,0),
	(2811,23,'Ala',0,'1800-01-01',NULL,0),
	(2812,23,'Albiano',0,'1800-01-01',NULL,0),
	(2813,23,'Aldeno',0,'1800-01-01',NULL,0),
	(2814,23,'Amblar',0,'1800-01-01',NULL,0),
	(2815,23,'Andalo',0,'1800-01-01',NULL,0),
	(2816,23,'Arco',0,'1800-01-01',NULL,0),
	(2817,23,'Avio',0,'1800-01-01',NULL,0),
	(2818,23,'Baselga di Pinè',0,'1800-01-01',NULL,0),
	(2819,23,'Bedollo',0,'1800-01-01',NULL,0),
	(2820,23,'Bersone',0,'1800-01-01',NULL,0),
	(2821,23,'Besenello',0,'1800-01-01',NULL,0),
	(2822,23,'Bieno',0,'1800-01-01',NULL,0),
	(2823,23,'Bleggio Superiore',0,'1800-01-01',NULL,0),
	(2824,23,'Bocenago',0,'1800-01-01',NULL,0),
	(2825,23,'Bolbeno',0,'1800-01-01',NULL,0),
	(2826,23,'Bondo',0,'1800-01-01',NULL,0),
	(2827,23,'Bondone',0,'1800-01-01',NULL,0),
	(2828,23,'Borgo Valsugana',0,'1800-01-01',NULL,0),
	(2829,23,'Bosentino',0,'1800-01-01',NULL,0),
	(2830,23,'Breguzzo',0,'1800-01-01',NULL,0),
	(2831,23,'Brentonico',0,'1800-01-01',NULL,0),
	(2832,23,'Bresimo',0,'1800-01-01',NULL,0),
	(2833,23,'Brez',0,'1800-01-01',NULL,0),
	(2834,23,'Brione',0,'1800-01-01',NULL,0),
	(2835,23,'Caderzone Terme',0,'1800-01-01',NULL,0),
	(2836,23,'Cagnò',0,'1800-01-01',NULL,0),
	(2837,23,'Calavino',0,'1800-01-01',NULL,0),
	(2838,23,'Calceranica al Lago',0,'1800-01-01',NULL,0),
	(2839,23,'Caldes',0,'1800-01-01',NULL,0),
	(2840,23,'Caldonazzo',0,'1800-01-01',NULL,0),
	(2841,23,'Calliano',0,'1800-01-01',NULL,0),
	(2842,23,'Campitello di Fassa',0,'1800-01-01',NULL,0),
	(2843,23,'Campodenno',0,'1800-01-01',NULL,0),
	(2844,23,'Canal San Bovo',0,'1800-01-01',NULL,0),
	(2845,23,'Canazei',0,'1800-01-01',NULL,0),
	(2846,23,'Capriana',0,'1800-01-01',NULL,0),
	(2847,23,'Carano',0,'1800-01-01',NULL,0),
	(2848,23,'Carisolo',0,'1800-01-01',NULL,0),
	(2849,23,'Carzano',0,'1800-01-01',NULL,0),
	(2850,23,'Castel Condino',0,'1800-01-01',NULL,0),
	(2851,23,'Castelfondo',0,'1800-01-01',NULL,0),
	(2852,23,'Castello-Molina di Fiemme',0,'1800-01-01',NULL,0),
	(2853,23,'Castello Tesino',0,'1800-01-01',NULL,0),
	(2854,23,'Castelnuovo',0,'1800-01-01',NULL,0),
	(2855,23,'Cavalese',0,'1800-01-01',NULL,0),
	(2856,23,'Cavareno',0,'1800-01-01',NULL,0),
	(2857,23,'Cavedago',0,'1800-01-01',NULL,0),
	(2858,23,'Cavedine',0,'1800-01-01',NULL,0),
	(2859,23,'Cavizzana',0,'1800-01-01',NULL,0),
	(2860,23,'Cembra',0,'1800-01-01',NULL,0),
	(2861,23,'Centa San Nicolò',0,'1800-01-01',NULL,0),
	(2862,23,'Cimego',0,'1800-01-01',NULL,0),
	(2863,23,'Cimone',0,'1800-01-01',NULL,0),
	(2864,23,'Cinte Tesino',0,'1800-01-01',NULL,0),
	(2865,23,'Cis',0,'1800-01-01',NULL,0),
	(2866,23,'Civezzano',0,'1800-01-01',NULL,0),
	(2867,23,'Cles',0,'1800-01-01',NULL,0),
	(2868,23,'Cloz',0,'1800-01-01',NULL,0),
	(2869,23,'Commezzadura',0,'1800-01-01',NULL,0),
	(2870,23,'Condino',0,'1800-01-01',NULL,0),
	(2871,23,'Coredo',0,'1800-01-01',NULL,0),
	(2872,23,'Croviana',0,'1800-01-01',NULL,0),
	(2873,23,'Cunevo',0,'1800-01-01',NULL,0),
	(2874,23,'Daiano',0,'1800-01-01',NULL,0),
	(2875,23,'Dambel',0,'1800-01-01',NULL,0),
	(2876,23,'Daone',0,'1800-01-01',NULL,0),
	(2877,23,'Darè',0,'1800-01-01',NULL,0),
	(2878,23,'Denno',0,'1800-01-01',NULL,0),
	(2879,23,'Dimaro',0,'1800-01-01',NULL,0),
	(2880,23,'Don',0,'1800-01-01',NULL,0),
	(2881,23,'Dorsino',0,'1800-01-01',NULL,0),
	(2882,23,'Drena',0,'1800-01-01',NULL,0),
	(2883,23,'Dro',0,'1800-01-01',NULL,0),
	(2884,23,'Faedo',0,'1800-01-01',NULL,0),
	(2885,23,'Fai della Paganella',0,'1800-01-01',NULL,0),
	(2886,23,'Faver',0,'1800-01-01',NULL,0),
	(2887,23,'Fiavè',0,'1800-01-01',NULL,0),
	(2888,23,'Fiera di Primiero',0,'1800-01-01',NULL,0),
	(2889,23,'Fierozzo',0,'1800-01-01',NULL,0),
	(2890,23,'Flavon',0,'1800-01-01',NULL,0),
	(2891,23,'Folgaria',0,'1800-01-01',NULL,0),
	(2892,23,'Fondo',0,'1800-01-01',NULL,0),
	(2893,23,'Fornace',0,'1800-01-01',NULL,0),
	(2894,23,'Frassilongo',0,'1800-01-01',NULL,0),
	(2895,23,'Garniga Terme',0,'1800-01-01',NULL,0),
	(2896,23,'Giovo',0,'1800-01-01',NULL,0),
	(2897,23,'Giustino',0,'1800-01-01',NULL,0),
	(2898,23,'Grauno',0,'1800-01-01',NULL,0),
	(2899,23,'Grigno',0,'1800-01-01',NULL,0),
	(2900,23,'Grumes',0,'1800-01-01',NULL,0),
	(2901,23,'Imer',0,'1800-01-01',NULL,0),
	(2902,23,'Isera',0,'1800-01-01',NULL,0),
	(2903,23,'Ivano-Fracena',0,'1800-01-01',NULL,0),
	(2904,23,'Lardaro',0,'1800-01-01',NULL,0),
	(2905,23,'Lasino',0,'1800-01-01',NULL,0),
	(2906,23,'Lavarone',0,'1800-01-01',NULL,0),
	(2907,23,'Lavis',0,'1800-01-01',NULL,0),
	(2908,23,'Levico Terme',0,'1800-01-01',NULL,0),
	(2909,23,'Lisignago',0,'1800-01-01',NULL,0),
	(2910,23,'Livo',0,'1800-01-01',NULL,0),
	(2911,23,'Lona-Lases',0,'1800-01-01',NULL,0),
	(2912,23,'Luserna',0,'1800-01-01',NULL,0),
	(2913,23,'Malè',0,'1800-01-01',NULL,0),
	(2914,23,'Malosco',0,'1800-01-01',NULL,0),
	(2915,23,'Massimeno',0,'1800-01-01',NULL,0),
	(2916,23,'Mazzin',0,'1800-01-01',NULL,0),
	(2917,23,'Mezzana',0,'1800-01-01',NULL,0),
	(2918,23,'Mezzano',0,'1800-01-01',NULL,0),
	(2919,23,'Mezzocorona',0,'1800-01-01',NULL,0),
	(2920,23,'Mezzolombardo',0,'1800-01-01',NULL,0),
	(2921,23,'Moena',0,'1800-01-01',NULL,0),
	(2922,23,'Molveno',0,'1800-01-01',NULL,0),
	(2923,23,'Monclassico',0,'1800-01-01',NULL,0),
	(2924,23,'Montagne',0,'1800-01-01',NULL,0),
	(2925,23,'Mori',0,'1800-01-01',NULL,0),
	(2926,23,'Nago-Torbole',0,'1800-01-01',NULL,0),
	(2927,23,'Nanno',0,'1800-01-01',NULL,0),
	(2928,23,'Nave San Rocco',0,'1800-01-01',NULL,0),
	(2929,23,'Nogaredo',0,'1800-01-01',NULL,0),
	(2930,23,'Nomi',0,'1800-01-01',NULL,0),
	(2931,23,'Novaledo',0,'1800-01-01',NULL,0),
	(2932,23,'Ospedaletto',0,'1800-01-01',NULL,0),
	(2933,23,'Ossana',0,'1800-01-01',NULL,0),
	(2934,23,'Padergnone',0,'1800-01-01',NULL,0),
	(2935,23,'Palù del Fersina',0,'1800-01-01',NULL,0),
	(2936,23,'Panchià',0,'1800-01-01',NULL,0),
	(2937,23,'Ronzo-Chienis',0,'1800-01-01',NULL,0),
	(2938,23,'Peio',0,'1800-01-01',NULL,0),
	(2939,23,'Pellizzano',0,'1800-01-01',NULL,0),
	(2940,23,'Pelugo',0,'1800-01-01',NULL,0),
	(2941,23,'Pergine Valsugana',0,'1800-01-01',NULL,0),
	(2942,23,'Pieve di Bono',0,'1800-01-01',NULL,0),
	(2943,23,'Pieve Tesino',0,'1800-01-01',NULL,0),
	(2944,23,'Pinzolo',0,'1800-01-01',NULL,0),
	(2945,23,'Pomarolo',0,'1800-01-01',NULL,0),
	(2946,23,'Pozza di Fassa',0,'1800-01-01',NULL,0),
	(2947,23,'Praso',0,'1800-01-01',NULL,0),
	(2948,23,'Predazzo',0,'1800-01-01',NULL,0),
	(2949,23,'Preore',0,'1800-01-01',NULL,0),
	(2950,23,'Prezzo',0,'1800-01-01',NULL,0),
	(2951,23,'Rabbi',0,'1800-01-01',NULL,0),
	(2952,23,'Ragoli',0,'1800-01-01',NULL,0),
	(2953,23,'Revò',0,'1800-01-01',NULL,0),
	(2954,23,'Riva del Garda',0,'1800-01-01',NULL,0),
	(2955,23,'Romallo',0,'1800-01-01',NULL,0),
	(2956,23,'Romeno',0,'1800-01-01',NULL,0),
	(2957,23,'Roncegno Terme',0,'1800-01-01',NULL,0),
	(2958,23,'Ronchi Valsugana',0,'1800-01-01',NULL,0),
	(2959,23,'Roncone',0,'1800-01-01',NULL,0),
	(2960,23,'Ronzone',0,'1800-01-01',NULL,0),
	(2961,23,'Roverè della Luna',0,'1800-01-01',NULL,0),
	(2962,23,'Rovereto',0,'1800-01-01',NULL,0),
	(2963,23,'Ruffrè-Mendola',0,'1800-01-01',NULL,0),
	(2964,23,'Rumo',0,'1800-01-01',NULL,0),
	(2965,23,'Sagron Mis',0,'1800-01-01',NULL,0),
	(2966,23,'Samone',0,'1800-01-01',NULL,0),
	(2967,23,'San Lorenzo in Banale',0,'1800-01-01',NULL,0),
	(2968,23,'San Michele all\'Adige',0,'1800-01-01',NULL,0),
	(2969,23,'Sant\'Orsola Terme',0,'1800-01-01',NULL,0),
	(2970,23,'Sanzeno',0,'1800-01-01',NULL,0),
	(2971,23,'Sarnonico',0,'1800-01-01',NULL,0),
	(2972,23,'Scurelle',0,'1800-01-01',NULL,0),
	(2973,23,'Segonzano',0,'1800-01-01',NULL,0),
	(2974,23,'Sfruz',0,'1800-01-01',NULL,0),
	(2975,23,'Siror',0,'1800-01-01',NULL,0),
	(2976,23,'Smarano',0,'1800-01-01',NULL,0),
	(2977,23,'Soraga',0,'1800-01-01',NULL,0),
	(2978,23,'Sover',0,'1800-01-01',NULL,0),
	(2979,23,'Spera',0,'1800-01-01',NULL,0),
	(2980,23,'Spiazzo',0,'1800-01-01',NULL,0),
	(2981,23,'Spormaggiore',0,'1800-01-01',NULL,0),
	(2982,23,'Sporminore',0,'1800-01-01',NULL,0),
	(2983,23,'Stenico',0,'1800-01-01',NULL,0),
	(2984,23,'Storo',0,'1800-01-01',NULL,0),
	(2985,23,'Strembo',0,'1800-01-01',NULL,0),
	(2986,23,'Strigno',0,'1800-01-01',NULL,0),
	(2987,23,'Taio',0,'1800-01-01',NULL,0),
	(2988,23,'Tassullo',0,'1800-01-01',NULL,0),
	(2989,23,'Telve',0,'1800-01-01',NULL,0),
	(2990,23,'Telve di Sopra',0,'1800-01-01',NULL,0),
	(2991,23,'Tenna',0,'1800-01-01',NULL,0),
	(2992,23,'Tenno',0,'1800-01-01',NULL,0),
	(2993,23,'Terlago',0,'1800-01-01',NULL,0),
	(2994,23,'Terragnolo',0,'1800-01-01',NULL,0),
	(2995,23,'Terres',0,'1800-01-01',NULL,0),
	(2996,23,'Terzolas',0,'1800-01-01',NULL,0),
	(2997,23,'Tesero',0,'1800-01-01',NULL,0),
	(2998,23,'Tione di Trento',0,'1800-01-01',NULL,0),
	(2999,23,'Ton',0,'1800-01-01',NULL,0),
	(3000,23,'Tonadico',0,'1800-01-01',NULL,0),
	(3001,23,'Torcegno',0,'1800-01-01',NULL,0),
	(3002,23,'Trambileno',0,'1800-01-01',NULL,0),
	(3003,23,'Transacqua',0,'1800-01-01',NULL,0),
	(3004,23,'Trento',1,'1800-01-01',NULL,0),
	(3005,23,'Tres',0,'1800-01-01',NULL,0),
	(3006,23,'Tuenno',0,'1800-01-01',NULL,0),
	(3007,23,'Valda',0,'1800-01-01',NULL,0),
	(3008,23,'Valfloriana',0,'1800-01-01',NULL,0),
	(3009,23,'Vallarsa',0,'1800-01-01',NULL,0),
	(3010,23,'Varena',0,'1800-01-01',NULL,0),
	(3011,23,'Vattaro',0,'1800-01-01',NULL,0),
	(3012,23,'Vermiglio',0,'1800-01-01',NULL,0),
	(3013,23,'Vervò',0,'1800-01-01',NULL,0),
	(3014,23,'Vezzano',0,'1800-01-01',NULL,0),
	(3015,23,'Vignola-Falesina',0,'1800-01-01',NULL,0),
	(3016,23,'Vigo di Fassa',0,'1800-01-01',NULL,0),
	(3017,23,'Vigolo Vattaro',0,'1800-01-01',NULL,0),
	(3018,23,'Vigo Rendena',0,'1800-01-01',NULL,0),
	(3019,23,'Villa Agnedo',0,'1800-01-01',NULL,0),
	(3020,23,'Villa Lagarina',0,'1800-01-01',NULL,0),
	(3021,23,'Villa Rendena',0,'1800-01-01',NULL,0),
	(3022,23,'Volano',0,'1800-01-01',NULL,0),
	(3023,23,'Zambana',0,'1800-01-01',NULL,0),
	(3024,23,'Ziano di Fiemme',0,'1800-01-01',NULL,0),
	(3025,23,'Zuclo',0,'1800-01-01',NULL,0),
	(3026,23,'Comano Terme',0,'1800-01-01',NULL,0),
	(3027,23,'Ledro',0,'1800-01-01',NULL,0),
	(3028,24,'Affi',0,'1800-01-01',NULL,0),
	(3029,24,'Albaredo d\'Adige',0,'1800-01-01',NULL,0),
	(3030,24,'Angiari',0,'1800-01-01',NULL,0),
	(3031,24,'Arcole',0,'1800-01-01',NULL,0),
	(3032,24,'Badia Calavena',0,'1800-01-01',NULL,0),
	(3033,24,'Bardolino',0,'1800-01-01',NULL,0),
	(3034,24,'Belfiore',0,'1800-01-01',NULL,0),
	(3035,24,'Bevilacqua',0,'1800-01-01',NULL,0),
	(3036,24,'Bonavigo',0,'1800-01-01',NULL,0),
	(3037,24,'Boschi Sant\'Anna',0,'1800-01-01',NULL,0),
	(3038,24,'Bosco Chiesanuova',0,'1800-01-01',NULL,0),
	(3039,24,'Bovolone',0,'1800-01-01',NULL,0),
	(3040,24,'Brentino Belluno',0,'1800-01-01',NULL,0),
	(3041,24,'Brenzone',0,'1800-01-01',NULL,0),
	(3042,24,'Bussolengo',0,'1800-01-01',NULL,0),
	(3043,24,'Buttapietra',0,'1800-01-01',NULL,0),
	(3044,24,'Caldiero',0,'1800-01-01',NULL,0),
	(3045,24,'Caprino Veronese',0,'1800-01-01',NULL,0),
	(3046,24,'Casaleone',0,'1800-01-01',NULL,0),
	(3047,24,'Castagnaro',0,'1800-01-01',NULL,0),
	(3048,24,'Castel d\'Azzano',0,'1800-01-01',NULL,0),
	(3049,24,'Castelnuovo del Garda',0,'1800-01-01',NULL,0),
	(3050,24,'Cavaion Veronese',0,'1800-01-01',NULL,0),
	(3051,24,'Cazzano di Tramigna',0,'1800-01-01',NULL,0),
	(3052,24,'Cerea',0,'1800-01-01',NULL,0),
	(3053,24,'Cerro Veronese',0,'1800-01-01',NULL,0),
	(3054,24,'Cologna Veneta',0,'1800-01-01',NULL,0),
	(3055,24,'Colognola ai Colli',0,'1800-01-01',NULL,0),
	(3056,24,'Concamarise',0,'1800-01-01',NULL,0),
	(3057,24,'Costermano',0,'1800-01-01',NULL,0),
	(3058,24,'Dolcè',0,'1800-01-01',NULL,0),
	(3059,24,'Erbè',0,'1800-01-01',NULL,0),
	(3060,24,'Erbezzo',0,'1800-01-01',NULL,0),
	(3061,24,'Ferrara di Monte Baldo',0,'1800-01-01',NULL,0),
	(3062,24,'Fumane',0,'1800-01-01',NULL,0),
	(3063,24,'Garda',0,'1800-01-01',NULL,0),
	(3064,24,'Gazzo Veronese',0,'1800-01-01',NULL,0),
	(3065,24,'Grezzana',0,'1800-01-01',NULL,0),
	(3066,24,'Illasi',0,'1800-01-01',NULL,0),
	(3067,24,'Isola della Scala',0,'1800-01-01',NULL,0),
	(3068,24,'Isola Rizza',0,'1800-01-01',NULL,0),
	(3069,24,'Lavagno',0,'1800-01-01',NULL,0),
	(3070,24,'Lazise',0,'1800-01-01',NULL,0),
	(3071,24,'Legnago',0,'1800-01-01',NULL,0),
	(3072,24,'Malcesine',0,'1800-01-01',NULL,0),
	(3073,24,'Marano di Valpolicella',0,'1800-01-01',NULL,0),
	(3074,24,'Mezzane di Sotto',0,'1800-01-01',NULL,0),
	(3075,24,'Minerbe',0,'1800-01-01',NULL,0),
	(3076,24,'Montecchia di Crosara',0,'1800-01-01',NULL,0),
	(3077,24,'Monteforte d\'Alpone',0,'1800-01-01',NULL,0),
	(3078,24,'Mozzecane',0,'1800-01-01',NULL,0),
	(3079,24,'Negrar',0,'1800-01-01',NULL,0),
	(3080,24,'Nogara',0,'1800-01-01',NULL,0),
	(3081,24,'Nogarole Rocca',0,'1800-01-01',NULL,0),
	(3082,24,'Oppeano',0,'1800-01-01',NULL,0),
	(3083,24,'Palù',0,'1800-01-01',NULL,0),
	(3084,24,'Pastrengo',0,'1800-01-01',NULL,0),
	(3085,24,'Pescantina',0,'1800-01-01',NULL,0),
	(3086,24,'Peschiera del Garda',0,'1800-01-01',NULL,0),
	(3087,24,'Povegliano Veronese',0,'1800-01-01',NULL,0),
	(3088,24,'Pressana',0,'1800-01-01',NULL,0),
	(3089,24,'Rivoli Veronese',0,'1800-01-01',NULL,0),
	(3090,24,'Roncà',0,'1800-01-01',NULL,0),
	(3091,24,'Ronco all\'Adige',0,'1800-01-01',NULL,0),
	(3092,24,'Roverchiara',0,'1800-01-01',NULL,0),
	(3093,24,'Roveredo di Guà',0,'1800-01-01',NULL,0),
	(3094,24,'Roverè Veronese',0,'1800-01-01',NULL,0),
	(3095,24,'Salizzole',0,'1800-01-01',NULL,0),
	(3096,24,'San Bonifacio',0,'1800-01-01',NULL,0),
	(3097,24,'San Giovanni Ilarione',0,'1800-01-01',NULL,0),
	(3098,24,'San Giovanni Lupatoto',0,'1800-01-01',NULL,0),
	(3099,24,'Sanguinetto',0,'1800-01-01',NULL,0),
	(3100,24,'San Martino Buon Albergo',0,'1800-01-01',NULL,0),
	(3101,24,'San Mauro di Saline',0,'1800-01-01',NULL,0),
	(3102,24,'San Pietro di Morubio',0,'1800-01-01',NULL,0),
	(3103,24,'San Pietro in Cariano',0,'1800-01-01',NULL,0),
	(3104,24,'Sant\'Ambrogio di Valpolicella',0,'1800-01-01',NULL,0),
	(3105,24,'Sant\'Anna d\'Alfaedo',0,'1800-01-01',NULL,0),
	(3106,24,'San Zeno di Montagna',0,'1800-01-01',NULL,0),
	(3107,24,'Selva di Progno',0,'1800-01-01',NULL,0),
	(3108,24,'Soave',0,'1800-01-01',NULL,0),
	(3109,24,'Sommacampagna',0,'1800-01-01',NULL,0),
	(3110,24,'Sona',0,'1800-01-01',NULL,0),
	(3111,24,'Sorgà',0,'1800-01-01',NULL,0),
	(3112,24,'Terrazzo',0,'1800-01-01',NULL,0),
	(3113,24,'Torri del Benaco',0,'1800-01-01',NULL,0),
	(3114,24,'Tregnago',0,'1800-01-01',NULL,0),
	(3115,24,'Trevenzuolo',0,'1800-01-01',NULL,0),
	(3116,24,'Valeggio sul Mincio',0,'1800-01-01',NULL,0),
	(3117,24,'Velo Veronese',0,'1800-01-01',NULL,0),
	(3118,24,'Verona',1,'1800-01-01',NULL,0),
	(3119,24,'Veronella',0,'1800-01-01',NULL,0),
	(3120,24,'Vestenanova',0,'1800-01-01',NULL,0),
	(3121,24,'Vigasio',0,'1800-01-01',NULL,0),
	(3122,24,'Villa Bartolomea',0,'1800-01-01',NULL,0),
	(3123,24,'Villafranca di Verona',0,'1800-01-01',NULL,0),
	(3124,24,'Zevio',0,'1800-01-01',NULL,0),
	(3125,24,'Zimella',0,'1800-01-01',NULL,0),
	(3126,25,'Agugliaro',0,'1800-01-01',NULL,0),
	(3127,25,'Albettone',0,'1800-01-01',NULL,0),
	(3128,25,'Alonte',0,'1800-01-01',NULL,0),
	(3129,25,'Altavilla Vicentina',0,'1800-01-01',NULL,0),
	(3130,25,'Altissimo',0,'1800-01-01',NULL,0),
	(3131,25,'Arcugnano',0,'1800-01-01',NULL,0),
	(3132,25,'Arsiero',0,'1800-01-01',NULL,0),
	(3133,25,'Arzignano',0,'1800-01-01',NULL,0),
	(3134,25,'Asiago',0,'1800-01-01',NULL,0),
	(3135,25,'Asigliano Veneto',0,'1800-01-01',NULL,0),
	(3136,25,'Barbarano Vicentino',0,'1800-01-01',NULL,0),
	(3137,25,'Bassano del Grappa',0,'1800-01-01',NULL,0),
	(3138,25,'Bolzano Vicentino',0,'1800-01-01',NULL,0),
	(3139,25,'Breganze',0,'1800-01-01',NULL,0),
	(3140,25,'Brendola',0,'1800-01-01',NULL,0),
	(3141,25,'Bressanvido',0,'1800-01-01',NULL,0),
	(3142,25,'Brogliano',0,'1800-01-01',NULL,0),
	(3143,25,'Caldogno',0,'1800-01-01',NULL,0),
	(3144,25,'Caltrano',0,'1800-01-01',NULL,0),
	(3145,25,'Calvene',0,'1800-01-01',NULL,0),
	(3146,25,'Camisano Vicentino',0,'1800-01-01',NULL,0),
	(3147,25,'Campiglia dei Berici',0,'1800-01-01',NULL,0),
	(3148,25,'Campolongo sul Brenta',0,'1800-01-01',NULL,0),
	(3149,25,'Carrè',0,'1800-01-01',NULL,0),
	(3150,25,'Cartigliano',0,'1800-01-01',NULL,0),
	(3151,25,'Cassola',0,'1800-01-01',NULL,0),
	(3152,25,'Castegnero',0,'1800-01-01',NULL,0),
	(3153,25,'Castelgomberto',0,'1800-01-01',NULL,0),
	(3154,25,'Chiampo',0,'1800-01-01',NULL,0),
	(3155,25,'Chiuppano',0,'1800-01-01',NULL,0),
	(3156,25,'Cismon del Grappa',0,'1800-01-01',NULL,0),
	(3157,25,'Cogollo del Cengio',0,'1800-01-01',NULL,0),
	(3158,25,'Conco',0,'1800-01-01',NULL,0),
	(3159,25,'Cornedo Vicentino',0,'1800-01-01',NULL,0),
	(3160,25,'Costabissara',0,'1800-01-01',NULL,0),
	(3161,25,'Creazzo',0,'1800-01-01',NULL,0),
	(3162,25,'Crespadoro',0,'1800-01-01',NULL,0),
	(3163,25,'Dueville',0,'1800-01-01',NULL,0),
	(3164,25,'Enego',0,'1800-01-01',NULL,0),
	(3165,25,'Fara Vicentino',0,'1800-01-01',NULL,0),
	(3166,25,'Foza',0,'1800-01-01',NULL,0),
	(3167,25,'Gallio',0,'1800-01-01',NULL,0),
	(3168,25,'Gambellara',0,'1800-01-01',NULL,0),
	(3169,25,'Gambugliano',0,'1800-01-01',NULL,0),
	(3170,25,'Grancona',0,'1800-01-01',NULL,0),
	(3171,25,'Grisignano di Zocco',0,'1800-01-01',NULL,0),
	(3172,25,'Grumolo delle Abbadesse',0,'1800-01-01',NULL,0),
	(3173,25,'Isola Vicentina',0,'1800-01-01',NULL,0),
	(3174,25,'Laghi',0,'1800-01-01',NULL,0),
	(3175,25,'Lastebasse',0,'1800-01-01',NULL,0),
	(3176,25,'Longare',0,'1800-01-01',NULL,0),
	(3177,25,'Lonigo',0,'1800-01-01',NULL,0),
	(3178,25,'Lugo di Vicenza',0,'1800-01-01',NULL,0),
	(3179,25,'Lusiana',0,'1800-01-01',NULL,0),
	(3180,25,'Malo',0,'1800-01-01',NULL,0),
	(3181,25,'Marano Vicentino',0,'1800-01-01',NULL,0),
	(3182,25,'Marostica',0,'1800-01-01',NULL,0),
	(3183,25,'Mason Vicentino',0,'1800-01-01',NULL,0),
	(3184,25,'Molvena',0,'1800-01-01',NULL,0),
	(3185,25,'Montebello Vicentino',0,'1800-01-01',NULL,0),
	(3186,25,'Montecchio Maggiore',0,'1800-01-01',NULL,0),
	(3187,25,'Montecchio Precalcino',0,'1800-01-01',NULL,0),
	(3188,25,'Monte di Malo',0,'1800-01-01',NULL,0),
	(3189,25,'Montegalda',0,'1800-01-01',NULL,0),
	(3190,25,'Montegaldella',0,'1800-01-01',NULL,0),
	(3191,25,'Monteviale',0,'1800-01-01',NULL,0),
	(3192,25,'Monticello Conte Otto',0,'1800-01-01',NULL,0),
	(3193,25,'Montorso Vicentino',0,'1800-01-01',NULL,0),
	(3194,25,'Mossano',0,'1800-01-01',NULL,0),
	(3195,25,'Mussolente',0,'1800-01-01',NULL,0),
	(3196,25,'Nanto',0,'1800-01-01',NULL,0),
	(3197,25,'Nogarole Vicentino',0,'1800-01-01',NULL,0),
	(3198,25,'Nove',0,'1800-01-01',NULL,0),
	(3199,25,'Noventa Vicentina',0,'1800-01-01',NULL,0),
	(3200,25,'Orgiano',0,'1800-01-01',NULL,0),
	(3201,25,'Pedemonte',0,'1800-01-01',NULL,0),
	(3202,25,'Pianezze',0,'1800-01-01',NULL,0),
	(3203,25,'Piovene Rocchette',0,'1800-01-01',NULL,0),
	(3204,25,'Pojana Maggiore',0,'1800-01-01',NULL,0),
	(3205,25,'Posina',0,'1800-01-01',NULL,0),
	(3206,25,'Pove del Grappa',0,'1800-01-01',NULL,0),
	(3207,25,'Pozzoleone',0,'1800-01-01',NULL,0),
	(3208,25,'Quinto Vicentino',0,'1800-01-01',NULL,0),
	(3209,25,'Recoaro Terme',0,'1800-01-01',NULL,0),
	(3210,25,'Roana',0,'1800-01-01',NULL,0),
	(3211,25,'Romano d\'Ezzelino',0,'1800-01-01',NULL,0),
	(3212,25,'Rosà',0,'1800-01-01',NULL,0),
	(3213,25,'Rossano Veneto',0,'1800-01-01',NULL,0),
	(3214,25,'Rotzo',0,'1800-01-01',NULL,0),
	(3215,25,'Salcedo',0,'1800-01-01',NULL,0),
	(3216,25,'Sandrigo',0,'1800-01-01',NULL,0),
	(3217,25,'San Germano dei Berici',0,'1800-01-01',NULL,0),
	(3218,25,'San Nazario',0,'1800-01-01',NULL,0),
	(3219,25,'San Pietro Mussolino',0,'1800-01-01',NULL,0),
	(3220,25,'Santorso',0,'1800-01-01',NULL,0),
	(3221,25,'San Vito di Leguzzano',0,'1800-01-01',NULL,0),
	(3222,25,'Sarcedo',0,'1800-01-01',NULL,0),
	(3223,25,'Sarego',0,'1800-01-01',NULL,0),
	(3224,25,'Schiavon',0,'1800-01-01',NULL,0),
	(3225,25,'Schio',0,'1800-01-01',NULL,0),
	(3226,25,'Solagna',0,'1800-01-01',NULL,0),
	(3227,25,'Sossano',0,'1800-01-01',NULL,0),
	(3228,25,'Sovizzo',0,'1800-01-01',NULL,0),
	(3229,25,'Tezze sul Brenta',0,'1800-01-01',NULL,0),
	(3230,25,'Thiene',0,'1800-01-01',NULL,0),
	(3231,25,'Tonezza del Cimone',0,'1800-01-01',NULL,0),
	(3232,25,'Torrebelvicino',0,'1800-01-01',NULL,0),
	(3233,25,'Torri di Quartesolo',0,'1800-01-01',NULL,0),
	(3234,25,'Trissino',0,'1800-01-01',NULL,0),
	(3235,25,'Valdagno',0,'1800-01-01',NULL,0),
	(3236,25,'Valdastico',0,'1800-01-01',NULL,0),
	(3237,25,'Valli del Pasubio',0,'1800-01-01',NULL,0),
	(3238,25,'Valstagna',0,'1800-01-01',NULL,0),
	(3239,25,'Velo d\'Astico',0,'1800-01-01',NULL,0),
	(3240,25,'Vicenza',1,'1800-01-01',NULL,0),
	(3241,25,'Villaga',0,'1800-01-01',NULL,0),
	(3242,25,'Villaverla',0,'1800-01-01',NULL,0),
	(3243,25,'Zanè',0,'1800-01-01',NULL,0),
	(3244,25,'Zermeghedo',0,'1800-01-01',NULL,0),
	(3245,25,'Zovencedo',0,'1800-01-01',NULL,0),
	(3246,25,'Zugliano',0,'1800-01-01',NULL,0),
	(3247,26,'Agordo',0,'1800-01-01',NULL,0),
	(3248,26,'Alano di Piave',0,'1800-01-01',NULL,0),
	(3249,26,'Alleghe',0,'1800-01-01',NULL,0),
	(3250,26,'Arsiè',0,'1800-01-01',NULL,0),
	(3251,26,'Auronzo di Cadore',0,'1800-01-01',NULL,0),
	(3252,26,'Belluno',1,'1800-01-01',NULL,0),
	(3253,26,'Borca di Cadore',0,'1800-01-01',NULL,0),
	(3254,26,'Calalzo di Cadore',0,'1800-01-01',NULL,0),
	(3255,26,'Castellavazzo',0,'1800-01-01',NULL,0),
	(3256,26,'Cencenighe Agordino',0,'1800-01-01',NULL,0),
	(3257,26,'Cesiomaggiore',0,'1800-01-01',NULL,0),
	(3258,26,'Chies d\'Alpago',0,'1800-01-01',NULL,0),
	(3259,26,'Cibiana di Cadore',0,'1800-01-01',NULL,0),
	(3260,26,'Colle Santa Lucia',0,'1800-01-01',NULL,0),
	(3261,26,'Comelico Superiore',0,'1800-01-01',NULL,0),
	(3262,26,'Cortina d\'Ampezzo',0,'1800-01-01',NULL,0),
	(3263,26,'Danta di Cadore',0,'1800-01-01',NULL,0),
	(3264,26,'Domegge di Cadore',0,'1800-01-01',NULL,0),
	(3265,26,'Falcade',0,'1800-01-01',NULL,0),
	(3266,26,'Farra d\'Alpago',0,'1800-01-01',NULL,0),
	(3267,26,'Feltre',0,'1800-01-01',NULL,0),
	(3268,26,'Fonzaso',0,'1800-01-01',NULL,0),
	(3269,26,'Canale d\'Agordo',0,'1800-01-01',NULL,0),
	(3270,26,'Forno di Zoldo',0,'1800-01-01',NULL,0),
	(3271,26,'Gosaldo',0,'1800-01-01',NULL,0),
	(3272,26,'Lamon',0,'1800-01-01',NULL,0),
	(3273,26,'La Valle Agordina',0,'1800-01-01',NULL,0),
	(3274,26,'Lentiai',0,'1800-01-01',NULL,0),
	(3275,26,'Limana',0,'1800-01-01',NULL,0),
	(3276,26,'Livinallongo del Col di Lana',0,'1800-01-01',NULL,0),
	(3277,26,'Longarone',0,'1800-01-01',NULL,0),
	(3278,26,'Lorenzago di Cadore',0,'1800-01-01',NULL,0),
	(3279,26,'Lozzo di Cadore',0,'1800-01-01',NULL,0),
	(3280,26,'Mel',0,'1800-01-01',NULL,0),
	(3281,26,'Ospitale di Cadore',0,'1800-01-01',NULL,0),
	(3282,26,'Pedavena',0,'1800-01-01',NULL,0),
	(3283,26,'Perarolo di Cadore',0,'1800-01-01',NULL,0),
	(3284,26,'Pieve d\'Alpago',0,'1800-01-01',NULL,0),
	(3285,26,'Pieve di Cadore',0,'1800-01-01',NULL,0),
	(3286,26,'Ponte nelle Alpi',0,'1800-01-01',NULL,0),
	(3287,26,'Puos d\'Alpago',0,'1800-01-01',NULL,0),
	(3288,26,'Quero',0,'1800-01-01',NULL,0),
	(3289,26,'Rivamonte Agordino',0,'1800-01-01',NULL,0),
	(3290,26,'Rocca Pietore',0,'1800-01-01',NULL,0),
	(3291,26,'San Gregorio nelle Alpi',0,'1800-01-01',NULL,0),
	(3292,26,'San Nicolò di Comelico',0,'1800-01-01',NULL,0),
	(3293,26,'San Pietro di Cadore',0,'1800-01-01',NULL,0),
	(3294,26,'Santa Giustina',0,'1800-01-01',NULL,0),
	(3295,26,'San Tomaso Agordino',0,'1800-01-01',NULL,0),
	(3296,26,'Santo Stefano di Cadore',0,'1800-01-01',NULL,0),
	(3297,26,'San Vito di Cadore',0,'1800-01-01',NULL,0),
	(3298,26,'Sappada',0,'1800-01-01',NULL,0),
	(3299,26,'Sedico',0,'1800-01-01',NULL,0),
	(3300,26,'Selva di Cadore',0,'1800-01-01',NULL,0),
	(3301,26,'Seren del Grappa',0,'1800-01-01',NULL,0),
	(3302,26,'Sospirolo',0,'1800-01-01',NULL,0),
	(3303,26,'Soverzene',0,'1800-01-01',NULL,0),
	(3304,26,'Sovramonte',0,'1800-01-01',NULL,0),
	(3305,26,'Taibon Agordino',0,'1800-01-01',NULL,0),
	(3306,26,'Tambre',0,'1800-01-01',NULL,0),
	(3307,26,'Trichiana',0,'1800-01-01',NULL,0),
	(3308,26,'Vallada Agordina',0,'1800-01-01',NULL,0),
	(3309,26,'Valle di Cadore',0,'1800-01-01',NULL,0),
	(3310,26,'Vas',0,'1800-01-01',NULL,0),
	(3311,26,'Vigo di Cadore',0,'1800-01-01',NULL,0),
	(3312,26,'Vodo Cadore',0,'1800-01-01',NULL,0),
	(3313,26,'Voltago Agordino',0,'1800-01-01',NULL,0),
	(3314,26,'Zoldo Alto',0,'1800-01-01',NULL,0),
	(3315,26,'Zoppè di Cadore',0,'1800-01-01',NULL,0),
	(3316,27,'Altivole',0,'1800-01-01',NULL,0),
	(3317,27,'Arcade',0,'1800-01-01',NULL,0),
	(3318,27,'Asolo',0,'1800-01-01',NULL,0),
	(3319,27,'Borso del Grappa',0,'1800-01-01',NULL,0),
	(3320,27,'Breda di Piave',0,'1800-01-01',NULL,0),
	(3321,27,'Caerano di San Marco',0,'1800-01-01',NULL,0),
	(3322,27,'Cappella Maggiore',0,'1800-01-01',NULL,0),
	(3323,27,'Carbonera',0,'1800-01-01',NULL,0),
	(3324,27,'Casale sul Sile',0,'1800-01-01',NULL,0),
	(3325,27,'Casier',0,'1800-01-01',NULL,0),
	(3326,27,'Castelcucco',0,'1800-01-01',NULL,0),
	(3327,27,'Castelfranco Veneto',0,'1800-01-01',NULL,0),
	(3328,27,'Castello di Godego',0,'1800-01-01',NULL,0),
	(3329,27,'Cavaso del Tomba',0,'1800-01-01',NULL,0),
	(3330,27,'Cessalto',0,'1800-01-01',NULL,0),
	(3331,27,'Chiarano',0,'1800-01-01',NULL,0),
	(3332,27,'Cimadolmo',0,'1800-01-01',NULL,0),
	(3333,27,'Cison di Valmarino',0,'1800-01-01',NULL,0),
	(3334,27,'Codognè',0,'1800-01-01',NULL,0),
	(3335,27,'Colle Umberto',0,'1800-01-01',NULL,0),
	(3336,27,'Conegliano',0,'1800-01-01',NULL,0),
	(3337,27,'Cordignano',0,'1800-01-01',NULL,0),
	(3338,27,'Cornuda',0,'1800-01-01',NULL,0),
	(3339,27,'Crespano del Grappa',0,'1800-01-01',NULL,0),
	(3340,27,'Crocetta del Montello',0,'1800-01-01',NULL,0),
	(3341,27,'Farra di Soligo',0,'1800-01-01',NULL,0),
	(3342,27,'Follina',0,'1800-01-01',NULL,0),
	(3343,27,'Fontanelle',0,'1800-01-01',NULL,0),
	(3344,27,'Fonte',0,'1800-01-01',NULL,0),
	(3345,27,'Fregona',0,'1800-01-01',NULL,0),
	(3346,27,'Gaiarine',0,'1800-01-01',NULL,0),
	(3347,27,'Giavera del Montello',0,'1800-01-01',NULL,0),
	(3348,27,'Godega di Sant\'Urbano',0,'1800-01-01',NULL,0),
	(3349,27,'Gorgo al Monticano',0,'1800-01-01',NULL,0),
	(3350,27,'Istrana',0,'1800-01-01',NULL,0),
	(3351,27,'Loria',0,'1800-01-01',NULL,0),
	(3352,27,'Mansuè',0,'1800-01-01',NULL,0),
	(3353,27,'Mareno di Piave',0,'1800-01-01',NULL,0),
	(3354,27,'Maser',0,'1800-01-01',NULL,0),
	(3355,27,'Maserada sul Piave',0,'1800-01-01',NULL,0),
	(3356,27,'Meduna di Livenza',0,'1800-01-01',NULL,0),
	(3357,27,'Miane',0,'1800-01-01',NULL,0),
	(3358,27,'Mogliano Veneto',0,'1800-01-01',NULL,0),
	(3359,27,'Monastier di Treviso',0,'1800-01-01',NULL,0),
	(3360,27,'Monfumo',0,'1800-01-01',NULL,0),
	(3361,27,'Montebelluna',0,'1800-01-01',NULL,0),
	(3362,27,'Morgano',0,'1800-01-01',NULL,0),
	(3363,27,'Moriago della Battaglia',0,'1800-01-01',NULL,0),
	(3364,27,'Motta di Livenza',0,'1800-01-01',NULL,0),
	(3365,27,'Nervesa della Battaglia',0,'1800-01-01',NULL,0),
	(3366,27,'Oderzo',0,'1800-01-01',NULL,0),
	(3367,27,'Ormelle',0,'1800-01-01',NULL,0),
	(3368,27,'Orsago',0,'1800-01-01',NULL,0),
	(3369,27,'Paderno del Grappa',0,'1800-01-01',NULL,0),
	(3370,27,'Paese',0,'1800-01-01',NULL,0),
	(3371,27,'Pederobba',0,'1800-01-01',NULL,0),
	(3372,27,'Pieve di Soligo',0,'1800-01-01',NULL,0),
	(3373,27,'Ponte di Piave',0,'1800-01-01',NULL,0),
	(3374,27,'Ponzano Veneto',0,'1800-01-01',NULL,0),
	(3375,27,'Portobuffolè',0,'1800-01-01',NULL,0),
	(3376,27,'Possagno',0,'1800-01-01',NULL,0),
	(3377,27,'Povegliano',0,'1800-01-01',NULL,0),
	(3378,27,'Preganziol',0,'1800-01-01',NULL,0),
	(3379,27,'Quinto di Treviso',0,'1800-01-01',NULL,0),
	(3380,27,'Refrontolo',0,'1800-01-01',NULL,0),
	(3381,27,'Resana',0,'1800-01-01',NULL,0),
	(3382,27,'Revine Lago',0,'1800-01-01',NULL,0),
	(3383,27,'Riese Pio X',0,'1800-01-01',NULL,0),
	(3384,27,'Roncade',0,'1800-01-01',NULL,0),
	(3385,27,'Salgareda',0,'1800-01-01',NULL,0),
	(3386,27,'San Biagio di Callalta',0,'1800-01-01',NULL,0),
	(3387,27,'San Fior',0,'1800-01-01',NULL,0),
	(3388,27,'San Pietro di Feletto',0,'1800-01-01',NULL,0),
	(3389,27,'San Polo di Piave',0,'1800-01-01',NULL,0),
	(3390,27,'Santa Lucia di Piave',0,'1800-01-01',NULL,0),
	(3391,27,'San Vendemiano',0,'1800-01-01',NULL,0),
	(3392,27,'San Zenone degli Ezzelini',0,'1800-01-01',NULL,0),
	(3393,27,'Sarmede',0,'1800-01-01',NULL,0),
	(3394,27,'Segusino',0,'1800-01-01',NULL,0),
	(3395,27,'Sernaglia della Battaglia',0,'1800-01-01',NULL,0),
	(3396,27,'Silea',0,'1800-01-01',NULL,0),
	(3397,27,'Spresiano',0,'1800-01-01',NULL,0),
	(3398,27,'Susegana',0,'1800-01-01',NULL,0),
	(3399,27,'Tarzo',0,'1800-01-01',NULL,0),
	(3400,27,'Trevignano',0,'1800-01-01',NULL,0),
	(3401,27,'Treviso',1,'1800-01-01',NULL,0),
	(3402,27,'Valdobbiadene',0,'1800-01-01',NULL,0),
	(3403,27,'Vazzola',0,'1800-01-01',NULL,0),
	(3404,27,'Vedelago',0,'1800-01-01',NULL,0),
	(3405,27,'Vidor',0,'1800-01-01',NULL,0),
	(3406,27,'Villorba',0,'1800-01-01',NULL,0),
	(3407,27,'Vittorio Veneto',0,'1800-01-01',NULL,0),
	(3408,27,'Volpago del Montello',0,'1800-01-01',NULL,0),
	(3409,27,'Zenson di Piave',0,'1800-01-01',NULL,0),
	(3410,27,'Zero Branco',0,'1800-01-01',NULL,0),
	(3411,28,'Annone Veneto',0,'1800-01-01',NULL,0),
	(3412,28,'Campagna Lupia',0,'1800-01-01',NULL,0),
	(3413,28,'Campolongo Maggiore',0,'1800-01-01',NULL,0),
	(3414,28,'Camponogara',0,'1800-01-01',NULL,0),
	(3415,28,'Caorle',0,'1800-01-01',NULL,0),
	(3416,28,'Cavarzere',0,'1800-01-01',NULL,0),
	(3417,28,'Ceggia',0,'1800-01-01',NULL,0),
	(3418,28,'Chioggia',0,'1800-01-01',NULL,0),
	(3419,28,'Cinto Caomaggiore',0,'1800-01-01',NULL,0),
	(3420,28,'Cona',0,'1800-01-01',NULL,0),
	(3421,28,'Concordia Sagittaria',0,'1800-01-01',NULL,0),
	(3422,28,'Dolo',0,'1800-01-01',NULL,0),
	(3423,28,'Eraclea',0,'1800-01-01',NULL,0),
	(3424,28,'Fiesso d\'Artico',0,'1800-01-01',NULL,0),
	(3425,28,'Fossalta di Piave',0,'1800-01-01',NULL,0),
	(3426,28,'Fossalta di Portogruaro',0,'1800-01-01',NULL,0),
	(3427,28,'Fossò',0,'1800-01-01',NULL,0),
	(3428,28,'Gruaro',0,'1800-01-01',NULL,0),
	(3429,28,'Jesolo',0,'1800-01-01',NULL,0),
	(3430,28,'Marcon',0,'1800-01-01',NULL,0),
	(3431,28,'Martellago',0,'1800-01-01',NULL,0),
	(3432,28,'Meolo',0,'1800-01-01',NULL,0),
	(3433,28,'Mira',0,'1800-01-01',NULL,0),
	(3434,28,'Mirano',0,'1800-01-01',NULL,0),
	(3435,28,'Musile di Piave',0,'1800-01-01',NULL,0),
	(3436,28,'Noale',0,'1800-01-01',NULL,0),
	(3437,28,'Noventa di Piave',0,'1800-01-01',NULL,0),
	(3438,28,'Pianiga',0,'1800-01-01',NULL,0),
	(3439,28,'Portogruaro',0,'1800-01-01',NULL,0),
	(3440,28,'Pramaggiore',0,'1800-01-01',NULL,0),
	(3441,28,'Quarto d\'Altino',0,'1800-01-01',NULL,0),
	(3442,28,'Salzano',0,'1800-01-01',NULL,0),
	(3443,28,'San Donà di Piave',0,'1800-01-01',NULL,0),
	(3444,28,'San Michele al Tagliamento',0,'1800-01-01',NULL,0),
	(3445,28,'Santa Maria di Sala',0,'1800-01-01',NULL,0),
	(3446,28,'Santo Stino di Livenza',0,'1800-01-01',NULL,0),
	(3447,28,'Scorzè',0,'1800-01-01',NULL,0),
	(3448,28,'Spinea',0,'1800-01-01',NULL,0),
	(3449,28,'Stra',0,'1800-01-01',NULL,0),
	(3450,28,'Teglio Veneto',0,'1800-01-01',NULL,0),
	(3451,28,'Torre di Mosto',0,'1800-01-01',NULL,0),
	(3452,28,'Venezia',1,'1800-01-01',NULL,0),
	(3453,28,'Vigonovo',0,'1800-01-01',NULL,0),
	(3454,28,'Cavallino-Treporti',0,'1800-01-01',NULL,0),
	(3455,29,'Abano Terme',0,'1800-01-01',NULL,0),
	(3456,29,'Agna',0,'1800-01-01',NULL,0),
	(3457,29,'Albignasego',0,'1800-01-01',NULL,0),
	(3458,29,'Anguillara Veneta',0,'1800-01-01',NULL,0),
	(3459,29,'Arquà Petrarca',0,'1800-01-01',NULL,0),
	(3460,29,'Arre',0,'1800-01-01',NULL,0),
	(3461,29,'Arzergrande',0,'1800-01-01',NULL,0),
	(3462,29,'Bagnoli di Sopra',0,'1800-01-01',NULL,0),
	(3463,29,'Baone',0,'1800-01-01',NULL,0),
	(3464,29,'Barbona',0,'1800-01-01',NULL,0),
	(3465,29,'Battaglia Terme',0,'1800-01-01',NULL,0),
	(3466,29,'Boara Pisani',0,'1800-01-01',NULL,0),
	(3467,29,'Borgoricco',0,'1800-01-01',NULL,0),
	(3468,29,'Bovolenta',0,'1800-01-01',NULL,0),
	(3469,29,'Brugine',0,'1800-01-01',NULL,0),
	(3470,29,'Cadoneghe',0,'1800-01-01',NULL,0),
	(3471,29,'Campodarsego',0,'1800-01-01',NULL,0),
	(3472,29,'Campodoro',0,'1800-01-01',NULL,0),
	(3473,29,'Camposampiero',0,'1800-01-01',NULL,0),
	(3474,29,'Campo San Martino',0,'1800-01-01',NULL,0),
	(3475,29,'Candiana',0,'1800-01-01',NULL,0),
	(3476,29,'Carceri',0,'1800-01-01',NULL,0),
	(3477,29,'Carmignano di Brenta',0,'1800-01-01',NULL,0),
	(3478,29,'Cartura',0,'1800-01-01',NULL,0),
	(3479,29,'Casale di Scodosia',0,'1800-01-01',NULL,0),
	(3480,29,'Casalserugo',0,'1800-01-01',NULL,0),
	(3481,29,'Castelbaldo',0,'1800-01-01',NULL,0),
	(3482,29,'Cervarese Santa Croce',0,'1800-01-01',NULL,0),
	(3483,29,'Cinto Euganeo',0,'1800-01-01',NULL,0),
	(3484,29,'Cittadella',0,'1800-01-01',NULL,0),
	(3485,29,'Codevigo',0,'1800-01-01',NULL,0),
	(3486,29,'Conselve',0,'1800-01-01',NULL,0),
	(3487,29,'Correzzola',0,'1800-01-01',NULL,0),
	(3488,29,'Curtarolo',0,'1800-01-01',NULL,0),
	(3489,29,'Este',0,'1800-01-01',NULL,0),
	(3490,29,'Fontaniva',0,'1800-01-01',NULL,0),
	(3491,29,'Galliera Veneta',0,'1800-01-01',NULL,0),
	(3492,29,'Galzignano Terme',0,'1800-01-01',NULL,0),
	(3493,29,'Gazzo',0,'1800-01-01',NULL,0),
	(3494,29,'Grantorto',0,'1800-01-01',NULL,0),
	(3495,29,'Granze',0,'1800-01-01',NULL,0),
	(3496,29,'Legnaro',0,'1800-01-01',NULL,0),
	(3497,29,'Limena',0,'1800-01-01',NULL,0),
	(3498,29,'Loreggia',0,'1800-01-01',NULL,0),
	(3499,29,'Lozzo Atestino',0,'1800-01-01',NULL,0),
	(3500,29,'Maserà di Padova',0,'1800-01-01',NULL,0),
	(3501,29,'Masi',0,'1800-01-01',NULL,0),
	(3502,29,'Massanzago',0,'1800-01-01',NULL,0),
	(3503,29,'Megliadino San Fidenzio',0,'1800-01-01',NULL,0),
	(3504,29,'Megliadino San Vitale',0,'1800-01-01',NULL,0),
	(3505,29,'Merlara',0,'1800-01-01',NULL,0),
	(3506,29,'Mestrino',0,'1800-01-01',NULL,0),
	(3507,29,'Monselice',0,'1800-01-01',NULL,0),
	(3508,29,'Montagnana',0,'1800-01-01',NULL,0),
	(3509,29,'Montegrotto Terme',0,'1800-01-01',NULL,0),
	(3510,29,'Noventa Padovana',0,'1800-01-01',NULL,0),
	(3511,29,'Ospedaletto Euganeo',0,'1800-01-01',NULL,0),
	(3512,29,'Padova',1,'1800-01-01',NULL,0),
	(3513,29,'Pernumia',0,'1800-01-01',NULL,0),
	(3514,29,'Piacenza d\'Adige',0,'1800-01-01',NULL,0),
	(3515,29,'Piazzola sul Brenta',0,'1800-01-01',NULL,0),
	(3516,29,'Piombino Dese',0,'1800-01-01',NULL,0),
	(3517,29,'Piove di Sacco',0,'1800-01-01',NULL,0),
	(3518,29,'Polverara',0,'1800-01-01',NULL,0),
	(3519,29,'Ponso',0,'1800-01-01',NULL,0),
	(3520,29,'Pontelongo',0,'1800-01-01',NULL,0),
	(3521,29,'Ponte San Nicolò',0,'1800-01-01',NULL,0),
	(3522,29,'Pozzonovo',0,'1800-01-01',NULL,0),
	(3523,29,'Rovolon',0,'1800-01-01',NULL,0),
	(3524,29,'Rubano',0,'1800-01-01',NULL,0),
	(3525,29,'Saccolongo',0,'1800-01-01',NULL,0),
	(3526,29,'Saletto',0,'1800-01-01',NULL,0),
	(3527,29,'San Giorgio delle Pertiche',0,'1800-01-01',NULL,0),
	(3528,29,'San Giorgio in Bosco',0,'1800-01-01',NULL,0),
	(3529,29,'San Martino di Lupari',0,'1800-01-01',NULL,0),
	(3530,29,'San Pietro in Gu',0,'1800-01-01',NULL,0),
	(3531,29,'San Pietro Viminario',0,'1800-01-01',NULL,0),
	(3532,29,'Santa Giustina in Colle',0,'1800-01-01',NULL,0),
	(3533,29,'Santa Margherita d\'Adige',0,'1800-01-01',NULL,0),
	(3534,29,'Sant\'Angelo di Piove di Sacco',0,'1800-01-01',NULL,0),
	(3535,29,'Sant\'Elena',0,'1800-01-01',NULL,0),
	(3536,29,'Sant\'Urbano',0,'1800-01-01',NULL,0),
	(3537,29,'Saonara',0,'1800-01-01',NULL,0),
	(3538,29,'Selvazzano Dentro',0,'1800-01-01',NULL,0),
	(3539,29,'Solesino',0,'1800-01-01',NULL,0),
	(3540,29,'Stanghella',0,'1800-01-01',NULL,0),
	(3541,29,'Teolo',0,'1800-01-01',NULL,0),
	(3542,29,'Terrassa Padovana',0,'1800-01-01',NULL,0),
	(3543,29,'Tombolo',0,'1800-01-01',NULL,0),
	(3544,29,'Torreglia',0,'1800-01-01',NULL,0),
	(3545,29,'Trebaseleghe',0,'1800-01-01',NULL,0),
	(3546,29,'Tribano',0,'1800-01-01',NULL,0),
	(3547,29,'Urbana',0,'1800-01-01',NULL,0),
	(3548,29,'Veggiano',0,'1800-01-01',NULL,0),
	(3549,29,'Vescovana',0,'1800-01-01',NULL,0),
	(3550,29,'Vighizzolo d\'Este',0,'1800-01-01',NULL,0),
	(3551,29,'Vigodarzere',0,'1800-01-01',NULL,0),
	(3552,29,'Vigonza',0,'1800-01-01',NULL,0),
	(3553,29,'Villa del Conte',0,'1800-01-01',NULL,0),
	(3554,29,'Villa Estense',0,'1800-01-01',NULL,0),
	(3555,29,'Villafranca Padovana',0,'1800-01-01',NULL,0),
	(3556,29,'Villanova di Camposampiero',0,'1800-01-01',NULL,0),
	(3557,29,'Vo\'',0,'1800-01-01',NULL,0),
	(3558,29,'Due Carrare',0,'1800-01-01',NULL,0),
	(3559,30,'Adria',0,'1800-01-01',NULL,0),
	(3560,30,'Ariano nel Polesine',0,'1800-01-01',NULL,0),
	(3561,30,'Arquà Polesine',0,'1800-01-01',NULL,0),
	(3562,30,'Badia Polesine',0,'1800-01-01',NULL,0),
	(3563,30,'Bagnolo di Po',0,'1800-01-01',NULL,0),
	(3564,30,'Bergantino',0,'1800-01-01',NULL,0),
	(3565,30,'Bosaro',0,'1800-01-01',NULL,0),
	(3566,30,'Calto',0,'1800-01-01',NULL,0),
	(3567,30,'Canaro',0,'1800-01-01',NULL,0),
	(3568,30,'Canda',0,'1800-01-01',NULL,0),
	(3569,30,'Castelguglielmo',0,'1800-01-01',NULL,0),
	(3570,30,'Castelmassa',0,'1800-01-01',NULL,0),
	(3571,30,'Castelnovo Bariano',0,'1800-01-01',NULL,0),
	(3572,30,'Ceneselli',0,'1800-01-01',NULL,0),
	(3573,30,'Ceregnano',0,'1800-01-01',NULL,0),
	(3574,30,'Corbola',0,'1800-01-01',NULL,0),
	(3575,30,'Costa di Rovigo',0,'1800-01-01',NULL,0),
	(3576,30,'Crespino',0,'1800-01-01',NULL,0),
	(3577,30,'Ficarolo',0,'1800-01-01',NULL,0),
	(3578,30,'Fiesso Umbertiano',0,'1800-01-01',NULL,0),
	(3579,30,'Frassinelle Polesine',0,'1800-01-01',NULL,0),
	(3580,30,'Fratta Polesine',0,'1800-01-01',NULL,0),
	(3581,30,'Gaiba',0,'1800-01-01',NULL,0),
	(3582,30,'Gavello',0,'1800-01-01',NULL,0),
	(3583,30,'Giacciano con Baruchella',0,'1800-01-01',NULL,0),
	(3584,30,'Guarda Veneta',0,'1800-01-01',NULL,0),
	(3585,30,'Lendinara',0,'1800-01-01',NULL,0),
	(3586,30,'Loreo',0,'1800-01-01',NULL,0),
	(3587,30,'Lusia',0,'1800-01-01',NULL,0),
	(3588,30,'Melara',0,'1800-01-01',NULL,0),
	(3589,30,'Occhiobello',0,'1800-01-01',NULL,0),
	(3590,30,'Papozze',0,'1800-01-01',NULL,0),
	(3591,30,'Pettorazza Grimani',0,'1800-01-01',NULL,0),
	(3592,30,'Pincara',0,'1800-01-01',NULL,0),
	(3593,30,'Polesella',0,'1800-01-01',NULL,0),
	(3594,30,'Pontecchio Polesine',0,'1800-01-01',NULL,0),
	(3595,30,'Porto Tolle',0,'1800-01-01',NULL,0),
	(3596,30,'Rosolina',0,'1800-01-01',NULL,0),
	(3597,30,'Rovigo',1,'1800-01-01',NULL,0),
	(3598,30,'Salara',0,'1800-01-01',NULL,0),
	(3599,30,'San Bellino',0,'1800-01-01',NULL,0),
	(3600,30,'San Martino di Venezze',0,'1800-01-01',NULL,0),
	(3601,30,'Stienta',0,'1800-01-01',NULL,0),
	(3602,30,'Taglio di Po',0,'1800-01-01',NULL,0),
	(3603,30,'Trecenta',0,'1800-01-01',NULL,0),
	(3604,30,'Villadose',0,'1800-01-01',NULL,0),
	(3605,30,'Villamarzana',0,'1800-01-01',NULL,0),
	(3606,30,'Villanova del Ghebbo',0,'1800-01-01',NULL,0),
	(3607,30,'Villanova Marchesana',0,'1800-01-01',NULL,0),
	(3608,30,'Porto Viro',0,'1800-01-01',NULL,0),
	(3609,31,'Aiello del Friuli',0,'1800-01-01',NULL,0),
	(3610,31,'Amaro',0,'1800-01-01',NULL,0),
	(3611,31,'Ampezzo',0,'1800-01-01',NULL,0),
	(3612,31,'Aquileia',0,'1800-01-01',NULL,0),
	(3613,31,'Arta Terme',0,'1800-01-01',NULL,0),
	(3614,31,'Artegna',0,'1800-01-01',NULL,0),
	(3615,31,'Attimis',0,'1800-01-01',NULL,0),
	(3616,31,'Bagnaria Arsa',0,'1800-01-01',NULL,0),
	(3617,31,'Basiliano',0,'1800-01-01',NULL,0),
	(3618,31,'Bertiolo',0,'1800-01-01',NULL,0),
	(3619,31,'Bicinicco',0,'1800-01-01',NULL,0),
	(3620,31,'Bordano',0,'1800-01-01',NULL,0),
	(3621,31,'Buja',0,'1800-01-01',NULL,0),
	(3622,31,'Buttrio',0,'1800-01-01',NULL,0),
	(3623,31,'Camino al Tagliamento',0,'1800-01-01',NULL,0),
	(3624,31,'Campoformido',0,'1800-01-01',NULL,0),
	(3625,31,'Carlino',0,'1800-01-01',NULL,0),
	(3626,31,'Cassacco',0,'1800-01-01',NULL,0),
	(3627,31,'Castions di Strada',0,'1800-01-01',NULL,0),
	(3628,31,'Cavazzo Carnico',0,'1800-01-01',NULL,0),
	(3629,31,'Cercivento',0,'1800-01-01',NULL,0),
	(3630,31,'Cervignano del Friuli',0,'1800-01-01',NULL,0),
	(3631,31,'Chiopris-Viscone',0,'1800-01-01',NULL,0),
	(3632,31,'Chiusaforte',0,'1800-01-01',NULL,0),
	(3633,31,'Cividale del Friuli',0,'1800-01-01',NULL,0),
	(3634,31,'Codroipo',0,'1800-01-01',NULL,0),
	(3635,31,'Colloredo di Monte Albano',0,'1800-01-01',NULL,0),
	(3636,31,'Comeglians',0,'1800-01-01',NULL,0),
	(3637,31,'Corno di Rosazzo',0,'1800-01-01',NULL,0),
	(3638,31,'Coseano',0,'1800-01-01',NULL,0),
	(3639,31,'Dignano',0,'1800-01-01',NULL,0),
	(3640,31,'Dogna',0,'1800-01-01',NULL,0),
	(3641,31,'Drenchia',0,'1800-01-01',NULL,0),
	(3642,31,'Enemonzo',0,'1800-01-01',NULL,0),
	(3643,31,'Faedis',0,'1800-01-01',NULL,0),
	(3644,31,'Fagagna',0,'1800-01-01',NULL,0),
	(3645,31,'Fiumicello',0,'1800-01-01',NULL,0),
	(3646,31,'Flaibano',0,'1800-01-01',NULL,0),
	(3647,31,'Forni Avoltri',0,'1800-01-01',NULL,0),
	(3648,31,'Forni di Sopra',0,'1800-01-01',NULL,0),
	(3649,31,'Forni di Sotto',0,'1800-01-01',NULL,0),
	(3650,31,'Gemona del Friuli',0,'1800-01-01',NULL,0),
	(3651,31,'Gonars',0,'1800-01-01',NULL,0),
	(3652,31,'Grimacco',0,'1800-01-01',NULL,0),
	(3653,31,'Latisana',0,'1800-01-01',NULL,0),
	(3654,31,'Lauco',0,'1800-01-01',NULL,0),
	(3655,31,'Lestizza',0,'1800-01-01',NULL,0),
	(3656,31,'Lignano Sabbiadoro',0,'1800-01-01',NULL,0),
	(3657,31,'Ligosullo',0,'1800-01-01',NULL,0),
	(3658,31,'Lusevera',0,'1800-01-01',NULL,0),
	(3659,31,'Magnano in Riviera',0,'1800-01-01',NULL,0),
	(3660,31,'Majano',0,'1800-01-01',NULL,0),
	(3661,31,'Malborghetto Valbruna',0,'1800-01-01',NULL,0),
	(3662,31,'Manzano',0,'1800-01-01',NULL,0),
	(3663,31,'Marano Lagunare',0,'1800-01-01',NULL,0),
	(3664,31,'Martignacco',0,'1800-01-01',NULL,0),
	(3665,31,'Mereto di Tomba',0,'1800-01-01',NULL,0),
	(3666,31,'Moggio Udinese',0,'1800-01-01',NULL,0),
	(3667,31,'Moimacco',0,'1800-01-01',NULL,0),
	(3668,31,'Montenars',0,'1800-01-01',NULL,0),
	(3669,31,'Mortegliano',0,'1800-01-01',NULL,0),
	(3670,31,'Moruzzo',0,'1800-01-01',NULL,0),
	(3671,31,'Muzzana del Turgnano',0,'1800-01-01',NULL,0),
	(3672,31,'Nimis',0,'1800-01-01',NULL,0),
	(3673,31,'Osoppo',0,'1800-01-01',NULL,0),
	(3674,31,'Ovaro',0,'1800-01-01',NULL,0),
	(3675,31,'Pagnacco',0,'1800-01-01',NULL,0),
	(3676,31,'Palazzolo dello Stella',0,'1800-01-01',NULL,0),
	(3677,31,'Palmanova',0,'1800-01-01',NULL,0),
	(3678,31,'Paluzza',0,'1800-01-01',NULL,0),
	(3679,31,'Pasian di Prato',0,'1800-01-01',NULL,0),
	(3680,31,'Paularo',0,'1800-01-01',NULL,0),
	(3681,31,'Pavia di Udine',0,'1800-01-01',NULL,0),
	(3682,31,'Pocenia',0,'1800-01-01',NULL,0),
	(3683,31,'Pontebba',0,'1800-01-01',NULL,0),
	(3684,31,'Porpetto',0,'1800-01-01',NULL,0),
	(3685,31,'Povoletto',0,'1800-01-01',NULL,0),
	(3686,31,'Pozzuolo del Friuli',0,'1800-01-01',NULL,0),
	(3687,31,'Pradamano',0,'1800-01-01',NULL,0),
	(3688,31,'Prato Carnico',0,'1800-01-01',NULL,0),
	(3689,31,'Precenicco',0,'1800-01-01',NULL,0),
	(3690,31,'Premariacco',0,'1800-01-01',NULL,0),
	(3691,31,'Preone',0,'1800-01-01',NULL,0),
	(3692,31,'Prepotto',0,'1800-01-01',NULL,0),
	(3693,31,'Pulfero',0,'1800-01-01',NULL,0),
	(3694,31,'Ragogna',0,'1800-01-01',NULL,0),
	(3695,31,'Ravascletto',0,'1800-01-01',NULL,0),
	(3696,31,'Raveo',0,'1800-01-01',NULL,0),
	(3697,31,'Reana del Rojale',0,'1800-01-01',NULL,0),
	(3698,31,'Remanzacco',0,'1800-01-01',NULL,0),
	(3699,31,'Resia',0,'1800-01-01',NULL,0),
	(3700,31,'Resiutta',0,'1800-01-01',NULL,0),
	(3701,31,'Rigolato',0,'1800-01-01',NULL,0),
	(3702,31,'Rive d\'Arcano',0,'1800-01-01',NULL,0),
	(3703,31,'Rivignano',0,'1800-01-01',NULL,0),
	(3704,31,'Ronchis',0,'1800-01-01',NULL,0),
	(3705,31,'Ruda',0,'1800-01-01',NULL,0),
	(3706,31,'San Daniele del Friuli',0,'1800-01-01',NULL,0),
	(3707,31,'San Giorgio di Nogaro',0,'1800-01-01',NULL,0),
	(3708,31,'San Giovanni al Natisone',0,'1800-01-01',NULL,0),
	(3709,31,'San Leonardo',0,'1800-01-01',NULL,0),
	(3710,31,'San Pietro al Natisone',0,'1800-01-01',NULL,0),
	(3711,31,'Santa Maria la Longa',0,'1800-01-01',NULL,0),
	(3712,31,'San Vito al Torre',0,'1800-01-01',NULL,0),
	(3713,31,'San Vito di Fagagna',0,'1800-01-01',NULL,0),
	(3714,31,'Sauris',0,'1800-01-01',NULL,0),
	(3715,31,'Savogna',0,'1800-01-01',NULL,0),
	(3716,31,'Sedegliano',0,'1800-01-01',NULL,0),
	(3717,31,'Socchieve',0,'1800-01-01',NULL,0),
	(3718,31,'Stregna',0,'1800-01-01',NULL,0),
	(3719,31,'Sutrio',0,'1800-01-01',NULL,0),
	(3720,31,'Taipana',0,'1800-01-01',NULL,0),
	(3721,31,'Talmassons',0,'1800-01-01',NULL,0),
	(3722,31,'Tarcento',0,'1800-01-01',NULL,0),
	(3723,31,'Tarvisio',0,'1800-01-01',NULL,0),
	(3724,31,'Tavagnacco',0,'1800-01-01',NULL,0),
	(3725,31,'Teor',0,'1800-01-01',NULL,0),
	(3726,31,'Terzo d\'Aquileia',0,'1800-01-01',NULL,0),
	(3727,31,'Tolmezzo',0,'1800-01-01',NULL,0),
	(3728,31,'Torreano',0,'1800-01-01',NULL,0),
	(3729,31,'Torviscosa',0,'1800-01-01',NULL,0),
	(3730,31,'Trasaghis',0,'1800-01-01',NULL,0),
	(3731,31,'Treppo Carnico',0,'1800-01-01',NULL,0),
	(3732,31,'Treppo Grande',0,'1800-01-01',NULL,0),
	(3733,31,'Tricesimo',0,'1800-01-01',NULL,0),
	(3734,31,'Trivignano Udinese',0,'1800-01-01',NULL,0),
	(3735,31,'Udine',1,'1800-01-01',NULL,0),
	(3736,31,'Varmo',0,'1800-01-01',NULL,0),
	(3737,31,'Venzone',0,'1800-01-01',NULL,0),
	(3738,31,'Verzegnis',0,'1800-01-01',NULL,0),
	(3739,31,'Villa Santina',0,'1800-01-01',NULL,0),
	(3740,31,'Villa Vicentina',0,'1800-01-01',NULL,0),
	(3741,31,'Visco',0,'1800-01-01',NULL,0),
	(3742,31,'Zuglio',0,'1800-01-01',NULL,0),
	(3743,31,'Forgaria nel Friuli',0,'1800-01-01',NULL,0),
	(3744,31,'Campolongo Tapogliano',0,'1800-01-01',NULL,0),
	(3745,32,'Capriva del Friuli',0,'1800-01-01',NULL,0),
	(3746,32,'Cormons',0,'1800-01-01',NULL,0),
	(3747,32,'Doberdò del Lago',0,'1800-01-01',NULL,0),
	(3748,32,'Dolegna del Collio',0,'1800-01-01',NULL,0),
	(3749,32,'Farra d\'Isonzo',0,'1800-01-01',NULL,0),
	(3750,32,'Fogliano Redipuglia',0,'1800-01-01',NULL,0),
	(3751,32,'Gorizia',1,'1800-01-01',NULL,0),
	(3752,32,'Gradisca d\'Isonzo',0,'1800-01-01',NULL,0),
	(3753,32,'Grado',0,'1800-01-01',NULL,0),
	(3754,32,'Mariano del Friuli',0,'1800-01-01',NULL,0),
	(3755,32,'Medea',0,'1800-01-01',NULL,0),
	(3756,32,'Monfalcone',0,'1800-01-01',NULL,0),
	(3757,32,'Moraro',0,'1800-01-01',NULL,0),
	(3758,32,'Mossa',0,'1800-01-01',NULL,0),
	(3759,32,'Romans d\'Isonzo',0,'1800-01-01',NULL,0),
	(3760,32,'Ronchi dei Legionari',0,'1800-01-01',NULL,0),
	(3761,32,'Sagrado',0,'1800-01-01',NULL,0),
	(3762,32,'San Canzian d\'Isonzo',0,'1800-01-01',NULL,0),
	(3763,32,'San Floriano del Collio',0,'1800-01-01',NULL,0),
	(3764,32,'San Lorenzo Isontino',0,'1800-01-01',NULL,0),
	(3765,32,'San Pier d\'Isonzo',0,'1800-01-01',NULL,0),
	(3766,32,'Savogna d\'Isonzo',0,'1800-01-01',NULL,0),
	(3767,32,'Staranzano',0,'1800-01-01',NULL,0),
	(3768,32,'Turriaco',0,'1800-01-01',NULL,0),
	(3769,32,'Villesse',0,'1800-01-01',NULL,0),
	(3770,33,'Duino-Aurisina',0,'1800-01-01',NULL,0),
	(3771,33,'Monrupino',0,'1800-01-01',NULL,0),
	(3772,33,'Muggia',0,'1800-01-01',NULL,0),
	(3773,33,'San Dorligo della Valle - Dolina',0,'1800-01-01',NULL,0),
	(3774,33,'Sgonico',0,'1800-01-01',NULL,0),
	(3775,33,'Trieste',1,'1800-01-01',NULL,0),
	(3776,39,'Agazzano',0,'1800-01-01',NULL,0),
	(3777,39,'Alseno',0,'1800-01-01',NULL,0),
	(3778,39,'Besenzone',0,'1800-01-01',NULL,0),
	(3779,39,'Bettola',0,'1800-01-01',NULL,0),
	(3780,39,'Bobbio',0,'1800-01-01',NULL,0),
	(3781,39,'Borgonovo Val Tidone',0,'1800-01-01',NULL,0),
	(3782,39,'Cadeo',0,'1800-01-01',NULL,0),
	(3783,39,'Calendasco',0,'1800-01-01',NULL,0),
	(3784,39,'Caminata',0,'1800-01-01',NULL,0),
	(3785,39,'Caorso',0,'1800-01-01',NULL,0),
	(3786,39,'Carpaneto Piacentino',0,'1800-01-01',NULL,0),
	(3787,39,'Castell\'Arquato',0,'1800-01-01',NULL,0),
	(3788,39,'Castel San Giovanni',0,'1800-01-01',NULL,0),
	(3789,39,'Castelvetro Piacentino',0,'1800-01-01',NULL,0),
	(3790,39,'Cerignale',0,'1800-01-01',NULL,0),
	(3791,39,'Coli',0,'1800-01-01',NULL,0),
	(3792,39,'Corte Brugnatella',0,'1800-01-01',NULL,0),
	(3793,39,'Cortemaggiore',0,'1800-01-01',NULL,0),
	(3794,39,'Farini',0,'1800-01-01',NULL,0),
	(3795,39,'Ferriere',0,'1800-01-01',NULL,0),
	(3796,39,'Fiorenzuola d\'Arda',0,'1800-01-01',NULL,0),
	(3797,39,'Gazzola',0,'1800-01-01',NULL,0),
	(3798,39,'Gossolengo',0,'1800-01-01',NULL,0),
	(3799,39,'Gragnano Trebbiense',0,'1800-01-01',NULL,0),
	(3800,39,'Gropparello',0,'1800-01-01',NULL,0),
	(3801,39,'Lugagnano Val d\'Arda',0,'1800-01-01',NULL,0),
	(3802,39,'Monticelli d\'Ongina',0,'1800-01-01',NULL,0),
	(3803,39,'Morfasso',0,'1800-01-01',NULL,0),
	(3804,39,'Nibbiano',0,'1800-01-01',NULL,0),
	(3805,39,'Ottone',0,'1800-01-01',NULL,0),
	(3806,39,'Pecorara',0,'1800-01-01',NULL,0),
	(3807,39,'Piacenza',1,'1800-01-01',NULL,0),
	(3808,39,'Pianello Val Tidone',0,'1800-01-01',NULL,0),
	(3809,39,'Piozzano',0,'1800-01-01',NULL,0),
	(3810,39,'Podenzano',0,'1800-01-01',NULL,0),
	(3811,39,'Ponte dell\'Olio',0,'1800-01-01',NULL,0),
	(3812,39,'Pontenure',0,'1800-01-01',NULL,0),
	(3813,39,'Rivergaro',0,'1800-01-01',NULL,0),
	(3814,39,'Rottofreno',0,'1800-01-01',NULL,0),
	(3815,39,'San Giorgio Piacentino',0,'1800-01-01',NULL,0),
	(3816,39,'San Pietro in Cerro',0,'1800-01-01',NULL,0),
	(3817,39,'Sarmato',0,'1800-01-01',NULL,0),
	(3818,39,'Travo',0,'1800-01-01',NULL,0),
	(3819,39,'Vernasca',0,'1800-01-01',NULL,0),
	(3820,39,'Vigolzone',0,'1800-01-01',NULL,0),
	(3821,39,'Villanova sull\'Arda',0,'1800-01-01',NULL,0),
	(3822,39,'Zerba',0,'1800-01-01',NULL,0),
	(3823,39,'Ziano Piacentino',0,'1800-01-01',NULL,0),
	(3824,40,'Albareto',0,'1800-01-01',NULL,0),
	(3825,40,'Bardi',0,'1800-01-01',NULL,0),
	(3826,40,'Bedonia',0,'1800-01-01',NULL,0),
	(3827,40,'Berceto',0,'1800-01-01',NULL,0),
	(3828,40,'Bore',0,'1800-01-01',NULL,0),
	(3829,40,'Borgo Val di Taro',0,'1800-01-01',NULL,0),
	(3830,40,'Busseto',0,'1800-01-01',NULL,0),
	(3831,40,'Calestano',0,'1800-01-01',NULL,0),
	(3832,40,'Collecchio',0,'1800-01-01',NULL,0),
	(3833,40,'Colorno',0,'1800-01-01',NULL,0),
	(3834,40,'Compiano',0,'1800-01-01',NULL,0),
	(3835,40,'Corniglio',0,'1800-01-01',NULL,0),
	(3836,40,'Felino',0,'1800-01-01',NULL,0),
	(3837,40,'Fidenza',0,'1800-01-01',NULL,0),
	(3838,40,'Fontanellato',0,'1800-01-01',NULL,0),
	(3839,40,'Fontevivo',0,'1800-01-01',NULL,0),
	(3840,40,'Fornovo di Taro',0,'1800-01-01',NULL,0),
	(3841,40,'Langhirano',0,'1800-01-01',NULL,0),
	(3842,40,'Lesignano de\' Bagni',0,'1800-01-01',NULL,0),
	(3843,40,'Medesano',0,'1800-01-01',NULL,0),
	(3844,40,'Mezzani',0,'1800-01-01',NULL,0),
	(3845,40,'Monchio delle Corti',0,'1800-01-01',NULL,0),
	(3846,40,'Montechiarugolo',0,'1800-01-01',NULL,0),
	(3847,40,'Neviano degli Arduini',0,'1800-01-01',NULL,0),
	(3848,40,'Noceto',0,'1800-01-01',NULL,0),
	(3849,40,'Palanzano',0,'1800-01-01',NULL,0),
	(3850,40,'Parma',1,'1800-01-01',NULL,0),
	(3851,40,'Pellegrino Parmense',0,'1800-01-01',NULL,0),
	(3852,40,'Polesine Parmense',0,'1800-01-01',NULL,0),
	(3853,40,'Roccabianca',0,'1800-01-01',NULL,0),
	(3854,40,'Sala Baganza',0,'1800-01-01',NULL,0),
	(3855,40,'Salsomaggiore Terme',0,'1800-01-01',NULL,0),
	(3856,40,'San Secondo Parmense',0,'1800-01-01',NULL,0),
	(3857,40,'Sissa',0,'1800-01-01',NULL,0),
	(3858,40,'Solignano',0,'1800-01-01',NULL,0),
	(3859,40,'Soragna',0,'1800-01-01',NULL,0),
	(3860,40,'Sorbolo',0,'1800-01-01',NULL,0),
	(3861,40,'Terenzo',0,'1800-01-01',NULL,0),
	(3862,40,'Tizzano Val Parma',0,'1800-01-01',NULL,0),
	(3863,40,'Tornolo',0,'1800-01-01',NULL,0),
	(3864,40,'Torrile',0,'1800-01-01',NULL,0),
	(3865,40,'Traversetolo',0,'1800-01-01',NULL,0),
	(3866,40,'Trecasali',0,'1800-01-01',NULL,0),
	(3867,40,'Valmozzola',0,'1800-01-01',NULL,0),
	(3868,40,'Varano de\' Melegari',0,'1800-01-01',NULL,0),
	(3869,40,'Varsi',0,'1800-01-01',NULL,0),
	(3870,40,'Zibello',0,'1800-01-01',NULL,0),
	(3871,41,'Albinea',0,'1800-01-01',NULL,0),
	(3872,41,'Bagnolo in Piano',0,'1800-01-01',NULL,0),
	(3873,41,'Baiso',0,'1800-01-01',NULL,0),
	(3874,41,'Bibbiano',0,'1800-01-01',NULL,0),
	(3875,41,'Boretto',0,'1800-01-01',NULL,0),
	(3876,41,'Brescello',0,'1800-01-01',NULL,0),
	(3877,41,'Busana',0,'1800-01-01',NULL,0),
	(3878,41,'Cadelbosco di Sopra',0,'1800-01-01',NULL,0),
	(3879,41,'Campagnola Emilia',0,'1800-01-01',NULL,0),
	(3880,41,'Campegine',0,'1800-01-01',NULL,0),
	(3881,41,'Carpineti',0,'1800-01-01',NULL,0),
	(3882,41,'Casalgrande',0,'1800-01-01',NULL,0),
	(3883,41,'Casina',0,'1800-01-01',NULL,0),
	(3884,41,'Castellarano',0,'1800-01-01',NULL,0),
	(3885,41,'Castelnovo di Sotto',0,'1800-01-01',NULL,0),
	(3886,41,'Castelnovo ne\' Monti',0,'1800-01-01',NULL,0),
	(3887,41,'Cavriago',0,'1800-01-01',NULL,0),
	(3888,41,'Canossa',0,'1800-01-01',NULL,0),
	(3889,41,'Collagna',0,'1800-01-01',NULL,0),
	(3890,41,'Correggio',0,'1800-01-01',NULL,0),
	(3891,41,'Fabbrico',0,'1800-01-01',NULL,0),
	(3892,41,'Gattatico',0,'1800-01-01',NULL,0),
	(3893,41,'Gualtieri',0,'1800-01-01',NULL,0),
	(3894,41,'Guastalla',0,'1800-01-01',NULL,0),
	(3895,41,'Ligonchio',0,'1800-01-01',NULL,0),
	(3896,41,'Luzzara',0,'1800-01-01',NULL,0),
	(3897,41,'Montecchio Emilia',0,'1800-01-01',NULL,0),
	(3898,41,'Novellara',0,'1800-01-01',NULL,0),
	(3899,41,'Poviglio',0,'1800-01-01',NULL,0),
	(3900,41,'Quattro Castella',0,'1800-01-01',NULL,0),
	(3901,41,'Ramiseto',0,'1800-01-01',NULL,0),
	(3902,41,'Reggiolo',0,'1800-01-01',NULL,0),
	(3903,41,'Reggio nell\'Emilia',1,'1800-01-01',NULL,0),
	(3904,41,'Rio Saliceto',0,'1800-01-01',NULL,0),
	(3905,41,'Rolo',0,'1800-01-01',NULL,0),
	(3906,41,'Rubiera',0,'1800-01-01',NULL,0),
	(3907,41,'San Martino in Rio',0,'1800-01-01',NULL,0),
	(3908,41,'San Polo d\'Enza',0,'1800-01-01',NULL,0),
	(3909,41,'Sant\'Ilario d\'Enza',0,'1800-01-01',NULL,0),
	(3910,41,'Scandiano',0,'1800-01-01',NULL,0),
	(3911,41,'Toano',0,'1800-01-01',NULL,0),
	(3912,41,'Vetto',0,'1800-01-01',NULL,0),
	(3913,41,'Vezzano sul Crostolo',0,'1800-01-01',NULL,0),
	(3914,41,'Viano',0,'1800-01-01',NULL,0),
	(3915,41,'Villa Minozzo',0,'1800-01-01',NULL,0),
	(3916,42,'Bastiglia',0,'1800-01-01',NULL,0),
	(3917,42,'Bomporto',0,'1800-01-01',NULL,0),
	(3918,42,'Campogalliano',0,'1800-01-01',NULL,0),
	(3919,42,'Camposanto',0,'1800-01-01',NULL,0),
	(3920,42,'Carpi',0,'1800-01-01',NULL,0),
	(3921,42,'Castelfranco Emilia',0,'1800-01-01',NULL,0),
	(3922,42,'Castelnuovo Rangone',0,'1800-01-01',NULL,0),
	(3923,42,'Castelvetro di Modena',0,'1800-01-01',NULL,0),
	(3924,42,'Cavezzo',0,'1800-01-01',NULL,0),
	(3925,42,'Concordia sulla Secchia',0,'1800-01-01',NULL,0),
	(3926,42,'Fanano',0,'1800-01-01',NULL,0),
	(3927,42,'Finale Emilia',0,'1800-01-01',NULL,0),
	(3928,42,'Fiorano Modenese',0,'1800-01-01',NULL,0),
	(3929,42,'Fiumalbo',0,'1800-01-01',NULL,0),
	(3930,42,'Formigine',0,'1800-01-01',NULL,0),
	(3931,42,'Frassinoro',0,'1800-01-01',NULL,0),
	(3932,42,'Guiglia',0,'1800-01-01',NULL,0),
	(3933,42,'Lama Mocogno',0,'1800-01-01',NULL,0),
	(3934,42,'Maranello',0,'1800-01-01',NULL,0),
	(3935,42,'Marano sul Panaro',0,'1800-01-01',NULL,0),
	(3936,42,'Medolla',0,'1800-01-01',NULL,0),
	(3937,42,'Mirandola',0,'1800-01-01',NULL,0),
	(3938,42,'Modena',1,'1800-01-01',NULL,0),
	(3939,42,'Montecreto',0,'1800-01-01',NULL,0),
	(3940,42,'Montefiorino',0,'1800-01-01',NULL,0),
	(3941,42,'Montese',0,'1800-01-01',NULL,0),
	(3942,42,'Nonantola',0,'1800-01-01',NULL,0),
	(3943,42,'Novi di Modena',0,'1800-01-01',NULL,0),
	(3944,42,'Palagano',0,'1800-01-01',NULL,0),
	(3945,42,'Pavullo nel Frignano',0,'1800-01-01',NULL,0),
	(3946,42,'Pievepelago',0,'1800-01-01',NULL,0),
	(3947,42,'Polinago',0,'1800-01-01',NULL,0),
	(3948,42,'Prignano sulla Secchia',0,'1800-01-01',NULL,0),
	(3949,42,'Ravarino',0,'1800-01-01',NULL,0),
	(3950,42,'Riolunato',0,'1800-01-01',NULL,0),
	(3951,42,'San Cesario sul Panaro',0,'1800-01-01',NULL,0),
	(3952,42,'San Felice sul Panaro',0,'1800-01-01',NULL,0),
	(3953,42,'San Possidonio',0,'1800-01-01',NULL,0),
	(3954,42,'San Prospero',0,'1800-01-01',NULL,0),
	(3955,42,'Sassuolo',0,'1800-01-01',NULL,0),
	(3956,42,'Savignano sul Panaro',0,'1800-01-01',NULL,0),
	(3957,42,'Serramazzoni',0,'1800-01-01',NULL,0),
	(3958,42,'Sestola',0,'1800-01-01',NULL,0),
	(3959,42,'Soliera',0,'1800-01-01',NULL,0),
	(3960,42,'Spilamberto',0,'1800-01-01',NULL,0),
	(3961,42,'Vignola',0,'1800-01-01',NULL,0),
	(3962,42,'Zocca',0,'1800-01-01',NULL,0),
	(3963,43,'Anzola dell\'Emilia',0,'1800-01-01',NULL,0),
	(3964,43,'Argelato',0,'1800-01-01',NULL,0),
	(3965,43,'Baricella',0,'1800-01-01',NULL,0),
	(3966,43,'Bazzano',0,'1800-01-01',NULL,0),
	(3967,43,'Bentivoglio',0,'1800-01-01',NULL,0),
	(3968,43,'Bologna',1,'1800-01-01',NULL,0),
	(3969,43,'Borgo Tossignano',0,'1800-01-01',NULL,0),
	(3970,43,'Budrio',0,'1800-01-01',NULL,0),
	(3971,43,'Calderara di Reno',0,'1800-01-01',NULL,0),
	(3972,43,'Camugnano',0,'1800-01-01',NULL,0),
	(3973,43,'Casalecchio di Reno',0,'1800-01-01',NULL,0),
	(3974,43,'Casalfiumanese',0,'1800-01-01',NULL,0),
	(3975,43,'Castel d\'Aiano',0,'1800-01-01',NULL,0),
	(3976,43,'Castel del Rio',0,'1800-01-01',NULL,0),
	(3977,43,'Castel di Casio',0,'1800-01-01',NULL,0),
	(3978,43,'Castel Guelfo di Bologna',0,'1800-01-01',NULL,0),
	(3979,43,'Castello d\'Argile',0,'1800-01-01',NULL,0),
	(3980,43,'Castello di Serravalle',0,'1800-01-01',NULL,0),
	(3981,43,'Castel Maggiore',0,'1800-01-01',NULL,0),
	(3982,43,'Castel San Pietro Terme',0,'1800-01-01',NULL,0),
	(3983,43,'Castenaso',0,'1800-01-01',NULL,0),
	(3984,43,'Castiglione dei Pepoli',0,'1800-01-01',NULL,0),
	(3985,43,'Crespellano',0,'1800-01-01',NULL,0),
	(3986,43,'Crevalcore',0,'1800-01-01',NULL,0),
	(3987,43,'Dozza',0,'1800-01-01',NULL,0),
	(3988,43,'Fontanelice',0,'1800-01-01',NULL,0),
	(3989,43,'Gaggio Montano',0,'1800-01-01',NULL,0),
	(3990,43,'Galliera',0,'1800-01-01',NULL,0),
	(3991,43,'Granaglione',0,'1800-01-01',NULL,0),
	(3992,43,'Granarolo dell\'Emilia',0,'1800-01-01',NULL,0),
	(3993,43,'Grizzana Morandi',0,'1800-01-01',NULL,0),
	(3994,43,'Imola',0,'1800-01-01',NULL,0),
	(3995,43,'Lizzano in Belvedere',0,'1800-01-01',NULL,0),
	(3996,43,'Loiano',0,'1800-01-01',NULL,0),
	(3997,43,'Malalbergo',0,'1800-01-01',NULL,0),
	(3998,43,'Marzabotto',0,'1800-01-01',NULL,0),
	(3999,43,'Medicina',0,'1800-01-01',NULL,0),
	(4000,43,'Minerbio',0,'1800-01-01',NULL,0),
	(4001,43,'Molinella',0,'1800-01-01',NULL,0),
	(4002,43,'Monghidoro',0,'1800-01-01',NULL,0),
	(4003,43,'Monterenzio',0,'1800-01-01',NULL,0),
	(4004,43,'Monte San Pietro',0,'1800-01-01',NULL,0),
	(4005,43,'Monteveglio',0,'1800-01-01',NULL,0),
	(4006,43,'Monzuno',0,'1800-01-01',NULL,0),
	(4007,43,'Mordano',0,'1800-01-01',NULL,0),
	(4008,43,'Ozzano dell\'Emilia',0,'1800-01-01',NULL,0),
	(4009,43,'Pianoro',0,'1800-01-01',NULL,0),
	(4010,43,'Pieve di Cento',0,'1800-01-01',NULL,0),
	(4011,43,'Porretta Terme',0,'1800-01-01',NULL,0),
	(4012,43,'Sala Bolognese',0,'1800-01-01',NULL,0),
	(4013,43,'San Benedetto Val di Sambro',0,'1800-01-01',NULL,0),
	(4014,43,'San Giorgio di Piano',0,'1800-01-01',NULL,0),
	(4015,43,'San Giovanni in Persiceto',0,'1800-01-01',NULL,0),
	(4016,43,'San Lazzaro di Savena',0,'1800-01-01',NULL,0),
	(4017,43,'San Pietro in Casale',0,'1800-01-01',NULL,0),
	(4018,43,'Sant\'Agata Bolognese',0,'1800-01-01',NULL,0),
	(4019,43,'Sasso Marconi',0,'1800-01-01',NULL,0),
	(4020,43,'Savigno',0,'1800-01-01',NULL,0),
	(4021,43,'Vergato',0,'1800-01-01',NULL,0),
	(4022,43,'Zola Predosa',0,'1800-01-01',NULL,0),
	(4023,44,'Argenta',0,'1800-01-01',NULL,0),
	(4024,44,'Berra',0,'1800-01-01',NULL,0),
	(4025,44,'Bondeno',0,'1800-01-01',NULL,0),
	(4026,44,'Cento',0,'1800-01-01',NULL,0),
	(4027,44,'Codigoro',0,'1800-01-01',NULL,0),
	(4028,44,'Comacchio',0,'1800-01-01',NULL,0),
	(4029,44,'Copparo',0,'1800-01-01',NULL,0),
	(4030,44,'Ferrara',1,'1800-01-01',NULL,0),
	(4031,44,'Formignana',0,'1800-01-01',NULL,0),
	(4032,44,'Jolanda di Savoia',0,'1800-01-01',NULL,0),
	(4033,44,'Lagosanto',0,'1800-01-01',NULL,0),
	(4034,44,'Masi Torello',0,'1800-01-01',NULL,0),
	(4035,44,'Massa Fiscaglia',0,'1800-01-01',NULL,0),
	(4036,44,'Mesola',0,'1800-01-01',NULL,0),
	(4037,44,'Migliarino',0,'1800-01-01',NULL,0),
	(4038,44,'Mirabello',0,'1800-01-01',NULL,0),
	(4039,44,'Ostellato',0,'1800-01-01',NULL,0),
	(4040,44,'Poggio Renatico',0,'1800-01-01',NULL,0),
	(4041,44,'Portomaggiore',0,'1800-01-01',NULL,0),
	(4042,44,'Ro',0,'1800-01-01',NULL,0),
	(4043,44,'Sant\'Agostino',0,'1800-01-01',NULL,0),
	(4044,44,'Vigarano Mainarda',0,'1800-01-01',NULL,0),
	(4045,44,'Voghiera',0,'1800-01-01',NULL,0),
	(4046,44,'Tresigallo',0,'1800-01-01',NULL,0),
	(4047,44,'Goro',0,'1800-01-01',NULL,0),
	(4048,44,'Migliaro',0,'1800-01-01',NULL,0),
	(4049,45,'Alfonsine',0,'1800-01-01',NULL,0),
	(4050,45,'Bagnacavallo',0,'1800-01-01',NULL,0),
	(4051,45,'Bagnara di Romagna',0,'1800-01-01',NULL,0),
	(4052,45,'Brisighella',0,'1800-01-01',NULL,0),
	(4053,45,'Casola Valsenio',0,'1800-01-01',NULL,0),
	(4054,45,'Castel Bolognese',0,'1800-01-01',NULL,0),
	(4055,45,'Cervia',0,'1800-01-01',NULL,0),
	(4056,45,'Conselice',0,'1800-01-01',NULL,0),
	(4057,45,'Cotignola',0,'1800-01-01',NULL,0),
	(4058,45,'Faenza',0,'1800-01-01',NULL,0),
	(4059,45,'Fusignano',0,'1800-01-01',NULL,0),
	(4060,45,'Lugo',0,'1800-01-01',NULL,0),
	(4061,45,'Massa Lombarda',0,'1800-01-01',NULL,0),
	(4062,45,'Ravenna',1,'1800-01-01',NULL,0),
	(4063,45,'Riolo Terme',0,'1800-01-01',NULL,0),
	(4064,45,'Russi',0,'1800-01-01',NULL,0),
	(4065,45,'Sant\'Agata sul Santerno',0,'1800-01-01',NULL,0),
	(4066,45,'Solarolo',0,'1800-01-01',NULL,0),
	(4067,46,'Bagno di Romagna',0,'1800-01-01',NULL,0),
	(4068,46,'Bertinoro',0,'1800-01-01',NULL,0),
	(4069,46,'Borghi',0,'1800-01-01',NULL,0),
	(4070,46,'Castrocaro Terme e Terra del Sole',0,'1800-01-01',NULL,0),
	(4071,46,'Cesena',0,'1800-01-01',NULL,0),
	(4072,46,'Cesenatico',0,'1800-01-01',NULL,0),
	(4073,46,'Civitella di Romagna',0,'1800-01-01',NULL,0),
	(4074,46,'Dovadola',0,'1800-01-01',NULL,0),
	(4075,46,'Forlì',1,'1800-01-01',NULL,0),
	(4076,46,'Forlimpopoli',0,'1800-01-01',NULL,0),
	(4077,46,'Galeata',0,'1800-01-01',NULL,0),
	(4078,46,'Gambettola',0,'1800-01-01',NULL,0),
	(4079,46,'Gatteo',0,'1800-01-01',NULL,0),
	(4080,46,'Longiano',0,'1800-01-01',NULL,0),
	(4081,46,'Meldola',0,'1800-01-01',NULL,0),
	(4082,46,'Mercato Saraceno',0,'1800-01-01',NULL,0),
	(4083,46,'Modigliana',0,'1800-01-01',NULL,0),
	(4084,46,'Montiano',0,'1800-01-01',NULL,0),
	(4085,46,'Portico e San Benedetto',0,'1800-01-01',NULL,0),
	(4086,46,'Predappio',0,'1800-01-01',NULL,0),
	(4087,46,'Premilcuore',0,'1800-01-01',NULL,0),
	(4088,46,'Rocca San Casciano',0,'1800-01-01',NULL,0),
	(4089,46,'Roncofreddo',0,'1800-01-01',NULL,0),
	(4090,46,'San Mauro Pascoli',0,'1800-01-01',NULL,0),
	(4091,46,'Santa Sofia',0,'1800-01-01',NULL,0),
	(4092,46,'Sarsina',0,'1800-01-01',NULL,0),
	(4093,46,'Savignano sul Rubicone',0,'1800-01-01',NULL,0),
	(4094,46,'Sogliano al Rubicone',0,'1800-01-01',NULL,0),
	(4095,46,'Tredozio',0,'1800-01-01',NULL,0),
	(4096,46,'Verghereto',0,'1800-01-01',NULL,0),
	(4097,60,'Acqualagna',0,'1800-01-01',NULL,0),
	(4098,60,'Apecchio',0,'1800-01-01',NULL,0),
	(4099,60,'Auditore',0,'1800-01-01',NULL,0),
	(4100,60,'Barchi',0,'1800-01-01',NULL,0),
	(4101,60,'Belforte all\'Isauro',0,'1800-01-01',NULL,0),
	(4102,60,'Borgo Pace',0,'1800-01-01',NULL,0),
	(4103,60,'Cagli',0,'1800-01-01',NULL,0),
	(4104,60,'Cantiano',0,'1800-01-01',NULL,0),
	(4105,60,'Carpegna',0,'1800-01-01',NULL,0),
	(4106,60,'Cartoceto',0,'1800-01-01',NULL,0),
	(4107,60,'Colbordolo',0,'1800-01-01',NULL,0),
	(4108,60,'Fano',0,'1800-01-01',NULL,0),
	(4109,60,'Fermignano',0,'1800-01-01',NULL,0),
	(4110,60,'Fossombrone',0,'1800-01-01',NULL,0),
	(4111,60,'Fratte Rosa',0,'1800-01-01',NULL,0),
	(4112,60,'Frontino',0,'1800-01-01',NULL,0),
	(4113,60,'Frontone',0,'1800-01-01',NULL,0),
	(4114,60,'Gabicce Mare',0,'1800-01-01',NULL,0),
	(4115,60,'Gradara',0,'1800-01-01',NULL,0),
	(4116,60,'Isola del Piano',0,'1800-01-01',NULL,0),
	(4117,60,'Lunano',0,'1800-01-01',NULL,0),
	(4118,60,'Macerata Feltria',0,'1800-01-01',NULL,0),
	(4119,60,'Mercatello sul Metauro',0,'1800-01-01',NULL,0),
	(4120,60,'Mercatino Conca',0,'1800-01-01',NULL,0),
	(4121,60,'Mombaroccio',0,'1800-01-01',NULL,0),
	(4122,60,'Mondavio',0,'1800-01-01',NULL,0),
	(4123,60,'Mondolfo',0,'1800-01-01',NULL,0),
	(4124,60,'Montecalvo in Foglia',0,'1800-01-01',NULL,0),
	(4125,60,'Monte Cerignone',0,'1800-01-01',NULL,0),
	(4126,60,'Monteciccardo',0,'1800-01-01',NULL,0),
	(4127,60,'Montecopiolo',0,'1800-01-01',NULL,0),
	(4128,60,'Montefelcino',0,'1800-01-01',NULL,0),
	(4129,60,'Monte Grimano Terme',0,'1800-01-01',NULL,0),
	(4130,60,'Montelabbate',0,'1800-01-01',NULL,0),
	(4131,60,'Montemaggiore al Metauro',0,'1800-01-01',NULL,0),
	(4132,60,'Monte Porzio',0,'1800-01-01',NULL,0),
	(4133,60,'Orciano di Pesaro',0,'1800-01-01',NULL,0),
	(4134,60,'Peglio',0,'1800-01-01',NULL,0),
	(4135,60,'Pergola',0,'1800-01-01',NULL,0),
	(4136,60,'Pesaro',1,'1800-01-01',NULL,0),
	(4137,60,'Petriano',0,'1800-01-01',NULL,0),
	(4138,60,'Piagge',0,'1800-01-01',NULL,0),
	(4139,60,'Piandimeleto',0,'1800-01-01',NULL,0),
	(4140,60,'Pietrarubbia',0,'1800-01-01',NULL,0),
	(4141,60,'Piobbico',0,'1800-01-01',NULL,0),
	(4142,60,'Saltara',0,'1800-01-01',NULL,0),
	(4143,60,'San Costanzo',0,'1800-01-01',NULL,0),
	(4144,60,'San Giorgio di Pesaro',0,'1800-01-01',NULL,0),
	(4145,60,'San Lorenzo in Campo',0,'1800-01-01',NULL,0),
	(4146,60,'Sant\'Angelo in Lizzola',0,'1800-01-01',NULL,0),
	(4147,60,'Sant\'Angelo in Vado',0,'1800-01-01',NULL,0),
	(4148,60,'Sant\'Ippolito',0,'1800-01-01',NULL,0),
	(4149,60,'Sassocorvaro',0,'1800-01-01',NULL,0),
	(4150,60,'Sassofeltrio',0,'1800-01-01',NULL,0),
	(4151,60,'Serra Sant\'Abbondio',0,'1800-01-01',NULL,0),
	(4152,60,'Serrungarina',0,'1800-01-01',NULL,0),
	(4153,60,'Tavoleto',0,'1800-01-01',NULL,0),
	(4154,60,'Tavullia',0,'1800-01-01',NULL,0),
	(4155,60,'Urbania',0,'1800-01-01',NULL,0),
	(4156,60,'Urbino',0,'1800-01-01',NULL,0),
	(4157,61,'Agugliano',0,'1800-01-01',NULL,0),
	(4158,61,'Ancona',1,'1800-01-01',NULL,0),
	(4159,61,'Arcevia',0,'1800-01-01',NULL,0),
	(4160,61,'Barbara',0,'1800-01-01',NULL,0),
	(4161,61,'Belvedere Ostrense',0,'1800-01-01',NULL,0),
	(4162,61,'Camerano',0,'1800-01-01',NULL,0),
	(4163,61,'Camerata Picena',0,'1800-01-01',NULL,0),
	(4164,61,'Castelbellino',0,'1800-01-01',NULL,0),
	(4165,61,'Castel Colonna',0,'1800-01-01',NULL,0),
	(4166,61,'Castelfidardo',0,'1800-01-01',NULL,0),
	(4167,61,'Castelleone di Suasa',0,'1800-01-01',NULL,0),
	(4168,61,'Castelplanio',0,'1800-01-01',NULL,0),
	(4169,61,'Cerreto d\'Esi',0,'1800-01-01',NULL,0),
	(4170,61,'Chiaravalle',0,'1800-01-01',NULL,0),
	(4171,61,'Corinaldo',0,'1800-01-01',NULL,0),
	(4172,61,'Cupramontana',0,'1800-01-01',NULL,0),
	(4173,61,'Fabriano',0,'1800-01-01',NULL,0),
	(4174,61,'Falconara Marittima',0,'1800-01-01',NULL,0),
	(4175,61,'Filottrano',0,'1800-01-01',NULL,0),
	(4176,61,'Genga',0,'1800-01-01',NULL,0),
	(4177,61,'Jesi',0,'1800-01-01',NULL,0),
	(4178,61,'Loreto',0,'1800-01-01',NULL,0),
	(4179,61,'Maiolati Spontini',0,'1800-01-01',NULL,0),
	(4180,61,'Mergo',0,'1800-01-01',NULL,0),
	(4181,61,'Monsano',0,'1800-01-01',NULL,0),
	(4182,61,'Montecarotto',0,'1800-01-01',NULL,0),
	(4183,61,'Montemarciano',0,'1800-01-01',NULL,0),
	(4184,61,'Monterado',0,'1800-01-01',NULL,0),
	(4185,61,'Monte Roberto',0,'1800-01-01',NULL,0),
	(4186,61,'Monte San Vito',0,'1800-01-01',NULL,0),
	(4187,61,'Morro d\'Alba',0,'1800-01-01',NULL,0),
	(4188,61,'Numana',0,'1800-01-01',NULL,0),
	(4189,61,'Offagna',0,'1800-01-01',NULL,0),
	(4190,61,'Osimo',0,'1800-01-01',NULL,0),
	(4191,61,'Ostra',0,'1800-01-01',NULL,0),
	(4192,61,'Ostra Vetere',0,'1800-01-01',NULL,0),
	(4193,61,'Poggio San Marcello',0,'1800-01-01',NULL,0),
	(4194,61,'Polverigi',0,'1800-01-01',NULL,0),
	(4195,61,'Ripe',0,'1800-01-01',NULL,0),
	(4196,61,'Rosora',0,'1800-01-01',NULL,0),
	(4197,61,'San Marcello',0,'1800-01-01',NULL,0),
	(4198,61,'San Paolo di Jesi',0,'1800-01-01',NULL,0),
	(4199,61,'Santa Maria Nuova',0,'1800-01-01',NULL,0),
	(4200,61,'Sassoferrato',0,'1800-01-01',NULL,0),
	(4201,61,'Senigallia',0,'1800-01-01',NULL,0),
	(4202,61,'Serra de\' Conti',0,'1800-01-01',NULL,0),
	(4203,61,'Serra San Quirico',0,'1800-01-01',NULL,0),
	(4204,61,'Sirolo',0,'1800-01-01',NULL,0),
	(4205,61,'Staffolo',0,'1800-01-01',NULL,0),
	(4206,62,'Acquacanina',0,'1800-01-01',NULL,0),
	(4207,62,'Apiro',0,'1800-01-01',NULL,0),
	(4208,62,'Appignano',0,'1800-01-01',NULL,0),
	(4209,62,'Belforte del Chienti',0,'1800-01-01',NULL,0),
	(4210,62,'Bolognola',0,'1800-01-01',NULL,0),
	(4211,62,'Caldarola',0,'1800-01-01',NULL,0),
	(4212,62,'Camerino',0,'1800-01-01',NULL,0),
	(4213,62,'Camporotondo di Fiastrone',0,'1800-01-01',NULL,0),
	(4214,62,'Castelraimondo',0,'1800-01-01',NULL,0),
	(4215,62,'Castelsantangelo sul Nera',0,'1800-01-01',NULL,0),
	(4216,62,'Cessapalombo',0,'1800-01-01',NULL,0),
	(4217,62,'Cingoli',0,'1800-01-01',NULL,0),
	(4218,62,'Civitanova Marche',0,'1800-01-01',NULL,0),
	(4219,62,'Colmurano',0,'1800-01-01',NULL,0),
	(4220,62,'Corridonia',0,'1800-01-01',NULL,0),
	(4221,62,'Esanatoglia',0,'1800-01-01',NULL,0),
	(4222,62,'Fiastra',0,'1800-01-01',NULL,0),
	(4223,62,'Fiordimonte',0,'1800-01-01',NULL,0),
	(4224,62,'Fiuminata',0,'1800-01-01',NULL,0),
	(4225,62,'Gagliole',0,'1800-01-01',NULL,0),
	(4226,62,'Gualdo',0,'1800-01-01',NULL,0),
	(4227,62,'Loro Piceno',0,'1800-01-01',NULL,0),
	(4228,62,'Macerata',1,'1800-01-01',NULL,0),
	(4229,62,'Matelica',0,'1800-01-01',NULL,0),
	(4230,62,'Mogliano',0,'1800-01-01',NULL,0),
	(4231,62,'Montecassiano',0,'1800-01-01',NULL,0),
	(4232,62,'Monte Cavallo',0,'1800-01-01',NULL,0),
	(4233,62,'Montecosaro',0,'1800-01-01',NULL,0),
	(4234,62,'Montefano',0,'1800-01-01',NULL,0),
	(4235,62,'Montelupone',0,'1800-01-01',NULL,0),
	(4236,62,'Monte San Giusto',0,'1800-01-01',NULL,0),
	(4237,62,'Monte San Martino',0,'1800-01-01',NULL,0),
	(4238,62,'Morrovalle',0,'1800-01-01',NULL,0),
	(4239,62,'Muccia',0,'1800-01-01',NULL,0),
	(4240,62,'Penna San Giovanni',0,'1800-01-01',NULL,0),
	(4241,62,'Petriolo',0,'1800-01-01',NULL,0),
	(4242,62,'Pievebovigliana',0,'1800-01-01',NULL,0),
	(4243,62,'Pieve Torina',0,'1800-01-01',NULL,0),
	(4244,62,'Pioraco',0,'1800-01-01',NULL,0),
	(4245,62,'Poggio San Vicino',0,'1800-01-01',NULL,0),
	(4246,62,'Pollenza',0,'1800-01-01',NULL,0),
	(4247,62,'Porto Recanati',0,'1800-01-01',NULL,0),
	(4248,62,'Potenza Picena',0,'1800-01-01',NULL,0),
	(4249,62,'Recanati',0,'1800-01-01',NULL,0),
	(4250,62,'Ripe San Ginesio',0,'1800-01-01',NULL,0),
	(4251,62,'San Ginesio',0,'1800-01-01',NULL,0),
	(4252,62,'San Severino Marche',0,'1800-01-01',NULL,0),
	(4253,62,'Sant\'Angelo in Pontano',0,'1800-01-01',NULL,0),
	(4254,62,'Sarnano',0,'1800-01-01',NULL,0),
	(4255,62,'Sefro',0,'1800-01-01',NULL,0),
	(4256,62,'Serrapetrona',0,'1800-01-01',NULL,0),
	(4257,62,'Serravalle di Chienti',0,'1800-01-01',NULL,0),
	(4258,62,'Tolentino',0,'1800-01-01',NULL,0),
	(4259,62,'Treia',0,'1800-01-01',NULL,0),
	(4260,62,'Urbisaglia',0,'1800-01-01',NULL,0),
	(4261,62,'Ussita',0,'1800-01-01',NULL,0),
	(4262,62,'Visso',0,'1800-01-01',NULL,0),
	(4263,63,'Acquasanta Terme',0,'1800-01-01',NULL,0),
	(4264,63,'Acquaviva Picena',0,'1800-01-01',NULL,0),
	(4265,63,'Appignano del Tronto',0,'1800-01-01',NULL,0),
	(4266,63,'Arquata del Tronto',0,'1800-01-01',NULL,0),
	(4267,63,'Ascoli Piceno',1,'1800-01-01',NULL,0),
	(4268,63,'Carassai',0,'1800-01-01',NULL,0),
	(4269,63,'Castel di Lama',0,'1800-01-01',NULL,0),
	(4270,63,'Castignano',0,'1800-01-01',NULL,0),
	(4271,63,'Castorano',0,'1800-01-01',NULL,0),
	(4272,63,'Colli del Tronto',0,'1800-01-01',NULL,0),
	(4273,63,'Comunanza',0,'1800-01-01',NULL,0),
	(4274,63,'Cossignano',0,'1800-01-01',NULL,0),
	(4275,63,'Cupra Marittima',0,'1800-01-01',NULL,0),
	(4276,63,'Folignano',0,'1800-01-01',NULL,0),
	(4277,63,'Force',0,'1800-01-01',NULL,0),
	(4278,63,'Grottammare',0,'1800-01-01',NULL,0),
	(4279,63,'Maltignano',0,'1800-01-01',NULL,0),
	(4280,63,'Massignano',0,'1800-01-01',NULL,0),
	(4281,63,'Monsampolo del Tronto',0,'1800-01-01',NULL,0),
	(4282,63,'Montalto delle Marche',0,'1800-01-01',NULL,0),
	(4283,63,'Montedinove',0,'1800-01-01',NULL,0),
	(4284,63,'Montefiore dell\'Aso',0,'1800-01-01',NULL,0),
	(4285,63,'Montegallo',0,'1800-01-01',NULL,0),
	(4286,63,'Montemonaco',0,'1800-01-01',NULL,0),
	(4287,63,'Monteprandone',0,'1800-01-01',NULL,0),
	(4288,63,'Offida',0,'1800-01-01',NULL,0),
	(4289,63,'Palmiano',0,'1800-01-01',NULL,0),
	(4290,63,'Ripatransone',0,'1800-01-01',NULL,0),
	(4291,63,'Roccafluvione',0,'1800-01-01',NULL,0),
	(4292,63,'Rotella',0,'1800-01-01',NULL,0),
	(4293,63,'San Benedetto del Tronto',0,'1800-01-01',NULL,0),
	(4294,63,'Spinetoli',0,'1800-01-01',NULL,0),
	(4295,63,'Venarotta',0,'1800-01-01',NULL,0),
	(4296,48,'Aulla',0,'1800-01-01',NULL,0),
	(4297,48,'Bagnone',0,'1800-01-01',NULL,0),
	(4298,48,'Carrara',0,'1800-01-01',NULL,0),
	(4299,48,'Casola in Lunigiana',0,'1800-01-01',NULL,0),
	(4300,48,'Comano',0,'1800-01-01',NULL,0),
	(4301,48,'Filattiera',0,'1800-01-01',NULL,0),
	(4302,48,'Fivizzano',0,'1800-01-01',NULL,0),
	(4303,48,'Fosdinovo',0,'1800-01-01',NULL,0),
	(4304,48,'Licciana Nardi',0,'1800-01-01',NULL,0),
	(4305,48,'Massa',1,'1800-01-01',NULL,0),
	(4306,48,'Montignoso',0,'1800-01-01',NULL,0),
	(4307,48,'Mulazzo',0,'1800-01-01',NULL,0),
	(4308,48,'Podenzana',0,'1800-01-01',NULL,0),
	(4309,48,'Pontremoli',0,'1800-01-01',NULL,0),
	(4310,48,'Tresana',0,'1800-01-01',NULL,0),
	(4311,48,'Villafranca in Lunigiana',0,'1800-01-01',NULL,0),
	(4312,48,'Zeri',0,'1800-01-01',NULL,0),
	(4313,49,'Altopascio',0,'1800-01-01',NULL,0),
	(4314,49,'Bagni di Lucca',0,'1800-01-01',NULL,0),
	(4315,49,'Barga',0,'1800-01-01',NULL,0),
	(4316,49,'Borgo a Mozzano',0,'1800-01-01',NULL,0),
	(4317,49,'Camaiore',0,'1800-01-01',NULL,0),
	(4318,49,'Camporgiano',0,'1800-01-01',NULL,0),
	(4319,49,'Capannori',0,'1800-01-01',NULL,0),
	(4320,49,'Careggine',0,'1800-01-01',NULL,0),
	(4321,49,'Castelnuovo di Garfagnana',0,'1800-01-01',NULL,0),
	(4322,49,'Castiglione di Garfagnana',0,'1800-01-01',NULL,0),
	(4323,49,'Coreglia Antelminelli',0,'1800-01-01',NULL,0),
	(4324,49,'Fabbriche di Vallico',0,'1800-01-01',NULL,0),
	(4325,49,'Forte dei Marmi',0,'1800-01-01',NULL,0),
	(4326,49,'Fosciandora',0,'1800-01-01',NULL,0),
	(4327,49,'Gallicano',0,'1800-01-01',NULL,0),
	(4328,49,'Giuncugnano',0,'1800-01-01',NULL,0),
	(4329,49,'Lucca',1,'1800-01-01',NULL,0),
	(4330,49,'Massarosa',0,'1800-01-01',NULL,0),
	(4331,49,'Minucciano',0,'1800-01-01',NULL,0),
	(4332,49,'Molazzana',0,'1800-01-01',NULL,0),
	(4333,49,'Montecarlo',0,'1800-01-01',NULL,0),
	(4334,49,'Pescaglia',0,'1800-01-01',NULL,0),
	(4335,49,'Piazza al Serchio',0,'1800-01-01',NULL,0),
	(4336,49,'Pietrasanta',0,'1800-01-01',NULL,0),
	(4337,49,'Pieve Fosciana',0,'1800-01-01',NULL,0),
	(4338,49,'Porcari',0,'1800-01-01',NULL,0),
	(4339,49,'San Romano in Garfagnana',0,'1800-01-01',NULL,0),
	(4340,49,'Seravezza',0,'1800-01-01',NULL,0),
	(4341,49,'Sillano',0,'1800-01-01',NULL,0),
	(4342,49,'Stazzema',0,'1800-01-01',NULL,0),
	(4343,49,'Vagli Sotto',0,'1800-01-01',NULL,0),
	(4344,49,'Vergemoli',0,'1800-01-01',NULL,0),
	(4345,49,'Viareggio',0,'1800-01-01',NULL,0),
	(4346,49,'Villa Basilica',0,'1800-01-01',NULL,0),
	(4347,49,'Villa Collemandina',0,'1800-01-01',NULL,0),
	(4348,50,'Abetone',0,'1800-01-01',NULL,0),
	(4349,50,'Agliana',0,'1800-01-01',NULL,0),
	(4350,50,'Buggiano',0,'1800-01-01',NULL,0),
	(4351,50,'Cutigliano',0,'1800-01-01',NULL,0),
	(4352,50,'Lamporecchio',0,'1800-01-01',NULL,0),
	(4353,50,'Larciano',0,'1800-01-01',NULL,0),
	(4354,50,'Marliana',0,'1800-01-01',NULL,0),
	(4355,50,'Massa e Cozzile',0,'1800-01-01',NULL,0),
	(4356,50,'Monsummano Terme',0,'1800-01-01',NULL,0),
	(4357,50,'Montale',0,'1800-01-01',NULL,0),
	(4358,50,'Montecatini-Terme',0,'1800-01-01',NULL,0),
	(4359,50,'Pescia',0,'1800-01-01',NULL,0),
	(4360,50,'Pieve a Nievole',0,'1800-01-01',NULL,0),
	(4361,50,'Pistoia',1,'1800-01-01',NULL,0),
	(4362,50,'Piteglio',0,'1800-01-01',NULL,0),
	(4363,50,'Ponte Buggianese',0,'1800-01-01',NULL,0),
	(4364,50,'Quarrata',0,'1800-01-01',NULL,0),
	(4365,50,'Sambuca Pistoiese',0,'1800-01-01',NULL,0),
	(4366,50,'San Marcello Pistoiese',0,'1800-01-01',NULL,0),
	(4367,50,'Serravalle Pistoiese',0,'1800-01-01',NULL,0),
	(4368,50,'Uzzano',0,'1800-01-01',NULL,0),
	(4369,50,'Chiesina Uzzanese',0,'1800-01-01',NULL,0),
	(4370,51,'Bagno a Ripoli',0,'1800-01-01',NULL,0),
	(4371,51,'Barberino di Mugello',0,'1800-01-01',NULL,0),
	(4372,51,'Barberino Val d\'Elsa',0,'1800-01-01',NULL,0),
	(4373,51,'Borgo San Lorenzo',0,'1800-01-01',NULL,0),
	(4374,51,'Calenzano',0,'1800-01-01',NULL,0),
	(4375,51,'Campi Bisenzio',0,'1800-01-01',NULL,0),
	(4376,51,'Capraia e Limite',0,'1800-01-01',NULL,0),
	(4377,51,'Castelfiorentino',0,'1800-01-01',NULL,0),
	(4378,51,'Cerreto Guidi',0,'1800-01-01',NULL,0),
	(4379,51,'Certaldo',0,'1800-01-01',NULL,0),
	(4380,51,'Dicomano',0,'1800-01-01',NULL,0),
	(4381,51,'Empoli',0,'1800-01-01',NULL,0),
	(4382,51,'Fiesole',0,'1800-01-01',NULL,0),
	(4383,51,'Figline Valdarno',0,'1800-01-01',NULL,0),
	(4384,51,'Firenze',1,'1800-01-01',NULL,0),
	(4385,51,'Firenzuola',0,'1800-01-01',NULL,0),
	(4386,51,'Fucecchio',0,'1800-01-01',NULL,0),
	(4387,51,'Gambassi Terme',0,'1800-01-01',NULL,0),
	(4388,51,'Greve in Chianti',0,'1800-01-01',NULL,0),
	(4389,51,'Impruneta',0,'1800-01-01',NULL,0),
	(4390,51,'Incisa in Val d\'Arno',0,'1800-01-01',NULL,0),
	(4391,51,'Lastra a Signa',0,'1800-01-01',NULL,0),
	(4392,51,'Londa',0,'1800-01-01',NULL,0),
	(4393,51,'Marradi',0,'1800-01-01',NULL,0),
	(4394,51,'Montaione',0,'1800-01-01',NULL,0),
	(4395,51,'Montelupo Fiorentino',0,'1800-01-01',NULL,0),
	(4396,51,'Montespertoli',0,'1800-01-01',NULL,0),
	(4397,51,'Palazzuolo sul Senio',0,'1800-01-01',NULL,0),
	(4398,51,'Pelago',0,'1800-01-01',NULL,0),
	(4399,51,'Pontassieve',0,'1800-01-01',NULL,0),
	(4400,51,'Reggello',0,'1800-01-01',NULL,0),
	(4401,51,'Rignano sull\'Arno',0,'1800-01-01',NULL,0),
	(4402,51,'Rufina',0,'1800-01-01',NULL,0),
	(4403,51,'San Casciano in Val di Pesa',0,'1800-01-01',NULL,0),
	(4404,51,'San Godenzo',0,'1800-01-01',NULL,0),
	(4405,51,'San Piero a Sieve',0,'1800-01-01',NULL,0),
	(4406,51,'Scandicci',0,'1800-01-01',NULL,0),
	(4407,51,'Scarperia',0,'1800-01-01',NULL,0),
	(4408,51,'Sesto Fiorentino',0,'1800-01-01',NULL,0),
	(4409,51,'Signa',0,'1800-01-01',NULL,0),
	(4410,51,'Tavarnelle Val di Pesa',0,'1800-01-01',NULL,0),
	(4411,51,'Vaglia',0,'1800-01-01',NULL,0),
	(4412,51,'Vicchio',0,'1800-01-01',NULL,0),
	(4413,51,'Vinci',0,'1800-01-01',NULL,0),
	(4414,52,'Bibbona',0,'1800-01-01',NULL,0),
	(4415,52,'Campiglia Marittima',0,'1800-01-01',NULL,0),
	(4416,52,'Campo nell\'Elba',0,'1800-01-01',NULL,0),
	(4417,52,'Capoliveri',0,'1800-01-01',NULL,0),
	(4418,52,'Capraia Isola',0,'1800-01-01',NULL,0),
	(4419,52,'Castagneto Carducci',0,'1800-01-01',NULL,0),
	(4420,52,'Cecina',0,'1800-01-01',NULL,0),
	(4421,52,'Collesalvetti',0,'1800-01-01',NULL,0),
	(4422,52,'Livorno',1,'1800-01-01',NULL,0),
	(4423,52,'Marciana',0,'1800-01-01',NULL,0),
	(4424,52,'Marciana Marina',0,'1800-01-01',NULL,0),
	(4425,52,'Piombino',0,'1800-01-01',NULL,0),
	(4426,52,'Porto Azzurro',0,'1800-01-01',NULL,0),
	(4427,52,'Portoferraio',0,'1800-01-01',NULL,0),
	(4428,52,'Rio Marina',0,'1800-01-01',NULL,0),
	(4429,52,'Rio nell\'Elba',0,'1800-01-01',NULL,0),
	(4430,52,'Rosignano Marittimo',0,'1800-01-01',NULL,0),
	(4431,52,'San Vincenzo',0,'1800-01-01',NULL,0),
	(4432,52,'Sassetta',0,'1800-01-01',NULL,0),
	(4433,52,'Suvereto',0,'1800-01-01',NULL,0),
	(4434,53,'Bientina',0,'1800-01-01',NULL,0),
	(4435,53,'Buti',0,'1800-01-01',NULL,0),
	(4436,53,'Calci',0,'1800-01-01',NULL,0),
	(4437,53,'Calcinaia',0,'1800-01-01',NULL,0),
	(4438,53,'Capannoli',0,'1800-01-01',NULL,0),
	(4439,53,'Casale Marittimo',0,'1800-01-01',NULL,0),
	(4440,53,'Casciana Terme',0,'1800-01-01',NULL,0),
	(4441,53,'Cascina',0,'1800-01-01',NULL,0),
	(4442,53,'Castelfranco di Sotto',0,'1800-01-01',NULL,0),
	(4443,53,'Castellina Marittima',0,'1800-01-01',NULL,0),
	(4444,53,'Castelnuovo di Val di Cecina',0,'1800-01-01',NULL,0),
	(4445,53,'Chianni',0,'1800-01-01',NULL,0),
	(4446,53,'Crespina',0,'1800-01-01',NULL,0),
	(4447,53,'Fauglia',0,'1800-01-01',NULL,0),
	(4448,53,'Guardistallo',0,'1800-01-01',NULL,0),
	(4449,53,'Lajatico',0,'1800-01-01',NULL,0),
	(4450,53,'Lari',0,'1800-01-01',NULL,0),
	(4451,53,'Lorenzana',0,'1800-01-01',NULL,0),
	(4452,53,'Montecatini Val di Cecina',0,'1800-01-01',NULL,0),
	(4453,53,'Montescudaio',0,'1800-01-01',NULL,0),
	(4454,53,'Monteverdi Marittimo',0,'1800-01-01',NULL,0),
	(4455,53,'Montopoli in Val d\'Arno',0,'1800-01-01',NULL,0),
	(4456,53,'Orciano Pisano',0,'1800-01-01',NULL,0),
	(4457,53,'Palaia',0,'1800-01-01',NULL,0),
	(4458,53,'Peccioli',0,'1800-01-01',NULL,0),
	(4459,53,'Pisa',1,'1800-01-01',NULL,0),
	(4460,53,'Pomarance',0,'1800-01-01',NULL,0),
	(4461,53,'Ponsacco',0,'1800-01-01',NULL,0),
	(4462,53,'Pontedera',0,'1800-01-01',NULL,0),
	(4463,53,'Riparbella',0,'1800-01-01',NULL,0),
	(4464,53,'San Giuliano Terme',0,'1800-01-01',NULL,0),
	(4465,53,'San Miniato',0,'1800-01-01',NULL,0),
	(4466,53,'Santa Croce sull\'Arno',0,'1800-01-01',NULL,0),
	(4467,53,'Santa Luce',0,'1800-01-01',NULL,0),
	(4468,53,'Santa Maria a Monte',0,'1800-01-01',NULL,0),
	(4469,53,'Terricciola',0,'1800-01-01',NULL,0),
	(4470,53,'Vecchiano',0,'1800-01-01',NULL,0),
	(4471,53,'Vicopisano',0,'1800-01-01',NULL,0),
	(4472,53,'Volterra',0,'1800-01-01',NULL,0),
	(4473,54,'Anghiari',0,'1800-01-01',NULL,0),
	(4474,54,'Arezzo',1,'1800-01-01',NULL,0),
	(4475,54,'Badia Tedalda',0,'1800-01-01',NULL,0),
	(4476,54,'Bibbiena',0,'1800-01-01',NULL,0),
	(4477,54,'Bucine',0,'1800-01-01',NULL,0),
	(4478,54,'Capolona',0,'1800-01-01',NULL,0),
	(4479,54,'Caprese Michelangelo',0,'1800-01-01',NULL,0),
	(4480,54,'Castel Focognano',0,'1800-01-01',NULL,0),
	(4481,54,'Castelfranco di Sopra',0,'1800-01-01',NULL,0),
	(4482,54,'Castel San Niccolò',0,'1800-01-01',NULL,0),
	(4483,54,'Castiglion Fibocchi',0,'1800-01-01',NULL,0),
	(4484,54,'Castiglion Fiorentino',0,'1800-01-01',NULL,0),
	(4485,54,'Cavriglia',0,'1800-01-01',NULL,0),
	(4486,54,'Chitignano',0,'1800-01-01',NULL,0),
	(4487,54,'Chiusi della Verna',0,'1800-01-01',NULL,0),
	(4488,54,'Civitella in Val di Chiana',0,'1800-01-01',NULL,0),
	(4489,54,'Cortona',0,'1800-01-01',NULL,0),
	(4490,54,'Foiano della Chiana',0,'1800-01-01',NULL,0),
	(4491,54,'Laterina',0,'1800-01-01',NULL,0),
	(4492,54,'Loro Ciuffenna',0,'1800-01-01',NULL,0),
	(4493,54,'Lucignano',0,'1800-01-01',NULL,0),
	(4494,54,'Marciano della Chiana',0,'1800-01-01',NULL,0),
	(4495,54,'Montemignaio',0,'1800-01-01',NULL,0),
	(4496,54,'Monterchi',0,'1800-01-01',NULL,0),
	(4497,54,'Monte San Savino',0,'1800-01-01',NULL,0),
	(4498,54,'Montevarchi',0,'1800-01-01',NULL,0),
	(4499,54,'Ortignano Raggiolo',0,'1800-01-01',NULL,0),
	(4500,54,'Pergine Valdarno',0,'1800-01-01',NULL,0),
	(4501,54,'Pian di Sco',0,'1800-01-01',NULL,0),
	(4502,54,'Pieve Santo Stefano',0,'1800-01-01',NULL,0),
	(4503,54,'Poppi',0,'1800-01-01',NULL,0),
	(4504,54,'Pratovecchio',0,'1800-01-01',NULL,0),
	(4505,54,'San Giovanni Valdarno',0,'1800-01-01',NULL,0),
	(4506,54,'Sansepolcro',0,'1800-01-01',NULL,0),
	(4507,54,'Sestino',0,'1800-01-01',NULL,0),
	(4508,54,'Stia',0,'1800-01-01',NULL,0),
	(4509,54,'Subbiano',0,'1800-01-01',NULL,0),
	(4510,54,'Talla',0,'1800-01-01',NULL,0),
	(4511,54,'Terranuova Bracciolini',0,'1800-01-01',NULL,0),
	(4512,55,'Abbadia San Salvatore',0,'1800-01-01',NULL,0),
	(4513,55,'Asciano',0,'1800-01-01',NULL,0),
	(4514,55,'Buonconvento',0,'1800-01-01',NULL,0),
	(4515,55,'Casole d\'Elsa',0,'1800-01-01',NULL,0),
	(4516,55,'Castellina in Chianti',0,'1800-01-01',NULL,0),
	(4517,55,'Castelnuovo Berardenga',0,'1800-01-01',NULL,0),
	(4518,55,'Castiglione d\'Orcia',0,'1800-01-01',NULL,0),
	(4519,55,'Cetona',0,'1800-01-01',NULL,0),
	(4520,55,'Chianciano Terme',0,'1800-01-01',NULL,0),
	(4521,55,'Chiusdino',0,'1800-01-01',NULL,0),
	(4522,55,'Chiusi',0,'1800-01-01',NULL,0),
	(4523,55,'Colle di Val d\'Elsa',0,'1800-01-01',NULL,0),
	(4524,55,'Gaiole in Chianti',0,'1800-01-01',NULL,0),
	(4525,55,'Montalcino',0,'1800-01-01',NULL,0),
	(4526,55,'Montepulciano',0,'1800-01-01',NULL,0),
	(4527,55,'Monteriggioni',0,'1800-01-01',NULL,0),
	(4528,55,'Monteroni d\'Arbia',0,'1800-01-01',NULL,0),
	(4529,55,'Monticiano',0,'1800-01-01',NULL,0),
	(4530,55,'Murlo',0,'1800-01-01',NULL,0),
	(4531,55,'Piancastagnaio',0,'1800-01-01',NULL,0),
	(4532,55,'Pienza',0,'1800-01-01',NULL,0),
	(4533,55,'Poggibonsi',0,'1800-01-01',NULL,0),
	(4534,55,'Radda in Chianti',0,'1800-01-01',NULL,0),
	(4535,55,'Radicofani',0,'1800-01-01',NULL,0),
	(4536,55,'Radicondoli',0,'1800-01-01',NULL,0),
	(4537,55,'Rapolano Terme',0,'1800-01-01',NULL,0),
	(4538,55,'San Casciano dei Bagni',0,'1800-01-01',NULL,0),
	(4539,55,'San Gimignano',0,'1800-01-01',NULL,0),
	(4540,55,'San Giovanni d\'Asso',0,'1800-01-01',NULL,0),
	(4541,55,'San Quirico d\'Orcia',0,'1800-01-01',NULL,0),
	(4542,55,'Sarteano',0,'1800-01-01',NULL,0),
	(4543,55,'Siena',1,'1800-01-01',NULL,0),
	(4544,55,'Sinalunga',0,'1800-01-01',NULL,0),
	(4545,55,'Sovicille',0,'1800-01-01',NULL,0),
	(4546,55,'Torrita di Siena',0,'1800-01-01',NULL,0),
	(4547,55,'Trequanda',0,'1800-01-01',NULL,0),
	(4548,56,'Arcidosso',0,'1800-01-01',NULL,0),
	(4549,56,'Campagnatico',0,'1800-01-01',NULL,0),
	(4550,56,'Capalbio',0,'1800-01-01',NULL,0),
	(4551,56,'Castel del Piano',0,'1800-01-01',NULL,0),
	(4552,56,'Castell\'Azzara',0,'1800-01-01',NULL,0),
	(4553,56,'Castiglione della Pescaia',0,'1800-01-01',NULL,0),
	(4554,56,'Cinigiano',0,'1800-01-01',NULL,0),
	(4555,56,'Civitella Paganico',0,'1800-01-01',NULL,0),
	(4556,56,'Follonica',0,'1800-01-01',NULL,0),
	(4557,56,'Gavorrano',0,'1800-01-01',NULL,0),
	(4558,56,'Grosseto',1,'1800-01-01',NULL,0),
	(4559,56,'Isola del Giglio',0,'1800-01-01',NULL,0),
	(4560,56,'Magliano in Toscana',0,'1800-01-01',NULL,0),
	(4561,56,'Manciano',0,'1800-01-01',NULL,0),
	(4562,56,'Massa Marittima',0,'1800-01-01',NULL,0),
	(4563,56,'Monte Argentario',0,'1800-01-01',NULL,0),
	(4564,56,'Montieri',0,'1800-01-01',NULL,0),
	(4565,56,'Orbetello',0,'1800-01-01',NULL,0),
	(4566,56,'Pitigliano',0,'1800-01-01',NULL,0),
	(4567,56,'Roccalbegna',0,'1800-01-01',NULL,0),
	(4568,56,'Roccastrada',0,'1800-01-01',NULL,0),
	(4569,56,'Santa Fiora',0,'1800-01-01',NULL,0),
	(4570,56,'Scansano',0,'1800-01-01',NULL,0),
	(4571,56,'Scarlino',0,'1800-01-01',NULL,0),
	(4572,56,'Seggiano',0,'1800-01-01',NULL,0),
	(4573,56,'Sorano',0,'1800-01-01',NULL,0),
	(4574,56,'Monterotondo Marittimo',0,'1800-01-01',NULL,0),
	(4575,56,'Semproniano',0,'1800-01-01',NULL,0),
	(4576,58,'Assisi',0,'1800-01-01',NULL,0),
	(4577,58,'Bastia Umbra',0,'1800-01-01',NULL,0),
	(4578,58,'Bettona',0,'1800-01-01',NULL,0),
	(4579,58,'Bevagna',0,'1800-01-01',NULL,0),
	(4580,58,'Campello sul Clitunno',0,'1800-01-01',NULL,0),
	(4581,58,'Cannara',0,'1800-01-01',NULL,0),
	(4582,58,'Cascia',0,'1800-01-01',NULL,0),
	(4583,58,'Castel Ritaldi',0,'1800-01-01',NULL,0),
	(4584,58,'Castiglione del Lago',0,'1800-01-01',NULL,0),
	(4585,58,'Cerreto di Spoleto',0,'1800-01-01',NULL,0),
	(4586,58,'Citerna',0,'1800-01-01',NULL,0),
	(4587,58,'Città della Pieve',0,'1800-01-01',NULL,0),
	(4588,58,'Città di Castello',0,'1800-01-01',NULL,0),
	(4589,58,'Collazzone',0,'1800-01-01',NULL,0),
	(4590,58,'Corciano',0,'1800-01-01',NULL,0),
	(4591,58,'Costacciaro',0,'1800-01-01',NULL,0),
	(4592,58,'Deruta',0,'1800-01-01',NULL,0),
	(4593,58,'Foligno',0,'1800-01-01',NULL,0),
	(4594,58,'Fossato di Vico',0,'1800-01-01',NULL,0),
	(4595,58,'Fratta Todina',0,'1800-01-01',NULL,0),
	(4596,58,'Giano dell\'Umbria',0,'1800-01-01',NULL,0),
	(4597,58,'Gualdo Cattaneo',0,'1800-01-01',NULL,0),
	(4598,58,'Gualdo Tadino',0,'1800-01-01',NULL,0),
	(4599,58,'Gubbio',0,'1800-01-01',NULL,0),
	(4600,58,'Lisciano Niccone',0,'1800-01-01',NULL,0),
	(4601,58,'Magione',0,'1800-01-01',NULL,0),
	(4602,58,'Marsciano',0,'1800-01-01',NULL,0),
	(4603,58,'Massa Martana',0,'1800-01-01',NULL,0),
	(4604,58,'Monte Castello di Vibio',0,'1800-01-01',NULL,0),
	(4605,58,'Montefalco',0,'1800-01-01',NULL,0),
	(4606,58,'Monteleone di Spoleto',0,'1800-01-01',NULL,0),
	(4607,58,'Monte Santa Maria Tiberina',0,'1800-01-01',NULL,0),
	(4608,58,'Montone',0,'1800-01-01',NULL,0),
	(4609,58,'Nocera Umbra',0,'1800-01-01',NULL,0),
	(4610,58,'Norcia',0,'1800-01-01',NULL,0),
	(4611,58,'Paciano',0,'1800-01-01',NULL,0),
	(4612,58,'Panicale',0,'1800-01-01',NULL,0),
	(4613,58,'Passignano sul Trasimeno',0,'1800-01-01',NULL,0),
	(4614,58,'Perugia',1,'1800-01-01',NULL,0),
	(4615,58,'Piegaro',0,'1800-01-01',NULL,0),
	(4616,58,'Pietralunga',0,'1800-01-01',NULL,0),
	(4617,58,'Poggiodomo',0,'1800-01-01',NULL,0),
	(4618,58,'Preci',0,'1800-01-01',NULL,0),
	(4619,58,'San Giustino',0,'1800-01-01',NULL,0),
	(4620,58,'Sant\'Anatolia di Narco',0,'1800-01-01',NULL,0),
	(4621,58,'Scheggia e Pascelupo',0,'1800-01-01',NULL,0),
	(4622,58,'Scheggino',0,'1800-01-01',NULL,0),
	(4623,58,'Sellano',0,'1800-01-01',NULL,0),
	(4624,58,'Sigillo',0,'1800-01-01',NULL,0),
	(4625,58,'Spello',0,'1800-01-01',NULL,0),
	(4626,58,'Spoleto',0,'1800-01-01',NULL,0),
	(4627,58,'Todi',0,'1800-01-01',NULL,0),
	(4628,58,'Torgiano',0,'1800-01-01',NULL,0),
	(4629,58,'Trevi',0,'1800-01-01',NULL,0),
	(4630,58,'Tuoro sul Trasimeno',0,'1800-01-01',NULL,0),
	(4631,58,'Umbertide',0,'1800-01-01',NULL,0),
	(4632,58,'Valfabbrica',0,'1800-01-01',NULL,0),
	(4633,58,'Vallo di Nera',0,'1800-01-01',NULL,0),
	(4634,58,'Valtopina',0,'1800-01-01',NULL,0),
	(4635,59,'Acquasparta',0,'1800-01-01',NULL,0),
	(4636,59,'Allerona',0,'1800-01-01',NULL,0),
	(4637,59,'Alviano',0,'1800-01-01',NULL,0),
	(4638,59,'Amelia',0,'1800-01-01',NULL,0),
	(4639,59,'Arrone',0,'1800-01-01',NULL,0),
	(4640,59,'Attigliano',0,'1800-01-01',NULL,0),
	(4641,59,'Baschi',0,'1800-01-01',NULL,0),
	(4642,59,'Calvi dell\'Umbria',0,'1800-01-01',NULL,0),
	(4643,59,'Castel Giorgio',0,'1800-01-01',NULL,0),
	(4644,59,'Castel Viscardo',0,'1800-01-01',NULL,0),
	(4645,59,'Fabro',0,'1800-01-01',NULL,0),
	(4646,59,'Ferentillo',0,'1800-01-01',NULL,0),
	(4647,59,'Ficulle',0,'1800-01-01',NULL,0),
	(4648,59,'Giove',0,'1800-01-01',NULL,0),
	(4649,59,'Guardea',0,'1800-01-01',NULL,0),
	(4650,59,'Lugnano in Teverina',0,'1800-01-01',NULL,0),
	(4651,59,'Montecastrilli',0,'1800-01-01',NULL,0),
	(4652,59,'Montecchio',0,'1800-01-01',NULL,0),
	(4653,59,'Montefranco',0,'1800-01-01',NULL,0),
	(4654,59,'Montegabbione',0,'1800-01-01',NULL,0),
	(4655,59,'Monteleone d\'Orvieto',0,'1800-01-01',NULL,0),
	(4656,59,'Narni',0,'1800-01-01',NULL,0),
	(4657,59,'Orvieto',0,'1800-01-01',NULL,0),
	(4658,59,'Otricoli',0,'1800-01-01',NULL,0),
	(4659,59,'Parrano',0,'1800-01-01',NULL,0),
	(4660,59,'Penna in Teverina',0,'1800-01-01',NULL,0),
	(4661,59,'Polino',0,'1800-01-01',NULL,0),
	(4662,59,'Porano',0,'1800-01-01',NULL,0),
	(4663,59,'San Gemini',0,'1800-01-01',NULL,0),
	(4664,59,'San Venanzo',0,'1800-01-01',NULL,0),
	(4665,59,'Stroncone',0,'1800-01-01',NULL,0),
	(4666,59,'Terni',1,'1800-01-01',NULL,0),
	(4667,59,'Avigliano Umbro',0,'1800-01-01',NULL,0),
	(4668,65,'Acquapendente',0,'1800-01-01',NULL,0),
	(4669,65,'Arlena di Castro',0,'1800-01-01',NULL,0),
	(4670,65,'Bagnoregio',0,'1800-01-01',NULL,0),
	(4671,65,'Barbarano Romano',0,'1800-01-01',NULL,0),
	(4672,65,'Bassano Romano',0,'1800-01-01',NULL,0),
	(4673,65,'Bassano in Teverina',0,'1800-01-01',NULL,0),
	(4674,65,'Blera',0,'1800-01-01',NULL,0),
	(4675,65,'Bolsena',0,'1800-01-01',NULL,0),
	(4676,65,'Bomarzo',0,'1800-01-01',NULL,0),
	(4677,65,'Calcata',0,'1800-01-01',NULL,0),
	(4678,65,'Canepina',0,'1800-01-01',NULL,0),
	(4679,65,'Canino',0,'1800-01-01',NULL,0),
	(4680,65,'Capodimonte',0,'1800-01-01',NULL,0),
	(4681,65,'Capranica',0,'1800-01-01',NULL,0),
	(4682,65,'Caprarola',0,'1800-01-01',NULL,0),
	(4683,65,'Carbognano',0,'1800-01-01',NULL,0),
	(4684,65,'Castel Sant\'Elia',0,'1800-01-01',NULL,0),
	(4685,65,'Castiglione in Teverina',0,'1800-01-01',NULL,0),
	(4686,65,'Celleno',0,'1800-01-01',NULL,0),
	(4687,65,'Cellere',0,'1800-01-01',NULL,0),
	(4688,65,'Civita Castellana',0,'1800-01-01',NULL,0),
	(4689,65,'Civitella d\'Agliano',0,'1800-01-01',NULL,0),
	(4690,65,'Corchiano',0,'1800-01-01',NULL,0),
	(4691,65,'Fabrica di Roma',0,'1800-01-01',NULL,0),
	(4692,65,'Faleria',0,'1800-01-01',NULL,0),
	(4693,65,'Farnese',0,'1800-01-01',NULL,0),
	(4694,65,'Gallese',0,'1800-01-01',NULL,0),
	(4695,65,'Gradoli',0,'1800-01-01',NULL,0),
	(4696,65,'Graffignano',0,'1800-01-01',NULL,0),
	(4697,65,'Grotte di Castro',0,'1800-01-01',NULL,0),
	(4698,65,'Ischia di Castro',0,'1800-01-01',NULL,0),
	(4699,65,'Latera',0,'1800-01-01',NULL,0),
	(4700,65,'Lubriano',0,'1800-01-01',NULL,0),
	(4701,65,'Marta',0,'1800-01-01',NULL,0),
	(4702,65,'Montalto di Castro',0,'1800-01-01',NULL,0),
	(4703,65,'Montefiascone',0,'1800-01-01',NULL,0),
	(4704,65,'Monte Romano',0,'1800-01-01',NULL,0),
	(4705,65,'Monterosi',0,'1800-01-01',NULL,0),
	(4706,65,'Nepi',0,'1800-01-01',NULL,0),
	(4707,65,'Onano',0,'1800-01-01',NULL,0),
	(4708,65,'Oriolo Romano',0,'1800-01-01',NULL,0),
	(4709,65,'Orte',0,'1800-01-01',NULL,0),
	(4710,65,'Piansano',0,'1800-01-01',NULL,0),
	(4711,65,'Proceno',0,'1800-01-01',NULL,0),
	(4712,65,'Ronciglione',0,'1800-01-01',NULL,0),
	(4713,65,'Villa San Giovanni in Tuscia',0,'1800-01-01',NULL,0),
	(4714,65,'San Lorenzo Nuovo',0,'1800-01-01',NULL,0),
	(4715,65,'Soriano nel Cimino',0,'1800-01-01',NULL,0),
	(4716,65,'Sutri',0,'1800-01-01',NULL,0),
	(4717,65,'Tarquinia',0,'1800-01-01',NULL,0),
	(4718,65,'Tessennano',0,'1800-01-01',NULL,0),
	(4719,65,'Tuscania',0,'1800-01-01',NULL,0),
	(4720,65,'Valentano',0,'1800-01-01',NULL,0),
	(4721,65,'Vallerano',0,'1800-01-01',NULL,0),
	(4722,65,'Vasanello',0,'1800-01-01',NULL,0),
	(4723,65,'Vejano',0,'1800-01-01',NULL,0),
	(4724,65,'Vetralla',0,'1800-01-01',NULL,0),
	(4725,65,'Vignanello',0,'1800-01-01',NULL,0),
	(4726,65,'Viterbo',1,'1800-01-01',NULL,0),
	(4727,65,'Vitorchiano',0,'1800-01-01',NULL,0),
	(4728,66,'Accumoli',0,'1800-01-01',NULL,0),
	(4729,66,'Amatrice',0,'1800-01-01',NULL,0),
	(4730,66,'Antrodoco',0,'1800-01-01',NULL,0),
	(4731,66,'Ascrea',0,'1800-01-01',NULL,0),
	(4732,66,'Belmonte in Sabina',0,'1800-01-01',NULL,0),
	(4733,66,'Borbona',0,'1800-01-01',NULL,0),
	(4734,66,'Borgorose',0,'1800-01-01',NULL,0),
	(4735,66,'Borgo Velino',0,'1800-01-01',NULL,0),
	(4736,66,'Cantalice',0,'1800-01-01',NULL,0),
	(4737,66,'Cantalupo in Sabina',0,'1800-01-01',NULL,0),
	(4738,66,'Casaprota',0,'1800-01-01',NULL,0),
	(4739,66,'Casperia',0,'1800-01-01',NULL,0),
	(4740,66,'Castel di Tora',0,'1800-01-01',NULL,0),
	(4741,66,'Castelnuovo di Farfa',0,'1800-01-01',NULL,0),
	(4742,66,'Castel Sant\'Angelo',0,'1800-01-01',NULL,0),
	(4743,66,'Cittaducale',0,'1800-01-01',NULL,0),
	(4744,66,'Cittareale',0,'1800-01-01',NULL,0),
	(4745,66,'Collalto Sabino',0,'1800-01-01',NULL,0),
	(4746,66,'Colle di Tora',0,'1800-01-01',NULL,0),
	(4747,66,'Collegiove',0,'1800-01-01',NULL,0),
	(4748,66,'Collevecchio',0,'1800-01-01',NULL,0),
	(4749,66,'Colli sul Velino',0,'1800-01-01',NULL,0),
	(4750,66,'Concerviano',0,'1800-01-01',NULL,0),
	(4751,66,'Configni',0,'1800-01-01',NULL,0),
	(4752,66,'Contigliano',0,'1800-01-01',NULL,0),
	(4753,66,'Cottanello',0,'1800-01-01',NULL,0),
	(4754,66,'Fara in Sabina',0,'1800-01-01',NULL,0),
	(4755,66,'Fiamignano',0,'1800-01-01',NULL,0),
	(4756,66,'Forano',0,'1800-01-01',NULL,0),
	(4757,66,'Frasso Sabino',0,'1800-01-01',NULL,0),
	(4758,66,'Greccio',0,'1800-01-01',NULL,0),
	(4759,66,'Labro',0,'1800-01-01',NULL,0),
	(4760,66,'Leonessa',0,'1800-01-01',NULL,0),
	(4761,66,'Longone Sabino',0,'1800-01-01',NULL,0),
	(4762,66,'Magliano Sabina',0,'1800-01-01',NULL,0),
	(4763,66,'Marcetelli',0,'1800-01-01',NULL,0),
	(4764,66,'Micigliano',0,'1800-01-01',NULL,0),
	(4765,66,'Mompeo',0,'1800-01-01',NULL,0),
	(4766,66,'Montasola',0,'1800-01-01',NULL,0),
	(4767,66,'Montebuono',0,'1800-01-01',NULL,0),
	(4768,66,'Monteleone Sabino',0,'1800-01-01',NULL,0),
	(4769,66,'Montenero Sabino',0,'1800-01-01',NULL,0),
	(4770,66,'Monte San Giovanni in Sabina',0,'1800-01-01',NULL,0),
	(4771,66,'Montopoli di Sabina',0,'1800-01-01',NULL,0),
	(4772,66,'Morro Reatino',0,'1800-01-01',NULL,0),
	(4773,66,'Nespolo',0,'1800-01-01',NULL,0),
	(4774,66,'Orvinio',0,'1800-01-01',NULL,0),
	(4775,66,'Paganico Sabino',0,'1800-01-01',NULL,0),
	(4776,66,'Pescorocchiano',0,'1800-01-01',NULL,0),
	(4777,66,'Petrella Salto',0,'1800-01-01',NULL,0),
	(4778,66,'Poggio Bustone',0,'1800-01-01',NULL,0),
	(4779,66,'Poggio Catino',0,'1800-01-01',NULL,0),
	(4780,66,'Poggio Mirteto',0,'1800-01-01',NULL,0),
	(4781,66,'Poggio Moiano',0,'1800-01-01',NULL,0),
	(4782,66,'Poggio Nativo',0,'1800-01-01',NULL,0),
	(4783,66,'Poggio San Lorenzo',0,'1800-01-01',NULL,0),
	(4784,66,'Posta',0,'1800-01-01',NULL,0),
	(4785,66,'Pozzaglia Sabina',0,'1800-01-01',NULL,0),
	(4786,66,'Rieti',1,'1800-01-01',NULL,0),
	(4787,66,'Rivodutri',0,'1800-01-01',NULL,0),
	(4788,66,'Roccantica',0,'1800-01-01',NULL,0),
	(4789,66,'Rocca Sinibalda',0,'1800-01-01',NULL,0),
	(4790,66,'Salisano',0,'1800-01-01',NULL,0),
	(4791,66,'Scandriglia',0,'1800-01-01',NULL,0),
	(4792,66,'Selci',0,'1800-01-01',NULL,0),
	(4793,66,'Stimigliano',0,'1800-01-01',NULL,0),
	(4794,66,'Tarano',0,'1800-01-01',NULL,0),
	(4795,66,'Toffia',0,'1800-01-01',NULL,0),
	(4796,66,'Torricella in Sabina',0,'1800-01-01',NULL,0),
	(4797,66,'Torri in Sabina',0,'1800-01-01',NULL,0),
	(4798,66,'Turania',0,'1800-01-01',NULL,0),
	(4799,66,'Vacone',0,'1800-01-01',NULL,0),
	(4800,66,'Varco Sabino',0,'1800-01-01',NULL,0),
	(4801,67,'Affile',0,'1800-01-01',NULL,0),
	(4802,67,'Agosta',0,'1800-01-01',NULL,0),
	(4803,67,'Albano Laziale',0,'1800-01-01',NULL,0),
	(4804,67,'Allumiere',0,'1800-01-01',NULL,0),
	(4805,67,'Anguillara Sabazia',0,'1800-01-01',NULL,0),
	(4806,67,'Anticoli Corrado',0,'1800-01-01',NULL,0),
	(4807,67,'Anzio',0,'1800-01-01',NULL,0),
	(4808,67,'Arcinazzo Romano',0,'1800-01-01',NULL,0),
	(4809,67,'Ariccia',0,'1800-01-01',NULL,0),
	(4810,67,'Arsoli',0,'1800-01-01',NULL,0),
	(4811,67,'Artena',0,'1800-01-01',NULL,0),
	(4812,67,'Bellegra',0,'1800-01-01',NULL,0),
	(4813,67,'Bracciano',0,'1800-01-01',NULL,0),
	(4814,67,'Camerata Nuova',0,'1800-01-01',NULL,0),
	(4815,67,'Campagnano di Roma',0,'1800-01-01',NULL,0),
	(4816,67,'Canale Monterano',0,'1800-01-01',NULL,0),
	(4817,67,'Canterano',0,'1800-01-01',NULL,0),
	(4818,67,'Capena',0,'1800-01-01',NULL,0),
	(4819,67,'Capranica Prenestina',0,'1800-01-01',NULL,0),
	(4820,67,'Carpineto Romano',0,'1800-01-01',NULL,0),
	(4821,67,'Casape',0,'1800-01-01',NULL,0),
	(4822,67,'Castel Gandolfo',0,'1800-01-01',NULL,0),
	(4823,67,'Castel Madama',0,'1800-01-01',NULL,0),
	(4824,67,'Castelnuovo di Porto',0,'1800-01-01',NULL,0),
	(4825,67,'Castel San Pietro Romano',0,'1800-01-01',NULL,0),
	(4826,67,'Cave',0,'1800-01-01',NULL,0),
	(4827,67,'Cerreto Laziale',0,'1800-01-01',NULL,0),
	(4828,67,'Cervara di Roma',0,'1800-01-01',NULL,0),
	(4829,67,'Cerveteri',0,'1800-01-01',NULL,0),
	(4830,67,'Ciciliano',0,'1800-01-01',NULL,0),
	(4831,67,'Cineto Romano',0,'1800-01-01',NULL,0),
	(4832,67,'Civitavecchia',0,'1800-01-01',NULL,0),
	(4833,67,'Civitella San Paolo',0,'1800-01-01',NULL,0),
	(4834,67,'Colleferro',0,'1800-01-01',NULL,0),
	(4835,67,'Colonna',0,'1800-01-01',NULL,0),
	(4836,67,'Fiano Romano',0,'1800-01-01',NULL,0),
	(4837,67,'Filacciano',0,'1800-01-01',NULL,0),
	(4838,67,'Formello',0,'1800-01-01',NULL,0),
	(4839,67,'Frascati',0,'1800-01-01',NULL,0),
	(4840,67,'Gallicano nel Lazio',0,'1800-01-01',NULL,0),
	(4841,67,'Gavignano',0,'1800-01-01',NULL,0),
	(4842,67,'Genazzano',0,'1800-01-01',NULL,0),
	(4843,67,'Genzano di Roma',0,'1800-01-01',NULL,0),
	(4844,67,'Gerano',0,'1800-01-01',NULL,0),
	(4845,67,'Gorga',0,'1800-01-01',NULL,0),
	(4846,67,'Grottaferrata',0,'1800-01-01',NULL,0),
	(4847,67,'Guidonia Montecelio',0,'1800-01-01',NULL,0),
	(4848,67,'Jenne',0,'1800-01-01',NULL,0),
	(4849,67,'Labico',0,'1800-01-01',NULL,0),
	(4850,67,'Lanuvio',0,'1800-01-01',NULL,0),
	(4851,67,'Licenza',0,'1800-01-01',NULL,0),
	(4852,67,'Magliano Romano',0,'1800-01-01',NULL,0),
	(4853,67,'Mandela',0,'1800-01-01',NULL,0),
	(4854,67,'Manziana',0,'1800-01-01',NULL,0),
	(4855,67,'Marano Equo',0,'1800-01-01',NULL,0),
	(4856,67,'Marcellina',0,'1800-01-01',NULL,0),
	(4857,67,'Marino',0,'1800-01-01',NULL,0),
	(4858,67,'Mazzano Romano',0,'1800-01-01',NULL,0),
	(4859,67,'Mentana',0,'1800-01-01',NULL,0),
	(4860,67,'Monte Compatri',0,'1800-01-01',NULL,0),
	(4861,67,'Monteflavio',0,'1800-01-01',NULL,0),
	(4862,67,'Montelanico',0,'1800-01-01',NULL,0),
	(4863,67,'Montelibretti',0,'1800-01-01',NULL,0),
	(4864,67,'Monte Porzio Catone',0,'1800-01-01',NULL,0),
	(4865,67,'Monterotondo',0,'1800-01-01',NULL,0),
	(4866,67,'Montorio Romano',0,'1800-01-01',NULL,0),
	(4867,67,'Moricone',0,'1800-01-01',NULL,0),
	(4868,67,'Morlupo',0,'1800-01-01',NULL,0),
	(4869,67,'Nazzano',0,'1800-01-01',NULL,0),
	(4870,67,'Nemi',0,'1800-01-01',NULL,0),
	(4871,67,'Nerola',0,'1800-01-01',NULL,0),
	(4872,67,'Nettuno',0,'1800-01-01',NULL,0),
	(4873,67,'Olevano Romano',0,'1800-01-01',NULL,0),
	(4874,67,'Palestrina',0,'1800-01-01',NULL,0),
	(4875,67,'Palombara Sabina',0,'1800-01-01',NULL,0),
	(4876,67,'Percile',0,'1800-01-01',NULL,0),
	(4877,67,'Pisoniano',0,'1800-01-01',NULL,0),
	(4878,67,'Poli',0,'1800-01-01',NULL,0),
	(4879,67,'Pomezia',0,'1800-01-01',NULL,0),
	(4880,67,'Ponzano Romano',0,'1800-01-01',NULL,0),
	(4881,67,'Riano',0,'1800-01-01',NULL,0),
	(4882,67,'Rignano Flaminio',0,'1800-01-01',NULL,0),
	(4883,67,'Riofreddo',0,'1800-01-01',NULL,0),
	(4884,67,'Rocca Canterano',0,'1800-01-01',NULL,0),
	(4885,67,'Rocca di Cave',0,'1800-01-01',NULL,0),
	(4886,67,'Rocca di Papa',0,'1800-01-01',NULL,0),
	(4887,67,'Roccagiovine',0,'1800-01-01',NULL,0),
	(4888,67,'Rocca Priora',0,'1800-01-01',NULL,0),
	(4889,67,'Rocca Santo Stefano',0,'1800-01-01',NULL,0),
	(4890,67,'Roiate',0,'1800-01-01',NULL,0),
	(4891,67,'Roma Capitale',1,'1800-01-01',NULL,0),
	(4892,67,'Roviano',0,'1800-01-01',NULL,0),
	(4893,67,'Sacrofano',0,'1800-01-01',NULL,0),
	(4894,67,'Sambuci',0,'1800-01-01',NULL,0),
	(4895,67,'San Gregorio da Sassola',0,'1800-01-01',NULL,0),
	(4896,67,'San Polo dei Cavalieri',0,'1800-01-01',NULL,0),
	(4897,67,'Santa Marinella',0,'1800-01-01',NULL,0),
	(4898,67,'Sant\'Angelo Romano',0,'1800-01-01',NULL,0),
	(4899,67,'Sant\'Oreste',0,'1800-01-01',NULL,0),
	(4900,67,'San Vito Romano',0,'1800-01-01',NULL,0),
	(4901,67,'Saracinesco',0,'1800-01-01',NULL,0),
	(4902,67,'Segni',0,'1800-01-01',NULL,0),
	(4903,67,'Subiaco',0,'1800-01-01',NULL,0),
	(4904,67,'Tivoli',0,'1800-01-01',NULL,0),
	(4905,67,'Tolfa',0,'1800-01-01',NULL,0),
	(4906,67,'Torrita Tiberina',0,'1800-01-01',NULL,0),
	(4907,67,'Trevignano Romano',0,'1800-01-01',NULL,0),
	(4908,67,'Vallepietra',0,'1800-01-01',NULL,0),
	(4909,67,'Vallinfreda',0,'1800-01-01',NULL,0),
	(4910,67,'Valmontone',0,'1800-01-01',NULL,0),
	(4911,67,'Velletri',0,'1800-01-01',NULL,0),
	(4912,67,'Vicovaro',0,'1800-01-01',NULL,0),
	(4913,67,'Vivaro Romano',0,'1800-01-01',NULL,0),
	(4914,67,'Zagarolo',0,'1800-01-01',NULL,0),
	(4915,67,'Lariano',0,'1800-01-01',NULL,0),
	(4916,67,'Ladispoli',0,'1800-01-01',NULL,0),
	(4917,67,'Ardea',0,'1800-01-01',NULL,0),
	(4918,67,'Ciampino',0,'1800-01-01',NULL,0),
	(4919,67,'San Cesareo',0,'1800-01-01',NULL,0),
	(4920,67,'Fiumicino',0,'1800-01-01',NULL,0),
	(4921,67,'Fonte Nuova',0,'1800-01-01',NULL,0),
	(4922,68,'Aprilia',0,'1800-01-01',NULL,0),
	(4923,68,'Bassiano',0,'1800-01-01',NULL,0),
	(4924,68,'Campodimele',0,'1800-01-01',NULL,0),
	(4925,68,'Castelforte',0,'1800-01-01',NULL,0),
	(4926,68,'Cisterna di Latina',0,'1800-01-01',NULL,0),
	(4927,68,'Cori',0,'1800-01-01',NULL,0),
	(4928,68,'Fondi',0,'1800-01-01',NULL,0),
	(4929,68,'Formia',0,'1800-01-01',NULL,0),
	(4930,68,'Gaeta',0,'1800-01-01',NULL,0),
	(4931,68,'Itri',0,'1800-01-01',NULL,0),
	(4932,68,'Latina',1,'1800-01-01',NULL,0),
	(4933,68,'Lenola',0,'1800-01-01',NULL,0),
	(4934,68,'Maenza',0,'1800-01-01',NULL,0),
	(4935,68,'Minturno',0,'1800-01-01',NULL,0),
	(4936,68,'Monte San Biagio',0,'1800-01-01',NULL,0),
	(4937,68,'Norma',0,'1800-01-01',NULL,0),
	(4938,68,'Pontinia',0,'1800-01-01',NULL,0),
	(4939,68,'Ponza',0,'1800-01-01',NULL,0),
	(4940,68,'Priverno',0,'1800-01-01',NULL,0),
	(4941,68,'Prossedi',0,'1800-01-01',NULL,0),
	(4942,68,'Roccagorga',0,'1800-01-01',NULL,0),
	(4943,68,'Rocca Massima',0,'1800-01-01',NULL,0),
	(4944,68,'Roccasecca dei Volsci',0,'1800-01-01',NULL,0),
	(4945,68,'Sabaudia',0,'1800-01-01',NULL,0),
	(4946,68,'San Felice Circeo',0,'1800-01-01',NULL,0),
	(4947,68,'Santi Cosma e Damiano',0,'1800-01-01',NULL,0),
	(4948,68,'Sermoneta',0,'1800-01-01',NULL,0),
	(4949,68,'Sezze',0,'1800-01-01',NULL,0),
	(4950,68,'Sonnino',0,'1800-01-01',NULL,0),
	(4951,68,'Sperlonga',0,'1800-01-01',NULL,0),
	(4952,68,'Spigno Saturnia',0,'1800-01-01',NULL,0),
	(4953,68,'Terracina',0,'1800-01-01',NULL,0),
	(4954,68,'Ventotene',0,'1800-01-01',NULL,0),
	(4955,69,'Acquafondata',0,'1800-01-01',NULL,0),
	(4956,69,'Acuto',0,'1800-01-01',NULL,0),
	(4957,69,'Alatri',0,'1800-01-01',NULL,0),
	(4958,69,'Alvito',0,'1800-01-01',NULL,0),
	(4959,69,'Amaseno',0,'1800-01-01',NULL,0),
	(4960,69,'Anagni',0,'1800-01-01',NULL,0),
	(4961,69,'Aquino',0,'1800-01-01',NULL,0),
	(4962,69,'Arce',0,'1800-01-01',NULL,0),
	(4963,69,'Arnara',0,'1800-01-01',NULL,0),
	(4964,69,'Arpino',0,'1800-01-01',NULL,0),
	(4965,69,'Atina',0,'1800-01-01',NULL,0),
	(4966,69,'Ausonia',0,'1800-01-01',NULL,0),
	(4967,69,'Belmonte Castello',0,'1800-01-01',NULL,0),
	(4968,69,'Boville Ernica',0,'1800-01-01',NULL,0),
	(4969,69,'Broccostella',0,'1800-01-01',NULL,0),
	(4970,69,'Campoli Appennino',0,'1800-01-01',NULL,0),
	(4971,69,'Casalattico',0,'1800-01-01',NULL,0),
	(4972,69,'Casalvieri',0,'1800-01-01',NULL,0),
	(4973,69,'Cassino',0,'1800-01-01',NULL,0),
	(4974,69,'Castelliri',0,'1800-01-01',NULL,0),
	(4975,69,'Castelnuovo Parano',0,'1800-01-01',NULL,0),
	(4976,69,'Castrocielo',0,'1800-01-01',NULL,0),
	(4977,69,'Castro dei Volsci',0,'1800-01-01',NULL,0),
	(4978,69,'Ceccano',0,'1800-01-01',NULL,0),
	(4979,69,'Ceprano',0,'1800-01-01',NULL,0),
	(4980,69,'Cervaro',0,'1800-01-01',NULL,0),
	(4981,69,'Colfelice',0,'1800-01-01',NULL,0),
	(4982,69,'Collepardo',0,'1800-01-01',NULL,0),
	(4983,69,'Colle San Magno',0,'1800-01-01',NULL,0),
	(4984,69,'Coreno Ausonio',0,'1800-01-01',NULL,0),
	(4985,69,'Esperia',0,'1800-01-01',NULL,0),
	(4986,69,'Falvaterra',0,'1800-01-01',NULL,0),
	(4987,69,'Ferentino',0,'1800-01-01',NULL,0),
	(4988,69,'Filettino',0,'1800-01-01',NULL,0),
	(4989,69,'Fiuggi',0,'1800-01-01',NULL,0),
	(4990,69,'Fontana Liri',0,'1800-01-01',NULL,0),
	(4991,69,'Fontechiari',0,'1800-01-01',NULL,0),
	(4992,69,'Frosinone',1,'1800-01-01',NULL,0),
	(4993,69,'Fumone',0,'1800-01-01',NULL,0),
	(4994,69,'Gallinaro',0,'1800-01-01',NULL,0),
	(4995,69,'Giuliano di Roma',0,'1800-01-01',NULL,0),
	(4996,69,'Guarcino',0,'1800-01-01',NULL,0),
	(4997,69,'Isola del Liri',0,'1800-01-01',NULL,0),
	(4998,69,'Monte San Giovanni Campano',0,'1800-01-01',NULL,0),
	(4999,69,'Morolo',0,'1800-01-01',NULL,0),
	(5000,69,'Paliano',0,'1800-01-01',NULL,0),
	(5001,69,'Pastena',0,'1800-01-01',NULL,0),
	(5002,69,'Patrica',0,'1800-01-01',NULL,0),
	(5003,69,'Pescosolido',0,'1800-01-01',NULL,0),
	(5004,69,'Picinisco',0,'1800-01-01',NULL,0),
	(5005,69,'Pico',0,'1800-01-01',NULL,0),
	(5006,69,'Piedimonte San Germano',0,'1800-01-01',NULL,0),
	(5007,69,'Piglio',0,'1800-01-01',NULL,0),
	(5008,69,'Pignataro Interamna',0,'1800-01-01',NULL,0),
	(5009,69,'Pofi',0,'1800-01-01',NULL,0),
	(5010,69,'Pontecorvo',0,'1800-01-01',NULL,0),
	(5011,69,'Posta Fibreno',0,'1800-01-01',NULL,0),
	(5012,69,'Ripi',0,'1800-01-01',NULL,0),
	(5013,69,'Rocca d\'Arce',0,'1800-01-01',NULL,0),
	(5014,69,'Roccasecca',0,'1800-01-01',NULL,0),
	(5015,69,'San Biagio Saracinisco',0,'1800-01-01',NULL,0),
	(5016,69,'San Donato Val di Comino',0,'1800-01-01',NULL,0),
	(5017,69,'San Giorgio a Liri',0,'1800-01-01',NULL,0),
	(5018,69,'San Giovanni Incarico',0,'1800-01-01',NULL,0),
	(5019,69,'Sant\'Ambrogio sul Garigliano',0,'1800-01-01',NULL,0),
	(5020,69,'Sant\'Andrea del Garigliano',0,'1800-01-01',NULL,0),
	(5021,69,'Sant\'Apollinare',0,'1800-01-01',NULL,0),
	(5022,69,'Sant\'Elia Fiumerapido',0,'1800-01-01',NULL,0),
	(5023,69,'Santopadre',0,'1800-01-01',NULL,0),
	(5024,69,'San Vittore del Lazio',0,'1800-01-01',NULL,0),
	(5025,69,'Serrone',0,'1800-01-01',NULL,0),
	(5026,69,'Settefrati',0,'1800-01-01',NULL,0),
	(5027,69,'Sgurgola',0,'1800-01-01',NULL,0),
	(5028,69,'Sora',0,'1800-01-01',NULL,0),
	(5029,69,'Strangolagalli',0,'1800-01-01',NULL,0),
	(5030,69,'Supino',0,'1800-01-01',NULL,0),
	(5031,69,'Terelle',0,'1800-01-01',NULL,0),
	(5032,69,'Torre Cajetani',0,'1800-01-01',NULL,0),
	(5033,69,'Torrice',0,'1800-01-01',NULL,0),
	(5034,69,'Trevi nel Lazio',0,'1800-01-01',NULL,0),
	(5035,69,'Trivigliano',0,'1800-01-01',NULL,0),
	(5036,69,'Vallecorsa',0,'1800-01-01',NULL,0),
	(5037,69,'Vallemaio',0,'1800-01-01',NULL,0),
	(5038,69,'Vallerotonda',0,'1800-01-01',NULL,0),
	(5039,69,'Veroli',0,'1800-01-01',NULL,0),
	(5040,69,'Vicalvi',0,'1800-01-01',NULL,0),
	(5041,69,'Vico nel Lazio',0,'1800-01-01',NULL,0),
	(5042,69,'Villa Latina',0,'1800-01-01',NULL,0),
	(5043,69,'Villa Santa Lucia',0,'1800-01-01',NULL,0),
	(5044,69,'Villa Santo Stefano',0,'1800-01-01',NULL,0),
	(5045,69,'Viticuso',0,'1800-01-01',NULL,0),
	(5046,76,'Ailano',0,'1800-01-01',NULL,0),
	(5047,76,'Alife',0,'1800-01-01',NULL,0),
	(5048,76,'Alvignano',0,'1800-01-01',NULL,0),
	(5049,76,'Arienzo',0,'1800-01-01',NULL,0),
	(5050,76,'Aversa',0,'1800-01-01',NULL,0),
	(5051,76,'Baia e Latina',0,'1800-01-01',NULL,0),
	(5052,76,'Bellona',0,'1800-01-01',NULL,0),
	(5053,76,'Caianello',0,'1800-01-01',NULL,0),
	(5054,76,'Caiazzo',0,'1800-01-01',NULL,0),
	(5055,76,'Calvi Risorta',0,'1800-01-01',NULL,0),
	(5056,76,'Camigliano',0,'1800-01-01',NULL,0),
	(5057,76,'Cancello ed Arnone',0,'1800-01-01',NULL,0),
	(5058,76,'Capodrise',0,'1800-01-01',NULL,0),
	(5059,76,'Capriati a Volturno',0,'1800-01-01',NULL,0),
	(5060,76,'Capua',0,'1800-01-01',NULL,0),
	(5061,76,'Carinaro',0,'1800-01-01',NULL,0),
	(5062,76,'Carinola',0,'1800-01-01',NULL,0),
	(5063,76,'Casagiove',0,'1800-01-01',NULL,0),
	(5064,76,'Casal di Principe',0,'1800-01-01',NULL,0),
	(5065,76,'Casaluce',0,'1800-01-01',NULL,0),
	(5066,76,'Casapulla',0,'1800-01-01',NULL,0),
	(5067,76,'Caserta',1,'1800-01-01',NULL,0),
	(5068,76,'Castel Campagnano',0,'1800-01-01',NULL,0),
	(5069,76,'Castel di Sasso',0,'1800-01-01',NULL,0),
	(5070,76,'Castello del Matese',0,'1800-01-01',NULL,0),
	(5071,76,'Castel Morrone',0,'1800-01-01',NULL,0),
	(5072,76,'Castel Volturno',0,'1800-01-01',NULL,0),
	(5073,76,'Cervino',0,'1800-01-01',NULL,0),
	(5074,76,'Cesa',0,'1800-01-01',NULL,0),
	(5075,76,'Ciorlano',0,'1800-01-01',NULL,0),
	(5076,76,'Conca della Campania',0,'1800-01-01',NULL,0),
	(5077,76,'Curti',0,'1800-01-01',NULL,0),
	(5078,76,'Dragoni',0,'1800-01-01',NULL,0),
	(5079,76,'Fontegreca',0,'1800-01-01',NULL,0),
	(5080,76,'Formicola',0,'1800-01-01',NULL,0),
	(5081,76,'Francolise',0,'1800-01-01',NULL,0),
	(5082,76,'Frignano',0,'1800-01-01',NULL,0),
	(5083,76,'Gallo Matese',0,'1800-01-01',NULL,0),
	(5084,76,'Galluccio',0,'1800-01-01',NULL,0),
	(5085,76,'Giano Vetusto',0,'1800-01-01',NULL,0),
	(5086,76,'Gioia Sannitica',0,'1800-01-01',NULL,0),
	(5087,76,'Grazzanise',0,'1800-01-01',NULL,0),
	(5088,76,'Gricignano di Aversa',0,'1800-01-01',NULL,0),
	(5089,76,'Letino',0,'1800-01-01',NULL,0),
	(5090,76,'Liberi',0,'1800-01-01',NULL,0),
	(5091,76,'Lusciano',0,'1800-01-01',NULL,0),
	(5092,76,'Macerata Campania',0,'1800-01-01',NULL,0),
	(5093,76,'Maddaloni',0,'1800-01-01',NULL,0),
	(5094,76,'Marcianise',0,'1800-01-01',NULL,0),
	(5095,76,'Marzano Appio',0,'1800-01-01',NULL,0),
	(5096,76,'Mignano Monte Lungo',0,'1800-01-01',NULL,0),
	(5097,76,'Mondragone',0,'1800-01-01',NULL,0),
	(5098,76,'Orta di Atella',0,'1800-01-01',NULL,0),
	(5099,76,'Parete',0,'1800-01-01',NULL,0),
	(5100,76,'Pastorano',0,'1800-01-01',NULL,0),
	(5101,76,'Piana di Monte Verna',0,'1800-01-01',NULL,0),
	(5102,76,'Piedimonte Matese',0,'1800-01-01',NULL,0),
	(5103,76,'Pietramelara',0,'1800-01-01',NULL,0),
	(5104,76,'Pietravairano',0,'1800-01-01',NULL,0),
	(5105,76,'Pignataro Maggiore',0,'1800-01-01',NULL,0),
	(5106,76,'Pontelatone',0,'1800-01-01',NULL,0),
	(5107,76,'Portico di Caserta',0,'1800-01-01',NULL,0),
	(5108,76,'Prata Sannita',0,'1800-01-01',NULL,0),
	(5109,76,'Pratella',0,'1800-01-01',NULL,0),
	(5110,76,'Presenzano',0,'1800-01-01',NULL,0),
	(5111,76,'Raviscanina',0,'1800-01-01',NULL,0),
	(5112,76,'Recale',0,'1800-01-01',NULL,0),
	(5113,76,'Riardo',0,'1800-01-01',NULL,0),
	(5114,76,'Rocca d\'Evandro',0,'1800-01-01',NULL,0),
	(5115,76,'Roccamonfina',0,'1800-01-01',NULL,0),
	(5116,76,'Roccaromana',0,'1800-01-01',NULL,0),
	(5117,76,'Rocchetta e Croce',0,'1800-01-01',NULL,0),
	(5118,76,'Ruviano',0,'1800-01-01',NULL,0),
	(5119,76,'San Cipriano d\'Aversa',0,'1800-01-01',NULL,0),
	(5120,76,'San Felice a Cancello',0,'1800-01-01',NULL,0),
	(5121,76,'San Gregorio Matese',0,'1800-01-01',NULL,0),
	(5122,76,'San Marcellino',0,'1800-01-01',NULL,0),
	(5123,76,'San Nicola la Strada',0,'1800-01-01',NULL,0),
	(5124,76,'San Pietro Infine',0,'1800-01-01',NULL,0),
	(5125,76,'San Potito Sannitico',0,'1800-01-01',NULL,0),
	(5126,76,'San Prisco',0,'1800-01-01',NULL,0),
	(5127,76,'Santa Maria a Vico',0,'1800-01-01',NULL,0),
	(5128,76,'Santa Maria Capua Vetere',0,'1800-01-01',NULL,0),
	(5129,76,'Santa Maria la Fossa',0,'1800-01-01',NULL,0),
	(5130,76,'San Tammaro',0,'1800-01-01',NULL,0),
	(5131,76,'Sant\'Angelo d\'Alife',0,'1800-01-01',NULL,0),
	(5132,76,'Sant\'Arpino',0,'1800-01-01',NULL,0),
	(5133,76,'Sessa Aurunca',0,'1800-01-01',NULL,0),
	(5134,76,'Sparanise',0,'1800-01-01',NULL,0),
	(5135,76,'Succivo',0,'1800-01-01',NULL,0),
	(5136,76,'Teano',0,'1800-01-01',NULL,0),
	(5137,76,'Teverola',0,'1800-01-01',NULL,0),
	(5138,76,'Tora e Piccilli',0,'1800-01-01',NULL,0),
	(5139,76,'Trentola-Ducenta',0,'1800-01-01',NULL,0),
	(5140,76,'Vairano Patenora',0,'1800-01-01',NULL,0),
	(5141,76,'Valle Agricola',0,'1800-01-01',NULL,0),
	(5142,76,'Valle di Maddaloni',0,'1800-01-01',NULL,0),
	(5143,76,'Villa di Briano',0,'1800-01-01',NULL,0),
	(5144,76,'Villa Literno',0,'1800-01-01',NULL,0),
	(5145,76,'Vitulazio',0,'1800-01-01',NULL,0),
	(5146,76,'Falciano del Massico',0,'1800-01-01',NULL,0),
	(5147,76,'Cellole',0,'1800-01-01',NULL,0),
	(5148,76,'Casapesenna',0,'1800-01-01',NULL,0),
	(5149,76,'San Marco Evangelista',0,'1800-01-01',NULL,0),
	(5150,77,'Airola',0,'1800-01-01',NULL,0),
	(5151,77,'Amorosi',0,'1800-01-01',NULL,0),
	(5152,77,'Apice',0,'1800-01-01',NULL,0),
	(5153,77,'Apollosa',0,'1800-01-01',NULL,0),
	(5154,77,'Arpaia',0,'1800-01-01',NULL,0),
	(5155,77,'Arpaise',0,'1800-01-01',NULL,0),
	(5156,77,'Baselice',0,'1800-01-01',NULL,0),
	(5157,77,'Benevento',1,'1800-01-01',NULL,0),
	(5158,77,'Bonea',0,'1800-01-01',NULL,0),
	(5159,77,'Bucciano',0,'1800-01-01',NULL,0),
	(5160,77,'Buonalbergo',0,'1800-01-01',NULL,0),
	(5161,77,'Calvi',0,'1800-01-01',NULL,0),
	(5162,77,'Campolattaro',0,'1800-01-01',NULL,0),
	(5163,77,'Campoli del Monte Taburno',0,'1800-01-01',NULL,0),
	(5164,77,'Casalduni',0,'1800-01-01',NULL,0),
	(5165,77,'Castelfranco in Miscano',0,'1800-01-01',NULL,0),
	(5166,77,'Castelpagano',0,'1800-01-01',NULL,0),
	(5167,77,'Castelpoto',0,'1800-01-01',NULL,0),
	(5168,77,'Castelvenere',0,'1800-01-01',NULL,0),
	(5169,77,'Castelvetere in Val Fortore',0,'1800-01-01',NULL,0),
	(5170,77,'Cautano',0,'1800-01-01',NULL,0),
	(5171,77,'Ceppaloni',0,'1800-01-01',NULL,0),
	(5172,77,'Cerreto Sannita',0,'1800-01-01',NULL,0),
	(5173,77,'Circello',0,'1800-01-01',NULL,0),
	(5174,77,'Colle Sannita',0,'1800-01-01',NULL,0),
	(5175,77,'Cusano Mutri',0,'1800-01-01',NULL,0),
	(5176,77,'Dugenta',0,'1800-01-01',NULL,0),
	(5177,77,'Durazzano',0,'1800-01-01',NULL,0),
	(5178,77,'Faicchio',0,'1800-01-01',NULL,0),
	(5179,77,'Foglianise',0,'1800-01-01',NULL,0),
	(5180,77,'Foiano di Val Fortore',0,'1800-01-01',NULL,0),
	(5181,77,'Forchia',0,'1800-01-01',NULL,0),
	(5182,77,'Fragneto l\'Abate',0,'1800-01-01',NULL,0),
	(5183,77,'Fragneto Monforte',0,'1800-01-01',NULL,0),
	(5184,77,'Frasso Telesino',0,'1800-01-01',NULL,0),
	(5185,77,'Ginestra degli Schiavoni',0,'1800-01-01',NULL,0),
	(5186,77,'Guardia Sanframondi',0,'1800-01-01',NULL,0),
	(5187,77,'Limatola',0,'1800-01-01',NULL,0),
	(5188,77,'Melizzano',0,'1800-01-01',NULL,0),
	(5189,77,'Moiano',0,'1800-01-01',NULL,0),
	(5190,77,'Molinara',0,'1800-01-01',NULL,0),
	(5191,77,'Montefalcone di Val Fortore',0,'1800-01-01',NULL,0),
	(5192,77,'Montesarchio',0,'1800-01-01',NULL,0),
	(5193,77,'Morcone',0,'1800-01-01',NULL,0),
	(5194,77,'Paduli',0,'1800-01-01',NULL,0),
	(5195,77,'Pago Veiano',0,'1800-01-01',NULL,0),
	(5196,77,'Pannarano',0,'1800-01-01',NULL,0),
	(5197,77,'Paolisi',0,'1800-01-01',NULL,0),
	(5198,77,'Paupisi',0,'1800-01-01',NULL,0),
	(5199,77,'Pesco Sannita',0,'1800-01-01',NULL,0),
	(5200,77,'Pietraroja',0,'1800-01-01',NULL,0),
	(5201,77,'Pietrelcina',0,'1800-01-01',NULL,0),
	(5202,77,'Ponte',0,'1800-01-01',NULL,0),
	(5203,77,'Pontelandolfo',0,'1800-01-01',NULL,0),
	(5204,77,'Puglianello',0,'1800-01-01',NULL,0),
	(5205,77,'Reino',0,'1800-01-01',NULL,0),
	(5206,77,'San Bartolomeo in Galdo',0,'1800-01-01',NULL,0),
	(5207,77,'San Giorgio del Sannio',0,'1800-01-01',NULL,0),
	(5208,77,'San Giorgio La Molara',0,'1800-01-01',NULL,0),
	(5209,77,'San Leucio del Sannio',0,'1800-01-01',NULL,0),
	(5210,77,'San Lorenzello',0,'1800-01-01',NULL,0),
	(5211,77,'San Lorenzo Maggiore',0,'1800-01-01',NULL,0),
	(5212,77,'San Lupo',0,'1800-01-01',NULL,0),
	(5213,77,'San Marco dei Cavoti',0,'1800-01-01',NULL,0),
	(5214,77,'San Martino Sannita',0,'1800-01-01',NULL,0),
	(5215,77,'San Nazzaro',0,'1800-01-01',NULL,0),
	(5216,77,'San Nicola Manfredi',0,'1800-01-01',NULL,0),
	(5217,77,'San Salvatore Telesino',0,'1800-01-01',NULL,0),
	(5218,77,'Santa Croce del Sannio',0,'1800-01-01',NULL,0),
	(5219,77,'Sant\'Agata de\' Goti',0,'1800-01-01',NULL,0),
	(5220,77,'Sant\'Angelo a Cupolo',0,'1800-01-01',NULL,0),
	(5221,77,'Sassinoro',0,'1800-01-01',NULL,0),
	(5222,77,'Solopaca',0,'1800-01-01',NULL,0),
	(5223,77,'Telese Terme',0,'1800-01-01',NULL,0),
	(5224,77,'Tocco Caudio',0,'1800-01-01',NULL,0),
	(5225,77,'Torrecuso',0,'1800-01-01',NULL,0),
	(5226,77,'Vitulano',0,'1800-01-01',NULL,0),
	(5227,77,'Sant\'Arcangelo Trimonte',0,'1800-01-01',NULL,0),
	(5228,78,'Acerra',0,'1800-01-01',NULL,0),
	(5229,78,'Afragola',0,'1800-01-01',NULL,0),
	(5230,78,'Agerola',0,'1800-01-01',NULL,0),
	(5231,78,'Anacapri',0,'1800-01-01',NULL,0),
	(5232,78,'Arzano',0,'1800-01-01',NULL,0),
	(5233,78,'Bacoli',0,'1800-01-01',NULL,0),
	(5234,78,'Barano d\'Ischia',0,'1800-01-01',NULL,0),
	(5235,78,'Boscoreale',0,'1800-01-01',NULL,0),
	(5236,78,'Boscotrecase',0,'1800-01-01',NULL,0),
	(5237,78,'Brusciano',0,'1800-01-01',NULL,0),
	(5238,78,'Caivano',0,'1800-01-01',NULL,0),
	(5239,78,'Calvizzano',0,'1800-01-01',NULL,0),
	(5240,78,'Camposano',0,'1800-01-01',NULL,0),
	(5241,78,'Capri',0,'1800-01-01',NULL,0),
	(5242,78,'Carbonara di Nola',0,'1800-01-01',NULL,0),
	(5243,78,'Cardito',0,'1800-01-01',NULL,0),
	(5244,78,'Casalnuovo di Napoli',0,'1800-01-01',NULL,0),
	(5245,78,'Casamarciano',0,'1800-01-01',NULL,0),
	(5246,78,'Casamicciola Terme',0,'1800-01-01',NULL,0),
	(5247,78,'Casandrino',0,'1800-01-01',NULL,0),
	(5248,78,'Casavatore',0,'1800-01-01',NULL,0),
	(5249,78,'Casola di Napoli',0,'1800-01-01',NULL,0),
	(5250,78,'Casoria',0,'1800-01-01',NULL,0),
	(5251,78,'Castellammare di Stabia',0,'1800-01-01',NULL,0),
	(5252,78,'Castello di Cisterna',0,'1800-01-01',NULL,0),
	(5253,78,'Cercola',0,'1800-01-01',NULL,0),
	(5254,78,'Cicciano',0,'1800-01-01',NULL,0),
	(5255,78,'Cimitile',0,'1800-01-01',NULL,0),
	(5256,78,'Comiziano',0,'1800-01-01',NULL,0),
	(5257,78,'Crispano',0,'1800-01-01',NULL,0),
	(5258,78,'Forio',0,'1800-01-01',NULL,0),
	(5259,78,'Frattamaggiore',0,'1800-01-01',NULL,0),
	(5260,78,'Frattaminore',0,'1800-01-01',NULL,0),
	(5261,78,'Giugliano in Campania',0,'1800-01-01',NULL,0),
	(5262,78,'Gragnano',0,'1800-01-01',NULL,0),
	(5263,78,'Grumo Nevano',0,'1800-01-01',NULL,0),
	(5264,78,'Ischia',0,'1800-01-01',NULL,0),
	(5265,78,'Lacco Ameno',0,'1800-01-01',NULL,0),
	(5266,78,'Lettere',0,'1800-01-01',NULL,0),
	(5267,78,'Liveri',0,'1800-01-01',NULL,0),
	(5268,78,'Marano di Napoli',0,'1800-01-01',NULL,0),
	(5269,78,'Mariglianella',0,'1800-01-01',NULL,0),
	(5270,78,'Marigliano',0,'1800-01-01',NULL,0),
	(5271,78,'Massa Lubrense',0,'1800-01-01',NULL,0),
	(5272,78,'Melito di Napoli',0,'1800-01-01',NULL,0),
	(5273,78,'Meta',0,'1800-01-01',NULL,0),
	(5274,78,'Monte di Procida',0,'1800-01-01',NULL,0),
	(5275,78,'Mugnano di Napoli',0,'1800-01-01',NULL,0),
	(5276,78,'Napoli',1,'1800-01-01',NULL,0),
	(5277,78,'Nola',0,'1800-01-01',NULL,0),
	(5278,78,'Ottaviano',0,'1800-01-01',NULL,0),
	(5279,78,'Palma Campania',0,'1800-01-01',NULL,0),
	(5280,78,'Piano di Sorrento',0,'1800-01-01',NULL,0),
	(5281,78,'Pimonte',0,'1800-01-01',NULL,0),
	(5282,78,'Poggiomarino',0,'1800-01-01',NULL,0),
	(5283,78,'Pollena Trocchia',0,'1800-01-01',NULL,0),
	(5284,78,'Pomigliano d\'Arco',0,'1800-01-01',NULL,0),
	(5285,78,'Pompei',0,'1800-01-01',NULL,0),
	(5286,78,'Portici',0,'1800-01-01',NULL,0),
	(5287,78,'Pozzuoli',0,'1800-01-01',NULL,0),
	(5288,78,'Procida',0,'1800-01-01',NULL,0),
	(5289,78,'Qualiano',0,'1800-01-01',NULL,0),
	(5290,78,'Quarto',0,'1800-01-01',NULL,0),
	(5291,78,'Ercolano',0,'1800-01-01',NULL,0),
	(5292,78,'Roccarainola',0,'1800-01-01',NULL,0),
	(5293,78,'San Gennaro Vesuviano',0,'1800-01-01',NULL,0),
	(5294,78,'San Giorgio a Cremano',0,'1800-01-01',NULL,0),
	(5295,78,'San Giuseppe Vesuviano',0,'1800-01-01',NULL,0),
	(5296,78,'San Paolo Bel Sito',0,'1800-01-01',NULL,0),
	(5297,78,'San Sebastiano al Vesuvio',0,'1800-01-01',NULL,0),
	(5298,78,'Sant\'Agnello',0,'1800-01-01',NULL,0),
	(5299,78,'Sant\'Anastasia',0,'1800-01-01',NULL,0),
	(5300,78,'Sant\'Antimo',0,'1800-01-01',NULL,0),
	(5301,78,'Sant\'Antonio Abate',0,'1800-01-01',NULL,0),
	(5302,78,'San Vitaliano',0,'1800-01-01',NULL,0),
	(5303,78,'Saviano',0,'1800-01-01',NULL,0),
	(5304,78,'Scisciano',0,'1800-01-01',NULL,0),
	(5305,78,'Serrara Fontana',0,'1800-01-01',NULL,0),
	(5306,78,'Somma Vesuviana',0,'1800-01-01',NULL,0),
	(5307,78,'Sorrento',0,'1800-01-01',NULL,0),
	(5308,78,'Striano',0,'1800-01-01',NULL,0),
	(5309,78,'Terzigno',0,'1800-01-01',NULL,0),
	(5310,78,'Torre Annunziata',0,'1800-01-01',NULL,0),
	(5311,78,'Torre del Greco',0,'1800-01-01',NULL,0),
	(5312,78,'Tufino',0,'1800-01-01',NULL,0),
	(5313,78,'Vico Equense',0,'1800-01-01',NULL,0),
	(5314,78,'Villaricca',0,'1800-01-01',NULL,0),
	(5315,78,'Visciano',0,'1800-01-01',NULL,0),
	(5316,78,'Volla',0,'1800-01-01',NULL,0),
	(5317,78,'Santa Maria la Carità',0,'1800-01-01',NULL,0),
	(5318,78,'Trecase',0,'1800-01-01',NULL,0),
	(5319,78,'Massa di Somma',0,'1800-01-01',NULL,0),
	(5320,79,'Aiello del Sabato',0,'1800-01-01',NULL,0),
	(5321,79,'Altavilla Irpina',0,'1800-01-01',NULL,0),
	(5322,79,'Andretta',0,'1800-01-01',NULL,0),
	(5323,79,'Aquilonia',0,'1800-01-01',NULL,0),
	(5324,79,'Ariano Irpino',0,'1800-01-01',NULL,0),
	(5325,79,'Atripalda',0,'1800-01-01',NULL,0),
	(5326,79,'Avella',0,'1800-01-01',NULL,0),
	(5327,79,'Avellino',1,'1800-01-01',NULL,0),
	(5328,79,'Bagnoli Irpino',0,'1800-01-01',NULL,0),
	(5329,79,'Baiano',0,'1800-01-01',NULL,0),
	(5330,79,'Bisaccia',0,'1800-01-01',NULL,0),
	(5331,79,'Bonito',0,'1800-01-01',NULL,0),
	(5332,79,'Cairano',0,'1800-01-01',NULL,0),
	(5333,79,'Calabritto',0,'1800-01-01',NULL,0),
	(5334,79,'Calitri',0,'1800-01-01',NULL,0),
	(5335,79,'Candida',0,'1800-01-01',NULL,0),
	(5336,79,'Caposele',0,'1800-01-01',NULL,0),
	(5337,79,'Capriglia Irpina',0,'1800-01-01',NULL,0),
	(5338,79,'Carife',0,'1800-01-01',NULL,0),
	(5339,79,'Casalbore',0,'1800-01-01',NULL,0),
	(5340,79,'Cassano Irpino',0,'1800-01-01',NULL,0),
	(5341,79,'Castel Baronia',0,'1800-01-01',NULL,0),
	(5342,79,'Castelfranci',0,'1800-01-01',NULL,0),
	(5343,79,'Castelvetere sul Calore',0,'1800-01-01',NULL,0),
	(5344,79,'Cervinara',0,'1800-01-01',NULL,0),
	(5345,79,'Cesinali',0,'1800-01-01',NULL,0),
	(5346,79,'Chianche',0,'1800-01-01',NULL,0),
	(5347,79,'Chiusano di San Domenico',0,'1800-01-01',NULL,0),
	(5348,79,'Contrada',0,'1800-01-01',NULL,0),
	(5349,79,'Conza della Campania',0,'1800-01-01',NULL,0),
	(5350,79,'Domicella',0,'1800-01-01',NULL,0),
	(5351,79,'Flumeri',0,'1800-01-01',NULL,0),
	(5352,79,'Fontanarosa',0,'1800-01-01',NULL,0),
	(5353,79,'Forino',0,'1800-01-01',NULL,0),
	(5354,79,'Frigento',0,'1800-01-01',NULL,0),
	(5355,79,'Gesualdo',0,'1800-01-01',NULL,0),
	(5356,79,'Greci',0,'1800-01-01',NULL,0),
	(5357,79,'Grottaminarda',0,'1800-01-01',NULL,0),
	(5358,79,'Grottolella',0,'1800-01-01',NULL,0),
	(5359,79,'Guardia Lombardi',0,'1800-01-01',NULL,0),
	(5360,79,'Lacedonia',0,'1800-01-01',NULL,0),
	(5361,79,'Lapio',0,'1800-01-01',NULL,0),
	(5362,79,'Lauro',0,'1800-01-01',NULL,0),
	(5363,79,'Lioni',0,'1800-01-01',NULL,0),
	(5364,79,'Luogosano',0,'1800-01-01',NULL,0),
	(5365,79,'Manocalzati',0,'1800-01-01',NULL,0),
	(5366,79,'Marzano di Nola',0,'1800-01-01',NULL,0),
	(5367,79,'Melito Irpino',0,'1800-01-01',NULL,0),
	(5368,79,'Mercogliano',0,'1800-01-01',NULL,0),
	(5369,79,'Mirabella Eclano',0,'1800-01-01',NULL,0),
	(5370,79,'Montaguto',0,'1800-01-01',NULL,0),
	(5371,79,'Montecalvo Irpino',0,'1800-01-01',NULL,0),
	(5372,79,'Montefalcione',0,'1800-01-01',NULL,0),
	(5373,79,'Monteforte Irpino',0,'1800-01-01',NULL,0),
	(5374,79,'Montefredane',0,'1800-01-01',NULL,0),
	(5375,79,'Montefusco',0,'1800-01-01',NULL,0),
	(5376,79,'Montella',0,'1800-01-01',NULL,0),
	(5377,79,'Montemarano',0,'1800-01-01',NULL,0),
	(5378,79,'Montemiletto',0,'1800-01-01',NULL,0),
	(5379,79,'Monteverde',0,'1800-01-01',NULL,0),
	(5380,79,'Montoro Inferiore',0,'1800-01-01',NULL,0),
	(5381,79,'Montoro Superiore',0,'1800-01-01',NULL,0);

INSERT INTO `geo_comuni` (`id`, `provincia_id`, `denominazione`, `capoluogo`, `data_istituzione`, `data_destituzione`, `cessato`)
VALUES
	(5382,79,'Morra De Sanctis',0,'1800-01-01',NULL,0),
	(5383,79,'Moschiano',0,'1800-01-01',NULL,0),
	(5384,79,'Mugnano del Cardinale',0,'1800-01-01',NULL,0),
	(5385,79,'Nusco',0,'1800-01-01',NULL,0),
	(5386,79,'Ospedaletto d\'Alpinolo',0,'1800-01-01',NULL,0),
	(5387,79,'Pago del Vallo di Lauro',0,'1800-01-01',NULL,0),
	(5388,79,'Parolise',0,'1800-01-01',NULL,0),
	(5389,79,'Paternopoli',0,'1800-01-01',NULL,0),
	(5390,79,'Petruro Irpino',0,'1800-01-01',NULL,0),
	(5391,79,'Pietradefusi',0,'1800-01-01',NULL,0),
	(5392,79,'Pietrastornina',0,'1800-01-01',NULL,0),
	(5393,79,'Prata di Principato Ultra',0,'1800-01-01',NULL,0),
	(5394,79,'Pratola Serra',0,'1800-01-01',NULL,0),
	(5395,79,'Quadrelle',0,'1800-01-01',NULL,0),
	(5396,79,'Quindici',0,'1800-01-01',NULL,0),
	(5397,79,'Roccabascerana',0,'1800-01-01',NULL,0),
	(5398,79,'Rocca San Felice',0,'1800-01-01',NULL,0),
	(5399,79,'Rotondi',0,'1800-01-01',NULL,0),
	(5400,79,'Salza Irpina',0,'1800-01-01',NULL,0),
	(5401,79,'San Mango sul Calore',0,'1800-01-01',NULL,0),
	(5402,79,'San Martino Valle Caudina',0,'1800-01-01',NULL,0),
	(5403,79,'San Michele di Serino',0,'1800-01-01',NULL,0),
	(5404,79,'San Nicola Baronia',0,'1800-01-01',NULL,0),
	(5405,79,'San Potito Ultra',0,'1800-01-01',NULL,0),
	(5406,79,'San Sossio Baronia',0,'1800-01-01',NULL,0),
	(5407,79,'Santa Lucia di Serino',0,'1800-01-01',NULL,0),
	(5408,79,'Sant\'Andrea di Conza',0,'1800-01-01',NULL,0),
	(5409,79,'Sant\'Angelo all\'Esca',0,'1800-01-01',NULL,0),
	(5410,79,'Sant\'Angelo a Scala',0,'1800-01-01',NULL,0),
	(5411,79,'Sant\'Angelo dei Lombardi',0,'1800-01-01',NULL,0),
	(5412,79,'Santa Paolina',0,'1800-01-01',NULL,0),
	(5413,79,'Santo Stefano del Sole',0,'1800-01-01',NULL,0),
	(5414,79,'Savignano Irpino',0,'1800-01-01',NULL,0),
	(5415,79,'Scampitella',0,'1800-01-01',NULL,0),
	(5416,79,'Senerchia',0,'1800-01-01',NULL,0),
	(5417,79,'Serino',0,'1800-01-01',NULL,0),
	(5418,79,'Sirignano',0,'1800-01-01',NULL,0),
	(5419,79,'Solofra',0,'1800-01-01',NULL,0),
	(5420,79,'Sorbo Serpico',0,'1800-01-01',NULL,0),
	(5421,79,'Sperone',0,'1800-01-01',NULL,0),
	(5422,79,'Sturno',0,'1800-01-01',NULL,0),
	(5423,79,'Summonte',0,'1800-01-01',NULL,0),
	(5424,79,'Taurano',0,'1800-01-01',NULL,0),
	(5425,79,'Taurasi',0,'1800-01-01',NULL,0),
	(5426,79,'Teora',0,'1800-01-01',NULL,0),
	(5427,79,'Torella dei Lombardi',0,'1800-01-01',NULL,0),
	(5428,79,'Torre Le Nocelle',0,'1800-01-01',NULL,0),
	(5429,79,'Torrioni',0,'1800-01-01',NULL,0),
	(5430,79,'Trevico',0,'1800-01-01',NULL,0),
	(5431,79,'Tufo',0,'1800-01-01',NULL,0),
	(5432,79,'Vallata',0,'1800-01-01',NULL,0),
	(5433,79,'Vallesaccarda',0,'1800-01-01',NULL,0),
	(5434,79,'Venticano',0,'1800-01-01',NULL,0),
	(5435,79,'Villamaina',0,'1800-01-01',NULL,0),
	(5436,79,'Villanova del Battista',0,'1800-01-01',NULL,0),
	(5437,79,'Volturara Irpina',0,'1800-01-01',NULL,0),
	(5438,79,'Zungoli',0,'1800-01-01',NULL,0),
	(5439,80,'Acerno',0,'1800-01-01',NULL,0),
	(5440,80,'Agropoli',0,'1800-01-01',NULL,0),
	(5441,80,'Albanella',0,'1800-01-01',NULL,0),
	(5442,80,'Alfano',0,'1800-01-01',NULL,0),
	(5443,80,'Altavilla Silentina',0,'1800-01-01',NULL,0),
	(5444,80,'Amalfi',0,'1800-01-01',NULL,0),
	(5445,80,'Angri',0,'1800-01-01',NULL,0),
	(5446,80,'Aquara',0,'1800-01-01',NULL,0),
	(5447,80,'Ascea',0,'1800-01-01',NULL,0),
	(5448,80,'Atena Lucana',0,'1800-01-01',NULL,0),
	(5449,80,'Atrani',0,'1800-01-01',NULL,0),
	(5450,80,'Auletta',0,'1800-01-01',NULL,0),
	(5451,80,'Baronissi',0,'1800-01-01',NULL,0),
	(5452,80,'Battipaglia',0,'1800-01-01',NULL,0),
	(5453,80,'Bellosguardo',0,'1800-01-01',NULL,0),
	(5454,80,'Bracigliano',0,'1800-01-01',NULL,0),
	(5455,80,'Buccino',0,'1800-01-01',NULL,0),
	(5456,80,'Buonabitacolo',0,'1800-01-01',NULL,0),
	(5457,80,'Caggiano',0,'1800-01-01',NULL,0),
	(5458,80,'Calvanico',0,'1800-01-01',NULL,0),
	(5459,80,'Camerota',0,'1800-01-01',NULL,0),
	(5460,80,'Campagna',0,'1800-01-01',NULL,0),
	(5461,80,'Campora',0,'1800-01-01',NULL,0),
	(5462,80,'Cannalonga',0,'1800-01-01',NULL,0),
	(5463,80,'Capaccio',0,'1800-01-01',NULL,0),
	(5464,80,'Casalbuono',0,'1800-01-01',NULL,0),
	(5465,80,'Casaletto Spartano',0,'1800-01-01',NULL,0),
	(5466,80,'Casal Velino',0,'1800-01-01',NULL,0),
	(5467,80,'Caselle in Pittari',0,'1800-01-01',NULL,0),
	(5468,80,'Castelcivita',0,'1800-01-01',NULL,0),
	(5469,80,'Castellabate',0,'1800-01-01',NULL,0),
	(5470,80,'Castelnuovo Cilento',0,'1800-01-01',NULL,0),
	(5471,80,'Castelnuovo di Conza',0,'1800-01-01',NULL,0),
	(5472,80,'Castel San Giorgio',0,'1800-01-01',NULL,0),
	(5473,80,'Castel San Lorenzo',0,'1800-01-01',NULL,0),
	(5474,80,'Castiglione del Genovesi',0,'1800-01-01',NULL,0),
	(5475,80,'Cava de\' Tirreni',0,'1800-01-01',NULL,0),
	(5476,80,'Celle di Bulgheria',0,'1800-01-01',NULL,0),
	(5477,80,'Centola',0,'1800-01-01',NULL,0),
	(5478,80,'Ceraso',0,'1800-01-01',NULL,0),
	(5479,80,'Cetara',0,'1800-01-01',NULL,0),
	(5480,80,'Cicerale',0,'1800-01-01',NULL,0),
	(5481,80,'Colliano',0,'1800-01-01',NULL,0),
	(5482,80,'Conca dei Marini',0,'1800-01-01',NULL,0),
	(5483,80,'Controne',0,'1800-01-01',NULL,0),
	(5484,80,'Contursi Terme',0,'1800-01-01',NULL,0),
	(5485,80,'Corbara',0,'1800-01-01',NULL,0),
	(5486,80,'Corleto Monforte',0,'1800-01-01',NULL,0),
	(5487,80,'Cuccaro Vetere',0,'1800-01-01',NULL,0),
	(5488,80,'Eboli',0,'1800-01-01',NULL,0),
	(5489,80,'Felitto',0,'1800-01-01',NULL,0),
	(5490,80,'Fisciano',0,'1800-01-01',NULL,0),
	(5491,80,'Furore',0,'1800-01-01',NULL,0),
	(5492,80,'Futani',0,'1800-01-01',NULL,0),
	(5493,80,'Giffoni Sei Casali',0,'1800-01-01',NULL,0),
	(5494,80,'Giffoni Valle Piana',0,'1800-01-01',NULL,0),
	(5495,80,'Gioi',0,'1800-01-01',NULL,0),
	(5496,80,'Giungano',0,'1800-01-01',NULL,0),
	(5497,80,'Ispani',0,'1800-01-01',NULL,0),
	(5498,80,'Laureana Cilento',0,'1800-01-01',NULL,0),
	(5499,80,'Laurino',0,'1800-01-01',NULL,0),
	(5500,80,'Laurito',0,'1800-01-01',NULL,0),
	(5501,80,'Laviano',0,'1800-01-01',NULL,0),
	(5502,80,'Lustra',0,'1800-01-01',NULL,0),
	(5503,80,'Magliano Vetere',0,'1800-01-01',NULL,0),
	(5504,80,'Maiori',0,'1800-01-01',NULL,0),
	(5505,80,'Mercato San Severino',0,'1800-01-01',NULL,0),
	(5506,80,'Minori',0,'1800-01-01',NULL,0),
	(5507,80,'Moio della Civitella',0,'1800-01-01',NULL,0),
	(5508,80,'Montano Antilia',0,'1800-01-01',NULL,0),
	(5509,80,'Montecorice',0,'1800-01-01',NULL,0),
	(5510,80,'Montecorvino Pugliano',0,'1800-01-01',NULL,0),
	(5511,80,'Montecorvino Rovella',0,'1800-01-01',NULL,0),
	(5512,80,'Monteforte Cilento',0,'1800-01-01',NULL,0),
	(5513,80,'Monte San Giacomo',0,'1800-01-01',NULL,0),
	(5514,80,'Montesano sulla Marcellana',0,'1800-01-01',NULL,0),
	(5515,80,'Morigerati',0,'1800-01-01',NULL,0),
	(5516,80,'Nocera Inferiore',0,'1800-01-01',NULL,0),
	(5517,80,'Nocera Superiore',0,'1800-01-01',NULL,0),
	(5518,80,'Novi Velia',0,'1800-01-01',NULL,0),
	(5519,80,'Ogliastro Cilento',0,'1800-01-01',NULL,0),
	(5520,80,'Olevano sul Tusciano',0,'1800-01-01',NULL,0),
	(5521,80,'Oliveto Citra',0,'1800-01-01',NULL,0),
	(5522,80,'Omignano',0,'1800-01-01',NULL,0),
	(5523,80,'Orria',0,'1800-01-01',NULL,0),
	(5524,80,'Ottati',0,'1800-01-01',NULL,0),
	(5525,80,'Padula',0,'1800-01-01',NULL,0),
	(5526,80,'Pagani',0,'1800-01-01',NULL,0),
	(5527,80,'Palomonte',0,'1800-01-01',NULL,0),
	(5528,80,'Pellezzano',0,'1800-01-01',NULL,0),
	(5529,80,'Perdifumo',0,'1800-01-01',NULL,0),
	(5530,80,'Perito',0,'1800-01-01',NULL,0),
	(5531,80,'Pertosa',0,'1800-01-01',NULL,0),
	(5532,80,'Petina',0,'1800-01-01',NULL,0),
	(5533,80,'Piaggine',0,'1800-01-01',NULL,0),
	(5534,80,'Pisciotta',0,'1800-01-01',NULL,0),
	(5535,80,'Polla',0,'1800-01-01',NULL,0),
	(5536,80,'Pollica',0,'1800-01-01',NULL,0),
	(5537,80,'Pontecagnano Faiano',0,'1800-01-01',NULL,0),
	(5538,80,'Positano',0,'1800-01-01',NULL,0),
	(5539,80,'Postiglione',0,'1800-01-01',NULL,0),
	(5540,80,'Praiano',0,'1800-01-01',NULL,0),
	(5541,80,'Prignano Cilento',0,'1800-01-01',NULL,0),
	(5542,80,'Ravello',0,'1800-01-01',NULL,0),
	(5543,80,'Ricigliano',0,'1800-01-01',NULL,0),
	(5544,80,'Roccadaspide',0,'1800-01-01',NULL,0),
	(5545,80,'Roccagloriosa',0,'1800-01-01',NULL,0),
	(5546,80,'Roccapiemonte',0,'1800-01-01',NULL,0),
	(5547,80,'Rofrano',0,'1800-01-01',NULL,0),
	(5548,80,'Romagnano al Monte',0,'1800-01-01',NULL,0),
	(5549,80,'Roscigno',0,'1800-01-01',NULL,0),
	(5550,80,'Rutino',0,'1800-01-01',NULL,0),
	(5551,80,'Sacco',0,'1800-01-01',NULL,0),
	(5552,80,'Sala Consilina',0,'1800-01-01',NULL,0),
	(5553,80,'Salento',0,'1800-01-01',NULL,0),
	(5554,80,'Salerno',1,'1800-01-01',NULL,0),
	(5555,80,'Salvitelle',0,'1800-01-01',NULL,0),
	(5556,80,'San Cipriano Picentino',0,'1800-01-01',NULL,0),
	(5557,80,'San Giovanni a Piro',0,'1800-01-01',NULL,0),
	(5558,80,'San Gregorio Magno',0,'1800-01-01',NULL,0),
	(5559,80,'San Mango Piemonte',0,'1800-01-01',NULL,0),
	(5560,80,'San Marzano sul Sarno',0,'1800-01-01',NULL,0),
	(5561,80,'San Mauro Cilento',0,'1800-01-01',NULL,0),
	(5562,80,'San Mauro la Bruca',0,'1800-01-01',NULL,0),
	(5563,80,'San Pietro al Tanagro',0,'1800-01-01',NULL,0),
	(5564,80,'San Rufo',0,'1800-01-01',NULL,0),
	(5565,80,'Santa Marina',0,'1800-01-01',NULL,0),
	(5566,80,'Sant\'Angelo a Fasanella',0,'1800-01-01',NULL,0),
	(5567,80,'Sant\'Arsenio',0,'1800-01-01',NULL,0),
	(5568,80,'Sant\'Egidio del Monte Albino',0,'1800-01-01',NULL,0),
	(5569,80,'Santomenna',0,'1800-01-01',NULL,0),
	(5570,80,'San Valentino Torio',0,'1800-01-01',NULL,0),
	(5571,80,'Sanza',0,'1800-01-01',NULL,0),
	(5572,80,'Sapri',0,'1800-01-01',NULL,0),
	(5573,80,'Sarno',0,'1800-01-01',NULL,0),
	(5574,80,'Sassano',0,'1800-01-01',NULL,0),
	(5575,80,'Scafati',0,'1800-01-01',NULL,0),
	(5576,80,'Scala',0,'1800-01-01',NULL,0),
	(5577,80,'Serramezzana',0,'1800-01-01',NULL,0),
	(5578,80,'Serre',0,'1800-01-01',NULL,0),
	(5579,80,'Sessa Cilento',0,'1800-01-01',NULL,0),
	(5580,80,'Siano',0,'1800-01-01',NULL,0),
	(5581,80,'Sicignano degli Alburni',0,'1800-01-01',NULL,0),
	(5582,80,'Stella Cilento',0,'1800-01-01',NULL,0),
	(5583,80,'Stio',0,'1800-01-01',NULL,0),
	(5584,80,'Teggiano',0,'1800-01-01',NULL,0),
	(5585,80,'Torchiara',0,'1800-01-01',NULL,0),
	(5586,80,'Torraca',0,'1800-01-01',NULL,0),
	(5587,80,'Torre Orsaia',0,'1800-01-01',NULL,0),
	(5588,80,'Tortorella',0,'1800-01-01',NULL,0),
	(5589,80,'Tramonti',0,'1800-01-01',NULL,0),
	(5590,80,'Trentinara',0,'1800-01-01',NULL,0),
	(5591,80,'Valle dell\'Angelo',0,'1800-01-01',NULL,0),
	(5592,80,'Vallo della Lucania',0,'1800-01-01',NULL,0),
	(5593,80,'Valva',0,'1800-01-01',NULL,0),
	(5594,80,'Vibonati',0,'1800-01-01',NULL,0),
	(5595,80,'Vietri sul Mare',0,'1800-01-01',NULL,0),
	(5596,80,'Bellizzi',0,'1800-01-01',NULL,0),
	(5597,70,'Acciano',0,'1800-01-01',NULL,0),
	(5598,70,'Aielli',0,'1800-01-01',NULL,0),
	(5599,70,'Alfedena',0,'1800-01-01',NULL,0),
	(5600,70,'Anversa degli Abruzzi',0,'1800-01-01',NULL,0),
	(5601,70,'Ateleta',0,'1800-01-01',NULL,0),
	(5602,70,'Avezzano',0,'1800-01-01',NULL,0),
	(5603,70,'Balsorano',0,'1800-01-01',NULL,0),
	(5604,70,'Barete',0,'1800-01-01',NULL,0),
	(5605,70,'Barisciano',0,'1800-01-01',NULL,0),
	(5606,70,'Barrea',0,'1800-01-01',NULL,0),
	(5607,70,'Bisegna',0,'1800-01-01',NULL,0),
	(5608,70,'Bugnara',0,'1800-01-01',NULL,0),
	(5609,70,'Cagnano Amiterno',0,'1800-01-01',NULL,0),
	(5610,70,'Calascio',0,'1800-01-01',NULL,0),
	(5611,70,'Campo di Giove',0,'1800-01-01',NULL,0),
	(5612,70,'Campotosto',0,'1800-01-01',NULL,0),
	(5613,70,'Canistro',0,'1800-01-01',NULL,0),
	(5614,70,'Cansano',0,'1800-01-01',NULL,0),
	(5615,70,'Capestrano',0,'1800-01-01',NULL,0),
	(5616,70,'Capistrello',0,'1800-01-01',NULL,0),
	(5617,70,'Capitignano',0,'1800-01-01',NULL,0),
	(5618,70,'Caporciano',0,'1800-01-01',NULL,0),
	(5619,70,'Cappadocia',0,'1800-01-01',NULL,0),
	(5620,70,'Carapelle Calvisio',0,'1800-01-01',NULL,0),
	(5621,70,'Carsoli',0,'1800-01-01',NULL,0),
	(5622,70,'Castel del Monte',0,'1800-01-01',NULL,0),
	(5623,70,'Castel di Ieri',0,'1800-01-01',NULL,0),
	(5624,70,'Castel di Sangro',0,'1800-01-01',NULL,0),
	(5625,70,'Castellafiume',0,'1800-01-01',NULL,0),
	(5626,70,'Castelvecchio Calvisio',0,'1800-01-01',NULL,0),
	(5627,70,'Castelvecchio Subequo',0,'1800-01-01',NULL,0),
	(5628,70,'Celano',0,'1800-01-01',NULL,0),
	(5629,70,'Cerchio',0,'1800-01-01',NULL,0),
	(5630,70,'Civita d\'Antino',0,'1800-01-01',NULL,0),
	(5631,70,'Civitella Alfedena',0,'1800-01-01',NULL,0),
	(5632,70,'Civitella Roveto',0,'1800-01-01',NULL,0),
	(5633,70,'Cocullo',0,'1800-01-01',NULL,0),
	(5634,70,'Collarmele',0,'1800-01-01',NULL,0),
	(5635,70,'Collelongo',0,'1800-01-01',NULL,0),
	(5636,70,'Collepietro',0,'1800-01-01',NULL,0),
	(5637,70,'Corfinio',0,'1800-01-01',NULL,0),
	(5638,70,'Fagnano Alto',0,'1800-01-01',NULL,0),
	(5639,70,'Fontecchio',0,'1800-01-01',NULL,0),
	(5640,70,'Fossa',0,'1800-01-01',NULL,0),
	(5641,70,'Gagliano Aterno',0,'1800-01-01',NULL,0),
	(5642,70,'Gioia dei Marsi',0,'1800-01-01',NULL,0),
	(5643,70,'Goriano Sicoli',0,'1800-01-01',NULL,0),
	(5644,70,'Introdacqua',0,'1800-01-01',NULL,0),
	(5645,70,'L\'Aquila',1,'1800-01-01',NULL,0),
	(5646,70,'Lecce nei Marsi',0,'1800-01-01',NULL,0),
	(5647,70,'Luco dei Marsi',0,'1800-01-01',NULL,0),
	(5648,70,'Lucoli',0,'1800-01-01',NULL,0),
	(5649,70,'Magliano de\' Marsi',0,'1800-01-01',NULL,0),
	(5650,70,'Massa d\'Albe',0,'1800-01-01',NULL,0),
	(5651,70,'Molina Aterno',0,'1800-01-01',NULL,0),
	(5652,70,'Montereale',0,'1800-01-01',NULL,0),
	(5653,70,'Morino',0,'1800-01-01',NULL,0),
	(5654,70,'Navelli',0,'1800-01-01',NULL,0),
	(5655,70,'Ocre',0,'1800-01-01',NULL,0),
	(5656,70,'Ofena',0,'1800-01-01',NULL,0),
	(5657,70,'Opi',0,'1800-01-01',NULL,0),
	(5658,70,'Oricola',0,'1800-01-01',NULL,0),
	(5659,70,'Ortona dei Marsi',0,'1800-01-01',NULL,0),
	(5660,70,'Ortucchio',0,'1800-01-01',NULL,0),
	(5661,70,'Ovindoli',0,'1800-01-01',NULL,0),
	(5662,70,'Pacentro',0,'1800-01-01',NULL,0),
	(5663,70,'Pereto',0,'1800-01-01',NULL,0),
	(5664,70,'Pescasseroli',0,'1800-01-01',NULL,0),
	(5665,70,'Pescina',0,'1800-01-01',NULL,0),
	(5666,70,'Pescocostanzo',0,'1800-01-01',NULL,0),
	(5667,70,'Pettorano sul Gizio',0,'1800-01-01',NULL,0),
	(5668,70,'Pizzoli',0,'1800-01-01',NULL,0),
	(5669,70,'Poggio Picenze',0,'1800-01-01',NULL,0),
	(5670,70,'Prata d\'Ansidonia',0,'1800-01-01',NULL,0),
	(5671,70,'Pratola Peligna',0,'1800-01-01',NULL,0),
	(5672,70,'Prezza',0,'1800-01-01',NULL,0),
	(5673,70,'Raiano',0,'1800-01-01',NULL,0),
	(5674,70,'Rivisondoli',0,'1800-01-01',NULL,0),
	(5675,70,'Roccacasale',0,'1800-01-01',NULL,0),
	(5676,70,'Rocca di Botte',0,'1800-01-01',NULL,0),
	(5677,70,'Rocca di Cambio',0,'1800-01-01',NULL,0),
	(5678,70,'Rocca di Mezzo',0,'1800-01-01',NULL,0),
	(5679,70,'Rocca Pia',0,'1800-01-01',NULL,0),
	(5680,70,'Roccaraso',0,'1800-01-01',NULL,0),
	(5681,70,'San Benedetto dei Marsi',0,'1800-01-01',NULL,0),
	(5682,70,'San Benedetto in Perillis',0,'1800-01-01',NULL,0),
	(5683,70,'San Demetrio ne\' Vestini',0,'1800-01-01',NULL,0),
	(5684,70,'San Pio delle Camere',0,'1800-01-01',NULL,0),
	(5685,70,'Sante Marie',0,'1800-01-01',NULL,0),
	(5686,70,'Sant\'Eusanio Forconese',0,'1800-01-01',NULL,0),
	(5687,70,'Santo Stefano di Sessanio',0,'1800-01-01',NULL,0),
	(5688,70,'San Vincenzo Valle Roveto',0,'1800-01-01',NULL,0),
	(5689,70,'Scanno',0,'1800-01-01',NULL,0),
	(5690,70,'Scontrone',0,'1800-01-01',NULL,0),
	(5691,70,'Scoppito',0,'1800-01-01',NULL,0),
	(5692,70,'Scurcola Marsicana',0,'1800-01-01',NULL,0),
	(5693,70,'Secinaro',0,'1800-01-01',NULL,0),
	(5694,70,'Sulmona',0,'1800-01-01',NULL,0),
	(5695,70,'Tagliacozzo',0,'1800-01-01',NULL,0),
	(5696,70,'Tione degli Abruzzi',0,'1800-01-01',NULL,0),
	(5697,70,'Tornimparte',0,'1800-01-01',NULL,0),
	(5698,70,'Trasacco',0,'1800-01-01',NULL,0),
	(5699,70,'Villalago',0,'1800-01-01',NULL,0),
	(5700,70,'Villa Santa Lucia degli Abruzzi',0,'1800-01-01',NULL,0),
	(5701,70,'Villa Sant\'Angelo',0,'1800-01-01',NULL,0),
	(5702,70,'Villavallelonga',0,'1800-01-01',NULL,0),
	(5703,70,'Villetta Barrea',0,'1800-01-01',NULL,0),
	(5704,70,'Vittorito',0,'1800-01-01',NULL,0),
	(5705,71,'Alba Adriatica',0,'1800-01-01',NULL,0),
	(5706,71,'Ancarano',0,'1800-01-01',NULL,0),
	(5707,71,'Arsita',0,'1800-01-01',NULL,0),
	(5708,71,'Atri',0,'1800-01-01',NULL,0),
	(5709,71,'Basciano',0,'1800-01-01',NULL,0),
	(5710,71,'Bellante',0,'1800-01-01',NULL,0),
	(5711,71,'Bisenti',0,'1800-01-01',NULL,0),
	(5712,71,'Campli',0,'1800-01-01',NULL,0),
	(5713,71,'Canzano',0,'1800-01-01',NULL,0),
	(5714,71,'Castel Castagna',0,'1800-01-01',NULL,0),
	(5715,71,'Castellalto',0,'1800-01-01',NULL,0),
	(5716,71,'Castelli',0,'1800-01-01',NULL,0),
	(5717,71,'Castiglione Messer Raimondo',0,'1800-01-01',NULL,0),
	(5718,71,'Castilenti',0,'1800-01-01',NULL,0),
	(5719,71,'Cellino Attanasio',0,'1800-01-01',NULL,0),
	(5720,71,'Cermignano',0,'1800-01-01',NULL,0),
	(5721,71,'Civitella del Tronto',0,'1800-01-01',NULL,0),
	(5722,71,'Colledara',0,'1800-01-01',NULL,0),
	(5723,71,'Colonnella',0,'1800-01-01',NULL,0),
	(5724,71,'Controguerra',0,'1800-01-01',NULL,0),
	(5725,71,'Corropoli',0,'1800-01-01',NULL,0),
	(5726,71,'Cortino',0,'1800-01-01',NULL,0),
	(5727,71,'Crognaleto',0,'1800-01-01',NULL,0),
	(5728,71,'Fano Adriano',0,'1800-01-01',NULL,0),
	(5729,71,'Giulianova',0,'1800-01-01',NULL,0),
	(5730,71,'Isola del Gran Sasso d\'Italia',0,'1800-01-01',NULL,0),
	(5731,71,'Montefino',0,'1800-01-01',NULL,0),
	(5732,71,'Montorio al Vomano',0,'1800-01-01',NULL,0),
	(5733,71,'Morro d\'Oro',0,'1800-01-01',NULL,0),
	(5734,71,'Mosciano Sant\'Angelo',0,'1800-01-01',NULL,0),
	(5735,71,'Nereto',0,'1800-01-01',NULL,0),
	(5736,71,'Notaresco',0,'1800-01-01',NULL,0),
	(5737,71,'Penna Sant\'Andrea',0,'1800-01-01',NULL,0),
	(5738,71,'Pietracamela',0,'1800-01-01',NULL,0),
	(5739,71,'Pineto',0,'1800-01-01',NULL,0),
	(5740,71,'Rocca Santa Maria',0,'1800-01-01',NULL,0),
	(5741,71,'Roseto degli Abruzzi',0,'1800-01-01',NULL,0),
	(5742,71,'Sant\'Egidio alla Vibrata',0,'1800-01-01',NULL,0),
	(5743,71,'Sant\'Omero',0,'1800-01-01',NULL,0),
	(5744,71,'Silvi',0,'1800-01-01',NULL,0),
	(5745,71,'Teramo',1,'1800-01-01',NULL,0),
	(5746,71,'Torano Nuovo',0,'1800-01-01',NULL,0),
	(5747,71,'Torricella Sicura',0,'1800-01-01',NULL,0),
	(5748,71,'Tortoreto',0,'1800-01-01',NULL,0),
	(5749,71,'Tossicia',0,'1800-01-01',NULL,0),
	(5750,71,'Valle Castellana',0,'1800-01-01',NULL,0),
	(5751,71,'Martinsicuro',0,'1800-01-01',NULL,0),
	(5752,72,'Abbateggio',0,'1800-01-01',NULL,0),
	(5753,72,'Alanno',0,'1800-01-01',NULL,0),
	(5754,72,'Bolognano',0,'1800-01-01',NULL,0),
	(5755,72,'Brittoli',0,'1800-01-01',NULL,0),
	(5756,72,'Bussi sul Tirino',0,'1800-01-01',NULL,0),
	(5757,72,'Cappelle sul Tavo',0,'1800-01-01',NULL,0),
	(5758,72,'Caramanico Terme',0,'1800-01-01',NULL,0),
	(5759,72,'Carpineto della Nora',0,'1800-01-01',NULL,0),
	(5760,72,'Castiglione a Casauria',0,'1800-01-01',NULL,0),
	(5761,72,'Catignano',0,'1800-01-01',NULL,0),
	(5762,72,'Cepagatti',0,'1800-01-01',NULL,0),
	(5763,72,'Città Sant\'Angelo',0,'1800-01-01',NULL,0),
	(5764,72,'Civitaquana',0,'1800-01-01',NULL,0),
	(5765,72,'Civitella Casanova',0,'1800-01-01',NULL,0),
	(5766,72,'Collecorvino',0,'1800-01-01',NULL,0),
	(5767,72,'Corvara',0,'1800-01-01',NULL,0),
	(5768,72,'Cugnoli',0,'1800-01-01',NULL,0),
	(5769,72,'Elice',0,'1800-01-01',NULL,0),
	(5770,72,'Farindola',0,'1800-01-01',NULL,0),
	(5771,72,'Lettomanoppello',0,'1800-01-01',NULL,0),
	(5772,72,'Loreto Aprutino',0,'1800-01-01',NULL,0),
	(5773,72,'Manoppello',0,'1800-01-01',NULL,0),
	(5774,72,'Montebello di Bertona',0,'1800-01-01',NULL,0),
	(5775,72,'Montesilvano',0,'1800-01-01',NULL,0),
	(5776,72,'Moscufo',0,'1800-01-01',NULL,0),
	(5777,72,'Nocciano',0,'1800-01-01',NULL,0),
	(5778,72,'Penne',0,'1800-01-01',NULL,0),
	(5779,72,'Pescara',1,'1800-01-01',NULL,0),
	(5780,72,'Pescosansonesco',0,'1800-01-01',NULL,0),
	(5781,72,'Pianella',0,'1800-01-01',NULL,0),
	(5782,72,'Picciano',0,'1800-01-01',NULL,0),
	(5783,72,'Pietranico',0,'1800-01-01',NULL,0),
	(5784,72,'Popoli',0,'1800-01-01',NULL,0),
	(5785,72,'Roccamorice',0,'1800-01-01',NULL,0),
	(5786,72,'Rosciano',0,'1800-01-01',NULL,0),
	(5787,72,'Salle',0,'1800-01-01',NULL,0),
	(5788,72,'Sant\'Eufemia a Maiella',0,'1800-01-01',NULL,0),
	(5789,72,'San Valentino in Abruzzo Citeriore',0,'1800-01-01',NULL,0),
	(5790,72,'Scafa',0,'1800-01-01',NULL,0),
	(5791,72,'Serramonacesca',0,'1800-01-01',NULL,0),
	(5792,72,'Spoltore',0,'1800-01-01',NULL,0),
	(5793,72,'Tocco da Casauria',0,'1800-01-01',NULL,0),
	(5794,72,'Torre de\' Passeri',0,'1800-01-01',NULL,0),
	(5795,72,'Turrivalignani',0,'1800-01-01',NULL,0),
	(5796,72,'Vicoli',0,'1800-01-01',NULL,0),
	(5797,72,'Villa Celiera',0,'1800-01-01',NULL,0),
	(5798,73,'Altino',0,'1800-01-01',NULL,0),
	(5799,73,'Archi',0,'1800-01-01',NULL,0),
	(5800,73,'Ari',0,'1800-01-01',NULL,0),
	(5801,73,'Arielli',0,'1800-01-01',NULL,0),
	(5802,73,'Atessa',0,'1800-01-01',NULL,0),
	(5803,73,'Bomba',0,'1800-01-01',NULL,0),
	(5804,73,'Borrello',0,'1800-01-01',NULL,0),
	(5805,73,'Bucchianico',0,'1800-01-01',NULL,0),
	(5806,73,'Montebello sul Sangro',0,'1800-01-01',NULL,0),
	(5807,73,'Canosa Sannita',0,'1800-01-01',NULL,0),
	(5808,73,'Carpineto Sinello',0,'1800-01-01',NULL,0),
	(5809,73,'Carunchio',0,'1800-01-01',NULL,0),
	(5810,73,'Casacanditella',0,'1800-01-01',NULL,0),
	(5811,73,'Casalanguida',0,'1800-01-01',NULL,0),
	(5812,73,'Casalbordino',0,'1800-01-01',NULL,0),
	(5813,73,'Casalincontrada',0,'1800-01-01',NULL,0),
	(5814,73,'Casoli',0,'1800-01-01',NULL,0),
	(5815,73,'Castel Frentano',0,'1800-01-01',NULL,0),
	(5816,73,'Castelguidone',0,'1800-01-01',NULL,0),
	(5817,73,'Castiglione Messer Marino',0,'1800-01-01',NULL,0),
	(5818,73,'Celenza sul Trigno',0,'1800-01-01',NULL,0),
	(5819,73,'Chieti',1,'1800-01-01',NULL,0),
	(5820,73,'Civitaluparella',0,'1800-01-01',NULL,0),
	(5821,73,'Civitella Messer Raimondo',0,'1800-01-01',NULL,0),
	(5822,73,'Colledimacine',0,'1800-01-01',NULL,0),
	(5823,73,'Colledimezzo',0,'1800-01-01',NULL,0),
	(5824,73,'Crecchio',0,'1800-01-01',NULL,0),
	(5825,73,'Cupello',0,'1800-01-01',NULL,0),
	(5826,73,'Dogliola',0,'1800-01-01',NULL,0),
	(5827,73,'Fara Filiorum Petri',0,'1800-01-01',NULL,0),
	(5828,73,'Fara San Martino',0,'1800-01-01',NULL,0),
	(5829,73,'Filetto',0,'1800-01-01',NULL,0),
	(5830,73,'Fossacesia',0,'1800-01-01',NULL,0),
	(5831,73,'Fraine',0,'1800-01-01',NULL,0),
	(5832,73,'Francavilla al Mare',0,'1800-01-01',NULL,0),
	(5833,73,'Fresagrandinaria',0,'1800-01-01',NULL,0),
	(5834,73,'Frisa',0,'1800-01-01',NULL,0),
	(5835,73,'Furci',0,'1800-01-01',NULL,0),
	(5836,73,'Gamberale',0,'1800-01-01',NULL,0),
	(5837,73,'Gessopalena',0,'1800-01-01',NULL,0),
	(5838,73,'Gissi',0,'1800-01-01',NULL,0),
	(5839,73,'Giuliano Teatino',0,'1800-01-01',NULL,0),
	(5840,73,'Guardiagrele',0,'1800-01-01',NULL,0),
	(5841,73,'Guilmi',0,'1800-01-01',NULL,0),
	(5842,73,'Lama dei Peligni',0,'1800-01-01',NULL,0),
	(5843,73,'Lanciano',0,'1800-01-01',NULL,0),
	(5844,73,'Lentella',0,'1800-01-01',NULL,0),
	(5845,73,'Lettopalena',0,'1800-01-01',NULL,0),
	(5846,73,'Liscia',0,'1800-01-01',NULL,0),
	(5847,73,'Miglianico',0,'1800-01-01',NULL,0),
	(5848,73,'Montazzoli',0,'1800-01-01',NULL,0),
	(5849,73,'Monteferrante',0,'1800-01-01',NULL,0),
	(5850,73,'Montelapiano',0,'1800-01-01',NULL,0),
	(5851,73,'Montenerodomo',0,'1800-01-01',NULL,0),
	(5852,73,'Monteodorisio',0,'1800-01-01',NULL,0),
	(5853,73,'Mozzagrogna',0,'1800-01-01',NULL,0),
	(5854,73,'Orsogna',0,'1800-01-01',NULL,0),
	(5855,73,'Ortona',0,'1800-01-01',NULL,0),
	(5856,73,'Paglieta',0,'1800-01-01',NULL,0),
	(5857,73,'Palena',0,'1800-01-01',NULL,0),
	(5858,73,'Palmoli',0,'1800-01-01',NULL,0),
	(5859,73,'Palombaro',0,'1800-01-01',NULL,0),
	(5860,73,'Pennadomo',0,'1800-01-01',NULL,0),
	(5861,73,'Pennapiedimonte',0,'1800-01-01',NULL,0),
	(5862,73,'Perano',0,'1800-01-01',NULL,0),
	(5863,73,'Pizzoferrato',0,'1800-01-01',NULL,0),
	(5864,73,'Poggiofiorito',0,'1800-01-01',NULL,0),
	(5865,73,'Pollutri',0,'1800-01-01',NULL,0),
	(5866,73,'Pretoro',0,'1800-01-01',NULL,0),
	(5867,73,'Quadri',0,'1800-01-01',NULL,0),
	(5868,73,'Rapino',0,'1800-01-01',NULL,0),
	(5869,73,'Ripa Teatina',0,'1800-01-01',NULL,0),
	(5870,73,'Roccamontepiano',0,'1800-01-01',NULL,0),
	(5871,73,'Rocca San Giovanni',0,'1800-01-01',NULL,0),
	(5872,73,'Roccascalegna',0,'1800-01-01',NULL,0),
	(5873,73,'Roccaspinalveti',0,'1800-01-01',NULL,0),
	(5874,73,'Roio del Sangro',0,'1800-01-01',NULL,0),
	(5875,73,'Rosello',0,'1800-01-01',NULL,0),
	(5876,73,'San Buono',0,'1800-01-01',NULL,0),
	(5877,73,'San Giovanni Lipioni',0,'1800-01-01',NULL,0),
	(5878,73,'San Giovanni Teatino',0,'1800-01-01',NULL,0),
	(5879,73,'San Martino sulla Marrucina',0,'1800-01-01',NULL,0),
	(5880,73,'San Salvo',0,'1800-01-01',NULL,0),
	(5881,73,'Santa Maria Imbaro',0,'1800-01-01',NULL,0),
	(5882,73,'Sant\'Eusanio del Sangro',0,'1800-01-01',NULL,0),
	(5883,73,'San Vito Chietino',0,'1800-01-01',NULL,0),
	(5884,73,'Scerni',0,'1800-01-01',NULL,0),
	(5885,73,'Schiavi di Abruzzo',0,'1800-01-01',NULL,0),
	(5886,73,'Taranta Peligna',0,'1800-01-01',NULL,0),
	(5887,73,'Tollo',0,'1800-01-01',NULL,0),
	(5888,73,'Torino di Sangro',0,'1800-01-01',NULL,0),
	(5889,73,'Tornareccio',0,'1800-01-01',NULL,0),
	(5890,73,'Torrebruna',0,'1800-01-01',NULL,0),
	(5891,73,'Torrevecchia Teatina',0,'1800-01-01',NULL,0),
	(5892,73,'Torricella Peligna',0,'1800-01-01',NULL,0),
	(5893,73,'Treglio',0,'1800-01-01',NULL,0),
	(5894,73,'Tufillo',0,'1800-01-01',NULL,0),
	(5895,73,'Vacri',0,'1800-01-01',NULL,0),
	(5896,73,'Vasto',0,'1800-01-01',NULL,0),
	(5897,73,'Villalfonsina',0,'1800-01-01',NULL,0),
	(5898,73,'Villamagna',0,'1800-01-01',NULL,0),
	(5899,73,'Villa Santa Maria',0,'1800-01-01',NULL,0),
	(5900,73,'Pietraferrazzana',0,'1800-01-01',NULL,0),
	(5901,73,'Fallo',0,'1800-01-01',NULL,0),
	(5902,74,'Acquaviva Collecroce',0,'1800-01-01',NULL,0),
	(5903,74,'Baranello',0,'1800-01-01',NULL,0),
	(5904,74,'Bojano',0,'1800-01-01',NULL,0),
	(5905,74,'Bonefro',0,'1800-01-01',NULL,0),
	(5906,74,'Busso',0,'1800-01-01',NULL,0),
	(5907,74,'Campobasso',1,'1800-01-01',NULL,0),
	(5908,74,'Campochiaro',0,'1800-01-01',NULL,0),
	(5909,74,'Campodipietra',0,'1800-01-01',NULL,0),
	(5910,74,'Campolieto',0,'1800-01-01',NULL,0),
	(5911,74,'Campomarino',0,'1800-01-01',NULL,0),
	(5912,74,'Casacalenda',0,'1800-01-01',NULL,0),
	(5913,74,'Casalciprano',0,'1800-01-01',NULL,0),
	(5914,74,'Castelbottaccio',0,'1800-01-01',NULL,0),
	(5915,74,'Castellino del Biferno',0,'1800-01-01',NULL,0),
	(5916,74,'Castelmauro',0,'1800-01-01',NULL,0),
	(5917,74,'Castropignano',0,'1800-01-01',NULL,0),
	(5918,74,'Cercemaggiore',0,'1800-01-01',NULL,0),
	(5919,74,'Cercepiccola',0,'1800-01-01',NULL,0),
	(5920,74,'Civitacampomarano',0,'1800-01-01',NULL,0),
	(5921,74,'Colle d\'Anchise',0,'1800-01-01',NULL,0),
	(5922,74,'Colletorto',0,'1800-01-01',NULL,0),
	(5923,74,'Duronia',0,'1800-01-01',NULL,0),
	(5924,74,'Ferrazzano',0,'1800-01-01',NULL,0),
	(5925,74,'Fossalto',0,'1800-01-01',NULL,0),
	(5926,74,'Gambatesa',0,'1800-01-01',NULL,0),
	(5927,74,'Gildone',0,'1800-01-01',NULL,0),
	(5928,74,'Guardialfiera',0,'1800-01-01',NULL,0),
	(5929,74,'Guardiaregia',0,'1800-01-01',NULL,0),
	(5930,74,'Guglionesi',0,'1800-01-01',NULL,0),
	(5931,74,'Jelsi',0,'1800-01-01',NULL,0),
	(5932,74,'Larino',0,'1800-01-01',NULL,0),
	(5933,74,'Limosano',0,'1800-01-01',NULL,0),
	(5934,74,'Lucito',0,'1800-01-01',NULL,0),
	(5935,74,'Lupara',0,'1800-01-01',NULL,0),
	(5936,74,'Macchia Valfortore',0,'1800-01-01',NULL,0),
	(5937,74,'Mafalda',0,'1800-01-01',NULL,0),
	(5938,74,'Matrice',0,'1800-01-01',NULL,0),
	(5939,74,'Mirabello Sannitico',0,'1800-01-01',NULL,0),
	(5940,74,'Molise',0,'1800-01-01',NULL,0),
	(5941,74,'Monacilioni',0,'1800-01-01',NULL,0),
	(5942,74,'Montagano',0,'1800-01-01',NULL,0),
	(5943,74,'Montecilfone',0,'1800-01-01',NULL,0),
	(5944,74,'Montefalcone nel Sannio',0,'1800-01-01',NULL,0),
	(5945,74,'Montelongo',0,'1800-01-01',NULL,0),
	(5946,74,'Montemitro',0,'1800-01-01',NULL,0),
	(5947,74,'Montenero di Bisaccia',0,'1800-01-01',NULL,0),
	(5948,74,'Montorio nei Frentani',0,'1800-01-01',NULL,0),
	(5949,74,'Morrone del Sannio',0,'1800-01-01',NULL,0),
	(5950,74,'Oratino',0,'1800-01-01',NULL,0),
	(5951,74,'Palata',0,'1800-01-01',NULL,0),
	(5952,74,'Petacciato',0,'1800-01-01',NULL,0),
	(5953,74,'Petrella Tifernina',0,'1800-01-01',NULL,0),
	(5954,74,'Pietracatella',0,'1800-01-01',NULL,0),
	(5955,74,'Pietracupa',0,'1800-01-01',NULL,0),
	(5956,74,'Portocannone',0,'1800-01-01',NULL,0),
	(5957,74,'Provvidenti',0,'1800-01-01',NULL,0),
	(5958,74,'Riccia',0,'1800-01-01',NULL,0),
	(5959,74,'Ripabottoni',0,'1800-01-01',NULL,0),
	(5960,74,'Ripalimosani',0,'1800-01-01',NULL,0),
	(5961,74,'Roccavivara',0,'1800-01-01',NULL,0),
	(5962,74,'Rotello',0,'1800-01-01',NULL,0),
	(5963,74,'Salcito',0,'1800-01-01',NULL,0),
	(5964,74,'San Biase',0,'1800-01-01',NULL,0),
	(5965,74,'San Felice del Molise',0,'1800-01-01',NULL,0),
	(5966,74,'San Giacomo degli Schiavoni',0,'1800-01-01',NULL,0),
	(5967,74,'San Giovanni in Galdo',0,'1800-01-01',NULL,0),
	(5968,74,'San Giuliano del Sannio',0,'1800-01-01',NULL,0),
	(5969,74,'San Giuliano di Puglia',0,'1800-01-01',NULL,0),
	(5970,74,'San Martino in Pensilis',0,'1800-01-01',NULL,0),
	(5971,74,'San Massimo',0,'1800-01-01',NULL,0),
	(5972,74,'San Polo Matese',0,'1800-01-01',NULL,0),
	(5973,74,'Santa Croce di Magliano',0,'1800-01-01',NULL,0),
	(5974,74,'Sant\'Angelo Limosano',0,'1800-01-01',NULL,0),
	(5975,74,'Sant\'Elia a Pianisi',0,'1800-01-01',NULL,0),
	(5976,74,'Sepino',0,'1800-01-01',NULL,0),
	(5977,74,'Spinete',0,'1800-01-01',NULL,0),
	(5978,74,'Tavenna',0,'1800-01-01',NULL,0),
	(5979,74,'Termoli',0,'1800-01-01',NULL,0),
	(5980,74,'Torella del Sannio',0,'1800-01-01',NULL,0),
	(5981,74,'Toro',0,'1800-01-01',NULL,0),
	(5982,74,'Trivento',0,'1800-01-01',NULL,0),
	(5983,74,'Tufara',0,'1800-01-01',NULL,0),
	(5984,74,'Ururi',0,'1800-01-01',NULL,0),
	(5985,74,'Vinchiaturo',0,'1800-01-01',NULL,0),
	(5986,81,'Accadia',0,'1800-01-01',NULL,0),
	(5987,81,'Alberona',0,'1800-01-01',NULL,0),
	(5988,81,'Anzano di Puglia',0,'1800-01-01',NULL,0),
	(5989,81,'Apricena',0,'1800-01-01',NULL,0),
	(5990,81,'Ascoli Satriano',0,'1800-01-01',NULL,0),
	(5991,81,'Biccari',0,'1800-01-01',NULL,0),
	(5992,81,'Bovino',0,'1800-01-01',NULL,0),
	(5993,81,'Cagnano Varano',0,'1800-01-01',NULL,0),
	(5994,81,'Candela',0,'1800-01-01',NULL,0),
	(5995,81,'Carapelle',0,'1800-01-01',NULL,0),
	(5996,81,'Carlantino',0,'1800-01-01',NULL,0),
	(5997,81,'Carpino',0,'1800-01-01',NULL,0),
	(5998,81,'Casalnuovo Monterotaro',0,'1800-01-01',NULL,0),
	(5999,81,'Casalvecchio di Puglia',0,'1800-01-01',NULL,0),
	(6000,81,'Castelluccio dei Sauri',0,'1800-01-01',NULL,0),
	(6001,81,'Castelluccio Valmaggiore',0,'1800-01-01',NULL,0),
	(6002,81,'Castelnuovo della Daunia',0,'1800-01-01',NULL,0),
	(6003,81,'Celenza Valfortore',0,'1800-01-01',NULL,0),
	(6004,81,'Celle di San Vito',0,'1800-01-01',NULL,0),
	(6005,81,'Cerignola',0,'1800-01-01',NULL,0),
	(6006,81,'Chieuti',0,'1800-01-01',NULL,0),
	(6007,81,'Deliceto',0,'1800-01-01',NULL,0),
	(6008,81,'Faeto',0,'1800-01-01',NULL,0),
	(6009,81,'Foggia',1,'1800-01-01',NULL,0),
	(6010,81,'Ischitella',0,'1800-01-01',NULL,0),
	(6011,81,'Isole Tremiti',0,'1800-01-01',NULL,0),
	(6012,81,'Lesina',0,'1800-01-01',NULL,0),
	(6013,81,'Lucera',0,'1800-01-01',NULL,0),
	(6014,81,'Manfredonia',0,'1800-01-01',NULL,0),
	(6015,81,'Mattinata',0,'1800-01-01',NULL,0),
	(6016,81,'Monteleone di Puglia',0,'1800-01-01',NULL,0),
	(6017,81,'Monte Sant\'Angelo',0,'1800-01-01',NULL,0),
	(6018,81,'Motta Montecorvino',0,'1800-01-01',NULL,0),
	(6019,81,'Orsara di Puglia',0,'1800-01-01',NULL,0),
	(6020,81,'Orta Nova',0,'1800-01-01',NULL,0),
	(6021,81,'Panni',0,'1800-01-01',NULL,0),
	(6022,81,'Peschici',0,'1800-01-01',NULL,0),
	(6023,81,'Pietramontecorvino',0,'1800-01-01',NULL,0),
	(6024,81,'Poggio Imperiale',0,'1800-01-01',NULL,0),
	(6025,81,'Rignano Garganico',0,'1800-01-01',NULL,0),
	(6026,81,'Rocchetta Sant\'Antonio',0,'1800-01-01',NULL,0),
	(6027,81,'Rodi Garganico',0,'1800-01-01',NULL,0),
	(6028,81,'Roseto Valfortore',0,'1800-01-01',NULL,0),
	(6029,81,'San Giovanni Rotondo',0,'1800-01-01',NULL,0),
	(6030,81,'San Marco in Lamis',0,'1800-01-01',NULL,0),
	(6031,81,'San Marco la Catola',0,'1800-01-01',NULL,0),
	(6032,81,'San Nicandro Garganico',0,'1800-01-01',NULL,0),
	(6033,81,'San Paolo di Civitate',0,'1800-01-01',NULL,0),
	(6034,81,'San Severo',0,'1800-01-01',NULL,0),
	(6035,81,'Sant\'Agata di Puglia',0,'1800-01-01',NULL,0),
	(6036,81,'Serracapriola',0,'1800-01-01',NULL,0),
	(6037,81,'Stornara',0,'1800-01-01',NULL,0),
	(6038,81,'Stornarella',0,'1800-01-01',NULL,0),
	(6039,81,'Torremaggiore',0,'1800-01-01',NULL,0),
	(6040,81,'Troia',0,'1800-01-01',NULL,0),
	(6041,81,'Vico del Gargano',0,'1800-01-01',NULL,0),
	(6042,81,'Vieste',0,'1800-01-01',NULL,0),
	(6043,81,'Volturara Appula',0,'1800-01-01',NULL,0),
	(6044,81,'Volturino',0,'1800-01-01',NULL,0),
	(6045,81,'Ordona',0,'1800-01-01',NULL,0),
	(6046,81,'Zapponeta',0,'1800-01-01',NULL,0),
	(6047,82,'Acquaviva delle Fonti',0,'1800-01-01',NULL,0),
	(6048,82,'Adelfia',0,'1800-01-01',NULL,0),
	(6049,82,'Alberobello',0,'1800-01-01',NULL,0),
	(6050,82,'Altamura',0,'1800-01-01',NULL,0),
	(6051,82,'Bari',1,'1800-01-01',NULL,0),
	(6052,82,'Binetto',0,'1800-01-01',NULL,0),
	(6053,82,'Bitetto',0,'1800-01-01',NULL,0),
	(6054,82,'Bitonto',0,'1800-01-01',NULL,0),
	(6055,82,'Bitritto',0,'1800-01-01',NULL,0),
	(6056,82,'Capurso',0,'1800-01-01',NULL,0),
	(6057,82,'Casamassima',0,'1800-01-01',NULL,0),
	(6058,82,'Cassano delle Murge',0,'1800-01-01',NULL,0),
	(6059,82,'Castellana Grotte',0,'1800-01-01',NULL,0),
	(6060,82,'Cellamare',0,'1800-01-01',NULL,0),
	(6061,82,'Conversano',0,'1800-01-01',NULL,0),
	(6062,82,'Corato',0,'1800-01-01',NULL,0),
	(6063,82,'Gioia del Colle',0,'1800-01-01',NULL,0),
	(6064,82,'Giovinazzo',0,'1800-01-01',NULL,0),
	(6065,82,'Gravina in Puglia',0,'1800-01-01',NULL,0),
	(6066,82,'Grumo Appula',0,'1800-01-01',NULL,0),
	(6067,82,'Locorotondo',0,'1800-01-01',NULL,0),
	(6068,82,'Modugno',0,'1800-01-01',NULL,0),
	(6069,82,'Mola di Bari',0,'1800-01-01',NULL,0),
	(6070,82,'Molfetta',0,'1800-01-01',NULL,0),
	(6071,82,'Monopoli',0,'1800-01-01',NULL,0),
	(6072,82,'Noci',0,'1800-01-01',NULL,0),
	(6073,82,'Noicattaro',0,'1800-01-01',NULL,0),
	(6074,82,'Palo del Colle',0,'1800-01-01',NULL,0),
	(6075,82,'Poggiorsini',0,'1800-01-01',NULL,0),
	(6076,82,'Polignano a Mare',0,'1800-01-01',NULL,0),
	(6077,82,'Putignano',0,'1800-01-01',NULL,0),
	(6078,82,'Rutigliano',0,'1800-01-01',NULL,0),
	(6079,82,'Ruvo di Puglia',0,'1800-01-01',NULL,0),
	(6080,82,'Sammichele di Bari',0,'1800-01-01',NULL,0),
	(6081,82,'Sannicandro di Bari',0,'1800-01-01',NULL,0),
	(6082,82,'Santeramo in Colle',0,'1800-01-01',NULL,0),
	(6083,82,'Terlizzi',0,'1800-01-01',NULL,0),
	(6084,82,'Toritto',0,'1800-01-01',NULL,0),
	(6085,82,'Triggiano',0,'1800-01-01',NULL,0),
	(6086,82,'Turi',0,'1800-01-01',NULL,0),
	(6087,82,'Valenzano',0,'1800-01-01',NULL,0),
	(6088,83,'Avetrana',0,'1800-01-01',NULL,0),
	(6089,83,'Carosino',0,'1800-01-01',NULL,0),
	(6090,83,'Castellaneta',0,'1800-01-01',NULL,0),
	(6091,83,'Crispiano',0,'1800-01-01',NULL,0),
	(6092,83,'Faggiano',0,'1800-01-01',NULL,0),
	(6093,83,'Fragagnano',0,'1800-01-01',NULL,0),
	(6094,83,'Ginosa',0,'1800-01-01',NULL,0),
	(6095,83,'Grottaglie',0,'1800-01-01',NULL,0),
	(6096,83,'Laterza',0,'1800-01-01',NULL,0),
	(6097,83,'Leporano',0,'1800-01-01',NULL,0),
	(6098,83,'Lizzano',0,'1800-01-01',NULL,0),
	(6099,83,'Manduria',0,'1800-01-01',NULL,0),
	(6100,83,'Martina Franca',0,'1800-01-01',NULL,0),
	(6101,83,'Maruggio',0,'1800-01-01',NULL,0),
	(6102,83,'Massafra',0,'1800-01-01',NULL,0),
	(6103,83,'Monteiasi',0,'1800-01-01',NULL,0),
	(6104,83,'Montemesola',0,'1800-01-01',NULL,0),
	(6105,83,'Monteparano',0,'1800-01-01',NULL,0),
	(6106,83,'Mottola',0,'1800-01-01',NULL,0),
	(6107,83,'Palagianello',0,'1800-01-01',NULL,0),
	(6108,83,'Palagiano',0,'1800-01-01',NULL,0),
	(6109,83,'Pulsano',0,'1800-01-01',NULL,0),
	(6110,83,'Roccaforzata',0,'1800-01-01',NULL,0),
	(6111,83,'San Giorgio Ionico',0,'1800-01-01',NULL,0),
	(6112,83,'San Marzano di San Giuseppe',0,'1800-01-01',NULL,0),
	(6113,83,'Sava',0,'1800-01-01',NULL,0),
	(6114,83,'Taranto',1,'1800-01-01',NULL,0),
	(6115,83,'Torricella',0,'1800-01-01',NULL,0),
	(6116,83,'Statte',0,'1800-01-01',NULL,0),
	(6117,84,'Brindisi',1,'1800-01-01',NULL,0),
	(6118,84,'Carovigno',0,'1800-01-01',NULL,0),
	(6119,84,'Ceglie Messapica',0,'1800-01-01',NULL,0),
	(6120,84,'Cellino San Marco',0,'1800-01-01',NULL,0),
	(6121,84,'Cisternino',0,'1800-01-01',NULL,0),
	(6122,84,'Erchie',0,'1800-01-01',NULL,0),
	(6123,84,'Fasano',0,'1800-01-01',NULL,0),
	(6124,84,'Francavilla Fontana',0,'1800-01-01',NULL,0),
	(6125,84,'Latiano',0,'1800-01-01',NULL,0),
	(6126,84,'Mesagne',0,'1800-01-01',NULL,0),
	(6127,84,'Oria',0,'1800-01-01',NULL,0),
	(6128,84,'Ostuni',0,'1800-01-01',NULL,0),
	(6129,84,'San Donaci',0,'1800-01-01',NULL,0),
	(6130,84,'San Michele Salentino',0,'1800-01-01',NULL,0),
	(6131,84,'San Pancrazio Salentino',0,'1800-01-01',NULL,0),
	(6132,84,'San Pietro Vernotico',0,'1800-01-01',NULL,0),
	(6133,84,'San Vito dei Normanni',0,'1800-01-01',NULL,0),
	(6134,84,'Torchiarolo',0,'1800-01-01',NULL,0),
	(6135,84,'Torre Santa Susanna',0,'1800-01-01',NULL,0),
	(6136,84,'Villa Castelli',0,'1800-01-01',NULL,0),
	(6137,85,'Acquarica del Capo',0,'1800-01-01',NULL,0),
	(6138,85,'Alessano',0,'1800-01-01',NULL,0),
	(6139,85,'Alezio',0,'1800-01-01',NULL,0),
	(6140,85,'Alliste',0,'1800-01-01',NULL,0),
	(6141,85,'Andrano',0,'1800-01-01',NULL,0),
	(6142,85,'Aradeo',0,'1800-01-01',NULL,0),
	(6143,85,'Arnesano',0,'1800-01-01',NULL,0),
	(6144,85,'Bagnolo del Salento',0,'1800-01-01',NULL,0),
	(6145,85,'Botrugno',0,'1800-01-01',NULL,0),
	(6146,85,'Calimera',0,'1800-01-01',NULL,0),
	(6147,85,'Campi Salentina',0,'1800-01-01',NULL,0),
	(6148,85,'Cannole',0,'1800-01-01',NULL,0),
	(6149,85,'Caprarica di Lecce',0,'1800-01-01',NULL,0),
	(6150,85,'Carmiano',0,'1800-01-01',NULL,0),
	(6151,85,'Carpignano Salentino',0,'1800-01-01',NULL,0),
	(6152,85,'Casarano',0,'1800-01-01',NULL,0),
	(6153,85,'Castri di Lecce',0,'1800-01-01',NULL,0),
	(6154,85,'Castrignano de\' Greci',0,'1800-01-01',NULL,0),
	(6155,85,'Castrignano del Capo',0,'1800-01-01',NULL,0),
	(6156,85,'Cavallino',0,'1800-01-01',NULL,0),
	(6157,85,'Collepasso',0,'1800-01-01',NULL,0),
	(6158,85,'Copertino',0,'1800-01-01',NULL,0),
	(6159,85,'Corigliano d\'Otranto',0,'1800-01-01',NULL,0),
	(6160,85,'Corsano',0,'1800-01-01',NULL,0),
	(6161,85,'Cursi',0,'1800-01-01',NULL,0),
	(6162,85,'Cutrofiano',0,'1800-01-01',NULL,0),
	(6163,85,'Diso',0,'1800-01-01',NULL,0),
	(6164,85,'Gagliano del Capo',0,'1800-01-01',NULL,0),
	(6165,85,'Galatina',0,'1800-01-01',NULL,0),
	(6166,85,'Galatone',0,'1800-01-01',NULL,0),
	(6167,85,'Gallipoli',0,'1800-01-01',NULL,0),
	(6168,85,'Giuggianello',0,'1800-01-01',NULL,0),
	(6169,85,'Giurdignano',0,'1800-01-01',NULL,0),
	(6170,85,'Guagnano',0,'1800-01-01',NULL,0),
	(6171,85,'Lecce',1,'1800-01-01',NULL,0),
	(6172,85,'Lequile',0,'1800-01-01',NULL,0),
	(6173,85,'Leverano',0,'1800-01-01',NULL,0),
	(6174,85,'Lizzanello',0,'1800-01-01',NULL,0),
	(6175,85,'Maglie',0,'1800-01-01',NULL,0),
	(6176,85,'Martano',0,'1800-01-01',NULL,0),
	(6177,85,'Martignano',0,'1800-01-01',NULL,0),
	(6178,85,'Matino',0,'1800-01-01',NULL,0),
	(6179,85,'Melendugno',0,'1800-01-01',NULL,0),
	(6180,85,'Melissano',0,'1800-01-01',NULL,0),
	(6181,85,'Melpignano',0,'1800-01-01',NULL,0),
	(6182,85,'Miggiano',0,'1800-01-01',NULL,0),
	(6183,85,'Minervino di Lecce',0,'1800-01-01',NULL,0),
	(6184,85,'Monteroni di Lecce',0,'1800-01-01',NULL,0),
	(6185,85,'Montesano Salentino',0,'1800-01-01',NULL,0),
	(6186,85,'Morciano di Leuca',0,'1800-01-01',NULL,0),
	(6187,85,'Muro Leccese',0,'1800-01-01',NULL,0),
	(6188,85,'Nardò',0,'1800-01-01',NULL,0),
	(6189,85,'Neviano',0,'1800-01-01',NULL,0),
	(6190,85,'Nociglia',0,'1800-01-01',NULL,0),
	(6191,85,'Novoli',0,'1800-01-01',NULL,0),
	(6192,85,'Ortelle',0,'1800-01-01',NULL,0),
	(6193,85,'Otranto',0,'1800-01-01',NULL,0),
	(6194,85,'Palmariggi',0,'1800-01-01',NULL,0),
	(6195,85,'Parabita',0,'1800-01-01',NULL,0),
	(6196,85,'Patù',0,'1800-01-01',NULL,0),
	(6197,85,'Poggiardo',0,'1800-01-01',NULL,0),
	(6198,85,'Presicce',0,'1800-01-01',NULL,0),
	(6199,85,'Racale',0,'1800-01-01',NULL,0),
	(6200,85,'Ruffano',0,'1800-01-01',NULL,0),
	(6201,85,'Salice Salentino',0,'1800-01-01',NULL,0),
	(6202,85,'Salve',0,'1800-01-01',NULL,0),
	(6203,85,'Sanarica',0,'1800-01-01',NULL,0),
	(6204,85,'San Cesario di Lecce',0,'1800-01-01',NULL,0),
	(6205,85,'San Donato di Lecce',0,'1800-01-01',NULL,0),
	(6206,85,'Sannicola',0,'1800-01-01',NULL,0),
	(6207,85,'San Pietro in Lama',0,'1800-01-01',NULL,0),
	(6208,85,'Santa Cesarea Terme',0,'1800-01-01',NULL,0),
	(6209,85,'Scorrano',0,'1800-01-01',NULL,0),
	(6210,85,'Seclì',0,'1800-01-01',NULL,0),
	(6211,85,'Sogliano Cavour',0,'1800-01-01',NULL,0),
	(6212,85,'Soleto',0,'1800-01-01',NULL,0),
	(6213,85,'Specchia',0,'1800-01-01',NULL,0),
	(6214,85,'Spongano',0,'1800-01-01',NULL,0),
	(6215,85,'Squinzano',0,'1800-01-01',NULL,0),
	(6216,85,'Sternatia',0,'1800-01-01',NULL,0),
	(6217,85,'Supersano',0,'1800-01-01',NULL,0),
	(6218,85,'Surano',0,'1800-01-01',NULL,0),
	(6219,85,'Surbo',0,'1800-01-01',NULL,0),
	(6220,85,'Taurisano',0,'1800-01-01',NULL,0),
	(6221,85,'Taviano',0,'1800-01-01',NULL,0),
	(6222,85,'Tiggiano',0,'1800-01-01',NULL,0),
	(6223,85,'Trepuzzi',0,'1800-01-01',NULL,0),
	(6224,85,'Tricase',0,'1800-01-01',NULL,0),
	(6225,85,'Tuglie',0,'1800-01-01',NULL,0),
	(6226,85,'Ugento',0,'1800-01-01',NULL,0),
	(6227,85,'Uggiano la Chiesa',0,'1800-01-01',NULL,0),
	(6228,85,'Veglie',0,'1800-01-01',NULL,0),
	(6229,85,'Vernole',0,'1800-01-01',NULL,0),
	(6230,85,'Zollino',0,'1800-01-01',NULL,0),
	(6231,85,'San Cassiano',0,'1800-01-01',NULL,0),
	(6232,85,'Castro',0,'1800-01-01',NULL,0),
	(6233,85,'Porto Cesareo',0,'1800-01-01',NULL,0),
	(6234,87,'Abriola',0,'1800-01-01',NULL,0),
	(6235,87,'Acerenza',0,'1800-01-01',NULL,0),
	(6236,87,'Albano di Lucania',0,'1800-01-01',NULL,0),
	(6237,87,'Anzi',0,'1800-01-01',NULL,0),
	(6238,87,'Armento',0,'1800-01-01',NULL,0),
	(6239,87,'Atella',0,'1800-01-01',NULL,0),
	(6240,87,'Avigliano',0,'1800-01-01',NULL,0),
	(6241,87,'Balvano',0,'1800-01-01',NULL,0),
	(6242,87,'Banzi',0,'1800-01-01',NULL,0),
	(6243,87,'Baragiano',0,'1800-01-01',NULL,0),
	(6244,87,'Barile',0,'1800-01-01',NULL,0),
	(6245,87,'Bella',0,'1800-01-01',NULL,0),
	(6246,87,'Brienza',0,'1800-01-01',NULL,0),
	(6247,87,'Brindisi Montagna',0,'1800-01-01',NULL,0),
	(6248,87,'Calvello',0,'1800-01-01',NULL,0),
	(6249,87,'Calvera',0,'1800-01-01',NULL,0),
	(6250,87,'Campomaggiore',0,'1800-01-01',NULL,0),
	(6251,87,'Cancellara',0,'1800-01-01',NULL,0),
	(6252,87,'Carbone',0,'1800-01-01',NULL,0),
	(6253,87,'San Paolo Albanese',0,'1800-01-01',NULL,0),
	(6254,87,'Castelgrande',0,'1800-01-01',NULL,0),
	(6255,87,'Castelluccio Inferiore',0,'1800-01-01',NULL,0),
	(6256,87,'Castelluccio Superiore',0,'1800-01-01',NULL,0),
	(6257,87,'Castelmezzano',0,'1800-01-01',NULL,0),
	(6258,87,'Castelsaraceno',0,'1800-01-01',NULL,0),
	(6259,87,'Castronuovo di Sant\'Andrea',0,'1800-01-01',NULL,0),
	(6260,87,'Cersosimo',0,'1800-01-01',NULL,0),
	(6261,87,'Chiaromonte',0,'1800-01-01',NULL,0),
	(6262,87,'Corleto Perticara',0,'1800-01-01',NULL,0),
	(6263,87,'Episcopia',0,'1800-01-01',NULL,0),
	(6264,87,'Fardella',0,'1800-01-01',NULL,0),
	(6265,87,'Filiano',0,'1800-01-01',NULL,0),
	(6266,87,'Forenza',0,'1800-01-01',NULL,0),
	(6267,87,'Francavilla in Sinni',0,'1800-01-01',NULL,0),
	(6268,87,'Gallicchio',0,'1800-01-01',NULL,0),
	(6269,87,'Genzano di Lucania',0,'1800-01-01',NULL,0),
	(6270,87,'Grumento Nova',0,'1800-01-01',NULL,0),
	(6271,87,'Guardia Perticara',0,'1800-01-01',NULL,0),
	(6272,87,'Lagonegro',0,'1800-01-01',NULL,0),
	(6273,87,'Latronico',0,'1800-01-01',NULL,0),
	(6274,87,'Laurenzana',0,'1800-01-01',NULL,0),
	(6275,87,'Lauria',0,'1800-01-01',NULL,0),
	(6276,87,'Lavello',0,'1800-01-01',NULL,0),
	(6277,87,'Maratea',0,'1800-01-01',NULL,0),
	(6278,87,'Marsico Nuovo',0,'1800-01-01',NULL,0),
	(6279,87,'Marsicovetere',0,'1800-01-01',NULL,0),
	(6280,87,'Maschito',0,'1800-01-01',NULL,0),
	(6281,87,'Melfi',0,'1800-01-01',NULL,0),
	(6282,87,'Missanello',0,'1800-01-01',NULL,0),
	(6283,87,'Moliterno',0,'1800-01-01',NULL,0),
	(6284,87,'Montemilone',0,'1800-01-01',NULL,0),
	(6285,87,'Montemurro',0,'1800-01-01',NULL,0),
	(6286,87,'Muro Lucano',0,'1800-01-01',NULL,0),
	(6287,87,'Nemoli',0,'1800-01-01',NULL,0),
	(6288,87,'Noepoli',0,'1800-01-01',NULL,0),
	(6289,87,'Oppido Lucano',0,'1800-01-01',NULL,0),
	(6290,87,'Palazzo San Gervasio',0,'1800-01-01',NULL,0),
	(6291,87,'Pescopagano',0,'1800-01-01',NULL,0),
	(6292,87,'Picerno',0,'1800-01-01',NULL,0),
	(6293,87,'Pietragalla',0,'1800-01-01',NULL,0),
	(6294,87,'Pietrapertosa',0,'1800-01-01',NULL,0),
	(6295,87,'Pignola',0,'1800-01-01',NULL,0),
	(6296,87,'Potenza',1,'1800-01-01',NULL,0),
	(6297,87,'Rapolla',0,'1800-01-01',NULL,0),
	(6298,87,'Rapone',0,'1800-01-01',NULL,0),
	(6299,87,'Rionero in Vulture',0,'1800-01-01',NULL,0),
	(6300,87,'Ripacandida',0,'1800-01-01',NULL,0),
	(6301,87,'Rivello',0,'1800-01-01',NULL,0),
	(6302,87,'Roccanova',0,'1800-01-01',NULL,0),
	(6303,87,'Rotonda',0,'1800-01-01',NULL,0),
	(6304,87,'Ruoti',0,'1800-01-01',NULL,0),
	(6305,87,'Ruvo del Monte',0,'1800-01-01',NULL,0),
	(6306,87,'San Chirico Nuovo',0,'1800-01-01',NULL,0),
	(6307,87,'San Chirico Raparo',0,'1800-01-01',NULL,0),
	(6308,87,'San Costantino Albanese',0,'1800-01-01',NULL,0),
	(6309,87,'San Fele',0,'1800-01-01',NULL,0),
	(6310,87,'San Martino d\'Agri',0,'1800-01-01',NULL,0),
	(6311,87,'San Severino Lucano',0,'1800-01-01',NULL,0),
	(6312,87,'Sant\'Angelo Le Fratte',0,'1800-01-01',NULL,0),
	(6313,87,'Sant\'Arcangelo',0,'1800-01-01',NULL,0),
	(6314,87,'Sarconi',0,'1800-01-01',NULL,0),
	(6315,87,'Sasso di Castalda',0,'1800-01-01',NULL,0),
	(6316,87,'Satriano di Lucania',0,'1800-01-01',NULL,0),
	(6317,87,'Savoia di Lucania',0,'1800-01-01',NULL,0),
	(6318,87,'Senise',0,'1800-01-01',NULL,0),
	(6319,87,'Spinoso',0,'1800-01-01',NULL,0),
	(6320,87,'Teana',0,'1800-01-01',NULL,0),
	(6321,87,'Terranova di Pollino',0,'1800-01-01',NULL,0),
	(6322,87,'Tito',0,'1800-01-01',NULL,0),
	(6323,87,'Tolve',0,'1800-01-01',NULL,0),
	(6324,87,'Tramutola',0,'1800-01-01',NULL,0),
	(6325,87,'Trecchina',0,'1800-01-01',NULL,0),
	(6326,87,'Trivigno',0,'1800-01-01',NULL,0),
	(6327,87,'Vaglio Basilicata',0,'1800-01-01',NULL,0),
	(6328,87,'Venosa',0,'1800-01-01',NULL,0),
	(6329,87,'Vietri di Potenza',0,'1800-01-01',NULL,0),
	(6330,87,'Viggianello',0,'1800-01-01',NULL,0),
	(6331,87,'Viggiano',0,'1800-01-01',NULL,0),
	(6332,87,'Ginestra',0,'1800-01-01',NULL,0),
	(6333,87,'Paterno',0,'1800-01-01',NULL,0),
	(6334,88,'Accettura',0,'1800-01-01',NULL,0),
	(6335,88,'Aliano',0,'1800-01-01',NULL,0),
	(6336,88,'Bernalda',0,'1800-01-01',NULL,0),
	(6337,88,'Calciano',0,'1800-01-01',NULL,0),
	(6338,88,'Cirigliano',0,'1800-01-01',NULL,0),
	(6339,88,'Colobraro',0,'1800-01-01',NULL,0),
	(6340,88,'Craco',0,'1800-01-01',NULL,0),
	(6341,88,'Ferrandina',0,'1800-01-01',NULL,0),
	(6342,88,'Garaguso',0,'1800-01-01',NULL,0),
	(6343,88,'Gorgoglione',0,'1800-01-01',NULL,0),
	(6344,88,'Grassano',0,'1800-01-01',NULL,0),
	(6345,88,'Grottole',0,'1800-01-01',NULL,0),
	(6346,88,'Irsina',0,'1800-01-01',NULL,0),
	(6347,88,'Matera',1,'1800-01-01',NULL,0),
	(6348,88,'Miglionico',0,'1800-01-01',NULL,0),
	(6349,88,'Montalbano Jonico',0,'1800-01-01',NULL,0),
	(6350,88,'Montescaglioso',0,'1800-01-01',NULL,0),
	(6351,88,'Nova Siri',0,'1800-01-01',NULL,0),
	(6352,88,'Oliveto Lucano',0,'1800-01-01',NULL,0),
	(6353,88,'Pisticci',0,'1800-01-01',NULL,0),
	(6354,88,'Policoro',0,'1800-01-01',NULL,0),
	(6355,88,'Pomarico',0,'1800-01-01',NULL,0),
	(6356,88,'Rotondella',0,'1800-01-01',NULL,0),
	(6357,88,'Salandra',0,'1800-01-01',NULL,0),
	(6358,88,'San Giorgio Lucano',0,'1800-01-01',NULL,0),
	(6359,88,'San Mauro Forte',0,'1800-01-01',NULL,0),
	(6360,88,'Stigliano',0,'1800-01-01',NULL,0),
	(6361,88,'Tricarico',0,'1800-01-01',NULL,0),
	(6362,88,'Tursi',0,'1800-01-01',NULL,0),
	(6363,88,'Valsinni',0,'1800-01-01',NULL,0),
	(6364,88,'Scanzano Jonico',0,'1800-01-01',NULL,0),
	(6365,89,'Acquaformosa',0,'1800-01-01',NULL,0),
	(6366,89,'Acquappesa',0,'1800-01-01',NULL,0),
	(6367,89,'Acri',0,'1800-01-01',NULL,0),
	(6368,89,'Aiello Calabro',0,'1800-01-01',NULL,0),
	(6369,89,'Aieta',0,'1800-01-01',NULL,0),
	(6370,89,'Albidona',0,'1800-01-01',NULL,0),
	(6371,89,'Alessandria del Carretto',0,'1800-01-01',NULL,0),
	(6372,89,'Altilia',0,'1800-01-01',NULL,0),
	(6373,89,'Altomonte',0,'1800-01-01',NULL,0),
	(6374,89,'Amantea',0,'1800-01-01',NULL,0),
	(6375,89,'Amendolara',0,'1800-01-01',NULL,0),
	(6376,89,'Aprigliano',0,'1800-01-01',NULL,0),
	(6377,89,'Belmonte Calabro',0,'1800-01-01',NULL,0),
	(6378,89,'Belsito',0,'1800-01-01',NULL,0),
	(6379,89,'Belvedere Marittimo',0,'1800-01-01',NULL,0),
	(6380,89,'Bianchi',0,'1800-01-01',NULL,0),
	(6381,89,'Bisignano',0,'1800-01-01',NULL,0),
	(6382,89,'Bocchigliero',0,'1800-01-01',NULL,0),
	(6383,89,'Bonifati',0,'1800-01-01',NULL,0),
	(6384,89,'Buonvicino',0,'1800-01-01',NULL,0),
	(6385,89,'Calopezzati',0,'1800-01-01',NULL,0),
	(6386,89,'Caloveto',0,'1800-01-01',NULL,0),
	(6387,89,'Campana',0,'1800-01-01',NULL,0),
	(6388,89,'Canna',0,'1800-01-01',NULL,0),
	(6389,89,'Cariati',0,'1800-01-01',NULL,0),
	(6390,89,'Carolei',0,'1800-01-01',NULL,0),
	(6391,89,'Carpanzano',0,'1800-01-01',NULL,0),
	(6392,89,'Casole Bruzio',0,'1800-01-01',NULL,0),
	(6393,89,'Cassano all\'Ionio',0,'1800-01-01',NULL,0),
	(6394,89,'Castiglione Cosentino',0,'1800-01-01',NULL,0),
	(6395,89,'Castrolibero',0,'1800-01-01',NULL,0),
	(6396,89,'Castroregio',0,'1800-01-01',NULL,0),
	(6397,89,'Castrovillari',0,'1800-01-01',NULL,0),
	(6398,89,'Celico',0,'1800-01-01',NULL,0),
	(6399,89,'Cellara',0,'1800-01-01',NULL,0),
	(6400,89,'Cerchiara di Calabria',0,'1800-01-01',NULL,0),
	(6401,89,'Cerisano',0,'1800-01-01',NULL,0),
	(6402,89,'Cervicati',0,'1800-01-01',NULL,0),
	(6403,89,'Cerzeto',0,'1800-01-01',NULL,0),
	(6404,89,'Cetraro',0,'1800-01-01',NULL,0),
	(6405,89,'Civita',0,'1800-01-01',NULL,0),
	(6406,89,'Cleto',0,'1800-01-01',NULL,0),
	(6407,89,'Colosimi',0,'1800-01-01',NULL,0),
	(6408,89,'Corigliano Calabro',0,'1800-01-01',NULL,0),
	(6409,89,'Cosenza',1,'1800-01-01',NULL,0),
	(6410,89,'Cropalati',0,'1800-01-01',NULL,0),
	(6411,89,'Crosia',0,'1800-01-01',NULL,0),
	(6412,89,'Diamante',0,'1800-01-01',NULL,0),
	(6413,89,'Dipignano',0,'1800-01-01',NULL,0),
	(6414,89,'Domanico',0,'1800-01-01',NULL,0),
	(6415,89,'Fagnano Castello',0,'1800-01-01',NULL,0),
	(6416,89,'Falconara Albanese',0,'1800-01-01',NULL,0),
	(6417,89,'Figline Vegliaturo',0,'1800-01-01',NULL,0),
	(6418,89,'Firmo',0,'1800-01-01',NULL,0),
	(6419,89,'Fiumefreddo Bruzio',0,'1800-01-01',NULL,0),
	(6420,89,'Francavilla Marittima',0,'1800-01-01',NULL,0),
	(6421,89,'Frascineto',0,'1800-01-01',NULL,0),
	(6422,89,'Fuscaldo',0,'1800-01-01',NULL,0),
	(6423,89,'Grimaldi',0,'1800-01-01',NULL,0),
	(6424,89,'Grisolia',0,'1800-01-01',NULL,0),
	(6425,89,'Guardia Piemontese',0,'1800-01-01',NULL,0),
	(6426,89,'Lago',0,'1800-01-01',NULL,0),
	(6427,89,'Laino Borgo',0,'1800-01-01',NULL,0),
	(6428,89,'Laino Castello',0,'1800-01-01',NULL,0),
	(6429,89,'Lappano',0,'1800-01-01',NULL,0),
	(6430,89,'Lattarico',0,'1800-01-01',NULL,0),
	(6431,89,'Longobardi',0,'1800-01-01',NULL,0),
	(6432,89,'Longobucco',0,'1800-01-01',NULL,0),
	(6433,89,'Lungro',0,'1800-01-01',NULL,0),
	(6434,89,'Luzzi',0,'1800-01-01',NULL,0),
	(6435,89,'Maierà',0,'1800-01-01',NULL,0),
	(6436,89,'Malito',0,'1800-01-01',NULL,0),
	(6437,89,'Malvito',0,'1800-01-01',NULL,0),
	(6438,89,'Mandatoriccio',0,'1800-01-01',NULL,0),
	(6439,89,'Mangone',0,'1800-01-01',NULL,0),
	(6440,89,'Marano Marchesato',0,'1800-01-01',NULL,0),
	(6441,89,'Marano Principato',0,'1800-01-01',NULL,0),
	(6442,89,'Marzi',0,'1800-01-01',NULL,0),
	(6443,89,'Mendicino',0,'1800-01-01',NULL,0),
	(6444,89,'Mongrassano',0,'1800-01-01',NULL,0),
	(6445,89,'Montalto Uffugo',0,'1800-01-01',NULL,0),
	(6446,89,'Montegiordano',0,'1800-01-01',NULL,0),
	(6447,89,'Morano Calabro',0,'1800-01-01',NULL,0),
	(6448,89,'Mormanno',0,'1800-01-01',NULL,0),
	(6449,89,'Mottafollone',0,'1800-01-01',NULL,0),
	(6450,89,'Nocara',0,'1800-01-01',NULL,0),
	(6451,89,'Oriolo',0,'1800-01-01',NULL,0),
	(6452,89,'Orsomarso',0,'1800-01-01',NULL,0),
	(6453,89,'Paludi',0,'1800-01-01',NULL,0),
	(6454,89,'Panettieri',0,'1800-01-01',NULL,0),
	(6455,89,'Paola',0,'1800-01-01',NULL,0),
	(6456,89,'Papasidero',0,'1800-01-01',NULL,0),
	(6457,89,'Parenti',0,'1800-01-01',NULL,0),
	(6458,89,'Paterno Calabro',0,'1800-01-01',NULL,0),
	(6459,89,'Pedace',0,'1800-01-01',NULL,0),
	(6460,89,'Pedivigliano',0,'1800-01-01',NULL,0),
	(6461,89,'Piane Crati',0,'1800-01-01',NULL,0),
	(6462,89,'Pietrafitta',0,'1800-01-01',NULL,0),
	(6463,89,'Pietrapaola',0,'1800-01-01',NULL,0),
	(6464,89,'Plataci',0,'1800-01-01',NULL,0),
	(6465,89,'Praia a Mare',0,'1800-01-01',NULL,0),
	(6466,89,'Rende',0,'1800-01-01',NULL,0),
	(6467,89,'Rocca Imperiale',0,'1800-01-01',NULL,0),
	(6468,89,'Roggiano Gravina',0,'1800-01-01',NULL,0),
	(6469,89,'Rogliano',0,'1800-01-01',NULL,0),
	(6470,89,'Rose',0,'1800-01-01',NULL,0),
	(6471,89,'Roseto Capo Spulico',0,'1800-01-01',NULL,0),
	(6472,89,'Rossano',0,'1800-01-01',NULL,0),
	(6473,89,'Rota Greca',0,'1800-01-01',NULL,0),
	(6474,89,'Rovito',0,'1800-01-01',NULL,0),
	(6475,89,'San Basile',0,'1800-01-01',NULL,0),
	(6476,89,'San Benedetto Ullano',0,'1800-01-01',NULL,0),
	(6477,89,'San Cosmo Albanese',0,'1800-01-01',NULL,0),
	(6478,89,'San Demetrio Corone',0,'1800-01-01',NULL,0),
	(6479,89,'San Donato di Ninea',0,'1800-01-01',NULL,0),
	(6480,89,'San Fili',0,'1800-01-01',NULL,0),
	(6481,89,'Sangineto',0,'1800-01-01',NULL,0),
	(6482,89,'San Giorgio Albanese',0,'1800-01-01',NULL,0),
	(6483,89,'San Giovanni in Fiore',0,'1800-01-01',NULL,0),
	(6484,89,'San Lorenzo Bellizzi',0,'1800-01-01',NULL,0),
	(6485,89,'San Lorenzo del Vallo',0,'1800-01-01',NULL,0),
	(6486,89,'San Lucido',0,'1800-01-01',NULL,0),
	(6487,89,'San Marco Argentano',0,'1800-01-01',NULL,0),
	(6488,89,'San Martino di Finita',0,'1800-01-01',NULL,0),
	(6489,89,'San Nicola Arcella',0,'1800-01-01',NULL,0),
	(6490,89,'San Pietro in Amantea',0,'1800-01-01',NULL,0),
	(6491,89,'San Pietro in Guarano',0,'1800-01-01',NULL,0),
	(6492,89,'San Sosti',0,'1800-01-01',NULL,0),
	(6493,89,'Santa Caterina Albanese',0,'1800-01-01',NULL,0),
	(6494,89,'Santa Domenica Talao',0,'1800-01-01',NULL,0),
	(6495,89,'Sant\'Agata di Esaro',0,'1800-01-01',NULL,0),
	(6496,89,'Santa Maria del Cedro',0,'1800-01-01',NULL,0),
	(6497,89,'Santa Sofia d\'Epiro',0,'1800-01-01',NULL,0),
	(6498,89,'Santo Stefano di Rogliano',0,'1800-01-01',NULL,0),
	(6499,89,'San Vincenzo La Costa',0,'1800-01-01',NULL,0),
	(6500,89,'Saracena',0,'1800-01-01',NULL,0),
	(6501,89,'Scala Coeli',0,'1800-01-01',NULL,0),
	(6502,89,'Scalea',0,'1800-01-01',NULL,0),
	(6503,89,'Scigliano',0,'1800-01-01',NULL,0),
	(6504,89,'Serra d\'Aiello',0,'1800-01-01',NULL,0),
	(6505,89,'Serra Pedace',0,'1800-01-01',NULL,0),
	(6506,89,'Spezzano Albanese',0,'1800-01-01',NULL,0),
	(6507,89,'Spezzano della Sila',0,'1800-01-01',NULL,0),
	(6508,89,'Spezzano Piccolo',0,'1800-01-01',NULL,0),
	(6509,89,'Tarsia',0,'1800-01-01',NULL,0),
	(6510,89,'Terranova da Sibari',0,'1800-01-01',NULL,0),
	(6511,89,'Terravecchia',0,'1800-01-01',NULL,0),
	(6512,89,'Torano Castello',0,'1800-01-01',NULL,0),
	(6513,89,'Tortora',0,'1800-01-01',NULL,0),
	(6514,89,'Trebisacce',0,'1800-01-01',NULL,0),
	(6515,89,'Trenta',0,'1800-01-01',NULL,0),
	(6516,89,'Vaccarizzo Albanese',0,'1800-01-01',NULL,0),
	(6517,89,'Verbicaro',0,'1800-01-01',NULL,0),
	(6518,89,'Villapiana',0,'1800-01-01',NULL,0),
	(6519,89,'Zumpano',0,'1800-01-01',NULL,0),
	(6520,90,'Albi',0,'1800-01-01',NULL,0),
	(6521,90,'Amaroni',0,'1800-01-01',NULL,0),
	(6522,90,'Amato',0,'1800-01-01',NULL,0),
	(6523,90,'Andali',0,'1800-01-01',NULL,0),
	(6524,90,'Argusto',0,'1800-01-01',NULL,0),
	(6525,90,'Badolato',0,'1800-01-01',NULL,0),
	(6526,90,'Belcastro',0,'1800-01-01',NULL,0),
	(6527,90,'Borgia',0,'1800-01-01',NULL,0),
	(6528,90,'Botricello',0,'1800-01-01',NULL,0),
	(6529,90,'Caraffa di Catanzaro',0,'1800-01-01',NULL,0),
	(6530,90,'Cardinale',0,'1800-01-01',NULL,0),
	(6531,90,'Carlopoli',0,'1800-01-01',NULL,0),
	(6532,90,'Catanzaro',1,'1800-01-01',NULL,0),
	(6533,90,'Cenadi',0,'1800-01-01',NULL,0),
	(6534,90,'Centrache',0,'1800-01-01',NULL,0),
	(6535,90,'Cerva',0,'1800-01-01',NULL,0),
	(6536,90,'Chiaravalle Centrale',0,'1800-01-01',NULL,0),
	(6537,90,'Cicala',0,'1800-01-01',NULL,0),
	(6538,90,'Conflenti',0,'1800-01-01',NULL,0),
	(6539,90,'Cortale',0,'1800-01-01',NULL,0),
	(6540,90,'Cropani',0,'1800-01-01',NULL,0),
	(6541,90,'Curinga',0,'1800-01-01',NULL,0),
	(6542,90,'Davoli',0,'1800-01-01',NULL,0),
	(6543,90,'Decollatura',0,'1800-01-01',NULL,0),
	(6544,90,'Falerna',0,'1800-01-01',NULL,0),
	(6545,90,'Feroleto Antico',0,'1800-01-01',NULL,0),
	(6546,90,'Fossato Serralta',0,'1800-01-01',NULL,0),
	(6547,90,'Gagliato',0,'1800-01-01',NULL,0),
	(6548,90,'Gasperina',0,'1800-01-01',NULL,0),
	(6549,90,'Gimigliano',0,'1800-01-01',NULL,0),
	(6550,90,'Girifalco',0,'1800-01-01',NULL,0),
	(6551,90,'Gizzeria',0,'1800-01-01',NULL,0),
	(6552,90,'Guardavalle',0,'1800-01-01',NULL,0),
	(6553,90,'Isca sullo Ionio',0,'1800-01-01',NULL,0),
	(6554,90,'Jacurso',0,'1800-01-01',NULL,0),
	(6555,90,'Magisano',0,'1800-01-01',NULL,0),
	(6556,90,'Maida',0,'1800-01-01',NULL,0),
	(6557,90,'Marcedusa',0,'1800-01-01',NULL,0),
	(6558,90,'Marcellinara',0,'1800-01-01',NULL,0),
	(6559,90,'Martirano',0,'1800-01-01',NULL,0),
	(6560,90,'Martirano Lombardo',0,'1800-01-01',NULL,0),
	(6561,90,'Miglierina',0,'1800-01-01',NULL,0),
	(6562,90,'Montauro',0,'1800-01-01',NULL,0),
	(6563,90,'Montepaone',0,'1800-01-01',NULL,0),
	(6564,90,'Motta Santa Lucia',0,'1800-01-01',NULL,0),
	(6565,90,'Nocera Terinese',0,'1800-01-01',NULL,0),
	(6566,90,'Olivadi',0,'1800-01-01',NULL,0),
	(6567,90,'Palermiti',0,'1800-01-01',NULL,0),
	(6568,90,'Pentone',0,'1800-01-01',NULL,0),
	(6569,90,'Petrizzi',0,'1800-01-01',NULL,0),
	(6570,90,'Petronà',0,'1800-01-01',NULL,0),
	(6571,90,'Pianopoli',0,'1800-01-01',NULL,0),
	(6572,90,'Platania',0,'1800-01-01',NULL,0),
	(6573,90,'San Floro',0,'1800-01-01',NULL,0),
	(6574,90,'San Mango d\'Aquino',0,'1800-01-01',NULL,0),
	(6575,90,'San Pietro a Maida',0,'1800-01-01',NULL,0),
	(6576,90,'San Pietro Apostolo',0,'1800-01-01',NULL,0),
	(6577,90,'San Sostene',0,'1800-01-01',NULL,0),
	(6578,90,'Santa Caterina dello Ionio',0,'1800-01-01',NULL,0),
	(6579,90,'Sant\'Andrea Apostolo dello Ionio',0,'1800-01-01',NULL,0),
	(6580,90,'San Vito sullo Ionio',0,'1800-01-01',NULL,0),
	(6581,90,'Satriano',0,'1800-01-01',NULL,0),
	(6582,90,'Sellia',0,'1800-01-01',NULL,0),
	(6583,90,'Sellia Marina',0,'1800-01-01',NULL,0),
	(6584,90,'Serrastretta',0,'1800-01-01',NULL,0),
	(6585,90,'Sersale',0,'1800-01-01',NULL,0),
	(6586,90,'Settingiano',0,'1800-01-01',NULL,0),
	(6587,90,'Simeri Crichi',0,'1800-01-01',NULL,0),
	(6588,90,'Sorbo San Basile',0,'1800-01-01',NULL,0),
	(6589,90,'Soverato',0,'1800-01-01',NULL,0),
	(6590,90,'Soveria Mannelli',0,'1800-01-01',NULL,0),
	(6591,90,'Soveria Simeri',0,'1800-01-01',NULL,0),
	(6592,90,'Squillace',0,'1800-01-01',NULL,0),
	(6593,90,'Stalettì',0,'1800-01-01',NULL,0),
	(6594,90,'Taverna',0,'1800-01-01',NULL,0),
	(6595,90,'Tiriolo',0,'1800-01-01',NULL,0),
	(6596,90,'Torre di Ruggiero',0,'1800-01-01',NULL,0),
	(6597,90,'Vallefiorita',0,'1800-01-01',NULL,0),
	(6598,90,'Zagarise',0,'1800-01-01',NULL,0),
	(6599,90,'Lamezia Terme',0,'1800-01-01',NULL,0),
	(6600,91,'Africo',0,'1800-01-01',NULL,0),
	(6601,91,'Agnana Calabra',0,'1800-01-01',NULL,0),
	(6602,91,'Anoia',0,'1800-01-01',NULL,0),
	(6603,91,'Antonimina',0,'1800-01-01',NULL,0),
	(6604,91,'Ardore',0,'1800-01-01',NULL,0),
	(6605,91,'Bagaladi',0,'1800-01-01',NULL,0),
	(6606,91,'Bagnara Calabra',0,'1800-01-01',NULL,0),
	(6607,91,'Benestare',0,'1800-01-01',NULL,0),
	(6608,91,'Bianco',0,'1800-01-01',NULL,0),
	(6609,91,'Bivongi',0,'1800-01-01',NULL,0),
	(6610,91,'Bova',0,'1800-01-01',NULL,0),
	(6611,91,'Bovalino',0,'1800-01-01',NULL,0),
	(6612,91,'Bova Marina',0,'1800-01-01',NULL,0),
	(6613,91,'Brancaleone',0,'1800-01-01',NULL,0),
	(6614,91,'Bruzzano Zeffirio',0,'1800-01-01',NULL,0),
	(6615,91,'Calanna',0,'1800-01-01',NULL,0),
	(6616,91,'Camini',0,'1800-01-01',NULL,0),
	(6617,91,'Campo Calabro',0,'1800-01-01',NULL,0),
	(6618,91,'Candidoni',0,'1800-01-01',NULL,0),
	(6619,91,'Canolo',0,'1800-01-01',NULL,0),
	(6620,91,'Caraffa del Bianco',0,'1800-01-01',NULL,0),
	(6621,91,'Cardeto',0,'1800-01-01',NULL,0),
	(6622,91,'Careri',0,'1800-01-01',NULL,0),
	(6623,91,'Casignana',0,'1800-01-01',NULL,0),
	(6624,91,'Caulonia',0,'1800-01-01',NULL,0),
	(6625,91,'Ciminà',0,'1800-01-01',NULL,0),
	(6626,91,'Cinquefrondi',0,'1800-01-01',NULL,0),
	(6627,91,'Cittanova',0,'1800-01-01',NULL,0),
	(6628,91,'Condofuri',0,'1800-01-01',NULL,0),
	(6629,91,'Cosoleto',0,'1800-01-01',NULL,0),
	(6630,91,'Delianuova',0,'1800-01-01',NULL,0),
	(6631,91,'Feroleto della Chiesa',0,'1800-01-01',NULL,0),
	(6632,91,'Ferruzzano',0,'1800-01-01',NULL,0),
	(6633,91,'Fiumara',0,'1800-01-01',NULL,0),
	(6634,91,'Galatro',0,'1800-01-01',NULL,0),
	(6635,91,'Gerace',0,'1800-01-01',NULL,0),
	(6636,91,'Giffone',0,'1800-01-01',NULL,0),
	(6637,91,'Gioia Tauro',0,'1800-01-01',NULL,0),
	(6638,91,'Gioiosa Ionica',0,'1800-01-01',NULL,0),
	(6639,91,'Grotteria',0,'1800-01-01',NULL,0),
	(6640,91,'Laganadi',0,'1800-01-01',NULL,0),
	(6641,91,'Laureana di Borrello',0,'1800-01-01',NULL,0),
	(6642,91,'Locri',0,'1800-01-01',NULL,0),
	(6643,91,'Mammola',0,'1800-01-01',NULL,0),
	(6644,91,'Marina di Gioiosa Ionica',0,'1800-01-01',NULL,0),
	(6645,91,'Maropati',0,'1800-01-01',NULL,0),
	(6646,91,'Martone',0,'1800-01-01',NULL,0),
	(6647,91,'Melicuccà',0,'1800-01-01',NULL,0),
	(6648,91,'Melicucco',0,'1800-01-01',NULL,0),
	(6649,91,'Melito di Porto Salvo',0,'1800-01-01',NULL,0),
	(6650,91,'Molochio',0,'1800-01-01',NULL,0),
	(6651,91,'Monasterace',0,'1800-01-01',NULL,0),
	(6652,91,'Montebello Ionico',0,'1800-01-01',NULL,0),
	(6653,91,'Motta San Giovanni',0,'1800-01-01',NULL,0),
	(6654,91,'Oppido Mamertina',0,'1800-01-01',NULL,0),
	(6655,91,'Palizzi',0,'1800-01-01',NULL,0),
	(6656,91,'Palmi',0,'1800-01-01',NULL,0),
	(6657,91,'Pazzano',0,'1800-01-01',NULL,0),
	(6658,91,'Placanica',0,'1800-01-01',NULL,0),
	(6659,91,'Platì',0,'1800-01-01',NULL,0),
	(6660,91,'Polistena',0,'1800-01-01',NULL,0),
	(6661,91,'Portigliola',0,'1800-01-01',NULL,0),
	(6662,91,'Reggio di Calabria',1,'1800-01-01',NULL,0),
	(6663,91,'Riace',0,'1800-01-01',NULL,0),
	(6664,91,'Rizziconi',0,'1800-01-01',NULL,0),
	(6665,91,'Roccaforte del Greco',0,'1800-01-01',NULL,0),
	(6666,91,'Roccella Ionica',0,'1800-01-01',NULL,0),
	(6667,91,'Roghudi',0,'1800-01-01',NULL,0),
	(6668,91,'Rosarno',0,'1800-01-01',NULL,0),
	(6669,91,'Samo',0,'1800-01-01',NULL,0),
	(6670,91,'San Giorgio Morgeto',0,'1800-01-01',NULL,0),
	(6671,91,'San Giovanni di Gerace',0,'1800-01-01',NULL,0),
	(6672,91,'San Lorenzo',0,'1800-01-01',NULL,0),
	(6673,91,'San Luca',0,'1800-01-01',NULL,0),
	(6674,91,'San Pietro di Caridà',0,'1800-01-01',NULL,0),
	(6675,91,'San Procopio',0,'1800-01-01',NULL,0),
	(6676,91,'San Roberto',0,'1800-01-01',NULL,0),
	(6677,91,'Santa Cristina d\'Aspromonte',0,'1800-01-01',NULL,0),
	(6678,91,'Sant\'Agata del Bianco',0,'1800-01-01',NULL,0),
	(6679,91,'Sant\'Alessio in Aspromonte',0,'1800-01-01',NULL,0),
	(6680,91,'Sant\'Eufemia d\'Aspromonte',0,'1800-01-01',NULL,0),
	(6681,91,'Sant\'Ilario dello Ionio',0,'1800-01-01',NULL,0),
	(6682,91,'Santo Stefano in Aspromonte',0,'1800-01-01',NULL,0),
	(6683,91,'Scido',0,'1800-01-01',NULL,0),
	(6684,91,'Scilla',0,'1800-01-01',NULL,0),
	(6685,91,'Seminara',0,'1800-01-01',NULL,0),
	(6686,91,'Serrata',0,'1800-01-01',NULL,0),
	(6687,91,'Siderno',0,'1800-01-01',NULL,0),
	(6688,91,'Sinopoli',0,'1800-01-01',NULL,0),
	(6689,91,'Staiti',0,'1800-01-01',NULL,0),
	(6690,91,'Stignano',0,'1800-01-01',NULL,0),
	(6691,91,'Stilo',0,'1800-01-01',NULL,0),
	(6692,91,'Taurianova',0,'1800-01-01',NULL,0),
	(6693,91,'Terranova Sappo Minulio',0,'1800-01-01',NULL,0),
	(6694,91,'Varapodio',0,'1800-01-01',NULL,0),
	(6695,91,'Villa San Giovanni',0,'1800-01-01',NULL,0),
	(6696,91,'San Ferdinando',0,'1800-01-01',NULL,0),
	(6697,94,'Alcamo',0,'1800-01-01',NULL,0),
	(6698,94,'Buseto Palizzolo',0,'1800-01-01',NULL,0),
	(6699,94,'Calatafimi-Segesta',0,'1800-01-01',NULL,0),
	(6700,94,'Campobello di Mazara',0,'1800-01-01',NULL,0),
	(6701,94,'Castellammare del Golfo',0,'1800-01-01',NULL,0),
	(6702,94,'Castelvetrano',0,'1800-01-01',NULL,0),
	(6703,94,'Custonaci',0,'1800-01-01',NULL,0),
	(6704,94,'Erice',0,'1800-01-01',NULL,0),
	(6705,94,'Favignana',0,'1800-01-01',NULL,0),
	(6706,94,'Gibellina',0,'1800-01-01',NULL,0),
	(6707,94,'Marsala',0,'1800-01-01',NULL,0),
	(6708,94,'Mazara del Vallo',0,'1800-01-01',NULL,0),
	(6709,94,'Paceco',0,'1800-01-01',NULL,0),
	(6710,94,'Pantelleria',0,'1800-01-01',NULL,0),
	(6711,94,'Partanna',0,'1800-01-01',NULL,0),
	(6712,94,'Poggioreale',0,'1800-01-01',NULL,0),
	(6713,94,'Salaparuta',0,'1800-01-01',NULL,0),
	(6714,94,'Salemi',0,'1800-01-01',NULL,0),
	(6715,94,'Santa Ninfa',0,'1800-01-01',NULL,0),
	(6716,94,'San Vito Lo Capo',0,'1800-01-01',NULL,0),
	(6717,94,'Trapani',1,'1800-01-01',NULL,0),
	(6718,94,'Valderice',0,'1800-01-01',NULL,0),
	(6719,94,'Vita',0,'1800-01-01',NULL,0),
	(6720,94,'Petrosino',0,'1800-01-01',NULL,0),
	(6721,95,'Alia',0,'1800-01-01',NULL,0),
	(6722,95,'Alimena',0,'1800-01-01',NULL,0),
	(6723,95,'Aliminusa',0,'1800-01-01',NULL,0),
	(6724,95,'Altavilla Milicia',0,'1800-01-01',NULL,0),
	(6725,95,'Altofonte',0,'1800-01-01',NULL,0),
	(6726,95,'Bagheria',0,'1800-01-01',NULL,0),
	(6727,95,'Balestrate',0,'1800-01-01',NULL,0),
	(6728,95,'Baucina',0,'1800-01-01',NULL,0),
	(6729,95,'Belmonte Mezzagno',0,'1800-01-01',NULL,0),
	(6730,95,'Bisacquino',0,'1800-01-01',NULL,0),
	(6731,95,'Bolognetta',0,'1800-01-01',NULL,0),
	(6732,95,'Bompietro',0,'1800-01-01',NULL,0),
	(6733,95,'Borgetto',0,'1800-01-01',NULL,0),
	(6734,95,'Caccamo',0,'1800-01-01',NULL,0),
	(6735,95,'Caltavuturo',0,'1800-01-01',NULL,0),
	(6736,95,'Campofelice di Fitalia',0,'1800-01-01',NULL,0),
	(6737,95,'Campofelice di Roccella',0,'1800-01-01',NULL,0),
	(6738,95,'Campofiorito',0,'1800-01-01',NULL,0),
	(6739,95,'Camporeale',0,'1800-01-01',NULL,0),
	(6740,95,'Capaci',0,'1800-01-01',NULL,0),
	(6741,95,'Carini',0,'1800-01-01',NULL,0),
	(6742,95,'Castelbuono',0,'1800-01-01',NULL,0),
	(6743,95,'Casteldaccia',0,'1800-01-01',NULL,0),
	(6744,95,'Castellana Sicula',0,'1800-01-01',NULL,0),
	(6745,95,'Castronovo di Sicilia',0,'1800-01-01',NULL,0),
	(6746,95,'Cefalà Diana',0,'1800-01-01',NULL,0),
	(6747,95,'Cefalù',0,'1800-01-01',NULL,0),
	(6748,95,'Cerda',0,'1800-01-01',NULL,0),
	(6749,95,'Chiusa Sclafani',0,'1800-01-01',NULL,0),
	(6750,95,'Ciminna',0,'1800-01-01',NULL,0),
	(6751,95,'Cinisi',0,'1800-01-01',NULL,0),
	(6752,95,'Collesano',0,'1800-01-01',NULL,0),
	(6753,95,'Contessa Entellina',0,'1800-01-01',NULL,0),
	(6754,95,'Corleone',0,'1800-01-01',NULL,0),
	(6755,95,'Ficarazzi',0,'1800-01-01',NULL,0),
	(6756,95,'Gangi',0,'1800-01-01',NULL,0),
	(6757,95,'Geraci Siculo',0,'1800-01-01',NULL,0),
	(6758,95,'Giardinello',0,'1800-01-01',NULL,0),
	(6759,95,'Giuliana',0,'1800-01-01',NULL,0),
	(6760,95,'Godrano',0,'1800-01-01',NULL,0),
	(6761,95,'Gratteri',0,'1800-01-01',NULL,0),
	(6762,95,'Isnello',0,'1800-01-01',NULL,0),
	(6763,95,'Isola delle Femmine',0,'1800-01-01',NULL,0),
	(6764,95,'Lascari',0,'1800-01-01',NULL,0),
	(6765,95,'Lercara Friddi',0,'1800-01-01',NULL,0),
	(6766,95,'Marineo',0,'1800-01-01',NULL,0),
	(6767,95,'Mezzojuso',0,'1800-01-01',NULL,0),
	(6768,95,'Misilmeri',0,'1800-01-01',NULL,0),
	(6769,95,'Monreale',0,'1800-01-01',NULL,0),
	(6770,95,'Montelepre',0,'1800-01-01',NULL,0),
	(6771,95,'Montemaggiore Belsito',0,'1800-01-01',NULL,0),
	(6772,95,'Palazzo Adriano',0,'1800-01-01',NULL,0),
	(6773,95,'Palermo',1,'1800-01-01',NULL,0),
	(6774,95,'Partinico',0,'1800-01-01',NULL,0),
	(6775,95,'Petralia Soprana',0,'1800-01-01',NULL,0),
	(6776,95,'Petralia Sottana',0,'1800-01-01',NULL,0),
	(6777,95,'Piana degli Albanesi',0,'1800-01-01',NULL,0),
	(6778,95,'Polizzi Generosa',0,'1800-01-01',NULL,0),
	(6779,95,'Pollina',0,'1800-01-01',NULL,0),
	(6780,95,'Prizzi',0,'1800-01-01',NULL,0),
	(6781,95,'Roccamena',0,'1800-01-01',NULL,0),
	(6782,95,'Roccapalumba',0,'1800-01-01',NULL,0),
	(6783,95,'San Cipirello',0,'1800-01-01',NULL,0),
	(6784,95,'San Giuseppe Jato',0,'1800-01-01',NULL,0),
	(6785,95,'San Mauro Castelverde',0,'1800-01-01',NULL,0),
	(6786,95,'Santa Cristina Gela',0,'1800-01-01',NULL,0),
	(6787,95,'Santa Flavia',0,'1800-01-01',NULL,0),
	(6788,95,'Sciara',0,'1800-01-01',NULL,0),
	(6789,95,'Sclafani Bagni',0,'1800-01-01',NULL,0),
	(6790,95,'Termini Imerese',0,'1800-01-01',NULL,0),
	(6791,95,'Terrasini',0,'1800-01-01',NULL,0),
	(6792,95,'Torretta',0,'1800-01-01',NULL,0),
	(6793,95,'Trabia',0,'1800-01-01',NULL,0),
	(6794,95,'Trappeto',0,'1800-01-01',NULL,0),
	(6795,95,'Ustica',0,'1800-01-01',NULL,0),
	(6796,95,'Valledolmo',0,'1800-01-01',NULL,0),
	(6797,95,'Ventimiglia di Sicilia',0,'1800-01-01',NULL,0),
	(6798,95,'Vicari',0,'1800-01-01',NULL,0),
	(6799,95,'Villabate',0,'1800-01-01',NULL,0),
	(6800,95,'Villafrati',0,'1800-01-01',NULL,0),
	(6801,95,'Scillato',0,'1800-01-01',NULL,0),
	(6802,95,'Blufi',0,'1800-01-01',NULL,0),
	(6803,96,'Alcara li Fusi',0,'1800-01-01',NULL,0),
	(6804,96,'Alì',0,'1800-01-01',NULL,0),
	(6805,96,'Alì Terme',0,'1800-01-01',NULL,0),
	(6806,96,'Antillo',0,'1800-01-01',NULL,0),
	(6807,96,'Barcellona Pozzo di Gotto',0,'1800-01-01',NULL,0),
	(6808,96,'Basicò',0,'1800-01-01',NULL,0),
	(6809,96,'Brolo',0,'1800-01-01',NULL,0),
	(6810,96,'Capizzi',0,'1800-01-01',NULL,0),
	(6811,96,'Capo d\'Orlando',0,'1800-01-01',NULL,0),
	(6812,96,'Capri Leone',0,'1800-01-01',NULL,0),
	(6813,96,'Caronia',0,'1800-01-01',NULL,0),
	(6814,96,'Casalvecchio Siculo',0,'1800-01-01',NULL,0),
	(6815,96,'Castel di Lucio',0,'1800-01-01',NULL,0),
	(6816,96,'Castell\'Umberto',0,'1800-01-01',NULL,0),
	(6817,96,'Castelmola',0,'1800-01-01',NULL,0),
	(6818,96,'Castroreale',0,'1800-01-01',NULL,0),
	(6819,96,'Cesarò',0,'1800-01-01',NULL,0),
	(6820,96,'Condrò',0,'1800-01-01',NULL,0),
	(6821,96,'Falcone',0,'1800-01-01',NULL,0),
	(6822,96,'Ficarra',0,'1800-01-01',NULL,0),
	(6823,96,'Fiumedinisi',0,'1800-01-01',NULL,0),
	(6824,96,'Floresta',0,'1800-01-01',NULL,0),
	(6825,96,'Fondachelli-Fantina',0,'1800-01-01',NULL,0),
	(6826,96,'Forza d\'Agrò',0,'1800-01-01',NULL,0),
	(6827,96,'Francavilla di Sicilia',0,'1800-01-01',NULL,0),
	(6828,96,'Frazzanò',0,'1800-01-01',NULL,0),
	(6829,96,'Furci Siculo',0,'1800-01-01',NULL,0),
	(6830,96,'Furnari',0,'1800-01-01',NULL,0),
	(6831,96,'Gaggi',0,'1800-01-01',NULL,0),
	(6832,96,'Galati Mamertino',0,'1800-01-01',NULL,0),
	(6833,96,'Gallodoro',0,'1800-01-01',NULL,0),
	(6834,96,'Giardini-Naxos',0,'1800-01-01',NULL,0),
	(6835,96,'Gioiosa Marea',0,'1800-01-01',NULL,0),
	(6836,96,'Graniti',0,'1800-01-01',NULL,0),
	(6837,96,'Gualtieri Sicaminò',0,'1800-01-01',NULL,0),
	(6838,96,'Itala',0,'1800-01-01',NULL,0),
	(6839,96,'Leni',0,'1800-01-01',NULL,0),
	(6840,96,'Letojanni',0,'1800-01-01',NULL,0),
	(6841,96,'Librizzi',0,'1800-01-01',NULL,0),
	(6842,96,'Limina',0,'1800-01-01',NULL,0),
	(6843,96,'Lipari',0,'1800-01-01',NULL,0),
	(6844,96,'Longi',0,'1800-01-01',NULL,0),
	(6845,96,'Malfa',0,'1800-01-01',NULL,0),
	(6846,96,'Malvagna',0,'1800-01-01',NULL,0),
	(6847,96,'Mandanici',0,'1800-01-01',NULL,0),
	(6848,96,'Mazzarrà Sant\'Andrea',0,'1800-01-01',NULL,0),
	(6849,96,'Merì',0,'1800-01-01',NULL,0),
	(6850,96,'Messina',1,'1800-01-01',NULL,0),
	(6851,96,'Milazzo',0,'1800-01-01',NULL,0),
	(6852,96,'Militello Rosmarino',0,'1800-01-01',NULL,0),
	(6853,96,'Mirto',0,'1800-01-01',NULL,0),
	(6854,96,'Mistretta',0,'1800-01-01',NULL,0),
	(6855,96,'Moio Alcantara',0,'1800-01-01',NULL,0),
	(6856,96,'Monforte San Giorgio',0,'1800-01-01',NULL,0),
	(6857,96,'Mongiuffi Melia',0,'1800-01-01',NULL,0),
	(6858,96,'Montagnareale',0,'1800-01-01',NULL,0),
	(6859,96,'Montalbano Elicona',0,'1800-01-01',NULL,0),
	(6860,96,'Motta Camastra',0,'1800-01-01',NULL,0),
	(6861,96,'Motta d\'Affermo',0,'1800-01-01',NULL,0),
	(6862,96,'Naso',0,'1800-01-01',NULL,0),
	(6863,96,'Nizza di Sicilia',0,'1800-01-01',NULL,0),
	(6864,96,'Novara di Sicilia',0,'1800-01-01',NULL,0),
	(6865,96,'Oliveri',0,'1800-01-01',NULL,0),
	(6866,96,'Pace del Mela',0,'1800-01-01',NULL,0),
	(6867,96,'Pagliara',0,'1800-01-01',NULL,0),
	(6868,96,'Patti',0,'1800-01-01',NULL,0),
	(6869,96,'Pettineo',0,'1800-01-01',NULL,0),
	(6870,96,'Piraino',0,'1800-01-01',NULL,0),
	(6871,96,'Raccuja',0,'1800-01-01',NULL,0),
	(6872,96,'Reitano',0,'1800-01-01',NULL,0),
	(6873,96,'Roccafiorita',0,'1800-01-01',NULL,0),
	(6874,96,'Roccalumera',0,'1800-01-01',NULL,0),
	(6875,96,'Roccavaldina',0,'1800-01-01',NULL,0),
	(6876,96,'Roccella Valdemone',0,'1800-01-01',NULL,0),
	(6877,96,'Rodì Milici',0,'1800-01-01',NULL,0),
	(6878,96,'Rometta',0,'1800-01-01',NULL,0),
	(6879,96,'San Filippo del Mela',0,'1800-01-01',NULL,0),
	(6880,96,'San Fratello',0,'1800-01-01',NULL,0),
	(6881,96,'San Marco d\'Alunzio',0,'1800-01-01',NULL,0),
	(6882,96,'San Pier Niceto',0,'1800-01-01',NULL,0),
	(6883,96,'San Piero Patti',0,'1800-01-01',NULL,0),
	(6884,96,'San Salvatore di Fitalia',0,'1800-01-01',NULL,0),
	(6885,96,'Santa Domenica Vittoria',0,'1800-01-01',NULL,0),
	(6886,96,'Sant\'Agata di Militello',0,'1800-01-01',NULL,0),
	(6887,96,'Sant\'Alessio Siculo',0,'1800-01-01',NULL,0),
	(6888,96,'Santa Lucia del Mela',0,'1800-01-01',NULL,0),
	(6889,96,'Santa Marina Salina',0,'1800-01-01',NULL,0),
	(6890,96,'Sant\'Angelo di Brolo',0,'1800-01-01',NULL,0),
	(6891,96,'Santa Teresa di Riva',0,'1800-01-01',NULL,0),
	(6892,96,'San Teodoro',0,'1800-01-01',NULL,0),
	(6893,96,'Santo Stefano di Camastra',0,'1800-01-01',NULL,0),
	(6894,96,'Saponara',0,'1800-01-01',NULL,0),
	(6895,96,'Savoca',0,'1800-01-01',NULL,0),
	(6896,96,'Scaletta Zanclea',0,'1800-01-01',NULL,0),
	(6897,96,'Sinagra',0,'1800-01-01',NULL,0),
	(6898,96,'Spadafora',0,'1800-01-01',NULL,0),
	(6899,96,'Taormina',0,'1800-01-01',NULL,0),
	(6900,96,'Torregrotta',0,'1800-01-01',NULL,0),
	(6901,96,'Tortorici',0,'1800-01-01',NULL,0),
	(6902,96,'Tripi',0,'1800-01-01',NULL,0),
	(6903,96,'Tusa',0,'1800-01-01',NULL,0),
	(6904,96,'Ucria',0,'1800-01-01',NULL,0),
	(6905,96,'Valdina',0,'1800-01-01',NULL,0),
	(6906,96,'Venetico',0,'1800-01-01',NULL,0),
	(6907,96,'Villafranca Tirrena',0,'1800-01-01',NULL,0),
	(6908,96,'Terme Vigliatore',0,'1800-01-01',NULL,0),
	(6909,96,'Acquedolci',0,'1800-01-01',NULL,0),
	(6910,96,'Torrenova',0,'1800-01-01',NULL,0),
	(6911,97,'Agrigento',1,'1800-01-01',NULL,0),
	(6912,97,'Alessandria della Rocca',0,'1800-01-01',NULL,0),
	(6913,97,'Aragona',0,'1800-01-01',NULL,0),
	(6914,97,'Bivona',0,'1800-01-01',NULL,0),
	(6915,97,'Burgio',0,'1800-01-01',NULL,0),
	(6916,97,'Calamonaci',0,'1800-01-01',NULL,0),
	(6917,97,'Caltabellotta',0,'1800-01-01',NULL,0),
	(6918,97,'Camastra',0,'1800-01-01',NULL,0),
	(6919,97,'Cammarata',0,'1800-01-01',NULL,0),
	(6920,97,'Campobello di Licata',0,'1800-01-01',NULL,0),
	(6921,97,'Canicattì',0,'1800-01-01',NULL,0),
	(6922,97,'Casteltermini',0,'1800-01-01',NULL,0),
	(6923,97,'Castrofilippo',0,'1800-01-01',NULL,0),
	(6924,97,'Cattolica Eraclea',0,'1800-01-01',NULL,0),
	(6925,97,'Cianciana',0,'1800-01-01',NULL,0),
	(6926,97,'Comitini',0,'1800-01-01',NULL,0),
	(6927,97,'Favara',0,'1800-01-01',NULL,0),
	(6928,97,'Grotte',0,'1800-01-01',NULL,0),
	(6929,97,'Joppolo Giancaxio',0,'1800-01-01',NULL,0),
	(6930,97,'Lampedusa e Linosa',0,'1800-01-01',NULL,0),
	(6931,97,'Licata',0,'1800-01-01',NULL,0),
	(6932,97,'Lucca Sicula',0,'1800-01-01',NULL,0),
	(6933,97,'Menfi',0,'1800-01-01',NULL,0),
	(6934,97,'Montallegro',0,'1800-01-01',NULL,0),
	(6935,97,'Montevago',0,'1800-01-01',NULL,0),
	(6936,97,'Naro',0,'1800-01-01',NULL,0),
	(6937,97,'Palma di Montechiaro',0,'1800-01-01',NULL,0),
	(6938,97,'Porto Empedocle',0,'1800-01-01',NULL,0),
	(6939,97,'Racalmuto',0,'1800-01-01',NULL,0),
	(6940,97,'Raffadali',0,'1800-01-01',NULL,0),
	(6941,97,'Ravanusa',0,'1800-01-01',NULL,0),
	(6942,97,'Realmonte',0,'1800-01-01',NULL,0),
	(6943,97,'Ribera',0,'1800-01-01',NULL,0),
	(6944,97,'Sambuca di Sicilia',0,'1800-01-01',NULL,0),
	(6945,97,'San Biagio Platani',0,'1800-01-01',NULL,0),
	(6946,97,'San Giovanni Gemini',0,'1800-01-01',NULL,0),
	(6947,97,'Santa Elisabetta',0,'1800-01-01',NULL,0),
	(6948,97,'Santa Margherita di Belice',0,'1800-01-01',NULL,0),
	(6949,97,'Sant\'Angelo Muxaro',0,'1800-01-01',NULL,0),
	(6950,97,'Santo Stefano Quisquina',0,'1800-01-01',NULL,0),
	(6951,97,'Sciacca',0,'1800-01-01',NULL,0),
	(6952,97,'Siculiana',0,'1800-01-01',NULL,0),
	(6953,97,'Villafranca Sicula',0,'1800-01-01',NULL,0),
	(6954,98,'Acquaviva Platani',0,'1800-01-01',NULL,0),
	(6955,98,'Bompensiere',0,'1800-01-01',NULL,0),
	(6956,98,'Butera',0,'1800-01-01',NULL,0),
	(6957,98,'Caltanissetta',1,'1800-01-01',NULL,0),
	(6958,98,'Campofranco',0,'1800-01-01',NULL,0),
	(6959,98,'Delia',0,'1800-01-01',NULL,0),
	(6960,98,'Gela',0,'1800-01-01',NULL,0),
	(6961,98,'Marianopoli',0,'1800-01-01',NULL,0),
	(6962,98,'Mazzarino',0,'1800-01-01',NULL,0),
	(6963,98,'Milena',0,'1800-01-01',NULL,0),
	(6964,98,'Montedoro',0,'1800-01-01',NULL,0),
	(6965,98,'Mussomeli',0,'1800-01-01',NULL,0),
	(6966,98,'Niscemi',0,'1800-01-01',NULL,0),
	(6967,98,'Resuttano',0,'1800-01-01',NULL,0),
	(6968,98,'Riesi',0,'1800-01-01',NULL,0),
	(6969,98,'San Cataldo',0,'1800-01-01',NULL,0),
	(6970,98,'Santa Caterina Villarmosa',0,'1800-01-01',NULL,0),
	(6971,98,'Serradifalco',0,'1800-01-01',NULL,0),
	(6972,98,'Sommatino',0,'1800-01-01',NULL,0),
	(6973,98,'Sutera',0,'1800-01-01',NULL,0),
	(6974,98,'Vallelunga Pratameno',0,'1800-01-01',NULL,0),
	(6975,98,'Villalba',0,'1800-01-01',NULL,0),
	(6976,99,'Agira',0,'1800-01-01',NULL,0),
	(6977,99,'Aidone',0,'1800-01-01',NULL,0),
	(6978,99,'Assoro',0,'1800-01-01',NULL,0),
	(6979,99,'Barrafranca',0,'1800-01-01',NULL,0),
	(6980,99,'Calascibetta',0,'1800-01-01',NULL,0),
	(6981,99,'Catenanuova',0,'1800-01-01',NULL,0),
	(6982,99,'Centuripe',0,'1800-01-01',NULL,0),
	(6983,99,'Cerami',0,'1800-01-01',NULL,0),
	(6984,99,'Enna',1,'1800-01-01',NULL,0),
	(6985,99,'Gagliano Castelferrato',0,'1800-01-01',NULL,0),
	(6986,99,'Leonforte',0,'1800-01-01',NULL,0),
	(6987,99,'Nicosia',0,'1800-01-01',NULL,0),
	(6988,99,'Nissoria',0,'1800-01-01',NULL,0),
	(6989,99,'Piazza Armerina',0,'1800-01-01',NULL,0),
	(6990,99,'Pietraperzia',0,'1800-01-01',NULL,0),
	(6991,99,'Regalbuto',0,'1800-01-01',NULL,0),
	(6992,99,'Sperlinga',0,'1800-01-01',NULL,0),
	(6993,99,'Troina',0,'1800-01-01',NULL,0),
	(6994,99,'Valguarnera Caropepe',0,'1800-01-01',NULL,0),
	(6995,99,'Villarosa',0,'1800-01-01',NULL,0),
	(6996,100,'Aci Bonaccorsi',0,'1800-01-01',NULL,0),
	(6997,100,'Aci Castello',0,'1800-01-01',NULL,0),
	(6998,100,'Aci Catena',0,'1800-01-01',NULL,0),
	(6999,100,'Acireale',0,'1800-01-01',NULL,0),
	(7000,100,'Aci Sant\'Antonio',0,'1800-01-01',NULL,0),
	(7001,100,'Adrano',0,'1800-01-01',NULL,0),
	(7002,100,'Belpasso',0,'1800-01-01',NULL,0),
	(7003,100,'Biancavilla',0,'1800-01-01',NULL,0),
	(7004,100,'Bronte',0,'1800-01-01',NULL,0),
	(7005,100,'Calatabiano',0,'1800-01-01',NULL,0),
	(7006,100,'Caltagirone',0,'1800-01-01',NULL,0),
	(7007,100,'Camporotondo Etneo',0,'1800-01-01',NULL,0),
	(7008,100,'Castel di Iudica',0,'1800-01-01',NULL,0),
	(7009,100,'Castiglione di Sicilia',0,'1800-01-01',NULL,0),
	(7010,100,'Catania',1,'1800-01-01',NULL,0),
	(7011,100,'Fiumefreddo di Sicilia',0,'1800-01-01',NULL,0),
	(7012,100,'Giarre',0,'1800-01-01',NULL,0),
	(7013,100,'Grammichele',0,'1800-01-01',NULL,0),
	(7014,100,'Gravina di Catania',0,'1800-01-01',NULL,0),
	(7015,100,'Licodia Eubea',0,'1800-01-01',NULL,0),
	(7016,100,'Linguaglossa',0,'1800-01-01',NULL,0),
	(7017,100,'Maletto',0,'1800-01-01',NULL,0),
	(7018,100,'Mascali',0,'1800-01-01',NULL,0),
	(7019,100,'Mascalucia',0,'1800-01-01',NULL,0),
	(7020,100,'Militello in Val di Catania',0,'1800-01-01',NULL,0),
	(7021,100,'Milo',0,'1800-01-01',NULL,0),
	(7022,100,'Mineo',0,'1800-01-01',NULL,0),
	(7023,100,'Mirabella Imbaccari',0,'1800-01-01',NULL,0),
	(7024,100,'Misterbianco',0,'1800-01-01',NULL,0),
	(7025,100,'Motta Sant\'Anastasia',0,'1800-01-01',NULL,0),
	(7026,100,'Nicolosi',0,'1800-01-01',NULL,0),
	(7027,100,'Palagonia',0,'1800-01-01',NULL,0),
	(7028,100,'Paternò',0,'1800-01-01',NULL,0),
	(7029,100,'Pedara',0,'1800-01-01',NULL,0),
	(7030,100,'Piedimonte Etneo',0,'1800-01-01',NULL,0),
	(7031,100,'Raddusa',0,'1800-01-01',NULL,0),
	(7032,100,'Ramacca',0,'1800-01-01',NULL,0),
	(7033,100,'Randazzo',0,'1800-01-01',NULL,0),
	(7034,100,'Riposto',0,'1800-01-01',NULL,0),
	(7035,100,'San Cono',0,'1800-01-01',NULL,0),
	(7036,100,'San Giovanni la Punta',0,'1800-01-01',NULL,0),
	(7037,100,'San Gregorio di Catania',0,'1800-01-01',NULL,0),
	(7038,100,'San Michele di Ganzaria',0,'1800-01-01',NULL,0),
	(7039,100,'San Pietro Clarenza',0,'1800-01-01',NULL,0),
	(7040,100,'Sant\'Agata li Battiati',0,'1800-01-01',NULL,0),
	(7041,100,'Sant\'Alfio',0,'1800-01-01',NULL,0),
	(7042,100,'Santa Maria di Licodia',0,'1800-01-01',NULL,0),
	(7043,100,'Santa Venerina',0,'1800-01-01',NULL,0),
	(7044,100,'Scordia',0,'1800-01-01',NULL,0),
	(7045,100,'Trecastagni',0,'1800-01-01',NULL,0),
	(7046,100,'Tremestieri Etneo',0,'1800-01-01',NULL,0),
	(7047,100,'Valverde',0,'1800-01-01',NULL,0),
	(7048,100,'Viagrande',0,'1800-01-01',NULL,0),
	(7049,100,'Vizzini',0,'1800-01-01',NULL,0),
	(7050,100,'Zafferana Etnea',0,'1800-01-01',NULL,0),
	(7051,100,'Mazzarrone',0,'1800-01-01',NULL,0),
	(7052,100,'Maniace',0,'1800-01-01',NULL,0),
	(7053,100,'Ragalna',0,'1800-01-01',NULL,0),
	(7054,101,'Acate',0,'1800-01-01',NULL,0),
	(7055,101,'Chiaramonte Gulfi',0,'1800-01-01',NULL,0),
	(7056,101,'Comiso',0,'1800-01-01',NULL,0),
	(7057,101,'Giarratana',0,'1800-01-01',NULL,0),
	(7058,101,'Ispica',0,'1800-01-01',NULL,0),
	(7059,101,'Modica',0,'1800-01-01',NULL,0),
	(7060,101,'Monterosso Almo',0,'1800-01-01',NULL,0),
	(7061,101,'Pozzallo',0,'1800-01-01',NULL,0),
	(7062,101,'Ragusa',1,'1800-01-01',NULL,0),
	(7063,101,'Santa Croce Camerina',0,'1800-01-01',NULL,0),
	(7064,101,'Scicli',0,'1800-01-01',NULL,0),
	(7065,101,'Vittoria',0,'1800-01-01',NULL,0),
	(7066,102,'Augusta',0,'1800-01-01',NULL,0),
	(7067,102,'Avola',0,'1800-01-01',NULL,0),
	(7068,102,'Buccheri',0,'1800-01-01',NULL,0),
	(7069,102,'Buscemi',0,'1800-01-01',NULL,0),
	(7070,102,'Canicattini Bagni',0,'1800-01-01',NULL,0),
	(7071,102,'Carlentini',0,'1800-01-01',NULL,0),
	(7072,102,'Cassaro',0,'1800-01-01',NULL,0),
	(7073,102,'Ferla',0,'1800-01-01',NULL,0),
	(7074,102,'Floridia',0,'1800-01-01',NULL,0),
	(7075,102,'Francofonte',0,'1800-01-01',NULL,0),
	(7076,102,'Lentini',0,'1800-01-01',NULL,0),
	(7077,102,'Melilli',0,'1800-01-01',NULL,0),
	(7078,102,'Noto',0,'1800-01-01',NULL,0),
	(7079,102,'Pachino',0,'1800-01-01',NULL,0),
	(7080,102,'Palazzolo Acreide',0,'1800-01-01',NULL,0),
	(7081,102,'Rosolini',0,'1800-01-01',NULL,0),
	(7082,102,'Siracusa',1,'1800-01-01',NULL,0),
	(7083,102,'Solarino',0,'1800-01-01',NULL,0),
	(7084,102,'Sortino',0,'1800-01-01',NULL,0),
	(7085,102,'Portopalo di Capo Passero',0,'1800-01-01',NULL,0),
	(7086,102,'Priolo Gargallo',0,'1800-01-01',NULL,0),
	(7087,103,'Alghero',0,'1800-01-01',NULL,0),
	(7088,103,'Anela',0,'1800-01-01',NULL,0),
	(7089,103,'Ardara',0,'1800-01-01',NULL,0),
	(7090,103,'Banari',0,'1800-01-01',NULL,0),
	(7091,103,'Benetutti',0,'1800-01-01',NULL,0),
	(7092,103,'Bessude',0,'1800-01-01',NULL,0),
	(7093,103,'Bonnanaro',0,'1800-01-01',NULL,0),
	(7094,103,'Bono',0,'1800-01-01',NULL,0),
	(7095,103,'Bonorva',0,'1800-01-01',NULL,0),
	(7096,103,'Borutta',0,'1800-01-01',NULL,0),
	(7097,103,'Bottidda',0,'1800-01-01',NULL,0),
	(7098,103,'Bultei',0,'1800-01-01',NULL,0),
	(7099,103,'Bulzi',0,'1800-01-01',NULL,0),
	(7100,103,'Burgos',0,'1800-01-01',NULL,0),
	(7101,103,'Cargeghe',0,'1800-01-01',NULL,0),
	(7102,103,'Castelsardo',0,'1800-01-01',NULL,0),
	(7103,103,'Cheremule',0,'1800-01-01',NULL,0),
	(7104,103,'Chiaramonti',0,'1800-01-01',NULL,0),
	(7105,103,'Codrongianos',0,'1800-01-01',NULL,0),
	(7106,103,'Cossoine',0,'1800-01-01',NULL,0),
	(7107,103,'Esporlatu',0,'1800-01-01',NULL,0),
	(7108,103,'Florinas',0,'1800-01-01',NULL,0),
	(7109,103,'Giave',0,'1800-01-01',NULL,0),
	(7110,103,'Illorai',0,'1800-01-01',NULL,0),
	(7111,103,'Ittireddu',0,'1800-01-01',NULL,0),
	(7112,103,'Ittiri',0,'1800-01-01',NULL,0),
	(7113,103,'Laerru',0,'1800-01-01',NULL,0),
	(7114,103,'Mara',0,'1800-01-01',NULL,0),
	(7115,103,'Martis',0,'1800-01-01',NULL,0),
	(7116,103,'Monteleone Rocca Doria',0,'1800-01-01',NULL,0),
	(7117,103,'Mores',0,'1800-01-01',NULL,0),
	(7118,103,'Muros',0,'1800-01-01',NULL,0),
	(7119,103,'Nughedu San Nicolò',0,'1800-01-01',NULL,0),
	(7120,103,'Nule',0,'1800-01-01',NULL,0),
	(7121,103,'Nulvi',0,'1800-01-01',NULL,0),
	(7122,103,'Olmedo',0,'1800-01-01',NULL,0),
	(7123,103,'Osilo',0,'1800-01-01',NULL,0),
	(7124,103,'Ossi',0,'1800-01-01',NULL,0),
	(7125,103,'Ozieri',0,'1800-01-01',NULL,0),
	(7126,103,'Padria',0,'1800-01-01',NULL,0),
	(7127,103,'Pattada',0,'1800-01-01',NULL,0),
	(7128,103,'Perfugas',0,'1800-01-01',NULL,0),
	(7129,103,'Ploaghe',0,'1800-01-01',NULL,0),
	(7130,103,'Porto Torres',0,'1800-01-01',NULL,0),
	(7131,103,'Pozzomaggiore',0,'1800-01-01',NULL,0),
	(7132,103,'Putifigari',0,'1800-01-01',NULL,0),
	(7133,103,'Romana',0,'1800-01-01',NULL,0),
	(7134,103,'Sassari',1,'1800-01-01',NULL,0),
	(7135,103,'Sedini',0,'1800-01-01',NULL,0),
	(7136,103,'Semestene',0,'1800-01-01',NULL,0),
	(7137,103,'Sennori',0,'1800-01-01',NULL,0),
	(7138,103,'Siligo',0,'1800-01-01',NULL,0),
	(7139,103,'Sorso',0,'1800-01-01',NULL,0),
	(7140,103,'Thiesi',0,'1800-01-01',NULL,0),
	(7141,103,'Tissi',0,'1800-01-01',NULL,0),
	(7142,103,'Torralba',0,'1800-01-01',NULL,0),
	(7143,103,'Tula',0,'1800-01-01',NULL,0),
	(7144,103,'Uri',0,'1800-01-01',NULL,0),
	(7145,103,'Usini',0,'1800-01-01',NULL,0),
	(7146,103,'Villanova Monteleone',0,'1800-01-01',NULL,0),
	(7147,103,'Valledoria',0,'1800-01-01',NULL,0),
	(7148,103,'Viddalba',0,'1800-01-01',NULL,0),
	(7149,103,'Tergu',0,'1800-01-01',NULL,0),
	(7150,103,'Santa Maria Coghinas',0,'1800-01-01',NULL,0),
	(7151,103,'Erula',0,'1800-01-01',NULL,0),
	(7152,103,'Stintino',0,'1800-01-01',NULL,0),
	(7153,104,'Aritzo',0,'1800-01-01',NULL,0),
	(7154,104,'Atzara',0,'1800-01-01',NULL,0),
	(7155,104,'Austis',0,'1800-01-01',NULL,0),
	(7156,104,'Belvì',0,'1800-01-01',NULL,0),
	(7157,104,'Birori',0,'1800-01-01',NULL,0),
	(7158,104,'Bitti',0,'1800-01-01',NULL,0),
	(7159,104,'Bolotana',0,'1800-01-01',NULL,0),
	(7160,104,'Borore',0,'1800-01-01',NULL,0),
	(7161,104,'Bortigali',0,'1800-01-01',NULL,0),
	(7162,104,'Desulo',0,'1800-01-01',NULL,0),
	(7163,104,'Dorgali',0,'1800-01-01',NULL,0),
	(7164,104,'Dualchi',0,'1800-01-01',NULL,0),
	(7165,104,'Fonni',0,'1800-01-01',NULL,0),
	(7166,104,'Gadoni',0,'1800-01-01',NULL,0),
	(7167,104,'Galtellì',0,'1800-01-01',NULL,0),
	(7168,104,'Gavoi',0,'1800-01-01',NULL,0),
	(7169,104,'Irgoli',0,'1800-01-01',NULL,0),
	(7170,104,'Lei',0,'1800-01-01',NULL,0),
	(7171,104,'Loculi',0,'1800-01-01',NULL,0),
	(7172,104,'Lodè',0,'1800-01-01',NULL,0),
	(7173,104,'Lula',0,'1800-01-01',NULL,0),
	(7174,104,'Macomer',0,'1800-01-01',NULL,0),
	(7175,104,'Mamoiada',0,'1800-01-01',NULL,0),
	(7176,104,'Meana Sardo',0,'1800-01-01',NULL,0),
	(7177,104,'Noragugume',0,'1800-01-01',NULL,0),
	(7178,104,'Nuoro',1,'1800-01-01',NULL,0),
	(7179,104,'Oliena',0,'1800-01-01',NULL,0),
	(7180,104,'Ollolai',0,'1800-01-01',NULL,0),
	(7181,104,'Olzai',0,'1800-01-01',NULL,0),
	(7182,104,'Onanì',0,'1800-01-01',NULL,0),
	(7183,104,'Onifai',0,'1800-01-01',NULL,0),
	(7184,104,'Oniferi',0,'1800-01-01',NULL,0),
	(7185,104,'Orani',0,'1800-01-01',NULL,0),
	(7186,104,'Orgosolo',0,'1800-01-01',NULL,0),
	(7187,104,'Orosei',0,'1800-01-01',NULL,0),
	(7188,104,'Orotelli',0,'1800-01-01',NULL,0),
	(7189,104,'Ortueri',0,'1800-01-01',NULL,0),
	(7190,104,'Orune',0,'1800-01-01',NULL,0),
	(7191,104,'Osidda',0,'1800-01-01',NULL,0),
	(7192,104,'Ottana',0,'1800-01-01',NULL,0),
	(7193,104,'Ovodda',0,'1800-01-01',NULL,0),
	(7194,104,'Posada',0,'1800-01-01',NULL,0),
	(7195,104,'Sarule',0,'1800-01-01',NULL,0),
	(7196,104,'Silanus',0,'1800-01-01',NULL,0),
	(7197,104,'Sindia',0,'1800-01-01',NULL,0),
	(7198,104,'Siniscola',0,'1800-01-01',NULL,0),
	(7199,104,'Sorgono',0,'1800-01-01',NULL,0),
	(7200,104,'Teti',0,'1800-01-01',NULL,0),
	(7201,104,'Tiana',0,'1800-01-01',NULL,0),
	(7202,104,'Tonara',0,'1800-01-01',NULL,0),
	(7203,104,'Torpè',0,'1800-01-01',NULL,0),
	(7204,104,'Lodine',0,'1800-01-01',NULL,0),
	(7205,105,'Armungia',0,'1800-01-01',NULL,0),
	(7206,105,'Assemini',0,'1800-01-01',NULL,0),
	(7207,105,'Ballao',0,'1800-01-01',NULL,0),
	(7208,105,'Barrali',0,'1800-01-01',NULL,0),
	(7209,105,'Burcei',0,'1800-01-01',NULL,0),
	(7210,105,'Cagliari',1,'1800-01-01',NULL,0),
	(7211,105,'Capoterra',0,'1800-01-01',NULL,0),
	(7212,105,'Decimomannu',0,'1800-01-01',NULL,0),
	(7213,105,'Decimoputzu',0,'1800-01-01',NULL,0),
	(7214,105,'Dolianova',0,'1800-01-01',NULL,0),
	(7215,105,'Domus de Maria',0,'1800-01-01',NULL,0),
	(7216,105,'Donori',0,'1800-01-01',NULL,0),
	(7217,105,'Gesico',0,'1800-01-01',NULL,0),
	(7218,105,'Goni',0,'1800-01-01',NULL,0),
	(7219,105,'Guamaggiore',0,'1800-01-01',NULL,0),
	(7220,105,'Guasila',0,'1800-01-01',NULL,0),
	(7221,105,'Mandas',0,'1800-01-01',NULL,0),
	(7222,105,'Maracalagonis',0,'1800-01-01',NULL,0),
	(7223,105,'Monastir',0,'1800-01-01',NULL,0),
	(7224,105,'Muravera',0,'1800-01-01',NULL,0),
	(7225,105,'Nuraminis',0,'1800-01-01',NULL,0),
	(7226,105,'Ortacesus',0,'1800-01-01',NULL,0),
	(7227,105,'Pimentel',0,'1800-01-01',NULL,0),
	(7228,105,'Pula',0,'1800-01-01',NULL,0),
	(7229,105,'Quartu Sant\'Elena',0,'1800-01-01',NULL,0),
	(7230,105,'Samatzai',0,'1800-01-01',NULL,0),
	(7231,105,'San Basilio',0,'1800-01-01',NULL,0),
	(7232,105,'San Nicolò Gerrei',0,'1800-01-01',NULL,0),
	(7233,105,'San Sperate',0,'1800-01-01',NULL,0),
	(7234,105,'Sant\'Andrea Frius',0,'1800-01-01',NULL,0),
	(7235,105,'San Vito',0,'1800-01-01',NULL,0),
	(7236,105,'Sarroch',0,'1800-01-01',NULL,0),
	(7237,105,'Selargius',0,'1800-01-01',NULL,0),
	(7238,105,'Selegas',0,'1800-01-01',NULL,0),
	(7239,105,'Senorbì',0,'1800-01-01',NULL,0),
	(7240,105,'Serdiana',0,'1800-01-01',NULL,0),
	(7241,105,'Sestu',0,'1800-01-01',NULL,0),
	(7242,105,'Settimo San Pietro',0,'1800-01-01',NULL,0),
	(7243,105,'Siliqua',0,'1800-01-01',NULL,0),
	(7244,105,'Silius',0,'1800-01-01',NULL,0),
	(7245,105,'Sinnai',0,'1800-01-01',NULL,0),
	(7246,105,'Siurgus Donigala',0,'1800-01-01',NULL,0),
	(7247,105,'Soleminis',0,'1800-01-01',NULL,0),
	(7248,105,'Suelli',0,'1800-01-01',NULL,0),
	(7249,105,'Teulada',0,'1800-01-01',NULL,0),
	(7250,105,'Ussana',0,'1800-01-01',NULL,0),
	(7251,105,'Uta',0,'1800-01-01',NULL,0),
	(7252,105,'Vallermosa',0,'1800-01-01',NULL,0),
	(7253,105,'Villaputzu',0,'1800-01-01',NULL,0),
	(7254,105,'Villasalto',0,'1800-01-01',NULL,0),
	(7255,105,'Villa San Pietro',0,'1800-01-01',NULL,0),
	(7256,105,'Villasimius',0,'1800-01-01',NULL,0),
	(7257,105,'Villasor',0,'1800-01-01',NULL,0),
	(7258,105,'Villaspeciosa',0,'1800-01-01',NULL,0),
	(7259,105,'Quartucciu',0,'1800-01-01',NULL,0),
	(7260,105,'Castiadas',0,'1800-01-01',NULL,0),
	(7261,105,'Elmas',0,'1800-01-01',NULL,0),
	(7262,105,'Monserrato',0,'1800-01-01',NULL,0),
	(7263,105,'Escalaplano',0,'1800-01-01',NULL,0),
	(7264,105,'Escolca',0,'1800-01-01',NULL,0),
	(7265,105,'Esterzili',0,'1800-01-01',NULL,0),
	(7266,105,'Gergei',0,'1800-01-01',NULL,0),
	(7267,105,'Isili',0,'1800-01-01',NULL,0),
	(7268,105,'Nuragus',0,'1800-01-01',NULL,0),
	(7269,105,'Nurallao',0,'1800-01-01',NULL,0),
	(7270,105,'Nurri',0,'1800-01-01',NULL,0),
	(7271,105,'Orroli',0,'1800-01-01',NULL,0),
	(7272,105,'Sadali',0,'1800-01-01',NULL,0),
	(7273,105,'Serri',0,'1800-01-01',NULL,0),
	(7274,105,'Seulo',0,'1800-01-01',NULL,0),
	(7275,105,'Villanova Tulo',0,'1800-01-01',NULL,0),
	(7276,34,'Andreis',0,'1800-01-01',NULL,0),
	(7277,34,'Arba',0,'1800-01-01',NULL,0),
	(7278,34,'Arzene',0,'1800-01-01',NULL,0),
	(7279,34,'Aviano',0,'1800-01-01',NULL,0),
	(7280,34,'Azzano Decimo',0,'1800-01-01',NULL,0),
	(7281,34,'Barcis',0,'1800-01-01',NULL,0),
	(7282,34,'Brugnera',0,'1800-01-01',NULL,0),
	(7283,34,'Budoia',0,'1800-01-01',NULL,0),
	(7284,34,'Caneva',0,'1800-01-01',NULL,0),
	(7285,34,'Casarsa della Delizia',0,'1800-01-01',NULL,0),
	(7286,34,'Castelnovo del Friuli',0,'1800-01-01',NULL,0),
	(7287,34,'Cavasso Nuovo',0,'1800-01-01',NULL,0),
	(7288,34,'Chions',0,'1800-01-01',NULL,0),
	(7289,34,'Cimolais',0,'1800-01-01',NULL,0),
	(7290,34,'Claut',0,'1800-01-01',NULL,0),
	(7291,34,'Clauzetto',0,'1800-01-01',NULL,0),
	(7292,34,'Cordenons',0,'1800-01-01',NULL,0),
	(7293,34,'Cordovado',0,'1800-01-01',NULL,0),
	(7294,34,'Erto e Casso',0,'1800-01-01',NULL,0),
	(7295,34,'Fanna',0,'1800-01-01',NULL,0),
	(7296,34,'Fiume Veneto',0,'1800-01-01',NULL,0),
	(7297,34,'Fontanafredda',0,'1800-01-01',NULL,0),
	(7298,34,'Frisanco',0,'1800-01-01',NULL,0),
	(7299,34,'Maniago',0,'1800-01-01',NULL,0),
	(7300,34,'Meduno',0,'1800-01-01',NULL,0),
	(7301,34,'Montereale Valcellina',0,'1800-01-01',NULL,0),
	(7302,34,'Morsano al Tagliamento',0,'1800-01-01',NULL,0),
	(7303,34,'Pasiano di Pordenone',0,'1800-01-01',NULL,0),
	(7304,34,'Pinzano al Tagliamento',0,'1800-01-01',NULL,0),
	(7305,34,'Polcenigo',0,'1800-01-01',NULL,0),
	(7306,34,'Porcia',0,'1800-01-01',NULL,0),
	(7307,34,'Pordenone',1,'1800-01-01',NULL,0),
	(7308,34,'Prata di Pordenone',0,'1800-01-01',NULL,0),
	(7309,34,'Pravisdomini',0,'1800-01-01',NULL,0),
	(7310,34,'Roveredo in Piano',0,'1800-01-01',NULL,0),
	(7311,34,'Sacile',0,'1800-01-01',NULL,0),
	(7312,34,'San Giorgio della Richinvelda',0,'1800-01-01',NULL,0),
	(7313,34,'San Martino al Tagliamento',0,'1800-01-01',NULL,0),
	(7314,34,'San Quirino',0,'1800-01-01',NULL,0),
	(7315,34,'San Vito al Tagliamento',0,'1800-01-01',NULL,0),
	(7316,34,'Sequals',0,'1800-01-01',NULL,0),
	(7317,34,'Sesto al Reghena',0,'1800-01-01',NULL,0),
	(7318,34,'Spilimbergo',0,'1800-01-01',NULL,0),
	(7319,34,'Tramonti di Sopra',0,'1800-01-01',NULL,0),
	(7320,34,'Tramonti di Sotto',0,'1800-01-01',NULL,0),
	(7321,34,'Travesio',0,'1800-01-01',NULL,0),
	(7322,34,'Valvasone',0,'1800-01-01',NULL,0),
	(7323,34,'Vito d\'Asio',0,'1800-01-01',NULL,0),
	(7324,34,'Vivaro',0,'1800-01-01',NULL,0),
	(7325,34,'Zoppola',0,'1800-01-01',NULL,0),
	(7326,34,'Vajont',0,'1800-01-01',NULL,0),
	(7327,75,'Acquaviva d\'Isernia',0,'1800-01-01',NULL,0),
	(7328,75,'Agnone',0,'1800-01-01',NULL,0),
	(7329,75,'Bagnoli del Trigno',0,'1800-01-01',NULL,0),
	(7330,75,'Belmonte del Sannio',0,'1800-01-01',NULL,0),
	(7331,75,'Cantalupo nel Sannio',0,'1800-01-01',NULL,0),
	(7332,75,'Capracotta',0,'1800-01-01',NULL,0),
	(7333,75,'Carovilli',0,'1800-01-01',NULL,0),
	(7334,75,'Carpinone',0,'1800-01-01',NULL,0),
	(7335,75,'Castel del Giudice',0,'1800-01-01',NULL,0),
	(7336,75,'Castelpetroso',0,'1800-01-01',NULL,0),
	(7337,75,'Castelpizzuto',0,'1800-01-01',NULL,0),
	(7338,75,'Castel San Vincenzo',0,'1800-01-01',NULL,0),
	(7339,75,'Castelverrino',0,'1800-01-01',NULL,0),
	(7340,75,'Cerro al Volturno',0,'1800-01-01',NULL,0),
	(7341,75,'Chiauci',0,'1800-01-01',NULL,0),
	(7342,75,'Civitanova del Sannio',0,'1800-01-01',NULL,0),
	(7343,75,'Colli a Volturno',0,'1800-01-01',NULL,0),
	(7344,75,'Conca Casale',0,'1800-01-01',NULL,0),
	(7345,75,'Filignano',0,'1800-01-01',NULL,0),
	(7346,75,'Forlì del Sannio',0,'1800-01-01',NULL,0),
	(7347,75,'Fornelli',0,'1800-01-01',NULL,0),
	(7348,75,'Frosolone',0,'1800-01-01',NULL,0),
	(7349,75,'Isernia',1,'1800-01-01',NULL,0),
	(7350,75,'Longano',0,'1800-01-01',NULL,0),
	(7351,75,'Macchia d\'Isernia',0,'1800-01-01',NULL,0),
	(7352,75,'Macchiagodena',0,'1800-01-01',NULL,0),
	(7353,75,'Miranda',0,'1800-01-01',NULL,0),
	(7354,75,'Montaquila',0,'1800-01-01',NULL,0),
	(7355,75,'Montenero Val Cocchiara',0,'1800-01-01',NULL,0),
	(7356,75,'Monteroduni',0,'1800-01-01',NULL,0),
	(7357,75,'Pesche',0,'1800-01-01',NULL,0),
	(7358,75,'Pescolanciano',0,'1800-01-01',NULL,0),
	(7359,75,'Pescopennataro',0,'1800-01-01',NULL,0),
	(7360,75,'Pettoranello del Molise',0,'1800-01-01',NULL,0),
	(7361,75,'Pietrabbondante',0,'1800-01-01',NULL,0),
	(7362,75,'Pizzone',0,'1800-01-01',NULL,0),
	(7363,75,'Poggio Sannita',0,'1800-01-01',NULL,0),
	(7364,75,'Pozzilli',0,'1800-01-01',NULL,0),
	(7365,75,'Rionero Sannitico',0,'1800-01-01',NULL,0),
	(7366,75,'Roccamandolfi',0,'1800-01-01',NULL,0),
	(7367,75,'Roccasicura',0,'1800-01-01',NULL,0),
	(7368,75,'Rocchetta a Volturno',0,'1800-01-01',NULL,0),
	(7369,75,'San Pietro Avellana',0,'1800-01-01',NULL,0),
	(7370,75,'Sant\'Agapito',0,'1800-01-01',NULL,0),
	(7371,75,'Santa Maria del Molise',0,'1800-01-01',NULL,0),
	(7372,75,'Sant\'Angelo del Pesco',0,'1800-01-01',NULL,0),
	(7373,75,'Sant\'Elena Sannita',0,'1800-01-01',NULL,0),
	(7374,75,'Scapoli',0,'1800-01-01',NULL,0),
	(7375,75,'Sessano del Molise',0,'1800-01-01',NULL,0),
	(7376,75,'Sesto Campano',0,'1800-01-01',NULL,0),
	(7377,75,'Vastogirardi',0,'1800-01-01',NULL,0),
	(7378,75,'Venafro',0,'1800-01-01',NULL,0),
	(7379,106,'Abbasanta',0,'1800-01-01',NULL,0),
	(7380,106,'Aidomaggiore',0,'1800-01-01',NULL,0),
	(7381,106,'Albagiara',0,'1800-01-01',NULL,0),
	(7382,106,'Ales',0,'1800-01-01',NULL,0),
	(7383,106,'Allai',0,'1800-01-01',NULL,0),
	(7384,106,'Arborea',0,'1800-01-01',NULL,0),
	(7385,106,'Ardauli',0,'1800-01-01',NULL,0),
	(7386,106,'Assolo',0,'1800-01-01',NULL,0),
	(7387,106,'Asuni',0,'1800-01-01',NULL,0),
	(7388,106,'Baradili',0,'1800-01-01',NULL,0),
	(7389,106,'Baratili San Pietro',0,'1800-01-01',NULL,0),
	(7390,106,'Baressa',0,'1800-01-01',NULL,0),
	(7391,106,'Bauladu',0,'1800-01-01',NULL,0),
	(7392,106,'Bidonì',0,'1800-01-01',NULL,0),
	(7393,106,'Bonarcado',0,'1800-01-01',NULL,0),
	(7394,106,'Boroneddu',0,'1800-01-01',NULL,0),
	(7395,106,'Busachi',0,'1800-01-01',NULL,0),
	(7396,106,'Cabras',0,'1800-01-01',NULL,0),
	(7397,106,'Cuglieri',0,'1800-01-01',NULL,0),
	(7398,106,'Fordongianus',0,'1800-01-01',NULL,0),
	(7399,106,'Ghilarza',0,'1800-01-01',NULL,0),
	(7400,106,'Gonnoscodina',0,'1800-01-01',NULL,0),
	(7401,106,'Gonnosnò',0,'1800-01-01',NULL,0),
	(7402,106,'Gonnostramatza',0,'1800-01-01',NULL,0),
	(7403,106,'Marrubiu',0,'1800-01-01',NULL,0),
	(7404,106,'Masullas',0,'1800-01-01',NULL,0),
	(7405,106,'Milis',0,'1800-01-01',NULL,0),
	(7406,106,'Mogorella',0,'1800-01-01',NULL,0),
	(7407,106,'Mogoro',0,'1800-01-01',NULL,0),
	(7408,106,'Morgongiori',0,'1800-01-01',NULL,0),
	(7409,106,'Narbolia',0,'1800-01-01',NULL,0),
	(7410,106,'Neoneli',0,'1800-01-01',NULL,0),
	(7411,106,'Norbello',0,'1800-01-01',NULL,0),
	(7412,106,'Nughedu Santa Vittoria',0,'1800-01-01',NULL,0),
	(7413,106,'Nurachi',0,'1800-01-01',NULL,0),
	(7414,106,'Nureci',0,'1800-01-01',NULL,0),
	(7415,106,'Ollastra',0,'1800-01-01',NULL,0),
	(7416,106,'Oristano',1,'1800-01-01',NULL,0),
	(7417,106,'Palmas Arborea',0,'1800-01-01',NULL,0),
	(7418,106,'Pau',0,'1800-01-01',NULL,0),
	(7419,106,'Paulilatino',0,'1800-01-01',NULL,0),
	(7420,106,'Pompu',0,'1800-01-01',NULL,0),
	(7421,106,'Riola Sardo',0,'1800-01-01',NULL,0),
	(7422,106,'Ruinas',0,'1800-01-01',NULL,0),
	(7423,106,'Samugheo',0,'1800-01-01',NULL,0),
	(7424,106,'San Nicolò d\'Arcidano',0,'1800-01-01',NULL,0),
	(7425,106,'Santa Giusta',0,'1800-01-01',NULL,0),
	(7426,106,'Villa Sant\'Antonio',0,'1800-01-01',NULL,0),
	(7427,106,'Santu Lussurgiu',0,'1800-01-01',NULL,0),
	(7428,106,'San Vero Milis',0,'1800-01-01',NULL,0),
	(7429,106,'Scano di Montiferro',0,'1800-01-01',NULL,0),
	(7430,106,'Sedilo',0,'1800-01-01',NULL,0),
	(7431,106,'Seneghe',0,'1800-01-01',NULL,0),
	(7432,106,'Senis',0,'1800-01-01',NULL,0),
	(7433,106,'Sennariolo',0,'1800-01-01',NULL,0),
	(7434,106,'Siamaggiore',0,'1800-01-01',NULL,0),
	(7435,106,'Siamanna',0,'1800-01-01',NULL,0),
	(7436,106,'Simala',0,'1800-01-01',NULL,0),
	(7437,106,'Simaxis',0,'1800-01-01',NULL,0),
	(7438,106,'Sini',0,'1800-01-01',NULL,0),
	(7439,106,'Siris',0,'1800-01-01',NULL,0),
	(7440,106,'Solarussa',0,'1800-01-01',NULL,0),
	(7441,106,'Sorradile',0,'1800-01-01',NULL,0),
	(7442,106,'Tadasuni',0,'1800-01-01',NULL,0),
	(7443,106,'Terralba',0,'1800-01-01',NULL,0),
	(7444,106,'Tramatza',0,'1800-01-01',NULL,0),
	(7445,106,'Tresnuraghes',0,'1800-01-01',NULL,0),
	(7446,106,'Ulà Tirso',0,'1800-01-01',NULL,0),
	(7447,106,'Uras',0,'1800-01-01',NULL,0),
	(7448,106,'Usellus',0,'1800-01-01',NULL,0),
	(7449,106,'Villanova Truschedu',0,'1800-01-01',NULL,0),
	(7450,106,'Villaurbana',0,'1800-01-01',NULL,0),
	(7451,106,'Villa Verde',0,'1800-01-01',NULL,0),
	(7452,106,'Zeddiani',0,'1800-01-01',NULL,0),
	(7453,106,'Zerfaliu',0,'1800-01-01',NULL,0),
	(7454,106,'Siapiccia',0,'1800-01-01',NULL,0),
	(7455,106,'Curcuris',0,'1800-01-01',NULL,0),
	(7456,106,'Soddì',0,'1800-01-01',NULL,0),
	(7457,106,'Bosa',0,'1800-01-01',NULL,0),
	(7458,106,'Flussio',0,'1800-01-01',NULL,0),
	(7459,106,'Genoni',0,'1800-01-01',NULL,0),
	(7460,106,'Laconi',0,'1800-01-01',NULL,0),
	(7461,106,'Magomadas',0,'1800-01-01',NULL,0),
	(7462,106,'Modolo',0,'1800-01-01',NULL,0),
	(7463,106,'Montresta',0,'1800-01-01',NULL,0),
	(7464,106,'Sagama',0,'1800-01-01',NULL,0),
	(7465,106,'Suni',0,'1800-01-01',NULL,0),
	(7466,106,'Tinnura',0,'1800-01-01',NULL,0),
	(7467,7,'Ailoche',0,'1800-01-01',NULL,0),
	(7468,7,'Andorno Micca',0,'1800-01-01',NULL,0),
	(7469,7,'Benna',0,'1800-01-01',NULL,0),
	(7470,7,'Biella',1,'1800-01-01',NULL,0),
	(7471,7,'Bioglio',0,'1800-01-01',NULL,0),
	(7472,7,'Borriana',0,'1800-01-01',NULL,0),
	(7473,7,'Brusnengo',0,'1800-01-01',NULL,0),
	(7474,7,'Callabiana',0,'1800-01-01',NULL,0),
	(7475,7,'Camandona',0,'1800-01-01',NULL,0),
	(7476,7,'Camburzano',0,'1800-01-01',NULL,0),
	(7477,7,'Campiglia Cervo',0,'1800-01-01',NULL,0),
	(7478,7,'Candelo',0,'1800-01-01',NULL,0),
	(7479,7,'Caprile',0,'1800-01-01',NULL,0),
	(7480,7,'Casapinta',0,'1800-01-01',NULL,0),
	(7481,7,'Castelletto Cervo',0,'1800-01-01',NULL,0),
	(7482,7,'Cavaglià',0,'1800-01-01',NULL,0),
	(7483,7,'Cerreto Castello',0,'1800-01-01',NULL,0),
	(7484,7,'Cerrione',0,'1800-01-01',NULL,0),
	(7485,7,'Coggiola',0,'1800-01-01',NULL,0),
	(7486,7,'Cossato',0,'1800-01-01',NULL,0),
	(7487,7,'Crevacuore',0,'1800-01-01',NULL,0),
	(7488,7,'Crosa',0,'1800-01-01',NULL,0),
	(7489,7,'Curino',0,'1800-01-01',NULL,0),
	(7490,7,'Donato',0,'1800-01-01',NULL,0),
	(7491,7,'Dorzano',0,'1800-01-01',NULL,0),
	(7492,7,'Gaglianico',0,'1800-01-01',NULL,0),
	(7493,7,'Gifflenga',0,'1800-01-01',NULL,0),
	(7494,7,'Graglia',0,'1800-01-01',NULL,0),
	(7495,7,'Lessona',0,'1800-01-01',NULL,0),
	(7496,7,'Magnano',0,'1800-01-01',NULL,0),
	(7497,7,'Massazza',0,'1800-01-01',NULL,0),
	(7498,7,'Masserano',0,'1800-01-01',NULL,0),
	(7499,7,'Mezzana Mortigliengo',0,'1800-01-01',NULL,0),
	(7500,7,'Miagliano',0,'1800-01-01',NULL,0),
	(7501,7,'Mongrando',0,'1800-01-01',NULL,0),
	(7502,7,'Mottalciata',0,'1800-01-01',NULL,0),
	(7503,7,'Muzzano',0,'1800-01-01',NULL,0),
	(7504,7,'Netro',0,'1800-01-01',NULL,0),
	(7505,7,'Occhieppo Inferiore',0,'1800-01-01',NULL,0),
	(7506,7,'Occhieppo Superiore',0,'1800-01-01',NULL,0),
	(7507,7,'Pettinengo',0,'1800-01-01',NULL,0),
	(7508,7,'Piatto',0,'1800-01-01',NULL,0),
	(7509,7,'Piedicavallo',0,'1800-01-01',NULL,0),
	(7510,7,'Pollone',0,'1800-01-01',NULL,0),
	(7511,7,'Ponderano',0,'1800-01-01',NULL,0),
	(7512,7,'Portula',0,'1800-01-01',NULL,0),
	(7513,7,'Pralungo',0,'1800-01-01',NULL,0),
	(7514,7,'Pray',0,'1800-01-01',NULL,0),
	(7515,7,'Quaregna',0,'1800-01-01',NULL,0),
	(7516,7,'Quittengo',0,'1800-01-01',NULL,0),
	(7517,7,'Ronco Biellese',0,'1800-01-01',NULL,0),
	(7518,7,'Roppolo',0,'1800-01-01',NULL,0),
	(7519,7,'Rosazza',0,'1800-01-01',NULL,0),
	(7520,7,'Sagliano Micca',0,'1800-01-01',NULL,0),
	(7521,7,'Sala Biellese',0,'1800-01-01',NULL,0),
	(7522,7,'Salussola',0,'1800-01-01',NULL,0),
	(7523,7,'Sandigliano',0,'1800-01-01',NULL,0),
	(7524,7,'San Paolo Cervo',0,'1800-01-01',NULL,0),
	(7525,7,'Selve Marcone',0,'1800-01-01',NULL,0),
	(7526,7,'Soprana',0,'1800-01-01',NULL,0),
	(7527,7,'Sordevolo',0,'1800-01-01',NULL,0),
	(7528,7,'Sostegno',0,'1800-01-01',NULL,0),
	(7529,7,'Strona',0,'1800-01-01',NULL,0),
	(7530,7,'Tavigliano',0,'1800-01-01',NULL,0),
	(7531,7,'Ternengo',0,'1800-01-01',NULL,0),
	(7532,7,'Tollegno',0,'1800-01-01',NULL,0),
	(7533,7,'Torrazzo',0,'1800-01-01',NULL,0),
	(7534,7,'Trivero',0,'1800-01-01',NULL,0),
	(7535,7,'Valdengo',0,'1800-01-01',NULL,0),
	(7536,7,'Vallanzengo',0,'1800-01-01',NULL,0),
	(7537,7,'Valle Mosso',0,'1800-01-01',NULL,0),
	(7538,7,'Valle San Nicolao',0,'1800-01-01',NULL,0),
	(7539,7,'Veglio',0,'1800-01-01',NULL,0),
	(7540,7,'Verrone',0,'1800-01-01',NULL,0),
	(7541,7,'Vigliano Biellese',0,'1800-01-01',NULL,0),
	(7542,7,'Villa del Bosco',0,'1800-01-01',NULL,0),
	(7543,7,'Villanova Biellese',0,'1800-01-01',NULL,0),
	(7544,7,'Viverone',0,'1800-01-01',NULL,0),
	(7545,7,'Zimone',0,'1800-01-01',NULL,0),
	(7546,7,'Zubiena',0,'1800-01-01',NULL,0),
	(7547,7,'Zumaglia',0,'1800-01-01',NULL,0),
	(7548,7,'Mosso',0,'1800-01-01',NULL,0),
	(7549,19,'Abbadia Lariana',0,'1800-01-01',NULL,0),
	(7550,19,'Airuno',0,'1800-01-01',NULL,0),
	(7551,19,'Annone di Brianza',0,'1800-01-01',NULL,0),
	(7552,19,'Ballabio',0,'1800-01-01',NULL,0),
	(7553,19,'Barzago',0,'1800-01-01',NULL,0),
	(7554,19,'Barzanò',0,'1800-01-01',NULL,0),
	(7555,19,'Barzio',0,'1800-01-01',NULL,0),
	(7556,19,'Bellano',0,'1800-01-01',NULL,0),
	(7557,19,'Bosisio Parini',0,'1800-01-01',NULL,0),
	(7558,19,'Brivio',0,'1800-01-01',NULL,0),
	(7559,19,'Bulciago',0,'1800-01-01',NULL,0),
	(7560,19,'Calco',0,'1800-01-01',NULL,0),
	(7561,19,'Calolziocorte',0,'1800-01-01',NULL,0),
	(7562,19,'Carenno',0,'1800-01-01',NULL,0),
	(7563,19,'Casargo',0,'1800-01-01',NULL,0),
	(7564,19,'Casatenovo',0,'1800-01-01',NULL,0),
	(7565,19,'Cassago Brianza',0,'1800-01-01',NULL,0),
	(7566,19,'Cassina Valsassina',0,'1800-01-01',NULL,0),
	(7567,19,'Castello di Brianza',0,'1800-01-01',NULL,0),
	(7568,19,'Cernusco Lombardone',0,'1800-01-01',NULL,0),
	(7569,19,'Cesana Brianza',0,'1800-01-01',NULL,0),
	(7570,19,'Civate',0,'1800-01-01',NULL,0),
	(7571,19,'Colico',0,'1800-01-01',NULL,0),
	(7572,19,'Colle Brianza',0,'1800-01-01',NULL,0),
	(7573,19,'Cortenova',0,'1800-01-01',NULL,0),
	(7574,19,'Costa Masnaga',0,'1800-01-01',NULL,0),
	(7575,19,'Crandola Valsassina',0,'1800-01-01',NULL,0),
	(7576,19,'Cremella',0,'1800-01-01',NULL,0),
	(7577,19,'Cremeno',0,'1800-01-01',NULL,0),
	(7578,19,'Dervio',0,'1800-01-01',NULL,0),
	(7579,19,'Dolzago',0,'1800-01-01',NULL,0),
	(7580,19,'Dorio',0,'1800-01-01',NULL,0),
	(7581,19,'Ello',0,'1800-01-01',NULL,0),
	(7582,19,'Erve',0,'1800-01-01',NULL,0),
	(7583,19,'Esino Lario',0,'1800-01-01',NULL,0),
	(7584,19,'Galbiate',0,'1800-01-01',NULL,0),
	(7585,19,'Garbagnate Monastero',0,'1800-01-01',NULL,0),
	(7586,19,'Garlate',0,'1800-01-01',NULL,0),
	(7587,19,'Imbersago',0,'1800-01-01',NULL,0),
	(7588,19,'Introbio',0,'1800-01-01',NULL,0),
	(7589,19,'Introzzo',0,'1800-01-01',NULL,0),
	(7590,19,'Lecco',1,'1800-01-01',NULL,0),
	(7591,19,'Lierna',0,'1800-01-01',NULL,0),
	(7592,19,'Lomagna',0,'1800-01-01',NULL,0),
	(7593,19,'Malgrate',0,'1800-01-01',NULL,0),
	(7594,19,'Mandello del Lario',0,'1800-01-01',NULL,0),
	(7595,19,'Margno',0,'1800-01-01',NULL,0),
	(7596,19,'Merate',0,'1800-01-01',NULL,0),
	(7597,19,'Missaglia',0,'1800-01-01',NULL,0),
	(7598,19,'Moggio',0,'1800-01-01',NULL,0),
	(7599,19,'Molteno',0,'1800-01-01',NULL,0),
	(7600,19,'Monte Marenzo',0,'1800-01-01',NULL,0),
	(7601,19,'Montevecchia',0,'1800-01-01',NULL,0),
	(7602,19,'Monticello Brianza',0,'1800-01-01',NULL,0),
	(7603,19,'Morterone',0,'1800-01-01',NULL,0),
	(7604,19,'Nibionno',0,'1800-01-01',NULL,0),
	(7605,19,'Oggiono',0,'1800-01-01',NULL,0),
	(7606,19,'Olgiate Molgora',0,'1800-01-01',NULL,0),
	(7607,19,'Olginate',0,'1800-01-01',NULL,0),
	(7608,19,'Oliveto Lario',0,'1800-01-01',NULL,0),
	(7609,19,'Osnago',0,'1800-01-01',NULL,0),
	(7610,19,'Paderno d\'Adda',0,'1800-01-01',NULL,0),
	(7611,19,'Pagnona',0,'1800-01-01',NULL,0),
	(7612,19,'Parlasco',0,'1800-01-01',NULL,0),
	(7613,19,'Pasturo',0,'1800-01-01',NULL,0),
	(7614,19,'Perego',0,'1800-01-01',NULL,0),
	(7615,19,'Perledo',0,'1800-01-01',NULL,0),
	(7616,19,'Pescate',0,'1800-01-01',NULL,0),
	(7617,19,'Premana',0,'1800-01-01',NULL,0),
	(7618,19,'Primaluna',0,'1800-01-01',NULL,0),
	(7619,19,'Robbiate',0,'1800-01-01',NULL,0),
	(7620,19,'Rogeno',0,'1800-01-01',NULL,0),
	(7621,19,'Rovagnate',0,'1800-01-01',NULL,0),
	(7622,19,'Santa Maria Hoè',0,'1800-01-01',NULL,0),
	(7623,19,'Sirone',0,'1800-01-01',NULL,0),
	(7624,19,'Sirtori',0,'1800-01-01',NULL,0),
	(7625,19,'Sueglio',0,'1800-01-01',NULL,0),
	(7626,19,'Suello',0,'1800-01-01',NULL,0),
	(7627,19,'Taceno',0,'1800-01-01',NULL,0),
	(7628,19,'Torre de\' Busi',0,'1800-01-01',NULL,0),
	(7629,19,'Tremenico',0,'1800-01-01',NULL,0),
	(7630,19,'Valgreghentino',0,'1800-01-01',NULL,0),
	(7631,19,'Valmadrera',0,'1800-01-01',NULL,0),
	(7632,19,'Varenna',0,'1800-01-01',NULL,0),
	(7633,19,'Vendrogno',0,'1800-01-01',NULL,0),
	(7634,19,'Vercurago',0,'1800-01-01',NULL,0),
	(7635,19,'Verderio Inferiore',0,'1800-01-01',NULL,0),
	(7636,19,'Verderio Superiore',0,'1800-01-01',NULL,0),
	(7637,19,'Vestreno',0,'1800-01-01',NULL,0),
	(7638,19,'Viganò',0,'1800-01-01',NULL,0),
	(7639,20,'Abbadia Cerreto',0,'1800-01-01',NULL,0),
	(7640,20,'Bertonico',0,'1800-01-01',NULL,0),
	(7641,20,'Boffalora d\'Adda',0,'1800-01-01',NULL,0),
	(7642,20,'Borghetto Lodigiano',0,'1800-01-01',NULL,0),
	(7643,20,'Borgo San Giovanni',0,'1800-01-01',NULL,0),
	(7644,20,'Brembio',0,'1800-01-01',NULL,0),
	(7645,20,'Camairago',0,'1800-01-01',NULL,0),
	(7646,20,'Casaletto Lodigiano',0,'1800-01-01',NULL,0),
	(7647,20,'Casalmaiocco',0,'1800-01-01',NULL,0),
	(7648,20,'Casalpusterlengo',0,'1800-01-01',NULL,0),
	(7649,20,'Caselle Landi',0,'1800-01-01',NULL,0),
	(7650,20,'Caselle Lurani',0,'1800-01-01',NULL,0),
	(7651,20,'Castelnuovo Bocca d\'Adda',0,'1800-01-01',NULL,0),
	(7652,20,'Castiglione d\'Adda',0,'1800-01-01',NULL,0),
	(7653,20,'Castiraga Vidardo',0,'1800-01-01',NULL,0),
	(7654,20,'Cavacurta',0,'1800-01-01',NULL,0),
	(7655,20,'Cavenago d\'Adda',0,'1800-01-01',NULL,0),
	(7656,20,'Cervignano d\'Adda',0,'1800-01-01',NULL,0),
	(7657,20,'Codogno',0,'1800-01-01',NULL,0),
	(7658,20,'Comazzo',0,'1800-01-01',NULL,0),
	(7659,20,'Cornegliano Laudense',0,'1800-01-01',NULL,0),
	(7660,20,'Corno Giovine',0,'1800-01-01',NULL,0),
	(7661,20,'Cornovecchio',0,'1800-01-01',NULL,0),
	(7662,20,'Corte Palasio',0,'1800-01-01',NULL,0),
	(7663,20,'Crespiatica',0,'1800-01-01',NULL,0),
	(7664,20,'Fombio',0,'1800-01-01',NULL,0),
	(7665,20,'Galgagnano',0,'1800-01-01',NULL,0),
	(7666,20,'Graffignana',0,'1800-01-01',NULL,0),
	(7667,20,'Guardamiglio',0,'1800-01-01',NULL,0),
	(7668,20,'Livraga',0,'1800-01-01',NULL,0),
	(7669,20,'Lodi',1,'1800-01-01',NULL,0),
	(7670,20,'Lodi Vecchio',0,'1800-01-01',NULL,0),
	(7671,20,'Maccastorna',0,'1800-01-01',NULL,0),
	(7672,20,'Mairago',0,'1800-01-01',NULL,0),
	(7673,20,'Maleo',0,'1800-01-01',NULL,0),
	(7674,20,'Marudo',0,'1800-01-01',NULL,0),
	(7675,20,'Massalengo',0,'1800-01-01',NULL,0),
	(7676,20,'Meleti',0,'1800-01-01',NULL,0),
	(7677,20,'Merlino',0,'1800-01-01',NULL,0),
	(7678,20,'Montanaso Lombardo',0,'1800-01-01',NULL,0),
	(7679,20,'Mulazzano',0,'1800-01-01',NULL,0),
	(7680,20,'Orio Litta',0,'1800-01-01',NULL,0),
	(7681,20,'Ospedaletto Lodigiano',0,'1800-01-01',NULL,0),
	(7682,20,'Ossago Lodigiano',0,'1800-01-01',NULL,0),
	(7683,20,'Pieve Fissiraga',0,'1800-01-01',NULL,0),
	(7684,20,'Salerano sul Lambro',0,'1800-01-01',NULL,0),
	(7685,20,'San Fiorano',0,'1800-01-01',NULL,0),
	(7686,20,'San Martino in Strada',0,'1800-01-01',NULL,0),
	(7687,20,'San Rocco al Porto',0,'1800-01-01',NULL,0),
	(7688,20,'Sant\'Angelo Lodigiano',0,'1800-01-01',NULL,0),
	(7689,20,'Santo Stefano Lodigiano',0,'1800-01-01',NULL,0),
	(7690,20,'Secugnago',0,'1800-01-01',NULL,0),
	(7691,20,'Senna Lodigiana',0,'1800-01-01',NULL,0),
	(7692,20,'Somaglia',0,'1800-01-01',NULL,0),
	(7693,20,'Sordio',0,'1800-01-01',NULL,0),
	(7694,20,'Tavazzano con Villavesco',0,'1800-01-01',NULL,0),
	(7695,20,'Terranova dei Passerini',0,'1800-01-01',NULL,0),
	(7696,20,'Turano Lodigiano',0,'1800-01-01',NULL,0),
	(7697,20,'Valera Fratta',0,'1800-01-01',NULL,0),
	(7698,20,'Villanova del Sillaro',0,'1800-01-01',NULL,0),
	(7699,20,'Zelo Buon Persico',0,'1800-01-01',NULL,0),
	(7700,47,'Bellaria-Igea Marina',0,'1800-01-01',NULL,0),
	(7701,47,'Cattolica',0,'1800-01-01',NULL,0),
	(7702,47,'Coriano',0,'1800-01-01',NULL,0),
	(7703,47,'Gemmano',0,'1800-01-01',NULL,0),
	(7704,47,'Misano Adriatico',0,'1800-01-01',NULL,0),
	(7705,47,'Mondaino',0,'1800-01-01',NULL,0),
	(7706,47,'Monte Colombo',0,'1800-01-01',NULL,0),
	(7707,47,'Montefiore Conca',0,'1800-01-01',NULL,0),
	(7708,47,'Montegridolfo',0,'1800-01-01',NULL,0),
	(7709,47,'Montescudo',0,'1800-01-01',NULL,0),
	(7710,47,'Morciano di Romagna',0,'1800-01-01',NULL,0),
	(7711,47,'Poggio Berni',0,'1800-01-01',NULL,0),
	(7712,47,'Riccione',0,'1800-01-01',NULL,0),
	(7713,47,'Rimini',1,'1800-01-01',NULL,0),
	(7714,47,'Saludecio',0,'1800-01-01',NULL,0),
	(7715,47,'San Clemente',0,'1800-01-01',NULL,0),
	(7716,47,'San Giovanni in Marignano',0,'1800-01-01',NULL,0),
	(7717,47,'Santarcangelo di Romagna',0,'1800-01-01',NULL,0),
	(7718,47,'Torriana',0,'1800-01-01',NULL,0),
	(7719,47,'Verucchio',0,'1800-01-01',NULL,0),
	(7720,47,'Casteldelci',0,'1800-01-01',NULL,0),
	(7721,47,'Maiolo',0,'1800-01-01',NULL,0),
	(7722,47,'Novafeltria',0,'1800-01-01',NULL,0),
	(7723,47,'Pennabilli',0,'1800-01-01',NULL,0),
	(7724,47,'San Leo',0,'1800-01-01',NULL,0),
	(7725,47,'Sant\'Agata Feltria',0,'1800-01-01',NULL,0),
	(7726,47,'Talamello',0,'1800-01-01',NULL,0),
	(7727,57,'Cantagallo',0,'1800-01-01',NULL,0),
	(7728,57,'Carmignano',0,'1800-01-01',NULL,0),
	(7729,57,'Montemurlo',0,'1800-01-01',NULL,0),
	(7730,57,'Poggio a Caiano',0,'1800-01-01',NULL,0),
	(7731,57,'Prato',1,'1800-01-01',NULL,0),
	(7732,57,'Vaiano',0,'1800-01-01',NULL,0),
	(7733,57,'Vernio',0,'1800-01-01',NULL,0),
	(7734,92,'Belvedere di Spinello',0,'1800-01-01',NULL,0),
	(7735,92,'Caccuri',0,'1800-01-01',NULL,0),
	(7736,92,'Carfizzi',0,'1800-01-01',NULL,0),
	(7737,92,'Casabona',0,'1800-01-01',NULL,0),
	(7738,92,'Castelsilano',0,'1800-01-01',NULL,0),
	(7739,92,'Cerenzia',0,'1800-01-01',NULL,0),
	(7740,92,'Cirò',0,'1800-01-01',NULL,0),
	(7741,92,'Cirò Marina',0,'1800-01-01',NULL,0),
	(7742,92,'Cotronei',0,'1800-01-01',NULL,0),
	(7743,92,'Crotone',1,'1800-01-01',NULL,0),
	(7744,92,'Crucoli',0,'1800-01-01',NULL,0),
	(7745,92,'Cutro',0,'1800-01-01',NULL,0),
	(7746,92,'Isola di Capo Rizzuto',0,'1800-01-01',NULL,0),
	(7747,92,'Melissa',0,'1800-01-01',NULL,0),
	(7748,92,'Mesoraca',0,'1800-01-01',NULL,0),
	(7749,92,'Pallagorio',0,'1800-01-01',NULL,0),
	(7750,92,'Petilia Policastro',0,'1800-01-01',NULL,0),
	(7751,92,'Roccabernarda',0,'1800-01-01',NULL,0),
	(7752,92,'Rocca di Neto',0,'1800-01-01',NULL,0),
	(7753,92,'San Mauro Marchesato',0,'1800-01-01',NULL,0),
	(7754,92,'San Nicola dell\'Alto',0,'1800-01-01',NULL,0),
	(7755,92,'Santa Severina',0,'1800-01-01',NULL,0),
	(7756,92,'Savelli',0,'1800-01-01',NULL,0),
	(7757,92,'Scandale',0,'1800-01-01',NULL,0),
	(7758,92,'Strongoli',0,'1800-01-01',NULL,0),
	(7759,92,'Umbriatico',0,'1800-01-01',NULL,0),
	(7760,92,'Verzino',0,'1800-01-01',NULL,0),
	(7761,93,'Acquaro',0,'1800-01-01',NULL,0),
	(7762,93,'Arena',0,'1800-01-01',NULL,0),
	(7763,93,'Briatico',0,'1800-01-01',NULL,0),
	(7764,93,'Brognaturo',0,'1800-01-01',NULL,0),
	(7765,93,'Capistrano',0,'1800-01-01',NULL,0),
	(7766,93,'Cessaniti',0,'1800-01-01',NULL,0),
	(7767,93,'Dasà',0,'1800-01-01',NULL,0),
	(7768,93,'Dinami',0,'1800-01-01',NULL,0),
	(7769,93,'Drapia',0,'1800-01-01',NULL,0),
	(7770,93,'Fabrizia',0,'1800-01-01',NULL,0),
	(7771,93,'Filadelfia',0,'1800-01-01',NULL,0),
	(7772,93,'Filandari',0,'1800-01-01',NULL,0),
	(7773,93,'Filogaso',0,'1800-01-01',NULL,0),
	(7774,93,'Francavilla Angitola',0,'1800-01-01',NULL,0),
	(7775,93,'Francica',0,'1800-01-01',NULL,0),
	(7776,93,'Gerocarne',0,'1800-01-01',NULL,0),
	(7777,93,'Ionadi',0,'1800-01-01',NULL,0),
	(7778,93,'Joppolo',0,'1800-01-01',NULL,0),
	(7779,93,'Limbadi',0,'1800-01-01',NULL,0),
	(7780,93,'Maierato',0,'1800-01-01',NULL,0),
	(7781,93,'Mileto',0,'1800-01-01',NULL,0),
	(7782,93,'Mongiana',0,'1800-01-01',NULL,0),
	(7783,93,'Monterosso Calabro',0,'1800-01-01',NULL,0),
	(7784,93,'Nardodipace',0,'1800-01-01',NULL,0),
	(7785,93,'Nicotera',0,'1800-01-01',NULL,0),
	(7786,93,'Parghelia',0,'1800-01-01',NULL,0),
	(7787,93,'Pizzo',0,'1800-01-01',NULL,0),
	(7788,93,'Pizzoni',0,'1800-01-01',NULL,0),
	(7789,93,'Polia',0,'1800-01-01',NULL,0),
	(7790,93,'Ricadi',0,'1800-01-01',NULL,0),
	(7791,93,'Rombiolo',0,'1800-01-01',NULL,0),
	(7792,93,'San Calogero',0,'1800-01-01',NULL,0),
	(7793,93,'San Costantino Calabro',0,'1800-01-01',NULL,0),
	(7794,93,'San Gregorio d\'Ippona',0,'1800-01-01',NULL,0),
	(7795,93,'San Nicola da Crissa',0,'1800-01-01',NULL,0),
	(7796,93,'Sant\'Onofrio',0,'1800-01-01',NULL,0),
	(7797,93,'Serra San Bruno',0,'1800-01-01',NULL,0),
	(7798,93,'Simbario',0,'1800-01-01',NULL,0),
	(7799,93,'Sorianello',0,'1800-01-01',NULL,0),
	(7800,93,'Soriano Calabro',0,'1800-01-01',NULL,0),
	(7801,93,'Spadola',0,'1800-01-01',NULL,0),
	(7802,93,'Spilinga',0,'1800-01-01',NULL,0),
	(7803,93,'Stefanaconi',0,'1800-01-01',NULL,0),
	(7804,93,'Tropea',0,'1800-01-01',NULL,0),
	(7805,93,'Vallelonga',0,'1800-01-01',NULL,0),
	(7806,93,'Vazzano',0,'1800-01-01',NULL,0),
	(7807,93,'Vibo Valentia',1,'1800-01-01',NULL,0),
	(7808,93,'Zaccanopoli',0,'1800-01-01',NULL,0),
	(7809,93,'Zambrone',0,'1800-01-01',NULL,0),
	(7810,93,'Zungri',0,'1800-01-01',NULL,0),
	(7811,8,'Antrona Schieranco',0,'1800-01-01',NULL,0),
	(7812,8,'Anzola d\'Ossola',0,'1800-01-01',NULL,0),
	(7813,8,'Arizzano',0,'1800-01-01',NULL,0),
	(7814,8,'Arola',0,'1800-01-01',NULL,0),
	(7815,8,'Aurano',0,'1800-01-01',NULL,0),
	(7816,8,'Baceno',0,'1800-01-01',NULL,0),
	(7817,8,'Bannio Anzino',0,'1800-01-01',NULL,0),
	(7818,8,'Baveno',0,'1800-01-01',NULL,0),
	(7819,8,'Bee',0,'1800-01-01',NULL,0),
	(7820,8,'Belgirate',0,'1800-01-01',NULL,0),
	(7821,8,'Beura-Cardezza',0,'1800-01-01',NULL,0),
	(7822,8,'Bognanco',0,'1800-01-01',NULL,0),
	(7823,8,'Brovello-Carpugnino',0,'1800-01-01',NULL,0),
	(7824,8,'Calasca-Castiglione',0,'1800-01-01',NULL,0),
	(7825,8,'Cambiasca',0,'1800-01-01',NULL,0),
	(7826,8,'Cannero Riviera',0,'1800-01-01',NULL,0),
	(7827,8,'Cannobio',0,'1800-01-01',NULL,0),
	(7828,8,'Caprezzo',0,'1800-01-01',NULL,0),
	(7829,8,'Casale Corte Cerro',0,'1800-01-01',NULL,0),
	(7830,8,'Cavaglio-Spoccia',0,'1800-01-01',NULL,0),
	(7831,8,'Ceppo Morelli',0,'1800-01-01',NULL,0),
	(7832,8,'Cesara',0,'1800-01-01',NULL,0),
	(7833,8,'Cossogno',0,'1800-01-01',NULL,0),
	(7834,8,'Craveggia',0,'1800-01-01',NULL,0),
	(7835,8,'Crevoladossola',0,'1800-01-01',NULL,0),
	(7836,8,'Crodo',0,'1800-01-01',NULL,0),
	(7837,8,'Cursolo-Orasso',0,'1800-01-01',NULL,0),
	(7838,8,'Domodossola',0,'1800-01-01',NULL,0),
	(7839,8,'Druogno',0,'1800-01-01',NULL,0),
	(7840,8,'Falmenta',0,'1800-01-01',NULL,0),
	(7841,8,'Formazza',0,'1800-01-01',NULL,0),
	(7842,8,'Germagno',0,'1800-01-01',NULL,0),
	(7843,8,'Ghiffa',0,'1800-01-01',NULL,0),
	(7844,8,'Gignese',0,'1800-01-01',NULL,0),
	(7845,8,'Gravellona Toce',0,'1800-01-01',NULL,0),
	(7846,8,'Gurro',0,'1800-01-01',NULL,0),
	(7847,8,'Intragna',0,'1800-01-01',NULL,0),
	(7848,8,'Loreglia',0,'1800-01-01',NULL,0),
	(7849,8,'Macugnaga',0,'1800-01-01',NULL,0),
	(7850,8,'Madonna del Sasso',0,'1800-01-01',NULL,0),
	(7851,8,'Malesco',0,'1800-01-01',NULL,0),
	(7852,8,'Masera',0,'1800-01-01',NULL,0),
	(7853,8,'Massiola',0,'1800-01-01',NULL,0),
	(7854,8,'Mergozzo',0,'1800-01-01',NULL,0),
	(7855,8,'Miazzina',0,'1800-01-01',NULL,0),
	(7856,8,'Montecrestese',0,'1800-01-01',NULL,0),
	(7857,8,'Montescheno',0,'1800-01-01',NULL,0),
	(7858,8,'Nonio',0,'1800-01-01',NULL,0),
	(7859,8,'Oggebbio',0,'1800-01-01',NULL,0),
	(7860,8,'Omegna',0,'1800-01-01',NULL,0),
	(7861,8,'Ornavasso',0,'1800-01-01',NULL,0),
	(7862,8,'Pallanzeno',0,'1800-01-01',NULL,0),
	(7863,8,'Piedimulera',0,'1800-01-01',NULL,0),
	(7864,8,'Pieve Vergonte',0,'1800-01-01',NULL,0),
	(7865,8,'Premeno',0,'1800-01-01',NULL,0),
	(7866,8,'Premia',0,'1800-01-01',NULL,0),
	(7867,8,'Premosello-Chiovenda',0,'1800-01-01',NULL,0),
	(7868,8,'Quarna Sopra',0,'1800-01-01',NULL,0),
	(7869,8,'Quarna Sotto',0,'1800-01-01',NULL,0),
	(7870,8,'Re',0,'1800-01-01',NULL,0),
	(7871,8,'San Bernardino Verbano',0,'1800-01-01',NULL,0),
	(7872,8,'Santa Maria Maggiore',0,'1800-01-01',NULL,0),
	(7873,8,'Seppiana',0,'1800-01-01',NULL,0),
	(7874,8,'Stresa',0,'1800-01-01',NULL,0),
	(7875,8,'Toceno',0,'1800-01-01',NULL,0),
	(7876,8,'Trarego Viggiona',0,'1800-01-01',NULL,0),
	(7877,8,'Trasquera',0,'1800-01-01',NULL,0),
	(7878,8,'Trontano',0,'1800-01-01',NULL,0),
	(7879,8,'Valstrona',0,'1800-01-01',NULL,0),
	(7880,8,'Vanzone con San Carlo',0,'1800-01-01',NULL,0),
	(7881,8,'Varzo',0,'1800-01-01',NULL,0),
	(7882,8,'Verbania',1,'1800-01-01',NULL,0),
	(7883,8,'Viganella',0,'1800-01-01',NULL,0),
	(7884,8,'Vignone',0,'1800-01-01',NULL,0),
	(7885,8,'Villadossola',0,'1800-01-01',NULL,0),
	(7886,8,'Villette',0,'1800-01-01',NULL,0),
	(7887,8,'Vogogna',0,'1800-01-01',NULL,0),
	(7888,107,'Aggius',0,'1800-01-01',NULL,0),
	(7889,107,'Aglientu',0,'1800-01-01',NULL,0),
	(7890,107,'Alà dei Sardi',0,'1800-01-01',NULL,0),
	(7891,107,'Arzachena',0,'1800-01-01',NULL,0),
	(7892,107,'Badesi',0,'1800-01-01',NULL,0),
	(7893,107,'Berchidda',0,'1800-01-01',NULL,0),
	(7894,107,'Bortigiadas',0,'1800-01-01',NULL,0),
	(7895,107,'Buddusò',0,'1800-01-01',NULL,0),
	(7896,107,'Budoni',0,'1800-01-01',NULL,0),
	(7897,107,'Calangianus',0,'1800-01-01',NULL,0),
	(7898,107,'Golfo Aranci',0,'1800-01-01',NULL,0),
	(7899,107,'La Maddalena',0,'1800-01-01',NULL,0),
	(7900,107,'Loiri Porto San Paolo',0,'1800-01-01',NULL,0),
	(7901,107,'Luogosanto',0,'1800-01-01',NULL,0),
	(7902,107,'Luras',0,'1800-01-01',NULL,0),
	(7903,107,'Monti',0,'1800-01-01',NULL,0),
	(7904,107,'Olbia',1,'1800-01-01',NULL,0),
	(7905,107,'Oschiri',0,'1800-01-01',NULL,0),
	(7906,107,'Padru',0,'1800-01-01',NULL,0),
	(7907,107,'Palau',0,'1800-01-01',NULL,0),
	(7908,107,'Sant\'Antonio di Gallura',0,'1800-01-01',NULL,0),
	(7909,107,'Santa Teresa Gallura',0,'1800-01-01',NULL,0),
	(7910,107,'San Teodoro',0,'1800-01-01',NULL,0),
	(7911,107,'Telti',0,'1800-01-01',NULL,0),
	(7912,107,'Tempio Pausania',1,'1800-01-01',NULL,0),
	(7913,107,'Trinità d\'Agultu e Vignola',0,'1800-01-01',NULL,0),
	(7914,108,'Arzana',0,'1800-01-01',NULL,0),
	(7915,108,'Bari Sardo',0,'1800-01-01',NULL,0),
	(7916,108,'Baunei',0,'1800-01-01',NULL,0),
	(7917,108,'Cardedu',0,'1800-01-01',NULL,0),
	(7918,108,'Elini',0,'1800-01-01',NULL,0),
	(7919,108,'Gairo',0,'1800-01-01',NULL,0),
	(7920,108,'Girasole',0,'1800-01-01',NULL,0),
	(7921,108,'Ilbono',0,'1800-01-01',NULL,0),
	(7922,108,'Jerzu',0,'1800-01-01',NULL,0),
	(7923,108,'Lanusei',1,'1800-01-01',NULL,0),
	(7924,108,'Loceri',0,'1800-01-01',NULL,0),
	(7925,108,'Lotzorai',0,'1800-01-01',NULL,0),
	(7926,108,'Osini',0,'1800-01-01',NULL,0),
	(7927,108,'Perdasdefogu',0,'1800-01-01',NULL,0),
	(7928,108,'Seui',0,'1800-01-01',NULL,0),
	(7929,108,'Talana',0,'1800-01-01',NULL,0),
	(7930,108,'Tertenia',0,'1800-01-01',NULL,0),
	(7931,108,'Tortolì',1,'1800-01-01',NULL,0),
	(7932,108,'Triei',0,'1800-01-01',NULL,0),
	(7933,108,'Ulassai',0,'1800-01-01',NULL,0),
	(7934,108,'Urzulei',0,'1800-01-01',NULL,0),
	(7935,108,'Ussassai',0,'1800-01-01',NULL,0),
	(7936,108,'Villagrande Strisaili',0,'1800-01-01',NULL,0),
	(7937,109,'Arbus',0,'1800-01-01',NULL,0),
	(7938,109,'Barumini',0,'1800-01-01',NULL,0),
	(7939,109,'Collinas',0,'1800-01-01',NULL,0),
	(7940,109,'Furtei',0,'1800-01-01',NULL,0),
	(7941,109,'Genuri',0,'1800-01-01',NULL,0),
	(7942,109,'Gesturi',0,'1800-01-01',NULL,0),
	(7943,109,'Gonnosfanadiga',0,'1800-01-01',NULL,0),
	(7944,109,'Guspini',0,'1800-01-01',NULL,0),
	(7945,109,'Las Plassas',0,'1800-01-01',NULL,0),
	(7946,109,'Lunamatrona',0,'1800-01-01',NULL,0),
	(7947,109,'Pabillonis',0,'1800-01-01',NULL,0),
	(7948,109,'Pauli Arbarei',0,'1800-01-01',NULL,0),
	(7949,109,'Samassi',0,'1800-01-01',NULL,0),
	(7950,109,'San Gavino Monreale',0,'1800-01-01',NULL,0),
	(7951,109,'Sanluri',1,'1800-01-01',NULL,0),
	(7952,109,'Sardara',0,'1800-01-01',NULL,0),
	(7953,109,'Segariu',0,'1800-01-01',NULL,0),
	(7954,109,'Serramanna',0,'1800-01-01',NULL,0),
	(7955,109,'Serrenti',0,'1800-01-01',NULL,0),
	(7956,109,'Setzu',0,'1800-01-01',NULL,0),
	(7957,109,'Siddi',0,'1800-01-01',NULL,0),
	(7958,109,'Tuili',0,'1800-01-01',NULL,0),
	(7959,109,'Turri',0,'1800-01-01',NULL,0),
	(7960,109,'Ussaramanna',0,'1800-01-01',NULL,0),
	(7961,109,'Villacidro',1,'1800-01-01',NULL,0),
	(7962,109,'Villamar',0,'1800-01-01',NULL,0),
	(7963,109,'Villanovaforru',0,'1800-01-01',NULL,0),
	(7964,109,'Villanovafranca',0,'1800-01-01',NULL,0),
	(7965,110,'Buggerru',0,'1800-01-01',NULL,0),
	(7966,110,'Calasetta',0,'1800-01-01',NULL,0),
	(7967,110,'Carbonia',1,'1800-01-01',NULL,0),
	(7968,110,'Carloforte',0,'1800-01-01',NULL,0),
	(7969,110,'Domusnovas',0,'1800-01-01',NULL,0),
	(7970,110,'Fluminimaggiore',0,'1800-01-01',NULL,0),
	(7971,110,'Giba',0,'1800-01-01',NULL,0),
	(7972,110,'Gonnesa',0,'1800-01-01',NULL,0),
	(7973,110,'Iglesias',1,'1800-01-01',NULL,0),
	(7974,110,'Masainas',0,'1800-01-01',NULL,0),
	(7975,110,'Musei',0,'1800-01-01',NULL,0),
	(7976,110,'Narcao',0,'1800-01-01',NULL,0),
	(7977,110,'Nuxis',0,'1800-01-01',NULL,0),
	(7978,110,'Perdaxius',0,'1800-01-01',NULL,0),
	(7979,110,'Piscinas',0,'1800-01-01',NULL,0),
	(7980,110,'Portoscuso',0,'1800-01-01',NULL,0),
	(7981,110,'San Giovanni Suergiu',0,'1800-01-01',NULL,0),
	(7982,110,'Santadi',0,'1800-01-01',NULL,0),
	(7983,110,'Sant\'Anna Arresi',0,'1800-01-01',NULL,0),
	(7984,110,'Sant\'Antioco',0,'1800-01-01',NULL,0),
	(7985,110,'Tratalias',0,'1800-01-01',NULL,0),
	(7986,110,'Villamassargia',0,'1800-01-01',NULL,0),
	(7987,110,'Villaperuccio',0,'1800-01-01',NULL,0),
	(7988,21,'Agrate Brianza',0,'1800-01-01',NULL,0),
	(7989,21,'Aicurzio',0,'1800-01-01',NULL,0),
	(7990,21,'Albiate',0,'1800-01-01',NULL,0),
	(7991,21,'Arcore',0,'1800-01-01',NULL,0),
	(7992,21,'Barlassina',0,'1800-01-01',NULL,0),
	(7993,21,'Bellusco',0,'1800-01-01',NULL,0),
	(7994,21,'Bernareggio',0,'1800-01-01',NULL,0),
	(7995,21,'Besana in Brianza',0,'1800-01-01',NULL,0),
	(7996,21,'Biassono',0,'1800-01-01',NULL,0),
	(7997,21,'Bovisio-Masciago',0,'1800-01-01',NULL,0),
	(7998,21,'Briosco',0,'1800-01-01',NULL,0),
	(7999,21,'Brugherio',0,'1800-01-01',NULL,0),
	(8000,21,'Burago di Molgora',0,'1800-01-01',NULL,0),
	(8001,21,'Camparada',0,'1800-01-01',NULL,0),
	(8002,21,'Carate Brianza',0,'1800-01-01',NULL,0),
	(8003,21,'Carnate',0,'1800-01-01',NULL,0),
	(8004,21,'Cavenago di Brianza',0,'1800-01-01',NULL,0),
	(8005,21,'Ceriano Laghetto',0,'1800-01-01',NULL,0),
	(8006,21,'Cesano Maderno',0,'1800-01-01',NULL,0),
	(8007,21,'Cogliate',0,'1800-01-01',NULL,0),
	(8008,21,'Concorezzo',0,'1800-01-01',NULL,0),
	(8009,21,'Correzzana',0,'1800-01-01',NULL,0),
	(8010,21,'Desio',0,'1800-01-01',NULL,0),
	(8011,21,'Giussano',0,'1800-01-01',NULL,0),
	(8012,21,'Lazzate',0,'1800-01-01',NULL,0),
	(8013,21,'Lesmo',0,'1800-01-01',NULL,0),
	(8014,21,'Limbiate',0,'1800-01-01',NULL,0),
	(8015,21,'Lissone',0,'1800-01-01',NULL,0),
	(8016,21,'Macherio',0,'1800-01-01',NULL,0),
	(8017,21,'Meda',0,'1800-01-01',NULL,0),
	(8018,21,'Mezzago',0,'1800-01-01',NULL,0),
	(8019,21,'Misinto',0,'1800-01-01',NULL,0),
	(8020,21,'Monza',1,'1800-01-01',NULL,0),
	(8021,21,'Muggiò',0,'1800-01-01',NULL,0),
	(8022,21,'Nova Milanese',0,'1800-01-01',NULL,0),
	(8023,21,'Ornago',0,'1800-01-01',NULL,0),
	(8024,21,'Renate',0,'1800-01-01',NULL,0),
	(8025,21,'Ronco Briantino',0,'1800-01-01',NULL,0),
	(8026,21,'Seregno',0,'1800-01-01',NULL,0),
	(8027,21,'Seveso',0,'1800-01-01',NULL,0),
	(8028,21,'Sovico',0,'1800-01-01',NULL,0),
	(8029,21,'Sulbiate',0,'1800-01-01',NULL,0),
	(8030,21,'Triuggio',0,'1800-01-01',NULL,0),
	(8031,21,'Usmate Velate',0,'1800-01-01',NULL,0),
	(8032,21,'Varedo',0,'1800-01-01',NULL,0),
	(8033,21,'Vedano al Lambro',0,'1800-01-01',NULL,0),
	(8034,21,'Veduggio con Colzano',0,'1800-01-01',NULL,0),
	(8035,21,'Verano Brianza',0,'1800-01-01',NULL,0),
	(8036,21,'Villasanta',0,'1800-01-01',NULL,0),
	(8037,21,'Vimercate',0,'1800-01-01',NULL,0),
	(8038,21,'Busnago',0,'1800-01-01',NULL,0),
	(8039,21,'Caponago',0,'1800-01-01',NULL,0),
	(8040,21,'Cornate d\'Adda',0,'1800-01-01',NULL,0),
	(8041,21,'Lentate sul Seveso',0,'1800-01-01',NULL,0),
	(8042,21,'Roncello',0,'1800-01-01',NULL,0),
	(8043,64,'Altidona',0,'1800-01-01',NULL,0),
	(8044,64,'Amandola',0,'1800-01-01',NULL,0),
	(8045,64,'Belmonte Piceno',0,'1800-01-01',NULL,0),
	(8046,64,'Campofilone',0,'1800-01-01',NULL,0),
	(8047,64,'Falerone',0,'1800-01-01',NULL,0),
	(8048,64,'Fermo',1,'1800-01-01',NULL,0),
	(8049,64,'Francavilla d\'Ete',0,'1800-01-01',NULL,0),
	(8050,64,'Grottazzolina',0,'1800-01-01',NULL,0),
	(8051,64,'Lapedona',0,'1800-01-01',NULL,0),
	(8052,64,'Magliano di Tenna',0,'1800-01-01',NULL,0),
	(8053,64,'Massa Fermana',0,'1800-01-01',NULL,0),
	(8054,64,'Monsampietro Morico',0,'1800-01-01',NULL,0),
	(8055,64,'Montappone',0,'1800-01-01',NULL,0),
	(8056,64,'Montefalcone Appennino',0,'1800-01-01',NULL,0),
	(8057,64,'Montefortino',0,'1800-01-01',NULL,0),
	(8058,64,'Monte Giberto',0,'1800-01-01',NULL,0),
	(8059,64,'Montegiorgio',0,'1800-01-01',NULL,0),
	(8060,64,'Montegranaro',0,'1800-01-01',NULL,0),
	(8061,64,'Monteleone di Fermo',0,'1800-01-01',NULL,0),
	(8062,64,'Montelparo',0,'1800-01-01',NULL,0),
	(8063,64,'Monte Rinaldo',0,'1800-01-01',NULL,0),
	(8064,64,'Monterubbiano',0,'1800-01-01',NULL,0),
	(8065,64,'Monte San Pietrangeli',0,'1800-01-01',NULL,0),
	(8066,64,'Monte Urano',0,'1800-01-01',NULL,0),
	(8067,64,'Monte Vidon Combatte',0,'1800-01-01',NULL,0),
	(8068,64,'Monte Vidon Corrado',0,'1800-01-01',NULL,0),
	(8069,64,'Montottone',0,'1800-01-01',NULL,0),
	(8070,64,'Moresco',0,'1800-01-01',NULL,0),
	(8071,64,'Ortezzano',0,'1800-01-01',NULL,0),
	(8072,64,'Pedaso',0,'1800-01-01',NULL,0),
	(8073,64,'Petritoli',0,'1800-01-01',NULL,0),
	(8074,64,'Ponzano di Fermo',0,'1800-01-01',NULL,0),
	(8075,64,'Porto San Giorgio',0,'1800-01-01',NULL,0),
	(8076,64,'Porto Sant\'Elpidio',0,'1800-01-01',NULL,0),
	(8077,64,'Rapagnano',0,'1800-01-01',NULL,0),
	(8078,64,'Santa Vittoria in Matenano',0,'1800-01-01',NULL,0),
	(8079,64,'Sant\'Elpidio a Mare',0,'1800-01-01',NULL,0),
	(8080,64,'Servigliano',0,'1800-01-01',NULL,0),
	(8081,64,'Smerillo',0,'1800-01-01',NULL,0),
	(8082,64,'Torre San Patrizio',0,'1800-01-01',NULL,0),
	(8083,86,'Andria',1,'1800-01-01',NULL,0),
	(8084,86,'Barletta',1,'1800-01-01',NULL,0),
	(8085,86,'Bisceglie',0,'1800-01-01',NULL,0),
	(8086,86,'Canosa di Puglia',0,'1800-01-01',NULL,0),
	(8087,86,'Margherita di Savoia',0,'1800-01-01',NULL,0),
	(8088,86,'Minervino Murge',0,'1800-01-01',NULL,0),
	(8089,86,'San Ferdinando di Puglia',0,'1800-01-01',NULL,0),
	(8090,86,'Spinazzola',0,'1800-01-01',NULL,0),
	(8091,86,'Trani',1,'1800-01-01',NULL,0),
	(8092,86,'Trinitapoli',0,'1800-01-01',NULL,0),
	(8093,1,'Abbadia Alpina',0,'1800-01-01',NULL,1),
	(8094,1,'Avuglione e Vernone',0,'1800-01-01',NULL,1),
	(8095,1,'Baio Dora',0,'1800-01-01',NULL,1),
	(8096,1,'Bairo Torre',0,'1800-01-01',NULL,1),
	(8097,1,'Baratonia',0,'1800-01-01',NULL,1),
	(8098,1,'Bardassano',0,'1800-01-01',NULL,1),
	(8099,1,'Beaulard',0,'1800-01-01',NULL,1),
	(8100,1,'Bonzo',0,'1800-01-01',NULL,1),
	(8101,1,'Bousson',0,'1800-01-01',NULL,1),
	(8102,1,'Bovile',0,'1800-01-01',NULL,1),
	(8103,1,'Bussolino Gassinese',0,'1800-01-01',NULL,1),
	(8104,1,'Camagna di Torino',0,'1800-01-01',NULL,1),
	(8105,1,'Campiglia Soana',0,'1800-01-01',NULL,1),
	(8106,1,'Campo Canavese',0,'1800-01-01',NULL,1),
	(8107,1,'Caravino',0,'1800-01-01',NULL,1),
	(8108,1,'Cavoretto',0,'1800-01-01',NULL,1),
	(8109,1,'Cesnola',0,'1800-01-01',NULL,1),
	(8110,1,'Champlas-Du-Col',0,'1800-01-01',NULL,1),
	(8111,1,'Chiabrano',0,'1800-01-01',NULL,1),
	(8112,1,'Col San Giovanni',0,'1800-01-01',NULL,1),
	(8113,1,'Desertes',0,'1800-01-01',NULL,1),
	(8114,1,'Drusacco',0,'1800-01-01',NULL,1),
	(8115,1,'Faetto',0,'1800-01-01',NULL,1),
	(8116,1,'Favria-Oglianico',0,'1800-01-01',NULL,1),
	(8117,1,'Fenile',0,'1800-01-01',NULL,1),
	(8118,1,'Fenils',0,'1800-01-01',NULL,1),
	(8119,1,'Foresto di Susa',0,'1800-01-01',NULL,1),
	(8120,1,'Forno Alpi Graie',0,'1800-01-01',NULL,1),
	(8121,1,'Frassinere',0,'1800-01-01',NULL,1),
	(8122,1,'Gauna',0,'1800-01-01',NULL,1),
	(8123,1,'Inverso Porte',0,'1800-01-01',NULL,1),
	(8124,1,'Luserna',0,'1800-01-01',NULL,1),
	(8125,1,'Maniglia',0,'1800-01-01',NULL,1),
	(8126,1,'Marcorengo',0,'1800-01-01',NULL,1),
	(8127,1,'Meano',0,'1800-01-01',NULL,1),
	(8128,1,'Melezet',0,'1800-01-01',NULL,1),
	(8129,1,'Mentoulles',0,'1800-01-01',NULL,1),
	(8130,1,'Millaures',0,'1800-01-01',NULL,1),
	(8131,1,'Mocchie',0,'1800-01-01',NULL,1),
	(8132,1,'Mollieres',0,'1800-01-01',NULL,1),
	(8133,1,'Monasterolo Torinese',0,'1800-01-01',NULL,1),
	(8134,1,'Mondrone',0,'1800-01-01',NULL,1),
	(8135,1,'Montestrutto',0,'1800-01-01',NULL,1),
	(8136,1,'Muriaglio',0,'1800-01-01',NULL,1),
	(8137,1,'Novareglia',0,'1800-01-01',NULL,1),
	(8138,1,'Palazzo Piverone',0,'1800-01-01',NULL,1),
	(8139,1,'Pedanea',0,'1800-01-01',NULL,1),
	(8140,1,'Piazzo',0,'1800-01-01',NULL,1),
	(8141,1,'Priacco',0,'1800-01-01',NULL,1),
	(8142,1,'Revigliasco Torinese',0,'1800-01-01',NULL,1),
	(8143,1,'Riclaretto',0,'1800-01-01',NULL,1),
	(8144,1,'Rivera',0,'1800-01-01',NULL,1),
	(8145,1,'Roccapiatta',0,'1800-01-01',NULL,1),
	(8146,1,'Rochemolles',0,'1800-01-01',NULL,1),
	(8147,1,'Rodoretto',0,'1800-01-01',NULL,1),
	(8148,1,'Rollieres',0,'1800-01-01',NULL,1),
	(8149,1,'Salecanischio',0,'1800-01-01',NULL,1),
	(8150,1,'Sale Castelnuovo',0,'1800-01-01',NULL,1),
	(8151,1,'Salto',0,'1800-01-01',NULL,1),
	(8152,1,'San Gillio Torinese',0,'1800-01-01',NULL,1),
	(8153,1,'San Giovanni Pellice',0,'1800-01-01',NULL,1),
	(8154,1,'San Martino di Perrero',0,'1800-01-01',NULL,1),
	(8155,1,'Savoulx',0,'1800-01-01',NULL,1),
	(8156,1,'Solomiac',0,'1800-01-01',NULL,1),
	(8157,1,'Strambino Romano',0,'1800-01-01',NULL,1),
	(8158,1,'Tavernette',0,'1800-01-01',NULL,1),
	(8159,1,'Thures',0,'1800-01-01',NULL,1),
	(8160,1,'Tina',0,'1800-01-01',NULL,1),
	(8161,1,'Traverse',0,'1800-01-01',NULL,1),
	(8162,1,'Valchiusella',0,'1800-01-01',NULL,1),
	(8163,1,'Valprato',0,'1800-01-01',NULL,1),
	(8164,1,'Villa Castelnuovo',0,'1800-01-01',NULL,1),
	(8165,2,'Agnona',0,'1800-01-01',NULL,1),
	(8166,2,'Andorno Cacciorna',0,'1800-01-01',NULL,1),
	(8167,2,'Aranco',0,'1800-01-01',NULL,1),
	(8168,2,'Bornate',0,'1800-01-01',NULL,1),
	(8169,2,'Camasco',0,'1800-01-01',NULL,1),
	(8170,2,'Cascine di Stra',0,'1800-01-01',NULL,1),
	(8171,2,'Castellengo',0,'1800-01-01',NULL,1),
	(8172,2,'Castelletto Villa',0,'1800-01-01',NULL,1),
	(8173,2,'Cervarolo',0,'1800-01-01',NULL,1),
	(8174,2,'Chiavazza',0,'1800-01-01',NULL,1),
	(8175,2,'Cossila',0,'1800-01-01',NULL,1),
	(8176,2,'Crevola Sesia',0,'1800-01-01',NULL,1),
	(8177,2,'Croce di Mosso',0,'1800-01-01',NULL,1),
	(8178,2,'Doccio',0,'1800-01-01',NULL,1),
	(8179,2,'Ferruta',0,'1800-01-01',NULL,1),
	(8180,2,'Flecchia',0,'1800-01-01',NULL,1),
	(8181,2,'Foresto Sesia',0,'1800-01-01',NULL,1),
	(8182,2,'Isolella',0,'1800-01-01',NULL,1),
	(8183,2,'Locarno',0,'1800-01-01',NULL,1),
	(8184,2,'Morca',0,'1800-01-01',NULL,1),
	(8185,2,'Morondo',0,'1800-01-01',NULL,1),
	(8186,2,'Parone',0,'1800-01-01',NULL,1),
	(8187,2,'Pianceri',0,'1800-01-01',NULL,1),
	(8188,2,'Piane Sesia',0,'1800-01-01',NULL,1),
	(8189,2,'Rocca Pietra',0,'1800-01-01',NULL,1),
	(8190,2,'San Giuseppe di Casto',0,'1800-01-01',NULL,1),
	(8191,2,'Valle Superiore Mosso',0,'1800-01-01',NULL,1),
	(8192,2,'Valmaggia',0,'1800-01-01',NULL,1),
	(8193,2,'Vintebbio',0,'1800-01-01',NULL,1),
	(8194,3,'Agaro',0,'1800-01-01',NULL,1),
	(8195,3,'Agnellengo',0,'1800-01-01',NULL,1),
	(8196,3,'Agrano',0,'1800-01-01',NULL,1),
	(8197,3,'Albogno',0,'1800-01-01',NULL,1),
	(8198,3,'Alzate con Linduno',0,'1800-01-01',NULL,1),
	(8199,3,'Antronapiana',0,'1800-01-01',NULL,1),
	(8200,3,'Anzino',0,'1800-01-01',NULL,1),
	(8201,3,'Ara',0,'1800-01-01',NULL,1),
	(8202,3,'Arizzano',0,'1800-01-01',NULL,1),
	(8203,3,'Arizzano Inferiore',0,'1800-01-01',NULL,1),
	(8204,3,'Arizzano Superiore',0,'1800-01-01',NULL,1),
	(8205,3,'Art',0,'1800-01-01',NULL,1),
	(8206,3,'Auzate',0,'1800-01-01',NULL,1),
	(8207,3,'Beura',0,'1800-01-01',NULL,1),
	(8208,3,'Bieno',0,'1800-01-01',NULL,1),
	(8209,3,'Bognanco Dentro',0,'1800-01-01',NULL,1),
	(8210,3,'Bognanco Fuori',0,'1800-01-01',NULL,1),
	(8211,3,'Boleto',0,'1800-01-01',NULL,1),
	(8212,3,'Borgone d\'Ossola',0,'1800-01-01',NULL,1),
	(8213,3,'Brisino',0,'1800-01-01',NULL,1),
	(8214,3,'Brovello',0,'1800-01-01',NULL,1),
	(8215,3,'Bugnate',0,'1800-01-01',NULL,1),
	(8216,3,'Buttogno',0,'1800-01-01',NULL,1),
	(8217,3,'Caddo',0,'1800-01-01',NULL,1),
	(8218,3,'Calice Ossolano',0,'1800-01-01',NULL,1),
	(8219,3,'Calogna',0,'1800-01-01',NULL,1),
	(8220,3,'Campello Monti',0,'1800-01-01',NULL,1),
	(8221,3,'Cardezza',0,'1800-01-01',NULL,1),
	(8222,3,'Cargiago',0,'1800-01-01',NULL,1),
	(8223,3,'Carpugnino',0,'1800-01-01',NULL,1),
	(8224,3,'Casaleggio Castellazzo',0,'1800-01-01',NULL,1),
	(8225,3,'Castiglione d\'Ossola',0,'1800-01-01',NULL,1),
	(8226,3,'Cavaglio San Donnino',0,'1800-01-01',NULL,1),
	(8227,3,'Cavandone',0,'1800-01-01',NULL,1),
	(8228,3,'Chignolo Verbano',0,'1800-01-01',NULL,1),
	(8229,3,'Cimamulera',0,'1800-01-01',NULL,1),
	(8230,3,'Cireggio',0,'1800-01-01',NULL,1),
	(8231,3,'Cisore',0,'1800-01-01',NULL,1),
	(8232,3,'Coimo',0,'1800-01-01',NULL,1),
	(8233,3,'Coiromonte',0,'1800-01-01',NULL,1),
	(8234,3,'Comnago',0,'1800-01-01',NULL,1),
	(8235,3,'Corciago',0,'1800-01-01',NULL,1),
	(8236,3,'Crana Gattugno',0,'1800-01-01',NULL,1),
	(8237,3,'Cravegna',0,'1800-01-01',NULL,1),
	(8238,3,'Crusinallo',0,'1800-01-01',NULL,1),
	(8239,3,'Cursolo',0,'1800-01-01',NULL,1),
	(8240,3,'Cuzzago',0,'1800-01-01',NULL,1),
	(8241,3,'Dagnente',0,'1800-01-01',NULL,1),
	(8242,3,'Dissimo',0,'1800-01-01',NULL,1),
	(8243,3,'Esio',0,'1800-01-01',NULL,1),
	(8244,3,'Finero',0,'1800-01-01',NULL,1),
	(8245,3,'Folsogno',0,'1800-01-01',NULL,1),
	(8246,3,'Fomarco',0,'1800-01-01',NULL,1),
	(8247,3,'Fornero',0,'1800-01-01',NULL,1),
	(8248,3,'Forno',0,'1800-01-01',NULL,1),
	(8249,3,'Fosseno',0,'1800-01-01',NULL,1),
	(8250,3,'Ghevio',0,'1800-01-01',NULL,1),
	(8251,3,'Graglia Piana',0,'1800-01-01',NULL,1),
	(8252,3,'Intra',0,'1800-01-01',NULL,1),
	(8253,3,'Invorio Superiore',0,'1800-01-01',NULL,1),
	(8254,3,'Isola San Giulio',0,'1800-01-01',NULL,1),
	(8255,3,'Luzzogno',0,'1800-01-01',NULL,1),
	(8256,3,'Magognino',0,'1800-01-01',NULL,1),
	(8257,3,'Mercurago',0,'1800-01-01',NULL,1),
	(8258,3,'Migiandone',0,'1800-01-01',NULL,1),
	(8259,3,'Monte Ossolano',0,'1800-01-01',NULL,1),
	(8260,3,'Montebuglio',0,'1800-01-01',NULL,1),
	(8261,3,'Montrigiasco',0,'1800-01-01',NULL,1),
	(8262,3,'Mozzio',0,'1800-01-01',NULL,1),
	(8263,3,'Nocco',0,'1800-01-01',NULL,1),
	(8264,3,'Olgia',0,'1800-01-01',NULL,1),
	(8265,3,'Orasso',0,'1800-01-01',NULL,1),
	(8266,3,'Orta Novarese',0,'1800-01-01',NULL,1),
	(8267,3,'Pallanza',0,'1800-01-01',NULL,1),
	(8268,3,'Preglia',0,'1800-01-01',NULL,1),
	(8269,3,'Prequartera',0,'1800-01-01',NULL,1),
	(8270,3,'Quarna',0,'1800-01-01',NULL,1),
	(8271,3,'Rovegro',0,'1800-01-01',NULL,1),
	(8272,3,'Rumianca',0,'1800-01-01',NULL,1),
	(8273,3,'Salecchio',0,'1800-01-01',NULL,1),
	(8274,3,'Sambughetto',0,'1800-01-01',NULL,1),
	(8275,3,'San Bartolomeo Valmara',0,'1800-01-01',NULL,1),
	(8276,3,'San Carlo d\'Ossola',0,'1800-01-01',NULL,1),
	(8277,3,'Sant',0,'1800-01-01',NULL,1),
	(8278,3,'Santa Maria Maggiore e Crana',0,'1800-01-01',NULL,1),
	(8279,3,'Santino',0,'1800-01-01',NULL,1),
	(8280,3,'Schieranco',0,'1800-01-01',NULL,1),
	(8281,3,'Sologno',0,'1800-01-01',NULL,1),
	(8282,3,'Sovazza',0,'1800-01-01',NULL,1),
	(8283,3,'Spoccia',0,'1800-01-01',NULL,1),
	(8284,3,'Stropino',0,'1800-01-01',NULL,1),
	(8285,3,'Suna',0,'1800-01-01',NULL,1),
	(8286,3,'Tapigliano',0,'1800-01-01',NULL,1),
	(8287,3,'Tappia',0,'1800-01-01',NULL,1),
	(8288,3,'Traffiume',0,'1800-01-01',NULL,1),
	(8289,3,'Trobaso',0,'1800-01-01',NULL,1),
	(8290,3,'Unchio',0,'1800-01-01',NULL,1),
	(8291,3,'Vagna',0,'1800-01-01',NULL,1),
	(8292,3,'Vergano Novarese',0,'1800-01-01',NULL,1),
	(8293,3,'Vezzo',0,'1800-01-01',NULL,1),
	(8294,3,'Viceno',0,'1800-01-01',NULL,1),
	(8295,3,'Viggiona',0,'1800-01-01',NULL,1),
	(8296,3,'Vocogno e Prestinone',0,'1800-01-01',NULL,1),
	(8297,3,'Zornasco',0,'1800-01-01',NULL,1),
	(8298,3,'Zoverallo',0,'1800-01-01',NULL,1),
	(8299,4,'Albaretto Valle di Macra',0,'1800-01-01',NULL,1),
	(8300,4,'Alma',0,'1800-01-01',NULL,1),
	(8301,4,'Andonno',0,'1800-01-01',NULL,1),
	(8302,4,'Bersezio',0,'1800-01-01',NULL,1),
	(8303,4,'Briga Marittima',0,'1800-01-01',NULL,1),
	(8304,4,'Castelletto Monforte',0,'1800-01-01',NULL,1),
	(8305,4,'Gaiola Moiola',0,'1800-01-01',NULL,1),
	(8306,4,'Gorrino',0,'1800-01-01',NULL,1),
	(8307,4,'Lottulo',0,'1800-01-01',NULL,1),
	(8308,4,'Malpotremo',0,'1800-01-01',NULL,1),
	(8309,4,'Novello Monchiero',0,'1800-01-01',NULL,1),
	(8310,4,'Paglieres',0,'1800-01-01',NULL,1),
	(8311,4,'Perno',0,'1800-01-01',NULL,1),
	(8312,4,'Priero Montezemolo',0,'1800-01-01',NULL,1),
	(8313,4,'Sambuco-Pietraporzio',0,'1800-01-01',NULL,1),
	(8314,4,'San Michele Prazzo',0,'1800-01-01',NULL,1),
	(8315,4,'San Pietro di Monterosso',0,'1800-01-01',NULL,1),
	(8316,4,'Scaletta Uzzone',0,'1800-01-01',NULL,1),
	(8317,4,'Scarnafigi-Ruffia',0,'1800-01-01',NULL,1),
	(8318,4,'Tenda',0,'1800-01-01',NULL,1),
	(8319,4,'Torre Uzzone',0,'1800-01-01',NULL,1),
	(8320,4,'Ussolo',0,'1800-01-01',NULL,1),
	(8321,4,'Villanovetta',0,'1800-01-01',NULL,1),
	(8322,5,'Colcavagno',0,'1800-01-01',NULL,1),
	(8323,5,'Montiglio',0,'1800-01-01',NULL,1),
	(8324,5,'Scandeluzza',0,'1800-01-01',NULL,1),
	(8325,5,'Bagnasco d\'Asti',0,'1800-01-01',NULL,1),
	(8326,5,'Castelvero d\'Asti',0,'1800-01-01',NULL,1),
	(8327,5,'Castiglione d\'Asti',0,'1800-01-01',NULL,1),
	(8328,5,'Cocconito',0,'1800-01-01',NULL,1),
	(8329,5,'Dusino',0,'1800-01-01',NULL,1),
	(8330,5,'Marmorito',0,'1800-01-01',NULL,1),
	(8331,5,'Mondonio',0,'1800-01-01',NULL,1),
	(8332,5,'Passerano',0,'1800-01-01',NULL,1),
	(8333,5,'Primeglio Schierano',0,'1800-01-01',NULL,1),
	(8334,5,'Quarto Astese',0,'1800-01-01',NULL,1),
	(8335,5,'Rinco',0,'1800-01-01',NULL,1),
	(8336,5,'San Marzano Moasca',0,'1800-01-01',NULL,1),
	(8337,5,'San Marzanotto',0,'1800-01-01',NULL,1),
	(8338,5,'San Michele d\'Asti',0,'1800-01-01',NULL,1),
	(8339,5,'San Paolo della Valle',0,'1800-01-01',NULL,1),
	(8340,5,'Serravalle d',0,'1800-01-01',NULL,1),
	(8341,5,'Sessant',0,'1800-01-01',NULL,1),
	(8342,5,'Solbrito',0,'1800-01-01',NULL,1),
	(8343,5,'Vaglierano',0,'1800-01-01',NULL,1),
	(8344,5,'Villa Corsione',0,'1800-01-01',NULL,1),
	(8345,6,'Bisio',0,'1800-01-01',NULL,1),
	(8346,6,'Brignano del Curone',0,'1800-01-01',NULL,1),
	(8347,6,'Brusaschetto',0,'1800-01-01',NULL,1),
	(8348,6,'Carezzano Superiore',0,'1800-01-01',NULL,1),
	(8349,6,'Castel de\' Ratti',0,'1800-01-01',NULL,1),
	(8350,6,'Castel San Pietro Monferrato',0,'1800-01-01',NULL,1),
	(8351,6,'Corteranzo',0,'1800-01-01',NULL,1),
	(8352,6,'Cuquello',0,'1800-01-01',NULL,1),
	(8353,6,'Forotondo',0,'1800-01-01',NULL,1),
	(8354,6,'Frascata',0,'1800-01-01',NULL,1),
	(8355,6,'Groppo',0,'1800-01-01',NULL,1),
	(8356,6,'Malvino',0,'1800-01-01',NULL,1),
	(8357,6,'Molino Alzano',0,'1800-01-01',NULL,1),
	(8358,6,'Molo di Borbera',0,'1800-01-01',NULL,1),
	(8359,6,'Montalero',0,'1800-01-01',NULL,1),
	(8360,6,'Montechiaro Denice',0,'1800-01-01',NULL,1),
	(8361,6,'Pavone d\'Alessandria',0,'1800-01-01',NULL,1),
	(8362,6,'Quarti',0,'1800-01-01',NULL,1),
	(8363,6,'Rosingo',0,'1800-01-01',NULL,1),
	(8364,6,'Salabue',0,'1800-01-01',NULL,1),
	(8365,6,'Sorli',0,'1800-01-01',NULL,1),
	(8366,6,'Tagliolo Belforte',0,'1800-01-01',NULL,1),
	(8367,6,'Torre de\' Ratti',0,'1800-01-01',NULL,1),
	(8368,6,'Varengo',0,'1800-01-01',NULL,1),
	(8369,6,'Vargo',0,'1800-01-01',NULL,1),
	(8370,6,'Villabella',0,'1800-01-01',NULL,1),
	(8371,9,'Challant',0,'1800-01-01',NULL,1),
	(8372,9,'Gressoney',0,'1800-01-01',NULL,1),
	(8373,9,'Rh',0,'1800-01-01',NULL,1),
	(8374,9,'Valdigna d',0,'1800-01-01',NULL,1),
	(8375,35,'Arzeno d\'Oneglia',0,'1800-01-01',NULL,1),
	(8376,35,'Bestagno',0,'1800-01-01',NULL,1),
	(8377,35,'Borghetto San Nicol',0,'1800-01-01',NULL,1),
	(8378,35,'Borgo Sant\'Agata',0,'1800-01-01',NULL,1),
	(8379,35,'Boscomare',0,'1800-01-01',NULL,1),
	(8380,35,'Bussana',0,'1800-01-01',NULL,1),
	(8381,35,'Candeasco',0,'1800-01-01',NULL,1),
	(8382,35,'Caramagna Ligure',0,'1800-01-01',NULL,1),
	(8383,35,'Cartari e Calderara',0,'1800-01-01',NULL,1),
	(8384,35,'Castelvecchio di Santa Maria Maggiore',0,'1800-01-01',NULL,1),
	(8385,35,'Cenova',0,'1800-01-01',NULL,1),
	(8386,35,'Col di Rodi',0,'1800-01-01',NULL,1),
	(8387,35,'Conio',0,'1800-01-01',NULL,1),
	(8388,35,'Costa d\'Oneglia',0,'1800-01-01',NULL,1),
	(8389,35,'Diano Borello',0,'1800-01-01',NULL,1),
	(8390,35,'Diano Calderina',0,'1800-01-01',NULL,1),
	(8391,35,'Gazzelli',0,'1800-01-01',NULL,1),
	(8392,35,'Lavina',0,'1800-01-01',NULL,1),
	(8393,35,'Lingueglietta',0,'1800-01-01',NULL,1),
	(8394,35,'Maro Castello',0,'1800-01-01',NULL,1),
	(8395,35,'Mendatica Montegrosso',0,'1800-01-01',NULL,1),
	(8396,35,'Moano',0,'1800-01-01',NULL,1),
	(8397,35,'Moltedo Superiore',0,'1800-01-01',NULL,1),
	(8398,35,'Montegrazie',0,'1800-01-01',NULL,1),
	(8399,35,'Olivastri',0,'1800-01-01',NULL,1),
	(8400,35,'Oneglia',0,'1800-01-01',NULL,1),
	(8401,35,'Pantasina',0,'1800-01-01',NULL,1),
	(8402,35,'Pianavia',0,'1800-01-01',NULL,1),
	(8403,35,'Piani',0,'1800-01-01',NULL,1),
	(8404,35,'Poggi',0,'1800-01-01',NULL,1),
	(8405,35,'Riva Santo Stefano',0,'1800-01-01',NULL,1),
	(8406,35,'San Lazzaro Reale',0,'1800-01-01',NULL,1),
	(8407,35,'Sarola',0,'1800-01-01',NULL,1),
	(8408,35,'Sasso di Bordighera',0,'1800-01-01',NULL,1),
	(8409,35,'Tavole',0,'1800-01-01',NULL,1),
	(8410,35,'Torrazza',0,'1800-01-01',NULL,1),
	(8411,35,'Torria',0,'1800-01-01',NULL,1),
	(8412,35,'Ubaga',0,'1800-01-01',NULL,1),
	(8413,35,'Valloria Marittima',0,'1800-01-01',NULL,1),
	(8414,35,'Villaguardia',0,'1800-01-01',NULL,1),
	(8415,35,'Villatalla',0,'1800-01-01',NULL,1),
	(8416,35,'Villaviani',0,'1800-01-01',NULL,1),
	(8417,35,'Ville San Pietro',0,'1800-01-01',NULL,1),
	(8418,35,'Ville San Sebastiano',0,'1800-01-01',NULL,1),
	(8419,36,'Bardino Nuovo',0,'1800-01-01',NULL,1),
	(8420,36,'Bardino Vecchio',0,'1800-01-01',NULL,1),
	(8421,36,'Biestro',0,'1800-01-01',NULL,1),
	(8422,36,'Borgio',0,'1800-01-01',NULL,1),
	(8423,36,'Brovida',0,'1800-01-01',NULL,1),
	(8424,36,'Cagna',0,'1800-01-01',NULL,1),
	(8425,36,'Calvisio',0,'1800-01-01',NULL,1),
	(8426,36,'Campochiesa',0,'1800-01-01',NULL,1),
	(8427,36,'Carpe',0,'1800-01-01',NULL,1),
	(8428,36,'Carretto',0,'1800-01-01',NULL,1),
	(8429,36,'Cenesi',0,'1800-01-01',NULL,1),
	(8430,36,'Ellera',0,'1800-01-01',NULL,1),
	(8431,36,'Finalborgo',0,'1800-01-01',NULL,1),
	(8432,36,'Finale Marina',0,'1800-01-01',NULL,1),
	(8433,36,'Finale Pia',0,'1800-01-01',NULL,1),
	(8434,36,'Gorra',0,'1800-01-01',NULL,1),
	(8435,36,'Lodisio',0,'1800-01-01',NULL,1),
	(8436,36,'Martina Olba',0,'1800-01-01',NULL,1),
	(8437,36,'Olba',0,'1800-01-01',NULL,1),
	(8438,36,'Orco',0,'1800-01-01',NULL,1),
	(8439,36,'Perti',0,'1800-01-01',NULL,1),
	(8440,36,'Portio',0,'1800-01-01',NULL,1),
	(8441,36,'Ranzi Pietra',0,'1800-01-01',NULL,1),
	(8442,36,'Rocchetta Cairo',0,'1800-01-01',NULL,1),
	(8443,36,'Rocchetta Cengio',0,'1800-01-01',NULL,1),
	(8444,36,'Santa Giulia',0,'1800-01-01',NULL,1),
	(8445,36,'Segno',0,'1800-01-01',NULL,1),
	(8446,36,'Varigotti',0,'1800-01-01',NULL,1),
	(8447,36,'Vellego',0,'1800-01-01',NULL,1),
	(8448,36,'Verezzi',0,'1800-01-01',NULL,1),
	(8449,36,'Verzi Pietra',0,'1800-01-01',NULL,1),
	(8450,36,'Vezzi',0,'1800-01-01',NULL,1),
	(8451,37,'Apparizione',0,'1800-01-01',NULL,1),
	(8452,37,'Bavari',0,'1800-01-01',NULL,1),
	(8453,37,'Bogliasco Pieve',0,'1800-01-01',NULL,1),
	(8454,37,'Bolzaneto',0,'1800-01-01',NULL,1),
	(8455,37,'Borzoli',0,'1800-01-01',NULL,1),
	(8456,37,'Canepa',0,'1800-01-01',NULL,1),
	(8457,37,'Cornigliano Ligure',0,'1800-01-01',NULL,1),
	(8458,37,'Foce',0,'1800-01-01',NULL,1),
	(8459,37,'Marassi',0,'1800-01-01',NULL,1),
	(8460,37,'Molassana',0,'1800-01-01',NULL,1),
	(8461,37,'Multedo',0,'1800-01-01',NULL,1),
	(8462,37,'Nervi',0,'1800-01-01',NULL,1),
	(8463,37,'Pegli',0,'1800-01-01',NULL,1),
	(8464,37,'Pontedecimo',0,'1800-01-01',NULL,1),
	(8465,37,'Pra',0,'1800-01-01',NULL,1),
	(8466,37,'Quarto dei Mille',0,'1800-01-01',NULL,1),
	(8467,37,'Quinto al Mare',0,'1800-01-01',NULL,1),
	(8468,37,'Rivarolo Ligure',0,'1800-01-01',NULL,1),
	(8469,37,'San Francesco d\'Albaro',0,'1800-01-01',NULL,1),
	(8470,37,'San Fruttuoso',0,'1800-01-01',NULL,1),
	(8471,37,'San Giovanni Battista',0,'1800-01-01',NULL,1),
	(8472,37,'San Martino d\'Albaro',0,'1800-01-01',NULL,1),
	(8473,37,'San Pier d\'Arena',0,'1800-01-01',NULL,1),
	(8474,37,'San Quirico in Val Polcevera',0,'1800-01-01',NULL,1),
	(8475,37,'Sant\'Ilario Ligure',0,'1800-01-01',NULL,1),
	(8476,37,'Sestri Ponente',0,'1800-01-01',NULL,1),
	(8477,37,'Staglieno',0,'1800-01-01',NULL,1),
	(8478,37,'Struppa',0,'1800-01-01',NULL,1),
	(8479,37,'Voltri',0,'1800-01-01',NULL,1),
	(8480,38,'Trebiano Magra',0,'1800-01-01',NULL,1),
	(8481,10,'Abbiateguazzone',0,'1800-01-01',NULL,1),
	(8482,10,'Albusciago',0,'1800-01-01',NULL,1),
	(8483,10,'Arbizzo',0,'1800-01-01',NULL,1),
	(8484,10,'Arcumeggia',0,'1800-01-01',NULL,1),
	(8485,10,'Ardena',0,'1800-01-01',NULL,1),
	(8486,10,'Armio',0,'1800-01-01',NULL,1),
	(8487,10,'Arnate',0,'1800-01-01',NULL,1),
	(8488,10,'Arolo',0,'1800-01-01',NULL,1),
	(8489,10,'Ballarate',0,'1800-01-01',NULL,1),
	(8490,10,'Barza',0,'1800-01-01',NULL,1),
	(8491,10,'Barzola',0,'1800-01-01',NULL,1),
	(8492,10,'Biegno',0,'1800-01-01',NULL,1),
	(8493,10,'Bizzozero',0,'1800-01-01',NULL,1),
	(8494,10,'Bobbiate',0,'1800-01-01',NULL,1),
	(8495,10,'Bodio',0,'1800-01-01',NULL,1),
	(8496,10,'Bogno',0,'1800-01-01',NULL,1),
	(8497,10,'Bolladello',0,'1800-01-01',NULL,1),
	(8498,10,'Borsano',0,'1800-01-01',NULL,1),
	(8499,10,'Bosco Valtravaglia',0,'1800-01-01',NULL,1),
	(8500,10,'Brenno Useria',0,'1800-01-01',NULL,1),
	(8501,10,'Brissago',0,'1800-01-01',NULL,1),
	(8502,10,'Cadegliano',0,'1800-01-01',NULL,1),
	(8503,10,'Cadero con Graglio',0,'1800-01-01',NULL,1),
	(8504,10,'Caidate',0,'1800-01-01',NULL,1),
	(8505,10,'Cajello',0,'1800-01-01',NULL,1),
	(8506,10,'Campagnano Vedasca',0,'1800-01-01',NULL,1),
	(8507,10,'Capolago',0,'1800-01-01',NULL,1),
	(8508,10,'Capronno',0,'1800-01-01',NULL,1),
	(8509,10,'Cardana',0,'1800-01-01',NULL,1),
	(8510,10,'Caronno Corbellaro',0,'1800-01-01',NULL,1),
	(8511,10,'Cassina Ferrara',0,'1800-01-01',NULL,1),
	(8512,10,'Cassina Pertusella',0,'1800-01-01',NULL,1),
	(8513,10,'Cassina Verghera',0,'1800-01-01',NULL,1),
	(8514,10,'Castegnate Olona',0,'1800-01-01',NULL,1),
	(8515,10,'Castelnovate',0,'1800-01-01',NULL,1),
	(8516,10,'Cavona',0,'1800-01-01',NULL,1),
	(8517,10,'Cedrate',0,'1800-01-01',NULL,1),
	(8518,10,'Celina',0,'1800-01-01',NULL,1),
	(8519,10,'Cerro Lago Maggiore',0,'1800-01-01',NULL,1),
	(8520,10,'Cimbro',0,'1800-01-01',NULL,1),
	(8521,10,'Cocquio',0,'1800-01-01',NULL,1),
	(8522,10,'Corgeno',0,'1800-01-01',NULL,1),
	(8523,10,'Crenna',0,'1800-01-01',NULL,1),
	(8524,10,'Crugnola',0,'1800-01-01',NULL,1),
	(8525,10,'Cugliate',0,'1800-01-01',NULL,1),
	(8526,10,'Cuveglio in Valle',0,'1800-01-01',NULL,1),
	(8527,10,'Cuvirone',0,'1800-01-01',NULL,1),
	(8528,10,'Due Cossani',0,'1800-01-01',NULL,1),
	(8529,10,'Fabiasco',0,'1800-01-01',NULL,1),
	(8530,10,'Garabiolo',0,'1800-01-01',NULL,1),
	(8531,10,'Gazzada',0,'1800-01-01',NULL,1),
	(8532,10,'Gornate-Superiore',0,'1800-01-01',NULL,1),
	(8533,10,'Gurone',0,'1800-01-01',NULL,1),
	(8534,10,'Jerago con Besnate ed Orago',0,'1800-01-01',NULL,1),
	(8535,10,'Laveno',0,'1800-01-01',NULL,1),
	(8536,10,'Lisanza',0,'1800-01-01',NULL,1),
	(8537,10,'Lissago',0,'1800-01-01',NULL,1),
	(8538,10,'Lozzo',0,'1800-01-01',NULL,1),
	(8539,10,'Maccagno Inferiore',0,'1800-01-01',NULL,1),
	(8540,10,'Masnago',0,'1800-01-01',NULL,1),
	(8541,10,'Menzago',0,'1800-01-01',NULL,1),
	(8542,10,'Mezzana Superiore',0,'1800-01-01',NULL,1),
	(8543,10,'Mombello Lago Maggiore',0,'1800-01-01',NULL,1),
	(8544,10,'Monate',0,'1800-01-01',NULL,1),
	(8545,10,'Montanate',0,'1800-01-01',NULL,1),
	(8546,10,'Montegrino',0,'1800-01-01',NULL,1),
	(8547,10,'Monteviasco',0,'1800-01-01',NULL,1),
	(8548,10,'Morosolo',0,'1800-01-01',NULL,1),
	(8549,10,'Muceno',0,'1800-01-01',NULL,1),
	(8550,10,'Musadino',0,'1800-01-01',NULL,1),
	(8551,10,'Musignano',0,'1800-01-01',NULL,1),
	(8552,10,'Nizzolina',0,'1800-01-01',NULL,1),
	(8553,10,'Olginasio',0,'1800-01-01',NULL,1),
	(8554,10,'Oltrona al Lago',0,'1800-01-01',NULL,1),
	(8555,10,'Oriano Sopra Ticino',0,'1800-01-01',NULL,1),
	(8556,10,'Orino-Azzio',0,'1800-01-01',NULL,1),
	(8557,10,'Peveranza',0,'1800-01-01',NULL,1),
	(8558,10,'Premezzo',0,'1800-01-01',NULL,1),
	(8559,10,'Prospiano',0,'1800-01-01',NULL,1),
	(8560,10,'Quinzano San Pietro',0,'1800-01-01',NULL,1),
	(8561,10,'Roggiano Valtravaglia',0,'1800-01-01',NULL,1),
	(8562,10,'Rovate',0,'1800-01-01',NULL,1),
	(8563,10,'Runo',0,'1800-01-01',NULL,1),
	(8564,10,'Sacconago',0,'1800-01-01',NULL,1),
	(8565,10,'San Pancrazio al Colle',0,'1800-01-01',NULL,1),
	(8566,10,'Sant',0,'1800-01-01',NULL,1),
	(8567,10,'Sant',0,'1800-01-01',NULL,1),
	(8568,10,'Santa Maria del Monte',0,'1800-01-01',NULL,1),
	(8569,10,'Schianno',0,'1800-01-01',NULL,1),
	(8570,10,'Sesona',0,'1800-01-01',NULL,1),
	(8571,10,'Solbiate sull',0,'1800-01-01',NULL,1),
	(8572,10,'Torba',0,'1800-01-01',NULL,1),
	(8573,10,'Tornavento',0,'1800-01-01',NULL,1),
	(8574,10,'Travedona',0,'1800-01-01',NULL,1),
	(8575,10,'Trevisago',0,'1800-01-01',NULL,1),
	(8576,10,'Vararo',0,'1800-01-01',NULL,1),
	(8577,10,'Veccana',0,'1800-01-01',NULL,1),
	(8578,10,'Velate',0,'1800-01-01',NULL,1),
	(8579,10,'Venegono',0,'1800-01-01',NULL,1),
	(8580,10,'Vergobbio',0,'1800-01-01',NULL,1),
	(8581,10,'Viconago',0,'1800-01-01',NULL,1),
	(8582,10,'Villa Dosia',0,'1800-01-01',NULL,1),
	(8583,10,'Vinago',0,'1800-01-01',NULL,1),
	(8584,10,'Voldomino',0,'1800-01-01',NULL,1),
	(8585,10,'Voltore',0,'1800-01-01',NULL,1),
	(8586,11,'Consiglio di Rumo',0,'1800-01-01',NULL,1),
	(8587,11,'Germasino',0,'1800-01-01',NULL,1),
	(8588,11,'Gravedona',0,'1800-01-01',NULL,1),
	(8589,11,'Sant\'Abbondio',0,'1800-01-01',NULL,1),
	(8590,11,'Santa Maria Rezzonico',0,'1800-01-01',NULL,1),
	(8591,11,'Abbadia Sopra Adda',0,'1800-01-01',NULL,1),
	(8592,11,'Acquate',0,'1800-01-01',NULL,1),
	(8593,11,'Aizurro',0,'1800-01-01',NULL,1),
	(8594,11,'Albate',0,'1800-01-01',NULL,1),
	(8595,11,'Albese',0,'1800-01-01',NULL,1),
	(8596,11,'Albogasio',0,'1800-01-01',NULL,1),
	(8597,11,'Arcellasco',0,'1800-01-01',NULL,1),
	(8598,11,'Asnago',0,'1800-01-01',NULL,1),
	(8599,11,'Bagaggera',0,'1800-01-01',NULL,1),
	(8600,11,'Baiedo',0,'1800-01-01',NULL,1),
	(8601,11,'Ballabio Inferiore',0,'1800-01-01',NULL,1),
	(8602,11,'Ballabio Superiore',0,'1800-01-01',NULL,1),
	(8603,11,'Barcone',0,'1800-01-01',NULL,1),
	(8604,11,'Bartesate',0,'1800-01-01',NULL,1),
	(8605,11,'Belledo',0,'1800-01-01',NULL,1),
	(8606,11,'Bernaga',0,'1800-01-01',NULL,1),
	(8607,11,'Bernate Rosales',0,'1800-01-01',NULL,1),
	(8608,11,'Biglio',0,'1800-01-01',NULL,1),
	(8609,11,'Bindo',0,'1800-01-01',NULL,1),
	(8610,11,'Breccia',0,'1800-01-01',NULL,1),
	(8611,11,'Breglia',0,'1800-01-01',NULL,1),
	(8612,11,'Brenno della Torre',0,'1800-01-01',NULL,1),
	(8613,11,'Brianzola',0,'1800-01-01',NULL,1),
	(8614,11,'Buccinigo',0,'1800-01-01',NULL,1),
	(8615,11,'Buggiolo',0,'1800-01-01',NULL,1),
	(8616,11,'Bugiallo',0,'1800-01-01',NULL,1),
	(8617,11,'Bulgorello',0,'1800-01-01',NULL,1),
	(8618,11,'Cagliano',0,'1800-01-01',NULL,1),
	(8619,11,'Camerlata',0,'1800-01-01',NULL,1),
	(8620,11,'Camnago Faloppia',0,'1800-01-01',NULL,1),
	(8621,11,'Camnago Volta',0,'1800-01-01',NULL,1),
	(8622,11,'Capiago',0,'1800-01-01',NULL,1),
	(8623,11,'Capiate',0,'1800-01-01',NULL,1),
	(8624,11,'Carate Lario',0,'1800-01-01',NULL,1),
	(8625,11,'Carcano',0,'1800-01-01',NULL,1),
	(8626,11,'Carella con Mariaga',0,'1800-01-01',NULL,1),
	(8627,11,'Careno',0,'1800-01-01',NULL,1),
	(8628,11,'Carlazzo Valsolda',0,'1800-01-01',NULL,1),
	(8629,11,'Carugo Arosio',0,'1800-01-01',NULL,1),
	(8630,11,'Casanova Lanza',0,'1800-01-01',NULL,1),
	(8631,11,'Casirago',0,'1800-01-01',NULL,1),
	(8632,11,'Casletto',0,'1800-01-01',NULL,1),
	(8633,11,'Caslino al Piano',0,'1800-01-01',NULL,1),
	(8634,11,'Casnate',0,'1800-01-01',NULL,1),
	(8635,11,'Cassago',0,'1800-01-01',NULL,1),
	(8636,11,'Cassano Albese',0,'1800-01-01',NULL,1),
	(8637,11,'Cassina de\' Bracchi',0,'1800-01-01',NULL,1),
	(8638,11,'Cassina Mariaga',0,'1800-01-01',NULL,1),
	(8639,11,'Castello Sopra Lecco',0,'1800-01-01',NULL,1),
	(8640,11,'Castello Valsolda',0,'1800-01-01',NULL,1),
	(8641,11,'Caversaccio',0,'1800-01-01',NULL,1),
	(8642,11,'Centemero',0,'1800-01-01',NULL,1),
	(8643,11,'Cereda',0,'1800-01-01',NULL,1),
	(8644,11,'Cernusco Montevecchia',0,'1800-01-01',NULL,1),
	(8645,11,'Cesello Brianza',0,'1800-01-01',NULL,1),
	(8646,11,'Chiuso',0,'1800-01-01',NULL,1),
	(8647,11,'Cima',0,'1800-01-01',NULL,1),
	(8648,11,'Civello',0,'1800-01-01',NULL,1),
	(8649,11,'Civiglio',0,'1800-01-01',NULL,1),
	(8650,11,'Colciago',0,'1800-01-01',NULL,1),
	(8651,11,'Cologna',0,'1800-01-01',NULL,1),
	(8652,11,'Concenedo',0,'1800-01-01',NULL,1),
	(8653,11,'Consonno',0,'1800-01-01',NULL,1),
	(8654,11,'Contra',0,'1800-01-01',NULL,1),
	(8655,11,'Corenno Plinio',0,'1800-01-01',NULL,1),
	(8656,11,'Cortabbio',0,'1800-01-01',NULL,1),
	(8657,11,'Cremnago',0,'1800-01-01',NULL,1),
	(8658,11,'Cressogno',0,'1800-01-01',NULL,1),
	(8659,11,'Crevenna',0,'1800-01-01',NULL,1),
	(8660,11,'Croce',0,'1800-01-01',NULL,1),
	(8661,11,'Dasio',0,'1800-01-01',NULL,1),
	(8662,11,'Dozio',0,'1800-01-01',NULL,1),
	(8663,11,'Drano',0,'1800-01-01',NULL,1),
	(8664,11,'Erba Incino',0,'1800-01-01',NULL,1),
	(8665,11,'Esino Inferiore',0,'1800-01-01',NULL,1),
	(8666,11,'Esino Superiore',0,'1800-01-01',NULL,1),
	(8667,11,'Fabbrica Durini',0,'1800-01-01',NULL,1),
	(8668,11,'Gaggino',0,'1800-01-01',NULL,1),
	(8669,11,'Germanedo',0,'1800-01-01',NULL,1),
	(8670,11,'Gottro',0,'1800-01-01',NULL,1),
	(8671,11,'Grandola',0,'1800-01-01',NULL,1),
	(8672,11,'Grona',0,'1800-01-01',NULL,1),
	(8673,11,'Imberido',0,'1800-01-01',NULL,1),
	(8674,11,'Incino',0,'1800-01-01',NULL,1),
	(8675,11,'Indovero',0,'1800-01-01',NULL,1),
	(8676,11,'Intimiano',0,'1800-01-01',NULL,1),
	(8677,11,'Isola Comacina',0,'1800-01-01',NULL,1),
	(8678,11,'Laorca',0,'1800-01-01',NULL,1),
	(8679,11,'Lemna',0,'1800-01-01',NULL,1),
	(8680,11,'Lezza',0,'1800-01-01',NULL,1),
	(8681,11,'Lieto Colle',0,'1800-01-01',NULL,1),
	(8682,11,'Limonta',0,'1800-01-01',NULL,1),
	(8683,11,'Linzanico',0,'1800-01-01',NULL,1),
	(8684,11,'Lomaniga',0,'1800-01-01',NULL,1),
	(8685,11,'Loveno Sopra Menaggio',0,'1800-01-01',NULL,1),
	(8686,11,'Lucino',0,'1800-01-01',NULL,1),
	(8687,11,'Maccio',0,'1800-01-01',NULL,1),
	(8688,11,'Maggianico',0,'1800-01-01',NULL,1),
	(8689,11,'Minoprio',0,'1800-01-01',NULL,1),
	(8690,11,'Mirabello Comasco',0,'1800-01-01',NULL,1),
	(8691,11,'Moiana',0,'1800-01-01',NULL,1),
	(8692,11,'Molina',0,'1800-01-01',NULL,1),
	(8693,11,'Mondonico',0,'1800-01-01',NULL,1),
	(8694,11,'Montano Comasco',0,'1800-01-01',NULL,1),
	(8695,11,'Monte Olimpino',0,'1800-01-01',NULL,1),
	(8696,11,'Nava',0,'1800-01-01',NULL,1),
	(8697,11,'Novate Brianza',0,'1800-01-01',NULL,1),
	(8698,11,'Olate',0,'1800-01-01',NULL,1),
	(8699,11,'Olcio',0,'1800-01-01',NULL,1),
	(8700,11,'Onno',0,'1800-01-01',NULL,1),
	(8701,11,'Oriano di Brianza',0,'1800-01-01',NULL,1),
	(8702,11,'Pagnano Valsassina',0,'1800-01-01',NULL,1),
	(8703,11,'Palanzo',0,'1800-01-01',NULL,1),
	(8704,11,'Parravicino',0,'1800-01-01',NULL,1),
	(8705,11,'Penzano',0,'1800-01-01',NULL,1),
	(8706,11,'Pessina Valsassina',0,'1800-01-01',NULL,1),
	(8707,11,'Piano Porlezza',0,'1800-01-01',NULL,1),
	(8708,11,'Piazza Santo Stefano',0,'1800-01-01',NULL,1),
	(8709,11,'Ponte Lambro',0,'1800-01-01',NULL,1),
	(8710,11,'Ponzate',0,'1800-01-01',NULL,1),
	(8711,11,'Puria',0,'1800-01-01',NULL,1),
	(8712,11,'Ramponio',0,'1800-01-01',NULL,1),
	(8713,11,'Rancio di Lecco',0,'1800-01-01',NULL,1),
	(8714,11,'Ravellino',0,'1800-01-01',NULL,1),
	(8715,11,'Rebbio',0,'1800-01-01',NULL,1),
	(8716,11,'Rezzonico',0,'1800-01-01',NULL,1),
	(8717,11,'Roman',0,'1800-01-01',NULL,1),
	(8718,11,'Rongio',0,'1800-01-01',NULL,1),
	(8719,11,'Rovenna',0,'1800-01-01',NULL,1),
	(8720,11,'Sabbioncello',0,'1800-01-01',NULL,1),
	(8721,11,'Sala al Barro',0,'1800-01-01',NULL,1),
	(8722,11,'San Bartolomeo al Bosco',0,'1800-01-01',NULL,1),
	(8723,11,'San Giovanni alla Castagna',0,'1800-01-01',NULL,1),
	(8724,11,'San Siro',0,'1800-01-01',NULL,1),
	(8725,11,'Santa Maria di Rovagnate',0,'1800-01-01',NULL,1),
	(8726,11,'Santa Valeria',0,'1800-01-01',NULL,1),
	(8727,11,'Sartirana Briantea',0,'1800-01-01',NULL,1),
	(8728,11,'Scarenna',0,'1800-01-01',NULL,1),
	(8729,11,'Scaria',0,'1800-01-01',NULL,1),
	(8730,11,'Seghebbia',0,'1800-01-01',NULL,1),
	(8731,11,'Seprio',0,'1800-01-01',NULL,1),
	(8732,11,'Solzago',0,'1800-01-01',NULL,1),
	(8733,11,'Somana',0,'1800-01-01',NULL,1),
	(8734,11,'Stazzona Germasino',0,'1800-01-01',NULL,1),
	(8735,11,'Tavordo',0,'1800-01-01',NULL,1),
	(8736,11,'Traversa',0,'1800-01-01',NULL,1),
	(8737,11,'Tregolo',0,'1800-01-01',NULL,1),
	(8738,11,'Tremezzina',0,'1800-01-01',NULL,1),
	(8739,11,'Trevano',0,'1800-01-01',NULL,1),
	(8740,11,'Uggiate',0,'1800-01-01',NULL,1),
	(8741,11,'Urio',0,'1800-01-01',NULL,1),
	(8742,11,'Vassena',0,'1800-01-01',NULL,1),
	(8743,11,'Verderio',0,'1800-01-01',NULL,1),
	(8744,11,'Verna',0,'1800-01-01',NULL,1),
	(8745,11,'Vertemate',0,'1800-01-01',NULL,1),
	(8746,11,'Vill',0,'1800-01-01',NULL,1),
	(8747,11,'Villa Roman',0,'1800-01-01',NULL,1),
	(8748,11,'Villa Vergano',0,'1800-01-01',NULL,1),
	(8749,11,'Vimogno',0,'1800-01-01',NULL,1),
	(8750,11,'Visino',0,'1800-01-01',NULL,1),
	(8751,11,'Zelbio-Veleso',0,'1800-01-01',NULL,1),
	(8752,12,'Acqua',0,'1800-01-01',NULL,1),
	(8753,12,'Boffetto',0,'1800-01-01',NULL,1),
	(8754,12,'Campovico',0,'1800-01-01',NULL,1),
	(8755,13,'Affori',0,'1800-01-01',NULL,1),
	(8756,13,'Agliate',0,'1800-01-01',NULL,1),
	(8757,13,'Arcagna',0,'1800-01-01',NULL,1),
	(8758,13,'Baggio',0,'1800-01-01',NULL,1),
	(8759,13,'Balsamo',0,'1800-01-01',NULL,1),
	(8760,13,'Baranzate',0,'1800-01-01',NULL,1),
	(8761,13,'Barate',0,'1800-01-01',NULL,1),
	(8762,13,'Barbajana',0,'1800-01-01',NULL,1),
	(8763,13,'Bargano',0,'1800-01-01',NULL,1),
	(8764,13,'Bestazzo',0,'1800-01-01',NULL,1),
	(8765,13,'Bienate',0,'1800-01-01',NULL,1),
	(8766,13,'Binzago',0,'1800-01-01',NULL,1),
	(8767,13,'Birago',0,'1800-01-01',NULL,1),
	(8768,13,'Bisentrate',0,'1800-01-01',NULL,1),
	(8769,13,'Boldinasco',0,'1800-01-01',NULL,1),
	(8770,13,'Bolgiano',0,'1800-01-01',NULL,1),
	(8771,13,'Bonirola',0,'1800-01-01',NULL,1),
	(8772,13,'Bornago',0,'1800-01-01',NULL,1),
	(8773,13,'Bottedo',0,'1800-01-01',NULL,1),
	(8774,13,'Briavacca',0,'1800-01-01',NULL,1),
	(8775,13,'Brusuglio',0,'1800-01-01',NULL,1),
	(8776,13,'Bruzzano dei Due Borghi',0,'1800-01-01',NULL,1),
	(8777,13,'Bustighera',0,'1800-01-01',NULL,1),
	(8778,13,'Ca\' de\' Mazzi',0,'1800-01-01',NULL,1),
	(8779,13,'Ca\' de\' Zecchi',0,'1800-01-01',NULL,1),
	(8780,13,'Ca\' dei Bolli',0,'1800-01-01',NULL,1),
	(8781,13,'Ca\' dell\'Acqua',0,'1800-01-01',NULL,1),
	(8782,13,'Cal',0,'1800-01-01',NULL,1),
	(8783,13,'Campolungo',0,'1800-01-01',NULL,1),
	(8784,13,'Capriano di Brianza',0,'1800-01-01',NULL,1),
	(8785,13,'Caselle d\'Ozero',0,'1800-01-01',NULL,1),
	(8786,13,'Casirate Olona',0,'1800-01-01',NULL,1),
	(8787,13,'Casolate',0,'1800-01-01',NULL,1),
	(8788,13,'Casone',0,'1800-01-01',NULL,1),
	(8789,13,'Cassina Aliprandi',0,'1800-01-01',NULL,1),
	(8790,13,'Cassina Amata',0,'1800-01-01',NULL,1),
	(8791,13,'Cassina Baraggia',0,'1800-01-01',NULL,1),
	(8792,13,'Cassina de\' Gatti',0,'1800-01-01',NULL,1),
	(8793,13,'Cassina Nuova',0,'1800-01-01',NULL,1),
	(8794,13,'Cassina Pobbia',0,'1800-01-01',NULL,1),
	(8795,13,'Cassina Savina',0,'1800-01-01',NULL,1),
	(8796,13,'Cassina Triulza',0,'1800-01-01',NULL,1),
	(8797,13,'Cassino d\'Alberi',0,'1800-01-01',NULL,1),
	(8798,13,'Castellazzo de\' Barzi',0,'1800-01-01',NULL,1),
	(8799,13,'Castelletto Mendosio',0,'1800-01-01',NULL,1),
	(8800,13,'Castiraga da Reggio',0,'1800-01-01',NULL,1),
	(8801,13,'Cavaione',0,'1800-01-01',NULL,1),
	(8802,13,'Caviaga',0,'1800-01-01',NULL,1),
	(8803,13,'Cazzano Besana',0,'1800-01-01',NULL,1),
	(8804,13,'Ceppeda',0,'1800-01-01',NULL,1),
	(8805,13,'Cerchiate',0,'1800-01-01',NULL,1),
	(8806,13,'Chiaravalle Milanese',0,'1800-01-01',NULL,1),
	(8807,13,'Chiosi d\'Adda Vigadore',0,'1800-01-01',NULL,1),
	(8808,13,'Chiosi di Porta Cremonese',0,'1800-01-01',NULL,1),
	(8809,13,'Chiosi di Porta d\'Adda',0,'1800-01-01',NULL,1),
	(8810,13,'Chiosi di Porta Regale',0,'1800-01-01',NULL,1),
	(8811,13,'Chiosi Uniti con Bottedo',0,'1800-01-01',NULL,1),
	(8812,13,'Cinisello',0,'1800-01-01',NULL,1),
	(8813,13,'Coazzano',0,'1800-01-01',NULL,1),
	(8814,13,'Colnago',0,'1800-01-01',NULL,1),
	(8815,13,'Colzano',0,'1800-01-01',NULL,1),
	(8816,13,'Concesa',0,'1800-01-01',NULL,1),
	(8817,13,'Copreno',0,'1800-01-01',NULL,1),
	(8818,13,'Corneliano Bertario',0,'1800-01-01',NULL,1),
	(8819,13,'Corpi Santi di Milano',0,'1800-01-01',NULL,1),
	(8820,13,'Corte Sant\'Andrea',0,'1800-01-01',NULL,1),
	(8821,13,'Costa al Lambro',0,'1800-01-01',NULL,1),
	(8822,13,'Crescenzago',0,'1800-01-01',NULL,1),
	(8823,13,'Dergano',0,'1800-01-01',NULL,1),
	(8824,13,'Dugnano',0,'1800-01-01',NULL,1),
	(8825,13,'Fagnano sul Naviglio',0,'1800-01-01',NULL,1),
	(8826,13,'Figino di Milano',0,'1800-01-01',NULL,1),
	(8827,13,'Furato',0,'1800-01-01',NULL,1),
	(8828,13,'Garbatola',0,'1800-01-01',NULL,1),
	(8829,13,'Garegnano',0,'1800-01-01',NULL,1),
	(8830,13,'Gattera Maiocca',0,'1800-01-01',NULL,1),
	(8831,13,'Gorlaprecotto',0,'1800-01-01',NULL,1),
	(8832,13,'Grancino',0,'1800-01-01',NULL,1),
	(8833,13,'Grazzanello',0,'1800-01-01',NULL,1),
	(8834,13,'Greco Milanese',0,'1800-01-01',NULL,1),
	(8835,13,'Groppello d\'Adda',0,'1800-01-01',NULL,1),
	(8836,13,'Guazzina',0,'1800-01-01',NULL,1),
	(8837,13,'Gugnano',0,'1800-01-01',NULL,1),
	(8838,13,'Incirano',0,'1800-01-01',NULL,1),
	(8839,13,'Induno Ticino',0,'1800-01-01',NULL,1),
	(8840,13,'Isola Balba',0,'1800-01-01',NULL,1),
	(8841,13,'Lambrate',0,'1800-01-01',NULL,1),
	(8842,13,'Lardera',0,'1800-01-01',NULL,1),
	(8843,13,'Limito',0,'1800-01-01',NULL,1),
	(8844,13,'Linate al Lambro',0,'1800-01-01',NULL,1),
	(8845,13,'Lucernate',0,'1800-01-01',NULL,1),
	(8846,13,'Marcallo',0,'1800-01-01',NULL,1),
	(8847,13,'Masciago Milanese',0,'1800-01-01',NULL,1),
	(8848,13,'Mazzo Milanese',0,'1800-01-01',NULL,1),
	(8849,13,'Melegnanello',0,'1800-01-01',NULL,1),
	(8850,13,'Mercugnano',0,'1800-01-01',NULL,1),
	(8851,13,'Mettone',0,'1800-01-01',NULL,1),
	(8852,13,'Mezzana Casati',0,'1800-01-01',NULL,1),
	(8853,13,'Mezzano Passone',0,'1800-01-01',NULL,1),
	(8854,13,'Mignette',0,'1800-01-01',NULL,1),
	(8855,13,'Mirabello San Bernardino',0,'1800-01-01',NULL,1),
	(8856,13,'Moncucco di Monza',0,'1800-01-01',NULL,1),
	(8857,13,'Moncucco Vecchio',0,'1800-01-01',NULL,1),
	(8858,13,'Mongiardino Sillaro',0,'1800-01-01',NULL,1),
	(8859,13,'Montesiro',0,'1800-01-01',NULL,1),
	(8860,13,'Morsenchio',0,'1800-01-01',NULL,1),
	(8861,13,'Motta Vigana',0,'1800-01-01',NULL,1),
	(8862,13,'Muggiano',0,'1800-01-01',NULL,1),
	(8863,13,'Musocco',0,'1800-01-01',NULL,1),
	(8864,13,'Niguarda',0,'1800-01-01',NULL,1),
	(8865,13,'Nosedo',0,'1800-01-01',NULL,1),
	(8866,13,'Novegro',0,'1800-01-01',NULL,1),
	(8867,13,'Omate',0,'1800-01-01',NULL,1),
	(8868,13,'Oreno',0,'1800-01-01',NULL,1),
	(8869,13,'Paina',0,'1800-01-01',NULL,1),
	(8870,13,'Palazzolo Milanese',0,'1800-01-01',NULL,1),
	(8871,13,'Passirana Milanese',0,'1800-01-01',NULL,1),
	(8872,13,'Pasturago',0,'1800-01-01',NULL,1),
	(8873,13,'Pedriano',0,'1800-01-01',NULL,1),
	(8874,13,'Pezzolo de\' Codazzi',0,'1800-01-01',NULL,1),
	(8875,13,'Pezzolo di Tavazzano',0,'1800-01-01',NULL,1),
	(8876,13,'Pinzano',0,'1800-01-01',NULL,1),
	(8877,13,'Pizzolano',0,'1800-01-01',NULL,1),
	(8878,13,'Pontesesto',0,'1800-01-01',NULL,1),
	(8879,13,'Porto d\'Adda',0,'1800-01-01',NULL,1),
	(8880,13,'Precotto',0,'1800-01-01',NULL,1),
	(8881,13,'Premenugo',0,'1800-01-01',NULL,1),
	(8882,13,'Quartiano',0,'1800-01-01',NULL,1),
	(8883,13,'Quarto Cagnino',0,'1800-01-01',NULL,1),
	(8884,13,'Quinto Romano',0,'1800-01-01',NULL,1),
	(8885,13,'Quintosole',0,'1800-01-01',NULL,1),
	(8886,13,'Regina Fittarezza',0,'1800-01-01',NULL,1),
	(8887,13,'Rescalda',0,'1800-01-01',NULL,1),
	(8888,13,'Riozzo',0,'1800-01-01',NULL,1),
	(8889,13,'Robbiano',0,'1800-01-01',NULL,1),
	(8890,13,'Robecchetto',0,'1800-01-01',NULL,1),
	(8891,13,'Robecco Lodigiano',0,'1800-01-01',NULL,1),
	(8892,13,'Ronchetto',0,'1800-01-01',NULL,1),
	(8893,13,'Roserio',0,'1800-01-01',NULL,1),
	(8894,13,'Rovagnasco',0,'1800-01-01',NULL,1),
	(8895,13,'Ruginello',0,'1800-01-01',NULL,1),
	(8896,13,'San Damiano di Monza',0,'1800-01-01',NULL,1),
	(8897,13,'San Giuliano',0,'1800-01-01',NULL,1),
	(8898,13,'San Novo',0,'1800-01-01',NULL,1),
	(8899,13,'San Pedrino',0,'1800-01-01',NULL,1),
	(8900,13,'San Pietro Bestazzo',0,'1800-01-01',NULL,1),
	(8901,13,'San Pietro Cusico',0,'1800-01-01',NULL,1),
	(8902,13,'San Vito e Marta',0,'1800-01-01',NULL,1),
	(8903,13,'Sant',0,'1800-01-01',NULL,1),
	(8904,13,'Santa Maria in Prato',0,'1800-01-01',NULL,1),
	(8905,13,'Sellanuova',0,'1800-01-01',NULL,1),
	(8906,13,'Sesto Pergola',0,'1800-01-01',NULL,1),
	(8907,13,'Sesto Ulteriano',0,'1800-01-01',NULL,1),
	(8908,13,'Soltarico',0,'1800-01-01',NULL,1),
	(8909,13,'Sulbiate Inferiore',0,'1800-01-01',NULL,1),
	(8910,13,'Sulbiate Superiore',0,'1800-01-01',NULL,1),
	(8911,13,'Tainate',0,'1800-01-01',NULL,1),
	(8912,13,'Tavazzano',0,'1800-01-01',NULL,1),
	(8913,13,'Terrazzano',0,'1800-01-01',NULL,1),
	(8914,13,'Tormo',0,'1800-01-01',NULL,1),
	(8915,13,'Trecella',0,'1800-01-01',NULL,1),
	(8916,13,'Tregasio',0,'1800-01-01',NULL,1),
	(8917,13,'Trenno',0,'1800-01-01',NULL,1),
	(8918,13,'Trivulza',0,'1800-01-01',NULL,1),
	(8919,13,'Trivulzina',0,'1800-01-01',NULL,1),
	(8920,13,'Turro Milanese',0,'1800-01-01',NULL,1),
	(8921,13,'Usmate',0,'1800-01-01',NULL,1),
	(8922,13,'Vaiano Valle',0,'1800-01-01',NULL,1),
	(8923,13,'Valle Guidino',0,'1800-01-01',NULL,1),
	(8924,13,'Veduggio',0,'1800-01-01',NULL,1),
	(8925,13,'Vergo',0,'1800-01-01',NULL,1),
	(8926,13,'Vidardo',0,'1800-01-01',NULL,1),
	(8927,13,'Vigadore',0,'1800-01-01',NULL,1),
	(8928,13,'Vigan',0,'1800-01-01',NULL,1),
	(8929,13,'Vigentino',0,'1800-01-01',NULL,1),
	(8930,13,'Vigonzino',0,'1800-01-01',NULL,1),
	(8931,13,'Villa Pizzone',0,'1800-01-01',NULL,1),
	(8932,13,'Villa Pompeiana',0,'1800-01-01',NULL,1),
	(8933,13,'Villa Raverio',0,'1800-01-01',NULL,1),
	(8934,13,'Villanova Vimercate',0,'1800-01-01',NULL,1),
	(8935,13,'Villarossa',0,'1800-01-01',NULL,1),
	(8936,13,'Vittadone',0,'1800-01-01',NULL,1),
	(8937,13,'Zelo Foramagno',0,'1800-01-01',NULL,1),
	(8938,13,'Zivido',0,'1800-01-01',NULL,1),
	(8939,13,'Zorlesco',0,'1800-01-01',NULL,1),
	(8940,14,'Riviera d\'Adda',0,'1800-01-01',NULL,1),
	(8941,14,'Albegno',0,'1800-01-01',NULL,1),
	(8942,14,'Alzano di Sopra',0,'1800-01-01',NULL,1),
	(8943,14,'Alzano Maggiore',0,'1800-01-01',NULL,1),
	(8944,14,'Baresi',0,'1800-01-01',NULL,1),
	(8945,14,'Barsizza',0,'1800-01-01',NULL,1),
	(8946,14,'Bondione',0,'1800-01-01',NULL,1),
	(8947,14,'Bondo Petello',0,'1800-01-01',NULL,1),
	(8948,14,'Bordogna',0,'1800-01-01',NULL,1),
	(8949,14,'Borgounito',0,'1800-01-01',NULL,1),
	(8950,14,'Brembate di Sotto',0,'1800-01-01',NULL,1),
	(8951,14,'Bruntino',0,'1800-01-01',NULL,1),
	(8952,14,'Calepio',0,'1800-01-01',NULL,1),
	(8953,14,'Capriate d\'Adda',0,'1800-01-01',NULL,1),
	(8954,14,'Carobbio',0,'1800-01-01',NULL,1),
	(8955,14,'Cenate',0,'1800-01-01',NULL,1),
	(8956,14,'Cenate d\'Argon',0,'1800-01-01',NULL,1),
	(8957,14,'Centrisola',0,'1800-01-01',NULL,1),
	(8958,14,'Cepino',0,'1800-01-01',NULL,1),
	(8959,14,'Colognola del Piano',0,'1800-01-01',NULL,1),
	(8960,14,'Corte',0,'1800-01-01',NULL,1),
	(8961,14,'Curdomo',0,'1800-01-01',NULL,1),
	(8962,14,'Curnasco',0,'1800-01-01',NULL,1),
	(8963,14,'Desenzano al Serio',0,'1800-01-01',NULL,1),
	(8964,14,'Dezzo di Scalve',0,'1800-01-01',NULL,1),
	(8965,14,'Endenna',0,'1800-01-01',NULL,1),
	(8966,14,'Endine',0,'1800-01-01',NULL,1),
	(8967,14,'Esmate',0,'1800-01-01',NULL,1),
	(8968,14,'Filago',0,'1800-01-01',NULL,1),
	(8969,14,'Fiumenero',0,'1800-01-01',NULL,1),
	(8970,14,'Fondra',0,'1800-01-01',NULL,1),
	(8971,14,'Frerola',0,'1800-01-01',NULL,1),
	(8972,14,'Fuipiano al Brembo',0,'1800-01-01',NULL,1),
	(8973,14,'Grignano',0,'1800-01-01',NULL,1),
	(8974,14,'Grumello de\' Zanchi',0,'1800-01-01',NULL,1),
	(8975,14,'Grumello del Piano',0,'1800-01-01',NULL,1),
	(8976,14,'Lizzola',0,'1800-01-01',NULL,1),
	(8977,14,'Locate Bergamasco',0,'1800-01-01',NULL,1),
	(8978,14,'Lorentino',0,'1800-01-01',NULL,1),
	(8979,14,'Mariano al Brembo',0,'1800-01-01',NULL,1),
	(8980,14,'Massari Melzi',0,'1800-01-01',NULL,1),
	(8981,14,'Mazzoleni e Falghera',0,'1800-01-01',NULL,1),
	(8982,14,'Molini di Colognola',0,'1800-01-01',NULL,1),
	(8983,14,'Nese',0,'1800-01-01',NULL,1),
	(8984,14,'Oltrepovo',0,'1800-01-01',NULL,1),
	(8985,14,'Oltressenda Bassa',0,'1800-01-01',NULL,1),
	(8986,14,'Orezzo',0,'1800-01-01',NULL,1),
	(8987,14,'Ossanesga',0,'1800-01-01',NULL,1),
	(8988,14,'Pian Gaiano',0,'1800-01-01',NULL,1),
	(8989,14,'Piazzo Alto',0,'1800-01-01',NULL,1),
	(8990,14,'Piazzo Basso',0,'1800-01-01',NULL,1),
	(8991,14,'Poscante',0,'1800-01-01',NULL,1),
	(8992,14,'Redona',0,'1800-01-01',NULL,1),
	(8993,14,'Rigosa',0,'1800-01-01',NULL,1),
	(8994,14,'Rocca del Colle',0,'1800-01-01',NULL,1),
	(8995,14,'Rosciate',0,'1800-01-01',NULL,1),
	(8996,14,'Rossino',0,'1800-01-01',NULL,1),
	(8997,14,'Rota Dentro',0,'1800-01-01',NULL,1),
	(8998,14,'Rota Fuori',0,'1800-01-01',NULL,1),
	(8999,14,'Rovetta con Fino',0,'1800-01-01',NULL,1),
	(9000,14,'Sabbio Bergamasco',0,'1800-01-01',NULL,1),
	(9001,14,'San Gallo',0,'1800-01-01',NULL,1),
	(9002,14,'San Gervasio d\'Adda',0,'1800-01-01',NULL,1),
	(9003,14,'San Martino de\' Calvi',0,'1800-01-01',NULL,1),
	(9004,14,'San Pietro d\'Orzio',0,'1800-01-01',NULL,1),
	(9005,14,'Sant',0,'1800-01-01',NULL,1),
	(9006,14,'Santo Stefano del Monte degli Angeli',0,'1800-01-01',NULL,1),
	(9007,14,'Scano al Brembo',0,'1800-01-01',NULL,1),
	(9008,14,'Scanzo',0,'1800-01-01',NULL,1),
	(9009,14,'Selino',0,'1800-01-01',NULL,1),
	(9010,14,'Sellere',0,'1800-01-01',NULL,1),
	(9011,14,'Sforzatica',0,'1800-01-01',NULL,1),
	(9012,14,'Solto',0,'1800-01-01',NULL,1),
	(9013,14,'Sombreno',0,'1800-01-01',NULL,1),
	(9014,14,'Somendenna',0,'1800-01-01',NULL,1),
	(9015,14,'Spino al Brembo',0,'1800-01-01',NULL,1),
	(9016,14,'Spinone',0,'1800-01-01',NULL,1),
	(9017,14,'Stabello',0,'1800-01-01',NULL,1),
	(9018,14,'Tagliuno',0,'1800-01-01',NULL,1),
	(9019,14,'Trabuchello',0,'1800-01-01',NULL,1),
	(9020,14,'Vall',0,'1800-01-01',NULL,1),
	(9021,14,'Valtesse',0,'1800-01-01',NULL,1),
	(9022,14,'Villongo San Filastro',0,'1800-01-01',NULL,1),
	(9023,14,'Villongo Sant',0,'1800-01-01',NULL,1),
	(9024,14,'Vilminore',0,'1800-01-01',NULL,1),
	(9025,14,'Zorzino',0,'1800-01-01',NULL,1),
	(9026,14,'Calolzio',0,'1800-01-01',NULL,1),
	(9027,15,'Acqualunga',0,'1800-01-01',NULL,1),
	(9028,15,'Alone',0,'1800-01-01',NULL,1),
	(9029,15,'Anfurro',0,'1800-01-01',NULL,1),
	(9030,15,'Armo',0,'1800-01-01',NULL,1),
	(9031,15,'Avenone',0,'1800-01-01',NULL,1),
	(9032,15,'Barco',0,'1800-01-01',NULL,1),
	(9033,15,'Bel Prato',0,'1800-01-01',NULL,1),
	(9034,15,'Bollone',0,'1800-01-01',NULL,1),
	(9035,15,'Borgonato',0,'1800-01-01',NULL,1),
	(9036,15,'Bornato',0,'1800-01-01',NULL,1),
	(9037,15,'Botticino Mattina',0,'1800-01-01',NULL,1),
	(9038,15,'Botticino Sera',0,'1800-01-01',NULL,1),
	(9039,15,'Brozzo',0,'1800-01-01',NULL,1),
	(9040,15,'Burago Riviera',0,'1800-01-01',NULL,1),
	(9041,15,'Cadignano',0,'1800-01-01',NULL,1),
	(9042,15,'Cajonvico',0,'1800-01-01',NULL,1),
	(9043,15,'Calino',0,'1800-01-01',NULL,1),
	(9044,15,'Camignone',0,'1800-01-01',NULL,1),
	(9045,15,'Campoverde',0,'1800-01-01',NULL,1),
	(9046,15,'Carcina',0,'1800-01-01',NULL,1),
	(9047,15,'Carzago della Riviera',0,'1800-01-01',NULL,1),
	(9048,15,'Castrezzone',0,'1800-01-01',NULL,1),
	(9049,15,'Ceto-Cerveno',0,'1800-01-01',NULL,1),
	(9050,15,'Cignano',0,'1800-01-01',NULL,1),
	(9051,15,'Ciliverghe',0,'1800-01-01',NULL,1),
	(9052,15,'Cimbergo-Paspardo',0,'1800-01-01',NULL,1),
	(9053,15,'Cividate Malegno',0,'1800-01-01',NULL,1),
	(9054,15,'Cizzago',0,'1800-01-01',NULL,1),
	(9055,15,'Clusane sul Lago',0,'1800-01-01',NULL,1),
	(9056,15,'Colombaro',0,'1800-01-01',NULL,1),
	(9057,15,'Comero',0,'1800-01-01',NULL,1),
	(9058,15,'Comezzano',0,'1800-01-01',NULL,1),
	(9059,15,'Cortenedolo',0,'1800-01-01',NULL,1),
	(9060,15,'Corticelle Pieve',0,'1800-01-01',NULL,1),
	(9061,15,'Cossirano',0,'1800-01-01',NULL,1),
	(9062,15,'Cremezzano',0,'1800-01-01',NULL,1),
	(9063,15,'Degagna',0,'1800-01-01',NULL,1),
	(9064,15,'Erbanno',0,'1800-01-01',NULL,1),
	(9065,15,'Farvengo',0,'1800-01-01',NULL,1),
	(9066,15,'Faverzano',0,'1800-01-01',NULL,1),
	(9067,15,'Fiumicello Urago',0,'1800-01-01',NULL,1),
	(9068,15,'Folzano',0,'1800-01-01',NULL,1),
	(9069,15,'Frontignano',0,'1800-01-01',NULL,1),
	(9070,15,'Gerolanuova',0,'1800-01-01',NULL,1),
	(9071,15,'Goglione Sopra',0,'1800-01-01',NULL,1),
	(9072,15,'Goglione Sotto',0,'1800-01-01',NULL,1),
	(9073,15,'Gorzone',0,'1800-01-01',NULL,1),
	(9074,15,'Inzino',0,'1800-01-01',NULL,1),
	(9075,15,'Levrange',0,'1800-01-01',NULL,1),
	(9076,15,'Livemmo',0,'1800-01-01',NULL,1),
	(9077,15,'Loveno Grumello',0,'1800-01-01',NULL,1),
	(9078,15,'Ludriano',0,'1800-01-01',NULL,1),
	(9079,15,'Lumezzane Pieve',0,'1800-01-01',NULL,1),
	(9080,15,'Lumezzane San Sebastiano',0,'1800-01-01',NULL,1),
	(9081,15,'Lumezzane Sant',0,'1800-01-01',NULL,1),
	(9082,15,'Maderno',0,'1800-01-01',NULL,1),
	(9083,15,'Magno Sopra Inzino',0,'1800-01-01',NULL,1),
	(9084,15,'Mazzunno',0,'1800-01-01',NULL,1),
	(9085,15,'Milzanello',0,'1800-01-01',NULL,1),
	(9086,15,'Moerna',0,'1800-01-01',NULL,1),
	(9087,15,'Mompiano',0,'1800-01-01',NULL,1),
	(9088,15,'Mu',0,'1800-01-01',NULL,1),
	(9089,15,'Navono',0,'1800-01-01',NULL,1),
	(9090,15,'Nigoline',0,'1800-01-01',NULL,1),
	(9091,15,'Nozza',0,'1800-01-01',NULL,1),
	(9092,15,'Ono Degno',0,'1800-01-01',NULL,1),
	(9093,15,'Oriano',0,'1800-01-01',NULL,1),
	(9094,15,'Padernello',0,'1800-01-01',NULL,1),
	(9095,15,'Paisco',0,'1800-01-01',NULL,1),
	(9096,15,'Persone',0,'1800-01-01',NULL,1),
	(9097,15,'Peschiera Maraglio',0,'1800-01-01',NULL,1),
	(9098,15,'Pezzoro',0,'1800-01-01',NULL,1),
	(9099,15,'Pilzone',0,'1800-01-01',NULL,1),
	(9100,15,'Poncarale Flero',0,'1800-01-01',NULL,1),
	(9101,15,'Pontagna',0,'1800-01-01',NULL,1),
	(9102,15,'Portese',0,'1800-01-01',NULL,1),
	(9103,15,'Porzano',0,'1800-01-01',NULL,1),
	(9104,15,'Prandaglio',0,'1800-01-01',NULL,1),
	(9105,15,'Presegno',0,'1800-01-01',NULL,1),
	(9106,15,'Provaglio Sopra',0,'1800-01-01',NULL,1),
	(9107,15,'Provaglio Sotto',0,'1800-01-01',NULL,1),
	(9108,15,'Provezze',0,'1800-01-01',NULL,1),
	(9109,15,'Quinzanello',0,'1800-01-01',NULL,1),
	(9110,15,'Raffa',0,'1800-01-01',NULL,1),
	(9111,15,'Remedello Sopra',0,'1800-01-01',NULL,1),
	(9112,15,'Remedello Sotto',0,'1800-01-01',NULL,1),
	(9113,15,'Rivoltella',0,'1800-01-01',NULL,1),
	(9114,15,'Rodengo',0,'1800-01-01',NULL,1),
	(9115,15,'Saiano',0,'1800-01-01',NULL,1),
	(9116,15,'San Bartolomeo',0,'1800-01-01',NULL,1),
	(9117,15,'San Felice di Scovolo',0,'1800-01-01',NULL,1),
	(9118,15,'San Nazzaro Mella',0,'1800-01-01',NULL,1),
	(9119,15,'San Vigilio',0,'1800-01-01',NULL,1),
	(9120,15,'Sant',0,'1800-01-01',NULL,1),
	(9121,15,'Sant',0,'1800-01-01',NULL,1),
	(9122,15,'Santicolo',0,'1800-01-01',NULL,1),
	(9123,15,'Scarpizzolo',0,'1800-01-01',NULL,1),
	(9124,15,'Siviano',0,'1800-01-01',NULL,1),
	(9125,15,'Sopraponte',0,'1800-01-01',NULL,1),
	(9126,15,'Soprazocco',0,'1800-01-01',NULL,1),
	(9127,15,'Terzano',0,'1800-01-01',NULL,1),
	(9128,15,'Timoline',0,'1800-01-01',NULL,1),
	(9129,15,'Torbiato',0,'1800-01-01',NULL,1),
	(9130,15,'Toscolano',0,'1800-01-01',NULL,1),
	(9131,15,'Urago Mella',0,'1800-01-01',NULL,1),
	(9132,15,'Valsaviore',0,'1800-01-01',NULL,1),
	(9133,15,'Vello',0,'1800-01-01',NULL,1),
	(9134,15,'Villa Cogozzo',0,'1800-01-01',NULL,1),
	(9135,15,'Villa d',0,'1800-01-01',NULL,1),
	(9136,15,'Virle Treponti',0,'1800-01-01',NULL,1),
	(9137,16,'Barona',0,'1800-01-01',NULL,1),
	(9138,16,'Baselica Bologna',0,'1800-01-01',NULL,1),
	(9139,16,'Belvedere al Po',0,'1800-01-01',NULL,1),
	(9140,16,'Bottarone',0,'1800-01-01',NULL,1),
	(9141,16,'Branduzzo',0,'1800-01-01',NULL,1),
	(9142,16,'Bressana',0,'1800-01-01',NULL,1),
	(9143,16,'Buttirago',0,'1800-01-01',NULL,1),
	(9144,16,'Ca\' de\' Tedioli',0,'1800-01-01',NULL,1),
	(9145,16,'Ca\' della Terra',0,'1800-01-01',NULL,1),
	(9146,16,'Cairo Lomellino',0,'1800-01-01',NULL,1),
	(9147,16,'Calignano',0,'1800-01-01',NULL,1),
	(9148,16,'Cambi',0,'1800-01-01',NULL,1),
	(9149,16,'Campomorto',0,'1800-01-01',NULL,1),
	(9150,16,'Camporinaldo',0,'1800-01-01',NULL,1),
	(9151,16,'Campospinoso Albaredo',0,'1800-01-01',NULL,1),
	(9152,16,'Cantonale',0,'1800-01-01',NULL,1),
	(9153,16,'Carpignago',0,'1800-01-01',NULL,1),
	(9154,16,'Casatico',0,'1800-01-01',NULL,1),
	(9155,16,'Cassine Calderari',0,'1800-01-01',NULL,1),
	(9156,16,'Cassine Sirigari',0,'1800-01-01',NULL,1),
	(9157,16,'Cassine Tolentine',0,'1800-01-01',NULL,1),
	(9158,16,'Cassino Po',0,'1800-01-01',NULL,1),
	(9159,16,'Castel Lambro',0,'1800-01-01',NULL,1),
	(9160,16,'Castellaro de\' Giorgi',0,'1800-01-01',NULL,1),
	(9161,16,'Castelletto Po',0,'1800-01-01',NULL,1),
	(9162,16,'Cavagnera',0,'1800-01-01',NULL,1),
	(9163,16,'Cella di Bobbio',0,'1800-01-01',NULL,1),
	(9164,16,'Celpenchio',0,'1800-01-01',NULL,1),
	(9165,16,'Comairano',0,'1800-01-01',NULL,1),
	(9166,16,'Corbesate',0,'1800-01-01',NULL,1),
	(9167,16,'Corpi Santi di Pavia',0,'1800-01-01',NULL,1),
	(9168,16,'Donelasco',0,'1800-01-01',NULL,1),
	(9169,16,'Fossarmato',0,'1800-01-01',NULL,1),
	(9170,16,'Gerrechiozzo',0,'1800-01-01',NULL,1),
	(9171,16,'Giovenzano',0,'1800-01-01',NULL,1),
	(9172,16,'Goido',0,'1800-01-01',NULL,1),
	(9173,16,'Gualdrasco',0,'1800-01-01',NULL,1),
	(9174,16,'Guinzano',0,'1800-01-01',NULL,1),
	(9175,16,'Liconasco',0,'1800-01-01',NULL,1),
	(9176,16,'Mandrino',0,'1800-01-01',NULL,1),
	(9177,16,'Mangialupo',0,'1800-01-01',NULL,1),
	(9178,16,'Mezzano Parpanese',0,'1800-01-01',NULL,1),
	(9179,16,'Mezzano Siccomario',0,'1800-01-01',NULL,1),
	(9180,16,'Mirabello ed Uniti di Pavia',0,'1800-01-01',NULL,1),
	(9181,16,'Misano Olona',0,'1800-01-01',NULL,1),
	(9182,16,'Montebolognola',0,'1800-01-01',NULL,1),
	(9183,16,'Monteleone sui Colli Pavesi',0,'1800-01-01',NULL,1),
	(9184,16,'Montesano al Piano',0,'1800-01-01',NULL,1),
	(9185,16,'Mont',0,'1800-01-01',NULL,1),
	(9186,16,'Motta San Damiano',0,'1800-01-01',NULL,1),
	(9187,16,'Origioso',0,'1800-01-01',NULL,1),
	(9188,16,'Pairana',0,'1800-01-01',NULL,1),
	(9189,16,'Papiago',0,'1800-01-01',NULL,1),
	(9190,16,'Pietra Gavina',0,'1800-01-01',NULL,1),
	(9191,16,'Pissarello',0,'1800-01-01',NULL,1),
	(9192,16,'Pizzocorno',0,'1800-01-01',NULL,1),
	(9193,16,'Pometo',0,'1800-01-01',NULL,1),
	(9194,16,'Pontecarate',0,'1800-01-01',NULL,1),
	(9195,16,'Prado',0,'1800-01-01',NULL,1),
	(9196,16,'Sagliano di Crenna',0,'1800-01-01',NULL,1),
	(9197,16,'San Perone',0,'1800-01-01',NULL,1),
	(9198,16,'San Ponzo Semola',0,'1800-01-01',NULL,1),
	(9199,16,'San Varese',0,'1800-01-01',NULL,1),
	(9200,16,'San Zeno e Foppa',0,'1800-01-01',NULL,1),
	(9201,16,'Sant',0,'1800-01-01',NULL,1),
	(9202,16,'Santa Margherita di Bobbio',0,'1800-01-01',NULL,1),
	(9203,16,'Santa Margherita Po',0,'1800-01-01',NULL,1),
	(9204,16,'Spirago',0,'1800-01-01',NULL,1),
	(9205,16,'Staghiglione',0,'1800-01-01',NULL,1),
	(9206,16,'Terrasa',0,'1800-01-01',NULL,1),
	(9207,16,'Torradello',0,'1800-01-01',NULL,1),
	(9208,16,'Torre Beretti',0,'1800-01-01',NULL,1),
	(9209,16,'Torre de\' Torti',0,'1800-01-01',NULL,1),
	(9210,16,'Torre del Mangano',0,'1800-01-01',NULL,1),
	(9211,16,'Torre del Monte',0,'1800-01-01',NULL,1),
	(9212,16,'Torriano',0,'1800-01-01',NULL,1),
	(9213,16,'Torrino',0,'1800-01-01',NULL,1),
	(9214,16,'Trebbiano Nizza',0,'1800-01-01',NULL,1),
	(9215,16,'Trognano',0,'1800-01-01',NULL,1),
	(9216,16,'Turago Bordone',0,'1800-01-01',NULL,1),
	(9217,16,'Vaccarizza',0,'1800-01-01',NULL,1),
	(9218,16,'Vairano Pavese',0,'1800-01-01',NULL,1),
	(9219,16,'Verrua Siccomario',0,'1800-01-01',NULL,1),
	(9220,16,'Vigalfo',0,'1800-01-01',NULL,1),
	(9221,16,'Vigonzone',0,'1800-01-01',NULL,1),
	(9222,16,'Villalunga',0,'1800-01-01',NULL,1),
	(9223,16,'Villareggio',0,'1800-01-01',NULL,1),
	(9224,16,'Vimanone',0,'1800-01-01',NULL,1),
	(9225,16,'Vivente',0,'1800-01-01',NULL,1),
	(9226,16,'Zavattarello Valverde',0,'1800-01-01',NULL,1),
	(9227,16,'Zelata',0,'1800-01-01',NULL,1),
	(9228,16,'Zibido al Lambro',0,'1800-01-01',NULL,1),
	(9229,17,'Acqualunga Badona',0,'1800-01-01',NULL,1),
	(9230,17,'Alfiano ed Uniti',0,'1800-01-01',NULL,1),
	(9231,17,'Ardole San Marino',0,'1800-01-01',NULL,1),
	(9232,17,'Bagnarolo',0,'1800-01-01',NULL,1),
	(9233,17,'Barbiselle',0,'1800-01-01',NULL,1),
	(9234,17,'Barzaniga',0,'1800-01-01',NULL,1),
	(9235,17,'Bettenesco',0,'1800-01-01',NULL,1),
	(9236,17,'Binanuova',0,'1800-01-01',NULL,1),
	(9237,17,'Bottaiano',0,'1800-01-01',NULL,1),
	(9238,17,'Brancere',0,'1800-01-01',NULL,1),
	(9239,17,'Breda Guazzona',0,'1800-01-01',NULL,1),
	(9240,17,'Brolpasino',0,'1800-01-01',NULL,1),
	(9241,17,'Ca\' de\' Bonavogli',0,'1800-01-01',NULL,1),
	(9242,17,'Ca\' de\' Caggi',0,'1800-01-01',NULL,1),
	(9243,17,'Ca\' de\' Corti',0,'1800-01-01',NULL,1),
	(9244,17,'Ca\' de\' Quinzani',0,'1800-01-01',NULL,1),
	(9245,17,'Ca\' de\' Sfondrati',0,'1800-01-01',NULL,1),
	(9246,17,'Ca\' de\' Soresini',0,'1800-01-01',NULL,1),
	(9247,17,'Ca\' de\' Staoli',0,'1800-01-01',NULL,1),
	(9248,17,'Ca\' de\' Stefani',0,'1800-01-01',NULL,1),
	(9249,17,'Canova del Morbasco',0,'1800-01-01',NULL,1),
	(9250,17,'Canova Olzano',0,'1800-01-01',NULL,1),
	(9251,17,'Cansero',0,'1800-01-01',NULL,1),
	(9252,17,'Carpaneta con Dosimo',0,'1800-01-01',NULL,1),
	(9253,17,'Caruberto',0,'1800-01-01',NULL,1),
	(9254,17,'Casale Cremasco',0,'1800-01-01',NULL,1),
	(9255,17,'Casalorzo Geroldi',0,'1800-01-01',NULL,1),
	(9256,17,'Casalsigone',0,'1800-01-01',NULL,1),
	(9257,17,'Casanova d\'Offredi',0,'1800-01-01',NULL,1),
	(9258,17,'Cassine Gandine',0,'1800-01-01',NULL,1),
	(9259,17,'Castelfranco d\'Oglio',0,'1800-01-01',NULL,1),
	(9260,17,'Castelnuovo Cremasco',0,'1800-01-01',NULL,1),
	(9261,17,'Castelnuovo del Vescovo',0,'1800-01-01',NULL,1),
	(9262,17,'Castelnuovo del Zappa',0,'1800-01-01',NULL,1),
	(9263,17,'Castelnuovo Gherardi',0,'1800-01-01',NULL,1),
	(9264,17,'Castelponzone',0,'1800-01-01',NULL,1),
	(9265,17,'Cava Tigozzi',0,'1800-01-01',NULL,1),
	(9266,17,'Cavallara',0,'1800-01-01',NULL,1),
	(9267,17,'Cella Dati',0,'1800-01-01',NULL,1),
	(9268,17,'Cignone',0,'1800-01-01',NULL,1),
	(9269,17,'Colombarolo',0,'1800-01-01',NULL,1),
	(9270,17,'Corpi Santi di Cremona',0,'1800-01-01',NULL,1),
	(9271,17,'Corte Madama',0,'1800-01-01',NULL,1),
	(9272,17,'Cortetano',0,'1800-01-01',NULL,1),
	(9273,17,'Costa Sant\'Abramo',0,'1800-01-01',NULL,1),
	(9274,17,'Credera',0,'1800-01-01',NULL,1),
	(9275,17,'Dosso Baroardo',0,'1800-01-01',NULL,1),
	(9276,17,'Dosso de\' Frati',0,'1800-01-01',NULL,1),
	(9277,17,'Duemiglia',0,'1800-01-01',NULL,1),
	(9278,17,'Farinate',0,'1800-01-01',NULL,1),
	(9279,17,'Fengo',0,'1800-01-01',NULL,1),
	(9280,17,'Forcello',0,'1800-01-01',NULL,1),
	(9281,17,'Fossa Guazzona',0,'1800-01-01',NULL,1),
	(9282,17,'Fracchia',0,'1800-01-01',NULL,1),
	(9283,17,'Gabbioneta',0,'1800-01-01',NULL,1),
	(9284,17,'Gadesco',0,'1800-01-01',NULL,1),
	(9285,17,'Gambina Barchetti',0,'1800-01-01',NULL,1),
	(9286,17,'Gazzo',0,'1800-01-01',NULL,1),
	(9287,17,'Gradella',0,'1800-01-01',NULL,1),
	(9288,17,'Grontorto',0,'1800-01-01',NULL,1),
	(9289,17,'Isola Pescaroli',0,'1800-01-01',NULL,1),
	(9290,17,'Isolello',0,'1800-01-01',NULL,1),
	(9291,17,'Levata',0,'1800-01-01',NULL,1),
	(9292,17,'Licengo',0,'1800-01-01',NULL,1),
	(9293,17,'Longardore',0,'1800-01-01',NULL,1),
	(9294,17,'Luignano',0,'1800-01-01',NULL,1),
	(9295,17,'Marzalengo',0,'1800-01-01',NULL,1),
	(9296,17,'Mirabello Ciria',0,'1800-01-01',NULL,1),
	(9297,17,'Montanara',0,'1800-01-01',NULL,1),
	(9298,17,'Monticelli Ripa d\'Oglio',0,'1800-01-01',NULL,1),
	(9299,17,'Nosadello',0,'1800-01-01',NULL,1),
	(9300,17,'Ombriano',0,'1800-01-01',NULL,1),
	(9301,17,'Ossalengo',0,'1800-01-01',NULL,1),
	(9302,17,'Ossolaro',0,'1800-01-01',NULL,1),
	(9303,17,'Paderno Cremonese',0,'1800-01-01',NULL,1),
	(9304,17,'Palvareto',0,'1800-01-01',NULL,1),
	(9305,17,'Passarera',0,'1800-01-01',NULL,1),
	(9306,17,'Persico',0,'1800-01-01',NULL,1),
	(9307,17,'Pieve Delmona',0,'1800-01-01',NULL,1),
	(9308,17,'Pieve San Maurizio',0,'1800-01-01',NULL,1),
	(9309,17,'Pieve Terzagni',0,'1800-01-01',NULL,1),
	(9310,17,'Polengo',0,'1800-01-01',NULL,1),
	(9311,17,'Pontirolo Capredoni',0,'1800-01-01',NULL,1),
	(9312,17,'Porta Ombriano',0,'1800-01-01',NULL,1),
	(9313,17,'Pozzaglio',0,'1800-01-01',NULL,1),
	(9314,17,'Pozzo Baronzio',0,'1800-01-01',NULL,1),
	(9315,17,'Prato Muzio',0,'1800-01-01',NULL,1),
	(9316,17,'Quistro',0,'1800-01-01',NULL,1),
	(9317,17,'Recorfano',0,'1800-01-01',NULL,1),
	(9318,17,'Ripalta Nuova',0,'1800-01-01',NULL,1),
	(9319,17,'Ripalta Vecchia',0,'1800-01-01',NULL,1),
	(9320,17,'Romprezzagno',0,'1800-01-01',NULL,1),
	(9321,17,'Ronca de\' Golferami',0,'1800-01-01',NULL,1),
	(9322,17,'Roncadello d\'Adda',0,'1800-01-01',NULL,1),
	(9323,17,'Rovereto',0,'1800-01-01',NULL,1),
	(9324,17,'Rubbiano',0,'1800-01-01',NULL,1),
	(9325,17,'San Bernardino',0,'1800-01-01',NULL,1),
	(9326,17,'San Lorenzo Aroldo',0,'1800-01-01',NULL,1),
	(9327,17,'San Lorenzo de\' Picenardi',0,'1800-01-01',NULL,1),
	(9328,17,'San Lorenzo Guazzone',0,'1800-01-01',NULL,1),
	(9329,17,'San Lorenzo Mondinari',0,'1800-01-01',NULL,1),
	(9330,17,'San Martino in Beliseto',0,'1800-01-01',NULL,1),
	(9331,17,'San Michele Cremasco',0,'1800-01-01',NULL,1),
	(9332,17,'San Paolo Ripa d\'Oglio',0,'1800-01-01',NULL,1),
	(9333,17,'San Salvatore',0,'1800-01-01',NULL,1),
	(9334,17,'San Sillo',0,'1800-01-01',NULL,1),
	(9335,17,'San Vito e Modesto',0,'1800-01-01',NULL,1),
	(9336,17,'Santa Maria della Croce',0,'1800-01-01',NULL,1),
	(9337,17,'Scannabue',0,'1800-01-01',NULL,1),
	(9338,17,'Silvella',0,'1800-01-01',NULL,1),
	(9339,17,'Solarolo del Persico',0,'1800-01-01',NULL,1),
	(9340,17,'Solarolo Monasterolo',0,'1800-01-01',NULL,1),
	(9341,17,'Stilo de\' Mariani',0,'1800-01-01',NULL,1),
	(9342,17,'Torre d',0,'1800-01-01',NULL,1),
	(9343,17,'Tredossi',0,'1800-01-01',NULL,1),
	(9344,17,'Trezzolasco',0,'1800-01-01',NULL,1),
	(9345,17,'Triburgo',0,'1800-01-01',NULL,1),
	(9346,17,'Vairano Cremasco',0,'1800-01-01',NULL,1),
	(9347,17,'Vidiceto',0,'1800-01-01',NULL,1),
	(9348,17,'Vidolasco',0,'1800-01-01',NULL,1),
	(9349,17,'Vighizzolo',0,'1800-01-01',NULL,1),
	(9350,17,'Villa Rocca',0,'1800-01-01',NULL,1),
	(9351,17,'Zanengo',0,'1800-01-01',NULL,1),
	(9352,17,'Zappello',0,'1800-01-01',NULL,1),
	(9353,17,'Vho',0,'1800-01-01',NULL,1),
	(9354,18,'Casalpoglio',0,'1800-01-01',NULL,1),
	(9355,22,'San Felice',0,'1800-01-01',NULL,1),
	(9356,22,'Senale',0,'1800-01-01',NULL,1),
	(9357,22,'Acereto',0,'1800-01-01',NULL,1),
	(9358,22,'Albes',0,'1800-01-01',NULL,1),
	(9359,22,'Alliz',0,'1800-01-01',NULL,1),
	(9360,22,'Anterselva',0,'1800-01-01',NULL,1),
	(9361,22,'Burgusio',0,'1800-01-01',NULL,1),
	(9362,22,'Caminata in Tures',0,'1800-01-01',NULL,1),
	(9363,22,'Castelbello',0,'1800-01-01',NULL,1),
	(9364,22,'Casteldarne',0,'1800-01-01',NULL,1),
	(9365,22,'Cauria',0,'1800-01-01',NULL,1),
	(9366,22,'Cengles',0,'1800-01-01',NULL,1),
	(9367,22,'Ceves',0,'1800-01-01',NULL,1),
	(9368,22,'Ciardes',0,'1800-01-01',NULL,1),
	(9369,22,'Clusio',0,'1800-01-01',NULL,1),
	(9370,22,'Coldrano',0,'1800-01-01',NULL,1),
	(9371,22,'Colfosco',0,'1800-01-01',NULL,1),
	(9372,22,'Colle in Casies',0,'1800-01-01',NULL,1),
	(9373,22,'Colli in Pusteria',0,'1800-01-01',NULL,1),
	(9374,22,'Colsano',0,'1800-01-01',NULL,1),
	(9375,22,'Corti in Pusteria',0,'1800-01-01',NULL,1),
	(9376,22,'Corvara in Passiria',0,'1800-01-01',NULL,1),
	(9377,22,'Corzes',0,'1800-01-01',NULL,1),
	(9378,22,'Covelano',0,'1800-01-01',NULL,1),
	(9379,22,'Curon',0,'1800-01-01',NULL,1),
	(9380,22,'Elle',0,'1800-01-01',NULL,1),
	(9381,22,'Eores',0,'1800-01-01',NULL,1),
	(9382,22,'Favogna di Sotto',0,'1800-01-01',NULL,1),
	(9383,22,'Fleres',0,'1800-01-01',NULL,1),
	(9384,22,'Foiana',0,'1800-01-01',NULL,1),
	(9385,22,'Fundres',0,'1800-01-01',NULL,1),
	(9386,22,'Gries',0,'1800-01-01',NULL,1),
	(9387,22,'Grimaldo',0,'1800-01-01',NULL,1),
	(9388,22,'Gudon',0,'1800-01-01',NULL,1),
	(9389,22,'Issengo',0,'1800-01-01',NULL,1),
	(9390,22,'Lacinigo',0,'1800-01-01',NULL,1),
	(9391,22,'Lappago',0,'1800-01-01',NULL,1),
	(9392,22,'Laudes',0,'1800-01-01',NULL,1),
	(9393,22,'Lazfons',0,'1800-01-01',NULL,1),
	(9394,22,'Longiar',0,'1800-01-01',NULL,1),
	(9395,22,'Lutago',0,'1800-01-01',NULL,1),
	(9396,22,'Magr',0,'1800-01-01',NULL,1),
	(9397,22,'Maia Alta',0,'1800-01-01',NULL,1),
	(9398,22,'Maia Bassa',0,'1800-01-01',NULL,1),
	(9399,22,'Mallas',0,'1800-01-01',NULL,1),
	(9400,22,'Mantana',0,'1800-01-01',NULL,1),
	(9401,22,'Maranza',0,'1800-01-01',NULL,1),
	(9402,22,'Mareta',0,'1800-01-01',NULL,1),
	(9403,22,'Mazia',0,'1800-01-01',NULL,1),
	(9404,22,'Millan-Sarnes',0,'1800-01-01',NULL,1),
	(9405,22,'Molini di Tures',0,'1800-01-01',NULL,1),
	(9406,22,'Monghezzo di Fuori',0,'1800-01-01',NULL,1),
	(9407,22,'Montassilone',0,'1800-01-01',NULL,1),
	(9408,22,'Monte di Mezzod',0,'1800-01-01',NULL,1),
	(9409,22,'Monte di Tramontana',0,'1800-01-01',NULL,1),
	(9410,22,'Monte San Candido',0,'1800-01-01',NULL,1),
	(9411,22,'Montechiaro',0,'1800-01-01',NULL,1),
	(9412,22,'Montefontana',0,'1800-01-01',NULL,1),
	(9413,22,'Monteponente',0,'1800-01-01',NULL,1),
	(9414,22,'Morter',0,'1800-01-01',NULL,1),
	(9415,22,'Mules',0,'1800-01-01',NULL,1),
	(9416,22,'Naz',0,'1800-01-01',NULL,1),
	(9417,22,'Novacella',0,'1800-01-01',NULL,1),
	(9418,22,'Onies',0,'1800-01-01',NULL,1),
	(9419,22,'Oris',0,'1800-01-01',NULL,1),
	(9420,22,'Planol',0,'1800-01-01',NULL,1),
	(9421,22,'Plata',0,'1800-01-01',NULL,1),
	(9422,22,'Prati',0,'1800-01-01',NULL,1),
	(9423,22,'Prato alla Drava',0,'1800-01-01',NULL,1),
	(9424,22,'Prato di Venosta',0,'1800-01-01',NULL,1),
	(9425,22,'Quarazze',0,'1800-01-01',NULL,1),
	(9426,22,'Rasun di Sopra',0,'1800-01-01',NULL,1),
	(9427,22,'Rasun di Sotto',0,'1800-01-01',NULL,1),
	(9428,22,'Rasun Valdaora',0,'1800-01-01',NULL,1),
	(9429,22,'Resia',0,'1800-01-01',NULL,1),
	(9430,22,'Ridanna',0,'1800-01-01',NULL,1),
	(9431,22,'Rina',0,'1800-01-01',NULL,1),
	(9432,22,'Riomolino',0,'1800-01-01',NULL,1),
	(9433,22,'Riscone',0,'1800-01-01',NULL,1),
	(9434,22,'Riva di Tures',0,'1800-01-01',NULL,1),
	(9435,22,'San Valentino alla Mutta',0,'1800-01-01',NULL,1),
	(9436,22,'San Giacomo',0,'1800-01-01',NULL,1),
	(9437,22,'San Giorgio',0,'1800-01-01',NULL,1),
	(9438,22,'San Giovanni',0,'1800-01-01',NULL,1),
	(9439,22,'San Leonardo',0,'1800-01-01',NULL,1),
	(9440,22,'San Lugano',0,'1800-01-01',NULL,1),
	(9441,22,'San Martino al Monte',0,'1800-01-01',NULL,1),
	(9442,22,'San Martino in Casies',0,'1800-01-01',NULL,1),
	(9443,22,'San Pietro',0,'1800-01-01',NULL,1),
	(9444,22,'San Sigismondo',0,'1800-01-01',NULL,1),
	(9445,22,'San Valentino al Brennero',0,'1800-01-01',NULL,1),
	(9446,22,'Sant\'Andrea in Monte',0,'1800-01-01',NULL,1),
	(9447,22,'Santa Maddalena in Casies',0,'1800-01-01',NULL,1),
	(9448,22,'Scaleres',0,'1800-01-01',NULL,1),
	(9449,22,'Sciaves',0,'1800-01-01',NULL,1),
	(9450,22,'Slingia',0,'1800-01-01',NULL,1),
	(9451,22,'Spinga',0,'1800-01-01',NULL,1),
	(9452,22,'Stava',0,'1800-01-01',NULL,1),
	(9453,22,'Stilves',0,'1800-01-01',NULL,1),
	(9454,22,'Tabl',0,'1800-01-01',NULL,1),
	(9455,22,'Tanas',0,'1800-01-01',NULL,1),
	(9456,22,'Tarces',0,'1800-01-01',NULL,1),
	(9457,22,'Tarres',0,'1800-01-01',NULL,1),
	(9458,22,'Telves',0,'1800-01-01',NULL,1),
	(9459,22,'Teodone',0,'1800-01-01',NULL,1),
	(9460,22,'Tesido',0,'1800-01-01',NULL,1),
	(9461,22,'Tiso',0,'1800-01-01',NULL,1),
	(9462,22,'Trens',0,'1800-01-01',NULL,1),
	(9463,22,'Tunes',0,'1800-01-01',NULL,1),
	(9464,22,'Valas',0,'1800-01-01',NULL,1),
	(9465,22,'Valgiovo',0,'1800-01-01',NULL,1),
	(9466,22,'Vallarga',0,'1800-01-01',NULL,1),
	(9467,22,'Valle San Silvestro',0,'1800-01-01',NULL,1),
	(9468,22,'Vallelunga',0,'1800-01-01',NULL,1),
	(9469,22,'Valles',0,'1800-01-01',NULL,1),
	(9470,22,'Vandoies di Sopra',0,'1800-01-01',NULL,1),
	(9471,22,'Vandoies di Sotto',0,'1800-01-01',NULL,1),
	(9472,22,'Vanga',0,'1800-01-01',NULL,1),
	(9473,22,'Vezzano',0,'1800-01-01',NULL,1),
	(9474,22,'Villa Ottone',0,'1800-01-01',NULL,1),
	(9475,22,'Villa Santa Caterina',0,'1800-01-01',NULL,1),
	(9476,22,'Vizze',0,'1800-01-01',NULL,1),
	(9477,22,'Versciaco',0,'1800-01-01',NULL,1),
	(9478,23,'Banco',0,'1800-01-01',NULL,1),
	(9479,23,'Baselga di Vezzano',0,'1800-01-01',NULL,1),
	(9480,23,'Bezzecca',0,'1800-01-01',NULL,1),
	(9481,23,'Bleggio Inferiore',0,'1800-01-01',NULL,1),
	(9482,23,'Casez',0,'1800-01-01',NULL,1),
	(9483,23,'Concei',0,'1800-01-01',NULL,1),
	(9484,23,'Lomaso',0,'1800-01-01',NULL,1),
	(9485,23,'Molina di Ledro',0,'1800-01-01',NULL,1),
	(9486,23,'Pieve di Ledro',0,'1800-01-01',NULL,1),
	(9487,23,'Tiarno di Sopra',0,'1800-01-01',NULL,1),
	(9488,23,'Tiarno di Sotto',0,'1800-01-01',NULL,1),
	(9489,23,'Vigolo Baselga',0,'1800-01-01',NULL,1),
	(9490,23,'Agrone',0,'1800-01-01',NULL,1),
	(9491,23,'Almazzago',0,'1800-01-01',NULL,1),
	(9492,23,'Andogno',0,'1800-01-01',NULL,1),
	(9493,23,'Arnago',0,'1800-01-01',NULL,1),
	(9494,23,'Beseno',0,'1800-01-01',NULL,1),
	(9495,23,'Biacesa',0,'1800-01-01',NULL,1),
	(9496,23,'Bleggio',0,'1800-01-01',NULL,1),
	(9497,23,'Bolentina',0,'1800-01-01',NULL,1),
	(9498,23,'Bondo Breguzzo',0,'1800-01-01',NULL,1),
	(9499,23,'Borghetto',0,'1800-01-01',NULL,1),
	(9500,23,'Borzago',0,'1800-01-01',NULL,1),
	(9501,23,'Bozzana',0,'1800-01-01',NULL,1),
	(9502,23,'Cadine',0,'1800-01-01',NULL,1),
	(9503,23,'Celledizzo',0,'1800-01-01',NULL,1),
	(9504,23,'Campo',0,'1800-01-01',NULL,1),
	(9505,23,'Canezza',0,'1800-01-01',NULL,1),
	(9506,23,'Carciato',0,'1800-01-01',NULL,1),
	(9507,23,'Castagn',0,'1800-01-01',NULL,1),
	(9508,23,'Castellano',0,'1800-01-01',NULL,1),
	(9509,23,'Castello',0,'1800-01-01',NULL,1),
	(9510,23,'Celentino',0,'1800-01-01',NULL,1),
	(9511,23,'Chienis',0,'1800-01-01',NULL,1),
	(9512,23,'Chizzola',0,'1800-01-01',NULL,1),
	(9513,23,'Ciago',0,'1800-01-01',NULL,1),
	(9514,23,'Cognola',0,'1800-01-01',NULL,1),
	(9515,23,'Cogolo',0,'1800-01-01',NULL,1),
	(9516,23,'Cologna in Giudicarie',0,'1800-01-01',NULL,1),
	(9517,23,'Cologna-Gavazzo',0,'1800-01-01',NULL,1),
	(9518,23,'Comano',0,'1800-01-01',NULL,1),
	(9519,23,'Comasine',0,'1800-01-01',NULL,1),
	(9520,23,'Costasavina',0,'1800-01-01',NULL,1),
	(9521,23,'Covelo',0,'1800-01-01',NULL,1),
	(9522,23,'Creto',0,'1800-01-01',NULL,1),
	(9523,23,'Dardine',0,'1800-01-01',NULL,1),
	(9524,23,'Darzo',0,'1800-01-01',NULL,1),
	(9525,23,'Deggiano',0,'1800-01-01',NULL,1),
	(9526,23,'Dercolo',0,'1800-01-01',NULL,1),
	(9527,23,'Dermulo',0,'1800-01-01',NULL,1),
	(9528,23,'Enguiso',0,'1800-01-01',NULL,1),
	(9529,23,'Falesina',0,'1800-01-01',NULL,1),
	(9530,23,'Fisto',0,'1800-01-01',NULL,1),
	(9531,23,'Forno',0,'1800-01-01',NULL,1),
	(9532,23,'Fraveggio',0,'1800-01-01',NULL,1),
	(9533,23,'Gardolo al Piano',0,'1800-01-01',NULL,1),
	(9534,23,'Grumo',0,'1800-01-01',NULL,1),
	(9535,23,'Iavr',0,'1800-01-01',NULL,1),
	(9536,23,'Ischia',0,'1800-01-01',NULL,1),
	(9537,23,'Legos',0,'1800-01-01',NULL,1),
	(9538,23,'Lenzima',0,'1800-01-01',NULL,1),
	(9539,23,'Lenzumo',0,'1800-01-01',NULL,1),
	(9540,23,'Lizzana',0,'1800-01-01',NULL,1),
	(9541,23,'Locca',0,'1800-01-01',NULL,1),
	(9542,23,'Lodrone',0,'1800-01-01',NULL,1),
	(9543,23,'Lon',0,'1800-01-01',NULL,1),
	(9544,23,'Lover',0,'1800-01-01',NULL,1),
	(9545,23,'Lundo',0,'1800-01-01',NULL,1),
	(9546,23,'Madrano',0,'1800-01-01',NULL,1),
	(9547,23,'Madruzzo',0,'1800-01-01',NULL,1),
	(9548,23,'Magras',0,'1800-01-01',NULL,1),
	(9549,23,'Malgolo',0,'1800-01-01',NULL,1),
	(9550,23,'Manzano',0,'1800-01-01',NULL,1),
	(9551,23,'Marano',0,'1800-01-01',NULL,1),
	(9552,23,'Marco',0,'1800-01-01',NULL,1),
	(9553,23,'Margone',0,'1800-01-01',NULL,1),
	(9554,23,'Masi di Vigo',0,'1800-01-01',NULL,1),
	(9555,23,'Mastellina',0,'1800-01-01',NULL,1),
	(9556,23,'Mattarello',0,'1800-01-01',NULL,1),
	(9557,23,'Meano',0,'1800-01-01',NULL,1),
	(9558,23,'Mechel',0,'1800-01-01',NULL,1),
	(9559,23,'Mestriago',0,'1800-01-01',NULL,1),
	(9560,23,'Mezzano Imer',0,'1800-01-01',NULL,1),
	(9561,23,'Mezzolago',0,'1800-01-01',NULL,1),
	(9562,23,'Miola',0,'1800-01-01',NULL,1),
	(9563,23,'Mollaro',0,'1800-01-01',NULL,1),
	(9564,23,'Montes',0,'1800-01-01',NULL,1),
	(9565,23,'Mortaso',0,'1800-01-01',NULL,1),
	(9566,23,'Noarna',0,'1800-01-01',NULL,1),
	(9567,23,'Nogar',0,'1800-01-01',NULL,1),
	(9568,23,'Nomesino',0,'1800-01-01',NULL,1),
	(9569,23,'Noriglio',0,'1800-01-01',NULL,1),
	(9570,23,'Oltresarca',0,'1800-01-01',NULL,1),
	(9571,23,'Patone',0,'1800-01-01',NULL,1),
	(9572,23,'Pederzano',0,'1800-01-01',NULL,1),
	(9573,23,'Perra',0,'1800-01-01',NULL,1),
	(9574,23,'Piano',0,'1800-01-01',NULL,1),
	(9575,23,'Pilcante',0,'1800-01-01',NULL,1),
	(9576,23,'Por',0,'1800-01-01',NULL,1),
	(9577,23,'Povo',0,'1800-01-01',NULL,1),
	(9578,23,'Pranzo',0,'1800-01-01',NULL,1),
	(9579,23,'Pr',0,'1800-01-01',NULL,1),
	(9580,23,'Pregasina',0,'1800-01-01',NULL,1),
	(9581,23,'Preghena',0,'1800-01-01',NULL,1),
	(9582,23,'Premione',0,'1800-01-01',NULL,1),
	(9583,23,'Presson',0,'1800-01-01',NULL,1),
	(9584,23,'Primiero',0,'1800-01-01',NULL,1),
	(9585,23,'Pri',0,'1800-01-01',NULL,1),
	(9586,23,'Quetta',0,'1800-01-01',NULL,1),
	(9587,23,'Ranzo',0,'1800-01-01',NULL,1),
	(9588,23,'Ravina',0,'1800-01-01',NULL,1),
	(9589,23,'Reviano Folas',0,'1800-01-01',NULL,1),
	(9590,23,'Romagnano',0,'1800-01-01',NULL,1),
	(9591,23,'Romarzolo',0,'1800-01-01',NULL,1),
	(9592,23,'Roncogno',0,'1800-01-01',NULL,1),
	(9593,23,'Ronzo',0,'1800-01-01',NULL,1),
	(9594,23,'Rover Carbonare',0,'1800-01-01',NULL,1),
	(9595,23,'Samoclevo',0,'1800-01-01',NULL,1),
	(9596,23,'San Giacomo',0,'1800-01-01',NULL,1),
	(9597,23,'Santa Margherita',0,'1800-01-01',NULL,1),
	(9598,23,'Saone',0,'1800-01-01',NULL,1),
	(9599,23,'Sardagna',0,'1800-01-01',NULL,1),
	(9600,23,'Sasso',0,'1800-01-01',NULL,1),
	(9601,23,'Scelmo',0,'1800-01-01',NULL,1),
	(9602,23,'Segno',0,'1800-01-01',NULL,1),
	(9603,23,'Seio',0,'1800-01-01',NULL,1),
	(9604,23,'Seo',0,'1800-01-01',NULL,1),
	(9605,23,'Serravalle all',0,'1800-01-01',NULL,1),
	(9606,23,'Serso',0,'1800-01-01',NULL,1),
	(9607,23,'Sevignano',0,'1800-01-01',NULL,1),
	(9608,23,'Sopramonte',0,'1800-01-01',NULL,1),
	(9609,23,'Strada',0,'1800-01-01',NULL,1),
	(9610,23,'Stramentizzo',0,'1800-01-01',NULL,1),
	(9611,23,'Stumiaga',0,'1800-01-01',NULL,1),
	(9612,23,'Sus',0,'1800-01-01',NULL,1),
	(9613,23,'Tavodo',0,'1800-01-01',NULL,1),
	(9614,23,'Tavon',0,'1800-01-01',NULL,1),
	(9615,23,'Termenago',0,'1800-01-01',NULL,1),
	(9616,23,'Termon',0,'1800-01-01',NULL,1),
	(9617,23,'Tiarno',0,'1800-01-01',NULL,1),
	(9618,23,'Torra',0,'1800-01-01',NULL,1),
	(9619,23,'Toss',0,'1800-01-01',NULL,1),
	(9620,23,'Tuenetto',0,'1800-01-01',NULL,1),
	(9621,23,'Valle San Felice',0,'1800-01-01',NULL,1),
	(9622,23,'Vasio',0,'1800-01-01',NULL,1),
	(9623,23,'Verdesina',0,'1800-01-01',NULL,1),
	(9624,23,'Viarago',0,'1800-01-01',NULL,1),
	(9625,23,'Vigalzano',0,'1800-01-01',NULL,1),
	(9626,23,'Vignola',0,'1800-01-01',NULL,1),
	(9627,23,'Vigo d',0,'1800-01-01',NULL,1),
	(9628,23,'Villa Banale',0,'1800-01-01',NULL,1),
	(9629,23,'Villazzano',0,'1800-01-01',NULL,1),
	(9630,23,'Ville del Monte',0,'1800-01-01',NULL,1),
	(9631,23,'Vion',0,'1800-01-01',NULL,1),
	(9632,24,'Avesa',0,'1800-01-01',NULL,1),
	(9633,24,'Belluno Veronese',0,'1800-01-01',NULL,1),
	(9634,24,'Bevilacqua-Boschi',0,'1800-01-01',NULL,1),
	(9635,24,'Brentino',0,'1800-01-01',NULL,1),
	(9636,24,'Breonio',0,'1800-01-01',NULL,1),
	(9637,24,'Ca\' di David',0,'1800-01-01',NULL,1),
	(9638,24,'Castione Veronese',0,'1800-01-01',NULL,1),
	(9639,24,'Correzzo',0,'1800-01-01',NULL,1),
	(9640,24,'Marcellise',0,'1800-01-01',NULL,1),
	(9641,24,'Mizzole',0,'1800-01-01',NULL,1),
	(9642,24,'Montorio Veronese',0,'1800-01-01',NULL,1),
	(9643,24,'Negarine',0,'1800-01-01',NULL,1),
	(9644,24,'Parona di Valpolicella',0,'1800-01-01',NULL,1),
	(9645,24,'Prun',0,'1800-01-01',NULL,1),
	(9646,24,'Quinto di Valpantena',0,'1800-01-01',NULL,1),
	(9647,24,'Quinzano Veronese',0,'1800-01-01',NULL,1),
	(9648,24,'San Massimo all\'Adige',0,'1800-01-01',NULL,1),
	(9649,24,'San Michele Extra',0,'1800-01-01',NULL,1),
	(9650,24,'Santa Maria in Stelle',0,'1800-01-01',NULL,1),
	(9651,25,'Tretto',0,'1800-01-01',NULL,1),
	(9652,25,'Casotto',0,'1800-01-01',NULL,1),
	(9653,25,'Crosara',0,'1800-01-01',NULL,1),
	(9654,25,'Forni di Val d\'Astico',0,'1800-01-01',NULL,1),
	(9655,25,'Magr',0,'1800-01-01',NULL,1),
	(9656,25,'Novale',0,'1800-01-01',NULL,1),
	(9657,25,'Tresch',0,'1800-01-01',NULL,1),
	(9658,25,'Vallonara',0,'1800-01-01',NULL,1),
	(9659,25,'Valrovina',0,'1800-01-01',NULL,1),
	(9660,27,'Ceneda',0,'1800-01-01',NULL,1),
	(9661,27,'Piavon',0,'1800-01-01',NULL,1),
	(9662,27,'Revine',0,'1800-01-01',NULL,1),
	(9663,27,'San Giorgio di Lago',0,'1800-01-01',NULL,1),
	(9664,27,'San Pietro di Barbozza',0,'1800-01-01',NULL,1),
	(9665,27,'Sant',0,'1800-01-01',NULL,1),
	(9666,27,'Serravalle',0,'1800-01-01',NULL,1),
	(9667,27,'Spercenigo',0,'1800-01-01',NULL,1),
	(9668,28,'Burano',0,'1800-01-01',NULL,1),
	(9669,28,'Chirignago',0,'1800-01-01',NULL,1),
	(9670,28,'Favaro Veneto',0,'1800-01-01',NULL,1),
	(9671,28,'Malamocco',0,'1800-01-01',NULL,1),
	(9672,28,'Mestre',0,'1800-01-01',NULL,1),
	(9673,28,'Murano',0,'1800-01-01',NULL,1),
	(9674,28,'Pellestrina',0,'1800-01-01',NULL,1),
	(9675,28,'Zelarino',0,'1800-01-01',NULL,1),
	(9676,28,'Gambarare',0,'1800-01-01',NULL,1),
	(9677,28,'Oriago',0,'1800-01-01',NULL,1),
	(9678,29,'Carrara San Giorgio',0,'1800-01-01',NULL,1),
	(9679,29,'Carrara Santo Stefano',0,'1800-01-01',NULL,1),
	(9680,29,'San Michele delle Badesse',0,'1800-01-01',NULL,1),
	(9681,30,'Contarina',0,'1800-01-01',NULL,1),
	(9682,30,'Donada',0,'1800-01-01',NULL,1),
	(9683,30,'Bellombra',0,'1800-01-01',NULL,1),
	(9684,30,'Boara Polesine',0,'1800-01-01',NULL,1),
	(9685,30,'Borsea',0,'1800-01-01',NULL,1),
	(9686,30,'Bottrighe',0,'1800-01-01',NULL,1),
	(9687,30,'Buso Sarzano',0,'1800-01-01',NULL,1),
	(9688,30,'Ca\' Emo',0,'1800-01-01',NULL,1),
	(9689,30,'Concadirame',0,'1800-01-01',NULL,1),
	(9690,30,'Crocetta',0,'1800-01-01',NULL,1),
	(9691,30,'Grignano di Polesine',0,'1800-01-01',NULL,1),
	(9692,30,'Massa Superiore',0,'1800-01-01',NULL,1),
	(9693,30,'Ramo di Palo',0,'1800-01-01',NULL,1),
	(9694,30,'Salvaterra',0,'1800-01-01',NULL,1),
	(9695,30,'Sant',0,'1800-01-01',NULL,1),
	(9696,30,'Villa d',0,'1800-01-01',NULL,1),
	(9697,30,'Saguedo',0,'1800-01-01',NULL,1),
	(9698,31,'Campolongo al Torre',0,'1800-01-01',NULL,1),
	(9699,31,'Tapogliano',0,'1800-01-01',NULL,1),
	(9700,31,'Camporosso in Valcanale',0,'1800-01-01',NULL,1),
	(9701,31,'Castel del Monte Udinese',0,'1800-01-01',NULL,1),
	(9702,31,'Cesclans',0,'1800-01-01',NULL,1),
	(9703,31,'Ciseriis',0,'1800-01-01',NULL,1),
	(9704,31,'Feletto Umberto',0,'1800-01-01',NULL,1),
	(9705,31,'Fusine in Valromana',0,'1800-01-01',NULL,1),
	(9706,31,'Ioannis',0,'1800-01-01',NULL,1),
	(9707,31,'Ipplis',0,'1800-01-01',NULL,1),
	(9708,31,'Laglesie San Leopoldo',0,'1800-01-01',NULL,1),
	(9709,31,'Malborghetto',0,'1800-01-01',NULL,1),
	(9710,31,'Mione',0,'1800-01-01',NULL,1),
	(9711,31,'Muscoli Strassoldo',0,'1800-01-01',NULL,1),
	(9712,31,'Perteole',0,'1800-01-01',NULL,1),
	(9713,31,'Pontebba Nova',0,'1800-01-01',NULL,1),
	(9714,31,'Raccolana',0,'1800-01-01',NULL,1),
	(9715,31,'Rivolto',0,'1800-01-01',NULL,1),
	(9716,31,'Rodda',0,'1800-01-01',NULL,1),
	(9717,31,'Scodovacca',0,'1800-01-01',NULL,1),
	(9718,31,'Segnacco',0,'1800-01-01',NULL,1),
	(9719,31,'Tarcetta',0,'1800-01-01',NULL,1),
	(9720,31,'Ugovizza Valbruna',0,'1800-01-01',NULL,1),
	(9721,32,'Aidussina',0,'1800-01-01',NULL,1),
	(9722,32,'Bergogna',0,'1800-01-01',NULL,1),
	(9723,32,'Cal di Canale',0,'1800-01-01',NULL,1),
	(9724,32,'Canale d\'Isonzo',0,'1800-01-01',NULL,1),
	(9725,32,'Caporetto',0,'1800-01-01',NULL,1),
	(9726,32,'Castel Dobra',0,'1800-01-01',NULL,1),
	(9727,32,'Cernizza Goriziana',0,'1800-01-01',NULL,1),
	(9728,32,'Chiapovano',0,'1800-01-01',NULL,1),
	(9729,32,'Circhina',0,'1800-01-01',NULL,1),
	(9730,32,'Comeno',0,'1800-01-01',NULL,1),
	(9731,32,'Gargaro',0,'1800-01-01',NULL,1),
	(9732,32,'Gracova Serravalle',0,'1800-01-01',NULL,1),
	(9733,32,'Idria',0,'1800-01-01',NULL,1),
	(9734,32,'Merna',0,'1800-01-01',NULL,1),
	(9735,32,'Montenero d\'Idria',0,'1800-01-01',NULL,1),
	(9736,32,'Montespino',0,'1800-01-01',NULL,1),
	(9737,32,'Opacchiasella',0,'1800-01-01',NULL,1),
	(9738,32,'Plezzo',0,'1800-01-01',NULL,1),
	(9739,32,'Ranziano',0,'1800-01-01',NULL,1),
	(9740,32,'Rifembergo',0,'1800-01-01',NULL,1),
	(9741,32,'Salona d\'Isonzo',0,'1800-01-01',NULL,1),
	(9742,32,'Sambasso',0,'1800-01-01',NULL,1),
	(9743,32,'San Daniele del Carso',0,'1800-01-01',NULL,1),
	(9744,32,'San Martino Quisca',0,'1800-01-01',NULL,1),
	(9745,32,'San Vito di Vipacco',0,'1800-01-01',NULL,1),
	(9746,32,'Santa Croce di Aidussina',0,'1800-01-01',NULL,1),
	(9747,32,'Santa Lucia d\'Isonzo',0,'1800-01-01',NULL,1),
	(9748,32,'Sonzia',0,'1800-01-01',NULL,1),
	(9749,32,'Tarnova della Selva',0,'1800-01-01',NULL,1),
	(9750,32,'Temenizza',0,'1800-01-01',NULL,1),
	(9751,32,'Tolmino',0,'1800-01-01',NULL,1),
	(9752,32,'Vipacco',0,'1800-01-01',NULL,1),
	(9753,32,'Zolla',0,'1800-01-01',NULL,1),
	(9754,32,'Brazzano',0,'1800-01-01',NULL,1),
	(9755,32,'Corona',0,'1800-01-01',NULL,1),
	(9756,32,'Cosbana nel Collio',0,'1800-01-01',NULL,1),
	(9757,32,'Lucinico',0,'1800-01-01',NULL,1),
	(9758,32,'Piedimonte del Calvario',0,'1800-01-01',NULL,1),
	(9759,32,'Romans',0,'1800-01-01',NULL,1),
	(9760,32,'Salcano',0,'1800-01-01',NULL,1),
	(9761,32,'San Pietro di Gorizia',0,'1800-01-01',NULL,1),
	(9762,32,'Sant',0,'1800-01-01',NULL,1),
	(9763,32,'Versa',0,'1800-01-01',NULL,1),
	(9764,32,'Vertoiba in Campi Santi',0,'1800-01-01',NULL,1),
	(9765,32,'Aiba',0,'1800-01-01',NULL,1),
	(9766,32,'Anicova Corada',0,'1800-01-01',NULL,1),
	(9767,32,'Auzza',0,'1800-01-01',NULL,1),
	(9768,32,'Battaglia della Bainsizza',0,'1800-01-01',NULL,1),
	(9769,32,'Biglia',0,'1800-01-01',NULL,1),
	(9770,32,'Bigliana',0,'1800-01-01',NULL,1),
	(9771,32,'Boriano',0,'1800-01-01',NULL,1),
	(9772,32,'Brestovizza in Valle',0,'1800-01-01',NULL,1),
	(9773,32,'Bretto',0,'1800-01-01',NULL,1),
	(9774,32,'Budagne',0,'1800-01-01',NULL,1),
	(9775,32,'Camigna',0,'1800-01-01',NULL,1),
	(9776,32,'Ceconico',0,'1800-01-01',NULL,1),
	(9777,32,'Cobbia',0,'1800-01-01',NULL,1),
	(9778,32,'Creda',0,'1800-01-01',NULL,1),
	(9779,32,'Descla',0,'1800-01-01',NULL,1),
	(9780,32,'Dole',0,'1800-01-01',NULL,1),
	(9781,32,'Dol Grande',0,'1800-01-01',NULL,1),
	(9782,32,'Dol-Ottelza',0,'1800-01-01',NULL,1),
	(9783,32,'Dresenza',0,'1800-01-01',NULL,1),
	(9784,32,'Ersel in Monte',0,'1800-01-01',NULL,1),
	(9785,32,'Gabria',0,'1800-01-01',NULL,1),
	(9786,32,'Gabrovizza',0,'1800-01-01',NULL,1),
	(9787,32,'Godovici',0,'1800-01-01',NULL,1),
	(9788,32,'Goiaci',0,'1800-01-01',NULL,1),
	(9789,32,'Goriano',0,'1800-01-01',NULL,1),
	(9790,32,'Gozza',0,'1800-01-01',NULL,1),
	(9791,32,'Idresca d\'Isonzo',0,'1800-01-01',NULL,1),
	(9792,32,'Idria di Sotto',0,'1800-01-01',NULL,1),
	(9793,32,'Ledine',0,'1800-01-01',NULL,1),
	(9794,32,'Libussina',0,'1800-01-01',NULL,1),
	(9795,32,'Locavizza di Aidussina',0,'1800-01-01',NULL,1),
	(9796,32,'Locavizza di Canale',0,'1800-01-01',NULL,1),
	(9797,32,'Lose',0,'1800-01-01',NULL,1),
	(9798,32,'Luico',0,'1800-01-01',NULL,1),
	(9799,32,'Medana',0,'1800-01-01',NULL,1),
	(9800,32,'Monte San Vito',0,'1800-01-01',NULL,1),
	(9801,32,'Monte Urabice',0,'1800-01-01',NULL,1),
	(9802,32,'Oltresonzia',0,'1800-01-01',NULL,1),
	(9803,32,'Ossecca Vittuglia',0,'1800-01-01',NULL,1),
	(9804,32,'Ossegliano San Michele',0,'1800-01-01',NULL,1),
	(9805,32,'Paniqua',0,'1800-01-01',NULL,1),
	(9806,32,'Planina',0,'1800-01-01',NULL,1),
	(9807,32,'Pliscovizza della Madonna',0,'1800-01-01',NULL,1),
	(9808,32,'Pocrai del Piro',0,'1800-01-01',NULL,1),
	(9809,32,'Podraga',0,'1800-01-01',NULL,1),
	(9810,32,'Prevacina',0,'1800-01-01',NULL,1),
	(9811,32,'Ronzina',0,'1800-01-01',NULL,1),
	(9812,32,'Sable Grande',0,'1800-01-01',NULL,1),
	(9813,32,'Saga',0,'1800-01-01',NULL,1),
	(9814,32,'Samaria',0,'1800-01-01',NULL,1),
	(9815,32,'Santo Spirito della Bainsizza',0,'1800-01-01',NULL,1),
	(9816,32,'Scherbina',0,'1800-01-01',NULL,1),
	(9817,32,'Scrilla',0,'1800-01-01',NULL,1),
	(9818,32,'Sebreghe',0,'1800-01-01',NULL,1),
	(9819,32,'Sedula',0,'1800-01-01',NULL,1),
	(9820,32,'Sella delle Trincee',0,'1800-01-01',NULL,1),
	(9821,32,'Serpenizza',0,'1800-01-01',NULL,1),
	(9822,32,'Slappe Zorzi',0,'1800-01-01',NULL,1),
	(9823,32,'Sturia delle Fusine',0,'1800-01-01',NULL,1),
	(9824,32,'Ternova d\'Isonzo',0,'1800-01-01',NULL,1),
	(9825,32,'Trenta d\'Isonzo',0,'1800-01-01',NULL,1),
	(9826,32,'Tribussa',0,'1800-01-01',NULL,1),
	(9827,32,'Ustie',0,'1800-01-01',NULL,1),
	(9828,32,'Verpogliano',0,'1800-01-01',NULL,1),
	(9829,32,'Vertovino',0,'1800-01-01',NULL,1),
	(9830,32,'Ville Montevecchio',0,'1800-01-01',NULL,1),
	(9831,32,'Voissizza di Comeno',0,'1800-01-01',NULL,1),
	(9832,32,'Volzana',0,'1800-01-01',NULL,1),
	(9833,32,'Voschia',0,'1800-01-01',NULL,1),
	(9834,33,'Bucuie',0,'1800-01-01',NULL,1),
	(9835,33,'Cave Auremiane',0,'1800-01-01',NULL,1),
	(9836,33,'Corgnale',0,'1800-01-01',NULL,1),
	(9837,33,'Cossana',0,'1800-01-01',NULL,1),
	(9838,33,'Crenovizza',0,'1800-01-01',NULL,1),
	(9839,33,'Divaccia Grotte del Timavo',0,'1800-01-01',NULL,1),
	(9840,33,'Duttogliano',0,'1800-01-01',NULL,1),
	(9841,33,'Postumia Grotte',0,'1800-01-01',NULL,1),
	(9842,33,'San Giacomo in Colle',0,'1800-01-01',NULL,1),
	(9843,33,'San Michele di Postumia',0,'1800-01-01',NULL,1),
	(9844,33,'San Pietro del Carso',0,'1800-01-01',NULL,1),
	(9845,33,'Senosecchia',0,'1800-01-01',NULL,1),
	(9846,33,'Sesana',0,'1800-01-01',NULL,1),
	(9847,33,'Tomadio',0,'1800-01-01',NULL,1),
	(9848,33,'Villa Slavina',0,'1800-01-01',NULL,1),
	(9849,33,'Aurisina',0,'1800-01-01',NULL,1),
	(9850,33,'Duino',0,'1800-01-01',NULL,1),
	(9851,33,'Malchina',0,'1800-01-01',NULL,1),
	(9852,33,'San Pelagio',0,'1800-01-01',NULL,1),
	(9853,33,'Slivia',0,'1800-01-01',NULL,1),
	(9854,33,'Alber di Sesana',0,'1800-01-01',NULL,1),
	(9855,33,'Auremo di Sopra',0,'1800-01-01',NULL,1),
	(9856,33,'Caccia',0,'1800-01-01',NULL,1),
	(9857,33,'Capriva nel Carso',0,'1800-01-01',NULL,1),
	(9858,33,'Famie',0,'1800-01-01',NULL,1),
	(9859,33,'Lase',0,'1800-01-01',NULL,1),
	(9860,33,'Poverio',0,'1800-01-01',NULL,1),
	(9861,33,'Roditti',0,'1800-01-01',NULL,1),
	(9862,33,'Scoppo',0,'1800-01-01',NULL,1),
	(9863,33,'Senadole',0,'1800-01-01',NULL,1),
	(9864,33,'Storie',0,'1800-01-01',NULL,1),
	(9865,33,'Villabassa di Senosecchia',0,'1800-01-01',NULL,1),
	(9866,39,'Borgo San Bernardino',0,'1800-01-01',NULL,1),
	(9867,39,'Mortizza',0,'1800-01-01',NULL,1),
	(9868,39,'San Lazzaro Alberoni',0,'1800-01-01',NULL,1),
	(9869,39,'Sant',0,'1800-01-01',NULL,1),
	(9870,39,'Trebecco',0,'1800-01-01',NULL,1),
	(9871,40,'Boccolo de\' Tassi',0,'1800-01-01',NULL,1),
	(9872,40,'Cortile San Martino',0,'1800-01-01',NULL,1),
	(9873,40,'Golese',0,'1800-01-01',NULL,1),
	(9874,40,'Marore',0,'1800-01-01',NULL,1),
	(9875,40,'Pione',0,'1800-01-01',NULL,1),
	(9876,40,'San Donato d\'Enza',0,'1800-01-01',NULL,1),
	(9877,40,'San Lazzaro Parmense',0,'1800-01-01',NULL,1),
	(9878,40,'San Martino Sinzano',0,'1800-01-01',NULL,1),
	(9879,40,'San Pancrazio Parmense',0,'1800-01-01',NULL,1),
	(9880,40,'Vigatto',0,'1800-01-01',NULL,1),
	(9881,41,'Gazzano',0,'1800-01-01',NULL,1),
	(9882,43,'Borgo Panigale',0,'1800-01-01',NULL,1),
	(9883,43,'Musiano',0,'1800-01-01',NULL,1),
	(9884,46,'Fiumana',0,'1800-01-01',NULL,1),
	(9885,46,'Mortano',0,'1800-01-01',NULL,1),
	(9886,46,'Roversano',0,'1800-01-01',NULL,1),
	(9887,46,'Sorbano',0,'1800-01-01',NULL,1),
	(9888,46,'Teodorano',0,'1800-01-01',NULL,1),
	(9889,60,'Candelara',0,'1800-01-01',NULL,1),
	(9890,60,'Casteldimezzo',0,'1800-01-01',NULL,1),
	(9891,60,'Fenigli',0,'1800-01-01',NULL,1),
	(9892,60,'Fiorenzuola di Focara',0,'1800-01-01',NULL,1),
	(9893,60,'Ginestreto',0,'1800-01-01',NULL,1),
	(9894,60,'Isola di Fano',0,'1800-01-01',NULL,1),
	(9895,60,'Montalfoglio',0,'1800-01-01',NULL,1),
	(9896,60,'Montalto Tarugo',0,'1800-01-01',NULL,1),
	(9897,60,'Monte Montanaro',0,'1800-01-01',NULL,1),
	(9898,60,'Montebello Metaurense',0,'1800-01-01',NULL,1),
	(9899,60,'Montefabbri',0,'1800-01-01',NULL,1),
	(9900,60,'Monteguiduccio',0,'1800-01-01',NULL,1),
	(9901,60,'Monterolo',0,'1800-01-01',NULL,1),
	(9902,60,'Montesecco Antico',0,'1800-01-01',NULL,1),
	(9903,60,'Montevecchio',0,'1800-01-01',NULL,1),
	(9904,60,'Novillara',0,'1800-01-01',NULL,1),
	(9905,60,'Pozzo Alto',0,'1800-01-01',NULL,1),
	(9906,60,'San Vito sul Cesano',0,'1800-01-01',NULL,1),
	(9907,60,'Sant',0,'1800-01-01',NULL,1),
	(9908,60,'Scavolino',0,'1800-01-01',NULL,1),
	(9909,60,'Sorbolongo',0,'1800-01-01',NULL,1),
	(9910,60,'Torre San Marco',0,'1800-01-01',NULL,1),
	(9911,61,'Montesicuro',0,'1800-01-01',NULL,1),
	(9912,61,'Paterno d\'Ancona',0,'1800-01-01',NULL,1),
	(9913,61,'Rosora Mergo',0,'1800-01-01',NULL,1),
	(9914,62,'Porto Civitanova',0,'1800-01-01',NULL,1),
	(9915,63,'Alteta',0,'1800-01-01',NULL,1),
	(9916,63,'Capradosso',0,'1800-01-01',NULL,1),
	(9917,63,'Castel di Croce',0,'1800-01-01',NULL,1),
	(9918,63,'Lisciano del Tronto',0,'1800-01-01',NULL,1),
	(9919,63,'Montacuto',0,'1800-01-01',NULL,1),
	(9920,63,'Montadamo',0,'1800-01-01',NULL,1),
	(9921,63,'Montecalvo del Castellano',0,'1800-01-01',NULL,1),
	(9922,63,'Moregnano',0,'1800-01-01',NULL,1),
	(9923,63,'Mozzano',0,'1800-01-01',NULL,1),
	(9924,63,'Osoli',0,'1800-01-01',NULL,1),
	(9925,63,'Pagliare',0,'1800-01-01',NULL,1),
	(9926,63,'Patrignone',0,'1800-01-01',NULL,1),
	(9927,63,'Porchia',0,'1800-01-01',NULL,1),
	(9928,63,'Porchiano dell\'Ascensione',0,'1800-01-01',NULL,1),
	(9929,63,'Quintodecimo',0,'1800-01-01',NULL,1),
	(9930,63,'Ripaberarda',0,'1800-01-01',NULL,1),
	(9931,63,'Roccareonile',0,'1800-01-01',NULL,1),
	(9932,63,'Sant',0,'1800-01-01',NULL,1),
	(9933,63,'Santa Maria del Tronto',0,'1800-01-01',NULL,1),
	(9934,63,'Torre di Palme',0,'1800-01-01',NULL,1),
	(9935,48,'Albiano di Magra',0,'1800-01-01',NULL,1),
	(9936,48,'Apuania',0,'1800-01-01',NULL,1),
	(9937,48,'Terrarossa',0,'1800-01-01',NULL,1),
	(9938,50,'Montecatini di Val di Nievole',0,'1800-01-01',NULL,1),
	(9939,50,'Porta al Borgo',0,'1800-01-01',NULL,1),
	(9940,50,'Porta Carratica',0,'1800-01-01',NULL,1),
	(9941,50,'Porta Lucchese',0,'1800-01-01',NULL,1),
	(9942,50,'Porta San Marco',0,'1800-01-01',NULL,1),
	(9943,50,'Vellano',0,'1800-01-01',NULL,1),
	(9944,51,'Brozzi',0,'1800-01-01',NULL,1),
	(9945,51,'Galluzzo',0,'1800-01-01',NULL,1),
	(9946,51,'Legnaia',0,'1800-01-01',NULL,1),
	(9947,51,'Pellegrino da Careggi',0,'1800-01-01',NULL,1),
	(9948,51,'Rovezzano',0,'1800-01-01',NULL,1),
	(9949,53,'Montecalvoli',0,'1800-01-01',NULL,1),
	(9950,53,'Santa Luce Orciano',0,'1800-01-01',NULL,1),
	(9951,54,'Castiglion Ubertini',0,'1800-01-01',NULL,1),
	(9952,54,'Pratovecchio Stia',0,'1800-01-01',NULL,1),
	(9953,54,'Raggiolo',0,'1800-01-01',NULL,1),
	(9954,55,'Masse di Citt',0,'1800-01-01',NULL,1),
	(9955,55,'Masse di San Martino',0,'1800-01-01',NULL,1),
	(9956,55,'Masse di Siena',0,'1800-01-01',NULL,1),
	(9957,58,'Castel San Felice',0,'1800-01-01',NULL,1),
	(9958,58,'Castel San Giovanni di Spoleto',0,'1800-01-01',NULL,1),
	(9959,58,'Ceselli',0,'1800-01-01',NULL,1),
	(9960,58,'Collemancio',0,'1800-01-01',NULL,1),
	(9961,58,'Montesanto Vigi',0,'1800-01-01',NULL,1),
	(9962,58,'Pascelupo',0,'1800-01-01',NULL,1),
	(9963,58,'Piedipaterno sul Nera',0,'1800-01-01',NULL,1),
	(9964,59,'Capitone',0,'1800-01-01',NULL,1),
	(9965,59,'Carnaiola',0,'1800-01-01',NULL,1),
	(9966,59,'Castel di Lago',0,'1800-01-01',NULL,1),
	(9967,59,'Cesi',0,'1800-01-01',NULL,1),
	(9968,59,'Collescipoli',0,'1800-01-01',NULL,1),
	(9969,59,'Collestatte',0,'1800-01-01',NULL,1),
	(9970,59,'Montegiove',0,'1800-01-01',NULL,1),
	(9971,59,'Monterubbiaglio',0,'1800-01-01',NULL,1),
	(9972,59,'Papigno',0,'1800-01-01',NULL,1),
	(9973,59,'Piediluco',0,'1800-01-01',NULL,1),
	(9974,59,'Porchiano del Monte',0,'1800-01-01',NULL,1),
	(9975,59,'Portaria',0,'1800-01-01',NULL,1),
	(9976,59,'San Vito in Monte',0,'1800-01-01',NULL,1),
	(9977,59,'Torre Orsina',0,'1800-01-01',NULL,1),
	(9978,65,'Bagnaja',0,'1800-01-01',NULL,1),
	(9979,65,'Castel Cellesi',0,'1800-01-01',NULL,1),
	(9980,65,'Grotte Santo Stefano',0,'1800-01-01',NULL,1),
	(9981,65,'Roccalvecce',0,'1800-01-01',NULL,1),
	(9982,65,'San Martino al Cimino',0,'1800-01-01',NULL,1),
	(9983,65,'San Michele in Teverina',0,'1800-01-01',NULL,1),
	(9984,66,'Bocchignano',0,'1800-01-01',NULL,1),
	(9985,66,'Castel San Benedetto Reatino',0,'1800-01-01',NULL,1),
	(9986,66,'Cerchiara in Sabina',0,'1800-01-01',NULL,1),
	(9987,66,'Collebaccaro',0,'1800-01-01',NULL,1),
	(9988,66,'Monte Santa Maria in Sabina',0,'1800-01-01',NULL,1),
	(9989,66,'Oliveto in Sabina',0,'1800-01-01',NULL,1),
	(9990,66,'Poggio Fidoni',0,'1800-01-01',NULL,1),
	(9991,66,'Posticciola',0,'1800-01-01',NULL,1),
	(9992,66,'Rocchette',0,'1800-01-01',NULL,1),
	(9993,66,'San Giovanni Reatino',0,'1800-01-01',NULL,1),
	(9994,66,'Sant',0,'1800-01-01',NULL,1),
	(9995,66,'Vazia',0,'1800-01-01',NULL,1),
	(9996,67,'Boville',0,'1800-01-01',NULL,1),
	(9997,67,'Montecelio',0,'1800-01-01',NULL,1),
	(9998,67,'Nettunia',0,'1800-01-01',NULL,1),
	(9999,68,'Castellonorato',0,'1800-01-01',NULL,1),
	(10000,68,'Elena',0,'1800-01-01',NULL,1),
	(10001,68,'Maranola',0,'1800-01-01',NULL,1),
	(10002,69,'Roccaguglielma',0,'1800-01-01',NULL,1),
	(10003,69,'San Pietro in Curolis',0,'1800-01-01',NULL,1),
	(10004,69,'Sant',0,'1800-01-01',NULL,1),
	(10005,69,'Viticuso ed Acquafondata',0,'1800-01-01',NULL,1),
	(10006,76,'Albanova',0,'1800-01-01',NULL,1),
	(10007,76,'Arienzo San Felice',0,'1800-01-01',NULL,1),
	(10008,76,'Atella di Napoli',0,'1800-01-01',NULL,1),
	(10009,76,'Casalba',0,'1800-01-01',NULL,1),
	(10010,76,'Fertilia',0,'1800-01-01',NULL,1),
	(10011,76,'Frignano',0,'1800-01-01',NULL,1),
	(10012,76,'Lusciano e Ducenta',0,'1800-01-01',NULL,1),
	(10013,76,'San Leucio',0,'1800-01-01',NULL,1),
	(10014,76,'Villa Volturno',0,'1800-01-01',NULL,1),
	(10015,77,'Bagnara di Benevento',0,'1800-01-01',NULL,1),
	(10016,77,'Civitella Licinio',0,'1800-01-01',NULL,1),
	(10017,77,'Luzzano',0,'1800-01-01',NULL,1),
	(10018,77,'Montorso',0,'1800-01-01',NULL,1),
	(10019,77,'Pastene',0,'1800-01-01',NULL,1),
	(10020,77,'Perrillo',0,'1800-01-01',NULL,1),
	(10021,77,'San Marco a Monti',0,'1800-01-01',NULL,1),
	(10022,77,'Varoni',0,'1800-01-01',NULL,1),
	(10023,78,'Barra',0,'1800-01-01',NULL,1),
	(10024,78,'Chiaiano ed Uniti',0,'1800-01-01',NULL,1),
	(10025,78,'Licignano di Napoli',0,'1800-01-01',NULL,1),
	(10026,78,'Pianura',0,'1800-01-01',NULL,1),
	(10027,78,'Piscinola',0,'1800-01-01',NULL,1),
	(10028,78,'Ponticelli',0,'1800-01-01',NULL,1),
	(10029,78,'San Giovanni a Teduccio',0,'1800-01-01',NULL,1),
	(10030,78,'San Pietro a Patierno',0,'1800-01-01',NULL,1),
	(10031,78,'Sant',0,'1800-01-01',NULL,1),
	(10032,78,'Secondigliano',0,'1800-01-01',NULL,1),
	(10033,78,'Sirico',0,'1800-01-01',NULL,1),
	(10034,78,'Soccavo',0,'1800-01-01',NULL,1),
	(10035,78,'Testaccio d\'Ischia',0,'1800-01-01',NULL,1),
	(10036,79,'Bellizzi Irpino',0,'1800-01-01',NULL,1),
	(10037,79,'Chianchetelle',0,'1800-01-01',NULL,1),
	(10038,79,'Migliano',0,'1800-01-01',NULL,1),
	(10039,79,'Quaglietta',0,'1800-01-01',NULL,1),
	(10040,79,'San Barbato',0,'1800-01-01',NULL,1),
	(10041,79,'San Pietro Irpino',0,'1800-01-01',NULL,1),
	(10042,79,'Sant\'Agata Irpina',0,'1800-01-01',NULL,1),
	(10043,79,'Tavernola San Felice',0,'1800-01-01',NULL,1),
	(10044,80,'Capitello',0,'1800-01-01',NULL,1),
	(10045,80,'Castelruggiero',0,'1800-01-01',NULL,1),
	(10046,80,'Fogna',0,'1800-01-01',NULL,1),
	(10047,80,'Galdo',0,'1800-01-01',NULL,1),
	(10048,80,'Licusati',0,'1800-01-01',NULL,1),
	(10049,80,'Piaggine Soprane',0,'1800-01-01',NULL,1),
	(10050,70,'Arischia',0,'1800-01-01',NULL,1),
	(10051,70,'Bagno',0,'1800-01-01',NULL,1),
	(10052,70,'Camarda',0,'1800-01-01',NULL,1),
	(10053,70,'Paganica',0,'1800-01-01',NULL,1),
	(10054,70,'Preturo',0,'1800-01-01',NULL,1),
	(10055,70,'Roio Piano',0,'1800-01-01',NULL,1),
	(10056,70,'Sassa',0,'1800-01-01',NULL,1),
	(10057,71,'Valle San Giovanni',0,'1800-01-01',NULL,1),
	(10058,72,'Castellammare Adriatico',0,'1800-01-01',NULL,1),
	(10059,72,'Montesilvano Marina',0,'1800-01-01',NULL,1),
	(10060,72,'Musellaro',0,'1800-01-01',NULL,1),
	(10061,72,'Roccacaramanico',0,'1800-01-01',NULL,1),
	(10062,73,'Fallascoso',0,'1800-01-01',NULL,1),
	(10063,73,'San Silvestro',0,'1800-01-01',NULL,1),
	(10064,82,'Canneto di Bari',0,'1800-01-01',NULL,1),
	(10065,82,'Carbonara di Bari',0,'1800-01-01',NULL,1),
	(10066,82,'Ceglie del Campo',0,'1800-01-01',NULL,1),
	(10067,82,'Loseto',0,'1800-01-01',NULL,1),
	(10068,82,'Montrone',0,'1800-01-01',NULL,1),
	(10069,87,'Castelluccio',0,'1800-01-01',NULL,1),
	(10070,89,'Aiello in Calabria',0,'1800-01-01',NULL,1),
	(10071,89,'Guardia Piemontese Terme',0,'1800-01-01',NULL,1),
	(10072,89,'Laino Bruzio',0,'1800-01-01',NULL,1),
	(10073,89,'Spezzano Grande',0,'1800-01-01',NULL,1),
	(10074,89,'Terrati',0,'1800-01-01',NULL,1),
	(10075,90,'Nicastro',0,'1800-01-01',NULL,1),
	(10076,90,'Sambiase',0,'1800-01-01',NULL,1),
	(10077,90,'Sant',0,'1800-01-01',NULL,1),
	(10078,90,'Castagna',0,'1800-01-01',NULL,1),
	(10079,90,'Piscopio',0,'1800-01-01',NULL,1),
	(10080,91,'Cannitello',0,'1800-01-01',NULL,1),
	(10081,91,'Carid',0,'1800-01-01',NULL,1),
	(10082,91,'Cataforio',0,'1800-01-01',NULL,1),
	(10083,91,'Catona',0,'1800-01-01',NULL,1),
	(10084,91,'Gallico',0,'1800-01-01',NULL,1),
	(10085,91,'Gallina',0,'1800-01-01',NULL,1),
	(10086,91,'Iatrinoli',0,'1800-01-01',NULL,1),
	(10087,91,'Orti',0,'1800-01-01',NULL,1),
	(10088,91,'Paracorio',0,'1800-01-01',NULL,1),
	(10089,91,'Pedavoli',0,'1800-01-01',NULL,1),
	(10090,91,'Pellaro',0,'1800-01-01',NULL,1),
	(10091,91,'Podargoni',0,'1800-01-01',NULL,1),
	(10092,91,'Radicena',0,'1800-01-01',NULL,1),
	(10093,91,'Rosal',0,'1800-01-01',NULL,1),
	(10094,91,'Salice Calabro',0,'1800-01-01',NULL,1),
	(10095,91,'Sambatello',0,'1800-01-01',NULL,1),
	(10096,91,'Samo di Calabria',0,'1800-01-01',NULL,1),
	(10097,91,'San Pier Fedele',0,'1800-01-01',NULL,1),
	(10098,91,'Tresilico',0,'1800-01-01',NULL,1),
	(10099,91,'Villa San Giuseppe',0,'1800-01-01',NULL,1),
	(10100,94,'Xitta',0,'1800-01-01',NULL,1),
	(10101,96,'Bauso',0,'1800-01-01',NULL,1),
	(10102,96,'Calvaruso',0,'1800-01-01',NULL,1),
	(10103,96,'Guidomandri',0,'1800-01-01',NULL,1),
	(10104,96,'Lanza',0,'1800-01-01',NULL,1),
	(10105,96,'Locadi',0,'1800-01-01',NULL,1),
	(10106,96,'Salina',0,'1800-01-01',NULL,1),
	(10107,96,'Santo Stefano di Briga',0,'1800-01-01',NULL,1),
	(10108,96,'Spadafora San Martino',0,'1800-01-01',NULL,1),
	(10109,96,'Spadafora San Pietro',0,'1800-01-01',NULL,1),
	(10110,99,'Carcaci',0,'1800-01-01',NULL,1),
	(10111,100,'Ionia',0,'1800-01-01',NULL,1),
	(10112,100,'San Giovanni di Galermo',0,'1800-01-01',NULL,1),
	(10113,101,'Ragusa Ibla',0,'1800-01-01',NULL,1),
	(10114,103,'Bantine',0,'1800-01-01',NULL,1),
	(10115,103,'Nuchis',0,'1800-01-01',NULL,1),
	(10116,103,'Rebeccu',0,'1800-01-01',NULL,1),
	(10117,104,'Garofai',0,'1800-01-01',NULL,1),
	(10118,104,'Irgoli di Galtelli',0,'1800-01-01',NULL,1),
	(10119,104,'Mulargia',0,'1800-01-01',NULL,1),
	(10120,104,'Tortol',0,'1800-01-01',NULL,1),
	(10121,105,'Arixi',0,'1800-01-01',NULL,1),
	(10122,105,'Donigala Siurgus',0,'1800-01-01',NULL,1),
	(10123,105,'Pirri',0,'1800-01-01',NULL,1),
	(10124,105,'San Pantaleo',0,'1800-01-01',NULL,1),
	(10125,105,'Serbariu',0,'1800-01-01',NULL,1),
	(10126,105,'Seuni',0,'1800-01-01',NULL,1),
	(10127,105,'Sicci San Biagio',0,'1800-01-01',NULL,1),
	(10128,105,'Sisini',0,'1800-01-01',NULL,1),
	(10129,105,'Siurgus',0,'1800-01-01',NULL,1),
	(10130,105,'Villagreca',0,'1800-01-01',NULL,1),
	(10131,34,'Vallenoncello',0,'1800-01-01',NULL,1),
	(10132,75,'Castellone al Volturno',0,'1800-01-01',NULL,1),
	(10133,75,'San Vincenzo a Volturno',0,'1800-01-01',NULL,1),
	(10134,106,'Domusnovas Canales',0,'1800-01-01',NULL,1),
	(10135,106,'Donigala Fenughedu',0,'1800-01-01',NULL,1),
	(10136,106,'Escovedu',0,'1800-01-01',NULL,1),
	(10137,106,'Figu',0,'1800-01-01',NULL,1),
	(10138,106,'Gonnosn',0,'1800-01-01',NULL,1),
	(10139,106,'Massama',0,'1800-01-01',NULL,1),
	(10140,106,'Nuraxinieddu',0,'1800-01-01',NULL,1),
	(10141,106,'San Vero Congius',0,'1800-01-01',NULL,1),
	(10142,106,'Siamanna',0,'1800-01-01',NULL,1),
	(10143,106,'Sil',0,'1800-01-01',NULL,1),
	(10144,106,'Solanas',0,'1800-01-01',NULL,1),
	(10145,106,'Zeppara',0,'1800-01-01',NULL,1),
	(10146,106,'Zuri',0,'1800-01-01',NULL,1),
	(10147,7,'Mosso Santa Maria',0,'1800-01-01',NULL,1),
	(10148,7,'Pistolesa',0,'1800-01-01',NULL,1),
	(10149,111,'Abbazia',0,'1800-01-01',NULL,1),
	(10150,111,'Castel Iablanizza',0,'1800-01-01',NULL,1),
	(10151,111,'Castelnuovo d\'Istria',0,'1800-01-01',NULL,1),
	(10152,111,'Clana',0,'1800-01-01',NULL,1),
	(10153,111,'Elsane',0,'1800-01-01',NULL,1),
	(10154,111,'Fiume',0,'1800-01-01',NULL,1),
	(10155,111,'Fontana del Conte',0,'1800-01-01',NULL,1),
	(10156,111,'Laurana',0,'1800-01-01',NULL,1),
	(10157,111,'Matteria',0,'1800-01-01',NULL,1),
	(10158,111,'Mattuglie',0,'1800-01-01',NULL,1),
	(10159,111,'Valsantamarina',0,'1800-01-01',NULL,1),
	(10160,111,'Primano',0,'1800-01-01',NULL,1),
	(10161,111,'Villa del Nevoso',0,'1800-01-01',NULL,1),
	(10162,111,'Apriano',0,'1800-01-01',NULL,1),
	(10163,111,'Berdo San Giovanni',0,'1800-01-01',NULL,1),
	(10164,111,'Bersezio del Quarnaro',0,'1800-01-01',NULL,1),
	(10165,111,'Bisterza',0,'1800-01-01',NULL,1),
	(10166,111,'Ceglie',0,'1800-01-01',NULL,1),
	(10167,111,'Monte Chilovi',0,'1800-01-01',NULL,1),
	(10168,111,'Retacevo in Monte',0,'1800-01-01',NULL,1),
	(10169,111,'Sagoria San Martino',0,'1800-01-01',NULL,1),
	(10170,111,'Smeria',0,'1800-01-01',NULL,1),
	(10171,111,'Torrenova di Bisterza',0,'1800-01-01',NULL,1),
	(10172,111,'Volosca-Abbazia',0,'1800-01-01',NULL,1),
	(10173,112,'Albona',0,'1800-01-01',NULL,1),
	(10174,112,'Antignana',0,'1800-01-01',NULL,1),
	(10175,112,'Arsia',0,'1800-01-01',NULL,1),
	(10176,112,'Barbana d\'Istria',0,'1800-01-01',NULL,1),
	(10177,112,'Bogliuno',0,'1800-01-01',NULL,1),
	(10178,112,'Brioni Maggiore',0,'1800-01-01',NULL,1),
	(10179,112,'Buie d\'Istria',0,'1800-01-01',NULL,1),
	(10180,112,'Canfanaro',0,'1800-01-01',NULL,1),
	(10181,112,'Capodistria',0,'1800-01-01',NULL,1),
	(10182,112,'Cherso',0,'1800-01-01',NULL,1),
	(10183,112,'Cittanova d\'Istria',0,'1800-01-01',NULL,1),
	(10184,112,'Dignano d\'Istria',0,'1800-01-01',NULL,1),
	(10185,112,'Erpelle-Cosina',0,'1800-01-01',NULL,1),
	(10186,112,'Fianona',0,'1800-01-01',NULL,1),
	(10187,112,'Gimino',0,'1800-01-01',NULL,1),
	(10188,112,'Grisignana',0,'1800-01-01',NULL,1),
	(10189,112,'Isola d\'Istria',0,'1800-01-01',NULL,1),
	(10190,112,'Lanischie',0,'1800-01-01',NULL,1),
	(10191,112,'Lussingrande',0,'1800-01-01',NULL,1),
	(10192,112,'Lussinpiccolo',0,'1800-01-01',NULL,1),
	(10193,112,'Maresego',0,'1800-01-01',NULL,1),
	(10194,112,'Monte di Capodistria',0,'1800-01-01',NULL,1),
	(10195,112,'Montona',0,'1800-01-01',NULL,1),
	(10196,112,'Neresine',0,'1800-01-01',NULL,1),
	(10197,112,'Orsera',0,'1800-01-01',NULL,1),
	(10198,112,'Ossero',0,'1800-01-01',NULL,1),
	(10199,112,'Parenzo',0,'1800-01-01',NULL,1),
	(10200,112,'Pinguente',0,'1800-01-01',NULL,1),
	(10201,112,'Pirano',0,'1800-01-01',NULL,1),
	(10202,112,'Pisino',0,'1800-01-01',NULL,1),
	(10203,112,'Pola',0,'1800-01-01',NULL,1),
	(10204,112,'Portole',0,'1800-01-01',NULL,1),
	(10205,112,'Rovigno d\'Istria',0,'1800-01-01',NULL,1),
	(10206,112,'Rozzo',0,'1800-01-01',NULL,1),
	(10207,112,'Sanvincenti',0,'1800-01-01',NULL,1),
	(10208,112,'Umago',0,'1800-01-01',NULL,1),
	(10209,112,'Valdarsa',0,'1800-01-01',NULL,1),
	(10210,112,'Valle d\'Istria',0,'1800-01-01',NULL,1),
	(10211,112,'Verteneglio',0,'1800-01-01',NULL,1),
	(10212,112,'Villa Decani',0,'1800-01-01',NULL,1),
	(10213,112,'Visignano d\'Istria',0,'1800-01-01',NULL,1),
	(10214,112,'Visinada',0,'1800-01-01',NULL,1),
	(10215,112,'Draguccio',0,'1800-01-01',NULL,1),
	(10216,112,'Occisla-Clanzo',0,'1800-01-01',NULL,1),
	(10217,113,'Lagosta',0,'1800-01-01',NULL,1),
	(10218,113,'Zara',0,'1800-01-01',NULL,1);
