<?php

namespace Schema31\GeoBundle\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormInterface;

use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Doctrine\ORM\EntityRepository;

use Schema31\GeoBundle\Model\LuogoNascita;
use Schema31\GeoBundle\Entity\GeoComune;

/**
 * Descrizione di GeoStatoType
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class LuogoNascitaType extends AbstractType {
    const ITALIA_ID = 1;

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('stato', GeoStatoType::class);
        
        $formModifier = function(FormInterface $form, ?int $statoId, ?int $provinciaId) use ($comuneModifier){      
            $hasProvincia = !is_null($statoId) && $statoId == self::ITALIA_ID;
            
            $optionsProvincia = [];
            $optionsProvincia['disabled'] = !$hasProvincia;
            $optionsProvincia['required'] = $hasProvincia;
                        
            $optionsComune = ['class' => GeoComune::class];
            if (is_null($provinciaId)) {
                $optionsComune['choices'] = [];
                $optionsComune['disabled'] = true;
                $optionsComune['required'] = false;
            } else {
                $optionsComune['disabled'] = false;
                $optionsComune['required'] = true;
                $optionsComune['query_builder'] = function (EntityRepository $er) use ($provinciaId){
                    return $er->createQueryBuilder('g')
                    ->where('g.provincia = '.$provinciaId)
                    ->orderBy('g.denominazione', 'ASC');
                };
            }
            
            $form->add('provincia', GeoProvinciaType::class, $optionsProvincia);
            $form->add('comune', EntityType::class, $optionsComune);                
        };
           
        $builder->addEventListener(
            FormEvents::PRE_SET_DATA,
            function (FormEvent $event) use ($formModifier){
                $stato = $event->getData()->getStato();
                $provincia = $event->getData()->getProvincia();
                
                $formModifier($event->getForm(), is_null($stato) ? null : $stato->getId(), is_null($provincia) ? null : $provincia->getId());
            }                
        );
        
        $builder->addEventListener(
            FormEvents::PRE_SUBMIT, 
            function (FormEvent $event) use ($formModifier){
                $data = $event->getData();

                $formModifier($event->getForm(), isset($data['stato']) ? (int) $data['stato'] : null, isset($data['provincia']) ? (int) $data['provincia'] : null);
            }
        );                       
    }
    
    public function configureOptions(OptionsResolver $resolver) 
    {
        $resolver->setDefaults(array(
            "data_class" => LuogoNascita::class
        ));
    } 
    
    public function getParent() {
        return \Symfony\Component\Form\Extension\Core\Type\FormType::class;
    }

}
