<?php

namespace Schema31\GeoBundle\Controller;

use Symfony\Component\HttpKernel\Controller;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;

use Schema31\GeoBundle\Entity\GeoComune;

/**
 * Description of ComuneController
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class ComuneController extends Controller {
    
    /**
     * @Route("/byProvincia/{provinciaId}")
     */
    public function comuniByProvinciaAction($provinciaId)
    {
        $em = $this->get('doctrine')->getManager();
        
        $comuni = $em->getRepository(GeoComune::class)->findBy(['provincia' => $provinciaId]);
        
        $result = new \stdClass();
        $result->count = count($comuni);
        $result->items = array_map(function($comune) { 
            $result = new \stdClass(); 
            $result->id = $comune->getId();   
            $result->denominazione = $comune->getDenominazione();
        }, $comuni);

        return new JsonResponse($result);
    }
}
