<?php

namespace Schema31\Exceptions\Operation;

use Schema31\Exceptions\Tag\InvalidDataTag;

/**
 * Description of ValidationException
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class ValidationException extends \Exception implements InvalidDataTag {
    private $errors = [];

    public static function createWithError(string $errorCode, string $errorDescription) {   
        $error = new \stdClass();
        $error->code = $errorCode;
        $error->description = $errorDescription;
        
        $exception = new self();
        $exception->setValidationErrors([$error]);
        
        return $exception;
    }
    
    public function getValidationErrors() {
        return $this->errors;
    }
    
    public function setValidationErrors($errors) {
        $this->errors = $errors;
    }
    
    public function addError(string $errorCode, string $errorDescription) {
        $error = new \stdClass();
        $error->code = $errorCode;
        $error->description = $errorDescription;

        $this->errors[] = $error;
    }

}
