<?php

namespace Schema31\Exceptions\Operation;

use Schema31\Exceptions\Tag\InvalidDataTag;

/**
 * Description of ValidationException
 *
 * @author gorlando
 */
class ValidationException extends \Exception implements InvalidDataTag {
    private $errors;
    
    public static function createWithError($errorCode, $errorDescription) {   
        $error = new \stdClass();
        $error->code = $errorCode;
        $error->description = $errorDescription;
        
        $exception = new self();
        $exception->setValidationErrors([$error]);
        
        return $exception;
    }
    
    public function getValidationErrors() {
        return $this->errors;
    }
    
    public function setValidationErrors($errors) {
        $this->errors = $errors;
    }

}
