<?php

namespace Schema31\EnumBundle\Serializer\Normalizer;

use Symfony\Component\Serializer\Normalizer\ContextAwareNormalizerInterface;
use Symfony\Component\Serializer\Normalizer\ContextAwareDenormalizerInterface;

use MyCLabs\Enum\Enum;

/**
 * Description of EnumNormalizer
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class EnumNormalizer implements ContextAwareNormalizerInterface, ContextAwareDenormalizerInterface {
    
    public function normalize($object, $format = null, array $context = array()) {
        return $object->getKey();
    }

    public function supportsNormalization($data, $format = null, array $context = array()) {
        return $data instanceof Enum;
    }

    public function denormalize($data, $type, $format = null, array $context = array()) {
        return $type::$data();
    }

    public function supportsDenormalization($data, $type, $format = null, array $context = array()) {
        return is_subclass_of($type, Enum::class);
    }

}
