<?php

declare(strict_types=1);

namespace Schema31\EnumBundle\HttpKernel\Controller\ArgumentResolver;

use MyCLabs\Enum\Enum;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Controller\ArgumentValueResolverInterface;
use Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadata;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;

class EnumValueResolver implements ArgumentValueResolverInterface {
    /**
     * {@inheritdoc}
     */
    public function supports(Request $request, ArgumentMetadata $argument) {
        return \is_subclass_of($argument->getType(), Enum::class);
    }

    /**
     * {@inheritdoc}
     */
    public function resolve(Request $request, ArgumentMetadata $argument) {
        /** @var Enum $enumClass */
        $enumClass = $argument->getType();
        $requestValue = $request->get($argument->getName());

        if (!\is_array($requestValue) || !$argument->isVariadic()) {
            $requestValue = [$requestValue];
        }

        foreach ($requestValue as $value) {
            if ($enumClass::isValidKey($value)) {
                yield $enumClass::$value();

                continue;
            }

            if (null !== $value || !$argument->isNullable()) {
                throw new BadRequestHttpException(sprintf('Enum "%s" does not accept value %s', $enumClass, var_export($value, true)));
            }

            yield null;
        }
    }
}
