<?php

namespace Schema31\EnumBundle\Form\Type;

use MyCLabs\Enum\Enum;
use Schema31\EnumBundle\Form\DataTransformer\ValueToEnumTransformer;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\Options;
use Symfony\Component\OptionsResolver\OptionsResolver;

class EnumType extends AbstractType {
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $transformer = new ValueToEnumTransformer($options['enum_class']);

        $builder->addModelTransformer($transformer);
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver) {
        $resolver
            ->setDefaults([
                'choices' => function (Options $options) {
                    /** @var string $enumClass */
                    $enumClass = $options['enum_class'];

                    return array_flip($enumClass::toArray());
                },
            ])
            ->setRequired('enum_class')
            ->setAllowedValues('enum_class', static function ($value) {
                return is_a($value, Enum::class, true);
            });
    }

    /**
     * {@inheritdoc}
     */
    public function getParent() {
        return ChoiceType::class;
    }
}
