<?php

namespace Schema31\DocumentBundle\Service;

use Schema31\DocumentBundle\Model\Document;
use Schema31\DocumentBundle\Model\StorageDocument;
use Schema31\GCloudStorageSDK\gCloud_Storage;

/**
 * Description of Storage
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class Storage {
    
    private $defaultRepository;
    private $defaultAuthentication;
    private $client;
    
    public function __construct(string $defaultRepository, string $defaultAuthentication) {
        $this->defaultRepository = $defaultRepository;
        $this->defaultAuthentication = $defaultAuthentication;
        $this->client = new gCloud_Storage();
    }
  
    public function write(StorageDocument $document): string {
        $this->setupClient($document);
        $fileKey = $this->client->sendFile($document->getUploadedFile()->getRealPath(), $document->getMimeType(), $document->getOriginalName()); 
        
        if (!$fileKey) {
            throw new \Exception();
        }
        
        $document->setFileKey($fileKey);

        return $fileKey;
    }
    
    public function stream(StorageDocument $document) {
        $this->setupClient($document);        
        $this->client->streamFile($document->getFileKey());        
    } 
    
    public function delete(StorageDocument $document) {
        $this->setupClient($document);     
        $this->client->deleteFile($document->getFileKey());       
    }    
    
    private function setupClient(StorageDocument $document) {
        $this->client->repositoryName = $document->getRepositoryName() ?? $this->defaultRepository;
        $this->client->Authentication = $document->getAuthentication() ?? $this->defaultAuthentication;            
    }
}
