<?php

namespace Schema31\DocumentBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * Description of Configuration
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class Configuration implements ConfigurationInterface
{
    
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('schema31_document');

        $treeBuilder->getRootNode()
            ->children()
                ->arrayNode('storage')
                    ->children()
                        ->scalarNode('repository')->end()
                        ->scalarNode('authentication')->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
