<?php

namespace Schema31\DocumentBundle\Type;

use Schema31\DocumentBundle\Model\StorageDocument;
use Symfony\Component\Form\DataMapperInterface;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class StorageDocType extends BlobDocumentType implements DataMapperInterface {
    public function buildForm(FormBuilderInterface $builder, array $options) {
        parent::buildForm($builder, $options);

        $this->options = $options;
    }

    public function mapFormsToData($forms, &$viewData) {
        /** @var FormInterface[] $forms */
        $forms = iterator_to_array($forms);

        $file = $forms['uploadedFile']->getData();

        $viewData->setUploadedFile($file);
        $viewData->setOriginalName(\urldecode($file->getClientOriginalName()));
        $viewData->setSize($file->getSize());
        $viewData->setMimeType($file->getMimeType());
        $viewData->setHash(hash_file("sha256", $file->getRealPath()));
        $viewData->setUploadDate(new \DateTime());
        $viewData->setToDelete(false);
    }

    public function configureOptions(OptionsResolver $resolver) {
        parent::configureOptions($resolver);

        $resolver->setDefaults([
            'data_class' => StorageDocument::class,
        ]);
    }
}
