<?php

namespace Schema31\DocumentBundle\Model;

use Doctrine\ORM\Mapping as ORM;

/**
 * Description of StorageDocument
 * 
 * @ORM\MappedSuperclass
 * 
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class StorageDocument extends Document {

    /**
     * @var string $filekey
     * 
     * @ORM\Column(type="string", length=36, nullable=true)
     */
    protected $fileKey; 
    
    /**
     * @var string $repositoryName
     * 
     * @ORM\Column(type="string", nullable=true)
     */
    protected $repositoryName; 

    /**
     * @var string $encryptionKey
     * 
     * @ORM\Column(type="string", nullable=true)
     */
    protected $encryptionKey;
    
    /**
     * @var string $toDelete
     * 
     * @ORM\Column(type="boolean", nullable=false)
     */
    protected $toDelete;   
    
    /**
     * @var string $authentication
     */
    protected $authentication;

    public function getRepositoryName() {
        return $this->repositoryName;
    }

    public function getEncryptionKey() {
        return $this->encryptionKey;
    }
    
    public function getToDelete() {
        return $this->toDelete;
    }
    
    public function getFileKey() {
        return $this->fileKey;
    }

    public function setFileKey(string $fileKey) {
        $this->fileKey = $fileKey;
    }

    public function setRepositoryName(string $repositoryName) {
        $this->repositoryName = $repositoryName;
    }

    public function setEncryptionKey(string $encryptionKey) {
        $this->encryptionKey = $encryptionKey;
    }
    
    public function setToDelete(bool $toDelete) {
        $this->toDelete = $toDelete;
    }   
    
    public function getAuthentication(): ?string {
        return $this->authentication;
    }

    public function setAuthentication(string $authentication) {
        $this->authentication = $authentication;
    }

}
