<?php

namespace Schema31\DocumentBundle\Type;

use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\DataMapperInterface;

/**
 * Descrizione di BlobStorageDocumentType
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class BlobStorageDocumentType extends BlobDocumentType implements DataMapperInterface {
            
    public function mapFormsToData($forms, &$viewData)
    {
        /** @var FormInterface[] $forms */
        $forms = iterator_to_array($forms);
        
        $file = $forms['uploadedFile']->getData();
        
        // se il file caricato è null e viene richiesta la cancelazione, marchiamo per la cancellazione e ritorniamo null
        if (is_null($file) && isset($forms['toDelete']) && $forms['toDelete']->getData() == "1") {
            $viewData->setToDelete(true);
            $viewData = null;
            return;
        }
        
        // se il file caricato è null, il documento rimane invariato
        if (is_null($file)) {
            return;
        }
        
        // se viene caricato un nuovo file, marchiamo quello vecchio per la cancellazione e ne torniamo uno nuovo
        $viewData->setToDelete(true);
        
        $viewData = clone $viewData;
        
        $this->mapFormToDocument($file, $viewData);
        
        $viewData->setToDelete(false);
    }

}
