<?php

namespace Schema31\DocumentBundle\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormView;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\DataMapperInterface;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\OptionsResolver\OptionsResolver;

use Symfony\Component\HttpFoundation\File\UploadedFile;

use Schema31\DocumentBundle\Model\Document;

/**
 * Descrizione di BlobDocumentType
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class BlobDocumentType extends AbstractType implements DataMapperInterface {
    
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder->addEventListener(
            FormEvents::PRE_SET_DATA,
            function (FormEvent $event) use ($options){
                $document = $event->getData();
                $required = $options['required'] && (is_null($document) || is_null($document->getId()));
                
                $options = array_merge(['required' => $required], $options['uploader_options']);
                
                $event->getForm()->add('uploadedFile', \Symfony\Component\Form\Extension\Core\Type\FileType::class, $options);
            }                
        );        
           
        if (!$options['required']) {
            $builder->add('toDelete', \Symfony\Component\Form\Extension\Core\Type\HiddenType::class, ['mapped' => false]);
        }
        
        $builder->setDataMapper($this);
    }

    public function configureOptions(OptionsResolver $resolver) 
    {
        $resolver->setDefaults(array(
            'data_class' => Document::class,
            'uploader_options' => []
        ));                         
    }  
    
    public function buildView(FormView $view, FormInterface $form, array $options) {
        if ($view->vars && $view->vars['value'] && \property_exists($view->vars['value'], 'getId') && $view->vars['value']->getId()) {
            $view->vars['uploadedFile'] = $view->vars['value']; 
        } else {
            $view->vars['uploadedFile'] = null;
        }
    }
    
    public function mapFormsToData($forms, &$viewData)
    {
        /** @var FormInterface[] $forms */
        $forms = iterator_to_array($forms);
        
        $file = $forms['uploadedFile']->getData();
        
        if (is_null($file) && isset($forms['toDelete']) && $forms['toDelete']->getData() == "1") {
            $viewData = null;
            return;
        }
        
        if (is_null($file)) {
            return;
        }
        
        $this->mapFormToDocument($file, $viewData);
    }
    
    protected function mapFormToDocument(UploadedFile $file, Document &$viewData) {
        $viewData->setUploadedFile($file);
        $viewData->setOriginalName(\urldecode($file->getClientOriginalName()));
        $viewData->setSize($file->getSize());
        $viewData->setMimeType($file->getMimeType());
        $viewData->setContent(file_get_contents($file->getRealPath()));
        $viewData->setHash(hash_file("sha256", $file->getRealPath()));
        $viewData->setUploadDate(new \DateTime());        
    }

    public function mapDataToForms($viewData, $forms) {
        
    }


}
