<?php

namespace Schema31\DocumentBundle\Validator\Constraints;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

use Schema31\P7MDecoder\P7MDecoder;

/**
 * Description of P7MSignedDocumentValidator
 * 
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class P7MSignedDocumentValidator extends ConstraintValidator {
    
    public function validate($value, Constraint $constraint) {
        $file = $value->getUploadedFile();
        if (is_null($file)) {
            return;
        }
        
        $p7mDecoder = new P7MDecoder();
        try {
            $result = $p7mDecoder->verifyFileSignature($file->getRealPath(), false, $constraint->fiscalCodes);
        } catch (\Exception $e) {
            $this->context->buildViolation($constraint->notSignedMessage)->addViolation();
            return;
        }
     
        if (!$result->isSignatureValid()) {
            $this->context->buildViolation($constraint->notSignedMessage)->addViolation();
        }        
    }

}
