<?php

namespace Schema31\DocumentBundle\Type;

use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\DataMapperInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\FormBuilderInterface;

use Schema31\DocumentBundle\Service\Storage;

/**
 * Descrizione di StorageDocumentType
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class StorageDocumentType extends BlobDocumentType implements DataMapperInterface {
    
    private $storage;
    private $options;
    
    public function __construct(Storage $storage) {
        $this->storage = $storage;
    }
    
    public function buildForm(FormBuilderInterface $builder, array $options) {
        parent::buildForm($builder, $options);
        
        $this->options = $options;
    }    
            
    public function mapFormsToData($forms, &$viewData)
    {
        /** @var FormInterface[] $forms */
        $forms = iterator_to_array($forms);
        
        $file = $forms['uploadedFile']->getData();
        
        // se il file caricato è null e viene richiesta la cancelazione, marchiamo per la cancellazione e ritorniamo null
        if (is_null($file) && isset($forms['toDelete']) && $forms['toDelete']->getData() == "1") {
            $viewData->setToDelete(true);
            $viewData = null;
            return;
        }
        
        // se il file caricato è null, il documento rimane invariato
        if (is_null($file)) {
            return;
        }
        
        // se viene caricato un nuovo file, marchiamo quello vecchio per la cancellazione e ne torniamo uno nuovo
        $viewData->setToDelete(true);
        
        $viewData = clone $viewData;
          
        $viewData->setUploadedFile($file);
        $viewData->setOriginalName(\urldecode($file->getClientOriginalName()));
        $viewData->setSize($file->getSize());
        $viewData->setMimeType($file->getMimeType());
        $viewData->setHash(hash_file("sha256", $file->getRealPath()));
        $viewData->setUploadDate(new \DateTime());
        $viewData->setToDelete(false);
        
        if (isset($this->options["repositoryName"])) {
            $viewData->setRepositoryName($this->options["repositoryName"]);
        }
        
        if (isset($this->options["authentication"])) {
            $viewData->setAuthentication($this->options["authentication"]);
        }
        
        $this->storage->write($viewData);
    }
    
    public function configureOptions(OptionsResolver $resolver) 
    {
        parent::configureOptions($resolver) ;
        
        $resolver->setDefaults(array(
            'repository' => null,
            'authentication' => null
        ));          
    }     

}
