<?php

namespace Schema31\DocumentBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\Config\FileLocator;

use Schema31\DocumentBundle\Service\Storage;

/**
 * Description of Schema31DocumentExtension
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class Schema31DocumentExtension extends Extension {
    
    public function load(array $configs, ContainerBuilder $container) {
        $loader = new YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('services.yml');   
        
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);   
        
        $definition = $container->getDefinition(Storage::class);
        $definition->replaceArgument(0, $config['storage']['repository']);
        $definition->replaceArgument(1, $config['storage']['authentication']);        
    }

}
