<?php

namespace Schema31\DocumentBundle\Service;

use Schema31\DocumentBundle\Model\Document;
use Schema31\GCloudStorageSDK\gCloud_Storage;

/**
 * Description of Storage
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class Storage {
    
    private $defaultRepository;
    private $defaultAuthentication;
    
    public function __construct(string $defaultRepository, string $defaultAuthentication) {
        $this->defaultRepository = $defaultRepository;
        $this->defaultAuthentication = $defaultAuthentication;
    }
  
    public function write(Document $document) {
        $storage31 = new gCloud_Storage();
        $storage31->repositoryName = $document->getRepositoryName() ?? $this->defaultRepository;
        $storage31->Authentication = $document->getAuthentication() ?? $this->defaultAuthentication;
        $fileKey = $storage31->sendFile($document->getUploadedFile()->getRealPath(), $document->getMimeType(), $document->getOriginalName()); 
        
        if (!$fileKey) {
            throw new \Exception();
        }
        
        $document->setFileKey($fileKey);
    }
    
    public function stream(Document $document) {
        $storage31 = new gCloud_Storage();
        $storage31->repositoryName = $document->getRepositoryName() ?? $this->defaultRepository;
        $storage31->Authentication = $document->getAuthentication() ?? $this->defaultAuthentication;       
        $storage31->streamFile($document->getFileKey());        
    }    
}
