<?php

namespace Schema31\DocumentBundle\Model;

use Doctrine\ORM\Mapping as ORM;

/**
 * Description of Document
 *
 * @ORM\MappedSuperclass
 * 
 * @author Antonio Turdo <aturdo@schema31.it>
 */
abstract class Document {
    
	/**
	 * @ORM\Id
	 * @ORM\Column(type="integer")
	 * @ORM\GeneratedValue(strategy="AUTO")
	 */
	protected $id;
    
    /**
     * @var string $originalName
     * 
     * @ORM\Column(type="string")
     */
    protected $originalName;
    
    /**
     * @var string $mimeType
     * 
     * @ORM\Column(type="string")
     */
    protected $mimeType;

    /**
     * @var int $size
     * 
     * @ORM\Column(type="integer")
     */
    protected $size;

    /**
     * @var \DateTime $uploadDate
     * 
     * @ORM\Column(type="datetime")
     */
    protected $uploadDate;

    /**
     * @var string $hash
     * 
     * @ORM\Column(type="string")
     */      
    protected $hash;
    
    private $uploadedFile;
    
    public function getId() {
        return $this->id;
    }
    
    public function getOriginalName():string {
        return $this->originalName;
    }

    public function getMimeType():string {
        return $this->mimeType;
    }

    public function getSize():int {
        return $this->size;
    }

    public function getUploadDate(): \DateTime {
        return $this->uploadDate;
    }

    public function getHash():string {
        return $this->hash;
    }

    public function getUploadedFile() {
        return $this->uploadedFile;
    }
    
    public function setOriginalName(string $originalName) {
        $this->originalName = $originalName;
    }

    public function setMimeType(string $mimeType) {
        $this->mimeType = $mimeType;
    }

    public function setSize(int $size) {
        $this->size = $size;
    }

    public function setUploadDate(\DateTime $uploadDate) {
        $this->uploadDate = $uploadDate;
    }

    public function setHash(string $hash) {
        $this->hash = $hash;
    }
     
    public function setUploadedFile($uploadedFile) {
        $this->uploadedFile = $uploadedFile;
    }
    
}
