<?php

namespace Schema31\CouchDBJobManager\Service;

/**
 * Description of CouchDBMapper
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class CouchDBMapper {
    
    private function getMapperFor($class) {
        $mapping = array(
            "Schema31\CouchDBJobManager\Domain\CouchDBJob" => "Schema31\CouchDBJobManager\Mapping\CouchDBJob"
        );
        
        if (array_key_exists($class, $mapping)) {
            $mapper = $mapping[$class];
            return new $mapper();
        } else {
            throw new \Exception("Mapping not found for $class");
        }
    }
    
    public function map($object) {
        $mapped = array();        
        $class = get_class($object);
        $reflectionClass = new \ReflectionClass($class);
        $mapping = $this->getMapperFor($class)->getMapping();
        
        foreach ($mapping as $fieldMapping) {
            $fieldName = $fieldMapping["fieldName"];
            if ($reflectionClass->hasProperty($fieldName)) {
                $property = $reflectionClass->getProperty($fieldName);
                $property->setAccessible(true);        
                $value = $this->convertValue($property->getValue($object), $fieldMapping["type"]);
                if (!is_null($value)) {
                    $mapped[$fieldName] = $value; 
                }
            }
        }        
        
        return $mapped;
    }

    private function convertValue($value, $type) {
        switch ($type) {
            case 'datetime':
                return $value->format(\DateTime::ATOM);
            case 'string':
                return $value;
            case 'array':
                return $value;                
        }      
    }    
    
    private function inverseConvertValue($value, $type) {
        switch ($type) {
            case 'datetime':
                return new \DateTime($value);
            case 'string':
                return $value;
            case 'array':
                return $value;                
        }      
    }
    
    public function inverseMap($doc, $class) {   
        $reflectionClass = new \ReflectionClass($class);
        $object = $reflectionClass->newInstanceWithoutConstructor();
        
        $mapping = $this->getMapperFor($class)->getMapping();
        
        foreach ($mapping as $fieldMapping) {
            $fieldName = $fieldMapping["fieldName"];
            if ($reflectionClass->hasProperty($fieldName) && array_key_exists($fieldName, $doc)) {
                $property = $reflectionClass->getProperty($fieldName);
                $property->setAccessible(true);
                $value = $this->inverseConvertValue($doc[$fieldName], $fieldMapping["type"]);
                $property->setValue($object, $value);    
            }
        }
        
        return $object;
    }    
}
