<?php

namespace Schema31\CouchDBClient\Domain;

/**
 * Description of MangoQuery
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class MangoQuery {
    
    private $selector;
    
    private $limit;
    
    private $skip;
    
    private $sort;
    
    public function __construct(\stdClass $selector) {
        $this->selector = $selector;
    }
    
    public function limit(int $limit) {
        $this->limit = $limit;
        return $this;
    }

    public function skip(int $skip) {
        $this->skip = $skip;
        return $this;
    }

    public function sort(array $sort) {
        $this->sort = $sort;
        return $this;
    }
    
    public function getSelector(): \stdClass {
        return $this->selector;
    }

    public function getLimit(): ?int {
        return $this->limit;
    }

    public function getSkip(): ?int {
        return $this->skip;
    }

    public function getSort(): ?array {
        return $this->sort;
    }

}
