<?php

namespace Schema31\CouchDBClient\Service;

use Schema31\CouchDBClient\Domain\ViewRequest;
use Schema31\CouchDBClient\Domain\ViewResponse;
use Schema31\CouchDBClient\Domain\MangoQuery;
use Schema31\CouchDBClient\Domain\MangoResponse;

use Schema31\CouchDBClient\Exception\CouchDBException;
use Schema31\CouchDBClient\Exception\CouchDBNotFoundException;
use Schema31\CouchDBClient\Exception\CouchDBForbiddenException;
use Schema31\CouchDBClient\Exception\CouchDBUnauthorizedException;

/**
 * Regular operations in a specific db
 * 
 * @author Antonio Turdo <aturdo@schema31.it>
 */
interface CouchDBClient extends CouchDB {
    
    public function connect(string $url, string $db, array $options = []): void;
    
    // section database
    
    /**
     * @return array of string (the uuids)
     * @throws CouchDBException
     */
    public function getUuids(int $count = 1): array;
    
    // section docs
    
    /**
     * @throws CouchDBException
     * @throws CouchDBNotFoundException
     * @throws CouchDBForbiddenException
     * @throws CouchDBUnauthorizedException
     */
    public function getDoc(string $id);
   
    /**
     * @throws CouchDBException
     * @throws CouchDBForbiddenException
     * @throws CouchDBUnauthorizedException
     */
    public function storeDoc($doc): void;
    
    /**
     * @return array of DocReference
     * @throws CouchDBException
     * @throws CouchDBForbiddenException
     * @throws CouchDBUnauthorizedException
     */
    public function storeDocs(array $docs): void;
    
    /**
     * @throws CouchDBException
     * @throws CouchDBForbiddenException
     * @throws CouchDBUnauthorizedException
     */
    public function deleteDoc($doc): void;
    
    /**
     * @throws CouchDBException
     * @throws CouchDBForbiddenException
     * @throws CouchDBUnauthorizedException
     */
    public function deleteDocs(array $docs): void;
    
    // section views
    
    /**
     * @throws CouchDBException
     * @throws CouchDBForbiddenException
     * @throws CouchDBUnauthorizedException
     */
    public function getView(ViewRequest $viewRequest): ViewResponse;
    
    // section mango
    
    /**
     * @throws CouchDBException
     * @throws CouchDBForbiddenException
     * @throws CouchDBUnauthorizedException
     */
    public function find(MangoQuery $query): MangoResponse;
}
