<?php

namespace Schema31\CouchDBClient\Domain;

/**
 * Description of MangoResponse
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class MangoResponse {
    
    private $docs;
    
    private $bookmark;
    
    private $warning;
    
    private $executionStats;
       
    public function __construct(array $docs, ?string $bookmark = null, ?string $warning = null, ?object $executionStats = null) {
        $this->docs = $docs;
        $this->bookmark = $bookmark;
        $this->warning = $warning;
        $this->executionStats = $executionStats;
    }
    
    public function getDocs(): array {
        return $this->docs;
    }

    public function getBookmark(): ?string {
        return $this->bookmark;
    }

    public function getWarning(): ?string {
        return $this->warning;
    }

    public function getExecutionStats(): ?object {
        return $this->executionStats;
    }

}
