<?php

namespace Schema31\CouchDBClient\Domain;

/**
 * Description of ViewResponse
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class ViewResponse {
    
    private $totalRows;
    
    private $offset;
    
    private $rows;
    
    public function __construct(array $rows, ?int $totalRows = null, ?int $offset = null) {
        $this->totalRows = $totalRows;
        $this->offset = $offset;
        $this->rows = $rows;
    }
    
    public function getTotalRows(): ?int {
        return $this->totalRows;
    }

    public function getOffset(): ?int {
        return $this->offset;
    }

    public function getRows(): array {
        return $this->rows;
    }
    
    public function getDocs(): array {
        return array_map(function($row) { return $row->doc; }, $this->rows);
    }
    
    public function getKeys(): array {
        return array_map(function($row) { return $row->key; }, $this->rows);
    }    

    public function getValues(): array {
        return array_map(function($row) { return $row->value; }, $this->rows);
    }  
    
    public function getIds(): array {
        return array_map(function($row) { return $row->id; }, $this->rows);
    }      
}
