<?php

namespace Schema31\CouchDBClient\Domain;

/**
 * Description of MangoResponse
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class MangoResponse {
    
    private $docs;
    
    private $bookmark;
    
    private $warning;
    
    private $executionStats;
       
    public function __construct(array $docs, string $bookmark, string $warning, ?object $executionStats = null) {
        $this->docs = $docs;
        $this->bookmark = $bookmark;
        $this->warning = $warning;
        $this->executionStats = $executionStats;
    }
    
    public function getDocs() {
        return $this->docs;
    }

    public function getBookmark() {
        return $this->bookmark;
    }

    public function getWarning() {
        return $this->warning;
    }

    public function getExecutionStats() {
        return $this->executionStats;
    }

}
