<?php

namespace Schema31\CouchDBClient\Service;

/**
 * Low level operations
 * 
 * @author Antonio Turdo <aturdo@schema31.it>
 */
interface CouchDB {
    
    /**
     * @param string $method The HTTP method to use (GET,PUT,POST,...)
     * @param string $url The URL to fetch
     * @param array $parameters The query parameters to pass to the query
     * @param $data The request body
     * @param string $contentType The content type of the data
     */
    public function query(string $method, string $url, array $parameters = [], $data = null, string $contentType = null);
    
}
