<?php

namespace Schema31\CouchDBClient\Service;

/**
 * Factory class for CouchDBAdmin
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class CouchDBAdminFactory {
    
    /**
     * @param string $class The class that implements CouchDBAdmin interface
     * @param string $url The couch server url with form [http|https]://host:port
     * @param string $db The db name
     * @param array $options Allowed options: username, password
     * @param $args Other arguments of the implementation
     * @return \Schema31\CouchDBClient\Service\CouchDBAdmin
     */
    public static function create(string $class, string $url, string $db, array $options = [], ...$args): CouchDBAdmin {
        $instance = new $class(...$args);
        $instance->connect($url, $db, $options);
        
        return $instance;
    }
}
