<?php

namespace Schema31\CouchDBClient\Service;

/**
 * Manage users, roles (and security) of a db
 * 
 * @author Antonio Turdo <aturdo@schema31.it>
 */
interface CouchDBAdmin extends CouchDB {
    
    public function connect(string $url, string $db, array $options = []): void;
    
    // users
    
    public function addMemberUser(string $user): void;
    
    public function addAdminUser(string $user): void;

    public function removeMemberUser(string $user): void;
    
    public function removeAdminUser(string $user): void;   
    
    public function getMemberUsers(): array;
    
    public function getAdminUsers(): array;
    
    // roles
    
    /*public function addMemberRole(string $user): void;
    
    public function addAdminRole(string $user): void;

    public function removeMemberRole(string $user): void;
    
    public function removeAdminRole(string $user): void;   
    
    public function getMemberRoles(): array;
    
    public function getAdminRoles(): array;   */
    
    
}
