<?php

namespace Schema31\CouchDBClient\Domain;

/**
 * Description of ViewRequest
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class ViewRequest {
    
    private $design;
    
    private $name;
    
    private $startkey;
    
    private $endkey;
    
    private $skip;
    
    private $limit;
    
    private $includeDocs;
    
    private $descending;
    
    public function __construct(string $design, string $name) {
        $this->design = $design;
        $this->name = $name;
    }
    
    public function partialKey($key) {
        $this->startkey($key);
        $this->endkey($key);
        
        return $this;
    }
    
    /**
     * @param string|array $startkey
     * @throws \Exception
     */
    public function startkey($startkey): ViewRequest {
        if (!is_string($startkey) && !is_array($startkey)) {
            throw new \Exception("Invalid argument type");
        }
        
        if (is_array($startkey)) {
            $startkey = json_encode($startkey);
        }
        
        $this->startkey = $startkey;
        return $this;
    }
   
    /**
     * @param string|array $endkey
     * @return ViewRequest
     * @throws \Exception
     */    
    public function endkey($endkey): ViewRequest {
        if (!is_string($endkey) && !is_array($endkey)) {
            throw new \Exception("Invalid argument type");
        }
        
        if (is_array($endkey)) {
            $endkey = substr(json_encode($endkey), 0, -1).',{}]';
        }        
        
        $this->endkey = $endkey;
        return $this;
    }

    public function skip(int $skip): ViewRequest {
        $this->skip = $skip;
        return $this;
    }

    public function limit(int $limit): ViewRequest {
        $this->limit = $limit;
        return $this;
    }

    public function includeDocs(bool $includeDocs): ViewRequest {
        $this->includeDocs = $includeDocs;
        return $this;
    }
    
    public function descending(bool $descending): ViewRequest {
        $this->descending = $descending;
        return $this;
    }
    
    public function getDesign(): string {
        return $this->design;
    }

    public function getName(): string {
        return $this->name;
    }

    public function getStartkey(): ?string {
        return $this->startkey;
    }

    public function getEndkey(): ?string {
        return $this->endkey;
    }

    public function getSkip(): ?int {
        return $this->skip;
    }

    public function getLimit(): ?int {
        return $this->limit;
    }

    public function getIncludeDocs(): ?bool {
        return $this->includeDocs;
    }

    public function getDescending(): ?bool {
        return $this->descending;
    }

}
