<?php

namespace Schema31\CouchDBClient\Domain;

/**
 * Description of SynchronizationReport
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class SynchronizationReport {
    
    private $misalignedDocIds, $alignedDocIds, $newDocIds, $updatedDocIds, $deletedDocIds;
    
    private $docIds;
    
    public function addMisalignedDoc($misalignedDocId) {
        $this->misalignedDocIds[] = $misalignedDocId;
        $this->docIds[] = $misalignedDocId;
    }
    
    public function addAlignedDoc($alignedDocId) {
        $this->alignedDocIds[] = $alignedDocId;
        $this->docIds[] = $alignedDocId;
    }    
    
    public function addNewDoc($newDocId) {
        $this->newDocIds[] = $newDocId;
        $this->docIds[] = $newDocId;
    }
    
    public function addUpdatedDoc($updatedDocId) {
        $this->updatedDocIds[] = $updatedDocId;
        $this->docIds[] = $updatedDocId;
    }
    
    public function addDeletedDoc($deletedDocId) {
        $this->deletedDocIds[] = $deletedDocId;        
    }
    
    public function getMisalignedDocIds() {
        return $this->misalignedDocIds;
    }

    public function getAlignedDocIds() {
        return $this->alignedDocIds;
    }

    public function getNewDocIds() {
        return $this->newDocIds;
    }

    public function getUpdatedDocIds() {
        return $this->updatedDocIds;
    }

    public function getDeletedDocIds() {
        return $this->deletedDocIds;
    }

    public function getDocIds() {
        return $this->docIds;
    }

}
