<?php

namespace Schema31\CouchDBClient\Service;

/**
 * Description of CouchDBClientFactory
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class CouchDBClientFactory {
    
    /**
     * @param string $class The class that implements CouchDBClient interface
     * @param string $url The couch server url with form [http|https]://host:port
     * @param string $db The db name
     * @param array $options Allowed options: username, password
     * @param $args Other arguments of the implementation
     * @return \Schema31\CouchDBClient\Service\CouchDBClient
     */
    public static function create(string $class, string $url, string $db, array $options = [], ...$args): CouchDBClient {
        $instance = new $class(...$args);
        $instance->connect($url, $db, $options);
        
        return $instance;
    }
}
