<?php

namespace Schema31\CouchDBClient\Service;

use Schema31\CouchDBClient\Domain\ViewRequest;
use Schema31\CouchDBClient\Domain\ViewResponse;
use Schema31\CouchDBClient\Domain\MangoQuery;
use Schema31\CouchDBClient\Domain\MangoResponse;
use Schema31\CouchDBClient\Domain\DocReference;
use Schema31\CouchDBClient\Domain\CouchDBException;

/**
 * @author Antonio Turdo <aturdo@schema31.it>
 */
interface CouchDBClient {
    
    public function connect(string $url, string $db, array $options = []): void;
    
    // section database
    
    /**
     * @return array of string (the uuids)
     * @throws CouchDBException
     */
    public function getUuids(int $count = 1): array;
    
    // section docs
    
    /**
     * @throws CouchDBException
     */
    public function getDoc(string $id);
   
    /**
     * @throws CouchDBException
     */
    public function storeDoc($doc): void;
    
    /**
     * @return array of DocReference
     * @throws CouchDBException
     */
    public function storeDocs(array $docs): void;
    
    /**
     * @throws CouchDBException
     */
    public function deleteDoc($doc): void;
    
    /**
     * @throws CouchDBException
     */
    public function deleteDocs(array $docs): void;
    
    // section views
    
    /**
     * @throws CouchDBException
     */
    public function getView(ViewRequest $viewRequest): ViewResponse;
    
    // section mango
    
    /**
     * @throws CouchDBException
     */
    public function find(MangoQuery $query): MangoResponse;
}
