<?php

namespace Schema31\CouchDBClient\Domain;

/**
 * Description of ViewRequest
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class ViewRequest {
    
    private $design;
    
    private $name;
    
    private $startkey;
    
    private $endkey;
    
    private $skip;
    
    private $limit;
    
    private $includeDocs;
    
    private $descending;
    
    public function __construct($design, $name) {
        $this->design = $design;
        $this->name = $name;
    }
    
    public function startkey(string $startkey) {
        $this->startkey = $startkey;
        return $this;
    }
    
    public function endkey(string $endkey) {
        $this->endkey = $endkey;
        return $this;
    }

    public function skip(int $skip) {
        $this->skip = $skip;
        return $this;
    }

    public function limit(int $limit) {
        $this->limit = $limit;
        return $this;
    }

    public function includeDocs(bool $includeDocs) {
        $this->includeDocs = $includeDocs;
        return $this;
    }
    
    public function descending(bool $descending) {
        $this->descending = $descending;
        return $this;
    }


}
