<?php

namespace Diogenes\DiogenesClient\Service;

use Diogenes\DiogenesClient\Service\DiogenesClient;
use Diogenes\DiogenesClient\Model\AddressType;

/**
 * Description of Mail
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class Mail {

    
    private $diogenesClient;
    
    public function __construct(DiogenesClient $diogenesClient) {
        $this->diogenesClient = $diogenesClient;
    }
 
    public function getAddressType($emailAddress) {
        
        list($user, $domain) = explode("@", $emailAddress);
        
        // chiamata a ws Diogenes
        try {
            $result = $this->diogenesClient->mailDomain($domain);
        } catch (\Exception $e) {
            return AddressType::unknownType($domain);
        }        
        
        if (isset($result->type) && in_array($result->type, AddressType::TYPES)) {
            return new AddressType($domain, $result->type, new \DateTime($result->lastUpdate));
        }
        
        return AddressType::unknownType($domain);
    }
}
