<?php

namespace Diogenes\DiogenesClient\Service;

use GuzzleHttp\Client;

/**
 * Description of DiogenesClient
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class DiogenesClient {
    
    private $httpClient;
    
    public function __construct($endpoint = 'https://api.diogenes.cloud', $timeout = 10.0) {
        $this->httpClient = new Client([
            'base_uri' => $endpoint,
            'timeout'  => $timeout,
        ]);
    }
    
    public function mailDomain($domain) {
        $response = $this->httpClient->request('GET', "/v1/mail/domain?domain=$domain");
        
        return json_decode($response->getBody());
    }
   
}
